% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_max.R
\name{col_max}
\alias{col_max}
\alias{col_min}
\title{Get the column name of the max/min number each row}
\usage{
col_max(.data, .name = "max_col")

col_min(.data, .name = "min_col")
}
\arguments{
\item{.data}{A data.frame with numeric column(s)}

\item{.name}{The column name of the new added column}
}
\value{
A data.table
}
\description{
For a data.frame with numeric values, add a new column
specifying the column name of the max/min value each row.
}
\examples{
set.seed(199057)
DT <- data.table(matrix(sample(10, 100, TRUE), ncol=10))
DT
col_max(DT)
col_max(DT,.name = "max_col_name")
col_min(DT)

col_max(iris)
}
\references{
https://stackoverflow.com/questions/17735859/for-each-row-return-the-column-name-of-the-largest-value
}
