% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate.R
\name{separate}
\alias{separate}
\title{Separate a character column into two columns using
a regular expression separator}
\usage{
separate(.data, separated_colname, into, sep = "[^[:alnum:]]+", remove = TRUE)
}
\arguments{
\item{.data}{A data frame.}

\item{separated_colname}{Column name, string only.}

\item{into}{Character vector of length 2.}

\item{sep}{Separator between columns.}

\item{remove}{If \code{TRUE}, remove input column from output data frame.}
}
\value{
A data.table
}
\description{
Given either regular expression,
\code{separate()} turns a single character column into two columns.
Analogous to \code{tidyr::separate}, but only split into two columns only.
}
\examples{
df <- data.table(x = c(NA, "a.b", "a.d", "b.c"))
df \%>\% separate(x, c("A", "B"))
# equals to
df <- data.table(x = c(NA, "a.b", "a.d", "b.c"))
df \%>\% separate("x", c("A", "B"))
}
\seealso{
\code{\link[tidyr]{separate}}, \code{\link[tidyfst]{unite_dt}}
}
