% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{centrality}
\alias{centrality}
\alias{centrality_alpha}
\alias{centrality_authority}
\alias{centrality_betweenness}
\alias{centrality_power}
\alias{centrality_closeness}
\alias{centrality_eigen}
\alias{centrality_hub}
\alias{centrality_pagerank}
\alias{centrality_subgraph}
\alias{centrality_degree}
\alias{centrality_edge_betweenness}
\title{Calculate node and edge centrality}
\usage{
centrality_alpha(weights = NULL, alpha = 1, exo = 1, tol = 1e-07,
  loops = FALSE)

centrality_authority(weights = NULL, scale = TRUE,
  options = igraph::arpack_defaults)

centrality_betweenness(weights = NULL, directed = TRUE, cutoff = NULL,
  nobigint = TRUE, normalized = FALSE)

centrality_power(exponent = 1, rescale = FALSE, tol = 1e-07,
  loops = FALSE)

centrality_closeness(weights = NULL, mode = "out", normalized = FALSE,
  cutoff = NULL)

centrality_eigen(weights = NULL, directed = FALSE, scale = TRUE,
  options = igraph::arpack_defaults)

centrality_hub(weights = NULL, scale = TRUE,
  options = igraph::arpack_defaults)

centrality_pagerank(weights = NULL, directed = TRUE, damping = 0.85,
  personalized = NULL)

centrality_subgraph(loops = FALSE)

centrality_degree(weights = NULL, mode = "out", loops = TRUE,
  normalized = FALSE)

centrality_edge_betweenness(weights = NULL, directed = TRUE,
  cutoff = NULL)
}
\arguments{
\item{weights}{The weight of the edges to use for the calculation. Will be
evaluated in the context of the edge data.}

\item{alpha}{Relative importance of endogenous vs exogenous factors}

\item{exo}{The exogenous factors of the nodes. Either a scalar or a number
number for each node. Evaluated in the context of the node data.}

\item{tol}{Tolerance for near-singularities during matrix inversion}

\item{loops}{Should loops be included in the calculation}

\item{scale}{Should the output be scaled between 0 and 1}

\item{options}{Settings passed on to \code{igraph::arpack()}}

\item{directed}{Should direction of edges be used for the calculations}

\item{cutoff}{maximum path length to use during calculations}

\item{nobigint}{Should big integers be avoided during calculations}

\item{normalized}{Should the output be normalized}

\item{exponent}{The decay rate for the Bonacich power centrality}

\item{rescale}{Should the output be scaled to sum up to 1}

\item{mode}{How should edges be followed. Ignored for undirected graphs}

\item{damping}{The damping factor of the page rank algorithm}

\item{personalized}{The probability of jumping to a node when abandoning a
random walk. Evaluated in the context of the node data.}
}
\value{
A numeric vector giving the centrality measure of each node.
}
\description{
The centrality of a node measures the importance of node in the network. As
the concept of importance is ill-defined and dependent on the network and
the questions under consideration, many centrality measures exist.
\code{tidygraph} provides a consistent set of wrappers for all the centrality
measures implemented in \code{igraph} for use inside \code{\link[dplyr:mutate]{dplyr::mutate()}} and other
relevant verbs. All functions provided by \code{tidygraph} have a consistent
naming scheme and automatically calls the function on the graph, returning a
vector with measures ready to be added to the node data.
}
\section{Functions}{
\itemize{
\item \code{centrality_alpha}: Wrapper for \code{\link[igraph:alpha_centrality]{igraph::alpha_centrality()}}

\item \code{centrality_authority}: Wrapper for \code{\link[igraph:authority_score]{igraph::authority_score()}}

\item \code{centrality_betweenness}: Wrapper for \code{\link[igraph:betweenness]{igraph::betweenness()}} and \code{\link[igraph:estimate_betweenness]{igraph::estimate_betweenness()}}

\item \code{centrality_power}: Wrapper for \code{\link[igraph:power_centrality]{igraph::power_centrality()}}

\item \code{centrality_closeness}: Wrapper for \code{\link[igraph:closeness]{igraph::closeness()}} and \code{\link[igraph:estimate_closeness]{igraph::estimate_closeness()}}

\item \code{centrality_eigen}: Wrapper for \code{\link[igraph:eigen_centrality]{igraph::eigen_centrality()}}

\item \code{centrality_hub}: Wrapper for \code{\link[igraph:hub_score]{igraph::hub_score()}}

\item \code{centrality_pagerank}: Wrapper for \code{\link[igraph:page_rank]{igraph::page_rank()}}

\item \code{centrality_subgraph}: Wrapper for \code{\link[igraph:subgraph_centrality]{igraph::subgraph_centrality()}}

\item \code{centrality_degree}: Wrapper for \code{\link[igraph:degree]{igraph::degree()}} and \code{\link[igraph:strength]{igraph::strength()}}

\item \code{centrality_edge_betweenness}: Wrapper for \code{\link[igraph:edge_betweenness]{igraph::edge_betweenness()}}
}}

\examples{
create_notable('bull') \%>\%
  activate(nodes) \%>\%
  mutate(importance = centrality_alpha())

# Most centrality measures are for nodes but not all
create_notable('bull') \%>\%
  activate(edges) \%>\%
  mutate(importance = centrality_edge_betweenness())
}
