% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge.R
\name{edge_types}
\alias{edge_types}
\alias{edge_is_multiple}
\alias{edge_is_loop}
\alias{edge_is_mutual}
\title{Querying edge types}
\usage{
edge_is_multiple()

edge_is_loop()

edge_is_mutual()
}
\value{
A logical vector of the same length as the number of edges in the
graph
}
\description{
These functions lets the user query whether the edges in a graph is of a
specific type. All functions return a logical vector giving whether each edge
in the graph corresponds to the specific type.
}
\section{Functions}{
\itemize{
\item \code{edge_is_multiple}: Query whether each edge has any parallel siblings

\item \code{edge_is_loop}: Query whether each edge is a loop

\item \code{edge_is_mutual}: Query whether each edge has a sibling going in the reverse direction
}}

\examples{
create_star(10, directed = TRUE, mutual = TRUE) \%>\%
  activate(edges) \%>\%
  sample_frac(0.7) \%>\%
  mutate(single_edge = !edge_is_mutual())
}
