% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public_api.R
\name{make_splits}
\alias{make_splits}
\title{Define splits for cross-fitting}
\usage{
make_splits(data, identifier, ..., .num_splits)
}
\arguments{
\item{data}{dataframe}

\item{identifier}{Unquoted name of unique identifier column}

\item{...}{variables on which to stratify (requires that \code{quickblock} be installed.)}

\item{.num_splits}{number of splits to create. If VIMP is requested in \code{QoI_cfg}, this
must be an even number.}
}
\value{
original dataframe with additional \code{.split_id} column
}
\description{
This takes a dataset, a column with a unique identifier and an
arbitrary number of covariates on which to stratify the splits.
It returns the original dataset with an additional column \code{.split_id}
corresponding to an identifier for the split.
}
\details{
To see an example analysis, read \code{vignette("experimental_analysis")} in the context
of an experiment, \code{vignette("experimental_analysis")} for an observational study, or
\code{vignette("methodological_details")} for a deeper dive under the hood.
}
\examples{
library("dplyr")
if(require("palmerpenguins")) {
data(package = 'palmerpenguins')
penguins$unitid = seq_len(nrow(penguins))
penguins$propensity = rep(0.5, nrow(penguins))
penguins$treatment = rbinom(nrow(penguins), 1, penguins$propensity)
cfg <- basic_config() \%>\% 
add_known_propensity_score("propensity") \%>\%
add_outcome_model("SL.glm.interaction") \%>\%
remove_vimp()
attach_config(penguins, cfg) \%>\%
make_splits(unitid, .num_splits = 4) \%>\%
produce_plugin_estimates(outcome = body_mass_g, treatment = treatment, species, sex) \%>\%
construct_pseudo_outcomes(body_mass_g, treatment) \%>\%
estimate_QoI(species, sex)
}
}
\seealso{
\code{\link[=attach_config]{attach_config()}}, \code{\link[=produce_plugin_estimates]{produce_plugin_estimates()}}, \code{\link[=construct_pseudo_outcomes]{construct_pseudo_outcomes()}},
\code{\link[=estimate_QoI]{estimate_QoI()}}
}
