% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_json.R
\name{bind_rows}
\alias{bind_rows}
\title{Bind Rows (tidyjson)}
\usage{
bind_rows(...)
}
\arguments{
\item{...}{Values passed on to dplyr::bind_rows}
}
\value{
If all parameters are `tbl_json` objects, then the JSON attributes
will be stacked and a `tbl_json` will be returned.  Otherwise, 
`dplyr::bind_rows` is used, a message is displayed,
and a `tbl_df` is returned.
}
\description{
Since bind_rows is not currently an s3 method, this function
is meant to mask dplyr::bind_rows (although it is called directly).
}
\examples{

## Simple example
a <- as.tbl_json('{"a": 1, "b": 2}')
b <- as.tbl_json('{"a": 3, "b": 4}')

bind_rows(a,b) \%>\% spread_values(a=jnumber(a),b=jnumber(b))

## as a list
bind_rows(list(a,b)) \%>\% spread_all()

}
\seealso{
[Related dplyr issue](https://github.com/tidyverse/dplyr/issues/2457)

\code{\link[dplyr]{bind_rows}}
}
