% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyllm.R
\name{LLMMessage}
\alias{LLMMessage}
\title{Large Language Model Message Class}
\description{
Large Language Model Message Class

Large Language Model Message Class
}
\details{
This class manages a history of messages and media interactions intended for use with large language  models.
It allows for adding messages, converting messages for API usage, and printing the history in a structured format.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{message_history}}{List to store all message interactions.}

\item{\code{system_prompt}}{The system prompt used for a conversation}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LLMMessage-new}{\code{LLMMessage$new()}}
\item \href{#method-LLMMessage-clone_deep}{\code{LLMMessage$clone_deep()}}
\item \href{#method-LLMMessage-add_message}{\code{LLMMessage$add_message()}}
\item \href{#method-LLMMessage-to_api_format}{\code{LLMMessage$to_api_format()}}
\item \href{#method-LLMMessage-has_image}{\code{LLMMessage$has_image()}}
\item \href{#method-LLMMessage-print}{\code{LLMMessage$print()}}
\item \href{#method-LLMMessage-clone}{\code{LLMMessage$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LLMMessage-new"></a>}}
\if{latex}{\out{\hypertarget{method-LLMMessage-new}{}}}
\subsection{Method \code{new()}}{
Initializes the LLMMessage object with an optional system prompt.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LLMMessage$new(system_prompt = "You are a helpful assistant")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{system_prompt}}{A string that sets the initial system prompt.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new LLMMessage object.
Deep Clone of LLMMessage Object

This method creates a deep copy of the \code{LLMMessage} object. It ensures that
all internal states, including message histories and settings, are copied
so that the original object remains unchanged when mutations are applied
to the copy. This is particularly useful for maintaining immutability in
a tidyverse-like functional programming context where functions should
not have side effects on their inputs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LLMMessage-clone_deep"></a>}}
\if{latex}{\out{\hypertarget{method-LLMMessage-clone_deep}{}}}
\subsection{Method \code{clone_deep()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LLMMessage$clone_deep()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new \code{LLMMessage} object that is a deep copy of the original.
Add a message

Adds a message to the history. Optionally includes media.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LLMMessage-add_message"></a>}}
\if{latex}{\out{\hypertarget{method-LLMMessage-add_message}{}}}
\subsection{Method \code{add_message()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LLMMessage$add_message(role, content, media = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{role}}{The role of the message sender (e.g., "user", "assistant").}

\item{\code{content}}{The textual content of the message.}

\item{\code{media}}{Optional; media content to attach to the message.
Convert to API format

Converts the message history to a format suitable for various API calls.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LLMMessage-to_api_format"></a>}}
\if{latex}{\out{\hypertarget{method-LLMMessage-to_api_format}{}}}
\subsection{Method \code{to_api_format()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LLMMessage$to_api_format(api_type, cgpt_image_detail = "auto")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_type}}{The type of API (e.g., "claude","groq","chatgpt").}

\item{\code{cgpt_image_detail}}{Specific option for ChatGPT API (imagedetail - set to auto)
Simple helper function to determine whether the message history contains
an image
We check this function whenever we call models that do not support images
so we can post a warning to the user that images were found but not sent
to the model}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LLMMessage-has_image"></a>}}
\if{latex}{\out{\hypertarget{method-LLMMessage-has_image}{}}}
\subsection{Method \code{has_image()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LLMMessage$has_image()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns TRUE if the message hisotry contains images
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LLMMessage-print"></a>}}
\if{latex}{\out{\hypertarget{method-LLMMessage-print}{}}}
\subsection{Method \code{print()}}{
Prints the current message history in a structured format.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LLMMessage$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LLMMessage-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LLMMessage-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LLMMessage$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
