% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imported-fun.R
\name{get_difference}
\alias{get_difference}
\title{Get model predictions for differences between conditions.}
\usage{
get_difference(
  model,
  comp,
  cond = NULL,
  rm.ranef = TRUE,
  se = TRUE,
  sim.ci = FALSE,
  f = 1.96,
  return.n.posterior = 0,
  print.summary = FALSE
)
}
\arguments{
\item{model}{A gam object, produced by \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}}.}

\item{comp}{A named list with the two levels to compare.}

\item{cond}{A named list of the values to use for the other predictor
terms. Variables omitted from this list will have the closest observed
value to the median for continuous variables, or the reference level for
factors.}

\item{rm.ranef}{Logical: whether or not to remove random effects.
Default is TRUE. Alternatively a vector of numbers with the
model term number of the random effect(s) to remove.
(See notes.)}

\item{se}{Logical: whether or not to return the confidence interval or
standard error around the estimates.}

\item{sim.ci}{Logical: Using simultaneous confidence intervals or not
(default set to FALSE). The implementation of simultaneous CIs follows
Gavin Simpson's blog of December 15, 2016:
\url{https://fromthebottomoftheheap.net/2016/12/15/simultaneous-interval-revisited/}.
This interval is calculated from simulations based.
Please specify a seed (e.g., \code{set.seed(123)}) for reproducible results.
In addition, make sure to specify at least 200 points for each smooth
for the simulations when using simultaneous CI.
Note: in contrast with Gavin Simpson's code, here the Bayesian posterior
covariance matrix of the parameters is uncertainty corrected
(\code{unconditional=TRUE}) to reflect the uncertainty on the estimation of
smoothness parameters.}

\item{f}{A number to scale the standard error. Defaults to 1.96, resulting
in 95\% confidence intervals. For 99\% confidence intervals use a value of
2.58.}

\item{return.n.posterior}{Numeric: N samples from
the posterior distribution of the fitted model are returned.
Default value is 0 (no samples returned).
Only works when \code{sim.ci=TRUE}.}

\item{print.summary}{Logical: whether or not to print a summary of the
values selected for each predictor.
Default set to the print info messages option
(see \code{infoMessages}).}
}
\value{
Returns a data frame with the estimates of the difference and
optionally the confidence intervals around that estimate.
}
\description{
Get model predictions for differences between conditions.
}
\section{Notes}{

Other, not specified effects and random effects are generally cancelled
out, when calculating the difference. When the predictors that
specify the conditions to compare are involved in other interactions
or included as random slopes, it may be useful to specify the values
of other predictors with \code{cond} or remove the random effects with
\code{rm.ranef}.
}

\author{
Jacolien van Rij, Martijn Wieling
}
\keyword{internal}
