% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyper_vars_dims.R
\name{hyper_vars}
\alias{hyper_vars}
\alias{hyper_dims}
\alias{hyper_grids}
\title{Grid status}
\usage{
hyper_vars(x, ...)

hyper_dims(x, ...)

hyper_grids(x, ...)
}
\arguments{
\item{x}{tidync object}

\item{...}{ignored}
}
\value{
data frame
}
\description{
Functions to report on the current status of the \code{active} grid. Information
on the active dimensions and variables are listed in a data frame with
multiple columns.
}
\details{
The dimensions and variables of the active grid are identified in the
\link[=print.tidync]{print} method of the tidync object, these functions exist to
provide that information directly.

\code{hyper_vars()} will list the ids, data type, name, dimension number, number
of attributes and and coordinate status of the variables on the currently
active grid.

\code{hyper_dims()} will list the names, lengths, start/count index, ids, and
status of dimensions on the currently active grid. records on the currently
active dimensions.

\code{hyper_grids()} will list the names, number of dimension, and number of
variables and active status of each grid in the source.
}
\examples{
f <- "S20080012008031.L3m_MO_CHL_chlor_a_9km.nc"
l3file <- system.file("extdata/oceandata", f, package= "tidync")
tnc <- tidync(l3file)
hyper_vars(tnc)
hyper_dims(tnc)
hyper_dims(tnc \%>\% hyper_filter(lat = lat < 20))
}
