% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_ndr.R
\name{read_ndr}
\alias{read_ndr}
\title{Read NDR "csv" file}
\usage{
read_ndr(path, time_stamp, cols = NULL, quiet = FALSE, ...)
}
\arguments{
\item{path}{Path to the csv file on your computer. The file path should be specified in the
format "C:/users/Desktop/your file.csv" or something similar.}

\item{time_stamp}{The date stamp for the downloaded line-list.}

\item{cols}{The column types of the downloaded NDR line-lists. The default sets the columns
based on the NDR line-list specifications between October 2020 and March 2021.
If the default fails, you can supply your column specifications following the instructions
in \code{?vroom::cols} documentation.}

\item{quiet}{Logical, to determine if the message about creating new columns should be printed or not.}

\item{...}{passes other arguments supplied to the \code{vroom::vroom()} used
behind the hood.}
}
\value{
read_ndr
}
\description{
Import your NDR patient-level line-list downloaded as ".csv" format from the
NDR front-end into R in a nicely formatted table. The function also creates three
additional variables - \code{date_ltfu}, \code{appointment_date} and \code{current_status} for ease of referencing
during analysis.
}
\examples{
# Read \code{ndr_example.csv} from a path
\donttest{
file_path <- system.file("extdata", "ndr_example.csv", package = "tidyndr")
read_ndr(file_path, time_stamp = "2021-02-15")
}

# Read using a link to the NDR csv file on the internet
\donttest{
file_path <- "https://raw.githubusercontent.com/stephenbalogun/example_files/main/ndr_example.csv"
read_ndr(file_path, time_stamp = "2021-02-15")
}
}
