% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disaggregate.R
\name{disaggregate}
\alias{disaggregate}
\title{Summarize an indicator into finer details by the specified variable}
\usage{
disaggregate(data, by, ...)
}
\arguments{
\item{data}{Data containing the indicator to be disaggregated.}

\item{by}{The variable of interest to be used for the disaggregation. The
options are any of: \code{"sex"}, \code{"current_age"}, \code{"pregnancy_status"}, \code{"art_duration"},
\code{"months_dispensed"} (of ARV), and \code{"age_sex"}.}

\item{...}{Other parameters to be passed based on the \code{by} supplied. These are: 1) the \code{`level`} of disaggregation,
("ip" or "country", "state", "lga" and "facility"). 2) \code{`pivot_wide`} TRUE or FALSE, used to determine how the tabular data should be presented.
The default options are "state" for  \code{by} and TRUE for \code{pivot_wide}.
value is "state".}
}
\value{
disaggregated data
}
\description{
Counts the number of occurrence of an outcome based on the category of
interest. It also provides "Totals" at the end of the columns or rows (or both)
where appropriate.
}
\examples{
### Disaggregate "TX_NEW" clients into age categories for each state
new_clients <- tx_new(ndr_example, from = "2021-01-01")
disaggregate(new_clients, by = "current_age") # default value of level is "state"

### Disaggregate "TX_CURR" by gender for each facility
curr_clients <- tx_curr(ndr_example)
disaggregate(curr_clients, by = "sex", level = "facility")

}
