% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rita_recent.R
\name{rita_recent}
\alias{rita_recent}
\title{Generate List of Clients who are RITA Recent}
\usage{
rita_recent(data, from = NULL, to = NULL, states = NULL, facilities = NULL)
}
\arguments{
\item{data}{An NDR dataframe imported using the \code{read_ndr()}.}

\item{from}{The start date in ISO8601 format (i.e. "yyyy-mm-dd").
The default is to start at the beginning of the current Fiscal Year (i.e. 1st of October).}

\item{to}{The end date written in ISO8601 format (i.e. "yyyy-mm-dd").
The default is the date of analysis.}

\item{states}{The name(s) of the State(s) of interest. The default utilizes all
the states in the dataframe. If specifying more than one state, combine the
states using the \code{c()} e.g. \code{c("State 1", "State 2")}.}

\item{facilities}{The name(s) of the facilit(ies) of interest. Default is to utilize
all the facilities contained in the dataframe. If specifying more than one
facility, combine the facilities using the \code{c()} e.g.
\code{c("Facility 1", "Facility 2")}.}
}
\value{
Line-list of clients who are RTRI recent and have a viral load result greater or equal to 1000 copies per microliter of blood.
}
\description{
Generate List of Clients who are RITA Recent
}
\examples{
## Line-list all HIV positive clients confirmed to be RITA recent
hts_pos <- hts_tst_pos(recency_example)

rita_recent(hts_pos)

}
