% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_depth_model.R
\name{age_depth_as_sec_axis}
\alias{age_depth_as_sec_axis}
\title{Use an age depth model as a second ggplot axis}
\usage{
age_depth_as_sec_axis(x, primary = c("depth", "age"), ...)
}
\arguments{
\item{x}{An \link{age_depth_model}}

\item{primary}{Specify the primary axis as 'age' or 'depth'}

\item{...}{Passed to \link[ggplot2:sec_axis]{sec_axis}}
}
\value{
A ggplot2 \link[ggplot2:sec_axis]{sec_axis} for use in \link[ggplot2:scale_continuous]{scale_x_continuous},
\link[ggplot2:scale_continuous]{scale_y_continuous}, or their reverse variants.
}
\description{
Use an age depth model as a second ggplot axis
}
\examples{
library(ggplot2)
alta_lake_adm <- age_depth_model(
  alta_lake_210Pb_ages,
  depth = depth_cm,
  age = age_year_ad
)

ggplot(alta_lake_210Pb_ages, aes(y = depth_cm, x = age_year_ad)) +
  geom_path() +
  geom_point() +
  scale_y_reverse(sec.axis = age_depth_as_sec_axis(alta_lake_adm))

}
