% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-general.R
\name{add_sum_bar}
\alias{add_sum_bar}
\alias{add_sum_dash}
\alias{add_sum_dot}
\alias{add_sum_value}
\alias{add_sum_line}
\alias{add_sum_area}
\title{Add sum}
\usage{
add_sum_bar(
  plot,
  dodge_width = NULL,
  width = 0.6,
  saturation = 1,
  preserve = "total",
  ...
)

add_sum_dash(
  plot,
  dodge_width = NULL,
  width = 0.6,
  linewidth = 0.25,
  preserve = "total",
  ...
)

add_sum_dot(plot, dodge_width = NULL, size = 2, preserve = "total", ...)

add_sum_value(
  plot,
  dodge_width = NULL,
  accuracy = 0.1,
  scale_cut = NULL,
  fontsize = 7,
  extra_padding = 0.15,
  vjust = NULL,
  hjust = NULL,
  preserve = "total",
  ...
)

add_sum_line(
  plot,
  group,
  dodge_width = NULL,
  linewidth = 0.25,
  preserve = "total",
  ...
)

add_sum_area(
  plot,
  group,
  dodge_width = NULL,
  linewidth = 0.25,
  preserve = "total",
  ...
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{dodge_width}{For adjusting the distance between grouped objects. Defaults to \code{0.8}.}

\item{width}{Width of the plot area. Defaults to \code{50}.}

\item{saturation}{A \code{number} between \code{0} and \code{1} for the color saturation of an object. A value of \code{0} is completely desaturated (white), \code{1} is the original color.}

\item{preserve}{Should dodging preserve the \code{"total"} width of all elements at
a position, or the width of a \code{"single"} element?}

\item{...}{Arguments passed on to the \code{geom} function.}

\item{linewidth}{Thickness of the line in points (pt). Typical values range between \code{0.25} and \code{1}.}

\item{size}{A \code{number} representing the size of the plot symbol. Typical
values range between \code{1} and \code{3}.}

\item{accuracy}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}

\item{scale_cut}{Scale cut function to be applied. See \code{scales::cut_short_scale()} and friends.}

\item{fontsize}{Font size in points. Defaults to \code{7}.}

\item{extra_padding}{Extra padding to create space for the value label.}

\item{vjust}{Vertical position adjustment of the value label.}

\item{hjust}{Horizontal position adjustment of the value label.}

\item{group}{Variable in the dataset to be used for grouping.}
}
\value{
A \code{tidyplot} object.
}
\description{
Add sum
}
\examples{
spendings \%>\%
  tidyplot(x = category, y = amount, color = category) \%>\%
  adjust_x_axis(rotate_labels = TRUE) \%>\%
  add_sum_bar()

spendings \%>\%
  tidyplot(x = category, y = amount, color = category) \%>\%
  adjust_x_axis(rotate_labels = TRUE) \%>\%
  add_sum_dash()

spendings \%>\%
  tidyplot(x = category, y = amount, color = category) \%>\%
  adjust_x_axis(rotate_labels = TRUE) \%>\%
  add_sum_dot()

spendings \%>\%
  tidyplot(x = category, y = amount, color = category) \%>\%
  adjust_x_axis(rotate_labels = TRUE) \%>\%
  add_sum_value()

spendings \%>\%
  tidyplot(x = category, y = amount) \%>\%
  adjust_x_axis(rotate_labels = TRUE) \%>\%
  add_sum_line()

spendings \%>\%
  tidyplot(x = category, y = amount) \%>\%
  adjust_x_axis(rotate_labels = TRUE) \%>\%
  add_sum_area()

# Combination
spendings \%>\%
  tidyplot(x = category, y = amount) \%>\%
  adjust_x_axis(rotate_labels = TRUE) \%>\%
  add_median_bar(alpha = 0.4) \%>\%
  add_median_dash() \%>\%
  add_median_dot() \%>\%
  add_median_value() \%>\%
  add_median_line()

# Changing arguments: alpha
# Makes objects transparent
spendings \%>\%
  tidyplot(x = category, y = amount, color = category) \%>\%
  theme_minimal_y() \%>\%
  adjust_x_axis(rotate_labels = TRUE) \%>\%
  add_sum_bar(alpha = 0.4)

# Changing arguments: saturation
# Reduces fill color saturation without making the object transparent
spendings \%>\%
  tidyplot(x = category, y = amount, color = category) \%>\%
  theme_minimal_y() \%>\%
  adjust_x_axis(rotate_labels = TRUE) \%>\%
  add_sum_bar(saturation = 0.3)

# Changing arguments: accuracy
spendings \%>\%
  tidyplot(x = category, y = amount, color = category) \%>\%
  adjust_x_axis(rotate_labels = TRUE) \%>\%
  add_sum_value(accuracy = 1)

# Changing arguments: fontsize
spendings \%>\%
  tidyplot(x = category, y = amount, color = category) \%>\%
  adjust_x_axis(rotate_labels = TRUE) \%>\%
  add_sum_value(fontsize = 10)

# Changing arguments: color
spendings \%>\%
  tidyplot(x = category, y = amount, color = category) \%>\%
  adjust_x_axis(rotate_labels = TRUE) \%>\%
  add_sum_value(color = "black")

# Changing arguments: extra_padding
spendings \%>\%
  tidyplot(x = category, y = amount, color = category) \%>\%
  adjust_x_axis(rotate_labels = TRUE) \%>\%
  add_sum_value(extra_padding = 0.5)

}
