% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-proportional.R
\name{add_pie}
\alias{add_pie}
\alias{add_donut}
\title{Add pie or donut chart}
\usage{
add_pie(plot, width = 1, reverse = FALSE, ...)

add_donut(plot, width = 1, reverse = FALSE, ...)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{width}{Width of the plot area. Defaults to \code{50}.}

\item{reverse}{Whether the order should be reversed or not. Defaults to \code{FALSE}, meaning not reversed.}

\item{...}{Arguments passed on to the \code{geom} function.}
}
\value{
A \code{tidyplot} object.
}
\description{
Add pie or donut chart
}
\examples{
# for a `count` only provide `color`
# `count` of the data points in each `energy_type` category
energy |>
  tidyplot(color = energy_type) |>
  add_pie()

energy |>
  tidyplot(color = energy_type) |>
  add_donut()

# for a `sum` provide `color` and `y`
# `sum` of `energy` in each `energy_type` category
energy |>
  tidyplot(y = energy, color = energy_type) |>
  add_pie()

energy |>
  tidyplot(y = energy, color = energy_type) |>
  add_donut()

}
