% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_sql.R
\name{tidypredict_sql_interval}
\alias{tidypredict_sql_interval}
\title{Returns a SQL query with formula to calculate predicted interval}
\usage{
tidypredict_sql_interval(model, con, interval = 0.95)
}
\arguments{
\item{model}{An R model or a tibble with a parsed model}

\item{con}{Database connection object. It is used to select
the correct SQL translation syntax.}

\item{interval}{The prediction interval, defaults to 0.95}
}
\description{
Returns a SQL query with formula to calculate predicted interval
}
\examples{
library(dbplyr)

model <- lm(mpg ~ wt + am + cyl, data = mtcars)
tidypredict_sql_interval(model, simulate_dbi())
}
\keyword{internal}
