% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_text_df_to_string.R
\name{df_to_string}
\alias{df_to_string}
\title{Convert a dataframe to a string representation}
\usage{
df_to_string(df, how = c("wide", "long"))
}
\arguments{
\item{df}{A \code{data.frame} object to be converted to a string}

\item{how}{In what way the df should be converted to a string;
either "wide" or "long". "wide" presents column names on the first row,
followed by the row values on each new row. "long" presents the values
of each row together with the column names, repeating for every row
after two lines of whitespace}
}
\value{
A single string representing the df
}
\description{
Converts a data frame to a string format, intended for sending it to a LLM
(or for display or logging).
}
\examples{
cars |>
  head(5) |>
  df_to_string(how = "wide")

cars |>
  head(5) |>
  df_to_string(how = "long")
}
\seealso{
Other text_helpers: 
\code{\link{skim_with_labels_and_levels}()},
\code{\link{vector_list_to_string}()}
}
\concept{text_helpers}
