% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_text_skim_with_labels_and_levels.R
\name{skim_with_labels_and_levels}
\alias{skim_with_labels_and_levels}
\title{Skim a dataframe and include labels and levels}
\usage{
skim_with_labels_and_levels(data)
}
\arguments{
\item{data}{A \code{data.frame} to be skimmed}
}
\value{
A \code{data.frame} with variable names, labels, levels, and a skim summary
}
\description{
This function takes a \code{data.frame} and returns a skim summary with variable names,
labels, and levels for categorical variables. It is a wrapper around the \code{\link[skimr:skim]{skimr::skim()}}
function.
}
\examples{
# First add some labels to 'mtcars':
mtcars$car <- rownames(mtcars)
mtcars$car <- factor(mtcars$car, levels = rownames(mtcars))
attr(mtcars$car, "label") <- "Name of the car"

# Then skim the data:
mtcars |>
  skim_with_labels_and_levels()
}
\seealso{
Other text_helpers: 
\code{\link{df_to_string}()},
\code{\link{vector_list_to_string}()}
}
\concept{text_helpers}
