% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate.R
\name{separate}
\alias{separate}
\title{Separate one column into multiple columns.}
\usage{
separate(data, col, into, sep = "[^[:alnum:]]+", remove = TRUE,
  convert = FALSE, extra = "warn", fill = "warn", ...)
}
\arguments{
\item{data}{A data frame.}

\item{col}{Bare column name.}

\item{into}{Names of new variables to create as character vector.}

\item{sep}{Separator between columns.

  If character, is interpreted as a regular expression. The default
  value is a regular expression that matches any sequence of
  non-alphanumeric values.

  If numeric, interpreted as positions to split at. Positive values start
  at 1 at the far-left of the string; negative value start at -1 at the
  far-right of the string. The length of \code{sep} should be one less than
  \code{into}.}

\item{remove}{If \code{TRUE}, remove input column from output data frame.}

\item{convert}{If \code{TRUE}, will run \code{\link{type.convert}} with
\code{as.is = TRUE} on new columns. This is useful if the component
columns are integer, numeric or logical.}

\item{extra}{If \code{sep} is a character vector, this controls what
  happens when there are too many pieces. There are three valid options:

  \itemize{
   \item "warn" (the default): emit a warning and drop extra values.
   \item "drop": drop any extra values without a warning.
   \item "merge": only splits at most \code{length(into)} times
  }}

\item{fill}{If \code{sep} is a character vector, this controls what
  happens when there are not enough pieces. There are three valid options:

  \itemize{
   \item "warn" (the default): emit a warning and fill from the right
   \item "right": fill with missing values on the right
   \item "left": fill with missing values on the left
  }}

\item{...}{Defunct, will be removed in the next version of the package.}
}
\description{
Given either regular expression or a vector of character positions,
\code{separate()} turns a single character column into multiple columns.
}
\examples{
library(dplyr)
df <- data.frame(x = c(NA, "a.b", "a.d", "b.c"))
df \%>\% separate(x, c("A", "B"))

# If every row doesn't split into the same number of pieces, use
# the extra and file arguments to control what happens
df <- data.frame(x = c("a", "a b", "a b c", NA))
df \%>\% separate(x, c("a", "b"))
# The same behaviour but no warnings
df \%>\% separate(x, c("a", "b"), extra = "drop", fill = "right")
# Another option:
df \%>\% separate(x, c("a", "b"), extra = "merge", fill = "left")

# If only want to split specified number of times use extra = "merge"
df <- data.frame(x = c("x: 123", "y: error: 7"))
df \%>\% separate(x, c("key", "value"), ": ", extra = "merge")
}
\seealso{
\code{\link{unite}()}, the complement.

\code{\link{separate_}} for a version that uses regular evaluation
  and is suitable for programming with.
}

