% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{arrange}
\alias{arrange}
\alias{bind_rows}
\alias{bind_cols}
\alias{distinct}
\alias{filter}
\alias{group_by}
\alias{summarise}
\alias{mutate}
\alias{rename}
\alias{rowwise}
\alias{left_join}
\alias{inner_join}
\alias{right_join}
\alias{full_join}
\alias{slice}
\alias{select}
\alias{sample_n}
\alias{sample_frac}
\alias{pull}
\title{Arrange rows by column values}
\usage{
bind_rows(..., .id = NULL, add.cell.ids = NULL)

bind_cols(..., .id = NULL)
}
\arguments{
\item{...}{For use by methods.}

\item{.id}{Data frame identifier.

  When `.id` is supplied, a new column of identifiers is
  created to link each row to its original data frame. The labels
  are taken from the named arguments to `bind_rows()`. When a
  list of data frames is supplied, the labels are taken from the
  names of the list. If no names are found a numeric sequence is
  used instead.}

\item{add.cell.ids}{from Seurat 3.0 A character vector of length(x = c(x, y)). Appends the corresponding values to the start of each objects' cell names.}

\item{.by_group}{If TRUE, will sort first by grouping variable. Applies to grouped data frames only.}

\item{.keep_all}{If TRUE, keep all variables in .data. If a combination of ... is not distinct, this keeps the first row of values. (See dplyr)}

\item{.preserve}{when `FALSE` (the default), the grouping structure
is recalculated based on the resulting data, otherwise it is kept as is.}

\item{.add}{When `FALSE`, the default, `group_by()` will
  override existing groups. To add to the existing groups, use
  `.add = TRUE`.

  This argument was previously called `add`, but that prevented
  creating a new grouping variable called `add`, and conflicts with
  our naming conventions.}

\item{.drop}{When `.drop = TRUE`, empty groups are dropped. See group_by_drop_default() for
what the default value is for this argument.}

\item{.data}{Input data frame.}

\item{x}{tbls to join. (See dplyr)}

\item{y}{tbls to join. (See dplyr)}

\item{by}{A character vector of variables to join by. (See dplyr)}

\item{copy}{If x and y are not from the same data source, and copy is TRUE, then y will be copied into the same src as x. (See dplyr)}

\item{suffix}{If there are non-joined duplicate variables in x and y, these suffixes will be added to the output to disambiguate them. Should be a character vector of length 2. (See dplyr)}

\item{tbl}{A data.frame.}

\item{size}{<[`tidy-select`][dplyr_select]>
For `sample_n()`, the number of rows to select.
For `sample_frac()`, the fraction of rows to select.
If `tbl` is grouped, `size` applies to each group.}

\item{replace}{Sample with or without replacement?}

\item{weight}{<[`tidy-select`][dplyr_select]> Sampling weights.
This must evaluate to a vector of non-negative numbers the same length as
the input. Weights are automatically standardised to sum to 1.}

\item{.env}{DEPRECATED.}

\item{name}{An optional parameter that specifies the column to be used
as names for a named vector. Specified in a similar manner as \code{var}.}
}
\value{
An object of the same type as `.data`.

* All rows appear in the output, but (usually) in a different place.
* Columns are not modified.
* Groups are not modified.
* Data frame attributes are preserved.

A Seurat object

An object of the same type as `.data`.

* Rows are a subset of the input, but appear in the same order.
* Columns are not modified.
* The number of groups may be reduced (if `.preserve` is not `TRUE`).
* Data frame attributes are preserved.

A grouped data frame, unless the combination of `...` and `add`
  yields a non empty set of grouping columns, a regular (ungrouped) data frame
  otherwise.

A tibble

An object of the same type as `.data`.

For `mutate()`:

* Rows are not affected.
* Existing columns will be preserved unless explicitly modified.
* New columns will be added to the right of existing columns.
* Columns given value `NULL` will be removed
* Groups will be recomputed if a grouping variable is mutated.
* Data frame attributes are preserved.

For `transmute()`:

* Rows are not affected.
* Apart from grouping variables, existing columns will be remove unless
  explicitly kept.
* Column order matches order of expressions.
* Groups will be recomputed if a grouping variable is mutated.
* Data frame attributes are preserved.

An object of the same type as `.data`.
* Rows are not affected.
* Column names are changed; column order is preserved
* Data frame attributes are preserved.
* Groups are updated to reflect new names.

A `tbl`

  A `tbl`

A Seurat object

A Seurat object

A Seurat object

A Seurat object

An object of the same type as `.data`. The output has the following
properties:

* Each row may appear 0, 1, or many times in the output.
* Columns are not modified.
* Groups are not modified.
* Data frame attributes are preserved.

An object of the same type as `.data`. The output has the following
properties:

* Rows are not affected.
* Output columns are a subset of input columns, potentially with a different
  order. Columns will be renamed if `new_name = old_name` form is used.
* Data frame attributes are preserved.
* Groups are maintained; you can't select off grouping variables.

A Seurat object

A vector the same size as `.data`.
}
\description{
`arrange()` order the rows of a data frame rows by the values of selected
columns.

Unlike other dplyr verbs, `arrange()` largely ignores grouping; you
need to explicit mention grouping variables (or use  `by_group = TRUE`)
in order to group by them, and functions of variables are evaluated
once per data frame, not once per group.

`filter()` retains the rows where the conditions you provide a `TRUE`. Note
that, unlike base subsetting with `[`, rows where the condition evaluates
to `NA` are dropped.

Most data operations are done on groups defined by variables.
`group_by()` takes an existing tbl and converts it into a grouped tbl
where operations are performed "by group". `ungroup()` removes grouping.

`summarise()` creates a new data frame. It will have one (or more) rows for
each combination of grouping variables; if there are no grouping variables,
the output will have a single row summarising all observations in the input.
It will contain one column for each grouping variable and one column
for each of the summary statistics that you have specified.

`summarise()` and `summarize()` are synonyms.

`mutate()` adds new variables and preserves existing ones;
`transmute()` adds new variables and drops existing ones.
New variables overwrite existing variables of the same name.
Variables can be removed by setting their value to `NULL`.

Rename individual variables using `new_name = old_name` syntax.

`rowwise()` is used for the results of [do()] when you
create list-variables. It is also useful to support arbitrary
complex operations that need to be applied to each row.

`slice()` lets you index rows by their (integer) locations. It allows you
to select, remove, and duplicate rows. It is accompanied by a number of
helpers for common use cases:

Select (and optionally rename) variables in a data frame, using a concise
mini-language that makes it easy to refer to variables based on their name
(e.g. `a:f` selects all columns from `a` on the left to `f` on the
right). You can also use predicate functions like is.numeric to select
variables based on their properties.

Sample n rows from a table

`pull()` is similar to `$`. It's mostly useful because it looks a little
nicer in pipes, it also works with remote data frames, and it can optionally
name the output.
}
\details{
## Locales
The sort order for character vectors will depend on the collating sequence
of the locale in use: see locales().

## Missing values
Unlike base sorting with `sort()`, `NA` are:
* always sorted to the end for local data, even when wrapped with `desc()`.
* treated differently for remote data, depending on the backend.

dplyr is not yet smart enough to optimise filtering optimisation
on grouped datasets that don't need grouped calculations. For this reason,
filtering is often considerably faster on ungroup()ed data.

Slice does not work with relational databases because they have no
intrinsic notion of row order. If you want to perform the equivalent
operation, use [filter()] and [row_number()].
}
\section{Methods}{

This function is a **generic**, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.


These function are **generic**s, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

Methods available in currently loaded packages:


These function are **generic**s, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

Methods available in currently loaded packages:


This function is a **generic**, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
}

\section{Grouped tibbles}{


Because mutating expressions are computed within groups, they may
yield different results on grouped tibbles. This will be the case
as soon as an aggregating, lagging, or ranking function is
involved. Compare this ungrouped mutate:

With the grouped equivalent:

The former normalises `mass` by the global average whereas the
latter normalises by the averages within gender levels.
}

\examples{
`\%>\%` = magrittr::`\%>\%`
pbmc_small \%>\%  arrange(nFeature_RNA)

`\%>\%` = magrittr::`\%>\%`
data("pbmc_small")
pbmc_small \%>\%  distinct(groups)


`\%>\%` = magrittr::`\%>\%`
data("pbmc_small")
pbmc_small \%>\%  filter(groups == "g1")

# Learn more in ?dplyr_eval
`\%>\%` = magrittr::`\%>\%`
data("pbmc_small")
pbmc_small \%>\%  group_by(groups)


`\%>\%` = magrittr::`\%>\%`
data("pbmc_small")
pbmc_small \%>\%  summarise(mean(nCount_RNA))

`\%>\%` = magrittr::`\%>\%`
data("pbmc_small")
pbmc_small \%>\%  mutate(nFeature_RNA = 1)

`\%>\%` = magrittr::`\%>\%`
data("pbmc_small")
pbmc_small \%>\%  rename(s_score = nFeature_RNA)

`\%>\%` = magrittr::`\%>\%`

`\%>\%` = magrittr::`\%>\%`
data("pbmc_small")
pbmc_small \%>\% left_join(pbmc_small \%>\% distinct(groups) \%>\% mutate(new_column = 1:2))

`\%>\%` = magrittr::`\%>\%`

data("pbmc_small")
pbmc_small \%>\% inner_join(pbmc_small \%>\% distinct(groups) \%>\% mutate(new_column = 1:2) \%>\% slice(1))

`\%>\%` = magrittr::`\%>\%`

data("pbmc_small")
pbmc_small \%>\% right_join(pbmc_small \%>\% distinct(groups) \%>\% mutate(new_column = 1:2) \%>\% slice(1))

`\%>\%` = magrittr::`\%>\%`
data("pbmc_small")
pbmc_small \%>\% full_join(tibble::tibble(groups = "g1", other=1:4))


`\%>\%` = magrittr::`\%>\%`
data("pbmc_small")
pbmc_small \%>\%  slice(1)

`\%>\%` = magrittr::`\%>\%`
data("pbmc_small")
pbmc_small \%>\%  select(cell, orig.ident )


`\%>\%` = magrittr::`\%>\%`
data("pbmc_small")
pbmc_small \%>\%  sample_n(50)
pbmc_small \%>\%  sample_frac(0.1)


`\%>\%` = magrittr::`\%>\%`
data("pbmc_small")
pbmc_small \%>\%  pull(groups)

}
\concept{grouping functions}
\concept{single table verbs}
\keyword{internal}
