% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_lm.r
\name{report_lm}
\alias{report_lm}
\title{Report method for linear regression models}
\usage{
report_lm(results, identifier, term = NULL, term_nr = NULL,
  statistic = NULL)
}
\arguments{
\item{results}{A tidy stats list.}

\item{identifier}{A character string identifying the model.}

\item{term}{A character string indicating which term you want to report the statistics of.}

\item{term_nr}{A number indicating which term you want to report the the statistics of.}

\item{statistic}{A character string of a statistic you want to extract from a model.}
}
\description{
Function to report a regression in APA style.
}
\examples{
# Read in a list of results
results <- read_stats(system.file("results.csv", package = "tidystats"))

# Example: regression term
report(results, identifier = "regression", term = "groupTrt")
report(results, identifier = "regression", term_nr = 2)
report(results, identifier = "regression", term = "groupTrt", statistic = "p")

}
