% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_chi_squared.R
\name{report_chi_squared}
\alias{report_chi_squared}
\title{Report function for a chi-squared test}
\usage{
report_chi_squared(identifier, results = getOption("tidystats_list"))
}
\arguments{
\item{identifier}{A character string identifying the model.}

\item{results}{A tidystats list.}
}
\description{
Function to report a chi-squared test in APA style.
}
\examples{
# Read in a list of results
results <- read_stats(system.file("results.csv", package = "tidystats"))

# Set the default tidystats list in options()
options(tidystats_list = results)

# Report results
report(identifier = "chi_squared")
report(identifier = "chi_squared_yates")

}
