% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_stats.R
\name{read_stats}
\alias{read_stats}
\title{Read a .json file that was produced with \code{\link[=write_stats]{write_stats()}}}
\usage{
read_stats(file)
}
\arguments{
\item{file}{A string specifying the path to the tidystats data file.}
}
\description{
\code{\link[=read_stats]{read_stats()}} can read a .json file containing statistics that was produced
using tidystats. It returns a list containing the statistics, with the
identifier as the name for each list element.
}
\examples{
# A simple example, assuming there is a file called 'statistics.json'
\dontrun{
statistics <- read_stats("statistics.json")
}

# A working example
statistics <- read_stats(
  file = system.file("statistics.json", package = "tidystats")
)

}
