% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull.R
\name{pull.}
\alias{pull.}
\title{Pull out a single variable}
\usage{
pull.(.df, var = -1, name = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{var}{The column to pull from the data.table as:
\itemize{
\item a variable name
\item a positive integer giving the column position
\item a negative integer giving the column position counting from the right
}}

\item{name}{Optional - specifies the column to be used as names for the vector.}
}
\description{
Pull a single variable from a data.table as a vector.
}
\examples{
df <- data.table(
  x = 1:3,
  y = 1:3
)

# Grab column by name
df \%>\%
  pull.(y)

# Grab column by position
df \%>\%
  pull.(1)

# Defaults to last column
df \%>\%
  pull.()
}
