% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_spatraster.R
\name{geom_spatraster}
\alias{geom_spatraster}
\title{Visualise SpatRaster objects}
\source{
Based on the \code{layer_spatial()} implementation on ggspatial package.
Thanks to \href{https://github.com/paleolimbot}{Dewey Dunnington} and
\href{https://github.com/paleolimbot/ggspatial/graphs/contributors}{ggspatial contributors}.
}
\usage{
geom_spatraster(
  mapping = aes(),
  data,
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = FALSE,
  interpolate = FALSE,
  maxcell = 5e+05,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{A SpatRaster object.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{interpolate}{If \code{TRUE} interpolate linearly, if \code{FALSE}
(the default) don't interpolate.}

\item{maxcell}{positive integer. Maximum number of cells to use for
the plot.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\value{
A ggplot2 layer
}
\description{
This geom is used to visualise SpatRaster objects (see \code{\link[terra:rast]{terra::rast()}}). The
geom is designed for visualise the object by layers, as \code{\link[terra:plot]{terra::plot()}} does.

For plotting SpatRaster objects as map tiles (i.e. RGB SpatRaster), use
\code{\link[=geom_spatraster_rgb]{geom_spatraster_rgb()}}.

The underlying implementation is based on \code{\link[ggplot2:geom_tile]{ggplot2::geom_raster()}}.
}
\section{terra equivalent}{


\code{\link[terra:plot]{terra::plot()}}
}

\section{Coords}{


When the SpatRaster does not present a crs (i.e.,
\code{terra::crs(rast) == ""}) the geom does not make any assumption on the
scales.

On SpatRaster that have a crs, the geom uses \code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}} to adjust
the scales. That means that also the \strong{SpatRaster may be reprojected}.
}

\section{Aesthetics}{


\code{geom_spatraster()} understands the following aesthetics:
\itemize{
\item \code{fill}
}

If \code{fill} is not provided, \code{geom_spatraster()} creates a ggplot2 layer with
all the layers of the SpatRaster object. Use \code{facet_wrap(~lyr)} to display
properly the SpatRaster layers.

If \code{fill} is used, it should contain the name of one layer that is present
on the SpatRaster (i.e.
\verb{geom_spatraster(data = rast, aes(fill = <name_of_lyr>)}). Names of the
layers can be retrieved using \code{names(rast)}.
}

\section{Facets}{


You can use \code{ facet_wrap(~lyr)} for creating a faceted plot by each layer of
the SpatRaster object. See \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}} for details.
}

\section{Computed variables}{


This geom computes internally some variables that are available for use as
aesthetics, using (for example) \verb{aes(color = after_stat(<computed>))} (see
\code{\link[ggplot2:aes_eval]{ggplot2::after_stat()}}).

\describe{
\item{\code{lyr}}{Name of the layer.}
}
}

\examples{
\donttest{
# Avg temperature on spring in Castille and Leon (Spain)
file_path <- system.file("extdata/cyl_temp.tif", package = "tidyterra")

library(terra)
temp_rast <- rast(file_path)

library(ggplot2)

# Display a single layer
names(temp_rast)

ggplot() +
  geom_spatraster(data = temp_rast, aes(fill = tavg_04)) +
  # You can use coord_sf
  coord_sf(crs = 3857) +
  scale_fill_terrain_c()

# Display facets
ggplot() +
  geom_spatraster(data = temp_rast) +
  facet_wrap(~lyr, ncol = 2) +
  scale_fill_terrain_b()


# Non spatial rasters

no_crs <- rast(crs = NA, extent = c(0, 100, 0, 100), nlyr = 1)
values(no_crs) <- seq_len(ncell(no_crs))


ggplot() +
  geom_spatraster(data = no_crs)

# Downsample

ggplot() +
  geom_spatraster(data = no_crs, maxcell = 25)
}

}
\seealso{
\code{\link[ggplot2:geom_tile]{ggplot2::geom_raster()}}, \code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}},
\code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}

Other ggplot2 utils:
\code{\link{autoplot}()},
\code{\link{geom_spat_contour}},
\code{\link{geom_spatraster_rgb}()},
\code{\link{ggspatvector}},
\code{\link{scale_fill_terrain}}
}
\concept{ggplot2.utils}
