% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot}
\alias{autoplot}
\alias{autoplot.SpatRaster}
\title{Create a complete ggplot for SpatRasters}
\usage{
\method{autoplot}{SpatRaster}(
  object,
  mapping = aes(),
  rgb = FALSE,
  facets = TRUE,
  nrow = NULL,
  ncol = 2,
  ...
)
}
\arguments{
\item{object}{A SpatRaster object.}

\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}} or
\code{\link[ggplot2:aes_]{ggplot2::aes_()}}. See \strong{Aesthetics} specially in the use of \code{fill}
aesthetic.}

\item{rgb}{Logical. Should be plotted as a RGB image?}

\item{facets}{Logical. Should facets be displayed?}

\item{nrow, ncol}{Number of rows and columns on the facet.}

\item{...}{other arguments passed to \code{\link[=geom_spatraster]{geom_spatraster()}} or
\code{\link[=geom_spatraster_rgb]{geom_spatraster_rgb()}}.}
}
\value{
A ggplot2 layer
}
\description{
\code{autoplot()} uses ggplot2 to draw plots as the ones produced by
\code{\link[terra:plot]{terra::plot()}}/\code{\link[terra:plotRGB]{terra::plotRGB()}} in a single command.
}
\details{
Implementation of \code{\link[ggplot2:autoplot]{ggplot2::autoplot()}}.
}
\examples{
\donttest{

file_path <- system.file("extdata/cyl_temp.tif", package = "tidyterra")

library(terra)
temp <- rast(file_path)

library(ggplot2)
autoplot(temp)


# With a tile

system.file("extdata/cyl_tile.tif", package = "tidyterra") \%>\%
  rast() \%>\%
  autoplot(rgb = TRUE)
}
}
\seealso{
\code{\link[ggplot2:autoplot]{ggplot2::autoplot()}}

Other ggplot2 utils:
\code{\link{geom_spat_contour}},
\code{\link{geom_spatraster_rgb}()},
\code{\link{geom_spatraster}()},
\code{\link{ggspatvector}}
}
\concept{ggplot2.utils}
