% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hypsometric_tints_db}
\alias{hypsometric_tints_db}
\title{Hypsometric palettes database}
\format{
A tibble of 1102 rows and
6 columns. with the following fields:
\itemize{
\item \strong{pal}: Name of the palette.
\item \strong{limit}: Recommended elevation limit (in meters) for each color.
\item \strong{r},\strong{g},\strong{b}: Value of the red, green and blue channel (RGB color
mode).
\item \strong{hex}: Hex code of the color.
}
}
\source{
cpt-city: \url{http://soliton.vm.bytemark.co.uk/pub/cpt-city/}.
}
\description{
A tibble including the color map of
33 gradient palettes. All the
palettes includes also a definition of colors limits in terms of elevation
(meters), that can be used with \code{\link[ggplot2:scale_gradient]{ggplot2::scale_fill_gradientn()}}.
}
\examples{
\donttest{
data("hypsometric_tints_db")

hypsometric_tints_db

# Select a palette
wikicols <- hypsometric_tints_db \%>\%
  filter(pal == "wiki-2.0")

f <- system.file("extdata/asia.tif", package = "tidyterra")
r <- terra::rast(f)

library(ggplot2)

p <- ggplot() +
  geom_spatraster(data = r) +
  labs(fill = "elevation")

p +
  scale_fill_gradientn(colors = wikicols$hex)

# Use with limits
p +
  scale_fill_gradientn(
    colors = wikicols$hex,
    values = scales::rescale(wikicols$limit),
    limit = range(wikicols$limit)
  )
}
}
\seealso{
\code{\link[=scale_fill_hypso_c]{scale_fill_hypso_c()}}

Other datasets: 
\code{\link{cross_blended_hypsometric_tints_db}},
\code{\link{volcano2}}
}
\concept{datasets}
