% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales_hypso.R
\name{scale_hypso}
\alias{scale_hypso}
\alias{scale_fill_hypso_d}
\alias{scale_colour_hypso_d}
\alias{scale_fill_hypso_c}
\alias{scale_colour_hypso_c}
\alias{scale_fill_hypso_b}
\alias{scale_colour_hypso_b}
\alias{hypso.colors}
\alias{scale_fill_hypso_tint_d}
\alias{scale_colour_hypso_tint_d}
\alias{scale_fill_hypso_tint_c}
\alias{scale_colour_hypso_tint_c}
\alias{scale_fill_hypso_tint_b}
\alias{scale_colour_hypso_tint_b}
\alias{hypso.colors2}
\alias{scale_color_hypso_d}
\alias{scale_color_hypso_tint_d}
\alias{scale_color_hypso_c}
\alias{scale_color_hypso_tint_c}
\alias{scale_color_hypso_b}
\alias{scale_color_hypso_tint_b}
\title{Gradient scales for representing hypsometry and bathymetry}
\source{
cpt-city: \url{http://seaviewsensing.com/pub/cpt-city/}.
}
\usage{
scale_fill_hypso_d(
  palette = "etopo1_hypso",
  ...,
  alpha = 1,
  direction = 1,
  na.translate = FALSE,
  drop = TRUE
)

scale_colour_hypso_d(
  palette = "etopo1_hypso",
  ...,
  alpha = 1,
  direction = 1,
  na.translate = FALSE,
  drop = TRUE
)

scale_fill_hypso_c(
  palette = "etopo1_hypso",
  ...,
  alpha = 1,
  direction = 1,
  na.value = "transparent",
  guide = "colourbar"
)

scale_colour_hypso_c(
  palette = "etopo1_hypso",
  ...,
  alpha = 1,
  direction = 1,
  na.value = "transparent",
  guide = "colourbar"
)

scale_fill_hypso_b(
  palette = "etopo1_hypso",
  ...,
  alpha = 1,
  direction = 1,
  na.value = "transparent",
  guide = "coloursteps"
)

scale_colour_hypso_b(
  palette = "etopo1_hypso",
  ...,
  alpha = 1,
  direction = 1,
  na.value = "transparent",
  guide = "coloursteps"
)

hypso.colors(n, palette = "etopo1_hypso", alpha = 1, rev = FALSE)

scale_fill_hypso_tint_d(
  palette = "etopo1_hypso",
  ...,
  alpha = 1,
  direction = 1,
  na.translate = FALSE,
  drop = TRUE
)

scale_colour_hypso_tint_d(
  palette = "etopo1_hypso",
  ...,
  alpha = 1,
  direction = 1,
  na.translate = FALSE,
  drop = TRUE
)

scale_fill_hypso_tint_c(
  palette = "etopo1_hypso",
  ...,
  alpha = 1,
  direction = 1,
  values = NULL,
  limits = NULL,
  na.value = "transparent",
  guide = "colourbar"
)

scale_colour_hypso_tint_c(
  palette = "etopo1_hypso",
  ...,
  alpha = 1,
  direction = 1,
  values = NULL,
  limits = NULL,
  na.value = "transparent",
  guide = "colourbar"
)

scale_fill_hypso_tint_b(
  palette = "etopo1_hypso",
  ...,
  alpha = 1,
  direction = 1,
  values = NULL,
  limits = NULL,
  na.value = "transparent",
  guide = "coloursteps"
)

scale_colour_hypso_tint_b(
  palette = "etopo1_hypso",
  ...,
  alpha = 1,
  direction = 1,
  values = NULL,
  limits = NULL,
  na.value = "transparent",
  guide = "coloursteps"
)

hypso.colors2(n, palette = "etopo1_hypso", alpha = 1, rev = FALSE)
}
\arguments{
\item{palette}{A valid palette name. The name is matched to the list of
available palettes, ignoring upper vs. lower case. See
\link{hypsometric_tints_db} for more info. Values available are:
\code{"arctic"}, \code{"arctic_bathy"}, \code{"arctic_hypso"}, \code{"c3t1"}, \code{"colombia"}, \code{"colombia_bathy"}, \code{"colombia_hypso"}, \code{"dem_poster"}, \code{"dem_print"}, \code{"dem_screen"}, \code{"etopo1"}, \code{"etopo1_bathy"}, \code{"etopo1_hypso"}, \code{"gmt_globe"}, \code{"gmt_globe_bathy"}, \code{"gmt_globe_hypso"}, \code{"meyers"}, \code{"meyers_bathy"}, \code{"meyers_hypso"}, \code{"moon"}, \code{"moon_bathy"}, \code{"moon_hypso"}, \code{"nordisk-familjebok"}, \code{"nordisk-familjebok_bathy"}, \code{"nordisk-familjebok_hypso"}, \code{"pakistan"}, \code{"spain"}, \code{"usgs-gswa2"}, \code{"utah_1"}, \code{"wiki-2.0"}, \code{"wiki-2.0_bathy"}, \code{"wiki-2.0_hypso"}, \code{"wiki-schwarzwald-cont"}.}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale}}, \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale}}, \code{\link[ggplot2:binned_scale]{ggplot2::binned_scale}}
  \describe{
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{expand}}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
    \item{\code{minor_breaks}}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (one minor break between
each major break)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks. Also
accepts rlang \link[rlang:as_function]{lambda} function notation. When
the function has two arguments, it will be given the limits and major
breaks.
}}
    \item{\code{n.breaks}}{An integer guiding the number of major breaks. The algorithm
may choose a slightly different number to ensure nice break labels. Will
only have an effect if \code{breaks = waiver()}. Use \code{NULL} to use the default
number of breaks given by the transformation.}
    \item{\code{nice.breaks}}{Logical. Should breaks be attempted placed at nice values
instead of exactly evenly spaced between the limits. If \code{TRUE} (default)
the scale will ask the transformation object to create breaks, and this
may result in a different number of breaks than requested. Ignored if
breaks are given explicitly.}
  }}

\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{direction}{Sets the order of colors in the scale. If 1, the default,
colors are ordered from darkest to lightest. If -1, the order of colors is
reversed.}

\item{na.translate}{Should \code{NA} values be removed from the legend? Default
is \code{TRUE}.}

\item{drop}{Should unused factor levels be omitted from the scale? The
default (\code{TRUE}) removes unused factors.}

\item{na.value}{Missing values will be replaced with this value. By default,
\CRANpkg{tidyterra} uses \code{na.value = "transparent"} so cells with \code{NA} are
not filled. See also
\href{https://github.com/dieghernan/tidyterra/issues/120}{#120}.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}

\item{n}{the number of colors (\eqn{\ge 1}) to be in the
    palette.}

\item{rev}{logical indicating whether the ordering of the colors should
    be reversed.}

\item{values}{if colours should not be evenly positioned along the gradient
this vector gives the position (between 0 and 1) for each colour in the
\code{colours} vector. See \code{\link[scales:rescale]{rescale()}} for a convenience function
to map an arbitrary range to between 0 and 1.}

\item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[ggplot2:coord_cartesian]{coord_cartesian()}}).
}}
}
\value{
The corresponding \CRANpkg{ggplot2} layer with the values applied to the
\code{fill/colour} aesthetics.
}
\description{
Implementation of a selection of gradient palettes available in
\href{http://seaviewsensing.com/pub/cpt-city/}{cpt-city}.

The following scales and palettes are provided:
\itemize{
\item \verb{scale_*_hypso_d()}: For discrete values.
\item \verb{scale_*_hypso_c()}: For continuous values.
\item \verb{scale_*_hypso_b()}: For binning continuous values.
\item \code{hypso.colors()}: A gradient color palette. See also
\code{\link[grDevices:palettes]{grDevices::terrain.colors()}} for details.
}

An additional set of scales is provided. These scales can act as
\href{https://en.wikipedia.org/wiki/Hypsometric_tints}{hypsometric (or bathymetric) tints}.
\itemize{
\item \verb{scale_*_hypso_tint_d()}: For discrete values.
\item \verb{scale_*_hypso_tint_c()}: For continuous values.
\item \verb{scale_*_hypso_tint_b()}: For binning continuous values.
\item \code{hypso.colors2()}: A gradient color palette. See also
\code{\link[grDevices:palettes]{grDevices::terrain.colors()}} for details.
}

See \strong{Details}.

Additional parameters \code{...} would be passed on to:
\itemize{
\item Discrete values: \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.
\item Continuous values: \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}.
\item Binned continuous values: \code{\link[ggplot2:binned_scale]{ggplot2::binned_scale()}}.
}

\strong{Note that} \CRANpkg{tidyterra} just documents a selection of these
additional parameters, check the \CRANpkg{ggplot2} functions listed above to
see the full range of parameters accepted by these scales.
}
\details{
On \verb{scale_*_hypso_tint_*} palettes, the position of the gradients and
the limits of the palette are redefined. Instead of treating the color
palette as a continuous gradient, they are rescaled to act as a hypsometric
tint. A rough description of these tints are:
\itemize{
\item Blue colors: Negative values.
\item Green colors: 0 to 1.000 values.
\item Browns: 1000 to 4.000 values.
\item Whites: Values higher than 4.000.
}

The following orientation would vary depending on the palette definition
(see \link{hypsometric_tints_db} for an example on how this could be achieved).

Note that the setup of the palette may not be always suitable for your
specific data. For example, a \code{SpatRaster} of small parts of the globe (and
with a limited range of elevations) may not be well represented. As an
example, a \code{SpatRaster} with a range of values on \verb{[100, 200]} would appear
almost as an uniform color. This could be adjusted using the
\code{limits}/\code{values} parameters.

\code{hypso.colors2()} provides a gradient color palette where the distance
between colors is different depending of the type of color. In contrast,
\code{hypso.colors()} provides an uniform gradient across colors. See
\strong{Examples}.
}
\examples{
\donttest{
filepath <- system.file("extdata/volcano2.tif", package = "tidyterra")

library(terra)
volcano2_rast <- rast(filepath)

# Palette
plot(volcano2_rast, col = hypso.colors(100, palette = "wiki-2.0_hypso"))

# Palette with uneven colors
plot(volcano2_rast, col = hypso.colors2(100, palette = "wiki-2.0_hypso"))


library(ggplot2)
ggplot() +
  geom_spatraster(data = volcano2_rast) +
  scale_fill_hypso_c(palette = "colombia_hypso")

# Use hypsometric  tint version...
ggplot() +
  geom_spatraster(data = volcano2_rast) +
  scale_fill_hypso_tint_c(palette = "colombia_hypso")

# ...but not suitable for the range of the raster: adjust
my_lims <- minmax(volcano2_rast) \%>\% as.integer() + c(-2, 2)

ggplot() +
  geom_spatraster(data = volcano2_rast) +
  scale_fill_hypso_tint_c(
    palette = "colombia_hypso",
    limits = my_lims
  )

# Full map with true tints

f_asia <- system.file("extdata/asia.tif", package = "tidyterra")
asia <- rast(f_asia)

ggplot() +
  geom_spatraster(data = asia) +
  scale_fill_hypso_tint_c(
    palette = "etopo1",
    labels = scales::label_number(),
    breaks = c(-10000, 0, 5000, 8000),
    guide = guide_colorbar(reverse = TRUE)
  ) +
  labs(fill = "elevation (m)") +
  theme(
    legend.position = "bottom",
    legend.title.position = "top",
    legend.key.width = rel(3),
    legend.ticks = element_line(colour = "black", linewidth = 0.3),
    legend.direction = "horizontal"
  )

# Binned
ggplot() +
  geom_spatraster(data = volcano2_rast) +
  scale_fill_hypso_b(breaks = seq(70, 200, 25), palette = "wiki-2.0_hypso")

# With limits and breaks
ggplot() +
  geom_spatraster(data = volcano2_rast) +
  scale_fill_hypso_tint_b(
    breaks = seq(75, 200, 25),
    palette = "wiki-2.0_hypso",
    limits = my_lims
  )

# With discrete values
factor <- volcano2_rast \%>\% mutate(cats = cut(elevation,
  breaks = c(100, 120, 130, 150, 170, 200),
  labels = c(
    "Very Low", "Low", "Average", "High",
    "Very High"
  )
))

ggplot() +
  geom_spatraster(data = factor, aes(fill = cats)) +
  scale_fill_hypso_d(na.value = "gray10", palette = "dem_poster")


# Tint version
ggplot() +
  geom_spatraster(data = factor, aes(fill = cats)) +
  scale_fill_hypso_tint_d(na.value = "gray10", palette = "dem_poster")
}
# Display all the cpl_city palettes

pals <- unique(hypsometric_tints_db$pal)

# Helper fun for plotting

ncols <- 128
rowcol <- grDevices::n2mfrow(length(pals))

opar <- par(no.readonly = TRUE)
par(mfrow = rowcol, mar = rep(1, 4))

for (i in pals) {
  image(
    x = seq(1, ncols), y = 1, z = as.matrix(seq(1, ncols)),
    col = hypso.colors(ncols, i), main = i,
    ylab = "", xaxt = "n", yaxt = "n", bty = "n"
  )
}
par(opar)
# Display all the cpl_city palettes on version 2

pals <- unique(hypsometric_tints_db$pal)

# Helper fun for plotting

ncols <- 128
rowcol <- grDevices::n2mfrow(length(pals))

opar <- par(no.readonly = TRUE)
par(mfrow = rowcol, mar = rep(1, 4))

for (i in pals) {
  image(
    x = seq(1, ncols), y = 1, z = as.matrix(seq(1, ncols)),
    col = hypso.colors2(ncols, i), main = i,
    ylab = "", xaxt = "n", yaxt = "n", bty = "n"
  )
}
par(opar)
}
\seealso{
\link{hypsometric_tints_db}, \code{\link[terra:plot]{terra::plot()}}, \code{\link[terra:minmax]{terra::minmax()}},
\code{\link[ggplot2:scale_viridis]{ggplot2::scale_fill_viridis_c()}}

See also \CRANpkg{ggplot2} docs on additional \code{...} parameters.

Other gradient scales and palettes for hypsometry:
\code{\link{scale_color_coltab}()},
\code{\link{scale_cross_blended}},
\code{\link{scale_grass}},
\code{\link{scale_princess}},
\code{\link{scale_terrain}},
\code{\link{scale_whitebox}}
}
\concept{gradients}
