% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{read_gtfs}
\alias{read_gtfs}
\title{Get and validate dataframes of General Transit Feed Specification (GTFS) data.}
\usage{
read_gtfs(path, local = FALSE, quiet = FALSE)
}
\arguments{
\item{path}{Character. url link to zip file OR path to local zip file. if to local path, then option \code{local} must be set to TRUE.}

\item{local}{Boolean. If the paths are searching locally or not. Default is FALSE (that is, urls).}

\item{quiet}{Boolean. Whether to see file download progress and files extract. FALSE by default.}
}
\value{
Dataframes of GTFS data.
}
\description{
This function reads GTFS text files from a local or remote zip file.
It also validates the files against the GTFS specification by file, requirement status, and column name
The data are returned as a list of dataframes and a validation object,
which contains details on whether all required files were found,
and which required and optional columns are present.
}
\examples{
\donttest{
library(dplyr)
u1 <- "https://developers.google.com/transit/gtfs/examples/sample-feed.zip"
sample_gtfs <- read_gtfs(u1)
attach(sample_gtfs)
#list routes by the number of stops they have
routes_df \%>\% inner_join(trips_df, by="route_id") \%>\%
  inner_join(stop_times_df) \%>\% 
    inner_join(stops_df, by="stop_id") \%>\% 
      group_by(route_long_name) \%>\%
        summarise(stop_count=n_distinct(stop_id)) \%>\%
          arrange(desc(stop_count))
}
}
