% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequencies.R
\name{get_stop_frequency}
\alias{get_stop_frequency}
\title{Get Stop Frequency}
\usage{
get_stop_frequency(gtfs_obj, start_hour = 6, end_hour = 22,
  service_id = "", dow = c(1, 1, 1, 1, 1, 0, 0), by_route = TRUE,
  wide = FALSE)
}
\arguments{
\item{gtfs_obj}{a list of gtfs dataframes as read by read_gtfs().}

\item{start_hour}{(optional) an integer indicating the start hour (default 7)}

\item{end_hour}{(optional) an integer indicating the end hour (default 20)}

\item{service_id}{(optional) a string from the calendar dataframe identifying a particular service schedule.}

\item{dow}{(optional) integer vector indicating which days of week to calculate for. default is weekday, e.g. c(1,1,1,1,1,0,0)}

\item{by_route}{default TRUE, if FALSE then calculate headway for any line coming through the stop in the same direction on the same schedule.}

\item{wide}{(optional) if true, then return a wide rather than tidy data frame}
}
\value{
a gtfs_obj with a dataframe of stops with a "Trips" variable representing the count trips taken through each stop for a route within a given time frame
}
\description{
Get Stop Frequency
}
\examples{
data(gtfs_obj)
gtfs_obj <- get_stop_frequency(gtfs_obj)
x <- order(gtfs_obj$stops_frequency$headway)
head(gtfs_obj$stops_frequency_df[x,])
}
