% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate-su-hill.R
\name{simulate_su_hill_data}
\alias{simulate_su_hill_data}
\title{Simulate data with scenarios from Hill and Su (2013)}
\usage{
simulate_su_hill_data(
  n,
  treatment_linear = TRUE,
  response_parallel = TRUE,
  response_aligned = TRUE,
  y_sd = 1,
  tau = 4,
  omega = 0,
  add_categorical = FALSE,
  coef_categorical_treatment = NULL,
  coef_categorical_nontreatment = NULL
)
}
\arguments{
\item{n}{Size of simulated sample.}

\item{treatment_linear}{Treatment assignment mechanism is linear?}

\item{response_parallel}{Response surface is parallel?}

\item{response_aligned}{Response surface is aligned?}

\item{y_sd}{Observation noise.}

\item{tau}{Treatment effect for parallel response surfaces. Not applicable if surface is nonparallel.}

\item{omega}{Offset to control treatment assignment ratios.}

\item{add_categorical}{Should a categorical variable be added? (Not in Hill and Su)}

\item{coef_categorical_treatment}{What are the coefficients of the categorical variable under treatment? (Not in Hill and Su)}

\item{coef_categorical_nontreatment}{What are the coefficients of the categorical variable under nontreatment? (Not in Hill and Su)}
}
\value{
An object of class \code{suhillsim} that is a list with elements
\item{data}{Simulated data in data.frame}
\item{mean_y}{The mean y values for each individual (row)}
\item{args}{List of arguments passed to function}
\item{formulas}{Response formulas used to generate data}
\item{coefs}{Coefficients for the formulas}
}
\description{
Sample \eqn{n} observations with the following scheme:
\enumerate{
  \item Covariates: \eqn{X_j ~ N(0,1)}.
  \item Assignment: \eqn{Z ~ Bin(n, p)}  with \eqn{p = logit^{-1}(a + X \gamma^L + Q \gamma^N)} where \eqn{a = \omega - mean(X \gamma^L + Q \gamma^N)}.
  \item Mean response: \eqn{E(Y(0)|X) = X \beta_0^L + Q \beta_0^N } and \eqn{E(Y(1)|X) = X \beta_1^L + Q \beta_1^N}.
  \item Observation: \eqn{Y ~ N(\mu,\sigma_y^2))}.
}
Superscript \eqn{L} denotes the linear components, whilst \eqn{N} denotes the non-linear
components.
}
\details{
Coefficients used are returned in the list this function creates. See Table 1 in Su and Hill (2013) for the table of coefficients.
The \eqn{X_j} are in a data.frame named \code{data} in the returned list.
The formula for the model matrix \eqn{[X,Q]} is named \code{su_hill_formula} in the returned list.
The coefficients used for the model matrix are contained in \code{coefs}.
The Su and Hill (2013) simulations did not include categorical variables, but you can add them here using arguments: \code{add_categorical}, \code{coef_categorical_treatment}, \code{coef_categorical_nontreatment}.

Hill, Jennifer; Su, Yu-Sung. Ann. Appl. Stat. 7 (2013), no. 3, 1386--1420. doi:10.1214/13-AOAS630. \url{https://projecteuclid.org/euclid.aoas/1380804800}
}
