% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_load.R
\name{tt_load}
\alias{tt_load}
\title{Load TidyTuesday data from Github}
\usage{
tt_load(x, week, download_files = "All", ..., auth = github_pat())
}
\arguments{
\item{x}{string representation of the date of data to pull, in YYYY-MM-dd
format, or just numeric entry for year}

\item{week}{left empty unless x is a numeric year entry, in which case the
week of interest should be entered}

\item{download_files}{which files to download from repo. defaults and
assumes "All" for the week.}

\item{...}{pass methods to the parsing functions. These will be passed to
ALL files, so be careful.}

\item{auth}{github Personal Access Token. See PAT section for more
information}
}
\value{
tt_data object, which contains data that can be accessed via `$`,
 and the readme for the weeks tidytuesday through printing the object or
 calling `readme()`
}
\description{
Load TidyTuesday data from Github
}
\section{PAT}{

A Github PAT is a personal Access Token. This allows for signed queries to
the github api, and increases the limit on the number of requests allowed
from 60 to 5000. Follow instructions from
<https://happygitwithr.com/github-pat.html> to set the PAT.
}

\examples{

# check to make sure there are requests still available
if(rate_limit_check(quiet = TRUE) > 10){

tt_output <- tt_load("2019-01-15")
tt_output
agencies <- tt_output$agencies

}

}
