% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvect_o3.R
\name{solvect_o3}
\alias{solvect_o3}
\title{Determine disinfection credit from ozone.}
\source{
USEPA (2020) Equation 4-4 through 4-7
https://www.epa.gov/system/files/documents/2022-02/disprof_bench_3rules_final_508.pdf

See references list at: \url{https://github.com/BrownandCaldwell-Public/tidywater/wiki/References}
}
\usage{
solvect_o3(water, time, dose, kd, baffle)
}
\arguments{
\item{water}{Source water object of class "water" created by \code{\link{define_water}}. Water must include ph and temp}

\item{time}{Retention time of disinfection segment in minutes.}

\item{dose}{Ozone dose in mg/L. This value can also be the y intercept of the decay curve (often slightly lower than ozone dose.)}

\item{kd}{First order decay constant. This parameter is optional. If not specified, the default ozone decay equations will be used.}

\item{baffle}{Baffle factor - unitless value between 0 and 1.}
}
\value{
A data frame containing actual CT, giardia log removal, virus log removal, and crypto log removal.
}
\description{
This function takes a water defined by \code{\link{define_water}} and the first order decay curve parameters
from an ozone dose and outputs a dataframe of acutal CT, and log removal for giardia, virus, and crypto
}
\details{
First order decay curve for ozone has the form: `residual = dose * exp(kd*time)`. kd should be a negative number.
Actual CT is an integration of the first order curve. The first 30 seconds are removed from the integral to account for
instantaneous demand.
}
\examples{

# Use kd from experimental data (recommended):
define_water(ph = 7.5, temp = 25) \%>\%
  solvect_o3(time = 10, dose = 2, kd = -0.5, baffle = 0.9)
define_water(ph = 7.5, alk = 100, doc = 2, uv254 = .02, br = 50) \%>\%
  solvect_o3(time = 10, dose = 2, baffle = 0.5)

}
\seealso{
\code{\link{define_water}}
}
