% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_id_from_wikipedia.R
\name{tw_get_id_of_wikipedia_page}
\alias{tw_get_id_of_wikipedia_page}
\title{Gets the Wikidata id of a Wikipedia page}
\usage{
tw_get_id_of_wikipedia_page(url = NULL, title = NULL, language = NULL)
}
\arguments{
\item{url}{Full URL to a Wikipedia page. If given, title and language can be left empty.}

\item{title}{Title of a Wikipedia page or final parts of its url. If given, url can be left empty, but language must be provided.}

\item{language}{Two-letter language code used to define the Wikipedia version to use. If url given, this can be left empty.}
}
\value{
A character vector of Wikidata identifiers.
}
\description{
Gets the Wikidata id of a Wikipedia page
}
\examples{
if (interactive()) {
  tw_get_id_of_wikipedia_page(title = "Margaret Mead", language = "en")
}
}
