% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlsx_color_theme.R
\name{xlsx_color_theme}
\alias{xlsx_color_theme}
\alias{xlsx_colour_theme}
\title{Import theme color definitions from xlsx (Excel) files}
\usage{
xlsx_color_theme(path, check_filetype = TRUE)

xlsx_colour_theme(path, check_filetype = TRUE)
}
\arguments{
\item{path}{Path to the xlsx file.}

\item{check_filetype}{Logical. Whether to check that the filetype is xlsx (or
xlsm) by looking at the file itself, rather than using the filename
extension.}
}
\value{
A data frame, one row per colour, with the following columns.
\itemize{
\item \code{name} The name of the theme.
\item \code{rgb} The RGB colour that has been set for the theme in this file.
}
}
\description{
\code{xlsx_color_theme()} (alias \code{xlsx_colour_theme()} returns the names and RGB
values of theme colours defined in xlsx (Excel) files.  For example,
\code{"accent6"} is the name of a theme colour in Excel, which could resolve to
any RGB colour defined by the author of the file.  Themes are often defined
to comply with corporate standards.
}
\examples{
examples <- system.file("extdata/examples.xlsx", package = "tidyxl")
xlsx_color_theme(examples)
xlsx_colour_theme(examples)
}
