% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transportation.R
\name{primary_secondary_roads}
\alias{primary_secondary_roads}
\title{Download a primary & secondary roads shapefile into R}
\usage{
primary_secondary_roads(state, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code of the state of the county you'd like
to download the roads for. Can also be state name or abbreviation
(case-insensitive).}

\item{year}{the data year (defaults to 2019).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{class}, which can be set to \code{"sf"} (the default) or \code{"sp"} to
request sf or sp class objects, and \code{refresh}, which specifies whether or
not to re-download shapefiles (defaults to \code{FALSE}).}
}
\description{
From the Census Bureau: "Primary roads are generally divided,
limited-access highways within the Federal interstate highway
system or under state management. These highways are distinguished by the presence of interchanges
and are accessible by ramps and may include some toll highways. Secondary roads are main arteries,
 usually in the U.S. highway, state
 highway, or county highway system. These roads have one or more lanes of
 traffic in each direction, may
 or may not be divided, and usually have at-grade intersections with many other roads and driveways.
}
\examples{
\dontrun{
library(tigris)

rds <- primary_secondary_roads()

plot(rds$geometry)

}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2019/TGRSHP2019_TechDoc.pdf}

Other transportation functions: 
\code{\link{address_ranges}()},
\code{\link{primary_roads}()},
\code{\link{rails}()},
\code{\link{roads}()}
}
\concept{transportation functions}
