% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/native.R
\name{native_areas}
\alias{native_areas}
\title{Download an American Indian / Alaska Native / Native Hawaiian Areas shapefile into R.}
\usage{
native_areas(cb = FALSE, year = NULL, ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
file.  Defaults to FALSE (the most detailed TIGER/Line file)}

\item{year}{the data year (defaults to 2020).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{class}, which can be set to \code{"sf"} (the default) or \code{"sp"} to
request sf or sp class objects, and \code{refresh}, which specifies whether or
not to re-download shapefiles (defaults to \code{FALSE}).}
}
\description{
Description from the Census Bureau: "This shapefile contain both legal and statistical
American Indian, Alaska Native, and Native Hawaiian
entities for which the Census Bureau publishes data. The legal entities consist of federally recognized
American Indian reservations and off-reservation trust land areas, state-recognized American Indian
reservations, and Hawaiian home lands (HHLs)." For more information, please see the link provided.
}
\examples{
\dontrun{
library(tigris)
library(ggplot2)
library(ggthemes)

nat <- native_areas(cb = TRUE)

gg <- ggplot()
gg <- gg + geom_sf(data = nat, color="black", fill="white", size=0.25)
gg <- gg + coord_sf(xlim=c(-179.1506, -129.9795),  # alaska
                     ylim=c(51.2097, 71.4410))
gg <- gg + theme_map()
gg
}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/reference/GARM/Ch5GARM.pdf}

Other native/tribal geometries functions: 
\code{\link{alaska_native_regional_corporations}()},
\code{\link{tribal_block_groups}()},
\code{\link{tribal_census_tracts}()},
\code{\link{tribal_subdivisions_national}()}
}
\concept{native/tribal geometries functions}
