% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metro_areas.R
\name{new_england}
\alias{new_england}
\title{Download a New England City and Town Area shapefile into R}
\usage{
new_england(type = "necta", cb = FALSE, year = NULL, ...)
}
\arguments{
\item{type}{Specify whether to download the New England City and Town Areas file (\code{'necta'}, the default),
the combined NECTA file (\code{'combined'}), or the NECTA divisions file (\code{'divisions'}).}

\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
cartographic boundary file.  Defaults to FALSE (the most detailed
TIGER/Line file).  Only available when \code{type = 'necta'}.}

\item{year}{the data year; defaults to 2022}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
From the US Census Bureau (see link for source): "In New England
(Connecticut, Maine, Massachusetts, New Hampshire, Rhode Island,
and Vermont), the OMB has defined an alternative county subdivision
(generally city and town) based definition of CBSAs
known as New England city and town areas (NECTAs). NECTAs are defined using the same criteria as
metropolitan and micropolitan statistical areas and are identified as either metropolitan or micropolitan,
based, respectively, on the presence of either an urbanized area of 50,000 or more inhabitants or an
urban cluster of at least 10,000 and less than 50,000 inhabitants."  Combined NECTAs, or CNECTAs, are two or more
NECTAs that have significant employment interchange, like Combined Statistical Areas;
NECTA divisions are subdivisions of NECTAs.
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.  sp classes should be considered deprecated as of tigris version 2.0, but legacy support is still available.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
\item \code{filter_by} Geometry used to filter the output returned by the function.  Can be an sf object, an object of class \code{bbox}, or a length-4 vector of format \code{c(xmin, ymin, xmax, ymax)} that can be converted to a bbox. Geometries that intersect the input to \code{filter_by} will be returned.
}
}

\examples{
\dontrun{
library(tigris)

ne <- new_england(cb = TRUE)

plot(ne$geometry)

}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2020/TGRSHP2020_TechDoc.pdf}

Other metro area functions: 
\code{\link{combined_statistical_areas}()},
\code{\link{core_based_statistical_areas}()},
\code{\link{metro_divisions}()},
\code{\link{urban_areas}()}
}
\concept{metro area functions}
