
# This R package is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This R package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU Library General
# Public License along with this R package; if not, write to the
# Free Foundation, Inc., 59 Temple Place, Suite 330, Boston,
# MA  02111-1307  USA

# Copyrights (C)
# for this R-port:
#   2007-2008, Yohan Chalabi, GPL
#   Yohan Chalabi <ychalabi@phys.ethz.ch>
#   1999 - 2007, Diethelm Wuertz, GPL
#   Diethelm Wuertz <wuertz@itp.phys.ethz.ch>
#   info@rmetrics.org
#   www.rmetrics.org
# for the code accessed (or partly included) from other R-ports:
#   see R's copyright and license files
# for the code accessed (or partly included) from contributed R-ports
# and other sources
#   see Rmetrics's copyright file


# fCalendar::2A-DaylightSavingTime.R
################################################################################
# FUNCTION:                 DESCRIPOTION:
#  Algiers                   Returns Algiers Daylight Saving Time Rules
#  ...
#  Honolulu                  Returns Honolulu Daylight Saving Time Rules
################################################################################


################################################################################
# The following DST Rules were extracted from tzdata (version tzdata2007k)
# and integrated into R functions.
################################################################################
# This file was auto-generated by .genDaylightSavingTime()
#


"Abidjan" <- function () {
structure(list(Abidjan = c("1901-12-14 20:45:52", "1912-01-01 00:16:08"
), offSet = c(-968L, 0L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"GMT"), numeric = c(-2147397248, -1830383032)), .Names = c("Abidjan", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Accra" <- function () {
structure(list(Accra = c("1901-12-14 20:45:52", "1918-01-01 00:00:52", 
"1936-09-01 00:00:00", "1936-12-30 23:40:00", "1937-09-01 00:00:00", 
"1937-12-30 23:40:00", "1938-09-01 00:00:00", "1938-12-30 23:40:00", 
"1939-09-01 00:00:00", "1939-12-30 23:40:00", "1940-09-01 00:00:00", 
"1940-12-30 23:40:00", "1941-09-01 00:00:00", "1941-12-30 23:40:00", 
"1942-09-01 00:00:00", "1942-12-30 23:40:00"), offSet = c(-52L, 
0L, 1200L, 0L, 1200L, 0L, 1200L, 0L, 1200L, 0L, 1200L, 0L, 1200L, 
0L, 1200L, 0L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "GMT", "GHST", 
"GMT", "GHST", "GMT", "GHST", "GMT", "GHST", "GMT", "GHST", "GMT", 
"GHST", "GMT", "GHST", "GMT"), numeric = c(-2147397248, -1640995148, 
-1051920000, -1041466800, -1020384000, -1009930800, -988848000, 
-978394800, -957312000, -946858800, -925689600, -915236400, -894153600, 
-883700400, -862617600, -852164400)), .Names = c("Accra", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -16L), class = "data.frame")
}

"Addis_Ababa" <- function () {
structure(list(Addis_Ababa = c("1901-12-14 20:45:52", "1936-05-04 21:24:40"
), offSet = c(9320L, 10800L), isdst = c(0L, 0L), TimeZone = c("ADMT", 
"EAT"), numeric = c(-2147397248, -1062210920)), .Names = c("Addis_Ababa", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Algiers" <- function () {
structure(list(Algiers = c("1901-12-14 20:45:52", "1911-03-10 23:50:39", 
"1916-06-14 23:00:00", "1916-10-01 23:00:00", "1917-03-24 23:00:00", 
"1917-10-07 23:00:00", "1918-03-09 23:00:00", "1918-10-06 23:00:00", 
"1919-03-01 23:00:00", "1919-10-05 23:00:00", "1920-02-14 23:00:00", 
"1920-10-23 23:00:00", "1921-03-14 23:00:00", "1921-06-21 23:00:00", 
"1939-09-11 23:00:00", "1939-11-19 00:00:00", "1940-02-25 02:00:00", 
"1944-04-03 01:00:00", "1944-10-08 00:00:00", "1945-04-02 01:00:00", 
"1945-09-15 23:00:00", "1946-10-06 23:00:00", "1956-01-29 00:00:00", 
"1963-04-13 23:00:00", "1971-04-25 23:00:00", "1971-09-26 23:00:00", 
"1977-10-20 23:00:00", "1978-03-24 00:00:00", "1978-09-22 01:00:00", 
"1979-10-25 23:00:00", "1980-04-25 00:00:00", "1980-10-31 01:00:00", 
"1981-05-01 00:00:00"), offSet = c(561L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
7200L, 3600L, 7200L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
7200L, 3600L, 0L, 3600L, 0L, 3600L), isdst = c(0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 
0L, 0L, 0L, 0L, 1L, 0L, 0L, 1L, 0L, 0L, 1L, 0L, 0L), TimeZone = c("PMT", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "CET", "CEST", "CET", 
"CEST", "CET", "WET", "CET", "WET", "WEST", "WET", "CET", "CEST", 
"CET", "WET", "WEST", "WET", "CET"), numeric = c(-2147397248, 
-1855958961, -1689814800, -1680397200, -1665363600, -1648342800, 
-1635123600, -1616893200, -1604278800, -1585443600, -1574038800, 
-1552266000, -1539997200, -1531443600, -956365200, -950486400, 
-942012000, -812502000, -796262400, -781052400, -766630800, -733280400, 
-439430400, -212029200, 41468400, 54774000, 246236400, 259545600, 
275274000, 309740400, 325468800, 341802000, 357523200)), .Names = c("Algiers", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-33L), class = "data.frame")
}

"Asmara" <- function () {
structure(list(Asmara = c("1901-12-14 20:45:52", "1936-05-04 21:24:40"
), offSet = c(9320L, 10800L), isdst = c(0L, 0L), TimeZone = c("ADMT", 
"EAT"), numeric = c(-2147397248, -1062210920)), .Names = c("Asmara", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Bamako" <- function () {
structure(list(Bamako = c("1901-12-14 20:45:52", "1912-01-01 00:32:00", 
"1934-02-26 00:00:00", "1960-06-20 01:00:00"), offSet = c(-1920L, 
0L, -3600L, 0L), isdst = c(0L, 0L, 0L, 0L), TimeZone = c("LMT", 
"GMT", "WAT", "GMT"), numeric = c(-2147397248, -1830382080, -1131235200, 
-300841200)), .Names = c("Bamako", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"Bangui" <- function () {
structure(list(Bangui = c("1901-12-14 20:45:52", "1911-12-31 22:45:40"
), offSet = c(4460L, 3600L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"WAT"), numeric = c(-2147397248, -1830388460)), .Names = c("Bangui", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Banjul" <- function () {
structure(list(Banjul = c("1912-01-01 01:06:36", "1935-01-01 01:06:36", 
"1964-01-01 01:00:00"), offSet = c(-3996L, -3600L, 0L), isdst = c(0L, 
0L, 0L), TimeZone = c("BMT", "WAT", "GMT"), numeric = c(-1830380004, 
-1104533604, -189385200)), .Names = c("Banjul", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -3L), class = "data.frame")
}

"Bissau" <- function () {
structure(list(Bissau = c("1901-12-14 20:45:52", "1911-05-26 01:02:20", 
"1975-01-01 01:00:00"), offSet = c(-3740L, -3600L, 0L), isdst = c(0L, 
0L, 0L), TimeZone = c("LMT", "WAT", "GMT"), numeric = c(-2147397248, 
-1849388260, 157770000)), .Names = c("Bissau", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -3L), class = "data.frame")
}

"Blantyre" <- function () {
structure(list(Blantyre = c("1901-12-14 20:45:52", "1903-02-28 21:40:00"
), offSet = c(8400L, 7200L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"CAT"), numeric = c(-2147397248, -2109291600)), .Names = c("Blantyre", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Brazzaville" <- function () {
structure(list(Brazzaville = c("1901-12-14 20:45:52", "1911-12-31 22:58:52"
), offSet = c(3668L, 3600L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"WAT"), numeric = c(-2147397248, -1830387668)), .Names = c("Brazzaville", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Bujumbura" <- function () {
structure(list(Bujumbura = "1901-12-14 20:45:52", offSet = 7200L, 
    isdst = 0L, TimeZone = "CAT", numeric = -2147397248), .Names = c("Bujumbura", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-1L), class = "data.frame")
}

"Cairo" <- function () {
structure(list(Cairo = c("1901-12-14 20:45:52", "1940-07-14 22:00:00", 
"1940-09-30 21:00:00", "1941-04-14 22:00:00", "1941-09-15 21:00:00", 
"1942-03-31 22:00:00", "1942-10-26 21:00:00", "1943-03-31 22:00:00", 
"1943-10-31 21:00:00", "1944-03-31 22:00:00", "1944-10-31 21:00:00", 
"1945-04-15 22:00:00", "1945-10-31 21:00:00", "1957-05-09 22:00:00", 
"1957-09-30 21:00:00", "1958-04-30 22:00:00", "1958-09-30 21:00:00", 
"1959-04-30 23:00:00", "1959-09-30 00:00:00", "1960-04-30 23:00:00", 
"1960-09-30 00:00:00", "1961-04-30 23:00:00", "1961-09-30 00:00:00", 
"1962-04-30 23:00:00", "1962-09-30 00:00:00", "1963-04-30 23:00:00", 
"1963-09-30 00:00:00", "1964-04-30 23:00:00", "1964-09-30 00:00:00", 
"1965-04-30 23:00:00", "1965-09-30 00:00:00", "1966-04-30 23:00:00", 
"1966-10-01 00:00:00", "1967-04-30 23:00:00", "1967-10-01 00:00:00", 
"1968-04-30 23:00:00", "1968-10-01 00:00:00", "1969-04-30 23:00:00", 
"1969-10-01 00:00:00", "1970-04-30 23:00:00", "1970-10-01 00:00:00", 
"1971-04-30 23:00:00", "1971-10-01 00:00:00", "1972-04-30 23:00:00", 
"1972-10-01 00:00:00", "1973-04-30 23:00:00", "1973-10-01 00:00:00", 
"1974-04-30 23:00:00", "1974-10-01 00:00:00", "1975-04-30 23:00:00", 
"1975-10-01 00:00:00", "1976-04-30 23:00:00", "1976-10-01 00:00:00", 
"1977-04-30 23:00:00", "1977-10-01 00:00:00", "1978-04-30 23:00:00", 
"1978-10-01 00:00:00", "1979-04-30 23:00:00", "1979-10-01 00:00:00", 
"1980-04-30 23:00:00", "1980-10-01 00:00:00", "1981-04-30 23:00:00", 
"1981-10-01 00:00:00", "1982-07-24 23:00:00", "1982-10-01 00:00:00", 
"1983-07-11 23:00:00", "1983-10-01 00:00:00", "1984-04-30 23:00:00", 
"1984-10-01 00:00:00", "1985-04-30 23:00:00", "1985-10-01 00:00:00", 
"1986-04-30 23:00:00", "1986-10-01 00:00:00", "1987-04-30 23:00:00", 
"1987-10-01 00:00:00", "1988-04-30 23:00:00", "1988-10-01 00:00:00", 
"1989-05-05 23:00:00", "1989-10-01 00:00:00", "1990-04-30 23:00:00", 
"1990-10-01 00:00:00", "1991-04-30 23:00:00", "1991-10-01 00:00:00", 
"1992-04-30 23:00:00", "1992-10-01 00:00:00", "1993-04-30 23:00:00", 
"1993-10-01 00:00:00", "1994-04-30 23:00:00", "1994-10-01 00:00:00", 
"1995-04-27 22:00:00", "1995-09-28 21:00:00", "1996-04-25 22:00:00", 
"1996-09-26 21:00:00", "1997-04-24 22:00:00", "1997-09-25 21:00:00", 
"1998-04-23 22:00:00", "1998-09-24 21:00:00", "1999-04-29 22:00:00", 
"1999-09-30 21:00:00", "2000-04-27 22:00:00", "2000-09-28 21:00:00", 
"2001-04-26 22:00:00", "2001-09-27 21:00:00", "2002-04-25 22:00:00", 
"2002-09-26 21:00:00", "2003-04-24 22:00:00", "2003-09-25 21:00:00", 
"2004-04-29 22:00:00", "2004-09-30 21:00:00", "2005-04-28 22:00:00", 
"2005-09-29 21:00:00", "2006-04-27 22:00:00", "2006-09-21 21:00:00", 
"2007-04-26 22:00:00", "2007-09-06 21:00:00", "2008-04-24 22:00:00", 
"2008-08-28 21:00:00", "2009-04-23 22:00:00", "2009-08-27 21:00:00", 
"2010-04-29 22:00:00", "2010-08-26 21:00:00", "2011-04-28 22:00:00", 
"2011-08-25 21:00:00", "2012-04-26 22:00:00", "2012-08-30 21:00:00", 
"2013-04-25 22:00:00", "2013-08-29 21:00:00", "2014-04-24 22:00:00", 
"2014-08-28 21:00:00", "2015-04-23 22:00:00", "2015-08-27 21:00:00", 
"2016-04-28 22:00:00", "2016-08-25 21:00:00", "2017-04-27 22:00:00", 
"2017-08-31 21:00:00", "2018-04-26 22:00:00", "2018-08-30 21:00:00", 
"2019-04-25 22:00:00", "2019-08-29 21:00:00", "2020-04-23 22:00:00", 
"2020-08-27 21:00:00", "2021-04-29 22:00:00", "2021-08-26 21:00:00", 
"2022-04-28 22:00:00", "2022-08-25 21:00:00", "2023-04-27 22:00:00", 
"2023-08-31 21:00:00", "2024-04-25 22:00:00", "2024-08-29 21:00:00", 
"2025-04-24 22:00:00", "2025-08-28 21:00:00", "2026-04-23 22:00:00", 
"2026-08-27 21:00:00", "2027-04-29 22:00:00", "2027-08-26 21:00:00", 
"2028-04-27 22:00:00", "2028-08-31 21:00:00", "2029-04-26 22:00:00", 
"2029-08-30 21:00:00", "2030-04-25 22:00:00", "2030-08-29 21:00:00", 
"2031-04-24 22:00:00", "2031-08-28 21:00:00", "2032-04-29 22:00:00", 
"2032-08-26 21:00:00", "2033-04-28 22:00:00", "2033-08-25 21:00:00", 
"2034-04-27 22:00:00", "2034-08-31 21:00:00", "2035-04-26 22:00:00", 
"2035-08-30 21:00:00", "2036-04-24 22:00:00", "2036-08-28 21:00:00", 
"2037-04-23 22:00:00", "2037-08-27 21:00:00"), offSet = c(7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 0L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"UTC"), numeric = c(-2147397248, -929844000, -923108400, -906170400, 
-892868400, -875844000, -857790000, -844308000, -825822000, -812685600, 
-794199600, -779853600, -762663600, -399088800, -386650800, -368330400, 
-355114800, -336790800, -323654400, -305168400, -292032000, -273632400, 
-260496000, -242096400, -228960000, -210560400, -197424000, -178938000, 
-165801600, -147402000, -134265600, -115866000, -102643200, -84330000, 
-71107200, -52707600, -39484800, -21171600, -7948800, 10364400, 
23587200, 41900400, 55123200, 73522800, 86745600, 105058800, 
118281600, 136594800, 149817600, 168130800, 181353600, 199753200, 
212976000, 231289200, 244512000, 262825200, 276048000, 294361200, 
307584000, 325983600, 339206400, 357519600, 370742400, 396399600, 
402278400, 426812400, 433814400, 452214000, 465436800, 483750000, 
496972800, 515286000, 528508800, 546822000, 560044800, 578444400, 
591667200, 610412400, 623203200, 641516400, 654739200, 673052400, 
686275200, 704674800, 717897600, 736210800, 749433600, 767746800, 
780969600, 799020000, 812322000, 830469600, 843771600, 861919200, 
875221200, 893368800, 906670800, 925423200, 938725200, 956872800, 
970174800, 988322400, 1001624400, 1019772000, 1033074000, 1051221600, 
1064523600, 1083276000, 1096578000, 1114725600, 1128027600, 1146175200, 
1158872400, 1177624800, 1189112400, 1209074400, 1219957200, 1240524000, 
1251406800, 1272578400, 1282856400, 1304028000, 1314306000, 1335477600, 
1346360400, 1366927200, 1377810000, 1398376800, 1409259600, 1429826400, 
1440709200, 1461880800, 1472158800, 1493330400, 1504213200, 1524780000, 
1535662800, 1556229600, 1567112400, 1587679200, 1598562000, 1619733600, 
1630011600, 1651183200, 1661461200, 1682632800, 1693515600, 1714082400, 
1724965200, 1745532000, 1756414800, 1776981600, 1787864400, 1809036000, 
1819314000, 1840485600, 1851368400, 1871935200, 1882818000, 1903384800, 
1914267600, 1934834400, 1945717200, 1966888800, 1977166800, 1998338400, 
2008616400, 2029788000, 2040670800, 2061237600, 2072120400, 2092687200, 
2103570000, 2124136800, 2135019600)), .Names = c("Cairo", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -175L), class = "data.frame")
}

"Casablanca" <- function () {
structure(list(Casablanca = c("1901-12-14 20:45:52", "1913-10-26 00:30:20", 
"1939-09-12 00:00:00", "1939-11-18 23:00:00", "1940-02-25 00:00:00", 
"1945-11-17 23:00:00", "1950-06-11 00:00:00", "1950-10-28 23:00:00", 
"1967-06-03 12:00:00", "1967-09-30 23:00:00", "1974-06-24 00:00:00", 
"1974-08-31 23:00:00", "1976-05-01 00:00:00", "1976-07-31 23:00:00", 
"1977-05-01 00:00:00", "1977-09-27 23:00:00", "1978-06-01 00:00:00", 
"1978-08-03 23:00:00", "1984-03-16 00:00:00", "1985-12-31 23:00:00", 
"2008-06-01 00:00:00", "2008-08-31 23:00:00"), offSet = c(-1820L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L), isdst = c(0L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 0L, 0L, 1L, 0L), TimeZone = c("LMT", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "CET", "WET", "WEST", "WET"
), numeric = c(-2147397248, -1773012580, -956361600, -950490000, 
-942019200, -761187600, -617241600, -605149200, -81432000, -71110800, 
141264000, 147222000, 199756800, 207702000, 231292800, 244249200, 
265507200, 271033200, 448243200, 504918000, 1212278400, 1220223600
)), .Names = c("Casablanca", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -22L), class = "data.frame")
}

"Ceuta" <- function () {
structure(list(Ceuta = c("1901-12-14 20:45:52", "1918-05-06 23:00:00", 
"1918-10-07 22:00:00", "1924-04-16 23:00:00", "1924-10-04 23:00:00", 
"1926-04-17 23:00:00", "1926-10-02 23:00:00", "1927-04-09 23:00:00", 
"1927-10-01 23:00:00", "1928-04-14 23:00:00", "1928-10-06 23:00:00", 
"1967-06-03 12:00:00", "1967-09-30 23:00:00", "1974-06-24 00:00:00", 
"1974-08-31 23:00:00", "1976-05-01 00:00:00", "1976-07-31 23:00:00", 
"1977-05-01 00:00:00", "1977-09-27 23:00:00", "1978-06-01 00:00:00", 
"1978-08-03 23:00:00", "1984-03-16 00:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00", "2031-03-30 01:00:00", 
"2031-10-26 01:00:00", "2032-03-28 01:00:00", "2032-10-31 01:00:00", 
"2033-03-27 01:00:00", "2033-10-30 01:00:00", "2034-03-26 01:00:00", 
"2034-10-29 01:00:00", "2035-03-25 01:00:00", "2035-10-28 01:00:00", 
"2036-03-30 01:00:00", "2036-10-26 01:00:00", "2037-03-29 01:00:00", 
"2037-10-25 01:00:00"), offSet = c(0L, 3600L, 0L, 3600L, 0L, 
3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L), TimeZone = c("WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET"), numeric = c(-2147397248, -1630112400, 
-1616810400, -1442451600, -1427677200, -1379293200, -1364778000, 
-1348448400, -1333328400, -1316394000, -1301274000, -81432000, 
-71110800, 141264000, 147222000, 199756800, 207702000, 231292800, 
244249200, 265507200, 271033200, 448243200, 512528400, 528253200, 
543978000, 559702800, 575427600, 591152400, 606877200, 622602000, 
638326800, 654656400, 670381200, 686106000, 701830800, 717555600, 
733280400, 749005200, 764730000, 780454800, 796179600, 811904400, 
828234000, 846378000, 859683600, 877827600, 891133200, 909277200, 
922582800, 941331600, 954032400, 972781200, 985482000, 1004230800, 
1017536400, 1035680400, 1048986000, 1067130000, 1080435600, 1099184400, 
1111885200, 1130634000, 1143334800, 1162083600, 1174784400, 1193533200, 
1206838800, 1224982800, 1238288400, 1256432400, 1269738000, 1288486800, 
1301187600, 1319936400, 1332637200, 1351386000, 1364691600, 1382835600, 
1396141200, 1414285200, 1427590800, 1445734800, 1459040400, 1477789200, 
1490490000, 1509238800, 1521939600, 1540688400, 1553994000, 1572138000, 
1585443600, 1603587600, 1616893200, 1635642000, 1648342800, 1667091600, 
1679792400, 1698541200, 1711846800, 1729990800, 1743296400, 1761440400, 
1774746000, 1792890000, 1806195600, 1824944400, 1837645200, 1856394000, 
1869094800, 1887843600, 1901149200, 1919293200, 1932598800, 1950742800, 
1964048400, 1982797200, 1995498000, 2014246800, 2026947600, 2045696400, 
2058397200, 2077146000, 2090451600, 2108595600, 2121901200, 2140045200
)), .Names = c("Ceuta", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -126L), class = "data.frame")
}

"Conakry" <- function () {
structure(list(Conakry = c("1901-12-14 20:45:52", "1912-01-01 00:54:52", 
"1934-02-26 00:00:00", "1960-01-01 01:00:00"), offSet = c(-3292L, 
0L, -3600L, 0L), isdst = c(0L, 0L, 0L, 0L), TimeZone = c("LMT", 
"GMT", "WAT", "GMT"), numeric = c(-2147397248, -1830380708, -1131235200, 
-315615600)), .Names = c("Conakry", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"Dakar" <- function () {
structure(list(Dakar = c("1901-12-14 20:45:52", "1912-01-01 01:09:44", 
"1941-06-01 01:00:00"), offSet = c(-4184L, -3600L, 0L), isdst = c(0L, 
0L, 0L), TimeZone = c("LMT", "WAT", "GMT"), numeric = c(-2147397248, 
-1830379816, -902098800)), .Names = c("Dakar", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -3L), class = "data.frame")
}

"Dar_es_Salaam" <- function () {
structure(list(Dar_es_Salaam = c("1901-12-14 20:45:52", "1930-12-31 21:22:52", 
"1947-12-31 21:00:00", "1960-12-31 21:15:15"), offSet = c(9428L, 
10800L, 9885L, 10800L), isdst = c(0L, 0L, 0L, 0L), TimeZone = c("LMT", 
"EAT", "BEAUT", "EAT"), numeric = c(-2147397248, -1230777428, 
-694321200, -284006685)), .Names = c("Dar_es_Salaam", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"Djibouti" <- function () {
structure(list(Djibouti = c("1901-12-14 20:45:52", "1911-06-30 21:07:24"
), offSet = c(10356L, 10800L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"EAT"), numeric = c(-2147397248, -1846291956)), .Names = c("Djibouti", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Douala" <- function () {
structure(list(Douala = c("1901-12-14 20:45:52", "1911-12-31 23:21:12"
), offSet = c(2328L, 3600L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"WAT"), numeric = c(-2147397248, -1830386328)), .Names = c("Douala", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"El_Aaiun" <- function () {
structure(list(El_Aaiun = c("1901-12-14 20:45:52", "1934-01-01 00:52:48", 
"1976-04-14 01:00:00"), offSet = c(-3168L, -3600L, 0L), isdst = c(0L, 
0L, 0L), TimeZone = c("LMT", "WAT", "WET"), numeric = c(-2147397248, 
-1136070432, 198291600)), .Names = c("El_Aaiun", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -3L), class = "data.frame")
}

"Freetown" <- function () {
structure(list(Freetown = c("1901-12-14 20:45:52", "1913-06-01 00:53:00", 
"1935-06-01 01:00:00", "1935-10-01 00:20:00", "1936-06-01 01:00:00", 
"1936-10-01 00:20:00", "1937-06-01 01:00:00", "1937-10-01 00:20:00", 
"1938-06-01 01:00:00", "1938-10-01 00:20:00", "1939-06-01 01:00:00", 
"1939-10-01 00:20:00", "1940-06-01 01:00:00", "1940-10-01 00:20:00", 
"1941-06-01 01:00:00", "1941-10-01 00:20:00", "1942-06-01 01:00:00", 
"1942-10-01 00:20:00", "1957-01-01 01:00:00", "1957-06-01 00:00:00", 
"1957-08-31 23:00:00", "1958-06-01 00:00:00", "1958-08-31 23:00:00", 
"1959-06-01 00:00:00", "1959-08-31 23:00:00", "1960-06-01 00:00:00", 
"1960-08-31 23:00:00", "1961-06-01 00:00:00", "1961-08-31 23:00:00", 
"1962-06-01 00:00:00", "1962-08-31 23:00:00"), offSet = c(-3180L, 
-3600L, -1200L, -3600L, -1200L, -3600L, -1200L, -3600L, -1200L, 
-3600L, -1200L, -3600L, -1200L, -3600L, -1200L, -3600L, -1200L, 
-3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("FMT", "WAT", "SLST", "WAT", 
"SLST", "WAT", "SLST", "WAT", "SLST", "WAT", "SLST", "WAT", "SLST", 
"WAT", "SLST", "WAT", "SLST", "WAT", "WAT", "SLST", "GMT", "SLST", 
"GMT", "SLST", "GMT", "SLST", "GMT", "SLST", "GMT", "SLST", "GMT"
), numeric = c(-2147397248, -1785712020, -1091487600, -1080949200, 
-1059865200, -1049326800, -1028329200, -1017790800, -996793200, 
-986254800, -965257200, -954718800, -933634800, -923096400, -902098800, 
-891560400, -870562800, -860024400, -410223600, -397180800, -389235600, 
-365644800, -357699600, -334108800, -326163600, -302486400, -294541200, 
-270950400, -263005200, -239414400, -231469200)), .Names = c("Freetown", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-31L), class = "data.frame")
}

"Gaborone" <- function () {
structure(list(Gaborone = c("1901-12-14 20:45:52", "1943-09-19 00:00:00", 
"1944-03-18 23:00:00"), offSet = c(7200L, 10800L, 7200L), isdst = c(0L, 
1L, 0L), TimeZone = c("CAT", "CAST", "CAT"), numeric = c(-2147397248, 
-829526400, -813805200)), .Names = c("Gaborone", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -3L), class = "data.frame")
}

"Harare" <- function () {
structure(list(Harare = c("1901-12-14 20:45:52", "1903-02-28 21:55:48"
), offSet = c(7452L, 7200L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"CAT"), numeric = c(-2147397248, -2109290652)), .Names = c("Harare", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Johannesburg" <- function () {
structure(list(Johannesburg = c("1901-12-14 20:45:52", "1903-02-28 22:30:00", 
"1942-09-20 00:00:00", "1943-03-20 23:00:00", "1943-09-19 00:00:00", 
"1944-03-18 23:00:00"), offSet = c(5400L, 7200L, 10800L, 7200L, 
10800L, 7200L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("SAST", 
"SAST", "SAST", "SAST", "SAST", "SAST"), numeric = c(-2147397248, 
-2109288600, -860976000, -845254800, -829526400, -813805200)), .Names = c("Johannesburg", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-6L), class = "data.frame")
}

"Kampala" <- function () {
structure(list(Kampala = c("1901-12-14 20:45:52", "1928-06-30 21:50:20", 
"1929-12-31 21:00:00", "1947-12-31 21:30:00", "1956-12-31 21:15:15"
), offSet = c(7780L, 10800L, 9000L, 9885L, 10800L), isdst = c(0L, 
0L, 0L, 0L, 0L), TimeZone = c("LMT", "EAT", "BEAT", "BEAUT", 
"EAT"), numeric = c(-2147397248, -1309745380, -1262314800, -694319400, 
-410237085)), .Names = c("Kampala", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -5L), class = "data.frame")
}

"Khartoum" <- function () {
structure(list(Khartoum = c("1901-12-14 20:45:52", "1930-12-31 21:49:52", 
"1970-04-30 22:00:00", "1970-10-14 21:00:00", "1971-04-29 22:00:00", 
"1971-10-14 21:00:00", "1972-04-29 22:00:00", "1972-10-14 21:00:00", 
"1973-04-28 22:00:00", "1973-10-14 21:00:00", "1974-04-27 22:00:00", 
"1974-10-14 21:00:00", "1975-04-26 22:00:00", "1975-10-14 21:00:00", 
"1976-04-24 22:00:00", "1976-10-14 21:00:00", "1977-04-23 22:00:00", 
"1977-10-14 21:00:00", "1978-04-29 22:00:00", "1978-10-14 21:00:00", 
"1979-04-28 22:00:00", "1979-10-14 21:00:00", "1980-04-26 22:00:00", 
"1980-10-14 21:00:00", "1981-04-25 22:00:00", "1981-10-14 21:00:00", 
"1982-04-24 22:00:00", "1982-10-14 21:00:00", "1983-04-23 22:00:00", 
"1983-10-14 21:00:00", "1984-04-28 22:00:00", "1984-10-14 21:00:00", 
"1985-04-27 22:00:00", "1985-10-14 21:00:00", "2000-01-15 10:00:00"
), offSet = c(7808L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L), TimeZone = c("LMT", "CAT", "CAST", 
"CAT", "CAST", "CAT", "CAST", "CAT", "CAST", "CAT", "CAST", "CAT", 
"CAST", "CAT", "CAST", "CAT", "CAST", "CAT", "CAST", "CAT", "CAST", 
"CAT", "CAST", "CAT", "CAST", "CAT", "CAST", "CAT", "CAST", "CAT", 
"CAST", "CAT", "CAST", "CAT", "EAT"), numeric = c(-2147397248, 
-1230775808, 10360800, 24786000, 41810400, 56322000, 73432800, 
87944400, 104882400, 119480400, 136332000, 151016400, 167781600, 
182552400, 199231200, 214174800, 230680800, 245710800, 262735200, 
277246800, 294184800, 308782800, 325634400, 340405200, 357084000, 
371941200, 388533600, 403477200, 419983200, 435013200, 452037600, 
466635600, 483487200, 498171600, 947930400)), .Names = c("Khartoum", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-35L), class = "data.frame")
}

"Kigali" <- function () {
structure(list(Kigali = c("1901-12-14 20:45:52", "1935-05-31 21:59:44"
), offSet = c(7216L, 7200L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"CAT"), numeric = c(-2147397248, -1091498416)), .Names = c("Kigali", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Kinshasa" <- function () {
structure(list(Kinshasa = "1901-12-14 20:45:52", offSet = 3600L, 
    isdst = 0L, TimeZone = "WAT", numeric = -2147397248), .Names = c("Kinshasa", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-1L), class = "data.frame")
}

"Lagos" <- function () {
structure(list(Lagos = c("1901-12-14 20:45:52", "1919-08-31 23:46:24"
), offSet = c(816L, 3600L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"WAT"), numeric = c(-2147397248, -1588464816)), .Names = c("Lagos", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Libreville" <- function () {
structure(list(Libreville = c("1901-12-14 20:45:52", "1911-12-31 23:22:12"
), offSet = c(2268L, 3600L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"WAT"), numeric = c(-2147397248, -1830386268)), .Names = c("Libreville", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Lome" <- function () {
structure(list(Lome = "1901-12-14 20:45:52", offSet = 0L, isdst = 0L, 
    TimeZone = "GMT", numeric = -2147397248), .Names = c("Lome", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-1L), class = "data.frame")
}

"Luanda" <- function () {
structure(list(Luanda = c("1901-12-14 20:45:52", "1911-05-25 23:07:56"
), offSet = c(3124L, 3600L), isdst = c(0L, 0L), TimeZone = c("AOT", 
"WAT"), numeric = c(-2147397248, -1849395124)), .Names = c("Luanda", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Lubumbashi" <- function () {
structure(list(Lubumbashi = "1901-12-14 20:45:52", offSet = 7200L, 
    isdst = 0L, TimeZone = "CAT", numeric = -2147397248), .Names = c("Lubumbashi", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-1L), class = "data.frame")
}

"Lusaka" <- function () {
structure(list(Lusaka = c("1901-12-14 20:45:52", "1903-02-28 22:06:52"
), offSet = c(6788L, 7200L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"CAT"), numeric = c(-2147397248, -2109289988)), .Names = c("Lusaka", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Malabo" <- function () {
structure(list(Malabo = c("1901-12-14 20:45:52", "1911-12-31 23:24:52", 
"1963-12-15 00:00:00"), offSet = c(2108L, 0L, 3600L), isdst = c(0L, 
0L, 0L), TimeZone = c("LMT", "GMT", "WAT"), numeric = c(-2147397248, 
-1830386108, -190857600)), .Names = c("Malabo", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -3L), class = "data.frame")
}

"Maputo" <- function () {
structure(list(Maputo = c("1901-12-14 20:45:52", "1903-02-28 21:49:40"
), offSet = c(7820L, 7200L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"CAT"), numeric = c(-2147397248, -2109291020)), .Names = c("Maputo", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Maseru" <- function () {
structure(list(Maseru = c("1901-12-14 20:45:52", "1903-02-28 22:10:00", 
"1943-09-19 00:00:00", "1944-03-18 23:00:00"), offSet = c(6600L, 
7200L, 10800L, 7200L), isdst = c(0L, 0L, 1L, 0L), TimeZone = c("LMT", 
"SAST", "SAST", "SAST"), numeric = c(-2147397248, -2109289800, 
-829526400, -813805200)), .Names = c("Maseru", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"Mbabane" <- function () {
structure(list(Mbabane = c("1901-12-14 20:45:52", "1903-02-28 21:55:36"
), offSet = c(7464L, 7200L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"SAST"), numeric = c(-2147397248, -2109290664)), .Names = c("Mbabane", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Mogadishu" <- function () {
structure(list(Mogadishu = c("1901-12-14 20:45:52", "1930-12-31 21:00:00", 
"1956-12-31 21:30:00"), offSet = c(10800L, 9000L, 10800L), isdst = c(0L, 
0L, 0L), TimeZone = c("EAT", "BEAT", "EAT"), numeric = c(-2147397248, 
-1230778800, -410236200)), .Names = c("Mogadishu", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -3L), class = "data.frame")
}

"Monrovia" <- function () {
structure(list(Monrovia = c("1901-12-14 20:45:52", "1919-03-01 00:43:08", 
"1972-05-01 00:44:30"), offSet = c(-2588L, -2670L, 0L), isdst = c(0L, 
0L, 0L), TimeZone = c("MMT", "LRT", "GMT"), numeric = c(-2147397248, 
-1604359012, 73529070)), .Names = c("Monrovia", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -3L), class = "data.frame")
}

"Nairobi" <- function () {
structure(list(Nairobi = c("1901-12-14 20:45:52", "1928-06-30 21:32:44", 
"1929-12-31 21:00:00", "1939-12-31 21:30:00", "1959-12-31 21:15:15"
), offSet = c(8836L, 10800L, 9000L, 9885L, 10800L), isdst = c(0L, 
0L, 0L, 0L, 0L), TimeZone = c("LMT", "EAT", "BEAT", "BEAUT", 
"EAT"), numeric = c(-2147397248, -1309746436, -1262314800, -946780200, 
-315629085)), .Names = c("Nairobi", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -5L), class = "data.frame")
}

"Ndjamena" <- function () {
structure(list(Ndjamena = c("1901-12-14 20:45:52", "1911-12-31 22:59:48", 
"1979-10-13 23:00:00", "1980-03-07 22:00:00"), offSet = c(3612L, 
3600L, 7200L, 3600L), isdst = c(0L, 0L, 1L, 0L), TimeZone = c("LMT", 
"WAT", "WAST", "WAT"), numeric = c(-2147397248, -1830387612, 
308703600, 321314400)), .Names = c("Ndjamena", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"Niamey" <- function () {
structure(list(Niamey = c("1901-12-14 20:45:52", "1911-12-31 23:51:32", 
"1934-02-26 01:00:00", "1960-01-01 00:00:00"), offSet = c(508L, 
-3600L, 0L, 3600L), isdst = c(0L, 0L, 0L, 0L), TimeZone = c("LMT", 
"WAT", "GMT", "WAT"), numeric = c(-2147397248, -1830384508, -1131231600, 
-315619200)), .Names = c("Niamey", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"Nouakchott" <- function () {
structure(list(Nouakchott = c("1901-12-14 20:45:52", "1912-01-01 01:03:48", 
"1934-02-26 00:00:00", "1960-11-28 01:00:00"), offSet = c(-3828L, 
0L, -3600L, 0L), isdst = c(0L, 0L, 0L, 0L), TimeZone = c("LMT", 
"GMT", "WAT", "GMT"), numeric = c(-2147397248, -1830380172, -1131235200, 
-286930800)), .Names = c("Nouakchott", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"Ouagadougou" <- function () {
structure(list(Ouagadougou = c("1901-12-14 20:45:52", "1912-01-01 00:06:04"
), offSet = c(-364L, 0L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"GMT"), numeric = c(-2147397248, -1830383636)), .Names = c("Ouagadougou", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Porto-Novo" <- function () {
structure(list(`Porto-Novo` = c("1901-12-14 20:45:52", "1911-12-31 23:49:32", 
"1934-02-26 00:00:00"), offSet = c(628L, 0L, 3600L), isdst = c(0L, 
0L, 0L), TimeZone = c("LMT", "GMT", "WAT"), numeric = c(-2147397248, 
-1830384628, -1131235200)), .Names = c("Porto-Novo", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -3L), class = "data.frame")
}

"Sao_Tome" <- function () {
structure(list(Sao_Tome = c("1901-12-14 20:45:52", "1912-01-01 00:36:32"
), offSet = c(-2192L, 0L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"GMT"), numeric = c(-2147397248, -1830381808)), .Names = c("Sao_Tome", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Tripoli" <- function () {
structure(list(Tripoli = c("1901-12-14 20:45:52", "1919-12-31 23:07:16", 
"1951-10-14 01:00:00", "1951-12-31 22:00:00", "1953-10-09 01:00:00", 
"1953-12-31 22:00:00", "1955-09-29 23:00:00", "1955-12-31 22:00:00", 
"1958-12-31 23:00:00", "1981-12-31 22:00:00", "1982-03-31 23:00:00", 
"1982-09-30 22:00:00", "1983-03-31 23:00:00", "1983-09-30 22:00:00", 
"1984-03-31 23:00:00", "1984-09-30 22:00:00", "1985-04-05 23:00:00", 
"1985-09-30 22:00:00", "1986-04-03 23:00:00", "1986-10-02 22:00:00", 
"1987-03-31 23:00:00", "1987-09-30 22:00:00", "1988-03-31 23:00:00", 
"1988-09-30 22:00:00", "1989-03-31 23:00:00", "1989-09-30 22:00:00", 
"1990-05-03 23:00:00", "1996-09-29 22:00:00", "1997-04-03 23:00:00"
), offSet = c(3164L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 0L, 0L, 1L), TimeZone = c("LMT", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "EET", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "EET", "CET", "CEST"), numeric = c(-2147397248, 
-1577926364, -574902000, -568087200, -512175600, -504928800, 
-449888400, -441856800, -347158800, 378684000, 386463600, 402271200, 
417999600, 433807200, 449622000, 465429600, 481590000, 496965600, 
512953200, 528674400, 544230000, 560037600, 575852400, 591660000, 
607388400, 623196000, 641775600, 844034400, 860108400)), .Names = c("Tripoli", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-29L), class = "data.frame")
}

"Tunis" <- function () {
structure(list(Tunis = c("1901-12-14 20:45:52", "1911-03-10 23:50:39", 
"1939-04-15 22:00:00", "1939-11-18 22:00:00", "1940-02-25 22:00:00", 
"1941-10-05 22:00:00", "1942-03-08 23:00:00", "1942-11-02 01:00:00", 
"1943-03-29 01:00:00", "1943-04-17 00:00:00", "1943-04-25 01:00:00", 
"1943-10-04 00:00:00", "1944-04-03 01:00:00", "1944-10-07 22:00:00", 
"1945-04-02 01:00:00", "1945-09-15 22:00:00", "1977-04-29 23:00:00", 
"1977-09-23 23:00:00", "1978-04-30 23:00:00", "1978-09-30 23:00:00", 
"1988-05-31 23:00:00", "1988-09-24 23:00:00", "1989-03-25 23:00:00", 
"1989-09-23 23:00:00", "1990-04-30 23:00:00", "1990-09-29 23:00:00", 
"2005-04-30 23:00:00", "2005-09-30 00:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00", "2037-10-25 01:00:00"
), offSet = c(561L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("PMT", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET"), numeric = c(-2147397248, 
-1855958961, -969242400, -950493600, -941940000, -891136800, 
-877827600, -857257200, -844556400, -842918400, -842223600, -828230400, 
-812502000, -796269600, -781052400, -766634400, 231202800, 243903600, 
262825200, 276044400, 581122800, 591145200, 606870000, 622594800, 
641516400, 654649200, 1114902000, 1128038400, 1143334800, 1162083600, 
1174784400, 1193533200, 1206838800, 1224982800, 1238288400, 1256432400, 
1269738000, 1288486800, 1301187600, 1319936400, 1332637200, 1351386000, 
1364691600, 1382835600, 1396141200, 1414285200, 1427590800, 1445734800, 
1459040400, 1477789200, 1490490000, 1509238800, 1521939600, 1540688400, 
1553994000, 1572138000, 1585443600, 1603587600, 1616893200, 1635642000, 
1648342800, 1667091600, 1679792400, 1698541200, 1711846800, 1729990800, 
1743296400, 1761440400, 1774746000, 1792890000, 1806195600, 1824944400, 
1837645200, 1856394000, 1869094800, 1887843600, 1901149200, 1919293200, 
1932598800, 1950742800, 1964048400, 1982797200, 1995498000, 2014246800, 
2026947600, 2045696400, 2058397200, 2077146000, 2090451600, 2108595600, 
2121901200, 2140045200)), .Names = c("Tunis", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -92L), class = "data.frame")
}

"Windhoek" <- function () {
structure(list(Windhoek = c("1901-12-14 20:45:52", "1903-02-28 22:30:00", 
"1942-09-20 00:00:00", "1990-03-20 22:00:00", "1994-04-02 22:00:00", 
"1994-09-04 01:00:00", "1995-04-02 00:00:00", "1995-09-03 01:00:00", 
"1996-04-07 00:00:00", "1996-09-01 01:00:00", "1997-04-06 00:00:00", 
"1997-09-07 01:00:00", "1998-04-05 00:00:00", "1998-09-06 01:00:00", 
"1999-04-04 00:00:00", "1999-09-05 01:00:00", "2000-04-02 00:00:00", 
"2000-09-03 01:00:00", "2001-04-01 00:00:00", "2001-09-02 01:00:00", 
"2002-04-07 00:00:00", "2002-09-01 01:00:00", "2003-04-06 00:00:00", 
"2003-09-07 01:00:00", "2004-04-04 00:00:00", "2004-09-05 01:00:00", 
"2005-04-03 00:00:00", "2005-09-04 01:00:00", "2006-04-02 00:00:00", 
"2006-09-03 01:00:00", "2007-04-01 00:00:00", "2007-09-02 01:00:00", 
"2008-04-06 00:00:00", "2008-09-07 01:00:00", "2009-04-05 00:00:00", 
"2009-09-06 01:00:00", "2010-04-04 00:00:00", "2010-09-05 01:00:00", 
"2011-04-03 00:00:00", "2011-09-04 01:00:00", "2012-04-01 00:00:00", 
"2012-09-02 01:00:00", "2013-04-07 00:00:00", "2013-09-01 01:00:00", 
"2014-04-06 00:00:00", "2014-09-07 01:00:00", "2015-04-05 00:00:00", 
"2015-09-06 01:00:00", "2016-04-03 00:00:00", "2016-09-04 01:00:00", 
"2017-04-02 00:00:00", "2017-09-03 01:00:00", "2018-04-01 00:00:00", 
"2018-09-02 01:00:00", "2019-04-07 00:00:00", "2019-09-01 01:00:00", 
"2020-04-05 00:00:00", "2020-09-06 01:00:00", "2021-04-04 00:00:00", 
"2021-09-05 01:00:00", "2022-04-03 00:00:00", "2022-09-04 01:00:00", 
"2023-04-02 00:00:00", "2023-09-03 01:00:00", "2024-04-07 00:00:00", 
"2024-09-01 01:00:00", "2025-04-06 00:00:00", "2025-09-07 01:00:00", 
"2026-04-05 00:00:00", "2026-09-06 01:00:00", "2027-04-04 00:00:00", 
"2027-09-05 01:00:00", "2028-04-02 00:00:00", "2028-09-03 01:00:00", 
"2029-04-01 00:00:00", "2029-09-02 01:00:00", "2030-04-07 00:00:00", 
"2030-09-01 01:00:00", "2031-04-06 00:00:00", "2031-09-07 01:00:00", 
"2032-04-04 00:00:00", "2032-09-05 01:00:00", "2033-04-03 00:00:00", 
"2033-09-04 01:00:00", "2034-04-02 00:00:00", "2034-09-03 01:00:00", 
"2035-04-01 00:00:00", "2035-09-02 01:00:00", "2036-04-06 00:00:00", 
"2036-09-07 01:00:00", "2037-04-05 00:00:00", "2037-09-06 01:00:00"
), offSet = c(5400L, 7200L, 10800L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L), isdst = c(0L, 0L, 1L, 0L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L), TimeZone = c("SWAT", "SAST", "SAST", 
"CAT", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", 
"WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", 
"WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", 
"WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", 
"WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", 
"WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", 
"WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", 
"WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", 
"WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST", 
"WAT", "WAST", "WAT", "WAST", "WAT", "WAST", "WAT", "WAST"), 
    numeric = c(-2147397248, -2109288600, -860976000, 637970400, 
    765324000, 778640400, 796780800, 810090000, 828835200, 841539600, 
    860284800, 873594000, 891734400, 905043600, 923184000, 936493200, 
    954633600, 967942800, 986083200, 999392400, 1018137600, 1030842000, 
    1049587200, 1062896400, 1081036800, 1094346000, 1112486400, 
    1125795600, 1143936000, 1157245200, 1175385600, 1188694800, 
    1207440000, 1220749200, 1238889600, 1252198800, 1270339200, 
    1283648400, 1301788800, 1315098000, 1333238400, 1346547600, 
    1365292800, 1377997200, 1396742400, 1410051600, 1428192000, 
    1441501200, 1459641600, 1472950800, 1491091200, 1504400400, 
    1522540800, 1535850000, 1554595200, 1567299600, 1586044800, 
    1599354000, 1617494400, 1630803600, 1648944000, 1662253200, 
    1680393600, 1693702800, 1712448000, 1725152400, 1743897600, 
    1757206800, 1775347200, 1788656400, 1806796800, 1820106000, 
    1838246400, 1851555600, 1869696000, 1883005200, 1901750400, 
    1914454800, 1933200000, 1946509200, 1964649600, 1977958800, 
    1996099200, 2009408400, 2027548800, 2040858000, 2058998400, 
    2072307600, 2091052800, 2104362000, 2122502400, 2135811600
    )), .Names = c("Windhoek", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -92L), class = "data.frame")
}

"Adak" <- function () {
structure(list(Adak = c("1901-12-14 20:45:52", "1945-08-14 23:00:00", 
"1967-04-01 11:00:00", "1969-04-27 13:00:00", "1969-10-26 12:00:00", 
"1970-04-26 13:00:00", "1970-10-25 12:00:00", "1971-04-25 13:00:00", 
"1971-10-31 12:00:00", "1972-04-30 13:00:00", "1972-10-29 12:00:00", 
"1973-04-29 13:00:00", "1973-10-28 12:00:00", "1974-01-06 13:00:00", 
"1974-10-27 12:00:00", "1975-02-23 13:00:00", "1975-10-26 12:00:00", 
"1976-04-25 13:00:00", "1976-10-31 12:00:00", "1977-04-24 13:00:00", 
"1977-10-30 12:00:00", "1978-04-30 13:00:00", "1978-10-29 12:00:00", 
"1979-04-29 13:00:00", "1979-10-28 12:00:00", "1980-04-27 13:00:00", 
"1980-10-26 12:00:00", "1981-04-26 13:00:00", "1981-10-25 12:00:00", 
"1982-04-25 13:00:00", "1982-10-31 12:00:00", "1983-11-30 10:00:00", 
"1984-04-29 12:00:00", "1984-10-28 11:00:00", "1985-04-28 12:00:00", 
"1985-10-27 11:00:00", "1986-04-27 12:00:00", "1986-10-26 11:00:00", 
"1987-04-05 12:00:00", "1987-10-25 11:00:00", "1988-04-03 12:00:00", 
"1988-10-30 11:00:00", "1989-04-02 12:00:00", "1989-10-29 11:00:00", 
"1990-04-01 12:00:00", "1990-10-28 11:00:00", "1991-04-07 12:00:00", 
"1991-10-27 11:00:00", "1992-04-05 12:00:00", "1992-10-25 11:00:00", 
"1993-04-04 12:00:00", "1993-10-31 11:00:00", "1994-04-03 12:00:00", 
"1994-10-30 11:00:00", "1995-04-02 12:00:00", "1995-10-29 11:00:00", 
"1996-04-07 12:00:00", "1996-10-27 11:00:00", "1997-04-06 12:00:00", 
"1997-10-26 11:00:00", "1998-04-05 12:00:00", "1998-10-25 11:00:00", 
"1999-04-04 12:00:00", "1999-10-31 11:00:00", "2000-04-02 12:00:00", 
"2000-10-29 11:00:00", "2001-04-01 12:00:00", "2001-10-28 11:00:00", 
"2002-04-07 12:00:00", "2002-10-27 11:00:00", "2003-04-06 12:00:00", 
"2003-10-26 11:00:00", "2004-04-04 12:00:00", "2004-10-31 11:00:00", 
"2005-04-03 12:00:00", "2005-10-30 11:00:00", "2006-04-02 12:00:00", 
"2006-10-29 11:00:00", "2007-03-11 12:00:00", "2007-11-04 11:00:00", 
"2008-03-09 12:00:00", "2008-11-02 11:00:00", "2009-03-08 12:00:00", 
"2009-11-01 11:00:00", "2010-03-14 12:00:00", "2010-11-07 11:00:00", 
"2011-03-13 12:00:00", "2011-11-06 11:00:00", "2012-03-11 12:00:00", 
"2012-11-04 11:00:00", "2013-03-10 12:00:00", "2013-11-03 11:00:00", 
"2014-03-09 12:00:00", "2014-11-02 11:00:00", "2015-03-08 12:00:00", 
"2015-11-01 11:00:00", "2016-03-13 12:00:00", "2016-11-06 11:00:00", 
"2017-03-12 12:00:00", "2017-11-05 11:00:00", "2018-03-11 12:00:00", 
"2018-11-04 11:00:00", "2019-03-10 12:00:00", "2019-11-03 11:00:00", 
"2020-03-08 12:00:00", "2020-11-01 11:00:00", "2021-03-14 12:00:00", 
"2021-11-07 11:00:00", "2022-03-13 12:00:00", "2022-11-06 11:00:00", 
"2023-03-12 12:00:00", "2023-11-05 11:00:00", "2024-03-10 12:00:00", 
"2024-11-03 11:00:00", "2025-03-09 12:00:00", "2025-11-02 11:00:00", 
"2026-03-08 12:00:00", "2026-11-01 11:00:00", "2027-03-14 12:00:00", 
"2027-11-07 11:00:00", "2028-03-12 12:00:00", "2028-11-05 11:00:00", 
"2029-03-11 12:00:00", "2029-11-04 11:00:00", "2030-03-10 12:00:00", 
"2030-11-03 11:00:00", "2031-03-09 12:00:00", "2031-11-02 11:00:00", 
"2032-03-14 12:00:00", "2032-11-07 11:00:00", "2033-03-13 12:00:00", 
"2033-11-06 11:00:00", "2034-03-12 12:00:00", "2034-11-05 11:00:00", 
"2035-03-11 12:00:00", "2035-11-04 11:00:00", "2036-03-09 12:00:00", 
"2036-11-02 11:00:00", "2037-03-08 12:00:00", "2037-11-01 11:00:00"
), offSet = c(-39600L, -36000L, -39600L, -36000L, -39600L, -36000L, 
-39600L, -36000L, -39600L, -36000L, -39600L, -36000L, -39600L, 
-36000L, -39600L, -36000L, -39600L, -36000L, -39600L, -36000L, 
-39600L, -36000L, -39600L, -36000L, -39600L, -36000L, -39600L, 
-36000L, -39600L, -36000L, -39600L, -36000L, -32400L, -36000L, 
-32400L, -36000L, -32400L, -36000L, -32400L, -36000L, -32400L, 
-36000L, -32400L, -36000L, -32400L, -36000L, -32400L, -36000L, 
-32400L, -36000L, -32400L, -36000L, -32400L, -36000L, -32400L, 
-36000L, -32400L, -36000L, -32400L, -36000L, -32400L, -36000L, 
-32400L, -36000L, -32400L, -36000L, -32400L, -36000L, -32400L, 
-36000L, -32400L, -36000L, -32400L, -36000L, -32400L, -36000L, 
-32400L, -36000L, -32400L, -36000L, -32400L, -36000L, -32400L, 
-36000L, -32400L, -36000L, -32400L, -36000L, -32400L, -36000L, 
-32400L, -36000L, -32400L, -36000L, -32400L, -36000L, -32400L, 
-36000L, -32400L, -36000L, -32400L, -36000L, -32400L, -36000L, 
-32400L, -36000L, -32400L, -36000L, -32400L, -36000L, -32400L, 
-36000L, -32400L, -36000L, -32400L, -36000L, -32400L, -36000L, 
-32400L, -36000L, -32400L, -36000L, -32400L, -36000L, -32400L, 
-36000L, -32400L, -36000L, -32400L, -36000L, -32400L, -36000L, 
-32400L, -36000L, -32400L, -36000L, -32400L, -36000L, -32400L, 
-36000L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L), TimeZone = c("NST", "NPT", "BST", "BDT", "BST", "BDT", "BST", 
"BDT", "BST", "BDT", "BST", "BDT", "BST", "BDT", "BST", "BDT", 
"BST", "BDT", "BST", "BDT", "BST", "BDT", "BST", "BDT", "BST", 
"BDT", "BST", "BDT", "BST", "BDT", "BST", "HAST", "HADT", "HAST", 
"HADT", "HAST", "HADT", "HAST", "HADT", "HAST", "HADT", "HAST", 
"HADT", "HAST", "HADT", "HAST", "HADT", "HAST", "HADT", "HAST", 
"HADT", "HAST", "HADT", "HAST", "HADT", "HAST", "HADT", "HAST", 
"HADT", "HAST", "HADT", "HAST", "HADT", "HAST", "HADT", "HAST", 
"HADT", "HAST", "HADT", "HAST", "HADT", "HAST", "HADT", "HAST", 
"HADT", "HAST", "HADT", "HAST", "HADT", "HAST", "HADT", "HAST", 
"HADT", "HAST", "HADT", "HAST", "HADT", "HAST", "HADT", "HAST", 
"HADT", "HAST", "HADT", "HAST", "HADT", "HAST", "HADT", "HAST", 
"HADT", "HAST", "HADT", "HAST", "HADT", "HAST", "HADT", "HAST", 
"HADT", "HAST", "HADT", "HAST", "HADT", "HAST", "HADT", "HAST", 
"HADT", "HAST", "HADT", "HAST", "HADT", "HAST", "HADT", "HAST", 
"HADT", "HAST", "HADT", "HAST", "HADT", "HAST", "HADT", "HAST", 
"HADT", "HAST", "HADT", "HAST", "HADT", "HAST", "HADT", "HAST", 
"HADT", "HAST"), numeric = c(-2147397248, -769395600, -86878800, 
-21466800, -5745600, 9982800, 25704000, 41432400, 57758400, 73486800, 
89208000, 104936400, 120657600, 126709200, 152107200, 162392400, 
183556800, 199285200, 215611200, 230734800, 247060800, 262789200, 
278510400, 294238800, 309960000, 325688400, 341409600, 357138000, 
372859200, 388587600, 404913600, 439034400, 452088000, 467809200, 
483537600, 499258800, 514987200, 530708400, 544622400, 562158000, 
576072000, 594212400, 607521600, 625662000, 638971200, 657111600, 
671025600, 688561200, 702475200, 720010800, 733924800, 752065200, 
765374400, 783514800, 796824000, 814964400, 828878400, 846414000, 
860328000, 877863600, 891777600, 909313200, 923227200, 941367600, 
954676800, 972817200, 986126400, 1004266800, 1018180800, 1035716400, 
1049630400, 1067166000, 1081080000, 1099220400, 1112529600, 1130670000, 
1143979200, 1162119600, 1173614400, 1194174000, 1205064000, 1225623600, 
1236513600, 1257073200, 1268568000, 1289127600, 1300017600, 1320577200, 
1331467200, 1352026800, 1362916800, 1383476400, 1394366400, 1414926000, 
1425816000, 1446375600, 1457870400, 1478430000, 1489320000, 1509879600, 
1520769600, 1541329200, 1552219200, 1572778800, 1583668800, 1604228400, 
1615723200, 1636282800, 1647172800, 1667732400, 1678622400, 1699182000, 
1710072000, 1730631600, 1741521600, 1762081200, 1772971200, 1793530800, 
1805025600, 1825585200, 1836475200, 1857034800, 1867924800, 1888484400, 
1899374400, 1919934000, 1930824000, 1951383600, 1962878400, 1983438000, 
1994328000, 2014887600, 2025777600, 2046337200, 2057227200, 2077786800, 
2088676800, 2109236400, 2120126400, 2140686000)), .Names = c("Adak", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-140L), class = "data.frame")
}

"Anchorage" <- function () {
structure(list(Anchorage = c("1901-12-14 20:45:52", "1945-08-14 23:00:00", 
"1967-04-01 10:00:00", "1969-04-27 12:00:00", "1969-10-26 11:00:00", 
"1970-04-26 12:00:00", "1970-10-25 11:00:00", "1971-04-25 12:00:00", 
"1971-10-31 11:00:00", "1972-04-30 12:00:00", "1972-10-29 11:00:00", 
"1973-04-29 12:00:00", "1973-10-28 11:00:00", "1974-01-06 12:00:00", 
"1974-10-27 11:00:00", "1975-02-23 12:00:00", "1975-10-26 11:00:00", 
"1976-04-25 12:00:00", "1976-10-31 11:00:00", "1977-04-24 12:00:00", 
"1977-10-30 11:00:00", "1978-04-30 12:00:00", "1978-10-29 11:00:00", 
"1979-04-29 12:00:00", "1979-10-28 11:00:00", "1980-04-27 12:00:00", 
"1980-10-26 11:00:00", "1981-04-26 12:00:00", "1981-10-25 11:00:00", 
"1982-04-25 12:00:00", "1982-10-31 11:00:00", "1983-11-30 09:00:00", 
"1984-04-29 11:00:00", "1984-10-28 10:00:00", "1985-04-28 11:00:00", 
"1985-10-27 10:00:00", "1986-04-27 11:00:00", "1986-10-26 10:00:00", 
"1987-04-05 11:00:00", "1987-10-25 10:00:00", "1988-04-03 11:00:00", 
"1988-10-30 10:00:00", "1989-04-02 11:00:00", "1989-10-29 10:00:00", 
"1990-04-01 11:00:00", "1990-10-28 10:00:00", "1991-04-07 11:00:00", 
"1991-10-27 10:00:00", "1992-04-05 11:00:00", "1992-10-25 10:00:00", 
"1993-04-04 11:00:00", "1993-10-31 10:00:00", "1994-04-03 11:00:00", 
"1994-10-30 10:00:00", "1995-04-02 11:00:00", "1995-10-29 10:00:00", 
"1996-04-07 11:00:00", "1996-10-27 10:00:00", "1997-04-06 11:00:00", 
"1997-10-26 10:00:00", "1998-04-05 11:00:00", "1998-10-25 10:00:00", 
"1999-04-04 11:00:00", "1999-10-31 10:00:00", "2000-04-02 11:00:00", 
"2000-10-29 10:00:00", "2001-04-01 11:00:00", "2001-10-28 10:00:00", 
"2002-04-07 11:00:00", "2002-10-27 10:00:00", "2003-04-06 11:00:00", 
"2003-10-26 10:00:00", "2004-04-04 11:00:00", "2004-10-31 10:00:00", 
"2005-04-03 11:00:00", "2005-10-30 10:00:00", "2006-04-02 11:00:00", 
"2006-10-29 10:00:00", "2007-03-11 11:00:00", "2007-11-04 10:00:00", 
"2008-03-09 11:00:00", "2008-11-02 10:00:00", "2009-03-08 11:00:00", 
"2009-11-01 10:00:00", "2010-03-14 11:00:00", "2010-11-07 10:00:00", 
"2011-03-13 11:00:00", "2011-11-06 10:00:00", "2012-03-11 11:00:00", 
"2012-11-04 10:00:00", "2013-03-10 11:00:00", "2013-11-03 10:00:00", 
"2014-03-09 11:00:00", "2014-11-02 10:00:00", "2015-03-08 11:00:00", 
"2015-11-01 10:00:00", "2016-03-13 11:00:00", "2016-11-06 10:00:00", 
"2017-03-12 11:00:00", "2017-11-05 10:00:00", "2018-03-11 11:00:00", 
"2018-11-04 10:00:00", "2019-03-10 11:00:00", "2019-11-03 10:00:00", 
"2020-03-08 11:00:00", "2020-11-01 10:00:00", "2021-03-14 11:00:00", 
"2021-11-07 10:00:00", "2022-03-13 11:00:00", "2022-11-06 10:00:00", 
"2023-03-12 11:00:00", "2023-11-05 10:00:00", "2024-03-10 11:00:00", 
"2024-11-03 10:00:00", "2025-03-09 11:00:00", "2025-11-02 10:00:00", 
"2026-03-08 11:00:00", "2026-11-01 10:00:00", "2027-03-14 11:00:00", 
"2027-11-07 10:00:00", "2028-03-12 11:00:00", "2028-11-05 10:00:00", 
"2029-03-11 11:00:00", "2029-11-04 10:00:00", "2030-03-10 11:00:00", 
"2030-11-03 10:00:00", "2031-03-09 11:00:00", "2031-11-02 10:00:00", 
"2032-03-14 11:00:00", "2032-11-07 10:00:00", "2033-03-13 11:00:00", 
"2033-11-06 10:00:00", "2034-03-12 11:00:00", "2034-11-05 10:00:00", 
"2035-03-11 11:00:00", "2035-11-04 10:00:00", "2036-03-09 11:00:00", 
"2036-11-02 10:00:00", "2037-03-08 11:00:00", "2037-11-01 10:00:00"
), offSet = c(-36000L, -32400L, -36000L, -32400L, -36000L, -32400L, 
-36000L, -32400L, -36000L, -32400L, -36000L, -32400L, -36000L, 
-32400L, -36000L, -32400L, -36000L, -32400L, -36000L, -32400L, 
-36000L, -32400L, -36000L, -32400L, -36000L, -32400L, -36000L, 
-32400L, -36000L, -32400L, -36000L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L), TimeZone = c("CAT", "CAPT", "AHST", "AHDT", "AHST", "AHDT", 
"AHST", "AHDT", "AHST", "AHDT", "AHST", "AHDT", "AHST", "AHDT", 
"AHST", "AHDT", "AHST", "AHDT", "AHST", "AHDT", "AHST", "AHDT", 
"AHST", "AHDT", "AHST", "AHDT", "AHST", "AHDT", "AHST", "AHDT", 
"AHST", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST"), numeric = c(-2147397248, 
-769395600, -86882400, -21470400, -5749200, 9979200, 25700400, 
41428800, 57754800, 73483200, 89204400, 104932800, 120654000, 
126705600, 152103600, 162388800, 183553200, 199281600, 215607600, 
230731200, 247057200, 262785600, 278506800, 294235200, 309956400, 
325684800, 341406000, 357134400, 372855600, 388584000, 404910000, 
439030800, 452084400, 467805600, 483534000, 499255200, 514983600, 
530704800, 544618800, 562154400, 576068400, 594208800, 607518000, 
625658400, 638967600, 657108000, 671022000, 688557600, 702471600, 
720007200, 733921200, 752061600, 765370800, 783511200, 796820400, 
814960800, 828874800, 846410400, 860324400, 877860000, 891774000, 
909309600, 923223600, 941364000, 954673200, 972813600, 986122800, 
1004263200, 1018177200, 1035712800, 1049626800, 1067162400, 1081076400, 
1099216800, 1112526000, 1130666400, 1143975600, 1162116000, 1173610800, 
1194170400, 1205060400, 1225620000, 1236510000, 1257069600, 1268564400, 
1289124000, 1300014000, 1320573600, 1331463600, 1352023200, 1362913200, 
1383472800, 1394362800, 1414922400, 1425812400, 1446372000, 1457866800, 
1478426400, 1489316400, 1509876000, 1520766000, 1541325600, 1552215600, 
1572775200, 1583665200, 1604224800, 1615719600, 1636279200, 1647169200, 
1667728800, 1678618800, 1699178400, 1710068400, 1730628000, 1741518000, 
1762077600, 1772967600, 1793527200, 1805022000, 1825581600, 1836471600, 
1857031200, 1867921200, 1888480800, 1899370800, 1919930400, 1930820400, 
1951380000, 1962874800, 1983434400, 1994324400, 2014884000, 2025774000, 
2046333600, 2057223600, 2077783200, 2088673200, 2109232800, 2120122800, 
2140682400)), .Names = c("Anchorage", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -140L), class = "data.frame")
}

"Anguilla" <- function () {
structure(list(Anguilla = c("1901-12-14 20:45:52", "1912-03-02 04:12:16"
), offSet = c(-15136L, -14400L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"AST"), numeric = c(-2147397248, -1825098464)), .Names = c("Anguilla", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Antigua" <- function () {
structure(list(Antigua = c("1901-12-14 20:45:52", "1912-03-02 04:07:12", 
"1951-01-01 05:00:00"), offSet = c(-14832L, -18000L, -14400L), 
    isdst = c(0L, 0L, 0L), TimeZone = c("LMT", "EST", "AST"), 
    numeric = c(-2147397248, -1825098768, -599598000)), .Names = c("Antigua", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-3L), class = "data.frame")
}

"Araguaina" <- function () {
structure(list(Araguaina = c("1901-12-14 20:45:52", "1914-01-01 03:12:48", 
"1931-10-03 14:00:00", "1932-04-01 02:00:00", "1932-10-03 03:00:00", 
"1933-04-01 02:00:00", "1949-12-01 03:00:00", "1950-04-16 03:00:00", 
"1950-12-01 03:00:00", "1951-04-01 02:00:00", "1951-12-01 03:00:00", 
"1952-04-01 02:00:00", "1952-12-01 03:00:00", "1953-03-01 02:00:00", 
"1963-12-09 03:00:00", "1964-03-01 02:00:00", "1965-01-31 03:00:00", 
"1965-03-31 02:00:00", "1965-12-01 03:00:00", "1966-03-01 02:00:00", 
"1966-11-01 03:00:00", "1967-03-01 02:00:00", "1967-11-01 03:00:00", 
"1968-03-01 02:00:00", "1985-11-02 03:00:00", "1986-03-15 02:00:00", 
"1986-10-25 03:00:00", "1987-02-14 02:00:00", "1987-10-25 03:00:00", 
"1988-02-07 02:00:00", "1988-10-16 03:00:00", "1989-01-29 02:00:00", 
"1989-10-15 03:00:00", "1990-02-11 02:00:00", "1995-10-15 03:00:00", 
"1996-02-11 02:00:00", "1996-10-06 03:00:00", "1997-02-16 02:00:00", 
"1997-10-06 03:00:00", "1998-03-01 02:00:00", "1998-10-11 03:00:00", 
"1999-02-21 02:00:00", "1999-10-03 03:00:00", "2000-02-27 02:00:00", 
"2000-10-08 03:00:00", "2001-02-18 02:00:00", "2001-10-14 03:00:00", 
"2002-02-17 02:00:00", "2002-11-03 03:00:00", "2003-02-16 02:00:00"
), offSet = c(-11568L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L), isdst = c(0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT"), numeric = c(-2147397248, -1767214032, 
-1206957600, -1191362400, -1175374800, -1159826400, -633819600, 
-622069200, -602283600, -591832800, -570747600, -560210400, -539125200, 
-531352800, -191365200, -184197600, -155163600, -150069600, -128898000, 
-121125600, -99954000, -89589600, -68418000, -57967200, 499748400, 
511236000, 530593200, 540266400, 562129200, 571197600, 592974000, 
602042400, 624423600, 634701600, 813726000, 824004000, 844570800, 
856058400, 876106800, 888717600, 908074800, 919562400, 938919600, 
951616800, 970974000, 982461600, 1003028400, 1013911200, 1036292400, 
1045360800)), .Names = c("Araguaina", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -50L), class = "data.frame")
}

"Buenos_Aires" <- function () {
structure(list(Buenos_Aires = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-21 03:00:00", 
"1991-03-03 02:00:00", "1991-10-20 03:00:00", "1992-03-01 02:00:00", 
"1992-10-18 03:00:00", "2000-03-03 03:00:00", "2007-12-30 03:00:00", 
"2008-03-16 02:00:00", "2008-10-19 03:00:00", "2009-03-15 02:00:00", 
"2009-10-18 03:00:00", "2010-03-21 02:00:00", "2010-10-17 03:00:00", 
"2011-03-20 02:00:00", "2011-10-16 03:00:00", "2012-03-18 02:00:00", 
"2012-10-21 03:00:00", "2013-03-17 02:00:00", "2013-10-20 03:00:00", 
"2014-03-16 02:00:00", "2014-10-19 03:00:00", "2015-03-15 02:00:00", 
"2015-10-18 03:00:00", "2016-03-20 02:00:00", "2016-10-16 03:00:00", 
"2017-03-19 02:00:00", "2017-10-15 03:00:00", "2018-03-18 02:00:00", 
"2018-10-21 03:00:00", "2019-03-17 02:00:00", "2019-10-20 03:00:00", 
"2020-03-15 02:00:00", "2020-10-18 03:00:00", "2021-03-21 02:00:00", 
"2021-10-17 03:00:00", "2022-03-20 02:00:00", "2022-10-16 03:00:00", 
"2023-03-19 02:00:00", "2023-10-15 03:00:00", "2024-03-17 02:00:00", 
"2024-10-20 03:00:00", "2025-03-16 02:00:00", "2025-10-19 03:00:00", 
"2026-03-15 02:00:00", "2026-10-18 03:00:00", "2027-03-21 02:00:00", 
"2027-10-17 03:00:00", "2028-03-19 02:00:00", "2028-10-15 03:00:00", 
"2029-03-18 02:00:00", "2029-10-21 03:00:00", "2030-03-17 02:00:00", 
"2030-10-20 03:00:00", "2031-03-16 02:00:00", "2031-10-19 03:00:00", 
"2032-03-21 02:00:00", "2032-10-17 03:00:00", "2033-03-20 02:00:00", 
"2033-10-16 03:00:00", "2034-03-19 02:00:00", "2034-10-15 03:00:00", 
"2035-03-18 02:00:00", "2035-10-21 03:00:00", "2036-03-16 02:00:00", 
"2036-10-19 03:00:00", "2037-03-15 02:00:00", "2037-10-18 03:00:00"
), offSet = c(-15408L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L), TimeZone = c("CMT", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST"), numeric = c(-2147397248, 
-1567453392, -1233432000, -1222981200, -1205956800, -1194037200, 
-1172865600, -1162501200, -1141329600, -1130965200, -1109793600, 
-1099429200, -1078257600, -1067806800, -1046635200, -1036270800, 
-1015099200, -1004734800, -983563200, -973198800, -952027200, 
-941576400, -931032000, -900882000, -890337600, -833749200, -827265600, 
-752274000, -733780800, -197326800, -190843200, -184194000, -164491200, 
-152658000, -132955200, -121122000, -101419200, -86821200, -71092800, 
-54766800, -39038400, -23317200, -7588800, 128142000, 136605600, 
596948400, 605066400, 624423600, 636516000, 656478000, 667965600, 
687927600, 699415200, 719377200, 952052400, 1198983600, 1205632800, 
1224385200, 1237082400, 1255834800, 1269136800, 1287284400, 1300586400, 
1318734000, 1332036000, 1350788400, 1363485600, 1382238000, 1394935200, 
1413687600, 1426384800, 1445137200, 1458439200, 1476586800, 1489888800, 
1508036400, 1521338400, 1540090800, 1552788000, 1571540400, 1584237600, 
1602990000, 1616292000, 1634439600, 1647741600, 1665889200, 1679191200, 
1697338800, 1710640800, 1729393200, 1742090400, 1760842800, 1773540000, 
1792292400, 1805594400, 1823742000, 1837044000, 1855191600, 1868493600, 
1887246000, 1899943200, 1918695600, 1931392800, 1950145200, 1963447200, 
1981594800, 1994896800, 2013044400, 2026346400, 2044494000, 2057796000, 
2076548400, 2089245600, 2107998000, 2120695200, 2139447600)), .Names = c("Buenos_Aires", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-116L), class = "data.frame")
}

"Catamarca" <- function () {
structure(list(Catamarca = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-21 03:00:00", 
"1991-03-03 02:00:00", "1991-10-20 04:00:00", "1992-03-01 02:00:00", 
"1992-10-18 03:00:00", "2000-03-03 03:00:00", "2004-06-01 03:00:00", 
"2004-06-20 04:00:00", "2007-12-30 03:00:00", "2008-03-16 02:00:00"
), offSet = c(-15408L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -14400L, -7200L, -10800L, -7200L, -10800L, -14400L, -10800L, 
-7200L, -10800L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 0L, 
1L, 0L), TimeZone = c("CMT", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "WART", 
"ARST", "ART", "ARST", "ART", "WART", "ART", "ARST", "ART"), 
    numeric = c(-2147397248, -1567453392, -1233432000, -1222981200, 
    -1205956800, -1194037200, -1172865600, -1162501200, -1141329600, 
    -1130965200, -1109793600, -1099429200, -1078257600, -1067806800, 
    -1046635200, -1036270800, -1015099200, -1004734800, -983563200, 
    -973198800, -952027200, -941576400, -931032000, -900882000, 
    -890337600, -833749200, -827265600, -752274000, -733780800, 
    -197326800, -190843200, -184194000, -164491200, -152658000, 
    -132955200, -121122000, -101419200, -86821200, -71092800, 
    -54766800, -39038400, -23317200, -7588800, 128142000, 136605600, 
    596948400, 605066400, 624423600, 636516000, 656478000, 667965600, 
    687931200, 699415200, 719377200, 952052400, 1086058800, 1087704000, 
    1198983600, 1205632800)), .Names = c("Catamarca", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -59L), class = "data.frame")
}

"Cordoba" <- function () {
structure(list(Cordoba = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-21 03:00:00", 
"1991-03-03 02:00:00", "1991-10-20 04:00:00", "1992-03-01 02:00:00", 
"1992-10-18 03:00:00", "2000-03-03 03:00:00", "2007-12-30 03:00:00", 
"2008-03-16 02:00:00", "2008-10-19 03:00:00", "2009-03-15 02:00:00", 
"2009-10-18 03:00:00", "2010-03-21 02:00:00", "2010-10-17 03:00:00", 
"2011-03-20 02:00:00", "2011-10-16 03:00:00", "2012-03-18 02:00:00", 
"2012-10-21 03:00:00", "2013-03-17 02:00:00", "2013-10-20 03:00:00", 
"2014-03-16 02:00:00", "2014-10-19 03:00:00", "2015-03-15 02:00:00", 
"2015-10-18 03:00:00", "2016-03-20 02:00:00", "2016-10-16 03:00:00", 
"2017-03-19 02:00:00", "2017-10-15 03:00:00", "2018-03-18 02:00:00", 
"2018-10-21 03:00:00", "2019-03-17 02:00:00", "2019-10-20 03:00:00", 
"2020-03-15 02:00:00", "2020-10-18 03:00:00", "2021-03-21 02:00:00", 
"2021-10-17 03:00:00", "2022-03-20 02:00:00", "2022-10-16 03:00:00", 
"2023-03-19 02:00:00", "2023-10-15 03:00:00", "2024-03-17 02:00:00", 
"2024-10-20 03:00:00", "2025-03-16 02:00:00", "2025-10-19 03:00:00", 
"2026-03-15 02:00:00", "2026-10-18 03:00:00", "2027-03-21 02:00:00", 
"2027-10-17 03:00:00", "2028-03-19 02:00:00", "2028-10-15 03:00:00", 
"2029-03-18 02:00:00", "2029-10-21 03:00:00", "2030-03-17 02:00:00", 
"2030-10-20 03:00:00", "2031-03-16 02:00:00", "2031-10-19 03:00:00", 
"2032-03-21 02:00:00", "2032-10-17 03:00:00", "2033-03-20 02:00:00", 
"2033-10-16 03:00:00", "2034-03-19 02:00:00", "2034-10-15 03:00:00", 
"2035-03-18 02:00:00", "2035-10-21 03:00:00", "2036-03-16 02:00:00", 
"2036-10-19 03:00:00", "2037-03-15 02:00:00", "2037-10-18 03:00:00"
), offSet = c(-15408L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -14400L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L), TimeZone = c("CMT", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "WART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST"), 
    numeric = c(-2147397248, -1567453392, -1233432000, -1222981200, 
    -1205956800, -1194037200, -1172865600, -1162501200, -1141329600, 
    -1130965200, -1109793600, -1099429200, -1078257600, -1067806800, 
    -1046635200, -1036270800, -1015099200, -1004734800, -983563200, 
    -973198800, -952027200, -941576400, -931032000, -900882000, 
    -890337600, -833749200, -827265600, -752274000, -733780800, 
    -197326800, -190843200, -184194000, -164491200, -152658000, 
    -132955200, -121122000, -101419200, -86821200, -71092800, 
    -54766800, -39038400, -23317200, -7588800, 128142000, 136605600, 
    596948400, 605066400, 624423600, 636516000, 656478000, 667965600, 
    687931200, 699415200, 719377200, 952052400, 1198983600, 1205632800, 
    1224385200, 1237082400, 1255834800, 1269136800, 1287284400, 
    1300586400, 1318734000, 1332036000, 1350788400, 1363485600, 
    1382238000, 1394935200, 1413687600, 1426384800, 1445137200, 
    1458439200, 1476586800, 1489888800, 1508036400, 1521338400, 
    1540090800, 1552788000, 1571540400, 1584237600, 1602990000, 
    1616292000, 1634439600, 1647741600, 1665889200, 1679191200, 
    1697338800, 1710640800, 1729393200, 1742090400, 1760842800, 
    1773540000, 1792292400, 1805594400, 1823742000, 1837044000, 
    1855191600, 1868493600, 1887246000, 1899943200, 1918695600, 
    1931392800, 1950145200, 1963447200, 1981594800, 1994896800, 
    2013044400, 2026346400, 2044494000, 2057796000, 2076548400, 
    2089245600, 2107998000, 2120695200, 2139447600)), .Names = c("Cordoba", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-116L), class = "data.frame")
}

"Jujuy" <- function () {
structure(list(Jujuy = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-28 04:00:00", 
"1991-03-17 03:00:00", "1991-10-06 04:00:00", "1992-03-01 02:00:00", 
"1992-10-18 03:00:00", "2000-03-03 03:00:00", "2007-12-30 03:00:00", 
"2008-03-16 02:00:00"), offSet = c(-15408L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -14400L, -10800L, -14400L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L), isdst = c(0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L), TimeZone = c("CMT", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ART", "ARST", "ART", "ARST", "ART", "ARST", "WART", 
"WARST", "WART", "ARST", "ART", "ARST", "ART", "ARST", "ART"), 
    numeric = c(-2147397248, -1567453392, -1233432000, -1222981200, 
    -1205956800, -1194037200, -1172865600, -1162501200, -1141329600, 
    -1130965200, -1109793600, -1099429200, -1078257600, -1067806800, 
    -1046635200, -1036270800, -1015099200, -1004734800, -983563200, 
    -973198800, -952027200, -941576400, -931032000, -900882000, 
    -890337600, -833749200, -827265600, -752274000, -733780800, 
    -197326800, -190843200, -184194000, -164491200, -152658000, 
    -132955200, -121122000, -101419200, -86821200, -71092800, 
    -54766800, -39038400, -23317200, -7588800, 128142000, 136605600, 
    596948400, 605066400, 624423600, 636516000, 657086400, 669178800, 
    686721600, 699415200, 719377200, 952052400, 1198983600, 1205632800
    )), .Names = c("Jujuy", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -57L), class = "data.frame")
}

"La_Rioja" <- function () {
structure(list(La_Rioja = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-21 03:00:00", 
"1991-03-01 02:00:00", "1991-05-07 04:00:00", "1991-10-20 03:00:00", 
"1992-03-01 02:00:00", "1992-10-18 03:00:00", "2000-03-03 03:00:00", 
"2004-06-01 03:00:00", "2004-06-20 04:00:00", "2007-12-30 03:00:00", 
"2008-03-16 02:00:00"), offSet = c(-15408L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -14400L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -14400L, -10800L, -7200L, -10800L), 
    isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
    1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
    0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
    0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 0L, 
    0L, 1L, 0L), TimeZone = c("CMT", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ART", "ARST", "ART", 
    "ARST", "ART", "ARST", "ART", "ARST", "WART", "ART", "ARST", 
    "ART", "ARST", "ART", "WART", "ART", "ARST", "ART"), numeric = c(-2147397248, 
    -1567453392, -1233432000, -1222981200, -1205956800, -1194037200, 
    -1172865600, -1162501200, -1141329600, -1130965200, -1109793600, 
    -1099429200, -1078257600, -1067806800, -1046635200, -1036270800, 
    -1015099200, -1004734800, -983563200, -973198800, -952027200, 
    -941576400, -931032000, -900882000, -890337600, -833749200, 
    -827265600, -752274000, -733780800, -197326800, -190843200, 
    -184194000, -164491200, -152658000, -132955200, -121122000, 
    -101419200, -86821200, -71092800, -54766800, -39038400, -23317200, 
    -7588800, 128142000, 136605600, 596948400, 605066400, 624423600, 
    636516000, 656478000, 667792800, 673588800, 687927600, 699415200, 
    719377200, 952052400, 1086058800, 1087704000, 1198983600, 
    1205632800)), .Names = c("La_Rioja", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -60L), class = "data.frame")
}

"Mendoza" <- function () {
structure(list(Mendoza = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-15 04:00:00", 
"1991-03-01 03:00:00", "1991-10-15 04:00:00", "1992-03-01 03:00:00", 
"1992-10-18 04:00:00", "2000-03-03 03:00:00", "2004-05-23 03:00:00", 
"2004-09-26 04:00:00", "2007-12-30 03:00:00", "2008-03-16 02:00:00"
), offSet = c(-15408L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -7200L, -10800L, -14400L, 
-10800L, -7200L, -10800L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 0L, 0L, 1L, 0L), TimeZone = c("CMT", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ART", "ARST", "ART", "ARST", "ART", "ARST", "WART", 
"WARST", "WART", "WARST", "WART", "ARST", "ART", "WART", "ART", 
"ARST", "ART"), numeric = c(-2147397248, -1567453392, -1233432000, 
-1222981200, -1205956800, -1194037200, -1172865600, -1162501200, 
-1141329600, -1130965200, -1109793600, -1099429200, -1078257600, 
-1067806800, -1046635200, -1036270800, -1015099200, -1004734800, 
-983563200, -973198800, -952027200, -941576400, -931032000, -900882000, 
-890337600, -833749200, -827265600, -752274000, -733780800, -197326800, 
-190843200, -184194000, -164491200, -152658000, -132955200, -121122000, 
-101419200, -86821200, -71092800, -54766800, -39038400, -23317200, 
-7588800, 128142000, 136605600, 596948400, 605066400, 624423600, 
636516000, 655963200, 667796400, 687499200, 699418800, 719380800, 
952052400, 1085281200, 1096171200, 1198983600, 1205632800)), .Names = c("Mendoza", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-59L), class = "data.frame")
}

"Rio_Gallegos" <- function () {
structure(list(Rio_Gallegos = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-21 03:00:00", 
"1991-03-03 02:00:00", "1991-10-20 03:00:00", "1992-03-01 02:00:00", 
"1992-10-18 03:00:00", "2000-03-03 03:00:00", "2004-06-01 03:00:00", 
"2004-06-20 04:00:00", "2007-12-30 03:00:00", "2008-03-16 02:00:00"
), offSet = c(-15408L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -14400L, -10800L, 
-7200L, -10800L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 0L, 
1L, 0L), TimeZone = c("CMT", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "WART", "ART", "ARST", "ART"), 
    numeric = c(-2147397248, -1567453392, -1233432000, -1222981200, 
    -1205956800, -1194037200, -1172865600, -1162501200, -1141329600, 
    -1130965200, -1109793600, -1099429200, -1078257600, -1067806800, 
    -1046635200, -1036270800, -1015099200, -1004734800, -983563200, 
    -973198800, -952027200, -941576400, -931032000, -900882000, 
    -890337600, -833749200, -827265600, -752274000, -733780800, 
    -197326800, -190843200, -184194000, -164491200, -152658000, 
    -132955200, -121122000, -101419200, -86821200, -71092800, 
    -54766800, -39038400, -23317200, -7588800, 128142000, 136605600, 
    596948400, 605066400, 624423600, 636516000, 656478000, 667965600, 
    687927600, 699415200, 719377200, 952052400, 1086058800, 1087704000, 
    1198983600, 1205632800)), .Names = c("Rio_Gallegos", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -59L), class = "data.frame")
}

"San_Juan" <- function () {
structure(list(San_Juan = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-21 03:00:00", 
"1991-03-01 02:00:00", "1991-05-07 04:00:00", "1991-10-20 03:00:00", 
"1992-03-01 02:00:00", "1992-10-18 03:00:00", "2000-03-03 03:00:00", 
"2004-05-31 03:00:00", "2004-07-25 04:00:00", "2007-12-30 03:00:00", 
"2008-03-16 02:00:00"), offSet = c(-15408L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -14400L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -14400L, -10800L, -7200L, -10800L), 
    isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
    1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
    0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
    0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 0L, 
    0L, 1L, 0L), TimeZone = c("CMT", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ART", "ARST", "ART", 
    "ARST", "ART", "ARST", "ART", "ARST", "WART", "ART", "ARST", 
    "ART", "ARST", "ART", "WART", "ART", "ARST", "ART"), numeric = c(-2147397248, 
    -1567453392, -1233432000, -1222981200, -1205956800, -1194037200, 
    -1172865600, -1162501200, -1141329600, -1130965200, -1109793600, 
    -1099429200, -1078257600, -1067806800, -1046635200, -1036270800, 
    -1015099200, -1004734800, -983563200, -973198800, -952027200, 
    -941576400, -931032000, -900882000, -890337600, -833749200, 
    -827265600, -752274000, -733780800, -197326800, -190843200, 
    -184194000, -164491200, -152658000, -132955200, -121122000, 
    -101419200, -86821200, -71092800, -54766800, -39038400, -23317200, 
    -7588800, 128142000, 136605600, 596948400, 605066400, 624423600, 
    636516000, 656478000, 667792800, 673588800, 687927600, 699415200, 
    719377200, 952052400, 1085972400, 1090728000, 1198983600, 
    1205632800)), .Names = c("San_Juan", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -60L), class = "data.frame")
}

"Tucuman" <- function () {
structure(list(Tucuman = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-21 03:00:00", 
"1991-03-03 02:00:00", "1991-10-20 04:00:00", "1992-03-01 02:00:00", 
"1992-10-18 03:00:00", "2000-03-03 03:00:00", "2004-06-01 03:00:00", 
"2004-06-13 04:00:00", "2007-12-30 03:00:00", "2008-03-16 02:00:00", 
"2008-10-19 03:00:00", "2009-03-15 02:00:00", "2009-10-18 03:00:00", 
"2010-03-21 02:00:00", "2010-10-17 03:00:00", "2011-03-20 02:00:00", 
"2011-10-16 03:00:00", "2012-03-18 02:00:00", "2012-10-21 03:00:00", 
"2013-03-17 02:00:00", "2013-10-20 03:00:00", "2014-03-16 02:00:00", 
"2014-10-19 03:00:00", "2015-03-15 02:00:00", "2015-10-18 03:00:00", 
"2016-03-20 02:00:00", "2016-10-16 03:00:00", "2017-03-19 02:00:00", 
"2017-10-15 03:00:00", "2018-03-18 02:00:00", "2018-10-21 03:00:00", 
"2019-03-17 02:00:00", "2019-10-20 03:00:00", "2020-03-15 02:00:00", 
"2020-10-18 03:00:00", "2021-03-21 02:00:00", "2021-10-17 03:00:00", 
"2022-03-20 02:00:00", "2022-10-16 03:00:00", "2023-03-19 02:00:00", 
"2023-10-15 03:00:00", "2024-03-17 02:00:00", "2024-10-20 03:00:00", 
"2025-03-16 02:00:00", "2025-10-19 03:00:00", "2026-03-15 02:00:00", 
"2026-10-18 03:00:00", "2027-03-21 02:00:00", "2027-10-17 03:00:00", 
"2028-03-19 02:00:00", "2028-10-15 03:00:00", "2029-03-18 02:00:00", 
"2029-10-21 03:00:00", "2030-03-17 02:00:00", "2030-10-20 03:00:00", 
"2031-03-16 02:00:00", "2031-10-19 03:00:00", "2032-03-21 02:00:00", 
"2032-10-17 03:00:00", "2033-03-20 02:00:00", "2033-10-16 03:00:00", 
"2034-03-19 02:00:00", "2034-10-15 03:00:00", "2035-03-18 02:00:00", 
"2035-10-21 03:00:00", "2036-03-16 02:00:00", "2036-10-19 03:00:00", 
"2037-03-15 02:00:00", "2037-10-18 03:00:00"), offSet = c(-15408L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -14400L, 
-7200L, -10800L, -7200L, -10800L, -14400L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L), 
    TimeZone = c("CMT", "ART", "ARST", "ART", "ARST", "ART", 
    "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
    "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
    "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
    "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
    "ARST", "ART", "ARST", "ART", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "WART", "ARST", "ART", "ARST", 
    "ART", "WART", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
    "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST"
    ), numeric = c(-2147397248, -1567453392, -1233432000, -1222981200, 
    -1205956800, -1194037200, -1172865600, -1162501200, -1141329600, 
    -1130965200, -1109793600, -1099429200, -1078257600, -1067806800, 
    -1046635200, -1036270800, -1015099200, -1004734800, -983563200, 
    -973198800, -952027200, -941576400, -931032000, -900882000, 
    -890337600, -833749200, -827265600, -752274000, -733780800, 
    -197326800, -190843200, -184194000, -164491200, -152658000, 
    -132955200, -121122000, -101419200, -86821200, -71092800, 
    -54766800, -39038400, -23317200, -7588800, 128142000, 136605600, 
    596948400, 605066400, 624423600, 636516000, 656478000, 667965600, 
    687931200, 699415200, 719377200, 952052400, 1086058800, 1087099200, 
    1198983600, 1205632800, 1224385200, 1237082400, 1255834800, 
    1269136800, 1287284400, 1300586400, 1318734000, 1332036000, 
    1350788400, 1363485600, 1382238000, 1394935200, 1413687600, 
    1426384800, 1445137200, 1458439200, 1476586800, 1489888800, 
    1508036400, 1521338400, 1540090800, 1552788000, 1571540400, 
    1584237600, 1602990000, 1616292000, 1634439600, 1647741600, 
    1665889200, 1679191200, 1697338800, 1710640800, 1729393200, 
    1742090400, 1760842800, 1773540000, 1792292400, 1805594400, 
    1823742000, 1837044000, 1855191600, 1868493600, 1887246000, 
    1899943200, 1918695600, 1931392800, 1950145200, 1963447200, 
    1981594800, 1994896800, 2013044400, 2026346400, 2044494000, 
    2057796000, 2076548400, 2089245600, 2107998000, 2120695200, 
    2139447600)), .Names = c("Tucuman", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -118L), class = "data.frame")
}

"Ushuaia" <- function () {
structure(list(Ushuaia = c("1901-12-14 20:45:52", "1920-05-01 04:16:48", 
"1930-12-01 04:00:00", "1931-04-01 03:00:00", "1931-10-15 04:00:00", 
"1932-03-01 03:00:00", "1932-11-01 04:00:00", "1933-03-01 03:00:00", 
"1933-11-01 04:00:00", "1934-03-01 03:00:00", "1934-11-01 04:00:00", 
"1935-03-01 03:00:00", "1935-11-01 04:00:00", "1936-03-01 03:00:00", 
"1936-11-01 04:00:00", "1937-03-01 03:00:00", "1937-11-01 04:00:00", 
"1938-03-01 03:00:00", "1938-11-01 04:00:00", "1939-03-01 03:00:00", 
"1939-11-01 04:00:00", "1940-03-01 03:00:00", "1940-07-01 04:00:00", 
"1941-06-15 03:00:00", "1941-10-15 04:00:00", "1943-08-01 03:00:00", 
"1943-10-15 04:00:00", "1946-03-01 03:00:00", "1946-10-01 04:00:00", 
"1963-10-01 03:00:00", "1963-12-15 04:00:00", "1964-03-01 03:00:00", 
"1964-10-15 04:00:00", "1965-03-01 03:00:00", "1965-10-15 04:00:00", 
"1966-03-01 03:00:00", "1966-10-15 04:00:00", "1967-04-02 03:00:00", 
"1967-10-01 04:00:00", "1968-04-07 03:00:00", "1968-10-06 04:00:00", 
"1969-04-06 03:00:00", "1969-10-05 04:00:00", "1974-01-23 03:00:00", 
"1974-05-01 02:00:00", "1988-12-01 03:00:00", "1989-03-05 02:00:00", 
"1989-10-15 03:00:00", "1990-03-04 02:00:00", "1990-10-21 03:00:00", 
"1991-03-03 02:00:00", "1991-10-20 03:00:00", "1992-03-01 02:00:00", 
"1992-10-18 03:00:00", "2000-03-03 03:00:00", "2004-05-30 03:00:00", 
"2004-06-20 04:00:00", "2007-12-30 03:00:00", "2008-03-16 02:00:00"
), offSet = c(-15408L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -14400L, -10800L, 
-7200L, -10800L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 0L, 
1L, 0L), TimeZone = c("CMT", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "WART", "ART", "ARST", "ART"), 
    numeric = c(-2147397248, -1567453392, -1233432000, -1222981200, 
    -1205956800, -1194037200, -1172865600, -1162501200, -1141329600, 
    -1130965200, -1109793600, -1099429200, -1078257600, -1067806800, 
    -1046635200, -1036270800, -1015099200, -1004734800, -983563200, 
    -973198800, -952027200, -941576400, -931032000, -900882000, 
    -890337600, -833749200, -827265600, -752274000, -733780800, 
    -197326800, -190843200, -184194000, -164491200, -152658000, 
    -132955200, -121122000, -101419200, -86821200, -71092800, 
    -54766800, -39038400, -23317200, -7588800, 128142000, 136605600, 
    596948400, 605066400, 624423600, 636516000, 656478000, 667965600, 
    687927600, 699415200, 719377200, 952052400, 1085886000, 1087704000, 
    1198983600, 1205632800)), .Names = c("Ushuaia", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -59L), class = "data.frame")
}

"Aruba" <- function () {
structure(list(Aruba = c("1901-12-14 20:45:52", "1912-02-12 04:40:24", 
"1965-01-01 04:30:00"), offSet = c(-16824L, -16200L, -14400L), 
    isdst = c(0L, 0L, 0L), TimeZone = c("LMT", "ANT", "AST"), 
    numeric = c(-2147397248, -1826738376, -157750200)), .Names = c("Aruba", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-3L), class = "data.frame")
}

"Asuncion" <- function () {
structure(list(Asuncion = c("1901-12-14 20:45:52", "1931-10-10 03:50:40", 
"1972-10-01 04:00:00", "1974-04-01 03:00:00", "1975-10-01 04:00:00", 
"1976-03-01 03:00:00", "1976-10-01 04:00:00", "1977-03-01 03:00:00", 
"1977-10-01 04:00:00", "1978-03-01 03:00:00", "1978-10-01 04:00:00", 
"1979-04-01 03:00:00", "1979-10-01 04:00:00", "1980-04-01 03:00:00", 
"1980-10-01 04:00:00", "1981-04-01 03:00:00", "1981-10-01 04:00:00", 
"1982-04-01 03:00:00", "1982-10-01 04:00:00", "1983-04-01 03:00:00", 
"1983-10-01 04:00:00", "1984-04-01 03:00:00", "1984-10-01 04:00:00", 
"1985-04-01 03:00:00", "1985-10-01 04:00:00", "1986-04-01 03:00:00", 
"1986-10-01 04:00:00", "1987-04-01 03:00:00", "1987-10-01 04:00:00", 
"1988-04-01 03:00:00", "1988-10-01 04:00:00", "1989-04-01 03:00:00", 
"1989-10-22 04:00:00", "1990-04-01 03:00:00", "1990-10-01 04:00:00", 
"1991-04-01 03:00:00", "1991-10-06 04:00:00", "1992-03-01 03:00:00", 
"1992-10-05 04:00:00", "1993-03-31 03:00:00", "1993-10-01 04:00:00", 
"1994-02-27 03:00:00", "1994-10-01 04:00:00", "1995-02-26 03:00:00", 
"1995-10-01 04:00:00", "1996-03-01 03:00:00", "1996-10-06 04:00:00", 
"1997-02-23 03:00:00", "1997-10-05 04:00:00", "1998-03-01 03:00:00", 
"1998-10-04 04:00:00", "1999-03-07 03:00:00", "1999-10-03 04:00:00", 
"2000-03-05 03:00:00", "2000-10-01 04:00:00", "2001-03-04 03:00:00", 
"2001-10-07 04:00:00", "2002-04-07 03:00:00", "2002-09-01 04:00:00", 
"2003-04-06 03:00:00", "2003-09-07 04:00:00", "2004-04-04 03:00:00", 
"2004-10-17 04:00:00", "2005-03-13 03:00:00", "2005-10-16 04:00:00", 
"2006-03-12 03:00:00", "2006-10-15 04:00:00", "2007-03-11 03:00:00", 
"2007-10-21 04:00:00", "2008-03-09 03:00:00", "2008-10-19 04:00:00", 
"2009-03-08 03:00:00", "2009-10-18 04:00:00", "2010-03-14 03:00:00", 
"2010-10-17 04:00:00", "2011-03-13 03:00:00", "2011-10-16 04:00:00", 
"2012-03-11 03:00:00", "2012-10-21 04:00:00", "2013-03-10 03:00:00", 
"2013-10-20 04:00:00", "2014-03-09 03:00:00", "2014-10-19 04:00:00", 
"2015-03-08 03:00:00", "2015-10-18 04:00:00", "2016-03-13 03:00:00", 
"2016-10-16 04:00:00", "2017-03-12 03:00:00", "2017-10-15 04:00:00", 
"2018-03-11 03:00:00", "2018-10-21 04:00:00", "2019-03-10 03:00:00", 
"2019-10-20 04:00:00", "2020-03-08 03:00:00", "2020-10-18 04:00:00", 
"2021-03-14 03:00:00", "2021-10-17 04:00:00", "2022-03-13 03:00:00", 
"2022-10-16 04:00:00", "2023-03-12 03:00:00", "2023-10-15 04:00:00", 
"2024-03-10 03:00:00", "2024-10-20 04:00:00", "2025-03-09 03:00:00", 
"2025-10-19 04:00:00", "2026-03-08 03:00:00", "2026-10-18 04:00:00", 
"2027-03-14 03:00:00", "2027-10-17 04:00:00", "2028-03-12 03:00:00", 
"2028-10-15 04:00:00", "2029-03-11 03:00:00", "2029-10-21 04:00:00", 
"2030-03-10 03:00:00", "2030-10-20 04:00:00", "2031-03-09 03:00:00", 
"2031-10-19 04:00:00", "2032-03-14 03:00:00", "2032-10-17 04:00:00", 
"2033-03-13 03:00:00", "2033-10-16 04:00:00", "2034-03-12 03:00:00", 
"2034-10-15 04:00:00", "2035-03-11 03:00:00", "2035-10-21 04:00:00", 
"2036-03-09 03:00:00", "2036-10-19 04:00:00", "2037-03-08 03:00:00", 
"2037-10-18 04:00:00"), offSet = c(-13840L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L
), isdst = c(0L, 0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L), TimeZone = c("AMT", "PYT", "PYT", "PYT", 
"PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", 
"PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", 
"PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", 
"PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", 
"PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", 
"PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", 
"PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", 
"PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", 
"PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", 
"PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", 
"PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", 
"PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", 
"PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST", 
"PYT", "PYST", "PYT", "PYST", "PYT", "PYST", "PYT", "PYST"), 
    numeric = c(-2147397248, -1206389360, 86760000, 134017200, 
    181368000, 194497200, 212990400, 226033200, 244526400, 257569200, 
    276062400, 291783600, 307598400, 323406000, 339220800, 354942000, 
    370756800, 386478000, 402292800, 418014000, 433828800, 449636400, 
    465451200, 481172400, 496987200, 512708400, 528523200, 544244400, 
    560059200, 575866800, 591681600, 607402800, 625032000, 638938800, 
    654753600, 670474800, 686721600, 699418800, 718257600, 733546800, 
    749448000, 762318000, 780984000, 793767600, 812520000, 825649200, 
    844574400, 856666800, 876024000, 888721200, 907473600, 920775600, 
    938923200, 952225200, 970372800, 983674800, 1002427200, 1018148400, 
    1030852800, 1049598000, 1062907200, 1081047600, 1097985600, 
    1110682800, 1129435200, 1142132400, 1160884800, 1173582000, 
    1192939200, 1205031600, 1224388800, 1236481200, 1255838400, 
    1268535600, 1287288000, 1299985200, 1318737600, 1331434800, 
    1350792000, 1362884400, 1382241600, 1394334000, 1413691200, 
    1425783600, 1445140800, 1457838000, 1476590400, 1489287600, 
    1508040000, 1520737200, 1540094400, 1552186800, 1571544000, 
    1583636400, 1602993600, 1615690800, 1634443200, 1647140400, 
    1665892800, 1678590000, 1697342400, 1710039600, 1729396800, 
    1741489200, 1760846400, 1772938800, 1792296000, 1804993200, 
    1823745600, 1836442800, 1855195200, 1867892400, 1887249600, 
    1899342000, 1918699200, 1930791600, 1950148800, 1962846000, 
    1981598400, 1994295600, 2013048000, 2025745200, 2044497600, 
    2057194800, 2076552000, 2088644400, 2108001600, 2120094000, 
    2139451200)), .Names = c("Asuncion", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -129L), class = "data.frame")
}

"Atikokan" <- function () {
structure(list(Atikokan = c("1901-12-14 20:45:52", "1918-04-14 08:00:00", 
"1918-10-31 07:00:00", "1940-09-29 06:00:00"), offSet = c(-21600L, 
-18000L, -21600L, -18000L), isdst = c(0L, 1L, 0L, 1L), TimeZone = c("CST", 
"CDT", "CST", "CDT"), numeric = c(-2147397248, -1632067200, -1614790800, 
-923248800)), .Names = c("Atikokan", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"Bahia" <- function () {
structure(list(Bahia = c("1901-12-14 20:45:52", "1914-01-01 02:34:04", 
"1931-10-03 14:00:00", "1932-04-01 02:00:00", "1932-10-03 03:00:00", 
"1933-04-01 02:00:00", "1949-12-01 03:00:00", "1950-04-16 03:00:00", 
"1950-12-01 03:00:00", "1951-04-01 02:00:00", "1951-12-01 03:00:00", 
"1952-04-01 02:00:00", "1952-12-01 03:00:00", "1953-03-01 02:00:00", 
"1963-12-09 03:00:00", "1964-03-01 02:00:00", "1965-01-31 03:00:00", 
"1965-03-31 02:00:00", "1965-12-01 03:00:00", "1966-03-01 02:00:00", 
"1966-11-01 03:00:00", "1967-03-01 02:00:00", "1967-11-01 03:00:00", 
"1968-03-01 02:00:00", "1985-11-02 03:00:00", "1986-03-15 02:00:00", 
"1986-10-25 03:00:00", "1987-02-14 02:00:00", "1987-10-25 03:00:00", 
"1988-02-07 02:00:00", "1988-10-16 03:00:00", "1989-01-29 02:00:00", 
"1989-10-15 03:00:00", "1990-02-11 02:00:00", "1990-10-21 03:00:00", 
"1991-02-17 02:00:00", "1991-10-20 03:00:00", "1992-02-09 02:00:00", 
"1992-10-25 03:00:00", "1993-01-31 02:00:00", "1993-10-17 03:00:00", 
"1994-02-20 02:00:00", "1994-10-16 03:00:00", "1995-02-19 02:00:00", 
"1995-10-15 03:00:00", "1996-02-11 02:00:00", "1996-10-06 03:00:00", 
"1997-02-16 02:00:00", "1997-10-06 03:00:00", "1998-03-01 02:00:00", 
"1998-10-11 03:00:00", "1999-02-21 02:00:00", "1999-10-03 03:00:00", 
"2000-02-27 02:00:00", "2000-10-08 03:00:00", "2001-02-18 02:00:00", 
"2001-10-14 03:00:00", "2002-02-17 02:00:00", "2002-11-03 03:00:00", 
"2003-02-16 02:00:00"), offSet = c(-9244L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L
), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L
), TimeZone = c("LMT", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT"), 
    numeric = c(-2147397248, -1767216356, -1206957600, -1191362400, 
    -1175374800, -1159826400, -633819600, -622069200, -602283600, 
    -591832800, -570747600, -560210400, -539125200, -531352800, 
    -191365200, -184197600, -155163600, -150069600, -128898000, 
    -121125600, -99954000, -89589600, -68418000, -57967200, 499748400, 
    511236000, 530593200, 540266400, 562129200, 571197600, 592974000, 
    602042400, 624423600, 634701600, 656478000, 666756000, 687927600, 
    697600800, 719982000, 728445600, 750826800, 761709600, 782276400, 
    793159200, 813726000, 824004000, 844570800, 856058400, 876106800, 
    888717600, 908074800, 919562400, 938919600, 951616800, 970974000, 
    982461600, 1003028400, 1013911200, 1036292400, 1045360800
    )), .Names = c("Bahia", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -60L), class = "data.frame")
}

"Barbados" <- function () {
structure(list(Barbados = c("1924-01-01 03:58:28", "1932-01-01 03:58:28", 
"1977-06-12 06:00:00", "1977-10-02 05:00:00", "1978-04-16 06:00:00", 
"1978-10-01 05:00:00", "1979-04-15 06:00:00", "1979-09-30 05:00:00", 
"1980-04-20 06:00:00", "1980-09-25 05:00:00"), offSet = c(-14308L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L), TimeZone = c("BMT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST"), numeric = c(-1451678492, -1199217692, 
234943200, 244616400, 261554400, 276066000, 293004000, 307515600, 
325058400, 338706000)), .Names = c("Barbados", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -10L), class = "data.frame")
}

"Belem" <- function () {
structure(list(Belem = c("1901-12-14 20:45:52", "1914-01-01 03:13:56", 
"1931-10-03 14:00:00", "1932-04-01 02:00:00", "1932-10-03 03:00:00", 
"1933-04-01 02:00:00", "1949-12-01 03:00:00", "1950-04-16 03:00:00", 
"1950-12-01 03:00:00", "1951-04-01 02:00:00", "1951-12-01 03:00:00", 
"1952-04-01 02:00:00", "1952-12-01 03:00:00", "1953-03-01 02:00:00", 
"1963-12-09 03:00:00", "1964-03-01 02:00:00", "1965-01-31 03:00:00", 
"1965-03-31 02:00:00", "1965-12-01 03:00:00", "1966-03-01 02:00:00", 
"1966-11-01 03:00:00", "1967-03-01 02:00:00", "1967-11-01 03:00:00", 
"1968-03-01 02:00:00", "1985-11-02 03:00:00", "1986-03-15 02:00:00", 
"1986-10-25 03:00:00", "1987-02-14 02:00:00", "1987-10-25 03:00:00", 
"1988-02-07 02:00:00"), offSet = c(-11636L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT"
), numeric = c(-2147397248, -1767213964, -1206957600, -1191362400, 
-1175374800, -1159826400, -633819600, -622069200, -602283600, 
-591832800, -570747600, -560210400, -539125200, -531352800, -191365200, 
-184197600, -155163600, -150069600, -128898000, -121125600, -99954000, 
-89589600, -68418000, -57967200, 499748400, 511236000, 530593200, 
540266400, 562129200, 571197600)), .Names = c("Belem", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -30L), class = "data.frame")
}

"Belize" <- function () {
structure(list(Belize = c("1901-12-14 20:45:52", "1912-04-01 05:52:48", 
"1918-10-06 06:00:00", "1919-02-09 05:30:00", "1919-10-05 06:00:00", 
"1920-02-15 05:30:00", "1920-10-03 06:00:00", "1921-02-13 05:30:00", 
"1921-10-02 06:00:00", "1922-02-12 05:30:00", "1922-10-08 06:00:00", 
"1923-02-11 05:30:00", "1923-10-07 06:00:00", "1924-02-10 05:30:00", 
"1924-10-05 06:00:00", "1925-02-15 05:30:00", "1925-10-04 06:00:00", 
"1926-02-14 05:30:00", "1926-10-03 06:00:00", "1927-02-13 05:30:00", 
"1927-10-02 06:00:00", "1928-02-12 05:30:00", "1928-10-07 06:00:00", 
"1929-02-10 05:30:00", "1929-10-06 06:00:00", "1930-02-09 05:30:00", 
"1930-10-05 06:00:00", "1931-02-15 05:30:00", "1931-10-04 06:00:00", 
"1932-02-14 05:30:00", "1932-10-02 06:00:00", "1933-02-12 05:30:00", 
"1933-10-08 06:00:00", "1934-02-11 05:30:00", "1934-10-07 06:00:00", 
"1935-02-10 05:30:00", "1935-10-06 06:00:00", "1936-02-09 05:30:00", 
"1936-10-04 06:00:00", "1937-02-14 05:30:00", "1937-10-03 06:00:00", 
"1938-02-13 05:30:00", "1938-10-02 06:00:00", "1939-02-12 05:30:00", 
"1939-10-08 06:00:00", "1940-02-11 05:30:00", "1940-10-06 06:00:00", 
"1941-02-09 05:30:00", "1941-10-05 06:00:00", "1942-02-15 05:30:00", 
"1942-10-04 06:00:00", "1943-02-14 05:30:00", "1973-12-05 06:00:00", 
"1974-02-09 05:00:00", "1982-12-18 06:00:00", "1983-02-12 05:00:00"
), offSet = c(-21168L, -21600L, -19800L, -21600L, -19800L, -21600L, 
-19800L, -21600L, -19800L, -21600L, -19800L, -21600L, -19800L, 
-21600L, -19800L, -21600L, -19800L, -21600L, -19800L, -21600L, 
-19800L, -21600L, -19800L, -21600L, -19800L, -21600L, -19800L, 
-21600L, -19800L, -21600L, -19800L, -21600L, -19800L, -21600L, 
-19800L, -21600L, -19800L, -21600L, -19800L, -21600L, -19800L, 
-21600L, -19800L, -21600L, -19800L, -21600L, -19800L, -21600L, 
-19800L, -21600L, -19800L, -21600L, -18000L, -21600L, -18000L, 
-21600L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"CST", "CHDT", "CST", "CHDT", "CST", "CHDT", "CST", "CHDT", "CST", 
"CHDT", "CST", "CHDT", "CST", "CHDT", "CST", "CHDT", "CST", "CHDT", 
"CST", "CHDT", "CST", "CHDT", "CST", "CHDT", "CST", "CHDT", "CST", 
"CHDT", "CST", "CHDT", "CST", "CHDT", "CST", "CHDT", "CST", "CHDT", 
"CST", "CHDT", "CST", "CHDT", "CST", "CHDT", "CST", "CHDT", "CST", 
"CHDT", "CST", "CHDT", "CST", "CHDT", "CST", "CDT", "CST", "CDT", 
"CST"), numeric = c(-2147397248, -1822500432, -1616954400, -1606069800, 
-1585504800, -1574015400, -1554055200, -1542565800, -1522605600, 
-1511116200, -1490551200, -1479666600, -1459101600, -1448217000, 
-1427652000, -1416162600, -1396202400, -1384713000, -1364752800, 
-1353263400, -1333303200, -1321813800, -1301248800, -1290364200, 
-1269799200, -1258914600, -1238349600, -1226860200, -1206900000, 
-1195410600, -1175450400, -1163961000, -1143396000, -1132511400, 
-1111946400, -1101061800, -1080496800, -1069612200, -1049047200, 
-1037557800, -1017597600, -1006108200, -986148000, -974658600, 
-954093600, -943209000, -922644000, -911759400, -891194400, -879705000, 
-859744800, -848255400, 123919200, 129618000, 409039200, 413874000
)), .Names = c("Belize", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -56L), class = "data.frame")
}

"Blanc-Sablon" <- function () {
structure(list(`Blanc-Sablon` = c("1901-12-14 20:45:52", "1918-04-14 06:00:00", 
"1918-10-31 05:00:00", "1945-08-14 23:00:00", "1945-09-30 05:00:00"
), offSet = c(-14400L, -10800L, -14400L, -10800L, -14400L), isdst = c(0L, 
1L, 0L, 1L, 0L), TimeZone = c("AST", "ADT", "AST", "APT", "AST"
), numeric = c(-2147397248, -1632074400, -1614798000, -769395600, 
-765399600)), .Names = c("Blanc-Sablon", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -5L), class = "data.frame")
}

"Boa_Vista" <- function () {
structure(list(Boa_Vista = c("1901-12-14 20:45:52", "1914-01-01 04:02:40", 
"1931-10-03 15:00:00", "1932-04-01 03:00:00", "1932-10-03 04:00:00", 
"1933-04-01 03:00:00", "1949-12-01 04:00:00", "1950-04-16 04:00:00", 
"1950-12-01 04:00:00", "1951-04-01 03:00:00", "1951-12-01 04:00:00", 
"1952-04-01 03:00:00", "1952-12-01 04:00:00", "1953-03-01 03:00:00", 
"1963-12-09 04:00:00", "1964-03-01 03:00:00", "1965-01-31 04:00:00", 
"1965-03-31 03:00:00", "1965-12-01 04:00:00", "1966-03-01 03:00:00", 
"1966-11-01 04:00:00", "1967-03-01 03:00:00", "1967-11-01 04:00:00", 
"1968-03-01 03:00:00", "1985-11-02 04:00:00", "1986-03-15 03:00:00", 
"1986-10-25 04:00:00", "1987-02-14 03:00:00", "1987-10-25 04:00:00", 
"1988-02-07 03:00:00", "1999-10-03 04:00:00", "2000-02-27 03:00:00", 
"2000-10-08 04:00:00", "2000-10-15 03:00:00"), offSet = c(-14560L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L), isdst = c(0L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L
), TimeZone = c("LMT", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT"
), numeric = c(-2147397248, -1767211040, -1206954000, -1191358800, 
-1175371200, -1159822800, -633816000, -622065600, -602280000, 
-591829200, -570744000, -560206800, -539121600, -531349200, -191361600, 
-184194000, -155160000, -150066000, -128894400, -121122000, -99950400, 
-89586000, -68414400, -57963600, 499752000, 511239600, 530596800, 
540270000, 562132800, 571201200, 938923200, 951620400, 970977600, 
971578800)), .Names = c("Boa_Vista", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -34L), class = "data.frame")
}

"Bogota" <- function () {
structure(list(Bogota = c("1901-12-14 20:45:52", "1914-11-23 04:56:20", 
"1992-05-03 05:00:00", "1993-04-04 04:00:00"), offSet = c(-17780L, 
-18000L, -14400L, -18000L), isdst = c(0L, 0L, 1L, 0L), TimeZone = c("BMT", 
"COT", "COST", "COT"), numeric = c(-2147397248, -1739041420, 
704869200, 733896000)), .Names = c("Bogota", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"Boise" <- function () {
structure(list(Boise = c("1901-12-14 20:45:52", "1918-03-31 10:00:00", 
"1918-10-27 09:00:00", "1919-03-30 10:00:00", "1919-10-26 09:00:00", 
"1923-05-13 10:00:00", "1945-08-14 23:00:00", "1945-09-30 08:00:00", 
"1967-04-30 09:00:00", "1967-10-29 08:00:00", "1968-04-28 09:00:00", 
"1968-10-27 08:00:00", "1969-04-27 09:00:00", "1969-10-26 08:00:00", 
"1970-04-26 09:00:00", "1970-10-25 08:00:00", "1971-04-25 09:00:00", 
"1971-10-31 08:00:00", "1972-04-30 09:00:00", "1972-10-29 08:00:00", 
"1973-04-29 09:00:00", "1973-10-28 08:00:00", "1974-02-03 09:00:00", 
"1974-10-27 08:00:00", "1975-02-23 09:00:00", "1975-10-26 08:00:00", 
"1976-04-25 09:00:00", "1976-10-31 08:00:00", "1977-04-24 09:00:00", 
"1977-10-30 08:00:00", "1978-04-30 09:00:00", "1978-10-29 08:00:00", 
"1979-04-29 09:00:00", "1979-10-28 08:00:00", "1980-04-27 09:00:00", 
"1980-10-26 08:00:00", "1981-04-26 09:00:00", "1981-10-25 08:00:00", 
"1982-04-25 09:00:00", "1982-10-31 08:00:00", "1983-04-24 09:00:00", 
"1983-10-30 08:00:00", "1984-04-29 09:00:00", "1984-10-28 08:00:00", 
"1985-04-28 09:00:00", "1985-10-27 08:00:00", "1986-04-27 09:00:00", 
"1986-10-26 08:00:00", "1987-04-05 09:00:00", "1987-10-25 08:00:00", 
"1988-04-03 09:00:00", "1988-10-30 08:00:00", "1989-04-02 09:00:00", 
"1989-10-29 08:00:00", "1990-04-01 09:00:00", "1990-10-28 08:00:00", 
"1991-04-07 09:00:00", "1991-10-27 08:00:00", "1992-04-05 09:00:00", 
"1992-10-25 08:00:00", "1993-04-04 09:00:00", "1993-10-31 08:00:00", 
"1994-04-03 09:00:00", "1994-10-30 08:00:00", "1995-04-02 09:00:00", 
"1995-10-29 08:00:00", "1996-04-07 09:00:00", "1996-10-27 08:00:00", 
"1997-04-06 09:00:00", "1997-10-26 08:00:00", "1998-04-05 09:00:00", 
"1998-10-25 08:00:00", "1999-04-04 09:00:00", "1999-10-31 08:00:00", 
"2000-04-02 09:00:00", "2000-10-29 08:00:00", "2001-04-01 09:00:00", 
"2001-10-28 08:00:00", "2002-04-07 09:00:00", "2002-10-27 08:00:00", 
"2003-04-06 09:00:00", "2003-10-26 08:00:00", "2004-04-04 09:00:00", 
"2004-10-31 08:00:00", "2005-04-03 09:00:00", "2005-10-30 08:00:00", 
"2006-04-02 09:00:00", "2006-10-29 08:00:00", "2007-03-11 09:00:00", 
"2007-11-04 08:00:00", "2008-03-09 09:00:00", "2008-11-02 08:00:00", 
"2009-03-08 09:00:00", "2009-11-01 08:00:00", "2010-03-14 09:00:00", 
"2010-11-07 08:00:00", "2011-03-13 09:00:00", "2011-11-06 08:00:00", 
"2012-03-11 09:00:00", "2012-11-04 08:00:00", "2013-03-10 09:00:00", 
"2013-11-03 08:00:00", "2014-03-09 09:00:00", "2014-11-02 08:00:00", 
"2015-03-08 09:00:00", "2015-11-01 08:00:00", "2016-03-13 09:00:00", 
"2016-11-06 08:00:00", "2017-03-12 09:00:00", "2017-11-05 08:00:00", 
"2018-03-11 09:00:00", "2018-11-04 08:00:00", "2019-03-10 09:00:00", 
"2019-11-03 08:00:00", "2020-03-08 09:00:00", "2020-11-01 08:00:00", 
"2021-03-14 09:00:00", "2021-11-07 08:00:00", "2022-03-13 09:00:00", 
"2022-11-06 08:00:00", "2023-03-12 09:00:00", "2023-11-05 08:00:00", 
"2024-03-10 09:00:00", "2024-11-03 08:00:00", "2025-03-09 09:00:00", 
"2025-11-02 08:00:00", "2026-03-08 09:00:00", "2026-11-01 08:00:00", 
"2027-03-14 09:00:00", "2027-11-07 08:00:00", "2028-03-12 09:00:00", 
"2028-11-05 08:00:00", "2029-03-11 09:00:00", "2029-11-04 08:00:00", 
"2030-03-10 09:00:00", "2030-11-03 08:00:00", "2031-03-09 09:00:00", 
"2031-11-02 08:00:00", "2032-03-14 09:00:00", "2032-11-07 08:00:00", 
"2033-03-13 09:00:00", "2033-11-06 08:00:00", "2034-03-12 09:00:00", 
"2034-11-05 08:00:00", "2035-03-11 09:00:00", "2035-11-04 08:00:00", 
"2036-03-09 09:00:00", "2036-11-02 08:00:00", "2037-03-08 09:00:00", 
"2037-11-01 08:00:00"), offSet = c(-28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L
), isdst = c(0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("PST", 
"PDT", "PST", "PDT", "PST", "MST", "MPT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST"), numeric = c(-2147397248, 
-1633269600, -1615129200, -1601820000, -1583679600, -1471788000, 
-769395600, -765388800, -84380400, -68659200, -52930800, -37209600, 
-21481200, -5760000, 9968400, 25689600, 41418000, 57744000, 73472400, 
89193600, 104922000, 120643200, 129114000, 152092800, 162378000, 
183542400, 199270800, 215596800, 230720400, 247046400, 262774800, 
278496000, 294224400, 309945600, 325674000, 341395200, 357123600, 
372844800, 388573200, 404899200, 420022800, 436348800, 452077200, 
467798400, 483526800, 499248000, 514976400, 530697600, 544611600, 
562147200, 576061200, 594201600, 607510800, 625651200, 638960400, 
657100800, 671014800, 688550400, 702464400, 7.2e+08, 733914000, 
752054400, 765363600, 783504000, 796813200, 814953600, 828867600, 
846403200, 860317200, 877852800, 891766800, 909302400, 923216400, 
941356800, 954666000, 972806400, 986115600, 1004256000, 1018170000, 
1035705600, 1049619600, 1067155200, 1081069200, 1099209600, 1112518800, 
1130659200, 1143968400, 1162108800, 1173603600, 1194163200, 1205053200, 
1225612800, 1236502800, 1257062400, 1268557200, 1289116800, 1300006800, 
1320566400, 1331456400, 1352016000, 1362906000, 1383465600, 1394355600, 
1414915200, 1425805200, 1446364800, 1457859600, 1478419200, 1489309200, 
1509868800, 1520758800, 1541318400, 1552208400, 1572768000, 1583658000, 
1604217600, 1615712400, 1636272000, 1647162000, 1667721600, 1678611600, 
1699171200, 1710061200, 1730620800, 1741510800, 1762070400, 1772960400, 
1793520000, 1805014800, 1825574400, 1836464400, 1857024000, 1867914000, 
1888473600, 1899363600, 1919923200, 1930813200, 1951372800, 1962867600, 
1983427200, 1994317200, 2014876800, 2025766800, 2046326400, 2057216400, 
2077776000, 2088666000, 2109225600, 2120115600, 2140675200)), .Names = c("Boise", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-150L), class = "data.frame")
}

"Cambridge_Bay" <- function () {
structure(list(Cambridge_Bay = c("1901-12-14 20:45:52", "1920-01-01 00:00:00", 
"1945-08-14 23:00:00", "1945-09-30 08:00:00", "1965-04-25 07:00:00", 
"1965-10-31 07:00:00", "1980-04-27 09:00:00", "1980-10-26 08:00:00", 
"1981-04-26 09:00:00", "1981-10-25 08:00:00", "1982-04-25 09:00:00", 
"1982-10-31 08:00:00", "1983-04-24 09:00:00", "1983-10-30 08:00:00", 
"1984-04-29 09:00:00", "1984-10-28 08:00:00", "1985-04-28 09:00:00", 
"1985-10-27 08:00:00", "1986-04-27 09:00:00", "1986-10-26 08:00:00", 
"1987-04-05 09:00:00", "1987-10-25 08:00:00", "1988-04-03 09:00:00", 
"1988-10-30 08:00:00", "1989-04-02 09:00:00", "1989-10-29 08:00:00", 
"1990-04-01 09:00:00", "1990-10-28 08:00:00", "1991-04-07 09:00:00", 
"1991-10-27 08:00:00", "1992-04-05 09:00:00", "1992-10-25 08:00:00", 
"1993-04-04 09:00:00", "1993-10-31 08:00:00", "1994-04-03 09:00:00", 
"1994-10-30 08:00:00", "1995-04-02 09:00:00", "1995-10-29 08:00:00", 
"1996-04-07 09:00:00", "1996-10-27 08:00:00", "1997-04-06 09:00:00", 
"1997-10-26 08:00:00", "1998-04-05 09:00:00", "1998-10-25 08:00:00", 
"1999-10-31 08:00:00", "2000-10-29 07:00:00", "2001-04-01 09:00:00", 
"2001-10-28 08:00:00", "2002-04-07 09:00:00", "2002-10-27 08:00:00", 
"2003-04-06 09:00:00", "2003-10-26 08:00:00", "2004-04-04 09:00:00", 
"2004-10-31 08:00:00", "2005-04-03 09:00:00", "2005-10-30 08:00:00", 
"2006-04-02 09:00:00", "2006-10-29 08:00:00", "2007-03-11 09:00:00", 
"2007-11-04 08:00:00", "2008-03-09 09:00:00", "2008-11-02 08:00:00", 
"2009-03-08 09:00:00", "2009-11-01 08:00:00", "2010-03-14 09:00:00", 
"2010-11-07 08:00:00", "2011-03-13 09:00:00", "2011-11-06 08:00:00", 
"2012-03-11 09:00:00", "2012-11-04 08:00:00", "2013-03-10 09:00:00", 
"2013-11-03 08:00:00", "2014-03-09 09:00:00", "2014-11-02 08:00:00", 
"2015-03-08 09:00:00", "2015-11-01 08:00:00", "2016-03-13 09:00:00", 
"2016-11-06 08:00:00", "2017-03-12 09:00:00", "2017-11-05 08:00:00", 
"2018-03-11 09:00:00", "2018-11-04 08:00:00", "2019-03-10 09:00:00", 
"2019-11-03 08:00:00", "2020-03-08 09:00:00", "2020-11-01 08:00:00", 
"2021-03-14 09:00:00", "2021-11-07 08:00:00", "2022-03-13 09:00:00", 
"2022-11-06 08:00:00", "2023-03-12 09:00:00", "2023-11-05 08:00:00", 
"2024-03-10 09:00:00", "2024-11-03 08:00:00", "2025-03-09 09:00:00", 
"2025-11-02 08:00:00", "2026-03-08 09:00:00", "2026-11-01 08:00:00", 
"2027-03-14 09:00:00", "2027-11-07 08:00:00", "2028-03-12 09:00:00", 
"2028-11-05 08:00:00", "2029-03-11 09:00:00", "2029-11-04 08:00:00", 
"2030-03-10 09:00:00", "2030-11-03 08:00:00", "2031-03-09 09:00:00", 
"2031-11-02 08:00:00", "2032-03-14 09:00:00", "2032-11-07 08:00:00", 
"2033-03-13 09:00:00", "2033-11-06 08:00:00", "2034-03-12 09:00:00", 
"2034-11-05 08:00:00", "2035-03-11 09:00:00", "2035-11-04 08:00:00", 
"2036-03-09 09:00:00", "2036-11-02 08:00:00", "2037-03-08 09:00:00", 
"2037-11-01 08:00:00"), offSet = c(0L, -25200L, -21600L, -25200L, 
-18000L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -18000L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L), isdst = c(0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L), TimeZone = c("zzz", "MST", "MPT", "MST", "MDDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "CST", "EST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST"), numeric = c(-2147397248, 
-1577923200, -769395600, -765388800, -147891600, -131562000, 
325674000, 341395200, 357123600, 372844800, 388573200, 404899200, 
420022800, 436348800, 452077200, 467798400, 483526800, 499248000, 
514976400, 530697600, 544611600, 562147200, 576061200, 594201600, 
607510800, 625651200, 638960400, 657100800, 671014800, 688550400, 
702464400, 7.2e+08, 733914000, 752054400, 765363600, 783504000, 
796813200, 814953600, 828867600, 846403200, 860317200, 877852800, 
891766800, 909302400, 941356800, 972802800, 986115600, 1004256000, 
1018170000, 1035705600, 1049619600, 1067155200, 1081069200, 1099209600, 
1112518800, 1130659200, 1143968400, 1162108800, 1173603600, 1194163200, 
1205053200, 1225612800, 1236502800, 1257062400, 1268557200, 1289116800, 
1300006800, 1320566400, 1331456400, 1352016000, 1362906000, 1383465600, 
1394355600, 1414915200, 1425805200, 1446364800, 1457859600, 1478419200, 
1489309200, 1509868800, 1520758800, 1541318400, 1552208400, 1572768000, 
1583658000, 1604217600, 1615712400, 1636272000, 1647162000, 1667721600, 
1678611600, 1699171200, 1710061200, 1730620800, 1741510800, 1762070400, 
1772960400, 1793520000, 1805014800, 1825574400, 1836464400, 1857024000, 
1867914000, 1888473600, 1899363600, 1919923200, 1930813200, 1951372800, 
1962867600, 1983427200, 1994317200, 2014876800, 2025766800, 2046326400, 
2057216400, 2077776000, 2088666000, 2109225600, 2120115600, 2140675200
)), .Names = c("Cambridge_Bay", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -120L), class = "data.frame")
}

"Campo_Grande" <- function () {
structure(list(Campo_Grande = c("1901-12-14 20:45:52", "1914-01-01 03:38:28", 
"1931-10-03 15:00:00", "1932-04-01 03:00:00", "1932-10-03 04:00:00", 
"1933-04-01 03:00:00", "1949-12-01 04:00:00", "1950-04-16 04:00:00", 
"1950-12-01 04:00:00", "1951-04-01 03:00:00", "1951-12-01 04:00:00", 
"1952-04-01 03:00:00", "1952-12-01 04:00:00", "1953-03-01 03:00:00", 
"1963-12-09 04:00:00", "1964-03-01 03:00:00", "1965-01-31 04:00:00", 
"1965-03-31 03:00:00", "1965-12-01 04:00:00", "1966-03-01 03:00:00", 
"1966-11-01 04:00:00", "1967-03-01 03:00:00", "1967-11-01 04:00:00", 
"1968-03-01 03:00:00", "1985-11-02 04:00:00", "1986-03-15 03:00:00", 
"1986-10-25 04:00:00", "1987-02-14 03:00:00", "1987-10-25 04:00:00", 
"1988-02-07 03:00:00", "1988-10-16 04:00:00", "1989-01-29 03:00:00", 
"1989-10-15 04:00:00", "1990-02-11 03:00:00", "1990-10-21 04:00:00", 
"1991-02-17 03:00:00", "1991-10-20 04:00:00", "1992-02-09 03:00:00", 
"1992-10-25 04:00:00", "1993-01-31 03:00:00", "1993-10-17 04:00:00", 
"1994-02-20 03:00:00", "1994-10-16 04:00:00", "1995-02-19 03:00:00", 
"1995-10-15 04:00:00", "1996-02-11 03:00:00", "1996-10-06 04:00:00", 
"1997-02-16 03:00:00", "1997-10-06 04:00:00", "1998-03-01 03:00:00", 
"1998-10-11 04:00:00", "1999-02-21 03:00:00", "1999-10-03 04:00:00", 
"2000-02-27 03:00:00", "2000-10-08 04:00:00", "2001-02-18 03:00:00", 
"2001-10-14 04:00:00", "2002-02-17 03:00:00", "2002-11-03 04:00:00", 
"2003-02-16 03:00:00", "2003-10-19 04:00:00", "2004-02-15 03:00:00", 
"2004-11-02 04:00:00", "2005-02-20 03:00:00", "2005-10-16 04:00:00", 
"2006-02-19 03:00:00", "2006-11-05 04:00:00", "2007-02-25 03:00:00", 
"2007-10-14 04:00:00", "2008-02-17 03:00:00", "2008-10-19 04:00:00", 
"2009-02-15 03:00:00", "2009-10-18 04:00:00", "2010-02-21 03:00:00", 
"2010-10-17 04:00:00", "2011-02-20 03:00:00", "2011-10-16 04:00:00", 
"2012-02-26 03:00:00", "2012-10-21 04:00:00", "2013-02-17 03:00:00", 
"2013-10-20 04:00:00", "2014-02-16 03:00:00", "2014-10-19 04:00:00", 
"2015-02-22 03:00:00", "2015-10-18 04:00:00", "2016-02-21 03:00:00", 
"2016-10-16 04:00:00", "2017-02-19 03:00:00", "2017-10-15 04:00:00", 
"2018-02-18 03:00:00", "2018-10-21 04:00:00", "2019-02-17 03:00:00", 
"2019-10-20 04:00:00", "2020-02-16 03:00:00", "2020-10-18 04:00:00", 
"2021-02-21 03:00:00", "2021-10-17 04:00:00", "2022-02-20 03:00:00", 
"2022-10-16 04:00:00", "2023-02-26 03:00:00", "2023-10-15 04:00:00", 
"2024-02-18 03:00:00", "2024-10-20 04:00:00", "2025-02-16 03:00:00", 
"2025-10-19 04:00:00", "2026-02-22 03:00:00", "2026-10-18 04:00:00", 
"2027-02-21 03:00:00", "2027-10-17 04:00:00", "2028-02-20 03:00:00", 
"2028-10-15 04:00:00", "2029-02-18 03:00:00", "2029-10-21 04:00:00", 
"2030-02-17 03:00:00", "2030-10-20 04:00:00", "2031-02-16 03:00:00", 
"2031-10-19 04:00:00", "2032-02-15 03:00:00", "2032-10-17 04:00:00", 
"2033-02-20 03:00:00", "2033-10-16 04:00:00", "2034-02-26 03:00:00", 
"2034-10-15 04:00:00", "2035-02-18 03:00:00", "2035-10-21 04:00:00", 
"2036-02-17 03:00:00", "2036-10-19 04:00:00", "2037-02-22 03:00:00", 
"2037-10-18 04:00:00"), offSet = c(-13108L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L
), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L), TimeZone = c("LMT", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST"), 
    numeric = c(-2147397248, -1767212492, -1206954000, -1191358800, 
    -1175371200, -1159822800, -633816000, -622065600, -602280000, 
    -591829200, -570744000, -560206800, -539121600, -531349200, 
    -191361600, -184194000, -155160000, -150066000, -128894400, 
    -121122000, -99950400, -89586000, -68414400, -57963600, 499752000, 
    511239600, 530596800, 540270000, 562132800, 571201200, 592977600, 
    602046000, 624427200, 634705200, 656481600, 666759600, 687931200, 
    697604400, 719985600, 728449200, 750830400, 761713200, 782280000, 
    793162800, 813729600, 824007600, 844574400, 856062000, 876110400, 
    888721200, 908078400, 919566000, 938923200, 951620400, 970977600, 
    982465200, 1003032000, 1013914800, 1036296000, 1045364400, 
    1066536000, 1076814000, 1099368000, 1108868400, 1129435200, 
    1140318000, 1162699200, 1172372400, 1192334400, 1203217200, 
    1224388800, 1234666800, 1255838400, 1266721200, 1287288000, 
    1298170800, 1318737600, 1330225200, 1350792000, 1361070000, 
    1382241600, 1392519600, 1413691200, 1424574000, 1445140800, 
    1456023600, 1476590400, 1487473200, 1508040000, 1518922800, 
    1540094400, 1550372400, 1571544000, 1581822000, 1602993600, 
    1613876400, 1634443200, 1645326000, 1665892800, 1677380400, 
    1697342400, 1708225200, 1729396800, 1739674800, 1760846400, 
    1771729200, 1792296000, 1803178800, 1823745600, 1834628400, 
    1855195200, 1866078000, 1887249600, 1897527600, 1918699200, 
    1928977200, 1950148800, 1960426800, 1981598400, 1992481200, 
    2013048000, 2024535600, 2044497600, 2055380400, 2076552000, 
    2086830000, 2108001600, 2118884400, 2139451200)), .Names = c("Campo_Grande", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-129L), class = "data.frame")
}

"Cancun" <- function () {
structure(list(Cancun = c("1901-12-14 20:45:52", "1922-01-01 06:00:00", 
"1981-12-23 06:00:00", "1996-04-07 07:00:00", "1996-10-27 06:00:00", 
"1997-04-06 07:00:00", "1997-10-26 06:00:00", "1998-04-05 07:00:00", 
"1998-08-02 06:00:00", "1998-10-25 07:00:00", "1999-04-04 08:00:00", 
"1999-10-31 07:00:00", "2000-04-02 08:00:00", "2000-10-29 07:00:00", 
"2001-05-06 08:00:00", "2001-09-30 07:00:00", "2002-04-07 08:00:00", 
"2002-10-27 07:00:00", "2003-04-06 08:00:00", "2003-10-26 07:00:00", 
"2004-04-04 08:00:00", "2004-10-31 07:00:00", "2005-04-03 08:00:00", 
"2005-10-30 07:00:00", "2006-04-02 08:00:00", "2006-10-29 07:00:00", 
"2007-04-01 08:00:00", "2007-10-28 07:00:00", "2008-04-06 08:00:00", 
"2008-10-26 07:00:00", "2009-04-05 08:00:00", "2009-10-25 07:00:00", 
"2010-04-04 08:00:00", "2010-10-31 07:00:00", "2011-04-03 08:00:00", 
"2011-10-30 07:00:00", "2012-04-01 08:00:00", "2012-10-28 07:00:00", 
"2013-04-07 08:00:00", "2013-10-27 07:00:00", "2014-04-06 08:00:00", 
"2014-10-26 07:00:00", "2015-04-05 08:00:00", "2015-10-25 07:00:00", 
"2016-04-03 08:00:00", "2016-10-30 07:00:00", "2017-04-02 08:00:00", 
"2017-10-29 07:00:00", "2018-04-01 08:00:00", "2018-10-28 07:00:00", 
"2019-04-07 08:00:00", "2019-10-27 07:00:00", "2020-04-05 08:00:00", 
"2020-10-25 07:00:00", "2021-04-04 08:00:00", "2021-10-31 07:00:00", 
"2022-04-03 08:00:00", "2022-10-30 07:00:00", "2023-04-02 08:00:00", 
"2023-10-29 07:00:00", "2024-04-07 08:00:00", "2024-10-27 07:00:00", 
"2025-04-06 08:00:00", "2025-10-26 07:00:00", "2026-04-05 08:00:00", 
"2026-10-25 07:00:00", "2027-04-04 08:00:00", "2027-10-31 07:00:00", 
"2028-04-02 08:00:00", "2028-10-29 07:00:00", "2029-04-01 08:00:00", 
"2029-10-28 07:00:00", "2030-04-07 08:00:00", "2030-10-27 07:00:00", 
"2031-04-06 08:00:00", "2031-10-26 07:00:00", "2032-04-04 08:00:00", 
"2032-10-31 07:00:00", "2033-04-03 08:00:00", "2033-10-30 07:00:00", 
"2034-04-02 08:00:00", "2034-10-29 07:00:00", "2035-04-01 08:00:00", 
"2035-10-28 07:00:00", "2036-04-06 08:00:00", "2036-10-26 07:00:00", 
"2037-04-05 08:00:00", "2037-10-25 07:00:00"), offSet = c(-20824L, 
-21600L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 
0L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L), TimeZone = c("LMT", "CST", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST"), numeric = c(-2147397248, -1514743200, 377935200, 828860400, 
846396000, 860310000, 877845600, 891759600, 902037600, 909298800, 
923212800, 941353200, 954662400, 972802800, 989136000, 1001833200, 
1018166400, 1035702000, 1049616000, 1067151600, 1081065600, 1099206000, 
1112515200, 1130655600, 1143964800, 1162105200, 1175414400, 1193554800, 
1207468800, 1225004400, 1238918400, 1256454000, 1270368000, 1288508400, 
1301817600, 1319958000, 1333267200, 1351407600, 1365321600, 1382857200, 
1396771200, 1414306800, 1428220800, 1445756400, 1459670400, 1477810800, 
1491120000, 1509260400, 1522569600, 1540710000, 1554624000, 1572159600, 
1586073600, 1603609200, 1617523200, 1635663600, 1648972800, 1667113200, 
1680422400, 1698562800, 1712476800, 1730012400, 1743926400, 1761462000, 
1775376000, 1792911600, 1806825600, 1824966000, 1838275200, 1856415600, 
1869724800, 1887865200, 1901779200, 1919314800, 1933228800, 1950764400, 
1964678400, 1982818800, 1996128000, 2014268400, 2027577600, 2045718000, 
2059027200, 2077167600, 2091081600, 2108617200, 2122531200, 2140066800
)), .Names = c("Cancun", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -88L), class = "data.frame")
}

"Caracas" <- function () {
structure(list(Caracas = c("1901-12-14 20:45:52", "1912-02-12 04:27:40", 
"1965-01-01 04:30:00", "2007-12-09 07:00:00"), offSet = c(-16060L, 
-16200L, -14400L, -16200L), isdst = c(0L, 0L, 0L, 0L), TimeZone = c("CMT", 
"VET", "VET", "VET"), numeric = c(-2147397248, -1826739140, -157750200, 
1197183600)), .Names = c("Caracas", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"Cayenne" <- function () {
structure(list(Cayenne = c("1901-12-14 20:45:52", "1911-07-01 03:29:20", 
"1967-10-01 04:00:00"), offSet = c(-12560L, -14400L, -10800L), 
    isdst = c(0L, 0L, 0L), TimeZone = c("LMT", "GFT", "GFT"), 
    numeric = c(-2147397248, -1846269040, -71092800)), .Names = c("Cayenne", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-3L), class = "data.frame")
}

"Cayman" <- function () {
structure(list(Cayman = c("1901-12-14 20:45:52", "1912-02-01 05:07:12"
), offSet = c(-18432L, -18000L), isdst = c(0L, 0L), TimeZone = c("KMT", 
"EST"), numeric = c(-2147397248, -1827687168)), .Names = c("Cayman", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Chicago" <- function () {
structure(list(Chicago = c("1901-12-14 20:45:52", "1918-03-31 08:00:00", 
"1918-10-27 07:00:00", "1919-03-30 08:00:00", "1919-10-26 07:00:00", 
"1920-06-13 08:00:00", "1920-10-31 07:00:00", "1921-03-27 08:00:00", 
"1921-10-30 07:00:00", "1922-04-30 08:00:00", "1922-09-24 07:00:00", 
"1923-04-29 08:00:00", "1923-09-30 07:00:00", "1924-04-27 08:00:00", 
"1924-09-28 07:00:00", "1925-04-26 08:00:00", "1925-09-27 07:00:00", 
"1926-04-25 08:00:00", "1926-09-26 07:00:00", "1927-04-24 08:00:00", 
"1927-09-25 07:00:00", "1928-04-29 08:00:00", "1928-09-30 07:00:00", 
"1929-04-28 08:00:00", "1929-09-29 07:00:00", "1930-04-27 08:00:00", 
"1930-09-28 07:00:00", "1931-04-26 08:00:00", "1931-09-27 07:00:00", 
"1932-04-24 08:00:00", "1932-09-25 07:00:00", "1933-04-30 08:00:00", 
"1933-09-24 07:00:00", "1934-04-29 08:00:00", "1934-09-30 07:00:00", 
"1935-04-28 08:00:00", "1935-09-29 07:00:00", "1936-03-01 08:00:00", 
"1936-11-15 07:00:00", "1937-04-25 08:00:00", "1937-09-26 07:00:00", 
"1938-04-24 08:00:00", "1938-09-25 07:00:00", "1939-04-30 08:00:00", 
"1939-09-24 07:00:00", "1940-04-28 08:00:00", "1940-09-29 07:00:00", 
"1941-04-27 08:00:00", "1941-09-28 07:00:00", "1945-08-14 23:00:00", 
"1945-09-30 07:00:00", "1946-04-28 08:00:00", "1946-09-29 07:00:00", 
"1947-04-27 08:00:00", "1947-09-28 07:00:00", "1948-04-25 08:00:00", 
"1948-09-26 07:00:00", "1949-04-24 08:00:00", "1949-09-25 07:00:00", 
"1950-04-30 08:00:00", "1950-09-24 07:00:00", "1951-04-29 08:00:00", 
"1951-09-30 07:00:00", "1952-04-27 08:00:00", "1952-09-28 07:00:00", 
"1953-04-26 08:00:00", "1953-09-27 07:00:00", "1954-04-25 08:00:00", 
"1954-09-26 07:00:00", "1955-04-24 08:00:00", "1955-10-30 07:00:00", 
"1956-04-29 08:00:00", "1956-10-28 07:00:00", "1957-04-28 08:00:00", 
"1957-10-27 07:00:00", "1958-04-27 08:00:00", "1958-10-26 07:00:00", 
"1959-04-26 08:00:00", "1959-10-25 07:00:00", "1960-04-24 08:00:00", 
"1960-10-30 07:00:00", "1961-04-30 08:00:00", "1961-10-29 07:00:00", 
"1962-04-29 08:00:00", "1962-10-28 07:00:00", "1963-04-28 08:00:00", 
"1963-10-27 07:00:00", "1964-04-26 08:00:00", "1964-10-25 07:00:00", 
"1965-04-25 08:00:00", "1965-10-31 07:00:00", "1966-04-24 08:00:00", 
"1966-10-30 07:00:00", "1967-04-30 08:00:00", "1967-10-29 07:00:00", 
"1968-04-28 08:00:00", "1968-10-27 07:00:00", "1969-04-27 08:00:00", 
"1969-10-26 07:00:00", "1970-04-26 08:00:00", "1970-10-25 07:00:00", 
"1971-04-25 08:00:00", "1971-10-31 07:00:00", "1972-04-30 08:00:00", 
"1972-10-29 07:00:00", "1973-04-29 08:00:00", "1973-10-28 07:00:00", 
"1974-01-06 08:00:00", "1974-10-27 07:00:00", "1975-02-23 08:00:00", 
"1975-10-26 07:00:00", "1976-04-25 08:00:00", "1976-10-31 07:00:00", 
"1977-04-24 08:00:00", "1977-10-30 07:00:00", "1978-04-30 08:00:00", 
"1978-10-29 07:00:00", "1979-04-29 08:00:00", "1979-10-28 07:00:00", 
"1980-04-27 08:00:00", "1980-10-26 07:00:00", "1981-04-26 08:00:00", 
"1981-10-25 07:00:00", "1982-04-25 08:00:00", "1982-10-31 07:00:00", 
"1983-04-24 08:00:00", "1983-10-30 07:00:00", "1984-04-29 08:00:00", 
"1984-10-28 07:00:00", "1985-04-28 08:00:00", "1985-10-27 07:00:00", 
"1986-04-27 08:00:00", "1986-10-26 07:00:00", "1987-04-05 08:00:00", 
"1987-10-25 07:00:00", "1988-04-03 08:00:00", "1988-10-30 07:00:00", 
"1989-04-02 08:00:00", "1989-10-29 07:00:00", "1990-04-01 08:00:00", 
"1990-10-28 07:00:00", "1991-04-07 08:00:00", "1991-10-27 07:00:00", 
"1992-04-05 08:00:00", "1992-10-25 07:00:00", "1993-04-04 08:00:00", 
"1993-10-31 07:00:00", "1994-04-03 08:00:00", "1994-10-30 07:00:00", 
"1995-04-02 08:00:00", "1995-10-29 07:00:00", "1996-04-07 08:00:00", 
"1996-10-27 07:00:00", "1997-04-06 08:00:00", "1997-10-26 07:00:00", 
"1998-04-05 08:00:00", "1998-10-25 07:00:00", "1999-04-04 08:00:00", 
"1999-10-31 07:00:00", "2000-04-02 08:00:00", "2000-10-29 07:00:00", 
"2001-04-01 08:00:00", "2001-10-28 07:00:00", "2002-04-07 08:00:00", 
"2002-10-27 07:00:00", "2003-04-06 08:00:00", "2003-10-26 07:00:00", 
"2004-04-04 08:00:00", "2004-10-31 07:00:00", "2005-04-03 08:00:00", 
"2005-10-30 07:00:00", "2006-04-02 08:00:00", "2006-10-29 07:00:00", 
"2007-03-11 08:00:00", "2007-11-04 07:00:00", "2008-03-09 08:00:00", 
"2008-11-02 07:00:00", "2009-03-08 08:00:00", "2009-11-01 07:00:00", 
"2010-03-14 08:00:00", "2010-11-07 07:00:00", "2011-03-13 08:00:00", 
"2011-11-06 07:00:00", "2012-03-11 08:00:00", "2012-11-04 07:00:00", 
"2013-03-10 08:00:00", "2013-11-03 07:00:00", "2014-03-09 08:00:00", 
"2014-11-02 07:00:00", "2015-03-08 08:00:00", "2015-11-01 07:00:00", 
"2016-03-13 08:00:00", "2016-11-06 07:00:00", "2017-03-12 08:00:00", 
"2017-11-05 07:00:00", "2018-03-11 08:00:00", "2018-11-04 07:00:00", 
"2019-03-10 08:00:00", "2019-11-03 07:00:00", "2020-03-08 08:00:00", 
"2020-11-01 07:00:00", "2021-03-14 08:00:00", "2021-11-07 07:00:00", 
"2022-03-13 08:00:00", "2022-11-06 07:00:00", "2023-03-12 08:00:00", 
"2023-11-05 07:00:00", "2024-03-10 08:00:00", "2024-11-03 07:00:00", 
"2025-03-09 08:00:00", "2025-11-02 07:00:00", "2026-03-08 08:00:00", 
"2026-11-01 07:00:00", "2027-03-14 08:00:00", "2027-11-07 07:00:00", 
"2028-03-12 08:00:00", "2028-11-05 07:00:00", "2029-03-11 08:00:00", 
"2029-11-04 07:00:00", "2030-03-10 08:00:00", "2030-11-03 07:00:00", 
"2031-03-09 08:00:00", "2031-11-02 07:00:00", "2032-03-14 08:00:00", 
"2032-11-07 07:00:00", "2033-03-13 08:00:00", "2033-11-06 07:00:00", 
"2034-03-12 08:00:00", "2034-11-05 07:00:00", "2035-03-11 08:00:00", 
"2035-11-04 07:00:00", "2036-03-09 08:00:00", "2036-11-02 07:00:00", 
"2037-03-08 08:00:00", "2037-11-01 07:00:00"), offSet = c(-21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L), TimeZone = c("CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "EST", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CPT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST"), numeric = c(-2147397248, 
-1633276800, -1615136400, -1601827200, -1583686800, -1563724800, 
-1551632400, -1538928000, -1520182800, -1504454400, -1491757200, 
-1473004800, -1459702800, -1441555200, -1428253200, -1410105600, 
-1396803600, -1378656000, -1365354000, -1347206400, -1333904400, 
-1315152000, -1301850000, -1283702400, -1270400400, -1252252800, 
-1238950800, -1220803200, -1207501200, -1189353600, -1176051600, 
-1157299200, -1144602000, -1125849600, -1112547600, -1094400000, 
-1081098000, -1067788800, -1045414800, -1031500800, -1018198800, 
-1000051200, -986749200, -967996800, -955299600, -936547200, 
-923245200, -905097600, -891795600, -769395600, -765392400, -747244800, 
-733942800, -715795200, -702493200, -684345600, -671043600, -652896000, 
-639594000, -620841600, -608144400, -589392000, -576090000, -557942400, 
-544640400, -526492800, -513190800, -495043200, -481741200, -463593600, 
-447267600, -431539200, -415818000, -400089600, -384368400, -368640000, 
-352918800, -337190400, -321469200, -305740800, -289414800, -273686400, 
-257965200, -242236800, -226515600, -210787200, -195066000, -179337600, 
-163616400, -147888000, -131562000, -116438400, -100112400, -84384000, 
-68662800, -52934400, -37213200, -21484800, -5763600, 9964800, 
25686000, 41414400, 57740400, 73468800, 89190000, 104918400, 
120639600, 126691200, 152089200, 162374400, 183538800, 199267200, 
215593200, 230716800, 247042800, 262771200, 278492400, 294220800, 
309942000, 325670400, 341391600, 357120000, 372841200, 388569600, 
404895600, 420019200, 436345200, 452073600, 467794800, 483523200, 
499244400, 514972800, 530694000, 544608000, 562143600, 576057600, 
594198000, 607507200, 625647600, 638956800, 657097200, 671011200, 
688546800, 702460800, 719996400, 733910400, 752050800, 765360000, 
783500400, 796809600, 814950000, 828864000, 846399600, 860313600, 
877849200, 891763200, 909298800, 923212800, 941353200, 954662400, 
972802800, 986112000, 1004252400, 1018166400, 1035702000, 1049616000, 
1067151600, 1081065600, 1099206000, 1112515200, 1130655600, 1143964800, 
1162105200, 1173600000, 1194159600, 1205049600, 1225609200, 1236499200, 
1257058800, 1268553600, 1289113200, 1300003200, 1320562800, 1331452800, 
1352012400, 1362902400, 1383462000, 1394352000, 1414911600, 1425801600, 
1446361200, 1457856000, 1478415600, 1489305600, 1509865200, 1520755200, 
1541314800, 1552204800, 1572764400, 1583654400, 1604214000, 1615708800, 
1636268400, 1647158400, 1667718000, 1678608000, 1699167600, 1710057600, 
1730617200, 1741507200, 1762066800, 1772956800, 1793516400, 1805011200, 
1825570800, 1836460800, 1857020400, 1867910400, 1888470000, 1899360000, 
1919919600, 1930809600, 1951369200, 1962864000, 1983423600, 1994313600, 
2014873200, 2025763200, 2046322800, 2057212800, 2077772400, 2088662400, 
2109222000, 2120112000, 2140671600)), .Names = c("Chicago", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -235L), class = "data.frame")
}

"Chihuahua" <- function () {
structure(list(Chihuahua = c("1901-12-14 20:45:52", "1922-01-01 07:00:00", 
"1927-06-11 06:00:00", "1930-11-15 06:00:00", "1931-05-02 06:00:00", 
"1931-10-01 06:00:00", "1932-04-01 07:00:00", "1996-04-07 08:00:00", 
"1996-10-27 07:00:00", "1997-04-06 08:00:00", "1998-04-05 09:00:00", 
"1998-10-25 08:00:00", "1999-04-04 09:00:00", "1999-10-31 08:00:00", 
"2000-04-02 09:00:00", "2000-10-29 08:00:00", "2001-05-06 09:00:00", 
"2001-09-30 08:00:00", "2002-04-07 09:00:00", "2002-10-27 08:00:00", 
"2003-04-06 09:00:00", "2003-10-26 08:00:00", "2004-04-04 09:00:00", 
"2004-10-31 08:00:00", "2005-04-03 09:00:00", "2005-10-30 08:00:00", 
"2006-04-02 09:00:00", "2006-10-29 08:00:00", "2007-04-01 09:00:00", 
"2007-10-28 08:00:00", "2008-04-06 09:00:00", "2008-10-26 08:00:00", 
"2009-04-05 09:00:00", "2009-10-25 08:00:00", "2010-04-04 09:00:00", 
"2010-10-31 08:00:00", "2011-04-03 09:00:00", "2011-10-30 08:00:00", 
"2012-04-01 09:00:00", "2012-10-28 08:00:00", "2013-04-07 09:00:00", 
"2013-10-27 08:00:00", "2014-04-06 09:00:00", "2014-10-26 08:00:00", 
"2015-04-05 09:00:00", "2015-10-25 08:00:00", "2016-04-03 09:00:00", 
"2016-10-30 08:00:00", "2017-04-02 09:00:00", "2017-10-29 08:00:00", 
"2018-04-01 09:00:00", "2018-10-28 08:00:00", "2019-04-07 09:00:00", 
"2019-10-27 08:00:00", "2020-04-05 09:00:00", "2020-10-25 08:00:00", 
"2021-04-04 09:00:00", "2021-10-31 08:00:00", "2022-04-03 09:00:00", 
"2022-10-30 08:00:00", "2023-04-02 09:00:00", "2023-10-29 08:00:00", 
"2024-04-07 09:00:00", "2024-10-27 08:00:00", "2025-04-06 09:00:00", 
"2025-10-26 08:00:00", "2026-04-05 09:00:00", "2026-10-25 08:00:00", 
"2027-04-04 09:00:00", "2027-10-31 08:00:00", "2028-04-02 09:00:00", 
"2028-10-29 08:00:00", "2029-04-01 09:00:00", "2029-10-28 08:00:00", 
"2030-04-07 09:00:00", "2030-10-27 08:00:00", "2031-04-06 09:00:00", 
"2031-10-26 08:00:00", "2032-04-04 09:00:00", "2032-10-31 08:00:00", 
"2033-04-03 09:00:00", "2033-10-30 08:00:00", "2034-04-02 09:00:00", 
"2034-10-29 08:00:00", "2035-04-01 09:00:00", "2035-10-28 08:00:00", 
"2036-04-06 09:00:00", "2036-10-26 08:00:00", "2037-04-05 09:00:00", 
"2037-10-25 08:00:00"), offSet = c(-25460L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L), isdst = c(0L, 0L, 0L, 0L, 0L, 0L, 
0L, 1L, 0L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L), TimeZone = c("LMT", "MST", "CST", "MST", "CST", 
"MST", "CST", "CDT", "CST", "CDT", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST"), numeric = c(-2147397248, -1514739600, 
-1343066400, -1234807200, -1220292000, -1207159200, -1191344400, 
828864000, 846399600, 860313600, 891766800, 909302400, 923216400, 
941356800, 954666000, 972806400, 989139600, 1001836800, 1018170000, 
1035705600, 1049619600, 1067155200, 1081069200, 1099209600, 1112518800, 
1130659200, 1143968400, 1162108800, 1175418000, 1193558400, 1207472400, 
1225008000, 1238922000, 1256457600, 1270371600, 1288512000, 1301821200, 
1319961600, 1333270800, 1351411200, 1365325200, 1382860800, 1396774800, 
1414310400, 1428224400, 1445760000, 1459674000, 1477814400, 1491123600, 
1509264000, 1522573200, 1540713600, 1554627600, 1572163200, 1586077200, 
1603612800, 1617526800, 1635667200, 1648976400, 1667116800, 1680426000, 
1698566400, 1712480400, 1730016000, 1743930000, 1761465600, 1775379600, 
1792915200, 1806829200, 1824969600, 1838278800, 1856419200, 1869728400, 
1887868800, 1901782800, 1919318400, 1933232400, 1950768000, 1964682000, 
1982822400, 1996131600, 2014272000, 2027581200, 2045721600, 2059030800, 
2077171200, 2091085200, 2108620800, 2122534800, 2140070400)), .Names = c("Chihuahua", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-90L), class = "data.frame")
}

"Costa_Rica" <- function () {
structure(list(Costa_Rica = c("1901-12-14 20:45:52", "1921-01-15 05:36:20", 
"1979-02-25 06:00:00", "1979-06-03 05:00:00", "1980-02-24 06:00:00", 
"1980-06-01 05:00:00", "1991-01-19 06:00:00", "1991-07-01 05:00:00", 
"1992-01-18 06:00:00", "1992-03-15 05:00:00"), offSet = c(-20180L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L), TimeZone = c("SJMT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST"), numeric = c(-2147397248, -1545071020, 
288770400, 297234000, 320220000, 328683600, 664264800, 678344400, 
695714400, 700635600)), .Names = c("Costa_Rica", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -10L), class = "data.frame")
}

"Cuiaba" <- function () {
structure(list(Cuiaba = c("1901-12-14 20:45:52", "1914-01-01 03:44:20", 
"1931-10-03 15:00:00", "1932-04-01 03:00:00", "1932-10-03 04:00:00", 
"1933-04-01 03:00:00", "1949-12-01 04:00:00", "1950-04-16 04:00:00", 
"1950-12-01 04:00:00", "1951-04-01 03:00:00", "1951-12-01 04:00:00", 
"1952-04-01 03:00:00", "1952-12-01 04:00:00", "1953-03-01 03:00:00", 
"1963-12-09 04:00:00", "1964-03-01 03:00:00", "1965-01-31 04:00:00", 
"1965-03-31 03:00:00", "1965-12-01 04:00:00", "1966-03-01 03:00:00", 
"1966-11-01 04:00:00", "1967-03-01 03:00:00", "1967-11-01 04:00:00", 
"1968-03-01 03:00:00", "1985-11-02 04:00:00", "1986-03-15 03:00:00", 
"1986-10-25 04:00:00", "1987-02-14 03:00:00", "1987-10-25 04:00:00", 
"1988-02-07 03:00:00", "1988-10-16 04:00:00", "1989-01-29 03:00:00", 
"1989-10-15 04:00:00", "1990-02-11 03:00:00", "1990-10-21 04:00:00", 
"1991-02-17 03:00:00", "1991-10-20 04:00:00", "1992-02-09 03:00:00", 
"1992-10-25 04:00:00", "1993-01-31 03:00:00", "1993-10-17 04:00:00", 
"1994-02-20 03:00:00", "1994-10-16 04:00:00", "1995-02-19 03:00:00", 
"1995-10-15 04:00:00", "1996-02-11 03:00:00", "1996-10-06 04:00:00", 
"1997-02-16 03:00:00", "1997-10-06 04:00:00", "1998-03-01 03:00:00", 
"1998-10-11 04:00:00", "1999-02-21 03:00:00", "1999-10-03 04:00:00", 
"2000-02-27 03:00:00", "2000-10-08 04:00:00", "2001-02-18 03:00:00", 
"2001-10-14 04:00:00", "2002-02-17 03:00:00", "2002-11-03 04:00:00", 
"2003-02-16 03:00:00", "2004-11-02 04:00:00", "2005-02-20 03:00:00", 
"2005-10-16 04:00:00", "2006-02-19 03:00:00", "2006-11-05 04:00:00", 
"2007-02-25 03:00:00", "2007-10-14 04:00:00", "2008-02-17 03:00:00", 
"2008-10-19 04:00:00", "2009-02-15 03:00:00", "2009-10-18 04:00:00", 
"2010-02-21 03:00:00", "2010-10-17 04:00:00", "2011-02-20 03:00:00", 
"2011-10-16 04:00:00", "2012-02-26 03:00:00", "2012-10-21 04:00:00", 
"2013-02-17 03:00:00", "2013-10-20 04:00:00", "2014-02-16 03:00:00", 
"2014-10-19 04:00:00", "2015-02-22 03:00:00", "2015-10-18 04:00:00", 
"2016-02-21 03:00:00", "2016-10-16 04:00:00", "2017-02-19 03:00:00", 
"2017-10-15 04:00:00", "2018-02-18 03:00:00", "2018-10-21 04:00:00", 
"2019-02-17 03:00:00", "2019-10-20 04:00:00", "2020-02-16 03:00:00", 
"2020-10-18 04:00:00", "2021-02-21 03:00:00", "2021-10-17 04:00:00", 
"2022-02-20 03:00:00", "2022-10-16 04:00:00", "2023-02-26 03:00:00", 
"2023-10-15 04:00:00", "2024-02-18 03:00:00", "2024-10-20 04:00:00", 
"2025-02-16 03:00:00", "2025-10-19 04:00:00", "2026-02-22 03:00:00", 
"2026-10-18 04:00:00", "2027-02-21 03:00:00", "2027-10-17 04:00:00", 
"2028-02-20 03:00:00", "2028-10-15 04:00:00", "2029-02-18 03:00:00", 
"2029-10-21 04:00:00", "2030-02-17 03:00:00", "2030-10-20 04:00:00", 
"2031-02-16 03:00:00", "2031-10-19 04:00:00", "2032-02-15 03:00:00", 
"2032-10-17 04:00:00", "2033-02-20 03:00:00", "2033-10-16 04:00:00", 
"2034-02-26 03:00:00", "2034-10-15 04:00:00", "2035-02-18 03:00:00", 
"2035-10-21 04:00:00", "2036-02-17 03:00:00", "2036-10-19 04:00:00", 
"2037-02-22 03:00:00", "2037-10-18 04:00:00"), offSet = c(-13460L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L
), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L), TimeZone = c("LMT", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST"), numeric = c(-2147397248, 
-1767212140, -1206954000, -1191358800, -1175371200, -1159822800, 
-633816000, -622065600, -602280000, -591829200, -570744000, -560206800, 
-539121600, -531349200, -191361600, -184194000, -155160000, -150066000, 
-128894400, -121122000, -99950400, -89586000, -68414400, -57963600, 
499752000, 511239600, 530596800, 540270000, 562132800, 571201200, 
592977600, 602046000, 624427200, 634705200, 656481600, 666759600, 
687931200, 697604400, 719985600, 728449200, 750830400, 761713200, 
782280000, 793162800, 813729600, 824007600, 844574400, 856062000, 
876110400, 888721200, 908078400, 919566000, 938923200, 951620400, 
970977600, 982465200, 1003032000, 1013914800, 1036296000, 1045364400, 
1099368000, 1108868400, 1129435200, 1140318000, 1162699200, 1172372400, 
1192334400, 1203217200, 1224388800, 1234666800, 1255838400, 1266721200, 
1287288000, 1298170800, 1318737600, 1330225200, 1350792000, 1361070000, 
1382241600, 1392519600, 1413691200, 1424574000, 1445140800, 1456023600, 
1476590400, 1487473200, 1508040000, 1518922800, 1540094400, 1550372400, 
1571544000, 1581822000, 1602993600, 1613876400, 1634443200, 1645326000, 
1665892800, 1677380400, 1697342400, 1708225200, 1729396800, 1739674800, 
1760846400, 1771729200, 1792296000, 1803178800, 1823745600, 1834628400, 
1855195200, 1866078000, 1887249600, 1897527600, 1918699200, 1928977200, 
1950148800, 1960426800, 1981598400, 1992481200, 2013048000, 2024535600, 
2044497600, 2055380400, 2076552000, 2086830000, 2108001600, 2118884400, 
2139451200)), .Names = c("Cuiaba", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -127L), class = "data.frame")
}

"Curacao" <- function () {
structure(list(Curacao = c("1901-12-14 20:45:52", "1912-02-12 04:35:44", 
"1965-01-01 04:30:00"), offSet = c(-16544L, -16200L, -14400L), 
    isdst = c(0L, 0L, 0L), TimeZone = c("LMT", "ANT", "AST"), 
    numeric = c(-2147397248, -1826738656, -157750200)), .Names = c("Curacao", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-3L), class = "data.frame")
}

"Danmarkshavn" <- function () {
structure(list(Danmarkshavn = c("1901-12-14 20:45:52", "1916-07-28 01:14:40", 
"1980-04-06 05:00:00", "1980-09-28 01:00:00", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-01-01 03:00:00"
), offSet = c(-4480L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, 0L), isdst = c(0L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L
), TimeZone = c("LMT", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", 
"WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", 
"WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", 
"WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", 
"GMT"), numeric = c(-2147397248, -1686091520, 323845200, 338950800, 
354675600, 370400400, 386125200, 401850000, 417574800, 433299600, 
449024400, 465354000, 481078800, 496803600, 512528400, 528253200, 
543978000, 559702800, 575427600, 591152400, 606877200, 622602000, 
638326800, 654656400, 670381200, 686106000, 701830800, 717555600, 
733280400, 749005200, 764730000, 780454800, 796179600, 811904400, 
820465200)), .Names = c("Danmarkshavn", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -35L), class = "data.frame")
}

"Dawson" <- function () {
structure(list(Dawson = c("1901-12-14 20:45:52", "1918-04-14 11:00:00", 
"1918-10-27 10:00:00", "1919-05-25 11:00:00", "1919-11-01 08:00:00", 
"1945-08-14 23:00:00", "1945-09-30 10:00:00", "1965-04-25 09:00:00", 
"1965-10-31 09:00:00", "1973-10-28 09:00:00", "1980-04-27 10:00:00", 
"1980-10-26 09:00:00", "1981-04-26 10:00:00", "1981-10-25 09:00:00", 
"1982-04-25 10:00:00", "1982-10-31 09:00:00", "1983-04-24 10:00:00", 
"1983-10-30 09:00:00", "1984-04-29 10:00:00", "1984-10-28 09:00:00", 
"1985-04-28 10:00:00", "1985-10-27 09:00:00", "1986-04-27 10:00:00", 
"1986-10-26 09:00:00", "1987-04-05 10:00:00", "1987-10-25 09:00:00", 
"1988-04-03 10:00:00", "1988-10-30 09:00:00", "1989-04-02 10:00:00", 
"1989-10-29 09:00:00", "1990-04-01 10:00:00", "1990-10-28 09:00:00", 
"1991-04-07 10:00:00", "1991-10-27 09:00:00", "1992-04-05 10:00:00", 
"1992-10-25 09:00:00", "1993-04-04 10:00:00", "1993-10-31 09:00:00", 
"1994-04-03 10:00:00", "1994-10-30 09:00:00", "1995-04-02 10:00:00", 
"1995-10-29 09:00:00", "1996-04-07 10:00:00", "1996-10-27 09:00:00", 
"1997-04-06 10:00:00", "1997-10-26 09:00:00", "1998-04-05 10:00:00", 
"1998-10-25 09:00:00", "1999-04-04 10:00:00", "1999-10-31 09:00:00", 
"2000-04-02 10:00:00", "2000-10-29 09:00:00", "2001-04-01 10:00:00", 
"2001-10-28 09:00:00", "2002-04-07 10:00:00", "2002-10-27 09:00:00", 
"2003-04-06 10:00:00", "2003-10-26 09:00:00", "2004-04-04 10:00:00", 
"2004-10-31 09:00:00", "2005-04-03 10:00:00", "2005-10-30 09:00:00", 
"2006-04-02 10:00:00", "2006-10-29 09:00:00", "2007-03-11 10:00:00", 
"2007-11-04 09:00:00", "2008-03-09 10:00:00", "2008-11-02 09:00:00", 
"2009-03-08 10:00:00", "2009-11-01 09:00:00", "2010-03-14 10:00:00", 
"2010-11-07 09:00:00", "2011-03-13 10:00:00", "2011-11-06 09:00:00", 
"2012-03-11 10:00:00", "2012-11-04 09:00:00", "2013-03-10 10:00:00", 
"2013-11-03 09:00:00", "2014-03-09 10:00:00", "2014-11-02 09:00:00", 
"2015-03-08 10:00:00", "2015-11-01 09:00:00", "2016-03-13 10:00:00", 
"2016-11-06 09:00:00", "2017-03-12 10:00:00", "2017-11-05 09:00:00", 
"2018-03-11 10:00:00", "2018-11-04 09:00:00", "2019-03-10 10:00:00", 
"2019-11-03 09:00:00", "2020-03-08 10:00:00", "2020-11-01 09:00:00", 
"2021-03-14 10:00:00", "2021-11-07 09:00:00", "2022-03-13 10:00:00", 
"2022-11-06 09:00:00", "2023-03-12 10:00:00", "2023-11-05 09:00:00", 
"2024-03-10 10:00:00", "2024-11-03 09:00:00", "2025-03-09 10:00:00", 
"2025-11-02 09:00:00", "2026-03-08 10:00:00", "2026-11-01 09:00:00", 
"2027-03-14 10:00:00", "2027-11-07 09:00:00", "2028-03-12 10:00:00", 
"2028-11-05 09:00:00", "2029-03-11 10:00:00", "2029-11-04 09:00:00", 
"2030-03-10 10:00:00", "2030-11-03 09:00:00", "2031-03-09 10:00:00", 
"2031-11-02 09:00:00", "2032-03-14 10:00:00", "2032-11-07 09:00:00", 
"2033-03-13 10:00:00", "2033-11-06 09:00:00", "2034-03-12 10:00:00", 
"2034-11-05 09:00:00", "2035-03-11 10:00:00", "2035-11-04 09:00:00", 
"2036-03-09 10:00:00", "2036-11-02 09:00:00", "2037-03-08 10:00:00", 
"2037-11-01 09:00:00"), offSet = c(-32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -25200L, -32400L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L), isdst = c(0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("YST", 
"YDT", "YST", "YDT", "YST", "YPT", "YST", "YDDT", "YST", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST"), numeric = c(-2147397248, 
-1632056400, -1615125600, -1596978000, -1583164800, -769395600, 
-765381600, -147884400, -131554800, 120646800, 325677600, 341398800, 
357127200, 372848400, 388576800, 404902800, 420026400, 436352400, 
452080800, 467802000, 483530400, 499251600, 514980000, 530701200, 
544615200, 562150800, 576064800, 594205200, 607514400, 625654800, 
638964000, 657104400, 671018400, 688554000, 702468000, 720003600, 
733917600, 752058000, 765367200, 783507600, 796816800, 814957200, 
828871200, 846406800, 860320800, 877856400, 891770400, 909306000, 
923220000, 941360400, 954669600, 972810000, 986119200, 1004259600, 
1018173600, 1035709200, 1049623200, 1067158800, 1081072800, 1099213200, 
1112522400, 1130662800, 1143972000, 1162112400, 1173607200, 1194166800, 
1205056800, 1225616400, 1236506400, 1257066000, 1268560800, 1289120400, 
1300010400, 1320570000, 1331460000, 1352019600, 1362909600, 1383469200, 
1394359200, 1414918800, 1425808800, 1446368400, 1457863200, 1478422800, 
1489312800, 1509872400, 1520762400, 1541322000, 1552212000, 1572771600, 
1583661600, 1604221200, 1615716000, 1636275600, 1647165600, 1667725200, 
1678615200, 1699174800, 1710064800, 1730624400, 1741514400, 1762074000, 
1772964000, 1793523600, 1805018400, 1825578000, 1836468000, 1857027600, 
1867917600, 1888477200, 1899367200, 1919926800, 1930816800, 1951376400, 
1962871200, 1983430800, 1994320800, 2014880400, 2025770400, 2046330000, 
2057220000, 2077779600, 2088669600, 2109229200, 2120119200, 2140678800
)), .Names = c("Dawson", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -126L), class = "data.frame")
}

"Dawson_Creek" <- function () {
structure(list(Dawson_Creek = c("1901-12-14 20:45:52", "1918-04-14 10:00:00", 
"1918-10-31 09:00:00", "1945-08-14 23:00:00", "1945-09-30 09:00:00", 
"1947-04-27 10:00:00", "1947-09-28 09:00:00", "1948-04-25 10:00:00", 
"1948-09-26 09:00:00", "1949-04-24 10:00:00", "1949-09-25 09:00:00", 
"1950-04-30 10:00:00", "1950-09-24 09:00:00", "1951-04-29 10:00:00", 
"1951-09-30 09:00:00", "1952-04-27 10:00:00", "1952-09-28 09:00:00", 
"1953-04-26 10:00:00", "1953-09-27 09:00:00", "1954-04-25 10:00:00", 
"1954-09-26 09:00:00", "1955-04-24 10:00:00", "1955-09-25 09:00:00", 
"1956-04-29 10:00:00", "1956-09-30 09:00:00", "1957-04-28 10:00:00", 
"1957-09-29 09:00:00", "1958-04-27 10:00:00", "1958-09-28 09:00:00", 
"1959-04-26 10:00:00", "1959-09-27 09:00:00", "1960-04-24 10:00:00", 
"1960-09-25 09:00:00", "1961-04-30 10:00:00", "1961-09-24 09:00:00", 
"1962-04-29 10:00:00", "1962-10-28 09:00:00", "1963-04-28 10:00:00", 
"1963-10-27 09:00:00", "1964-04-26 10:00:00", "1964-10-25 09:00:00", 
"1965-04-25 10:00:00", "1965-10-31 09:00:00", "1966-04-24 10:00:00", 
"1966-10-30 09:00:00", "1967-04-30 10:00:00", "1967-10-29 09:00:00", 
"1968-04-28 10:00:00", "1968-10-27 09:00:00", "1969-04-27 10:00:00", 
"1969-10-26 09:00:00", "1970-04-26 10:00:00", "1970-10-25 09:00:00", 
"1971-04-25 10:00:00", "1971-10-31 09:00:00", "1972-04-30 10:00:00"
), offSet = c(-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L), TimeZone = c("PST", 
"PDT", "PST", "PPT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT"), numeric = c(-2147397248, -1632060000, -1614783600, -769395600, 
-765385200, -715788000, -702486000, -684338400, -671036400, -652888800, 
-639586800, -620834400, -608137200, -589384800, -576082800, -557935200, 
-544633200, -526485600, -513183600, -495036000, -481734000, -463586400, 
-450284400, -431532000, -418230000, -400082400, -386780400, -368632800, 
-355330800, -337183200, -323881200, -305733600, -292431600, -273679200, 
-260982000, -242229600, -226508400, -210780000, -195058800, -179330400, 
-163609200, -147880800, -131554800, -116431200, -100105200, -84376800, 
-68655600, -52927200, -37206000, -21477600, -5756400, 9972000, 
25693200, 41421600, 57747600, 73476000)), .Names = c("Dawson_Creek", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-56L), class = "data.frame")
}

"Denver" <- function () {
structure(list(Denver = c("1901-12-14 20:45:52", "1918-03-31 09:00:00", 
"1918-10-27 08:00:00", "1919-03-30 09:00:00", "1919-10-26 08:00:00", 
"1920-03-28 09:00:00", "1920-10-31 08:00:00", "1921-03-27 09:00:00", 
"1921-05-22 08:00:00", "1945-08-14 23:00:00", "1945-09-30 08:00:00", 
"1965-04-25 09:00:00", "1965-10-31 08:00:00", "1966-04-24 09:00:00", 
"1966-10-30 08:00:00", "1967-04-30 09:00:00", "1967-10-29 08:00:00", 
"1968-04-28 09:00:00", "1968-10-27 08:00:00", "1969-04-27 09:00:00", 
"1969-10-26 08:00:00", "1970-04-26 09:00:00", "1970-10-25 08:00:00", 
"1971-04-25 09:00:00", "1971-10-31 08:00:00", "1972-04-30 09:00:00", 
"1972-10-29 08:00:00", "1973-04-29 09:00:00", "1973-10-28 08:00:00", 
"1974-01-06 09:00:00", "1974-10-27 08:00:00", "1975-02-23 09:00:00", 
"1975-10-26 08:00:00", "1976-04-25 09:00:00", "1976-10-31 08:00:00", 
"1977-04-24 09:00:00", "1977-10-30 08:00:00", "1978-04-30 09:00:00", 
"1978-10-29 08:00:00", "1979-04-29 09:00:00", "1979-10-28 08:00:00", 
"1980-04-27 09:00:00", "1980-10-26 08:00:00", "1981-04-26 09:00:00", 
"1981-10-25 08:00:00", "1982-04-25 09:00:00", "1982-10-31 08:00:00", 
"1983-04-24 09:00:00", "1983-10-30 08:00:00", "1984-04-29 09:00:00", 
"1984-10-28 08:00:00", "1985-04-28 09:00:00", "1985-10-27 08:00:00", 
"1986-04-27 09:00:00", "1986-10-26 08:00:00", "1987-04-05 09:00:00", 
"1987-10-25 08:00:00", "1988-04-03 09:00:00", "1988-10-30 08:00:00", 
"1989-04-02 09:00:00", "1989-10-29 08:00:00", "1990-04-01 09:00:00", 
"1990-10-28 08:00:00", "1991-04-07 09:00:00", "1991-10-27 08:00:00", 
"1992-04-05 09:00:00", "1992-10-25 08:00:00", "1993-04-04 09:00:00", 
"1993-10-31 08:00:00", "1994-04-03 09:00:00", "1994-10-30 08:00:00", 
"1995-04-02 09:00:00", "1995-10-29 08:00:00", "1996-04-07 09:00:00", 
"1996-10-27 08:00:00", "1997-04-06 09:00:00", "1997-10-26 08:00:00", 
"1998-04-05 09:00:00", "1998-10-25 08:00:00", "1999-04-04 09:00:00", 
"1999-10-31 08:00:00", "2000-04-02 09:00:00", "2000-10-29 08:00:00", 
"2001-04-01 09:00:00", "2001-10-28 08:00:00", "2002-04-07 09:00:00", 
"2002-10-27 08:00:00", "2003-04-06 09:00:00", "2003-10-26 08:00:00", 
"2004-04-04 09:00:00", "2004-10-31 08:00:00", "2005-04-03 09:00:00", 
"2005-10-30 08:00:00", "2006-04-02 09:00:00", "2006-10-29 08:00:00", 
"2007-03-11 09:00:00", "2007-11-04 08:00:00", "2008-03-09 09:00:00", 
"2008-11-02 08:00:00", "2009-03-08 09:00:00", "2009-11-01 08:00:00", 
"2010-03-14 09:00:00", "2010-11-07 08:00:00", "2011-03-13 09:00:00", 
"2011-11-06 08:00:00", "2012-03-11 09:00:00", "2012-11-04 08:00:00", 
"2013-03-10 09:00:00", "2013-11-03 08:00:00", "2014-03-09 09:00:00", 
"2014-11-02 08:00:00", "2015-03-08 09:00:00", "2015-11-01 08:00:00", 
"2016-03-13 09:00:00", "2016-11-06 08:00:00", "2017-03-12 09:00:00", 
"2017-11-05 08:00:00", "2018-03-11 09:00:00", "2018-11-04 08:00:00", 
"2019-03-10 09:00:00", "2019-11-03 08:00:00", "2020-03-08 09:00:00", 
"2020-11-01 08:00:00", "2021-03-14 09:00:00", "2021-11-07 08:00:00", 
"2022-03-13 09:00:00", "2022-11-06 08:00:00", "2023-03-12 09:00:00", 
"2023-11-05 08:00:00", "2024-03-10 09:00:00", "2024-11-03 08:00:00", 
"2025-03-09 09:00:00", "2025-11-02 08:00:00", "2026-03-08 09:00:00", 
"2026-11-01 08:00:00", "2027-03-14 09:00:00", "2027-11-07 08:00:00", 
"2028-03-12 09:00:00", "2028-11-05 08:00:00", "2029-03-11 09:00:00", 
"2029-11-04 08:00:00", "2030-03-10 09:00:00", "2030-11-03 08:00:00", 
"2031-03-09 09:00:00", "2031-11-02 08:00:00", "2032-03-14 09:00:00", 
"2032-11-07 08:00:00", "2033-03-13 09:00:00", "2033-11-06 08:00:00", 
"2034-03-12 09:00:00", "2034-11-05 08:00:00", "2035-03-11 09:00:00", 
"2035-11-04 08:00:00", "2036-03-09 09:00:00", "2036-11-02 08:00:00", 
"2037-03-08 09:00:00", "2037-11-01 08:00:00"), offSet = c(-25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L), TimeZone = c("MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MPT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST"
), numeric = c(-2147397248, -1633273200, -1615132800, -1601823600, 
-1583683200, -1570374000, -1551628800, -1538924400, -1534089600, 
-769395600, -765388800, -147884400, -131558400, -116434800, -100108800, 
-84380400, -68659200, -52930800, -37209600, -21481200, -5760000, 
9968400, 25689600, 41418000, 57744000, 73472400, 89193600, 104922000, 
120643200, 126694800, 152092800, 162378000, 183542400, 199270800, 
215596800, 230720400, 247046400, 262774800, 278496000, 294224400, 
309945600, 325674000, 341395200, 357123600, 372844800, 388573200, 
404899200, 420022800, 436348800, 452077200, 467798400, 483526800, 
499248000, 514976400, 530697600, 544611600, 562147200, 576061200, 
594201600, 607510800, 625651200, 638960400, 657100800, 671014800, 
688550400, 702464400, 7.2e+08, 733914000, 752054400, 765363600, 
783504000, 796813200, 814953600, 828867600, 846403200, 860317200, 
877852800, 891766800, 909302400, 923216400, 941356800, 954666000, 
972806400, 986115600, 1004256000, 1018170000, 1035705600, 1049619600, 
1067155200, 1081069200, 1099209600, 1112518800, 1130659200, 1143968400, 
1162108800, 1173603600, 1194163200, 1205053200, 1225612800, 1236502800, 
1257062400, 1268557200, 1289116800, 1300006800, 1320566400, 1331456400, 
1352016000, 1362906000, 1383465600, 1394355600, 1414915200, 1425805200, 
1446364800, 1457859600, 1478419200, 1489309200, 1509868800, 1520758800, 
1541318400, 1552208400, 1572768000, 1583658000, 1604217600, 1615712400, 
1636272000, 1647162000, 1667721600, 1678611600, 1699171200, 1710061200, 
1730620800, 1741510800, 1762070400, 1772960400, 1793520000, 1805014800, 
1825574400, 1836464400, 1857024000, 1867914000, 1888473600, 1899363600, 
1919923200, 1930813200, 1951372800, 1962867600, 1983427200, 1994317200, 
2014876800, 2025766800, 2046326400, 2057216400, 2077776000, 2088666000, 
2109225600, 2120115600, 2140675200)), .Names = c("Denver", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -157L), class = "data.frame")
}

"Detroit" <- function () {
structure(list(Detroit = c("1901-12-14 20:45:52", "1905-01-01 05:32:11", 
"1915-05-15 08:00:00", "1945-08-14 23:00:00", "1945-09-30 06:00:00", 
"1948-04-25 07:00:00", "1948-09-26 06:00:00", "1967-06-14 07:00:00", 
"1967-10-29 06:00:00", "1973-04-29 07:00:00", "1973-10-28 06:00:00", 
"1974-01-06 07:00:00", "1974-10-27 06:00:00", "1975-04-27 07:00:00", 
"1975-10-26 06:00:00", "1976-04-25 07:00:00", "1976-10-31 06:00:00", 
"1977-04-24 07:00:00", "1977-10-30 06:00:00", "1978-04-30 07:00:00", 
"1978-10-29 06:00:00", "1979-04-29 07:00:00", "1979-10-28 06:00:00", 
"1980-04-27 07:00:00", "1980-10-26 06:00:00", "1981-04-26 07:00:00", 
"1981-10-25 06:00:00", "1982-04-25 07:00:00", "1982-10-31 06:00:00", 
"1983-04-24 07:00:00", "1983-10-30 06:00:00", "1984-04-29 07:00:00", 
"1984-10-28 06:00:00", "1985-04-28 07:00:00", "1985-10-27 06:00:00", 
"1986-04-27 07:00:00", "1986-10-26 06:00:00", "1987-04-05 07:00:00", 
"1987-10-25 06:00:00", "1988-04-03 07:00:00", "1988-10-30 06:00:00", 
"1989-04-02 07:00:00", "1989-10-29 06:00:00", "1990-04-01 07:00:00", 
"1990-10-28 06:00:00", "1991-04-07 07:00:00", "1991-10-27 06:00:00", 
"1992-04-05 07:00:00", "1992-10-25 06:00:00", "1993-04-04 07:00:00", 
"1993-10-31 06:00:00", "1994-04-03 07:00:00", "1994-10-30 06:00:00", 
"1995-04-02 07:00:00", "1995-10-29 06:00:00", "1996-04-07 07:00:00", 
"1996-10-27 06:00:00", "1997-04-06 07:00:00", "1997-10-26 06:00:00", 
"1998-04-05 07:00:00", "1998-10-25 06:00:00", "1999-04-04 07:00:00", 
"1999-10-31 06:00:00", "2000-04-02 07:00:00", "2000-10-29 06:00:00", 
"2001-04-01 07:00:00", "2001-10-28 06:00:00", "2002-04-07 07:00:00", 
"2002-10-27 06:00:00", "2003-04-06 07:00:00", "2003-10-26 06:00:00", 
"2004-04-04 07:00:00", "2004-10-31 06:00:00", "2005-04-03 07:00:00", 
"2005-10-30 06:00:00", "2006-04-02 07:00:00", "2006-10-29 06:00:00", 
"2007-03-11 07:00:00", "2007-11-04 06:00:00", "2008-03-09 07:00:00", 
"2008-11-02 06:00:00", "2009-03-08 07:00:00", "2009-11-01 06:00:00", 
"2010-03-14 07:00:00", "2010-11-07 06:00:00", "2011-03-13 07:00:00", 
"2011-11-06 06:00:00", "2012-03-11 07:00:00", "2012-11-04 06:00:00", 
"2013-03-10 07:00:00", "2013-11-03 06:00:00", "2014-03-09 07:00:00", 
"2014-11-02 06:00:00", "2015-03-08 07:00:00", "2015-11-01 06:00:00", 
"2016-03-13 07:00:00", "2016-11-06 06:00:00", "2017-03-12 07:00:00", 
"2017-11-05 06:00:00", "2018-03-11 07:00:00", "2018-11-04 06:00:00", 
"2019-03-10 07:00:00", "2019-11-03 06:00:00", "2020-03-08 07:00:00", 
"2020-11-01 06:00:00", "2021-03-14 07:00:00", "2021-11-07 06:00:00", 
"2022-03-13 07:00:00", "2022-11-06 06:00:00", "2023-03-12 07:00:00", 
"2023-11-05 06:00:00", "2024-03-10 07:00:00", "2024-11-03 06:00:00", 
"2025-03-09 07:00:00", "2025-11-02 06:00:00", "2026-03-08 07:00:00", 
"2026-11-01 06:00:00", "2027-03-14 07:00:00", "2027-11-07 06:00:00", 
"2028-03-12 07:00:00", "2028-11-05 06:00:00", "2029-03-11 07:00:00", 
"2029-11-04 06:00:00", "2030-03-10 07:00:00", "2030-11-03 06:00:00", 
"2031-03-09 07:00:00", "2031-11-02 06:00:00", "2032-03-14 07:00:00", 
"2032-11-07 06:00:00", "2033-03-13 07:00:00", "2033-11-06 06:00:00", 
"2034-03-12 07:00:00", "2034-11-05 06:00:00", "2035-03-11 07:00:00", 
"2035-11-04 06:00:00", "2036-03-09 07:00:00", "2036-11-02 06:00:00", 
"2037-03-08 07:00:00", "2037-11-01 06:00:00"), offSet = c(-19931L, 
-21600L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L), isdst = c(0L, 0L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "CST", 
"EST", "EPT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST"), numeric = c(-2147397248, -2051202469, -1724083200, 
-769395600, -765396000, -684349200, -671047200, -80499600, -68666400, 
104914800, 120636000, 126687600, 152085600, 167814000, 183535200, 
199263600, 215589600, 230713200, 247039200, 262767600, 278488800, 
294217200, 309938400, 325666800, 341388000, 357116400, 372837600, 
388566000, 404892000, 420015600, 436341600, 452070000, 467791200, 
483519600, 499240800, 514969200, 530690400, 544604400, 562140000, 
576054000, 594194400, 607503600, 625644000, 638953200, 657093600, 
671007600, 688543200, 702457200, 719992800, 733906800, 752047200, 
765356400, 783496800, 796806000, 814946400, 828860400, 846396000, 
860310000, 877845600, 891759600, 909295200, 923209200, 941349600, 
954658800, 972799200, 986108400, 1004248800, 1018162800, 1035698400, 
1049612400, 1067148000, 1081062000, 1099202400, 1112511600, 1130652000, 
1143961200, 1162101600, 1173596400, 1194156000, 1205046000, 1225605600, 
1236495600, 1257055200, 1268550000, 1289109600, 1299999600, 1320559200, 
1331449200, 1352008800, 1362898800, 1383458400, 1394348400, 1414908000, 
1425798000, 1446357600, 1457852400, 1478412000, 1489302000, 1509861600, 
1520751600, 1541311200, 1552201200, 1572760800, 1583650800, 1604210400, 
1615705200, 1636264800, 1647154800, 1667714400, 1678604400, 1699164000, 
1710054000, 1730613600, 1741503600, 1762063200, 1772953200, 1793512800, 
1805007600, 1825567200, 1836457200, 1857016800, 1867906800, 1888466400, 
1899356400, 1919916000, 1930806000, 1951365600, 1962860400, 1983420000, 
1994310000, 2014869600, 2025759600, 2046319200, 2057209200, 2077768800, 
2088658800, 2109218400, 2120108400, 2140668000)), .Names = c("Detroit", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-139L), class = "data.frame")
}

"Dominica" <- function () {
structure(list(Dominica = c("1901-12-14 20:45:52", "1911-07-01 04:06:36"
), offSet = c(-14736L, -14400L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"AST"), numeric = c(-2147397248, -1846266804)), .Names = c("Dominica", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Edmonton" <- function () {
structure(list(Edmonton = c("1901-12-14 20:45:52", "1906-09-01 07:33:52", 
"1918-04-14 09:00:00", "1918-10-31 08:00:00", "1919-04-13 09:00:00", 
"1919-05-27 08:00:00", "1920-04-25 09:00:00", "1920-10-31 08:00:00", 
"1921-04-24 09:00:00", "1921-09-25 08:00:00", "1922-04-30 09:00:00", 
"1922-09-24 08:00:00", "1923-04-29 09:00:00", "1923-09-30 08:00:00", 
"1945-08-14 23:00:00", "1945-09-30 08:00:00", "1947-04-27 09:00:00", 
"1947-09-28 08:00:00", "1967-04-30 09:00:00", "1967-10-29 08:00:00", 
"1969-04-27 09:00:00", "1969-10-26 08:00:00", "1972-04-30 09:00:00", 
"1972-10-29 08:00:00", "1973-04-29 09:00:00", "1973-10-28 08:00:00", 
"1974-04-28 09:00:00", "1974-10-27 08:00:00", "1975-04-27 09:00:00", 
"1975-10-26 08:00:00", "1976-04-25 09:00:00", "1976-10-31 08:00:00", 
"1977-04-24 09:00:00", "1977-10-30 08:00:00", "1978-04-30 09:00:00", 
"1978-10-29 08:00:00", "1979-04-29 09:00:00", "1979-10-28 08:00:00", 
"1980-04-27 09:00:00", "1980-10-26 08:00:00", "1981-04-26 09:00:00", 
"1981-10-25 08:00:00", "1982-04-25 09:00:00", "1982-10-31 08:00:00", 
"1983-04-24 09:00:00", "1983-10-30 08:00:00", "1984-04-29 09:00:00", 
"1984-10-28 08:00:00", "1985-04-28 09:00:00", "1985-10-27 08:00:00", 
"1986-04-27 09:00:00", "1986-10-26 08:00:00", "1987-04-05 09:00:00", 
"1987-10-25 08:00:00", "1988-04-03 09:00:00", "1988-10-30 08:00:00", 
"1989-04-02 09:00:00", "1989-10-29 08:00:00", "1990-04-01 09:00:00", 
"1990-10-28 08:00:00", "1991-04-07 09:00:00", "1991-10-27 08:00:00", 
"1992-04-05 09:00:00", "1992-10-25 08:00:00", "1993-04-04 09:00:00", 
"1993-10-31 08:00:00", "1994-04-03 09:00:00", "1994-10-30 08:00:00", 
"1995-04-02 09:00:00", "1995-10-29 08:00:00", "1996-04-07 09:00:00", 
"1996-10-27 08:00:00", "1997-04-06 09:00:00", "1997-10-26 08:00:00", 
"1998-04-05 09:00:00", "1998-10-25 08:00:00", "1999-04-04 09:00:00", 
"1999-10-31 08:00:00", "2000-04-02 09:00:00", "2000-10-29 08:00:00", 
"2001-04-01 09:00:00", "2001-10-28 08:00:00", "2002-04-07 09:00:00", 
"2002-10-27 08:00:00", "2003-04-06 09:00:00", "2003-10-26 08:00:00", 
"2004-04-04 09:00:00", "2004-10-31 08:00:00", "2005-04-03 09:00:00", 
"2005-10-30 08:00:00", "2006-04-02 09:00:00", "2006-10-29 08:00:00", 
"2007-03-11 09:00:00", "2007-11-04 08:00:00", "2008-03-09 09:00:00", 
"2008-11-02 08:00:00", "2009-03-08 09:00:00", "2009-11-01 08:00:00", 
"2010-03-14 09:00:00", "2010-11-07 08:00:00", "2011-03-13 09:00:00", 
"2011-11-06 08:00:00", "2012-03-11 09:00:00", "2012-11-04 08:00:00", 
"2013-03-10 09:00:00", "2013-11-03 08:00:00", "2014-03-09 09:00:00", 
"2014-11-02 08:00:00", "2015-03-08 09:00:00", "2015-11-01 08:00:00", 
"2016-03-13 09:00:00", "2016-11-06 08:00:00", "2017-03-12 09:00:00", 
"2017-11-05 08:00:00", "2018-03-11 09:00:00", "2018-11-04 08:00:00", 
"2019-03-10 09:00:00", "2019-11-03 08:00:00", "2020-03-08 09:00:00", 
"2020-11-01 08:00:00", "2021-03-14 09:00:00", "2021-11-07 08:00:00", 
"2022-03-13 09:00:00", "2022-11-06 08:00:00", "2023-03-12 09:00:00", 
"2023-11-05 08:00:00", "2024-03-10 09:00:00", "2024-11-03 08:00:00", 
"2025-03-09 09:00:00", "2025-11-02 08:00:00", "2026-03-08 09:00:00", 
"2026-11-01 08:00:00", "2027-03-14 09:00:00", "2027-11-07 08:00:00", 
"2028-03-12 09:00:00", "2028-11-05 08:00:00", "2029-03-11 09:00:00", 
"2029-11-04 08:00:00", "2030-03-10 09:00:00", "2030-11-03 08:00:00", 
"2031-03-09 09:00:00", "2031-11-02 08:00:00", "2032-03-14 09:00:00", 
"2032-11-07 08:00:00", "2033-03-13 09:00:00", "2033-11-06 08:00:00", 
"2034-03-12 09:00:00", "2034-11-05 08:00:00", "2035-03-11 09:00:00", 
"2035-11-04 08:00:00", "2036-03-09 09:00:00", "2036-11-02 08:00:00", 
"2037-03-08 09:00:00", "2037-11-01 08:00:00"), offSet = c(-27232L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L), isdst = c(0L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MPT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST"), numeric = c(-2147397248, 
-1998663968, -1632063600, -1614787200, -1600614000, -1596816000, 
-1567954800, -1551628800, -1536505200, -1523203200, -1504450800, 
-1491753600, -1473001200, -1459699200, -769395600, -765388800, 
-715791600, -702489600, -84380400, -68659200, -21481200, -5760000, 
73472400, 89193600, 104922000, 120643200, 136371600, 152092800, 
167821200, 183542400, 199270800, 215596800, 230720400, 247046400, 
262774800, 278496000, 294224400, 309945600, 325674000, 341395200, 
357123600, 372844800, 388573200, 404899200, 420022800, 436348800, 
452077200, 467798400, 483526800, 499248000, 514976400, 530697600, 
544611600, 562147200, 576061200, 594201600, 607510800, 625651200, 
638960400, 657100800, 671014800, 688550400, 702464400, 7.2e+08, 
733914000, 752054400, 765363600, 783504000, 796813200, 814953600, 
828867600, 846403200, 860317200, 877852800, 891766800, 909302400, 
923216400, 941356800, 954666000, 972806400, 986115600, 1004256000, 
1018170000, 1035705600, 1049619600, 1067155200, 1081069200, 1099209600, 
1112518800, 1130659200, 1143968400, 1162108800, 1173603600, 1194163200, 
1205053200, 1225612800, 1236502800, 1257062400, 1268557200, 1289116800, 
1300006800, 1320566400, 1331456400, 1352016000, 1362906000, 1383465600, 
1394355600, 1414915200, 1425805200, 1446364800, 1457859600, 1478419200, 
1489309200, 1509868800, 1520758800, 1541318400, 1552208400, 1572768000, 
1583658000, 1604217600, 1615712400, 1636272000, 1647162000, 1667721600, 
1678611600, 1699171200, 1710061200, 1730620800, 1741510800, 1762070400, 
1772960400, 1793520000, 1805014800, 1825574400, 1836464400, 1857024000, 
1867914000, 1888473600, 1899363600, 1919923200, 1930813200, 1951372800, 
1962867600, 1983427200, 1994317200, 2014876800, 2025766800, 2046326400, 
2057216400, 2077776000, 2088666000, 2109225600, 2120115600, 2140675200
)), .Names = c("Edmonton", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -154L), class = "data.frame")
}

"Eirunepe" <- function () {
structure(list(Eirunepe = c("1901-12-14 20:45:52", "1914-01-01 04:39:28", 
"1931-10-03 16:00:00", "1932-04-01 04:00:00", "1932-10-03 05:00:00", 
"1933-04-01 04:00:00", "1949-12-01 05:00:00", "1950-04-16 05:00:00", 
"1950-12-01 05:00:00", "1951-04-01 04:00:00", "1951-12-01 05:00:00", 
"1952-04-01 04:00:00", "1952-12-01 05:00:00", "1953-03-01 04:00:00", 
"1963-12-09 05:00:00", "1964-03-01 04:00:00", "1965-01-31 05:00:00", 
"1965-03-31 04:00:00", "1965-12-01 05:00:00", "1966-03-01 04:00:00", 
"1966-11-01 05:00:00", "1967-03-01 04:00:00", "1967-11-01 05:00:00", 
"1968-03-01 04:00:00", "1985-11-02 05:00:00", "1986-03-15 04:00:00", 
"1986-10-25 05:00:00", "1987-02-14 04:00:00", "1987-10-25 05:00:00", 
"1988-02-07 04:00:00", "1993-10-17 05:00:00", "1994-02-20 04:00:00", 
"2008-06-24 05:00:00"), offSet = c(-16768L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L), TimeZone = c("LMT", "ACT", 
"ACST", "ACT", "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", "ACST", 
"ACT", "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", 
"ACST", "ACT", "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", "ACST", 
"ACT", "ACST", "ACT", "AMT"), numeric = c(-2147397248, -1767208832, 
-1206950400, -1191355200, -1175367600, -1159819200, -633812400, 
-622062000, -602276400, -591825600, -570740400, -560203200, -539118000, 
-531345600, -191358000, -184190400, -155156400, -150062400, -128890800, 
-121118400, -99946800, -89582400, -68410800, -57960000, 499755600, 
511243200, 530600400, 540273600, 562136400, 571204800, 750834000, 
761716800, 1214283600)), .Names = c("Eirunepe", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -33L), class = "data.frame")
}

"El_Salvador" <- function () {
structure(list(El_Salvador = c("1901-12-14 20:45:52", "1921-01-01 05:56:48", 
"1987-05-03 06:00:00", "1987-09-27 05:00:00", "1988-05-01 06:00:00", 
"1988-09-25 05:00:00"), offSet = c(-21408L, -21600L, -18000L, 
-21600L, -18000L, -21600L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L), 
    TimeZone = c("LMT", "CST", "CDT", "CST", "CDT", "CST"), numeric = c(-2147397248, 
    -1546279392, 547020000, 559717200, 578469600, 591166800)), .Names = c("El_Salvador", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-6L), class = "data.frame")
}

"Fortaleza" <- function () {
structure(list(Fortaleza = c("1901-12-14 20:45:52", "1914-01-01 02:34:00", 
"1931-10-03 14:00:00", "1932-04-01 02:00:00", "1932-10-03 03:00:00", 
"1933-04-01 02:00:00", "1949-12-01 03:00:00", "1950-04-16 03:00:00", 
"1950-12-01 03:00:00", "1951-04-01 02:00:00", "1951-12-01 03:00:00", 
"1952-04-01 02:00:00", "1952-12-01 03:00:00", "1953-03-01 02:00:00", 
"1963-12-09 03:00:00", "1964-03-01 02:00:00", "1965-01-31 03:00:00", 
"1965-03-31 02:00:00", "1965-12-01 03:00:00", "1966-03-01 02:00:00", 
"1966-11-01 03:00:00", "1967-03-01 02:00:00", "1967-11-01 03:00:00", 
"1968-03-01 02:00:00", "1985-11-02 03:00:00", "1986-03-15 02:00:00", 
"1986-10-25 03:00:00", "1987-02-14 02:00:00", "1987-10-25 03:00:00", 
"1988-02-07 02:00:00", "1988-10-16 03:00:00", "1989-01-29 02:00:00", 
"1989-10-15 03:00:00", "1990-02-11 02:00:00", "1999-10-03 03:00:00", 
"2000-02-27 02:00:00", "2000-10-08 03:00:00", "2000-10-22 02:00:00", 
"2001-10-14 03:00:00", "2002-02-17 02:00:00"), offSet = c(-9240L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L), 
    isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
    1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
    0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
    "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
    "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
    "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
    "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
    "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT"), numeric = c(-2147397248, 
    -1767216360, -1206957600, -1191362400, -1175374800, -1159826400, 
    -633819600, -622069200, -602283600, -591832800, -570747600, 
    -560210400, -539125200, -531352800, -191365200, -184197600, 
    -155163600, -150069600, -128898000, -121125600, -99954000, 
    -89589600, -68418000, -57967200, 499748400, 511236000, 530593200, 
    540266400, 562129200, 571197600, 592974000, 602042400, 624423600, 
    634701600, 938919600, 951616800, 970974000, 972180000, 1003028400, 
    1013911200)), .Names = c("Fortaleza", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -40L), class = "data.frame")
}

"Glace_Bay" <- function () {
structure(list(Glace_Bay = c("1901-12-14 20:45:52", "1902-06-15 03:59:48", 
"1918-04-14 06:00:00", "1918-10-31 05:00:00", "1945-08-14 23:00:00", 
"1945-09-30 05:00:00", "1953-04-26 06:00:00", "1953-09-27 05:00:00", 
"1972-04-30 06:00:00", "1972-10-29 05:00:00", "1973-04-29 06:00:00", 
"1973-10-28 05:00:00", "1974-04-28 06:00:00", "1974-10-27 05:00:00", 
"1975-04-27 06:00:00", "1975-10-26 05:00:00", "1976-04-25 06:00:00", 
"1976-10-31 05:00:00", "1977-04-24 06:00:00", "1977-10-30 05:00:00", 
"1978-04-30 06:00:00", "1978-10-29 05:00:00", "1979-04-29 06:00:00", 
"1979-10-28 05:00:00", "1980-04-27 06:00:00", "1980-10-26 05:00:00", 
"1981-04-26 06:00:00", "1981-10-25 05:00:00", "1982-04-25 06:00:00", 
"1982-10-31 05:00:00", "1983-04-24 06:00:00", "1983-10-30 05:00:00", 
"1984-04-29 06:00:00", "1984-10-28 05:00:00", "1985-04-28 06:00:00", 
"1985-10-27 05:00:00", "1986-04-27 06:00:00", "1986-10-26 05:00:00", 
"1987-04-05 06:00:00", "1987-10-25 05:00:00", "1988-04-03 06:00:00", 
"1988-10-30 05:00:00", "1989-04-02 06:00:00", "1989-10-29 05:00:00", 
"1990-04-01 06:00:00", "1990-10-28 05:00:00", "1991-04-07 06:00:00", 
"1991-10-27 05:00:00", "1992-04-05 06:00:00", "1992-10-25 05:00:00", 
"1993-04-04 06:00:00", "1993-10-31 05:00:00", "1994-04-03 06:00:00", 
"1994-10-30 05:00:00", "1995-04-02 06:00:00", "1995-10-29 05:00:00", 
"1996-04-07 06:00:00", "1996-10-27 05:00:00", "1997-04-06 06:00:00", 
"1997-10-26 05:00:00", "1998-04-05 06:00:00", "1998-10-25 05:00:00", 
"1999-04-04 06:00:00", "1999-10-31 05:00:00", "2000-04-02 06:00:00", 
"2000-10-29 05:00:00", "2001-04-01 06:00:00", "2001-10-28 05:00:00", 
"2002-04-07 06:00:00", "2002-10-27 05:00:00", "2003-04-06 06:00:00", 
"2003-10-26 05:00:00", "2004-04-04 06:00:00", "2004-10-31 05:00:00", 
"2005-04-03 06:00:00", "2005-10-30 05:00:00", "2006-04-02 06:00:00", 
"2006-10-29 05:00:00", "2007-03-11 06:00:00", "2007-11-04 05:00:00", 
"2008-03-09 06:00:00", "2008-11-02 05:00:00", "2009-03-08 06:00:00", 
"2009-11-01 05:00:00", "2010-03-14 06:00:00", "2010-11-07 05:00:00", 
"2011-03-13 06:00:00", "2011-11-06 05:00:00", "2012-03-11 06:00:00", 
"2012-11-04 05:00:00", "2013-03-10 06:00:00", "2013-11-03 05:00:00", 
"2014-03-09 06:00:00", "2014-11-02 05:00:00", "2015-03-08 06:00:00", 
"2015-11-01 05:00:00", "2016-03-13 06:00:00", "2016-11-06 05:00:00", 
"2017-03-12 06:00:00", "2017-11-05 05:00:00", "2018-03-11 06:00:00", 
"2018-11-04 05:00:00", "2019-03-10 06:00:00", "2019-11-03 05:00:00", 
"2020-03-08 06:00:00", "2020-11-01 05:00:00", "2021-03-14 06:00:00", 
"2021-11-07 05:00:00", "2022-03-13 06:00:00", "2022-11-06 05:00:00", 
"2023-03-12 06:00:00", "2023-11-05 05:00:00", "2024-03-10 06:00:00", 
"2024-11-03 05:00:00", "2025-03-09 06:00:00", "2025-11-02 05:00:00", 
"2026-03-08 06:00:00", "2026-11-01 05:00:00", "2027-03-14 06:00:00", 
"2027-11-07 05:00:00", "2028-03-12 06:00:00", "2028-11-05 05:00:00", 
"2029-03-11 06:00:00", "2029-11-04 05:00:00", "2030-03-10 06:00:00", 
"2030-11-03 05:00:00", "2031-03-09 06:00:00", "2031-11-02 05:00:00", 
"2032-03-14 06:00:00", "2032-11-07 05:00:00", "2033-03-13 06:00:00", 
"2033-11-06 05:00:00", "2034-03-12 06:00:00", "2034-11-05 05:00:00", 
"2035-03-11 06:00:00", "2035-11-04 05:00:00", "2036-03-09 06:00:00", 
"2036-11-02 05:00:00", "2037-03-08 06:00:00", "2037-11-01 05:00:00"
), offSet = c(-14388L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L), TimeZone = c("LMT", "AST", "ADT", "AST", "APT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST"), numeric = c(-2147397248, 
-2131646412, -1632074400, -1614798000, -769395600, -765399600, 
-526500000, -513198000, 73461600, 89182800, 104911200, 120632400, 
136360800, 152082000, 167810400, 183531600, 199260000, 215586000, 
230709600, 247035600, 262764000, 278485200, 294213600, 309934800, 
325663200, 341384400, 357112800, 372834000, 388562400, 404888400, 
420012000, 436338000, 452066400, 467787600, 483516000, 499237200, 
514965600, 530686800, 544600800, 562136400, 576050400, 594190800, 
607500000, 625640400, 638949600, 657090000, 671004000, 688539600, 
702453600, 719989200, 733903200, 752043600, 765352800, 783493200, 
796802400, 814942800, 828856800, 846392400, 860306400, 877842000, 
891756000, 909291600, 923205600, 941346000, 954655200, 972795600, 
986104800, 1004245200, 1018159200, 1035694800, 1049608800, 1067144400, 
1081058400, 1099198800, 1112508000, 1130648400, 1143957600, 1162098000, 
1173592800, 1194152400, 1205042400, 1225602000, 1236492000, 1257051600, 
1268546400, 1289106000, 1299996000, 1320555600, 1331445600, 1352005200, 
1362895200, 1383454800, 1394344800, 1414904400, 1425794400, 1446354000, 
1457848800, 1478408400, 1489298400, 1509858000, 1520748000, 1541307600, 
1552197600, 1572757200, 1583647200, 1604206800, 1615701600, 1636261200, 
1647151200, 1667710800, 1678600800, 1699160400, 1710050400, 1730610000, 
1741500000, 1762059600, 1772949600, 1793509200, 1805004000, 1825563600, 
1836453600, 1857013200, 1867903200, 1888462800, 1899352800, 1919912400, 
1930802400, 1951362000, 1962856800, 1983416400, 1994306400, 2014866000, 
2025756000, 2046315600, 2057205600, 2077765200, 2088655200, 2109214800, 
2120104800, 2140664400)), .Names = c("Glace_Bay", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -140L), class = "data.frame")
}

"Godthab" <- function () {
structure(list(Godthab = c("1901-12-14 20:45:52", "1916-07-28 03:26:56", 
"1980-04-06 05:00:00", "1980-09-28 01:00:00", "1981-03-29 01:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00", "2037-10-25 01:00:00"), offSet = c(-12416L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, 0L), isdst = c(0L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L), TimeZone = c("LMT", "WGT", "WGST", "WGT", "WGST", 
"WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", 
"WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", 
"WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", 
"WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", 
"WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", 
"WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", 
"WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", 
"WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", 
"WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", 
"WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", 
"WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", 
"WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", "WGT", "WGST", 
"WGT", "WGST", "WGT", "WGST", "UTC"), numeric = c(-2147397248, 
-1686083584, 323845200, 338950800, 354675600, 370400400, 386125200, 
401850000, 417574800, 433299600, 449024400, 465354000, 481078800, 
496803600, 512528400, 528253200, 543978000, 559702800, 575427600, 
591152400, 606877200, 622602000, 638326800, 654656400, 670381200, 
686106000, 701830800, 717555600, 733280400, 749005200, 764730000, 
780454800, 796179600, 811904400, 828234000, 846378000, 859683600, 
877827600, 891133200, 909277200, 922582800, 941331600, 954032400, 
972781200, 985482000, 1004230800, 1017536400, 1035680400, 1048986000, 
1067130000, 1080435600, 1099184400, 1111885200, 1130634000, 1143334800, 
1162083600, 1174784400, 1193533200, 1206838800, 1224982800, 1238288400, 
1256432400, 1269738000, 1288486800, 1301187600, 1319936400, 1332637200, 
1351386000, 1364691600, 1382835600, 1396141200, 1414285200, 1427590800, 
1445734800, 1459040400, 1477789200, 1490490000, 1509238800, 1521939600, 
1540688400, 1553994000, 1572138000, 1585443600, 1603587600, 1616893200, 
1635642000, 1648342800, 1667091600, 1679792400, 1698541200, 1711846800, 
1729990800, 1743296400, 1761440400, 1774746000, 1792890000, 1806195600, 
1824944400, 1837645200, 1856394000, 1869094800, 1887843600, 1901149200, 
1919293200, 1932598800, 1950742800, 1964048400, 1982797200, 1995498000, 
2014246800, 2026947600, 2045696400, 2058397200, 2077146000, 2090451600, 
2108595600, 2121901200, 2140045200)), .Names = c("Godthab", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -118L), class = "data.frame")
}

"Goose_Bay" <- function () {
structure(list(Goose_Bay = c("1901-12-14 20:45:52", "1918-04-14 05:30:52", 
"1918-10-31 04:30:52", "1935-03-30 03:30:52", "1936-05-11 03:30:00", 
"1936-10-05 02:30:00", "1937-05-10 03:30:00", "1937-10-04 02:30:00", 
"1938-05-09 03:30:00", "1938-10-03 02:30:00", "1939-05-15 03:30:00", 
"1939-10-02 02:30:00", "1940-05-13 03:30:00", "1940-10-07 02:30:00", 
"1941-05-12 03:30:00", "1941-10-06 02:30:00", "1945-08-14 23:00:00", 
"1945-09-30 04:30:00", "1946-05-12 05:30:00", "1946-10-06 04:30:00", 
"1947-05-11 05:30:00", "1947-10-05 04:30:00", "1948-05-09 05:30:00", 
"1948-10-03 04:30:00", "1949-05-08 05:30:00", "1949-10-02 04:30:00", 
"1950-05-14 05:30:00", "1950-10-08 04:30:00", "1951-04-29 05:30:00", 
"1951-09-30 04:30:00", "1952-04-27 05:30:00", "1952-09-28 04:30:00", 
"1953-04-26 05:30:00", "1953-09-27 04:30:00", "1954-04-25 05:30:00", 
"1954-09-26 04:30:00", "1955-04-24 05:30:00", "1955-09-25 04:30:00", 
"1956-04-29 05:30:00", "1956-09-30 04:30:00", "1957-04-28 05:30:00", 
"1957-09-29 04:30:00", "1958-04-27 05:30:00", "1958-09-28 04:30:00", 
"1959-04-26 05:30:00", "1959-09-27 04:30:00", "1960-04-24 05:30:00", 
"1960-10-30 04:30:00", "1961-04-30 05:30:00", "1961-10-29 04:30:00", 
"1962-04-29 05:30:00", "1962-10-28 04:30:00", "1963-04-28 05:30:00", 
"1963-10-27 04:30:00", "1964-04-26 05:30:00", "1964-10-25 04:30:00", 
"1965-04-25 05:30:00", "1965-10-31 04:30:00", "1966-03-15 05:30:00", 
"1966-04-24 06:00:00", "1966-10-30 05:00:00", "1967-04-30 06:00:00", 
"1967-10-29 05:00:00", "1968-04-28 06:00:00", "1968-10-27 05:00:00", 
"1969-04-27 06:00:00", "1969-10-26 05:00:00", "1970-04-26 06:00:00", 
"1970-10-25 05:00:00", "1971-04-25 06:00:00", "1971-10-31 05:00:00", 
"1972-04-30 06:00:00", "1972-10-29 05:00:00", "1973-04-29 06:00:00", 
"1973-10-28 05:00:00", "1974-04-28 06:00:00", "1974-10-27 05:00:00", 
"1975-04-27 06:00:00", "1975-10-26 05:00:00", "1976-04-25 06:00:00", 
"1976-10-31 05:00:00", "1977-04-24 06:00:00", "1977-10-30 05:00:00", 
"1978-04-30 06:00:00", "1978-10-29 05:00:00", "1979-04-29 06:00:00", 
"1979-10-28 05:00:00", "1980-04-27 06:00:00", "1980-10-26 05:00:00", 
"1981-04-26 06:00:00", "1981-10-25 05:00:00", "1982-04-25 06:00:00", 
"1982-10-31 05:00:00", "1983-04-24 06:00:00", "1983-10-30 05:00:00", 
"1984-04-29 06:00:00", "1984-10-28 05:00:00", "1985-04-28 06:00:00", 
"1985-10-27 05:00:00", "1986-04-27 06:00:00", "1986-10-26 05:00:00", 
"1987-04-05 04:01:00", "1987-10-25 03:01:00", "1988-04-03 04:01:00", 
"1988-10-30 02:01:00", "1989-04-02 04:01:00", "1989-10-29 03:01:00", 
"1990-04-01 04:01:00", "1990-10-28 03:01:00", "1991-04-07 04:01:00", 
"1991-10-27 03:01:00", "1992-04-05 04:01:00", "1992-10-25 03:01:00", 
"1993-04-04 04:01:00", "1993-10-31 03:01:00", "1994-04-03 04:01:00", 
"1994-10-30 03:01:00", "1995-04-02 04:01:00", "1995-10-29 03:01:00", 
"1996-04-07 04:01:00", "1996-10-27 03:01:00", "1997-04-06 04:01:00", 
"1997-10-26 03:01:00", "1998-04-05 04:01:00", "1998-10-25 03:01:00", 
"1999-04-04 04:01:00", "1999-10-31 03:01:00", "2000-04-02 04:01:00", 
"2000-10-29 03:01:00", "2001-04-01 04:01:00", "2001-10-28 03:01:00", 
"2002-04-07 04:01:00", "2002-10-27 03:01:00", "2003-04-06 04:01:00", 
"2003-10-26 03:01:00", "2004-04-04 04:01:00", "2004-10-31 03:01:00", 
"2005-04-03 04:01:00", "2005-10-30 03:01:00", "2006-04-02 04:01:00", 
"2006-10-29 03:01:00", "2007-03-11 04:01:00", "2007-11-04 03:01:00", 
"2008-03-09 04:01:00", "2008-11-02 03:01:00", "2009-03-08 04:01:00", 
"2009-11-01 03:01:00", "2010-03-14 04:01:00", "2010-11-07 03:01:00", 
"2011-03-13 04:01:00", "2011-11-06 03:01:00", "2012-03-11 04:01:00", 
"2012-11-04 03:01:00", "2013-03-10 04:01:00", "2013-11-03 03:01:00", 
"2014-03-09 04:01:00", "2014-11-02 03:01:00", "2015-03-08 04:01:00", 
"2015-11-01 03:01:00", "2016-03-13 04:01:00", "2016-11-06 03:01:00", 
"2017-03-12 04:01:00", "2017-11-05 03:01:00", "2018-03-11 04:01:00", 
"2018-11-04 03:01:00", "2019-03-10 04:01:00", "2019-11-03 03:01:00", 
"2020-03-08 04:01:00", "2020-11-01 03:01:00", "2021-03-14 04:01:00", 
"2021-11-07 03:01:00", "2022-03-13 04:01:00", "2022-11-06 03:01:00", 
"2023-03-12 04:01:00", "2023-11-05 03:01:00", "2024-03-10 04:01:00", 
"2024-11-03 03:01:00", "2025-03-09 04:01:00", "2025-11-02 03:01:00", 
"2026-03-08 04:01:00", "2026-11-01 03:01:00", "2027-03-14 04:01:00", 
"2027-11-07 03:01:00", "2028-03-12 04:01:00", "2028-11-05 03:01:00", 
"2029-03-11 04:01:00", "2029-11-04 03:01:00", "2030-03-10 04:01:00", 
"2030-11-03 03:01:00", "2031-03-09 04:01:00", "2031-11-02 03:01:00", 
"2032-03-14 04:01:00", "2032-11-07 03:01:00", "2033-03-13 04:01:00", 
"2033-11-06 03:01:00", "2034-03-12 04:01:00", "2034-11-05 03:01:00", 
"2035-03-11 04:01:00", "2035-11-04 03:01:00", "2036-03-09 04:01:00", 
"2036-11-02 03:01:00", "2037-03-08 04:01:00", "2037-11-01 03:01:00"
), offSet = c(-12652L, -9052L, -12652L, -12600L, -9000L, -12600L, 
-9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, 
-9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, 
-9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, 
-9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, 
-9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, 
-9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, 
-9000L, -12600L, -9000L, -12600L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-7200L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L), isdst = c(0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L), TimeZone = c("NST", "NDT", "NST", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NPT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADDT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST"
), numeric = c(-2147397248, -1632076148, -1614799748, -1096921748, 
-1061670600, -1048973400, -1030221000, -1017523800, -998771400, 
-986074200, -966717000, -954624600, -935267400, -922570200, -903817800, 
-891120600, -769395600, -765401400, -746044200, -733347000, -714594600, 
-701897400, -683145000, -670447800, -651695400, -638998200, -619641000, 
-606943800, -589401000, -576099000, -557951400, -544649400, -526501800, 
-513199800, -495052200, -481750200, -463602600, -450300600, -431548200, 
-418246200, -400098600, -386796600, -368649000, -355347000, -337199400, 
-323897400, -305749800, -289423800, -273695400, -257974200, -242245800, 
-226524600, -210796200, -195075000, -179346600, -163625400, -147897000, 
-131571000, -119903400, -116445600, -100119600, -84391200, -68670000, 
-52941600, -37220400, -21492000, -5770800, 9957600, 25678800, 
41407200, 57733200, 73461600, 89182800, 104911200, 120632400, 
136360800, 152082000, 167810400, 183531600, 199260000, 215586000, 
230709600, 247035600, 262764000, 278485200, 294213600, 309934800, 
325663200, 341384400, 357112800, 372834000, 388562400, 404888400, 
420012000, 436338000, 452066400, 467787600, 483516000, 499237200, 
514965600, 530686800, 544593660, 562129260, 576043260, 594180060, 
607492860, 625633260, 638942460, 657082860, 670996860, 688532460, 
702446460, 719982060, 733896060, 752036460, 765345660, 783486060, 
796795260, 814935660, 828849660, 846385260, 860299260, 877834860, 
891748860, 909284460, 923198460, 941338860, 954648060, 972788460, 
986097660, 1004238060, 1018152060, 1035687660, 1049601660, 1067137260, 
1081051260, 1099191660, 1112500860, 1130641260, 1143950460, 1162090860, 
1173585660, 1194145260, 1205035260, 1225594860, 1236484860, 1257044460, 
1268539260, 1289098860, 1299988860, 1320548460, 1331438460, 1351998060, 
1362888060, 1383447660, 1394337660, 1414897260, 1425787260, 1446346860, 
1457841660, 1478401260, 1489291260, 1509850860, 1520740860, 1541300460, 
1552190460, 1572750060, 1583640060, 1604199660, 1615694460, 1636254060, 
1647144060, 1667703660, 1678593660, 1699153260, 1710043260, 1730602860, 
1741492860, 1762052460, 1772942460, 1793502060, 1804996860, 1825556460, 
1836446460, 1857006060, 1867896060, 1888455660, 1899345660, 1919905260, 
1930795260, 1951354860, 1962849660, 1983409260, 1994299260, 2014858860, 
2025748860, 2046308460, 2057198460, 2077758060, 2088648060, 2109207660, 
2120097660, 2140657260)), .Names = c("Goose_Bay", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -203L), class = "data.frame")
}

"Grand_Turk" <- function () {
structure(list(Grand_Turk = c("1901-12-14 20:45:52", "1912-02-01 05:07:12", 
"1979-04-29 07:00:00", "1979-10-28 06:00:00", "1980-04-27 07:00:00", 
"1980-10-26 06:00:00", "1981-04-26 07:00:00", "1981-10-25 06:00:00", 
"1982-04-25 07:00:00", "1982-10-31 06:00:00", "1983-04-24 07:00:00", 
"1983-10-30 06:00:00", "1984-04-29 07:00:00", "1984-10-28 06:00:00", 
"1985-04-28 07:00:00", "1985-10-27 06:00:00", "1986-04-27 07:00:00", 
"1986-10-26 06:00:00", "1987-04-05 07:00:00", "1987-10-25 06:00:00", 
"1988-04-03 07:00:00", "1988-10-30 06:00:00", "1989-04-02 07:00:00", 
"1989-10-29 06:00:00", "1990-04-01 07:00:00", "1990-10-28 06:00:00", 
"1991-04-07 07:00:00", "1991-10-27 06:00:00", "1992-04-05 07:00:00", 
"1992-10-25 06:00:00", "1993-04-04 07:00:00", "1993-10-31 06:00:00", 
"1994-04-03 07:00:00", "1994-10-30 06:00:00", "1995-04-02 07:00:00", 
"1995-10-29 06:00:00", "1996-04-07 07:00:00", "1996-10-27 06:00:00", 
"1997-04-06 07:00:00", "1997-10-26 06:00:00", "1998-04-05 07:00:00", 
"1998-10-25 06:00:00", "1999-04-04 07:00:00", "1999-10-31 06:00:00", 
"2000-04-02 07:00:00", "2000-10-29 06:00:00", "2001-04-01 07:00:00", 
"2001-10-28 06:00:00", "2002-04-07 07:00:00", "2002-10-27 06:00:00", 
"2003-04-06 07:00:00", "2003-10-26 06:00:00", "2004-04-04 07:00:00", 
"2004-10-31 06:00:00", "2005-04-03 07:00:00", "2005-10-30 06:00:00", 
"2006-04-02 07:00:00", "2006-10-29 06:00:00", "2007-03-11 07:00:00", 
"2007-11-04 06:00:00", "2008-03-09 07:00:00", "2008-11-02 06:00:00", 
"2009-03-08 07:00:00", "2009-11-01 06:00:00", "2010-03-14 07:00:00", 
"2010-11-07 06:00:00", "2011-03-13 07:00:00", "2011-11-06 06:00:00", 
"2012-03-11 07:00:00", "2012-11-04 06:00:00", "2013-03-10 07:00:00", 
"2013-11-03 06:00:00", "2014-03-09 07:00:00", "2014-11-02 06:00:00", 
"2015-03-08 07:00:00", "2015-11-01 06:00:00", "2016-03-13 07:00:00", 
"2016-11-06 06:00:00", "2017-03-12 07:00:00", "2017-11-05 06:00:00", 
"2018-03-11 07:00:00", "2018-11-04 06:00:00", "2019-03-10 07:00:00", 
"2019-11-03 06:00:00", "2020-03-08 07:00:00", "2020-11-01 06:00:00", 
"2021-03-14 07:00:00", "2021-11-07 06:00:00", "2022-03-13 07:00:00", 
"2022-11-06 06:00:00", "2023-03-12 07:00:00", "2023-11-05 06:00:00", 
"2024-03-10 07:00:00", "2024-11-03 06:00:00", "2025-03-09 07:00:00", 
"2025-11-02 06:00:00", "2026-03-08 07:00:00", "2026-11-01 06:00:00", 
"2027-03-14 07:00:00", "2027-11-07 06:00:00", "2028-03-12 07:00:00", 
"2028-11-05 06:00:00", "2029-03-11 07:00:00", "2029-11-04 06:00:00", 
"2030-03-10 07:00:00", "2030-11-03 06:00:00", "2031-03-09 07:00:00", 
"2031-11-02 06:00:00", "2032-03-14 07:00:00", "2032-11-07 06:00:00", 
"2033-03-13 07:00:00", "2033-11-06 06:00:00", "2034-03-12 07:00:00", 
"2034-11-05 06:00:00", "2035-03-11 07:00:00", "2035-11-04 06:00:00", 
"2036-03-09 07:00:00", "2036-11-02 06:00:00", "2037-03-08 07:00:00", 
"2037-11-01 06:00:00"), offSet = c(-18432L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L), isdst = c(0L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("KMT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST"), numeric = c(-2147397248, 
-1827687168, 294217200, 309938400, 325666800, 341388000, 357116400, 
372837600, 388566000, 404892000, 420015600, 436341600, 452070000, 
467791200, 483519600, 499240800, 514969200, 530690400, 544604400, 
562140000, 576054000, 594194400, 607503600, 625644000, 638953200, 
657093600, 671007600, 688543200, 702457200, 719992800, 733906800, 
752047200, 765356400, 783496800, 796806000, 814946400, 828860400, 
846396000, 860310000, 877845600, 891759600, 909295200, 923209200, 
941349600, 954658800, 972799200, 986108400, 1004248800, 1018162800, 
1035698400, 1049612400, 1067148000, 1081062000, 1099202400, 1112511600, 
1130652000, 1143961200, 1162101600, 1173596400, 1194156000, 1205046000, 
1225605600, 1236495600, 1257055200, 1268550000, 1289109600, 1299999600, 
1320559200, 1331449200, 1352008800, 1362898800, 1383458400, 1394348400, 
1414908000, 1425798000, 1446357600, 1457852400, 1478412000, 1489302000, 
1509861600, 1520751600, 1541311200, 1552201200, 1572760800, 1583650800, 
1604210400, 1615705200, 1636264800, 1647154800, 1667714400, 1678604400, 
1699164000, 1710054000, 1730613600, 1741503600, 1762063200, 1772953200, 
1793512800, 1805007600, 1825567200, 1836457200, 1857016800, 1867906800, 
1888466400, 1899356400, 1919916000, 1930806000, 1951365600, 1962860400, 
1983420000, 1994310000, 2014869600, 2025759600, 2046319200, 2057209200, 
2077768800, 2088658800, 2109218400, 2120108400, 2140668000)), .Names = c("Grand_Turk", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-120L), class = "data.frame")
}

"Grenada" <- function () {
structure(list(Grenada = c("1901-12-14 20:45:52", "1911-07-01 04:07:00"
), offSet = c(-14820L, -14400L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"AST"), numeric = c(-2147397248, -1846266780)), .Names = c("Grenada", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Guadeloupe" <- function () {
structure(list(Guadeloupe = c("1901-12-14 20:45:52", "1911-06-08 04:06:08"
), offSet = c(-14768L, -14400L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"AST"), numeric = c(-2147397248, -1848254032)), .Names = c("Guadeloupe", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Guatemala" <- function () {
structure(list(Guatemala = c("1901-12-14 20:45:52", "1918-10-05 06:02:04", 
"1973-11-25 06:00:00", "1974-02-24 05:00:00", "1983-05-21 06:00:00", 
"1983-09-22 05:00:00", "1991-03-23 06:00:00", "1991-09-07 05:00:00", 
"2006-04-30 06:00:00", "2006-10-01 05:00:00"), offSet = c(-21724L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L), TimeZone = c("LMT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST"), numeric = c(-2147397248, -1617040676, 
123055200, 130914000, 422344800, 433054800, 669708000, 684219600, 
1146376800, 1159678800)), .Names = c("Guatemala", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -10L), class = "data.frame")
}

"Guayaquil" <- function () {
structure(list(Guayaquil = c("1901-12-14 20:45:52", "1931-01-01 05:14:00"
), offSet = c(-18840L, -18000L), isdst = c(0L, 0L), TimeZone = c("QMT", 
"ECT"), numeric = c(-2147397248, -1230749160)), .Names = c("Guayaquil", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Guyana" <- function () {
structure(list(Guyana = c("1901-12-14 20:45:52", "1966-05-26 03:45:00", 
"1975-07-31 03:45:00", "1991-01-01 03:00:00"), offSet = c(-13960L, 
-13500L, -10800L, -14400L), isdst = c(0L, 0L, 0L, 0L), TimeZone = c("LMT", 
"GYT", "GYT", "GYT"), numeric = c(-2147397248, -113688900, 176010300, 
662698800)), .Names = c("Guyana", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"Halifax" <- function () {
structure(list(Halifax = c("1901-12-14 20:45:52", "1902-06-15 04:14:24", 
"1916-04-01 04:00:00", "1916-10-01 03:00:00", "1918-04-14 06:00:00", 
"1918-10-31 05:00:00", "1920-05-09 04:00:00", "1920-08-29 03:00:00", 
"1921-05-06 04:00:00", "1921-09-05 03:00:00", "1922-04-30 04:00:00", 
"1922-09-05 03:00:00", "1923-05-06 04:00:00", "1923-09-04 03:00:00", 
"1924-05-04 04:00:00", "1924-09-15 03:00:00", "1925-05-03 04:00:00", 
"1925-09-28 03:00:00", "1926-05-16 04:00:00", "1926-09-13 03:00:00", 
"1927-05-01 04:00:00", "1927-09-26 03:00:00", "1928-05-13 04:00:00", 
"1928-09-09 03:00:00", "1929-05-12 04:00:00", "1929-09-03 03:00:00", 
"1930-05-11 04:00:00", "1930-09-15 03:00:00", "1931-05-10 04:00:00", 
"1931-09-28 03:00:00", "1932-05-01 04:00:00", "1932-09-26 03:00:00", 
"1933-04-30 04:00:00", "1933-10-02 03:00:00", "1934-05-20 04:00:00", 
"1934-09-16 03:00:00", "1935-06-02 04:00:00", "1935-09-30 03:00:00", 
"1936-06-01 04:00:00", "1936-09-14 03:00:00", "1937-05-02 04:00:00", 
"1937-09-27 03:00:00", "1938-05-01 04:00:00", "1938-09-26 03:00:00", 
"1939-05-28 04:00:00", "1939-09-25 03:00:00", "1940-05-05 04:00:00", 
"1940-09-30 03:00:00", "1941-05-04 04:00:00", "1941-09-29 03:00:00", 
"1945-08-14 23:00:00", "1945-09-30 05:00:00", "1946-04-28 06:00:00", 
"1946-09-29 05:00:00", "1947-04-27 06:00:00", "1947-09-28 05:00:00", 
"1948-04-25 06:00:00", "1948-09-26 05:00:00", "1949-04-24 06:00:00", 
"1949-09-25 05:00:00", "1951-04-29 06:00:00", "1951-09-30 05:00:00", 
"1952-04-27 06:00:00", "1952-09-28 05:00:00", "1953-04-26 06:00:00", 
"1953-09-27 05:00:00", "1954-04-25 06:00:00", "1954-09-26 05:00:00", 
"1956-04-29 06:00:00", "1956-09-30 05:00:00", "1957-04-28 06:00:00", 
"1957-09-29 05:00:00", "1958-04-27 06:00:00", "1958-09-28 05:00:00", 
"1959-04-26 06:00:00", "1959-09-27 05:00:00", "1962-04-29 06:00:00", 
"1962-10-28 05:00:00", "1963-04-28 06:00:00", "1963-10-27 05:00:00", 
"1964-04-26 06:00:00", "1964-10-25 05:00:00", "1965-04-25 06:00:00", 
"1965-10-31 05:00:00", "1966-04-24 06:00:00", "1966-10-30 05:00:00", 
"1967-04-30 06:00:00", "1967-10-29 05:00:00", "1968-04-28 06:00:00", 
"1968-10-27 05:00:00", "1969-04-27 06:00:00", "1969-10-26 05:00:00", 
"1970-04-26 06:00:00", "1970-10-25 05:00:00", "1971-04-25 06:00:00", 
"1971-10-31 05:00:00", "1972-04-30 06:00:00", "1972-10-29 05:00:00", 
"1973-04-29 06:00:00", "1973-10-28 05:00:00", "1974-04-28 06:00:00", 
"1974-10-27 05:00:00", "1975-04-27 06:00:00", "1975-10-26 05:00:00", 
"1976-04-25 06:00:00", "1976-10-31 05:00:00", "1977-04-24 06:00:00", 
"1977-10-30 05:00:00", "1978-04-30 06:00:00", "1978-10-29 05:00:00", 
"1979-04-29 06:00:00", "1979-10-28 05:00:00", "1980-04-27 06:00:00", 
"1980-10-26 05:00:00", "1981-04-26 06:00:00", "1981-10-25 05:00:00", 
"1982-04-25 06:00:00", "1982-10-31 05:00:00", "1983-04-24 06:00:00", 
"1983-10-30 05:00:00", "1984-04-29 06:00:00", "1984-10-28 05:00:00", 
"1985-04-28 06:00:00", "1985-10-27 05:00:00", "1986-04-27 06:00:00", 
"1986-10-26 05:00:00", "1987-04-05 06:00:00", "1987-10-25 05:00:00", 
"1988-04-03 06:00:00", "1988-10-30 05:00:00", "1989-04-02 06:00:00", 
"1989-10-29 05:00:00", "1990-04-01 06:00:00", "1990-10-28 05:00:00", 
"1991-04-07 06:00:00", "1991-10-27 05:00:00", "1992-04-05 06:00:00", 
"1992-10-25 05:00:00", "1993-04-04 06:00:00", "1993-10-31 05:00:00", 
"1994-04-03 06:00:00", "1994-10-30 05:00:00", "1995-04-02 06:00:00", 
"1995-10-29 05:00:00", "1996-04-07 06:00:00", "1996-10-27 05:00:00", 
"1997-04-06 06:00:00", "1997-10-26 05:00:00", "1998-04-05 06:00:00", 
"1998-10-25 05:00:00", "1999-04-04 06:00:00", "1999-10-31 05:00:00", 
"2000-04-02 06:00:00", "2000-10-29 05:00:00", "2001-04-01 06:00:00", 
"2001-10-28 05:00:00", "2002-04-07 06:00:00", "2002-10-27 05:00:00", 
"2003-04-06 06:00:00", "2003-10-26 05:00:00", "2004-04-04 06:00:00", 
"2004-10-31 05:00:00", "2005-04-03 06:00:00", "2005-10-30 05:00:00", 
"2006-04-02 06:00:00", "2006-10-29 05:00:00", "2007-03-11 06:00:00", 
"2007-11-04 05:00:00", "2008-03-09 06:00:00", "2008-11-02 05:00:00", 
"2009-03-08 06:00:00", "2009-11-01 05:00:00", "2010-03-14 06:00:00", 
"2010-11-07 05:00:00", "2011-03-13 06:00:00", "2011-11-06 05:00:00", 
"2012-03-11 06:00:00", "2012-11-04 05:00:00", "2013-03-10 06:00:00", 
"2013-11-03 05:00:00", "2014-03-09 06:00:00", "2014-11-02 05:00:00", 
"2015-03-08 06:00:00", "2015-11-01 05:00:00", "2016-03-13 06:00:00", 
"2016-11-06 05:00:00", "2017-03-12 06:00:00", "2017-11-05 05:00:00", 
"2018-03-11 06:00:00", "2018-11-04 05:00:00", "2019-03-10 06:00:00", 
"2019-11-03 05:00:00", "2020-03-08 06:00:00", "2020-11-01 05:00:00", 
"2021-03-14 06:00:00", "2021-11-07 05:00:00", "2022-03-13 06:00:00", 
"2022-11-06 05:00:00", "2023-03-12 06:00:00", "2023-11-05 05:00:00", 
"2024-03-10 06:00:00", "2024-11-03 05:00:00", "2025-03-09 06:00:00", 
"2025-11-02 05:00:00", "2026-03-08 06:00:00", "2026-11-01 05:00:00", 
"2027-03-14 06:00:00", "2027-11-07 05:00:00", "2028-03-12 06:00:00", 
"2028-11-05 05:00:00", "2029-03-11 06:00:00", "2029-11-04 05:00:00", 
"2030-03-10 06:00:00", "2030-11-03 05:00:00", "2031-03-09 06:00:00", 
"2031-11-02 05:00:00", "2032-03-14 06:00:00", "2032-11-07 05:00:00", 
"2033-03-13 06:00:00", "2033-11-06 05:00:00", "2034-03-12 06:00:00", 
"2034-11-05 05:00:00", "2035-03-11 06:00:00", "2035-11-04 05:00:00", 
"2036-03-09 06:00:00", "2036-11-02 05:00:00", "2037-03-08 06:00:00", 
"2037-11-01 05:00:00"), offSet = c(-15264L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "APT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST"), numeric = c(-2147397248, -2131645536, -1696276800, -1680469200, 
-1632074400, -1614798000, -1566763200, -1557090000, -1535486400, 
-1524949200, -1504468800, -1493413200, -1472414400, -1461963600, 
-1440964800, -1429390800, -1409515200, -1396731600, -1376856000, 
-1366491600, -1346616000, -1333832400, -1313956800, -1303678800, 
-1282507200, -1272661200, -1251057600, -1240088400, -1219608000, 
-1207429200, -1188763200, -1175979600, -1157313600, -1143925200, 
-1124049600, -1113771600, -1091390400, -1081026000, -1059854400, 
-1050786000, -1030910400, -1018126800, -999460800, -986677200, 
-965592000, -955227600, -935956800, -923173200, -904507200, -891723600, 
-769395600, -765399600, -747252000, -733950000, -715802400, -702500400, 
-684352800, -671050800, -652903200, -639601200, -589399200, -576097200, 
-557949600, -544647600, -526500000, -513198000, -495050400, -481748400, 
-431546400, -418244400, -400096800, -386794800, -368647200, -355345200, 
-337197600, -323895600, -242244000, -226522800, -210794400, -195073200, 
-179344800, -163623600, -147895200, -131569200, -116445600, -100119600, 
-84391200, -68670000, -52941600, -37220400, -21492000, -5770800, 
9957600, 25678800, 41407200, 57733200, 73461600, 89182800, 104911200, 
120632400, 136360800, 152082000, 167810400, 183531600, 199260000, 
215586000, 230709600, 247035600, 262764000, 278485200, 294213600, 
309934800, 325663200, 341384400, 357112800, 372834000, 388562400, 
404888400, 420012000, 436338000, 452066400, 467787600, 483516000, 
499237200, 514965600, 530686800, 544600800, 562136400, 576050400, 
594190800, 607500000, 625640400, 638949600, 657090000, 671004000, 
688539600, 702453600, 719989200, 733903200, 752043600, 765352800, 
783493200, 796802400, 814942800, 828856800, 846392400, 860306400, 
877842000, 891756000, 909291600, 923205600, 941346000, 954655200, 
972795600, 986104800, 1004245200, 1018159200, 1035694800, 1049608800, 
1067144400, 1081058400, 1099198800, 1112508000, 1130648400, 1143957600, 
1162098000, 1173592800, 1194152400, 1205042400, 1225602000, 1236492000, 
1257051600, 1268546400, 1289106000, 1299996000, 1320555600, 1331445600, 
1352005200, 1362895200, 1383454800, 1394344800, 1414904400, 1425794400, 
1446354000, 1457848800, 1478408400, 1489298400, 1509858000, 1520748000, 
1541307600, 1552197600, 1572757200, 1583647200, 1604206800, 1615701600, 
1636261200, 1647151200, 1667710800, 1678600800, 1699160400, 1710050400, 
1730610000, 1741500000, 1762059600, 1772949600, 1793509200, 1805004000, 
1825563600, 1836453600, 1857013200, 1867903200, 1888462800, 1899352800, 
1919912400, 1930802400, 1951362000, 1962856800, 1983416400, 1994306400, 
2014866000, 2025756000, 2046315600, 2057205600, 2077765200, 2088655200, 
2109214800, 2120104800, 2140664400)), .Names = c("Halifax", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -228L), class = "data.frame")
}

"Havana" <- function () {
structure(list(Havana = c("1901-12-14 20:45:52", "1925-07-19 17:29:36", 
"1928-06-10 05:00:00", "1928-10-10 04:00:00", "1940-06-02 05:00:00", 
"1940-09-01 04:00:00", "1941-06-01 05:00:00", "1941-09-07 04:00:00", 
"1942-06-07 05:00:00", "1942-09-06 04:00:00", "1945-06-03 05:00:00", 
"1945-09-02 04:00:00", "1946-06-02 05:00:00", "1946-09-01 04:00:00", 
"1965-06-01 05:00:00", "1965-09-30 04:00:00", "1966-05-29 05:00:00", 
"1966-10-02 04:00:00", "1967-04-08 05:00:00", "1967-09-10 04:00:00", 
"1968-04-14 05:00:00", "1968-09-08 04:00:00", "1969-04-27 05:00:00", 
"1969-10-26 04:00:00", "1970-04-26 05:00:00", "1970-10-25 04:00:00", 
"1971-04-25 05:00:00", "1971-10-31 04:00:00", "1972-04-30 05:00:00", 
"1972-10-08 04:00:00", "1973-04-29 05:00:00", "1973-10-08 04:00:00", 
"1974-04-28 05:00:00", "1974-10-08 04:00:00", "1975-04-27 05:00:00", 
"1975-10-26 04:00:00", "1976-04-25 05:00:00", "1976-10-31 04:00:00", 
"1977-04-24 05:00:00", "1977-10-30 04:00:00", "1978-05-07 05:00:00", 
"1978-10-08 04:00:00", "1979-03-18 05:00:00", "1979-10-14 04:00:00", 
"1980-03-16 05:00:00", "1980-10-12 04:00:00", "1981-05-10 05:00:00", 
"1981-10-11 04:00:00", "1982-05-09 05:00:00", "1982-10-10 04:00:00", 
"1983-05-08 05:00:00", "1983-10-09 04:00:00", "1984-05-06 05:00:00", 
"1984-10-14 04:00:00", "1985-05-05 05:00:00", "1985-10-13 04:00:00", 
"1986-03-16 05:00:00", "1986-10-12 04:00:00", "1987-03-15 05:00:00", 
"1987-10-11 04:00:00", "1988-03-20 05:00:00", "1988-10-09 04:00:00", 
"1989-03-19 05:00:00", "1989-10-08 04:00:00", "1990-04-01 05:00:00", 
"1990-10-14 04:00:00", "1991-04-07 05:00:00", "1991-10-13 05:00:00", 
"1992-04-05 05:00:00", "1992-10-11 05:00:00", "1993-04-04 05:00:00", 
"1993-10-10 05:00:00", "1994-04-03 05:00:00", "1994-10-09 05:00:00", 
"1995-04-02 05:00:00", "1995-10-08 05:00:00", "1996-04-07 05:00:00", 
"1996-10-06 05:00:00", "1997-04-06 05:00:00", "1997-10-12 05:00:00", 
"1998-03-29 05:00:00", "1998-10-25 05:00:00", "1999-03-28 05:00:00", 
"1999-10-31 05:00:00", "2000-04-02 05:00:00", "2000-10-29 05:00:00", 
"2001-04-01 05:00:00", "2001-10-28 05:00:00", "2002-04-07 05:00:00", 
"2002-10-27 05:00:00", "2003-04-06 05:00:00", "2003-10-26 05:00:00", 
"2004-04-04 05:00:00", "2006-10-29 05:00:00", "2007-03-11 05:00:00", 
"2007-10-28 05:00:00", "2008-03-16 05:00:00", "2008-10-26 05:00:00", 
"2009-03-15 05:00:00", "2009-10-25 05:00:00", "2010-03-21 05:00:00", 
"2010-10-31 05:00:00", "2011-03-20 05:00:00", "2011-10-30 05:00:00", 
"2012-03-18 05:00:00", "2012-10-28 05:00:00", "2013-03-17 05:00:00", 
"2013-10-27 05:00:00", "2014-03-16 05:00:00", "2014-10-26 05:00:00", 
"2015-03-15 05:00:00", "2015-10-25 05:00:00", "2016-03-20 05:00:00", 
"2016-10-30 05:00:00", "2017-03-19 05:00:00", "2017-10-29 05:00:00", 
"2018-03-18 05:00:00", "2018-10-28 05:00:00", "2019-03-17 05:00:00", 
"2019-10-27 05:00:00", "2020-03-15 05:00:00", "2020-10-25 05:00:00", 
"2021-03-21 05:00:00", "2021-10-31 05:00:00", "2022-03-20 05:00:00", 
"2022-10-30 05:00:00", "2023-03-19 05:00:00", "2023-10-29 05:00:00", 
"2024-03-17 05:00:00", "2024-10-27 05:00:00", "2025-03-16 05:00:00", 
"2025-10-26 05:00:00", "2026-03-15 05:00:00", "2026-10-25 05:00:00", 
"2027-03-21 05:00:00", "2027-10-31 05:00:00", "2028-03-19 05:00:00", 
"2028-10-29 05:00:00", "2029-03-18 05:00:00", "2029-10-28 05:00:00", 
"2030-03-17 05:00:00", "2030-10-27 05:00:00", "2031-03-16 05:00:00", 
"2031-10-26 05:00:00", "2032-03-21 05:00:00", "2032-10-31 05:00:00", 
"2033-03-20 05:00:00", "2033-10-30 05:00:00", "2034-03-19 05:00:00", 
"2034-10-29 05:00:00", "2035-03-18 05:00:00", "2035-10-28 05:00:00", 
"2036-03-16 05:00:00", "2036-10-26 05:00:00", "2037-03-15 05:00:00", 
"2037-10-25 05:00:00"), offSet = c(-19776L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L), isdst = c(0L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("HMT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST"), numeric = c(-2147397248, -1402813824, -1311534000, 
-1300996800, -933534000, -925675200, -902084400, -893620800, 
-870030000, -862171200, -775681200, -767822400, -744231600, -736372800, 
-144702000, -134251200, -113425200, -102542400, -86295600, -72907200, 
-54154800, -41457600, -21495600, -5774400, 9954000, 25675200, 
41403600, 57729600, 73458000, 87364800, 104907600, 118900800, 
136357200, 150436800, 167806800, 183528000, 199256400, 215582400, 
230706000, 247032000, 263365200, 276667200, 290581200, 308721600, 
322030800, 340171200, 358318800, 371620800, 389768400, 403070400, 
421218000, 434520000, 452667600, 466574400, 484117200, 498024000, 
511333200, 529473600, 542782800, 560923200, 574837200, 592372800, 
606286800, 623822400, 638946000, 655876800, 671000400, 687330000, 
702450000, 718779600, 733899600, 750229200, 765349200, 781678800, 
796798800, 813128400, 828853200, 844578000, 860302800, 876632400, 
891147600, 909291600, 922597200, 941346000, 954651600, 972795600, 
986101200, 1004245200, 1018155600, 1035694800, 1049605200, 1067144400, 
1081054800, 1162098000, 1173589200, 1193547600, 1205643600, 1224997200, 
1237093200, 1256446800, 1269147600, 1288501200, 1300597200, 1319950800, 
1332046800, 1351400400, 1363496400, 1382850000, 1394946000, 1414299600, 
1426395600, 1445749200, 1458450000, 1477803600, 1489899600, 1509253200, 
1521349200, 1540702800, 1552798800, 1572152400, 1584248400, 1603602000, 
1616302800, 1635656400, 1647752400, 1667106000, 1679202000, 1698555600, 
1710651600, 1730005200, 1742101200, 1761454800, 1773550800, 1792904400, 
1805605200, 1824958800, 1837054800, 1856408400, 1868504400, 1887858000, 
1899954000, 1919307600, 1931403600, 1950757200, 1963458000, 1982811600, 
1994907600, 2014261200, 2026357200, 2045710800, 2057806800, 2077160400, 
2089256400, 2108610000, 2120706000, 2140059600)), .Names = c("Havana", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-156L), class = "data.frame")
}

"Hermosillo" <- function () {
structure(list(Hermosillo = c("1901-12-14 20:45:52", "1922-01-01 07:00:00", 
"1927-06-11 06:00:00", "1930-11-15 06:00:00", "1931-05-02 06:00:00", 
"1931-10-01 06:00:00", "1932-04-01 07:00:00", "1942-04-24 06:00:00", 
"1949-01-14 07:00:00", "1970-01-01 08:00:00", "1996-04-07 09:00:00", 
"1996-10-27 08:00:00", "1997-04-06 09:00:00", "1997-10-26 08:00:00", 
"1998-04-05 09:00:00", "1998-10-25 08:00:00"), offSet = c(-26632L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-28800L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L), isdst = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "MST", "CST", "MST", 
"CST", "MST", "CST", "MST", "PST", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST"), numeric = c(-2147397248, -1514739600, -1343066400, 
-1234807200, -1220292000, -1207159200, -1191344400, -873828000, 
-661539600, 28800, 828867600, 846403200, 860317200, 877852800, 
891766800, 909302400)), .Names = c("Hermosillo", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -16L), class = "data.frame")
}

"Indianapolis" <- function () {
structure(list(Indianapolis = c("1901-12-14 20:45:52", "1918-03-31 08:00:00", 
"1918-10-27 07:00:00", "1919-03-30 08:00:00", "1919-10-26 07:00:00", 
"1941-06-22 08:00:00", "1941-09-28 07:00:00", "1945-08-14 23:00:00", 
"1945-09-30 07:00:00", "1946-04-28 08:00:00", "1946-09-29 07:00:00", 
"1947-04-27 08:00:00", "1947-09-28 07:00:00", "1948-04-25 08:00:00", 
"1948-09-26 07:00:00", "1949-04-24 08:00:00", "1949-09-25 07:00:00", 
"1950-04-30 08:00:00", "1950-09-24 07:00:00", "1951-04-29 08:00:00", 
"1951-09-30 07:00:00", "1952-04-27 08:00:00", "1952-09-28 07:00:00", 
"1953-04-26 08:00:00", "1953-09-27 07:00:00", "1954-04-25 08:00:00", 
"1954-09-26 07:00:00", "1955-04-24 08:00:00", "1957-09-29 07:00:00", 
"1958-04-27 08:00:00", "1969-04-27 07:00:00", "1969-10-26 06:00:00", 
"1970-04-26 07:00:00", "1970-10-25 06:00:00", "2006-04-02 07:00:00", 
"2006-10-29 06:00:00", "2007-03-11 07:00:00", "2007-11-04 06:00:00", 
"2008-03-09 07:00:00", "2008-11-02 06:00:00", "2009-03-08 07:00:00", 
"2009-11-01 06:00:00", "2010-03-14 07:00:00", "2010-11-07 06:00:00", 
"2011-03-13 07:00:00", "2011-11-06 06:00:00", "2012-03-11 07:00:00", 
"2012-11-04 06:00:00", "2013-03-10 07:00:00", "2013-11-03 06:00:00", 
"2014-03-09 07:00:00", "2014-11-02 06:00:00", "2015-03-08 07:00:00", 
"2015-11-01 06:00:00", "2016-03-13 07:00:00", "2016-11-06 06:00:00", 
"2017-03-12 07:00:00", "2017-11-05 06:00:00", "2018-03-11 07:00:00", 
"2018-11-04 06:00:00", "2019-03-10 07:00:00", "2019-11-03 06:00:00", 
"2020-03-08 07:00:00", "2020-11-01 06:00:00", "2021-03-14 07:00:00", 
"2021-11-07 06:00:00", "2022-03-13 07:00:00", "2022-11-06 06:00:00", 
"2023-03-12 07:00:00", "2023-11-05 06:00:00", "2024-03-10 07:00:00", 
"2024-11-03 06:00:00", "2025-03-09 07:00:00", "2025-11-02 06:00:00", 
"2026-03-08 07:00:00", "2026-11-01 06:00:00", "2027-03-14 07:00:00", 
"2027-11-07 06:00:00", "2028-03-12 07:00:00", "2028-11-05 06:00:00", 
"2029-03-11 07:00:00", "2029-11-04 06:00:00", "2030-03-10 07:00:00", 
"2030-11-03 06:00:00", "2031-03-09 07:00:00", "2031-11-02 06:00:00", 
"2032-03-14 07:00:00", "2032-11-07 06:00:00", "2033-03-13 07:00:00", 
"2033-11-06 06:00:00", "2034-03-12 07:00:00", "2034-11-05 06:00:00", 
"2035-03-11 07:00:00", "2035-11-04 06:00:00", "2036-03-09 07:00:00", 
"2036-11-02 06:00:00", "2037-03-08 07:00:00", "2037-11-01 06:00:00"
), offSet = c(-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CPT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "EST", "CST", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST"), numeric = c(-2147397248, 
-1633276800, -1615136400, -1601827200, -1583686800, -900259200, 
-891795600, -769395600, -765392400, -747244800, -733942800, -715795200, 
-702493200, -684345600, -671043600, -652896000, -639594000, -620841600, 
-608144400, -589392000, -576090000, -557942400, -544640400, -526492800, 
-513190800, -495043200, -481741200, -463593600, -386787600, -368640000, 
-21488400, -5767200, 9961200, 25682400, 1143961200, 1162101600, 
1173596400, 1194156000, 1205046000, 1225605600, 1236495600, 1257055200, 
1268550000, 1289109600, 1299999600, 1320559200, 1331449200, 1352008800, 
1362898800, 1383458400, 1394348400, 1414908000, 1425798000, 1446357600, 
1457852400, 1478412000, 1489302000, 1509861600, 1520751600, 1541311200, 
1552201200, 1572760800, 1583650800, 1604210400, 1615705200, 1636264800, 
1647154800, 1667714400, 1678604400, 1699164000, 1710054000, 1730613600, 
1741503600, 1762063200, 1772953200, 1793512800, 1805007600, 1825567200, 
1836457200, 1857016800, 1867906800, 1888466400, 1899356400, 1919916000, 
1930806000, 1951365600, 1962860400, 1983420000, 1994310000, 2014869600, 
2025759600, 2046319200, 2057209200, 2077768800, 2088658800, 2109218400, 
2120108400, 2140668000)), .Names = c("Indianapolis", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -98L), class = "data.frame")
}

"Knox" <- function () {
structure(list(Knox = c("1901-12-14 20:45:52", "1918-03-31 08:00:00", 
"1918-10-27 07:00:00", "1919-03-30 08:00:00", "1919-10-26 07:00:00", 
"1945-08-14 23:00:00", "1945-09-30 07:00:00", "1947-04-27 08:00:00", 
"1947-09-28 07:00:00", "1948-04-25 08:00:00", "1948-09-26 07:00:00", 
"1949-04-24 08:00:00", "1949-09-25 07:00:00", "1950-04-30 08:00:00", 
"1950-09-24 07:00:00", "1951-04-29 08:00:00", "1951-09-30 07:00:00", 
"1952-04-27 08:00:00", "1952-09-28 07:00:00", "1953-04-26 08:00:00", 
"1953-09-27 07:00:00", "1954-04-25 08:00:00", "1954-09-26 07:00:00", 
"1955-04-24 08:00:00", "1955-10-30 07:00:00", "1956-04-29 08:00:00", 
"1956-10-28 07:00:00", "1957-04-28 08:00:00", "1957-09-29 07:00:00", 
"1958-04-27 08:00:00", "1958-09-28 07:00:00", "1959-04-26 08:00:00", 
"1959-10-25 07:00:00", "1960-04-24 08:00:00", "1960-10-30 07:00:00", 
"1961-04-30 08:00:00", "1961-10-29 07:00:00", "1962-04-29 08:00:00", 
"1963-10-27 07:00:00", "1967-04-30 08:00:00", "1967-10-29 07:00:00", 
"1968-04-28 08:00:00", "1968-10-27 07:00:00", "1969-04-27 08:00:00", 
"1969-10-26 07:00:00", "1970-04-26 08:00:00", "1970-10-25 07:00:00", 
"1971-04-25 08:00:00", "1971-10-31 07:00:00", "1972-04-30 08:00:00", 
"1972-10-29 07:00:00", "1973-04-29 08:00:00", "1973-10-28 07:00:00", 
"1974-01-06 08:00:00", "1974-10-27 07:00:00", "1975-02-23 08:00:00", 
"1975-10-26 07:00:00", "1976-04-25 08:00:00", "1976-10-31 07:00:00", 
"1977-04-24 08:00:00", "1977-10-30 07:00:00", "1978-04-30 08:00:00", 
"1978-10-29 07:00:00", "1979-04-29 08:00:00", "1979-10-28 07:00:00", 
"1980-04-27 08:00:00", "1980-10-26 07:00:00", "1981-04-26 08:00:00", 
"1981-10-25 07:00:00", "1982-04-25 08:00:00", "1982-10-31 07:00:00", 
"1983-04-24 08:00:00", "1983-10-30 07:00:00", "1984-04-29 08:00:00", 
"1984-10-28 07:00:00", "1985-04-28 08:00:00", "1985-10-27 07:00:00", 
"1986-04-27 08:00:00", "1986-10-26 07:00:00", "1987-04-05 08:00:00", 
"1987-10-25 07:00:00", "1988-04-03 08:00:00", "1988-10-30 07:00:00", 
"1989-04-02 08:00:00", "1989-10-29 07:00:00", "1990-04-01 08:00:00", 
"1990-10-28 07:00:00", "2006-04-02 07:00:00", "2006-10-29 07:00:00", 
"2007-03-11 08:00:00", "2007-11-04 07:00:00", "2008-03-09 08:00:00", 
"2008-11-02 07:00:00", "2009-03-08 08:00:00", "2009-11-01 07:00:00", 
"2010-03-14 08:00:00", "2010-11-07 07:00:00", "2011-03-13 08:00:00", 
"2011-11-06 07:00:00", "2012-03-11 08:00:00", "2012-11-04 07:00:00", 
"2013-03-10 08:00:00", "2013-11-03 07:00:00", "2014-03-09 08:00:00", 
"2014-11-02 07:00:00", "2015-03-08 08:00:00", "2015-11-01 07:00:00", 
"2016-03-13 08:00:00", "2016-11-06 07:00:00", "2017-03-12 08:00:00", 
"2017-11-05 07:00:00", "2018-03-11 08:00:00", "2018-11-04 07:00:00", 
"2019-03-10 08:00:00", "2019-11-03 07:00:00", "2020-03-08 08:00:00", 
"2020-11-01 07:00:00", "2021-03-14 08:00:00", "2021-11-07 07:00:00", 
"2022-03-13 08:00:00", "2022-11-06 07:00:00", "2023-03-12 08:00:00", 
"2023-11-05 07:00:00", "2024-03-10 08:00:00", "2024-11-03 07:00:00", 
"2025-03-09 08:00:00", "2025-11-02 07:00:00", "2026-03-08 08:00:00", 
"2026-11-01 07:00:00", "2027-03-14 08:00:00", "2027-11-07 07:00:00", 
"2028-03-12 08:00:00", "2028-11-05 07:00:00", "2029-03-11 08:00:00", 
"2029-11-04 07:00:00", "2030-03-10 08:00:00", "2030-11-03 07:00:00", 
"2031-03-09 08:00:00", "2031-11-02 07:00:00", "2032-03-14 08:00:00", 
"2032-11-07 07:00:00", "2033-03-13 08:00:00", "2033-11-06 07:00:00", 
"2034-03-12 08:00:00", "2034-11-05 07:00:00", "2035-03-11 08:00:00", 
"2035-11-04 07:00:00", "2036-03-09 08:00:00", "2036-11-02 07:00:00", 
"2037-03-08 08:00:00", "2037-11-01 07:00:00"), offSet = c(-21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L), TimeZone = c("CST", "CDT", "CST", "CDT", "CST", "CPT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "EST", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST"
), numeric = c(-2147397248, -1633276800, -1615136400, -1601827200, 
-1583686800, -769395600, -765392400, -715795200, -702493200, 
-684345600, -671043600, -652896000, -639594000, -620841600, -608144400, 
-589392000, -576090000, -557942400, -544640400, -526492800, -513190800, 
-495043200, -481741200, -463593600, -447267600, -431539200, -415818000, 
-400089600, -386787600, -368640000, -355338000, -337190400, -321469200, 
-305740800, -289414800, -273686400, -257965200, -242236800, -195066000, 
-84384000, -68662800, -52934400, -37213200, -21484800, -5763600, 
9964800, 25686000, 41414400, 57740400, 73468800, 89190000, 104918400, 
120639600, 126691200, 152089200, 162374400, 183538800, 199267200, 
215593200, 230716800, 247042800, 262771200, 278492400, 294220800, 
309942000, 325670400, 341391600, 357120000, 372841200, 388569600, 
404895600, 420019200, 436345200, 452073600, 467794800, 483523200, 
499244400, 514972800, 530694000, 544608000, 562143600, 576057600, 
594198000, 607507200, 625647600, 638956800, 657097200, 1143961200, 
1162105200, 1173600000, 1194159600, 1205049600, 1225609200, 1236499200, 
1257058800, 1268553600, 1289113200, 1300003200, 1320562800, 1331452800, 
1352012400, 1362902400, 1383462000, 1394352000, 1414911600, 1425801600, 
1446361200, 1457856000, 1478415600, 1489305600, 1509865200, 1520755200, 
1541314800, 1552204800, 1572764400, 1583654400, 1604214000, 1615708800, 
1636268400, 1647158400, 1667718000, 1678608000, 1699167600, 1710057600, 
1730617200, 1741507200, 1762066800, 1772956800, 1793516400, 1805011200, 
1825570800, 1836460800, 1857020400, 1867910400, 1888470000, 1899360000, 
1919919600, 1930809600, 1951369200, 1962864000, 1983423600, 1994313600, 
2014873200, 2025763200, 2046322800, 2057212800, 2077772400, 2088662400, 
2109222000, 2120112000, 2140671600)), .Names = c("Knox", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -151L), class = "data.frame")
}

"Marengo" <- function () {
structure(list(Marengo = c("1901-12-14 20:45:52", "1918-03-31 08:00:00", 
"1918-10-27 07:00:00", "1919-03-30 08:00:00", "1919-10-26 07:00:00", 
"1945-08-14 23:00:00", "1945-09-30 07:00:00", "1951-04-29 08:00:00", 
"1951-09-30 07:00:00", "1954-04-25 08:00:00", "1954-09-26 07:00:00", 
"1955-04-24 08:00:00", "1955-09-25 07:00:00", "1956-04-29 08:00:00", 
"1956-09-30 07:00:00", "1957-04-28 08:00:00", "1957-09-29 07:00:00", 
"1958-04-27 08:00:00", "1958-09-28 07:00:00", "1959-04-26 08:00:00", 
"1959-09-27 07:00:00", "1960-04-24 08:00:00", "1960-09-25 07:00:00", 
"1961-04-30 08:00:00", "1969-04-27 07:00:00", "1969-10-26 06:00:00", 
"1970-04-26 07:00:00", "1970-10-25 06:00:00", "1971-04-25 07:00:00", 
"1971-10-31 06:00:00", "1972-04-30 07:00:00", "1972-10-29 06:00:00", 
"1973-04-29 07:00:00", "1974-10-27 07:00:00", "1975-02-23 07:00:00", 
"1975-10-26 06:00:00", "2006-04-02 07:00:00", "2006-10-29 06:00:00", 
"2007-03-11 07:00:00", "2007-11-04 06:00:00", "2008-03-09 07:00:00", 
"2008-11-02 06:00:00", "2009-03-08 07:00:00", "2009-11-01 06:00:00", 
"2010-03-14 07:00:00", "2010-11-07 06:00:00", "2011-03-13 07:00:00", 
"2011-11-06 06:00:00", "2012-03-11 07:00:00", "2012-11-04 06:00:00", 
"2013-03-10 07:00:00", "2013-11-03 06:00:00", "2014-03-09 07:00:00", 
"2014-11-02 06:00:00", "2015-03-08 07:00:00", "2015-11-01 06:00:00", 
"2016-03-13 07:00:00", "2016-11-06 06:00:00", "2017-03-12 07:00:00", 
"2017-11-05 06:00:00", "2018-03-11 07:00:00", "2018-11-04 06:00:00", 
"2019-03-10 07:00:00", "2019-11-03 06:00:00", "2020-03-08 07:00:00", 
"2020-11-01 06:00:00", "2021-03-14 07:00:00", "2021-11-07 06:00:00", 
"2022-03-13 07:00:00", "2022-11-06 06:00:00", "2023-03-12 07:00:00", 
"2023-11-05 06:00:00", "2024-03-10 07:00:00", "2024-11-03 06:00:00", 
"2025-03-09 07:00:00", "2025-11-02 06:00:00", "2026-03-08 07:00:00", 
"2026-11-01 06:00:00", "2027-03-14 07:00:00", "2027-11-07 06:00:00", 
"2028-03-12 07:00:00", "2028-11-05 06:00:00", "2029-03-11 07:00:00", 
"2029-11-04 06:00:00", "2030-03-10 07:00:00", "2030-11-03 06:00:00", 
"2031-03-09 07:00:00", "2031-11-02 06:00:00", "2032-03-14 07:00:00", 
"2032-11-07 06:00:00", "2033-03-13 07:00:00", "2033-11-06 06:00:00", 
"2034-03-12 07:00:00", "2034-11-05 06:00:00", "2035-03-11 07:00:00", 
"2035-11-04 06:00:00", "2036-03-09 07:00:00", "2036-11-02 06:00:00", 
"2037-03-08 07:00:00", "2037-11-01 06:00:00"), offSet = c(-21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("CST", "CDT", 
"CST", "CDT", "CST", "CPT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST"), numeric = c(-2147397248, 
-1633276800, -1615136400, -1601827200, -1583686800, -769395600, 
-765392400, -589392000, -576090000, -495043200, -481741200, -463593600, 
-450291600, -431539200, -418237200, -400089600, -386787600, -368640000, 
-355338000, -337190400, -323888400, -305740800, -292438800, -273686400, 
-21488400, -5767200, 9961200, 25682400, 41410800, 57736800, 73465200, 
89186400, 104914800, 152089200, 162370800, 183535200, 1143961200, 
1162101600, 1173596400, 1194156000, 1205046000, 1225605600, 1236495600, 
1257055200, 1268550000, 1289109600, 1299999600, 1320559200, 1331449200, 
1352008800, 1362898800, 1383458400, 1394348400, 1414908000, 1425798000, 
1446357600, 1457852400, 1478412000, 1489302000, 1509861600, 1520751600, 
1541311200, 1552201200, 1572760800, 1583650800, 1604210400, 1615705200, 
1636264800, 1647154800, 1667714400, 1678604400, 1699164000, 1710054000, 
1730613600, 1741503600, 1762063200, 1772953200, 1793512800, 1805007600, 
1825567200, 1836457200, 1857016800, 1867906800, 1888466400, 1899356400, 
1919916000, 1930806000, 1951365600, 1962860400, 1983420000, 1994310000, 
2014869600, 2025759600, 2046319200, 2057209200, 2077768800, 2088658800, 
2109218400, 2120108400, 2140668000)), .Names = c("Marengo", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -100L), class = "data.frame")
}

"Petersburg" <- function () {
structure(list(Petersburg = c("1901-12-14 20:45:52", "1918-03-31 08:00:00", 
"1918-10-27 07:00:00", "1919-03-30 08:00:00", "1919-10-26 07:00:00", 
"1945-08-14 23:00:00", "1945-09-30 07:00:00", "1955-05-01 06:00:00", 
"1955-09-25 07:00:00", "1956-04-29 08:00:00", "1956-09-30 07:00:00", 
"1957-04-28 08:00:00", "1957-09-29 07:00:00", "1958-04-27 08:00:00", 
"1958-09-28 07:00:00", "1959-04-26 08:00:00", "1959-09-27 07:00:00", 
"1960-04-24 08:00:00", "1960-09-25 07:00:00", "1961-04-30 08:00:00", 
"1961-10-29 07:00:00", "1962-04-29 08:00:00", "1962-10-28 07:00:00", 
"1963-04-28 08:00:00", "1963-10-27 07:00:00", "1964-04-26 08:00:00", 
"1964-10-25 07:00:00", "1965-04-25 08:00:00", "1966-10-30 07:00:00", 
"1967-04-30 08:00:00", "1967-10-29 07:00:00", "1968-04-28 08:00:00", 
"1968-10-27 07:00:00", "1969-04-27 08:00:00", "1969-10-26 07:00:00", 
"1970-04-26 08:00:00", "1970-10-25 07:00:00", "1971-04-25 08:00:00", 
"1971-10-31 07:00:00", "1972-04-30 08:00:00", "1972-10-29 07:00:00", 
"1973-04-29 08:00:00", "1973-10-28 07:00:00", "1974-01-06 08:00:00", 
"1974-10-27 07:00:00", "1975-02-23 08:00:00", "1975-10-26 07:00:00", 
"1976-04-25 08:00:00", "1976-10-31 07:00:00", "2006-04-02 07:00:00", 
"2006-10-29 07:00:00", "2007-11-04 07:00:00", "2008-03-09 07:00:00", 
"2008-11-02 06:00:00", "2009-03-08 07:00:00", "2009-11-01 06:00:00", 
"2010-03-14 07:00:00", "2010-11-07 06:00:00", "2011-03-13 07:00:00", 
"2011-11-06 06:00:00", "2012-03-11 07:00:00", "2012-11-04 06:00:00", 
"2013-03-10 07:00:00", "2013-11-03 06:00:00", "2014-03-09 07:00:00", 
"2014-11-02 06:00:00", "2015-03-08 07:00:00", "2015-11-01 06:00:00", 
"2016-03-13 07:00:00", "2016-11-06 06:00:00", "2017-03-12 07:00:00", 
"2017-11-05 06:00:00", "2018-03-11 07:00:00", "2018-11-04 06:00:00", 
"2019-03-10 07:00:00", "2019-11-03 06:00:00", "2020-03-08 07:00:00", 
"2020-11-01 06:00:00", "2021-03-14 07:00:00", "2021-11-07 06:00:00", 
"2022-03-13 07:00:00", "2022-11-06 06:00:00", "2023-03-12 07:00:00", 
"2023-11-05 06:00:00", "2024-03-10 07:00:00", "2024-11-03 06:00:00", 
"2025-03-09 07:00:00", "2025-11-02 06:00:00", "2026-03-08 07:00:00", 
"2026-11-01 06:00:00", "2027-03-14 07:00:00", "2027-11-07 06:00:00", 
"2028-03-12 07:00:00", "2028-11-05 06:00:00", "2029-03-11 07:00:00", 
"2029-11-04 06:00:00", "2030-03-10 07:00:00", "2030-11-03 06:00:00", 
"2031-03-09 07:00:00", "2031-11-02 06:00:00", "2032-03-14 07:00:00", 
"2032-11-07 06:00:00", "2033-03-13 07:00:00", "2033-11-06 06:00:00", 
"2034-03-12 07:00:00", "2034-11-05 06:00:00", "2035-03-11 07:00:00", 
"2035-11-04 06:00:00", "2036-03-09 07:00:00", "2036-11-02 06:00:00", 
"2037-03-08 07:00:00", "2037-11-01 06:00:00"), offSet = c(-21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L), isdst = c(0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), 
    TimeZone = c("CST", "CDT", "CST", "CDT", "CST", "CPT", "CST", 
    "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
    "CDT", "CST", "EST", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
    "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "EST", 
    "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
    "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
    "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
    "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
    "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
    "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
    "EDT", "EST", "EDT", "EST", "EDT", "EST"), numeric = c(-2147397248, 
    -1633276800, -1615136400, -1601827200, -1583686800, -769395600, 
    -765392400, -462996000, -450291600, -431539200, -418237200, 
    -400089600, -386787600, -368640000, -355338000, -337190400, 
    -323888400, -305740800, -292438800, -273686400, -257965200, 
    -242236800, -226515600, -210787200, -195066000, -179337600, 
    -163616400, -147888000, -100112400, -84384000, -68662800, 
    -52934400, -37213200, -21484800, -5763600, 9964800, 25686000, 
    41414400, 57740400, 73468800, 89190000, 104918400, 120639600, 
    126691200, 152089200, 162374400, 183538800, 199267200, 215593200, 
    1143961200, 1162105200, 1194159600, 1205046000, 1225605600, 
    1236495600, 1257055200, 1268550000, 1289109600, 1299999600, 
    1320559200, 1331449200, 1352008800, 1362898800, 1383458400, 
    1394348400, 1414908000, 1425798000, 1446357600, 1457852400, 
    1478412000, 1489302000, 1509861600, 1520751600, 1541311200, 
    1552201200, 1572760800, 1583650800, 1604210400, 1615705200, 
    1636264800, 1647154800, 1667714400, 1678604400, 1699164000, 
    1710054000, 1730613600, 1741503600, 1762063200, 1772953200, 
    1793512800, 1805007600, 1825567200, 1836457200, 1857016800, 
    1867906800, 1888466400, 1899356400, 1919916000, 1930806000, 
    1951365600, 1962860400, 1983420000, 1994310000, 2014869600, 
    2025759600, 2046319200, 2057209200, 2077768800, 2088658800, 
    2109218400, 2120108400, 2140668000)), .Names = c("Petersburg", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-112L), class = "data.frame")
}

"Tell_City" <- function () {
structure(list(Tell_City = c("1901-12-14 20:45:52", "1918-03-31 08:00:00", 
"1918-10-27 07:00:00", "1919-03-30 08:00:00", "1919-10-26 07:00:00", 
"1945-08-14 23:00:00", "1945-09-30 07:00:00", "1946-04-28 08:00:00", 
"1946-09-29 07:00:00", "1953-04-26 08:00:00", "1953-09-27 07:00:00", 
"1954-04-25 08:00:00", "1954-09-26 07:00:00", "1955-05-01 06:00:00", 
"1955-09-25 07:00:00", "1956-04-29 08:00:00", "1956-09-30 07:00:00", 
"1957-04-28 08:00:00", "1957-09-29 07:00:00", "1958-04-27 08:00:00", 
"1958-09-28 07:00:00", "1959-04-26 08:00:00", "1959-09-27 07:00:00", 
"1960-04-24 08:00:00", "1960-10-30 07:00:00", "1961-04-30 08:00:00", 
"1961-09-24 07:00:00", "1962-04-29 08:00:00", "1962-10-28 07:00:00", 
"1963-04-28 08:00:00", "1963-10-27 07:00:00", "1964-04-26 08:00:00", 
"1969-04-27 07:00:00", "1969-10-26 06:00:00", "1970-04-26 07:00:00", 
"2006-04-02 07:00:00", "2006-10-29 07:00:00", "2007-03-11 08:00:00", 
"2007-11-04 07:00:00", "2008-03-09 08:00:00", "2008-11-02 07:00:00", 
"2009-03-08 08:00:00", "2009-11-01 07:00:00", "2010-03-14 08:00:00", 
"2010-11-07 07:00:00", "2011-03-13 08:00:00", "2011-11-06 07:00:00", 
"2012-03-11 08:00:00", "2012-11-04 07:00:00", "2013-03-10 08:00:00", 
"2013-11-03 07:00:00", "2014-03-09 08:00:00", "2014-11-02 07:00:00", 
"2015-03-08 08:00:00", "2015-11-01 07:00:00", "2016-03-13 08:00:00", 
"2016-11-06 07:00:00", "2017-03-12 08:00:00", "2017-11-05 07:00:00", 
"2018-03-11 08:00:00", "2018-11-04 07:00:00", "2019-03-10 08:00:00", 
"2019-11-03 07:00:00", "2020-03-08 08:00:00", "2020-11-01 07:00:00", 
"2021-03-14 08:00:00", "2021-11-07 07:00:00", "2022-03-13 08:00:00", 
"2022-11-06 07:00:00", "2023-03-12 08:00:00", "2023-11-05 07:00:00", 
"2024-03-10 08:00:00", "2024-11-03 07:00:00", "2025-03-09 08:00:00", 
"2025-11-02 07:00:00", "2026-03-08 08:00:00", "2026-11-01 07:00:00", 
"2027-03-14 08:00:00", "2027-11-07 07:00:00", "2028-03-12 08:00:00", 
"2028-11-05 07:00:00", "2029-03-11 08:00:00", "2029-11-04 07:00:00", 
"2030-03-10 08:00:00", "2030-11-03 07:00:00", "2031-03-09 08:00:00", 
"2031-11-02 07:00:00", "2032-03-14 08:00:00", "2032-11-07 07:00:00", 
"2033-03-13 08:00:00", "2033-11-06 07:00:00", "2034-03-12 08:00:00", 
"2034-11-05 07:00:00", "2035-03-11 08:00:00", "2035-11-04 07:00:00", 
"2036-03-09 08:00:00", "2036-11-02 07:00:00", "2037-03-08 08:00:00", 
"2037-11-01 07:00:00"), offSet = c(-21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L), isdst = c(0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 
1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L), TimeZone = c("CST", "CDT", "CST", "CDT", "CST", "CPT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "EST", "EDT", "EST", 
"EDT", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST"), numeric = c(-2147397248, -1633276800, -1615136400, 
-1601827200, -1583686800, -769395600, -765392400, -747244800, 
-733942800, -526492800, -513190800, -495043200, -481741200, -462996000, 
-450291600, -431539200, -418237200, -400089600, -386787600, -368640000, 
-355338000, -337190400, -323888400, -305740800, -289414800, -273686400, 
-260989200, -242236800, -226515600, -210787200, -195066000, -179337600, 
-21488400, -5767200, 9961200, 1143961200, 1162105200, 1173600000, 
1194159600, 1205049600, 1225609200, 1236499200, 1257058800, 1268553600, 
1289113200, 1300003200, 1320562800, 1331452800, 1352012400, 1362902400, 
1383462000, 1394352000, 1414911600, 1425801600, 1446361200, 1457856000, 
1478415600, 1489305600, 1509865200, 1520755200, 1541314800, 1552204800, 
1572764400, 1583654400, 1604214000, 1615708800, 1636268400, 1647158400, 
1667718000, 1678608000, 1699167600, 1710057600, 1730617200, 1741507200, 
1762066800, 1772956800, 1793516400, 1805011200, 1825570800, 1836460800, 
1857020400, 1867910400, 1888470000, 1899360000, 1919919600, 1930809600, 
1951369200, 1962864000, 1983423600, 1994313600, 2014873200, 2025763200, 
2046322800, 2057212800, 2077772400, 2088662400, 2109222000, 2120112000, 
2140671600)), .Names = c("Tell_City", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -99L), class = "data.frame")
}

"Vevay" <- function () {
structure(list(Vevay = c("1901-12-14 20:45:52", "1918-03-31 08:00:00", 
"1918-10-27 07:00:00", "1919-03-30 08:00:00", "1919-10-26 07:00:00", 
"1945-08-14 23:00:00", "1945-09-30 07:00:00", "1954-04-25 08:00:00", 
"1969-04-27 07:00:00", "1969-10-26 06:00:00", "1970-04-26 07:00:00", 
"1970-10-25 06:00:00", "1971-04-25 07:00:00", "1971-10-31 06:00:00", 
"1972-04-30 07:00:00", "1972-10-29 06:00:00", "2006-04-02 07:00:00", 
"2006-10-29 06:00:00", "2007-03-11 07:00:00", "2007-11-04 06:00:00", 
"2008-03-09 07:00:00", "2008-11-02 06:00:00", "2009-03-08 07:00:00", 
"2009-11-01 06:00:00", "2010-03-14 07:00:00", "2010-11-07 06:00:00", 
"2011-03-13 07:00:00", "2011-11-06 06:00:00", "2012-03-11 07:00:00", 
"2012-11-04 06:00:00", "2013-03-10 07:00:00", "2013-11-03 06:00:00", 
"2014-03-09 07:00:00", "2014-11-02 06:00:00", "2015-03-08 07:00:00", 
"2015-11-01 06:00:00", "2016-03-13 07:00:00", "2016-11-06 06:00:00", 
"2017-03-12 07:00:00", "2017-11-05 06:00:00", "2018-03-11 07:00:00", 
"2018-11-04 06:00:00", "2019-03-10 07:00:00", "2019-11-03 06:00:00", 
"2020-03-08 07:00:00", "2020-11-01 06:00:00", "2021-03-14 07:00:00", 
"2021-11-07 06:00:00", "2022-03-13 07:00:00", "2022-11-06 06:00:00", 
"2023-03-12 07:00:00", "2023-11-05 06:00:00", "2024-03-10 07:00:00", 
"2024-11-03 06:00:00", "2025-03-09 07:00:00", "2025-11-02 06:00:00", 
"2026-03-08 07:00:00", "2026-11-01 06:00:00", "2027-03-14 07:00:00", 
"2027-11-07 06:00:00", "2028-03-12 07:00:00", "2028-11-05 06:00:00", 
"2029-03-11 07:00:00", "2029-11-04 06:00:00", "2030-03-10 07:00:00", 
"2030-11-03 06:00:00", "2031-03-09 07:00:00", "2031-11-02 06:00:00", 
"2032-03-14 07:00:00", "2032-11-07 06:00:00", "2033-03-13 07:00:00", 
"2033-11-06 06:00:00", "2034-03-12 07:00:00", "2034-11-05 06:00:00", 
"2035-03-11 07:00:00", "2035-11-04 06:00:00", "2036-03-09 07:00:00", 
"2036-11-02 06:00:00", "2037-03-08 07:00:00", "2037-11-01 06:00:00"
), offSet = c(-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L), isdst = c(0L, 1L, 0L, 1L, 
0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("CST", 
"CDT", "CST", "CDT", "CST", "CPT", "CST", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST"), numeric = c(-2147397248, 
-1633276800, -1615136400, -1601827200, -1583686800, -769395600, 
-765392400, -495043200, -21488400, -5767200, 9961200, 25682400, 
41410800, 57736800, 73465200, 89186400, 1143961200, 1162101600, 
1173596400, 1194156000, 1205046000, 1225605600, 1236495600, 1257055200, 
1268550000, 1289109600, 1299999600, 1320559200, 1331449200, 1352008800, 
1362898800, 1383458400, 1394348400, 1414908000, 1425798000, 1446357600, 
1457852400, 1478412000, 1489302000, 1509861600, 1520751600, 1541311200, 
1552201200, 1572760800, 1583650800, 1604210400, 1615705200, 1636264800, 
1647154800, 1667714400, 1678604400, 1699164000, 1710054000, 1730613600, 
1741503600, 1762063200, 1772953200, 1793512800, 1805007600, 1825567200, 
1836457200, 1857016800, 1867906800, 1888466400, 1899356400, 1919916000, 
1930806000, 1951365600, 1962860400, 1983420000, 1994310000, 2014869600, 
2025759600, 2046319200, 2057209200, 2077768800, 2088658800, 2109218400, 
2120108400, 2140668000)), .Names = c("Vevay", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -80L), class = "data.frame")
}

"Vincennes" <- function () {
structure(list(Vincennes = c("1901-12-14 20:45:52", "1918-03-31 08:00:00", 
"1918-10-27 07:00:00", "1919-03-30 08:00:00", "1919-10-26 07:00:00", 
"1945-08-14 23:00:00", "1945-09-30 07:00:00", "1946-04-28 08:00:00", 
"1946-09-29 07:00:00", "1953-04-26 08:00:00", "1953-09-27 07:00:00", 
"1954-04-25 08:00:00", "1954-09-26 07:00:00", "1955-05-01 06:00:00", 
"1955-09-25 07:00:00", "1956-04-29 08:00:00", "1956-09-30 07:00:00", 
"1957-04-28 08:00:00", "1957-09-29 07:00:00", "1958-04-27 08:00:00", 
"1958-09-28 07:00:00", "1959-04-26 08:00:00", "1959-09-27 07:00:00", 
"1960-04-24 08:00:00", "1960-10-30 07:00:00", "1961-04-30 08:00:00", 
"1961-09-24 07:00:00", "1962-04-29 08:00:00", "1962-10-28 07:00:00", 
"1963-04-28 08:00:00", "1963-10-27 07:00:00", "1964-04-26 08:00:00", 
"1969-04-27 07:00:00", "1969-10-26 06:00:00", "1970-04-26 07:00:00", 
"2006-04-02 07:00:00", "2006-10-29 07:00:00", "2007-11-04 07:00:00", 
"2008-03-09 07:00:00", "2008-11-02 06:00:00", "2009-03-08 07:00:00", 
"2009-11-01 06:00:00", "2010-03-14 07:00:00", "2010-11-07 06:00:00", 
"2011-03-13 07:00:00", "2011-11-06 06:00:00", "2012-03-11 07:00:00", 
"2012-11-04 06:00:00", "2013-03-10 07:00:00", "2013-11-03 06:00:00", 
"2014-03-09 07:00:00", "2014-11-02 06:00:00", "2015-03-08 07:00:00", 
"2015-11-01 06:00:00", "2016-03-13 07:00:00", "2016-11-06 06:00:00", 
"2017-03-12 07:00:00", "2017-11-05 06:00:00", "2018-03-11 07:00:00", 
"2018-11-04 06:00:00", "2019-03-10 07:00:00", "2019-11-03 06:00:00", 
"2020-03-08 07:00:00", "2020-11-01 06:00:00", "2021-03-14 07:00:00", 
"2021-11-07 06:00:00", "2022-03-13 07:00:00", "2022-11-06 06:00:00", 
"2023-03-12 07:00:00", "2023-11-05 06:00:00", "2024-03-10 07:00:00", 
"2024-11-03 06:00:00", "2025-03-09 07:00:00", "2025-11-02 06:00:00", 
"2026-03-08 07:00:00", "2026-11-01 06:00:00", "2027-03-14 07:00:00", 
"2027-11-07 06:00:00", "2028-03-12 07:00:00", "2028-11-05 06:00:00", 
"2029-03-11 07:00:00", "2029-11-04 06:00:00", "2030-03-10 07:00:00", 
"2030-11-03 06:00:00", "2031-03-09 07:00:00", "2031-11-02 06:00:00", 
"2032-03-14 07:00:00", "2032-11-07 06:00:00", "2033-03-13 07:00:00", 
"2033-11-06 06:00:00", "2034-03-12 07:00:00", "2034-11-05 06:00:00", 
"2035-03-11 07:00:00", "2035-11-04 06:00:00", "2036-03-09 07:00:00", 
"2036-11-02 06:00:00", "2037-03-08 07:00:00", "2037-11-01 06:00:00"
), offSet = c(-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -21600L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("CST", "CDT", "CST", 
"CDT", "CST", "CPT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "EST", "EDT", "EST", "EDT", "CDT", "CST", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST"), numeric = c(-2147397248, 
-1633276800, -1615136400, -1601827200, -1583686800, -769395600, 
-765392400, -747244800, -733942800, -526492800, -513190800, -495043200, 
-481741200, -462996000, -450291600, -431539200, -418237200, -400089600, 
-386787600, -368640000, -355338000, -337190400, -323888400, -305740800, 
-289414800, -273686400, -260989200, -242236800, -226515600, -210787200, 
-195066000, -179337600, -21488400, -5767200, 9961200, 1143961200, 
1162105200, 1194159600, 1205046000, 1225605600, 1236495600, 1257055200, 
1268550000, 1289109600, 1299999600, 1320559200, 1331449200, 1352008800, 
1362898800, 1383458400, 1394348400, 1414908000, 1425798000, 1446357600, 
1457852400, 1478412000, 1489302000, 1509861600, 1520751600, 1541311200, 
1552201200, 1572760800, 1583650800, 1604210400, 1615705200, 1636264800, 
1647154800, 1667714400, 1678604400, 1699164000, 1710054000, 1730613600, 
1741503600, 1762063200, 1772953200, 1793512800, 1805007600, 1825567200, 
1836457200, 1857016800, 1867906800, 1888466400, 1899356400, 1919916000, 
1930806000, 1951365600, 1962860400, 1983420000, 1994310000, 2014869600, 
2025759600, 2046319200, 2057209200, 2077768800, 2088658800, 2109218400, 
2120108400, 2140668000)), .Names = c("Vincennes", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -98L), class = "data.frame")
}

"Winamac" <- function () {
structure(list(Winamac = c("1901-12-14 20:45:52", "1918-03-31 08:00:00", 
"1918-10-27 07:00:00", "1919-03-30 08:00:00", "1919-10-26 07:00:00", 
"1945-08-14 23:00:00", "1945-09-30 07:00:00", "1946-04-28 08:00:00", 
"1946-09-29 07:00:00", "1947-04-27 08:00:00", "1947-09-28 07:00:00", 
"1948-04-25 08:00:00", "1948-09-26 07:00:00", "1949-04-24 08:00:00", 
"1949-09-25 07:00:00", "1950-04-30 08:00:00", "1950-09-24 07:00:00", 
"1951-04-29 08:00:00", "1951-09-30 07:00:00", "1952-04-27 08:00:00", 
"1952-09-28 07:00:00", "1953-04-26 08:00:00", "1953-09-27 07:00:00", 
"1954-04-25 08:00:00", "1954-09-26 07:00:00", "1955-04-24 08:00:00", 
"1955-10-30 07:00:00", "1956-04-29 08:00:00", "1956-10-28 07:00:00", 
"1957-04-28 08:00:00", "1957-09-29 07:00:00", "1958-04-27 08:00:00", 
"1958-09-28 07:00:00", "1959-04-26 08:00:00", "1959-09-27 07:00:00", 
"1960-04-24 08:00:00", "1960-09-25 07:00:00", "1961-04-30 08:00:00", 
"1969-04-27 07:00:00", "1969-10-26 06:00:00", "1970-04-26 07:00:00", 
"2006-04-02 07:00:00", "2006-10-29 07:00:00", "2007-03-11 08:00:00", 
"2007-11-04 06:00:00", "2008-03-09 07:00:00", "2008-11-02 06:00:00", 
"2009-03-08 07:00:00", "2009-11-01 06:00:00", "2010-03-14 07:00:00", 
"2010-11-07 06:00:00", "2011-03-13 07:00:00", "2011-11-06 06:00:00", 
"2012-03-11 07:00:00", "2012-11-04 06:00:00", "2013-03-10 07:00:00", 
"2013-11-03 06:00:00", "2014-03-09 07:00:00", "2014-11-02 06:00:00", 
"2015-03-08 07:00:00", "2015-11-01 06:00:00", "2016-03-13 07:00:00", 
"2016-11-06 06:00:00", "2017-03-12 07:00:00", "2017-11-05 06:00:00", 
"2018-03-11 07:00:00", "2018-11-04 06:00:00", "2019-03-10 07:00:00", 
"2019-11-03 06:00:00", "2020-03-08 07:00:00", "2020-11-01 06:00:00", 
"2021-03-14 07:00:00", "2021-11-07 06:00:00", "2022-03-13 07:00:00", 
"2022-11-06 06:00:00", "2023-03-12 07:00:00", "2023-11-05 06:00:00", 
"2024-03-10 07:00:00", "2024-11-03 06:00:00", "2025-03-09 07:00:00", 
"2025-11-02 06:00:00", "2026-03-08 07:00:00", "2026-11-01 06:00:00", 
"2027-03-14 07:00:00", "2027-11-07 06:00:00", "2028-03-12 07:00:00", 
"2028-11-05 06:00:00", "2029-03-11 07:00:00", "2029-11-04 06:00:00", 
"2030-03-10 07:00:00", "2030-11-03 06:00:00", "2031-03-09 07:00:00", 
"2031-11-02 06:00:00", "2032-03-14 07:00:00", "2032-11-07 06:00:00", 
"2033-03-13 07:00:00", "2033-11-06 06:00:00", "2034-03-12 07:00:00", 
"2034-11-05 06:00:00", "2035-03-11 07:00:00", "2035-11-04 06:00:00", 
"2036-03-09 07:00:00", "2036-11-02 06:00:00", "2037-03-08 07:00:00", 
"2037-11-01 06:00:00"), offSet = c(-21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -21600L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L), isdst = c(0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 0L, 1L, 0L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L), TimeZone = c("CST", "CDT", "CST", "CDT", 
"CST", "CPT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "EST", "EDT", "EST", 
"EDT", "CDT", "CST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST"), numeric = c(-2147397248, -1633276800, -1615136400, 
-1601827200, -1583686800, -769395600, -765392400, -747244800, 
-733942800, -715795200, -702493200, -684345600, -671043600, -652896000, 
-639594000, -620841600, -608144400, -589392000, -576090000, -557942400, 
-544640400, -526492800, -513190800, -495043200, -481741200, -463593600, 
-447267600, -431539200, -415818000, -400089600, -386787600, -368640000, 
-355338000, -337190400, -323888400, -305740800, -292438800, -273686400, 
-21488400, -5767200, 9961200, 1143961200, 1162105200, 1173600000, 
1194156000, 1205046000, 1225605600, 1236495600, 1257055200, 1268550000, 
1289109600, 1299999600, 1320559200, 1331449200, 1352008800, 1362898800, 
1383458400, 1394348400, 1414908000, 1425798000, 1446357600, 1457852400, 
1478412000, 1489302000, 1509861600, 1520751600, 1541311200, 1552201200, 
1572760800, 1583650800, 1604210400, 1615705200, 1636264800, 1647154800, 
1667714400, 1678604400, 1699164000, 1710054000, 1730613600, 1741503600, 
1762063200, 1772953200, 1793512800, 1805007600, 1825567200, 1836457200, 
1857016800, 1867906800, 1888466400, 1899356400, 1919916000, 1930806000, 
1951365600, 1962860400, 1983420000, 1994310000, 2014869600, 2025759600, 
2046319200, 2057209200, 2077768800, 2088658800, 2109218400, 2120108400, 
2140668000)), .Names = c("Winamac", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -105L), class = "data.frame")
}

"Inuvik" <- function () {
structure(list(Inuvik = c("1901-12-14 20:45:52", "1953-01-01 00:00:00", 
"1965-04-25 08:00:00", "1965-10-31 08:00:00", "1979-04-29 10:00:00", 
"1980-04-27 09:00:00", "1980-10-26 08:00:00", "1981-04-26 09:00:00", 
"1981-10-25 08:00:00", "1982-04-25 09:00:00", "1982-10-31 08:00:00", 
"1983-04-24 09:00:00", "1983-10-30 08:00:00", "1984-04-29 09:00:00", 
"1984-10-28 08:00:00", "1985-04-28 09:00:00", "1985-10-27 08:00:00", 
"1986-04-27 09:00:00", "1986-10-26 08:00:00", "1987-04-05 09:00:00", 
"1987-10-25 08:00:00", "1988-04-03 09:00:00", "1988-10-30 08:00:00", 
"1989-04-02 09:00:00", "1989-10-29 08:00:00", "1990-04-01 09:00:00", 
"1990-10-28 08:00:00", "1991-04-07 09:00:00", "1991-10-27 08:00:00", 
"1992-04-05 09:00:00", "1992-10-25 08:00:00", "1993-04-04 09:00:00", 
"1993-10-31 08:00:00", "1994-04-03 09:00:00", "1994-10-30 08:00:00", 
"1995-04-02 09:00:00", "1995-10-29 08:00:00", "1996-04-07 09:00:00", 
"1996-10-27 08:00:00", "1997-04-06 09:00:00", "1997-10-26 08:00:00", 
"1998-04-05 09:00:00", "1998-10-25 08:00:00", "1999-04-04 09:00:00", 
"1999-10-31 08:00:00", "2000-04-02 09:00:00", "2000-10-29 08:00:00", 
"2001-04-01 09:00:00", "2001-10-28 08:00:00", "2002-04-07 09:00:00", 
"2002-10-27 08:00:00", "2003-04-06 09:00:00", "2003-10-26 08:00:00", 
"2004-04-04 09:00:00", "2004-10-31 08:00:00", "2005-04-03 09:00:00", 
"2005-10-30 08:00:00", "2006-04-02 09:00:00", "2006-10-29 08:00:00", 
"2007-03-11 09:00:00", "2007-11-04 08:00:00", "2008-03-09 09:00:00", 
"2008-11-02 08:00:00", "2009-03-08 09:00:00", "2009-11-01 08:00:00", 
"2010-03-14 09:00:00", "2010-11-07 08:00:00", "2011-03-13 09:00:00", 
"2011-11-06 08:00:00", "2012-03-11 09:00:00", "2012-11-04 08:00:00", 
"2013-03-10 09:00:00", "2013-11-03 08:00:00", "2014-03-09 09:00:00", 
"2014-11-02 08:00:00", "2015-03-08 09:00:00", "2015-11-01 08:00:00", 
"2016-03-13 09:00:00", "2016-11-06 08:00:00", "2017-03-12 09:00:00", 
"2017-11-05 08:00:00", "2018-03-11 09:00:00", "2018-11-04 08:00:00", 
"2019-03-10 09:00:00", "2019-11-03 08:00:00", "2020-03-08 09:00:00", 
"2020-11-01 08:00:00", "2021-03-14 09:00:00", "2021-11-07 08:00:00", 
"2022-03-13 09:00:00", "2022-11-06 08:00:00", "2023-03-12 09:00:00", 
"2023-11-05 08:00:00", "2024-03-10 09:00:00", "2024-11-03 08:00:00", 
"2025-03-09 09:00:00", "2025-11-02 08:00:00", "2026-03-08 09:00:00", 
"2026-11-01 08:00:00", "2027-03-14 09:00:00", "2027-11-07 08:00:00", 
"2028-03-12 09:00:00", "2028-11-05 08:00:00", "2029-03-11 09:00:00", 
"2029-11-04 08:00:00", "2030-03-10 09:00:00", "2030-11-03 08:00:00", 
"2031-03-09 09:00:00", "2031-11-02 08:00:00", "2032-03-14 09:00:00", 
"2032-11-07 08:00:00", "2033-03-13 09:00:00", "2033-11-06 08:00:00", 
"2034-03-12 09:00:00", "2034-11-05 08:00:00", "2035-03-11 09:00:00", 
"2035-11-04 08:00:00", "2036-03-09 09:00:00", "2036-11-02 08:00:00", 
"2037-03-08 09:00:00", "2037-11-01 08:00:00"), offSet = c(0L, 
-28800L, -21600L, -28800L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L), isdst = c(0L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("zzz", 
"PST", "PDDT", "PST", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST"), numeric = c(-2147397248, -536457600, -147888000, 
-131558400, 294228000, 325674000, 341395200, 357123600, 372844800, 
388573200, 404899200, 420022800, 436348800, 452077200, 467798400, 
483526800, 499248000, 514976400, 530697600, 544611600, 562147200, 
576061200, 594201600, 607510800, 625651200, 638960400, 657100800, 
671014800, 688550400, 702464400, 7.2e+08, 733914000, 752054400, 
765363600, 783504000, 796813200, 814953600, 828867600, 846403200, 
860317200, 877852800, 891766800, 909302400, 923216400, 941356800, 
954666000, 972806400, 986115600, 1004256000, 1018170000, 1035705600, 
1049619600, 1067155200, 1081069200, 1099209600, 1112518800, 1130659200, 
1143968400, 1162108800, 1173603600, 1194163200, 1205053200, 1225612800, 
1236502800, 1257062400, 1268557200, 1289116800, 1300006800, 1320566400, 
1331456400, 1352016000, 1362906000, 1383465600, 1394355600, 1414915200, 
1425805200, 1446364800, 1457859600, 1478419200, 1489309200, 1509868800, 
1520758800, 1541318400, 1552208400, 1572768000, 1583658000, 1604217600, 
1615712400, 1636272000, 1647162000, 1667721600, 1678611600, 1699171200, 
1710061200, 1730620800, 1741510800, 1762070400, 1772960400, 1793520000, 
1805014800, 1825574400, 1836464400, 1857024000, 1867914000, 1888473600, 
1899363600, 1919923200, 1930813200, 1951372800, 1962867600, 1983427200, 
1994317200, 2014876800, 2025766800, 2046326400, 2057216400, 2077776000, 
2088666000, 2109225600, 2120115600, 2140675200)), .Names = c("Inuvik", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-121L), class = "data.frame")
}

"Iqaluit" <- function () {
structure(list(Iqaluit = c("1901-12-14 20:45:52", "1945-08-14 23:00:00", 
"1945-09-30 06:00:00", "1965-04-25 05:00:00", "1965-10-31 05:00:00", 
"1980-04-27 07:00:00", "1980-10-26 06:00:00", "1981-04-26 07:00:00", 
"1981-10-25 06:00:00", "1982-04-25 07:00:00", "1982-10-31 06:00:00", 
"1983-04-24 07:00:00", "1983-10-30 06:00:00", "1984-04-29 07:00:00", 
"1984-10-28 06:00:00", "1985-04-28 07:00:00", "1985-10-27 06:00:00", 
"1986-04-27 07:00:00", "1986-10-26 06:00:00", "1987-04-05 07:00:00", 
"1987-10-25 06:00:00", "1988-04-03 07:00:00", "1988-10-30 06:00:00", 
"1989-04-02 07:00:00", "1989-10-29 06:00:00", "1990-04-01 07:00:00", 
"1990-10-28 06:00:00", "1991-04-07 07:00:00", "1991-10-27 06:00:00", 
"1992-04-05 07:00:00", "1992-10-25 06:00:00", "1993-04-04 07:00:00", 
"1993-10-31 06:00:00", "1994-04-03 07:00:00", "1994-10-30 06:00:00", 
"1995-04-02 07:00:00", "1995-10-29 06:00:00", "1996-04-07 07:00:00", 
"1996-10-27 06:00:00", "1997-04-06 07:00:00", "1997-10-26 06:00:00", 
"1998-04-05 07:00:00", "1998-10-25 06:00:00", "1999-04-04 07:00:00", 
"1999-10-31 06:00:00", "2000-10-29 07:00:00", "2001-04-01 07:00:00", 
"2001-10-28 06:00:00", "2002-04-07 07:00:00", "2002-10-27 06:00:00", 
"2003-04-06 07:00:00", "2003-10-26 06:00:00", "2004-04-04 07:00:00", 
"2004-10-31 06:00:00", "2005-04-03 07:00:00", "2005-10-30 06:00:00", 
"2006-04-02 07:00:00", "2006-10-29 06:00:00", "2007-03-11 07:00:00", 
"2007-11-04 06:00:00", "2008-03-09 07:00:00", "2008-11-02 06:00:00", 
"2009-03-08 07:00:00", "2009-11-01 06:00:00", "2010-03-14 07:00:00", 
"2010-11-07 06:00:00", "2011-03-13 07:00:00", "2011-11-06 06:00:00", 
"2012-03-11 07:00:00", "2012-11-04 06:00:00", "2013-03-10 07:00:00", 
"2013-11-03 06:00:00", "2014-03-09 07:00:00", "2014-11-02 06:00:00", 
"2015-03-08 07:00:00", "2015-11-01 06:00:00", "2016-03-13 07:00:00", 
"2016-11-06 06:00:00", "2017-03-12 07:00:00", "2017-11-05 06:00:00", 
"2018-03-11 07:00:00", "2018-11-04 06:00:00", "2019-03-10 07:00:00", 
"2019-11-03 06:00:00", "2020-03-08 07:00:00", "2020-11-01 06:00:00", 
"2021-03-14 07:00:00", "2021-11-07 06:00:00", "2022-03-13 07:00:00", 
"2022-11-06 06:00:00", "2023-03-12 07:00:00", "2023-11-05 06:00:00", 
"2024-03-10 07:00:00", "2024-11-03 06:00:00", "2025-03-09 07:00:00", 
"2025-11-02 06:00:00", "2026-03-08 07:00:00", "2026-11-01 06:00:00", 
"2027-03-14 07:00:00", "2027-11-07 06:00:00", "2028-03-12 07:00:00", 
"2028-11-05 06:00:00", "2029-03-11 07:00:00", "2029-11-04 06:00:00", 
"2030-03-10 07:00:00", "2030-11-03 06:00:00", "2031-03-09 07:00:00", 
"2031-11-02 06:00:00", "2032-03-14 07:00:00", "2032-11-07 06:00:00", 
"2033-03-13 07:00:00", "2033-11-06 06:00:00", "2034-03-12 07:00:00", 
"2034-11-05 06:00:00", "2035-03-11 07:00:00", "2035-11-04 06:00:00", 
"2036-03-09 07:00:00", "2036-11-02 06:00:00", "2037-03-08 07:00:00", 
"2037-11-01 06:00:00"), offSet = c(0L, -14400L, -18000L, -10800L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -21600L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L), isdst = c(0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L), TimeZone = c("zzz", "EPT", "EST", "EDDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "CST", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST"), numeric = c(-2147397248, 
-769395600, -765396000, -147898800, -131569200, 325666800, 341388000, 
357116400, 372837600, 388566000, 404892000, 420015600, 436341600, 
452070000, 467791200, 483519600, 499240800, 514969200, 530690400, 
544604400, 562140000, 576054000, 594194400, 607503600, 625644000, 
638953200, 657093600, 671007600, 688543200, 702457200, 719992800, 
733906800, 752047200, 765356400, 783496800, 796806000, 814946400, 
828860400, 846396000, 860310000, 877845600, 891759600, 909295200, 
923209200, 941349600, 972802800, 986108400, 1004248800, 1018162800, 
1035698400, 1049612400, 1067148000, 1081062000, 1099202400, 1112511600, 
1130652000, 1143961200, 1162101600, 1173596400, 1194156000, 1205046000, 
1225605600, 1236495600, 1257055200, 1268550000, 1289109600, 1299999600, 
1320559200, 1331449200, 1352008800, 1362898800, 1383458400, 1394348400, 
1414908000, 1425798000, 1446357600, 1457852400, 1478412000, 1489302000, 
1509861600, 1520751600, 1541311200, 1552201200, 1572760800, 1583650800, 
1604210400, 1615705200, 1636264800, 1647154800, 1667714400, 1678604400, 
1699164000, 1710054000, 1730613600, 1741503600, 1762063200, 1772953200, 
1793512800, 1805007600, 1825567200, 1836457200, 1857016800, 1867906800, 
1888466400, 1899356400, 1919916000, 1930806000, 1951365600, 1962860400, 
1983420000, 1994310000, 2014869600, 2025759600, 2046319200, 2057209200, 
2077768800, 2088658800, 2109218400, 2120108400, 2140668000)), .Names = c("Iqaluit", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-120L), class = "data.frame")
}

"Jamaica" <- function () {
structure(list(Jamaica = c("1901-12-14 20:45:52", "1912-02-01 05:07:12", 
"1974-04-28 07:00:00", "1974-10-27 06:00:00", "1975-02-23 07:00:00", 
"1975-10-26 06:00:00", "1976-04-25 07:00:00", "1976-10-31 06:00:00", 
"1977-04-24 07:00:00", "1977-10-30 06:00:00", "1978-04-30 07:00:00", 
"1978-10-29 06:00:00", "1979-04-29 07:00:00", "1979-10-28 06:00:00", 
"1980-04-27 07:00:00", "1980-10-26 06:00:00", "1981-04-26 07:00:00", 
"1981-10-25 06:00:00", "1982-04-25 07:00:00", "1982-10-31 06:00:00", 
"1983-04-24 07:00:00", "1983-10-30 06:00:00"), offSet = c(-18432L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L
), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("KMT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST"), numeric = c(-2147397248, -1827687168, 136364400, 
152085600, 162370800, 183535200, 199263600, 215589600, 230713200, 
247039200, 262767600, 278488800, 294217200, 309938400, 325666800, 
341388000, 357116400, 372837600, 388566000, 404892000, 420015600, 
436341600)), .Names = c("Jamaica", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -22L), class = "data.frame")
}

"Juneau" <- function () {
structure(list(Juneau = c("1901-12-14 20:45:52", "1945-08-14 23:00:00", 
"1945-09-30 09:00:00", "1969-04-27 10:00:00", "1969-10-26 09:00:00", 
"1970-04-26 10:00:00", "1970-10-25 09:00:00", "1971-04-25 10:00:00", 
"1971-10-31 09:00:00", "1972-04-30 10:00:00", "1972-10-29 09:00:00", 
"1973-04-29 10:00:00", "1973-10-28 09:00:00", "1974-01-06 10:00:00", 
"1974-10-27 09:00:00", "1975-02-23 10:00:00", "1975-10-26 09:00:00", 
"1976-04-25 10:00:00", "1976-10-31 09:00:00", "1977-04-24 10:00:00", 
"1977-10-30 09:00:00", "1978-04-30 10:00:00", "1978-10-29 09:00:00", 
"1979-04-29 10:00:00", "1979-10-28 09:00:00", "1980-04-27 10:00:00", 
"1980-10-26 09:00:00", "1981-04-26 10:00:00", "1981-10-25 09:00:00", 
"1982-04-25 10:00:00", "1982-10-31 09:00:00", "1983-04-24 10:00:00", 
"1983-11-30 09:00:00", "1984-04-29 11:00:00", "1984-10-28 10:00:00", 
"1985-04-28 11:00:00", "1985-10-27 10:00:00", "1986-04-27 11:00:00", 
"1986-10-26 10:00:00", "1987-04-05 11:00:00", "1987-10-25 10:00:00", 
"1988-04-03 11:00:00", "1988-10-30 10:00:00", "1989-04-02 11:00:00", 
"1989-10-29 10:00:00", "1990-04-01 11:00:00", "1990-10-28 10:00:00", 
"1991-04-07 11:00:00", "1991-10-27 10:00:00", "1992-04-05 11:00:00", 
"1992-10-25 10:00:00", "1993-04-04 11:00:00", "1993-10-31 10:00:00", 
"1994-04-03 11:00:00", "1994-10-30 10:00:00", "1995-04-02 11:00:00", 
"1995-10-29 10:00:00", "1996-04-07 11:00:00", "1996-10-27 10:00:00", 
"1997-04-06 11:00:00", "1997-10-26 10:00:00", "1998-04-05 11:00:00", 
"1998-10-25 10:00:00", "1999-04-04 11:00:00", "1999-10-31 10:00:00", 
"2000-04-02 11:00:00", "2000-10-29 10:00:00", "2001-04-01 11:00:00", 
"2001-10-28 10:00:00", "2002-04-07 11:00:00", "2002-10-27 10:00:00", 
"2003-04-06 11:00:00", "2003-10-26 10:00:00", "2004-04-04 11:00:00", 
"2004-10-31 10:00:00", "2005-04-03 11:00:00", "2005-10-30 10:00:00", 
"2006-04-02 11:00:00", "2006-10-29 10:00:00", "2007-03-11 11:00:00", 
"2007-11-04 10:00:00", "2008-03-09 11:00:00", "2008-11-02 10:00:00", 
"2009-03-08 11:00:00", "2009-11-01 10:00:00", "2010-03-14 11:00:00", 
"2010-11-07 10:00:00", "2011-03-13 11:00:00", "2011-11-06 10:00:00", 
"2012-03-11 11:00:00", "2012-11-04 10:00:00", "2013-03-10 11:00:00", 
"2013-11-03 10:00:00", "2014-03-09 11:00:00", "2014-11-02 10:00:00", 
"2015-03-08 11:00:00", "2015-11-01 10:00:00", "2016-03-13 11:00:00", 
"2016-11-06 10:00:00", "2017-03-12 11:00:00", "2017-11-05 10:00:00", 
"2018-03-11 11:00:00", "2018-11-04 10:00:00", "2019-03-10 11:00:00", 
"2019-11-03 10:00:00", "2020-03-08 11:00:00", "2020-11-01 10:00:00", 
"2021-03-14 11:00:00", "2021-11-07 10:00:00", "2022-03-13 11:00:00", 
"2022-11-06 10:00:00", "2023-03-12 11:00:00", "2023-11-05 10:00:00", 
"2024-03-10 11:00:00", "2024-11-03 10:00:00", "2025-03-09 11:00:00", 
"2025-11-02 10:00:00", "2026-03-08 11:00:00", "2026-11-01 10:00:00", 
"2027-03-14 11:00:00", "2027-11-07 10:00:00", "2028-03-12 11:00:00", 
"2028-11-05 10:00:00", "2029-03-11 11:00:00", "2029-11-04 10:00:00", 
"2030-03-10 11:00:00", "2030-11-03 10:00:00", "2031-03-09 11:00:00", 
"2031-11-02 10:00:00", "2032-03-14 11:00:00", "2032-11-07 10:00:00", 
"2033-03-13 11:00:00", "2033-11-06 10:00:00", "2034-03-12 11:00:00", 
"2034-11-05 10:00:00", "2035-03-11 11:00:00", "2035-11-04 10:00:00", 
"2036-03-09 11:00:00", "2036-11-02 10:00:00", "2037-03-08 11:00:00", 
"2037-11-01 10:00:00"), offSet = c(-28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L), isdst = c(0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("PST", 
"PPT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST"
), numeric = c(-2147397248, -769395600, -765385200, -21477600, 
-5756400, 9972000, 25693200, 41421600, 57747600, 73476000, 89197200, 
104925600, 120646800, 126698400, 152096400, 162381600, 183546000, 
199274400, 215600400, 230724000, 247050000, 262778400, 278499600, 
294228000, 309949200, 325677600, 341398800, 357127200, 372848400, 
388576800, 404902800, 420026400, 439030800, 452084400, 467805600, 
483534000, 499255200, 514983600, 530704800, 544618800, 562154400, 
576068400, 594208800, 607518000, 625658400, 638967600, 657108000, 
671022000, 688557600, 702471600, 720007200, 733921200, 752061600, 
765370800, 783511200, 796820400, 814960800, 828874800, 846410400, 
860324400, 877860000, 891774000, 909309600, 923223600, 941364000, 
954673200, 972813600, 986122800, 1004263200, 1018177200, 1035712800, 
1049626800, 1067162400, 1081076400, 1099216800, 1112526000, 1130666400, 
1143975600, 1162116000, 1173610800, 1194170400, 1205060400, 1225620000, 
1236510000, 1257069600, 1268564400, 1289124000, 1300014000, 1320573600, 
1331463600, 1352023200, 1362913200, 1383472800, 1394362800, 1414922400, 
1425812400, 1446372000, 1457866800, 1478426400, 1489316400, 1509876000, 
1520766000, 1541325600, 1552215600, 1572775200, 1583665200, 1604224800, 
1615719600, 1636279200, 1647169200, 1667728800, 1678618800, 1699178400, 
1710068400, 1730628000, 1741518000, 1762077600, 1772967600, 1793527200, 
1805022000, 1825581600, 1836471600, 1857031200, 1867921200, 1888480800, 
1899370800, 1919930400, 1930820400, 1951380000, 1962874800, 1983434400, 
1994324400, 2014884000, 2025774000, 2046333600, 2057223600, 2077783200, 
2088673200, 2109232800, 2120122800, 2140682400)), .Names = c("Juneau", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-141L), class = "data.frame")
}

"Louisville" <- function () {
structure(list(Louisville = c("1901-12-14 20:45:52", "1918-03-31 08:00:00", 
"1918-10-27 07:00:00", "1919-03-30 08:00:00", "1919-10-26 07:00:00", 
"1921-05-01 08:00:00", "1921-09-01 07:00:00", "1941-04-27 08:00:00", 
"1941-09-28 07:00:00", "1945-08-14 23:00:00", "1945-09-30 07:00:00", 
"1946-01-01 06:00:00", "1946-06-02 07:00:00", "1947-04-27 08:00:00", 
"1950-09-24 07:00:00", "1951-04-29 08:00:00", "1951-09-30 07:00:00", 
"1952-04-27 08:00:00", "1952-09-28 07:00:00", "1953-04-26 08:00:00", 
"1953-09-27 07:00:00", "1954-04-25 08:00:00", "1954-09-26 07:00:00", 
"1955-04-24 08:00:00", "1955-09-25 07:00:00", "1956-04-29 08:00:00", 
"1956-10-28 07:00:00", "1957-04-28 08:00:00", "1957-10-27 07:00:00", 
"1958-04-27 08:00:00", "1958-10-26 07:00:00", "1959-04-26 08:00:00", 
"1959-10-25 07:00:00", "1960-04-24 08:00:00", "1960-10-30 07:00:00", 
"1961-07-23 07:00:00", "1968-04-28 07:00:00", "1968-10-27 06:00:00", 
"1969-04-27 07:00:00", "1969-10-26 06:00:00", "1970-04-26 07:00:00", 
"1970-10-25 06:00:00", "1971-04-25 07:00:00", "1971-10-31 06:00:00", 
"1972-04-30 07:00:00", "1972-10-29 06:00:00", "1973-04-29 07:00:00", 
"1974-10-27 07:00:00", "1975-02-23 07:00:00", "1975-10-26 06:00:00", 
"1976-04-25 07:00:00", "1976-10-31 06:00:00", "1977-04-24 07:00:00", 
"1977-10-30 06:00:00", "1978-04-30 07:00:00", "1978-10-29 06:00:00", 
"1979-04-29 07:00:00", "1979-10-28 06:00:00", "1980-04-27 07:00:00", 
"1980-10-26 06:00:00", "1981-04-26 07:00:00", "1981-10-25 06:00:00", 
"1982-04-25 07:00:00", "1982-10-31 06:00:00", "1983-04-24 07:00:00", 
"1983-10-30 06:00:00", "1984-04-29 07:00:00", "1984-10-28 06:00:00", 
"1985-04-28 07:00:00", "1985-10-27 06:00:00", "1986-04-27 07:00:00", 
"1986-10-26 06:00:00", "1987-04-05 07:00:00", "1987-10-25 06:00:00", 
"1988-04-03 07:00:00", "1988-10-30 06:00:00", "1989-04-02 07:00:00", 
"1989-10-29 06:00:00", "1990-04-01 07:00:00", "1990-10-28 06:00:00", 
"1991-04-07 07:00:00", "1991-10-27 06:00:00", "1992-04-05 07:00:00", 
"1992-10-25 06:00:00", "1993-04-04 07:00:00", "1993-10-31 06:00:00", 
"1994-04-03 07:00:00", "1994-10-30 06:00:00", "1995-04-02 07:00:00", 
"1995-10-29 06:00:00", "1996-04-07 07:00:00", "1996-10-27 06:00:00", 
"1997-04-06 07:00:00", "1997-10-26 06:00:00", "1998-04-05 07:00:00", 
"1998-10-25 06:00:00", "1999-04-04 07:00:00", "1999-10-31 06:00:00", 
"2000-04-02 07:00:00", "2000-10-29 06:00:00", "2001-04-01 07:00:00", 
"2001-10-28 06:00:00", "2002-04-07 07:00:00", "2002-10-27 06:00:00", 
"2003-04-06 07:00:00", "2003-10-26 06:00:00", "2004-04-04 07:00:00", 
"2004-10-31 06:00:00", "2005-04-03 07:00:00", "2005-10-30 06:00:00", 
"2006-04-02 07:00:00", "2006-10-29 06:00:00", "2007-03-11 07:00:00", 
"2007-11-04 06:00:00", "2008-03-09 07:00:00", "2008-11-02 06:00:00", 
"2009-03-08 07:00:00", "2009-11-01 06:00:00", "2010-03-14 07:00:00", 
"2010-11-07 06:00:00", "2011-03-13 07:00:00", "2011-11-06 06:00:00", 
"2012-03-11 07:00:00", "2012-11-04 06:00:00", "2013-03-10 07:00:00", 
"2013-11-03 06:00:00", "2014-03-09 07:00:00", "2014-11-02 06:00:00", 
"2015-03-08 07:00:00", "2015-11-01 06:00:00", "2016-03-13 07:00:00", 
"2016-11-06 06:00:00", "2017-03-12 07:00:00", "2017-11-05 06:00:00", 
"2018-03-11 07:00:00", "2018-11-04 06:00:00", "2019-03-10 07:00:00", 
"2019-11-03 06:00:00", "2020-03-08 07:00:00", "2020-11-01 06:00:00", 
"2021-03-14 07:00:00", "2021-11-07 06:00:00", "2022-03-13 07:00:00", 
"2022-11-06 06:00:00", "2023-03-12 07:00:00", "2023-11-05 06:00:00", 
"2024-03-10 07:00:00", "2024-11-03 06:00:00", "2025-03-09 07:00:00", 
"2025-11-02 06:00:00", "2026-03-08 07:00:00", "2026-11-01 06:00:00", 
"2027-03-14 07:00:00", "2027-11-07 06:00:00", "2028-03-12 07:00:00", 
"2028-11-05 06:00:00", "2029-03-11 07:00:00", "2029-11-04 06:00:00", 
"2030-03-10 07:00:00", "2030-11-03 06:00:00", "2031-03-09 07:00:00", 
"2031-11-02 06:00:00", "2032-03-14 07:00:00", "2032-11-07 06:00:00", 
"2033-03-13 07:00:00", "2033-11-06 06:00:00", "2034-03-12 07:00:00", 
"2034-11-05 06:00:00", "2035-03-11 07:00:00", "2035-11-04 06:00:00", 
"2036-03-09 07:00:00", "2036-11-02 06:00:00", "2037-03-08 07:00:00", 
"2037-11-01 06:00:00"), offSet = c(-21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CPT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST"
), numeric = c(-2147397248, -1633276800, -1615136400, -1601827200, 
-1583686800, -1535904000, -1525280400, -905097600, -891795600, 
-769395600, -765392400, -757360800, -744224400, -715795200, -608144400, 
-589392000, -576090000, -557942400, -544640400, -526492800, -513190800, 
-495043200, -481741200, -463593600, -450291600, -431539200, -415818000, 
-400089600, -384368400, -368640000, -352918800, -337190400, -321469200, 
-305740800, -289414800, -266432400, -52938000, -37216800, -21488400, 
-5767200, 9961200, 25682400, 41410800, 57736800, 73465200, 89186400, 
104914800, 152089200, 162370800, 183535200, 199263600, 215589600, 
230713200, 247039200, 262767600, 278488800, 294217200, 309938400, 
325666800, 341388000, 357116400, 372837600, 388566000, 404892000, 
420015600, 436341600, 452070000, 467791200, 483519600, 499240800, 
514969200, 530690400, 544604400, 562140000, 576054000, 594194400, 
607503600, 625644000, 638953200, 657093600, 671007600, 688543200, 
702457200, 719992800, 733906800, 752047200, 765356400, 783496800, 
796806000, 814946400, 828860400, 846396000, 860310000, 877845600, 
891759600, 909295200, 923209200, 941349600, 954658800, 972799200, 
986108400, 1004248800, 1018162800, 1035698400, 1049612400, 1067148000, 
1081062000, 1099202400, 1112511600, 1130652000, 1143961200, 1162101600, 
1173596400, 1194156000, 1205046000, 1225605600, 1236495600, 1257055200, 
1268550000, 1289109600, 1299999600, 1320559200, 1331449200, 1352008800, 
1362898800, 1383458400, 1394348400, 1414908000, 1425798000, 1446357600, 
1457852400, 1478412000, 1489302000, 1509861600, 1520751600, 1541311200, 
1552201200, 1572760800, 1583650800, 1604210400, 1615705200, 1636264800, 
1647154800, 1667714400, 1678604400, 1699164000, 1710054000, 1730613600, 
1741503600, 1762063200, 1772953200, 1793512800, 1805007600, 1825567200, 
1836457200, 1857016800, 1867906800, 1888466400, 1899356400, 1919916000, 
1930806000, 1951365600, 1962860400, 1983420000, 1994310000, 2014869600, 
2025759600, 2046319200, 2057209200, 2077768800, 2088658800, 2109218400, 
2120108400, 2140668000)), .Names = c("Louisville", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -174L), class = "data.frame")
}

"Monticello" <- function () {
structure(list(Monticello = c("1901-12-14 20:45:52", "1918-03-31 08:00:00", 
"1918-10-27 07:00:00", "1919-03-30 08:00:00", "1919-10-26 07:00:00", 
"1945-08-14 23:00:00", "1945-09-30 07:00:00", "1968-04-28 08:00:00", 
"1968-10-27 07:00:00", "1969-04-27 08:00:00", "1969-10-26 07:00:00", 
"1970-04-26 08:00:00", "1970-10-25 07:00:00", "1971-04-25 08:00:00", 
"1971-10-31 07:00:00", "1972-04-30 08:00:00", "1972-10-29 07:00:00", 
"1973-04-29 08:00:00", "1973-10-28 07:00:00", "1974-01-06 08:00:00", 
"1974-10-27 07:00:00", "1975-02-23 08:00:00", "1975-10-26 07:00:00", 
"1976-04-25 08:00:00", "1976-10-31 07:00:00", "1977-04-24 08:00:00", 
"1977-10-30 07:00:00", "1978-04-30 08:00:00", "1978-10-29 07:00:00", 
"1979-04-29 08:00:00", "1979-10-28 07:00:00", "1980-04-27 08:00:00", 
"1980-10-26 07:00:00", "1981-04-26 08:00:00", "1981-10-25 07:00:00", 
"1982-04-25 08:00:00", "1982-10-31 07:00:00", "1983-04-24 08:00:00", 
"1983-10-30 07:00:00", "1984-04-29 08:00:00", "1984-10-28 07:00:00", 
"1985-04-28 08:00:00", "1985-10-27 07:00:00", "1986-04-27 08:00:00", 
"1986-10-26 07:00:00", "1987-04-05 08:00:00", "1987-10-25 07:00:00", 
"1988-04-03 08:00:00", "1988-10-30 07:00:00", "1989-04-02 08:00:00", 
"1989-10-29 07:00:00", "1990-04-01 08:00:00", "1990-10-28 07:00:00", 
"1991-04-07 08:00:00", "1991-10-27 07:00:00", "1992-04-05 08:00:00", 
"1992-10-25 07:00:00", "1993-04-04 08:00:00", "1993-10-31 07:00:00", 
"1994-04-03 08:00:00", "1994-10-30 07:00:00", "1995-04-02 08:00:00", 
"1995-10-29 07:00:00", "1996-04-07 08:00:00", "1996-10-27 07:00:00", 
"1997-04-06 08:00:00", "1997-10-26 07:00:00", "1998-04-05 08:00:00", 
"1998-10-25 07:00:00", "1999-04-04 08:00:00", "1999-10-31 07:00:00", 
"2000-10-29 07:00:00", "2001-04-01 07:00:00", "2001-10-28 06:00:00", 
"2002-04-07 07:00:00", "2002-10-27 06:00:00", "2003-04-06 07:00:00", 
"2003-10-26 06:00:00", "2004-04-04 07:00:00", "2004-10-31 06:00:00", 
"2005-04-03 07:00:00", "2005-10-30 06:00:00", "2006-04-02 07:00:00", 
"2006-10-29 06:00:00", "2007-03-11 07:00:00", "2007-11-04 06:00:00", 
"2008-03-09 07:00:00", "2008-11-02 06:00:00", "2009-03-08 07:00:00", 
"2009-11-01 06:00:00", "2010-03-14 07:00:00", "2010-11-07 06:00:00", 
"2011-03-13 07:00:00", "2011-11-06 06:00:00", "2012-03-11 07:00:00", 
"2012-11-04 06:00:00", "2013-03-10 07:00:00", "2013-11-03 06:00:00", 
"2014-03-09 07:00:00", "2014-11-02 06:00:00", "2015-03-08 07:00:00", 
"2015-11-01 06:00:00", "2016-03-13 07:00:00", "2016-11-06 06:00:00", 
"2017-03-12 07:00:00", "2017-11-05 06:00:00", "2018-03-11 07:00:00", 
"2018-11-04 06:00:00", "2019-03-10 07:00:00", "2019-11-03 06:00:00", 
"2020-03-08 07:00:00", "2020-11-01 06:00:00", "2021-03-14 07:00:00", 
"2021-11-07 06:00:00", "2022-03-13 07:00:00", "2022-11-06 06:00:00", 
"2023-03-12 07:00:00", "2023-11-05 06:00:00", "2024-03-10 07:00:00", 
"2024-11-03 06:00:00", "2025-03-09 07:00:00", "2025-11-02 06:00:00", 
"2026-03-08 07:00:00", "2026-11-01 06:00:00", "2027-03-14 07:00:00", 
"2027-11-07 06:00:00", "2028-03-12 07:00:00", "2028-11-05 06:00:00", 
"2029-03-11 07:00:00", "2029-11-04 06:00:00", "2030-03-10 07:00:00", 
"2030-11-03 06:00:00", "2031-03-09 07:00:00", "2031-11-02 06:00:00", 
"2032-03-14 07:00:00", "2032-11-07 06:00:00", "2033-03-13 07:00:00", 
"2033-11-06 06:00:00", "2034-03-12 07:00:00", "2034-11-05 06:00:00", 
"2035-03-11 07:00:00", "2035-11-04 06:00:00", "2036-03-09 07:00:00", 
"2036-11-02 06:00:00", "2037-03-08 07:00:00", "2037-11-01 06:00:00"
), offSet = c(-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L
), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("CST", "CDT", "CST", "CDT", 
"CST", "CPT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST"), numeric = c(-2147397248, 
-1633276800, -1615136400, -1601827200, -1583686800, -769395600, 
-765392400, -52934400, -37213200, -21484800, -5763600, 9964800, 
25686000, 41414400, 57740400, 73468800, 89190000, 104918400, 
120639600, 126691200, 152089200, 162374400, 183538800, 199267200, 
215593200, 230716800, 247042800, 262771200, 278492400, 294220800, 
309942000, 325670400, 341391600, 357120000, 372841200, 388569600, 
404895600, 420019200, 436345200, 452073600, 467794800, 483523200, 
499244400, 514972800, 530694000, 544608000, 562143600, 576057600, 
594198000, 607507200, 625647600, 638956800, 657097200, 671011200, 
688546800, 702460800, 719996400, 733910400, 752050800, 765360000, 
783500400, 796809600, 814950000, 828864000, 846399600, 860313600, 
877849200, 891763200, 909298800, 923212800, 941353200, 972802800, 
986108400, 1004248800, 1018162800, 1035698400, 1049612400, 1067148000, 
1081062000, 1099202400, 1112511600, 1130652000, 1143961200, 1162101600, 
1173596400, 1194156000, 1205046000, 1225605600, 1236495600, 1257055200, 
1268550000, 1289109600, 1299999600, 1320559200, 1331449200, 1352008800, 
1362898800, 1383458400, 1394348400, 1414908000, 1425798000, 1446357600, 
1457852400, 1478412000, 1489302000, 1509861600, 1520751600, 1541311200, 
1552201200, 1572760800, 1583650800, 1604210400, 1615705200, 1636264800, 
1647154800, 1667714400, 1678604400, 1699164000, 1710054000, 1730613600, 
1741503600, 1762063200, 1772953200, 1793512800, 1805007600, 1825567200, 
1836457200, 1857016800, 1867906800, 1888466400, 1899356400, 1919916000, 
1930806000, 1951365600, 1962860400, 1983420000, 1994310000, 2014869600, 
2025759600, 2046319200, 2057209200, 2077768800, 2088658800, 2109218400, 
2120108400, 2140668000)), .Names = c("Monticello", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -146L), class = "data.frame")
}

"La_Paz" <- function () {
structure(list(La_Paz = c("1901-12-14 20:45:52", "1931-10-15 04:32:36", 
"1932-03-21 03:32:36"), offSet = c(-16356L, -12756L, -14400L), 
    isdst = c(0L, 1L, 0L), TimeZone = c("CMT", "BOST", "BOT"), 
    numeric = c(-2147397248, -1205954844, -1192307244)), .Names = c("La_Paz", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-3L), class = "data.frame")
}

"Lima" <- function () {
structure(list(Lima = c("1901-12-14 20:45:52", "1908-07-28 05:08:36", 
"1938-01-01 05:00:00", "1938-04-01 04:00:00", "1938-09-25 05:00:00", 
"1939-03-26 04:00:00", "1939-09-24 05:00:00", "1940-03-24 04:00:00", 
"1986-01-01 05:00:00", "1986-04-01 04:00:00", "1987-01-01 05:00:00", 
"1987-04-01 04:00:00", "1990-01-01 05:00:00", "1990-04-01 04:00:00", 
"1994-01-01 05:00:00", "1994-04-01 04:00:00"), offSet = c(-18516L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "PET", "PEST", "PET", 
"PEST", "PET", "PEST", "PET", "PEST", "PET", "PEST", "PET", "PEST", 
"PET", "PEST", "PET"), numeric = c(-2147397248, -1938538284, 
-1009825200, -1002052800, -986756400, -971035200, -955306800, 
-939585600, 504939600, 512712000, 536475600, 544248000, 631170000, 
638942400, 757400400, 765172800)), .Names = c("Lima", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -16L), class = "data.frame")
}

"Los_Angeles" <- function () {
structure(list(Los_Angeles = c("1901-12-14 20:45:52", "1918-03-31 10:00:00", 
"1918-10-27 09:00:00", "1919-03-30 10:00:00", "1919-10-26 09:00:00", 
"1945-08-14 23:00:00", "1945-09-30 09:00:00", "1948-03-14 10:00:00", 
"1949-01-01 09:00:00", "1950-04-30 10:00:00", "1950-09-24 09:00:00", 
"1951-04-29 10:00:00", "1951-09-30 09:00:00", "1952-04-27 10:00:00", 
"1952-09-28 09:00:00", "1953-04-26 10:00:00", "1953-09-27 09:00:00", 
"1954-04-25 10:00:00", "1954-09-26 09:00:00", "1955-04-24 10:00:00", 
"1955-09-25 09:00:00", "1956-04-29 10:00:00", "1956-09-30 09:00:00", 
"1957-04-28 10:00:00", "1957-09-29 09:00:00", "1958-04-27 10:00:00", 
"1958-09-28 09:00:00", "1959-04-26 10:00:00", "1959-09-27 09:00:00", 
"1960-04-24 10:00:00", "1960-09-25 09:00:00", "1961-04-30 10:00:00", 
"1961-09-24 09:00:00", "1962-04-29 10:00:00", "1962-10-28 09:00:00", 
"1963-04-28 10:00:00", "1963-10-27 09:00:00", "1964-04-26 10:00:00", 
"1964-10-25 09:00:00", "1965-04-25 10:00:00", "1965-10-31 09:00:00", 
"1966-04-24 10:00:00", "1966-10-30 09:00:00", "1967-04-30 10:00:00", 
"1967-10-29 09:00:00", "1968-04-28 10:00:00", "1968-10-27 09:00:00", 
"1969-04-27 10:00:00", "1969-10-26 09:00:00", "1970-04-26 10:00:00", 
"1970-10-25 09:00:00", "1971-04-25 10:00:00", "1971-10-31 09:00:00", 
"1972-04-30 10:00:00", "1972-10-29 09:00:00", "1973-04-29 10:00:00", 
"1973-10-28 09:00:00", "1974-01-06 10:00:00", "1974-10-27 09:00:00", 
"1975-02-23 10:00:00", "1975-10-26 09:00:00", "1976-04-25 10:00:00", 
"1976-10-31 09:00:00", "1977-04-24 10:00:00", "1977-10-30 09:00:00", 
"1978-04-30 10:00:00", "1978-10-29 09:00:00", "1979-04-29 10:00:00", 
"1979-10-28 09:00:00", "1980-04-27 10:00:00", "1980-10-26 09:00:00", 
"1981-04-26 10:00:00", "1981-10-25 09:00:00", "1982-04-25 10:00:00", 
"1982-10-31 09:00:00", "1983-04-24 10:00:00", "1983-10-30 09:00:00", 
"1984-04-29 10:00:00", "1984-10-28 09:00:00", "1985-04-28 10:00:00", 
"1985-10-27 09:00:00", "1986-04-27 10:00:00", "1986-10-26 09:00:00", 
"1987-04-05 10:00:00", "1987-10-25 09:00:00", "1988-04-03 10:00:00", 
"1988-10-30 09:00:00", "1989-04-02 10:00:00", "1989-10-29 09:00:00", 
"1990-04-01 10:00:00", "1990-10-28 09:00:00", "1991-04-07 10:00:00", 
"1991-10-27 09:00:00", "1992-04-05 10:00:00", "1992-10-25 09:00:00", 
"1993-04-04 10:00:00", "1993-10-31 09:00:00", "1994-04-03 10:00:00", 
"1994-10-30 09:00:00", "1995-04-02 10:00:00", "1995-10-29 09:00:00", 
"1996-04-07 10:00:00", "1996-10-27 09:00:00", "1997-04-06 10:00:00", 
"1997-10-26 09:00:00", "1998-04-05 10:00:00", "1998-10-25 09:00:00", 
"1999-04-04 10:00:00", "1999-10-31 09:00:00", "2000-04-02 10:00:00", 
"2000-10-29 09:00:00", "2001-04-01 10:00:00", "2001-10-28 09:00:00", 
"2002-04-07 10:00:00", "2002-10-27 09:00:00", "2003-04-06 10:00:00", 
"2003-10-26 09:00:00", "2004-04-04 10:00:00", "2004-10-31 09:00:00", 
"2005-04-03 10:00:00", "2005-10-30 09:00:00", "2006-04-02 10:00:00", 
"2006-10-29 09:00:00", "2007-03-11 10:00:00", "2007-11-04 09:00:00", 
"2008-03-09 10:00:00", "2008-11-02 09:00:00", "2009-03-08 10:00:00", 
"2009-11-01 09:00:00", "2010-03-14 10:00:00", "2010-11-07 09:00:00", 
"2011-03-13 10:00:00", "2011-11-06 09:00:00", "2012-03-11 10:00:00", 
"2012-11-04 09:00:00", "2013-03-10 10:00:00", "2013-11-03 09:00:00", 
"2014-03-09 10:00:00", "2014-11-02 09:00:00", "2015-03-08 10:00:00", 
"2015-11-01 09:00:00", "2016-03-13 10:00:00", "2016-11-06 09:00:00", 
"2017-03-12 10:00:00", "2017-11-05 09:00:00", "2018-03-11 10:00:00", 
"2018-11-04 09:00:00", "2019-03-10 10:00:00", "2019-11-03 09:00:00", 
"2020-03-08 10:00:00", "2020-11-01 09:00:00", "2021-03-14 10:00:00", 
"2021-11-07 09:00:00", "2022-03-13 10:00:00", "2022-11-06 09:00:00", 
"2023-03-12 10:00:00", "2023-11-05 09:00:00", "2024-03-10 10:00:00", 
"2024-11-03 09:00:00", "2025-03-09 10:00:00", "2025-11-02 09:00:00", 
"2026-03-08 10:00:00", "2026-11-01 09:00:00", "2027-03-14 10:00:00", 
"2027-11-07 09:00:00", "2028-03-12 10:00:00", "2028-11-05 09:00:00", 
"2029-03-11 10:00:00", "2029-11-04 09:00:00", "2030-03-10 10:00:00", 
"2030-11-03 09:00:00", "2031-03-09 10:00:00", "2031-11-02 09:00:00", 
"2032-03-14 10:00:00", "2032-11-07 09:00:00", "2033-03-13 10:00:00", 
"2033-11-06 09:00:00", "2034-03-12 10:00:00", "2034-11-05 09:00:00", 
"2035-03-11 10:00:00", "2035-11-04 09:00:00", "2036-03-09 10:00:00", 
"2036-11-02 09:00:00", "2037-03-08 10:00:00", "2037-11-01 09:00:00"
), offSet = c(-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L), isdst = c(0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L), TimeZone = c("PST", "PDT", "PST", "PDT", 
"PST", "PPT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST"), numeric = c(-2147397248, -1633269600, -1615129200, -1601820000, 
-1583679600, -769395600, -765385200, -687967200, -662655600, 
-620834400, -608137200, -589384800, -576082800, -557935200, -544633200, 
-526485600, -513183600, -495036000, -481734000, -463586400, -450284400, 
-431532000, -418230000, -400082400, -386780400, -368632800, -355330800, 
-337183200, -323881200, -305733600, -292431600, -273679200, -260982000, 
-242229600, -226508400, -210780000, -195058800, -179330400, -163609200, 
-147880800, -131554800, -116431200, -100105200, -84376800, -68655600, 
-52927200, -37206000, -21477600, -5756400, 9972000, 25693200, 
41421600, 57747600, 73476000, 89197200, 104925600, 120646800, 
126698400, 152096400, 162381600, 183546000, 199274400, 215600400, 
230724000, 247050000, 262778400, 278499600, 294228000, 309949200, 
325677600, 341398800, 357127200, 372848400, 388576800, 404902800, 
420026400, 436352400, 452080800, 467802000, 483530400, 499251600, 
514980000, 530701200, 544615200, 562150800, 576064800, 594205200, 
607514400, 625654800, 638964000, 657104400, 671018400, 688554000, 
702468000, 720003600, 733917600, 752058000, 765367200, 783507600, 
796816800, 814957200, 828871200, 846406800, 860320800, 877856400, 
891770400, 909306000, 923220000, 941360400, 954669600, 972810000, 
986119200, 1004259600, 1018173600, 1035709200, 1049623200, 1067158800, 
1081072800, 1099213200, 1112522400, 1130662800, 1143972000, 1162112400, 
1173607200, 1194166800, 1205056800, 1225616400, 1236506400, 1257066000, 
1268560800, 1289120400, 1300010400, 1320570000, 1331460000, 1352019600, 
1362909600, 1383469200, 1394359200, 1414918800, 1425808800, 1446368400, 
1457863200, 1478422800, 1489312800, 1509872400, 1520762400, 1541322000, 
1552212000, 1572771600, 1583661600, 1604221200, 1615716000, 1636275600, 
1647165600, 1667725200, 1678615200, 1699174800, 1710064800, 1730624400, 
1741514400, 1762074000, 1772964000, 1793523600, 1805018400, 1825578000, 
1836468000, 1857027600, 1867917600, 1888477200, 1899367200, 1919926800, 
1930816800, 1951376400, 1962871200, 1983430800, 1994320800, 2014880400, 
2025770400, 2046330000, 2057220000, 2077779600, 2088669600, 2109229200, 
2120119200, 2140678800)), .Names = c("Los_Angeles", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -185L), class = "data.frame")
}

"Maceio" <- function () {
structure(list(Maceio = c("1901-12-14 20:45:52", "1914-01-01 02:22:52", 
"1931-10-03 14:00:00", "1932-04-01 02:00:00", "1932-10-03 03:00:00", 
"1933-04-01 02:00:00", "1949-12-01 03:00:00", "1950-04-16 03:00:00", 
"1950-12-01 03:00:00", "1951-04-01 02:00:00", "1951-12-01 03:00:00", 
"1952-04-01 02:00:00", "1952-12-01 03:00:00", "1953-03-01 02:00:00", 
"1963-12-09 03:00:00", "1964-03-01 02:00:00", "1965-01-31 03:00:00", 
"1965-03-31 02:00:00", "1965-12-01 03:00:00", "1966-03-01 02:00:00", 
"1966-11-01 03:00:00", "1967-03-01 02:00:00", "1967-11-01 03:00:00", 
"1968-03-01 02:00:00", "1985-11-02 03:00:00", "1986-03-15 02:00:00", 
"1986-10-25 03:00:00", "1987-02-14 02:00:00", "1987-10-25 03:00:00", 
"1988-02-07 02:00:00", "1988-10-16 03:00:00", "1989-01-29 02:00:00", 
"1989-10-15 03:00:00", "1990-02-11 02:00:00", "1995-10-15 03:00:00", 
"1996-02-11 02:00:00", "1999-10-03 03:00:00", "2000-02-27 02:00:00", 
"2000-10-08 03:00:00", "2000-10-22 02:00:00", "2001-10-14 03:00:00", 
"2002-02-17 02:00:00"), offSet = c(-8572L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L), isdst = c(0L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT"), numeric = c(-2147397248, -1767217028, 
-1206957600, -1191362400, -1175374800, -1159826400, -633819600, 
-622069200, -602283600, -591832800, -570747600, -560210400, -539125200, 
-531352800, -191365200, -184197600, -155163600, -150069600, -128898000, 
-121125600, -99954000, -89589600, -68418000, -57967200, 499748400, 
511236000, 530593200, 540266400, 562129200, 571197600, 592974000, 
602042400, 624423600, 634701600, 813726000, 824004000, 938919600, 
951616800, 970974000, 972180000, 1003028400, 1013911200)), .Names = c("Maceio", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-42L), class = "data.frame")
}

"Managua" <- function () {
structure(list(Managua = c("1901-12-14 20:45:52", "1934-06-23 05:45:12", 
"1973-05-01 06:00:00", "1975-02-16 05:00:00", "1979-03-18 06:00:00", 
"1979-06-25 05:00:00", "1980-03-16 06:00:00", "1980-06-23 05:00:00", 
"1992-01-01 10:00:00", "1992-09-24 05:00:00", "1993-01-01 06:00:00", 
"1997-01-01 05:00:00", "2005-04-10 06:00:00", "2005-10-02 05:00:00", 
"2006-04-30 08:00:00", "2006-10-01 06:00:00"), offSet = c(-20712L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L), isdst = c(0L, 0L, 0L, 0L, 1L, 0L, 1L, 0L, 0L, 0L, 0L, 
0L, 1L, 0L, 1L, 0L), TimeZone = c("MMT", "CST", "EST", "CST", 
"CDT", "CST", "CDT", "CST", "EST", "CST", "EST", "CST", "CDT", 
"CST", "CDT", "CST"), numeric = c(-2147397248, -1121105688, 105084000, 
161758800, 290584800, 299134800, 322034400, 330584400, 694260000, 
717310800, 725868000, 852094800, 1113112800, 1128229200, 1146384000, 
1159682400)), .Names = c("Managua", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -16L), class = "data.frame")
}

"Manaus" <- function () {
structure(list(Manaus = c("1901-12-14 20:45:52", "1914-01-01 04:00:04", 
"1931-10-03 15:00:00", "1932-04-01 03:00:00", "1932-10-03 04:00:00", 
"1933-04-01 03:00:00", "1949-12-01 04:00:00", "1950-04-16 04:00:00", 
"1950-12-01 04:00:00", "1951-04-01 03:00:00", "1951-12-01 04:00:00", 
"1952-04-01 03:00:00", "1952-12-01 04:00:00", "1953-03-01 03:00:00", 
"1963-12-09 04:00:00", "1964-03-01 03:00:00", "1965-01-31 04:00:00", 
"1965-03-31 03:00:00", "1965-12-01 04:00:00", "1966-03-01 03:00:00", 
"1966-11-01 04:00:00", "1967-03-01 03:00:00", "1967-11-01 04:00:00", 
"1968-03-01 03:00:00", "1985-11-02 04:00:00", "1986-03-15 03:00:00", 
"1986-10-25 04:00:00", "1987-02-14 03:00:00", "1987-10-25 04:00:00", 
"1988-02-07 03:00:00", "1993-10-17 04:00:00", "1994-02-20 03:00:00"
), offSet = c(-14404L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L), isdst = c(0L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT"), numeric = c(-2147397248, -1767211196, 
-1206954000, -1191358800, -1175371200, -1159822800, -633816000, 
-622065600, -602280000, -591829200, -570744000, -560206800, -539121600, 
-531349200, -191361600, -184194000, -155160000, -150066000, -128894400, 
-121122000, -99950400, -89586000, -68414400, -57963600, 499752000, 
511239600, 530596800, 540270000, 562132800, 571201200, 750830400, 
761713200)), .Names = c("Manaus", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -32L), class = "data.frame")
}

"Marigot" <- function () {
structure(list(Marigot = c("1901-12-14 20:45:52", "1911-06-08 04:06:08"
), offSet = c(-14768L, -14400L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"AST"), numeric = c(-2147397248, -1848254032)), .Names = c("Marigot", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Martinique" <- function () {
structure(list(Martinique = c("1901-12-14 20:45:52", "1911-05-01 04:04:20", 
"1980-04-06 04:00:00", "1980-09-28 03:00:00"), offSet = c(-14660L, 
-14400L, -10800L, -14400L), isdst = c(0L, 0L, 1L, 0L), TimeZone = c("FFMT", 
"AST", "ADT", "AST"), numeric = c(-2147397248, -1851537340, 323841600, 
338958000)), .Names = c("Martinique", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"Mazatlan" <- function () {
structure(list(Mazatlan = c("1901-12-14 20:45:52", "1922-01-01 07:00:00", 
"1927-06-11 06:00:00", "1930-11-15 06:00:00", "1931-05-02 06:00:00", 
"1931-10-01 06:00:00", "1932-04-01 07:00:00", "1942-04-24 06:00:00", 
"1949-01-14 07:00:00", "1970-01-01 08:00:00", "1996-04-07 09:00:00", 
"1996-10-27 08:00:00", "1997-04-06 09:00:00", "1997-10-26 08:00:00", 
"1998-04-05 09:00:00", "1998-10-25 08:00:00", "1999-04-04 09:00:00", 
"1999-10-31 08:00:00", "2000-04-02 09:00:00", "2000-10-29 08:00:00", 
"2001-05-06 09:00:00", "2001-09-30 08:00:00", "2002-04-07 09:00:00", 
"2002-10-27 08:00:00", "2003-04-06 09:00:00", "2003-10-26 08:00:00", 
"2004-04-04 09:00:00", "2004-10-31 08:00:00", "2005-04-03 09:00:00", 
"2005-10-30 08:00:00", "2006-04-02 09:00:00", "2006-10-29 08:00:00", 
"2007-04-01 09:00:00", "2007-10-28 08:00:00", "2008-04-06 09:00:00", 
"2008-10-26 08:00:00", "2009-04-05 09:00:00", "2009-10-25 08:00:00", 
"2010-04-04 09:00:00", "2010-10-31 08:00:00", "2011-04-03 09:00:00", 
"2011-10-30 08:00:00", "2012-04-01 09:00:00", "2012-10-28 08:00:00", 
"2013-04-07 09:00:00", "2013-10-27 08:00:00", "2014-04-06 09:00:00", 
"2014-10-26 08:00:00", "2015-04-05 09:00:00", "2015-10-25 08:00:00", 
"2016-04-03 09:00:00", "2016-10-30 08:00:00", "2017-04-02 09:00:00", 
"2017-10-29 08:00:00", "2018-04-01 09:00:00", "2018-10-28 08:00:00", 
"2019-04-07 09:00:00", "2019-10-27 08:00:00", "2020-04-05 09:00:00", 
"2020-10-25 08:00:00", "2021-04-04 09:00:00", "2021-10-31 08:00:00", 
"2022-04-03 09:00:00", "2022-10-30 08:00:00", "2023-04-02 09:00:00", 
"2023-10-29 08:00:00", "2024-04-07 09:00:00", "2024-10-27 08:00:00", 
"2025-04-06 09:00:00", "2025-10-26 08:00:00", "2026-04-05 09:00:00", 
"2026-10-25 08:00:00", "2027-04-04 09:00:00", "2027-10-31 08:00:00", 
"2028-04-02 09:00:00", "2028-10-29 08:00:00", "2029-04-01 09:00:00", 
"2029-10-28 08:00:00", "2030-04-07 09:00:00", "2030-10-27 08:00:00", 
"2031-04-06 09:00:00", "2031-10-26 08:00:00", "2032-04-04 09:00:00", 
"2032-10-31 08:00:00", "2033-04-03 09:00:00", "2033-10-30 08:00:00", 
"2034-04-02 09:00:00", "2034-10-29 08:00:00", "2035-04-01 09:00:00", 
"2035-10-28 08:00:00", "2036-04-06 09:00:00", "2036-10-26 08:00:00", 
"2037-04-05 09:00:00", "2037-10-25 08:00:00"), offSet = c(-25540L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-28800L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L), isdst = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 
0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "MST", "CST", "MST", 
"CST", "MST", "CST", "MST", "PST", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST"
), numeric = c(-2147397248, -1514739600, -1343066400, -1234807200, 
-1220292000, -1207159200, -1191344400, -873828000, -661539600, 
28800, 828867600, 846403200, 860317200, 877852800, 891766800, 
909302400, 923216400, 941356800, 954666000, 972806400, 989139600, 
1001836800, 1018170000, 1035705600, 1049619600, 1067155200, 1081069200, 
1099209600, 1112518800, 1130659200, 1143968400, 1162108800, 1175418000, 
1193558400, 1207472400, 1225008000, 1238922000, 1256457600, 1270371600, 
1288512000, 1301821200, 1319961600, 1333270800, 1351411200, 1365325200, 
1382860800, 1396774800, 1414310400, 1428224400, 1445760000, 1459674000, 
1477814400, 1491123600, 1509264000, 1522573200, 1540713600, 1554627600, 
1572163200, 1586077200, 1603612800, 1617526800, 1635667200, 1648976400, 
1667116800, 1680426000, 1698566400, 1712480400, 1730016000, 1743930000, 
1761465600, 1775379600, 1792915200, 1806829200, 1824969600, 1838278800, 
1856419200, 1869728400, 1887868800, 1901782800, 1919318400, 1933232400, 
1950768000, 1964682000, 1982822400, 1996131600, 2014272000, 2027581200, 
2045721600, 2059030800, 2077171200, 2091085200, 2108620800, 2122534800, 
2140070400)), .Names = c("Mazatlan", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -94L), class = "data.frame")
}

"Menominee" <- function () {
structure(list(Menominee = c("1901-12-14 20:45:52", "1918-03-31 08:00:00", 
"1918-10-27 07:00:00", "1919-03-30 08:00:00", "1919-10-26 07:00:00", 
"1945-08-14 23:00:00", "1945-09-30 07:00:00", "1946-04-28 08:00:00", 
"1946-09-29 07:00:00", "1966-04-24 08:00:00", "1966-10-30 07:00:00", 
"1973-04-29 07:00:00", "1973-10-28 07:00:00", "1974-01-06 08:00:00", 
"1974-10-27 07:00:00", "1975-02-23 08:00:00", "1975-10-26 07:00:00", 
"1976-04-25 08:00:00", "1976-10-31 07:00:00", "1977-04-24 08:00:00", 
"1977-10-30 07:00:00", "1978-04-30 08:00:00", "1978-10-29 07:00:00", 
"1979-04-29 08:00:00", "1979-10-28 07:00:00", "1980-04-27 08:00:00", 
"1980-10-26 07:00:00", "1981-04-26 08:00:00", "1981-10-25 07:00:00", 
"1982-04-25 08:00:00", "1982-10-31 07:00:00", "1983-04-24 08:00:00", 
"1983-10-30 07:00:00", "1984-04-29 08:00:00", "1984-10-28 07:00:00", 
"1985-04-28 08:00:00", "1985-10-27 07:00:00", "1986-04-27 08:00:00", 
"1986-10-26 07:00:00", "1987-04-05 08:00:00", "1987-10-25 07:00:00", 
"1988-04-03 08:00:00", "1988-10-30 07:00:00", "1989-04-02 08:00:00", 
"1989-10-29 07:00:00", "1990-04-01 08:00:00", "1990-10-28 07:00:00", 
"1991-04-07 08:00:00", "1991-10-27 07:00:00", "1992-04-05 08:00:00", 
"1992-10-25 07:00:00", "1993-04-04 08:00:00", "1993-10-31 07:00:00", 
"1994-04-03 08:00:00", "1994-10-30 07:00:00", "1995-04-02 08:00:00", 
"1995-10-29 07:00:00", "1996-04-07 08:00:00", "1996-10-27 07:00:00", 
"1997-04-06 08:00:00", "1997-10-26 07:00:00", "1998-04-05 08:00:00", 
"1998-10-25 07:00:00", "1999-04-04 08:00:00", "1999-10-31 07:00:00", 
"2000-04-02 08:00:00", "2000-10-29 07:00:00", "2001-04-01 08:00:00", 
"2001-10-28 07:00:00", "2002-04-07 08:00:00", "2002-10-27 07:00:00", 
"2003-04-06 08:00:00", "2003-10-26 07:00:00", "2004-04-04 08:00:00", 
"2004-10-31 07:00:00", "2005-04-03 08:00:00", "2005-10-30 07:00:00", 
"2006-04-02 08:00:00", "2006-10-29 07:00:00", "2007-03-11 08:00:00", 
"2007-11-04 07:00:00", "2008-03-09 08:00:00", "2008-11-02 07:00:00", 
"2009-03-08 08:00:00", "2009-11-01 07:00:00", "2010-03-14 08:00:00", 
"2010-11-07 07:00:00", "2011-03-13 08:00:00", "2011-11-06 07:00:00", 
"2012-03-11 08:00:00", "2012-11-04 07:00:00", "2013-03-10 08:00:00", 
"2013-11-03 07:00:00", "2014-03-09 08:00:00", "2014-11-02 07:00:00", 
"2015-03-08 08:00:00", "2015-11-01 07:00:00", "2016-03-13 08:00:00", 
"2016-11-06 07:00:00", "2017-03-12 08:00:00", "2017-11-05 07:00:00", 
"2018-03-11 08:00:00", "2018-11-04 07:00:00", "2019-03-10 08:00:00", 
"2019-11-03 07:00:00", "2020-03-08 08:00:00", "2020-11-01 07:00:00", 
"2021-03-14 08:00:00", "2021-11-07 07:00:00", "2022-03-13 08:00:00", 
"2022-11-06 07:00:00", "2023-03-12 08:00:00", "2023-11-05 07:00:00", 
"2024-03-10 08:00:00", "2024-11-03 07:00:00", "2025-03-09 08:00:00", 
"2025-11-02 07:00:00", "2026-03-08 08:00:00", "2026-11-01 07:00:00", 
"2027-03-14 08:00:00", "2027-11-07 07:00:00", "2028-03-12 08:00:00", 
"2028-11-05 07:00:00", "2029-03-11 08:00:00", "2029-11-04 07:00:00", 
"2030-03-10 08:00:00", "2030-11-03 07:00:00", "2031-03-09 08:00:00", 
"2031-11-02 07:00:00", "2032-03-14 08:00:00", "2032-11-07 07:00:00", 
"2033-03-13 08:00:00", "2033-11-06 07:00:00", "2034-03-12 08:00:00", 
"2034-11-05 07:00:00", "2035-03-11 08:00:00", "2035-11-04 07:00:00", 
"2036-03-09 08:00:00", "2036-11-02 07:00:00", "2037-03-08 08:00:00", 
"2037-11-01 07:00:00"), offSet = c(-21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L), isdst = c(0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("CST", 
"CDT", "CST", "CDT", "CST", "CPT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST"), numeric = c(-2147397248, 
-1633276800, -1615136400, -1601827200, -1583686800, -769395600, 
-765392400, -747244800, -733942800, -116438400, -100112400, 104914800, 
120639600, 126691200, 152089200, 162374400, 183538800, 199267200, 
215593200, 230716800, 247042800, 262771200, 278492400, 294220800, 
309942000, 325670400, 341391600, 357120000, 372841200, 388569600, 
404895600, 420019200, 436345200, 452073600, 467794800, 483523200, 
499244400, 514972800, 530694000, 544608000, 562143600, 576057600, 
594198000, 607507200, 625647600, 638956800, 657097200, 671011200, 
688546800, 702460800, 719996400, 733910400, 752050800, 765360000, 
783500400, 796809600, 814950000, 828864000, 846399600, 860313600, 
877849200, 891763200, 909298800, 923212800, 941353200, 954662400, 
972802800, 986112000, 1004252400, 1018166400, 1035702000, 1049616000, 
1067151600, 1081065600, 1099206000, 1112515200, 1130655600, 1143964800, 
1162105200, 1173600000, 1194159600, 1205049600, 1225609200, 1236499200, 
1257058800, 1268553600, 1289113200, 1300003200, 1320562800, 1331452800, 
1352012400, 1362902400, 1383462000, 1394352000, 1414911600, 1425801600, 
1446361200, 1457856000, 1478415600, 1489305600, 1509865200, 1520755200, 
1541314800, 1552204800, 1572764400, 1583654400, 1604214000, 1615708800, 
1636268400, 1647158400, 1667718000, 1678608000, 1699167600, 1710057600, 
1730617200, 1741507200, 1762066800, 1772956800, 1793516400, 1805011200, 
1825570800, 1836460800, 1857020400, 1867910400, 1888470000, 1899360000, 
1919919600, 1930809600, 1951369200, 1962864000, 1983423600, 1994313600, 
2014873200, 2025763200, 2046322800, 2057212800, 2077772400, 2088662400, 
2109222000, 2120112000, 2140671600)), .Names = c("Menominee", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-141L), class = "data.frame")
}

"Merida" <- function () {
structure(list(Merida = c("1901-12-14 20:45:52", "1922-01-01 06:00:00", 
"1981-12-23 06:00:00", "1982-12-02 05:00:00", "1996-04-07 08:00:00", 
"1996-10-27 07:00:00", "1997-04-06 08:00:00", "1997-10-26 07:00:00", 
"1998-04-05 08:00:00", "1998-10-25 07:00:00", "1999-04-04 08:00:00", 
"1999-10-31 07:00:00", "2000-04-02 08:00:00", "2000-10-29 07:00:00", 
"2001-05-06 08:00:00", "2001-09-30 07:00:00", "2002-04-07 08:00:00", 
"2002-10-27 07:00:00", "2003-04-06 08:00:00", "2003-10-26 07:00:00", 
"2004-04-04 08:00:00", "2004-10-31 07:00:00", "2005-04-03 08:00:00", 
"2005-10-30 07:00:00", "2006-04-02 08:00:00", "2006-10-29 07:00:00", 
"2007-04-01 08:00:00", "2007-10-28 07:00:00", "2008-04-06 08:00:00", 
"2008-10-26 07:00:00", "2009-04-05 08:00:00", "2009-10-25 07:00:00", 
"2010-04-04 08:00:00", "2010-10-31 07:00:00", "2011-04-03 08:00:00", 
"2011-10-30 07:00:00", "2012-04-01 08:00:00", "2012-10-28 07:00:00", 
"2013-04-07 08:00:00", "2013-10-27 07:00:00", "2014-04-06 08:00:00", 
"2014-10-26 07:00:00", "2015-04-05 08:00:00", "2015-10-25 07:00:00", 
"2016-04-03 08:00:00", "2016-10-30 07:00:00", "2017-04-02 08:00:00", 
"2017-10-29 07:00:00", "2018-04-01 08:00:00", "2018-10-28 07:00:00", 
"2019-04-07 08:00:00", "2019-10-27 07:00:00", "2020-04-05 08:00:00", 
"2020-10-25 07:00:00", "2021-04-04 08:00:00", "2021-10-31 07:00:00", 
"2022-04-03 08:00:00", "2022-10-30 07:00:00", "2023-04-02 08:00:00", 
"2023-10-29 07:00:00", "2024-04-07 08:00:00", "2024-10-27 07:00:00", 
"2025-04-06 08:00:00", "2025-10-26 07:00:00", "2026-04-05 08:00:00", 
"2026-10-25 07:00:00", "2027-04-04 08:00:00", "2027-10-31 07:00:00", 
"2028-04-02 08:00:00", "2028-10-29 07:00:00", "2029-04-01 08:00:00", 
"2029-10-28 07:00:00", "2030-04-07 08:00:00", "2030-10-27 07:00:00", 
"2031-04-06 08:00:00", "2031-10-26 07:00:00", "2032-04-04 08:00:00", 
"2032-10-31 07:00:00", "2033-04-03 08:00:00", "2033-10-30 07:00:00", 
"2034-04-02 08:00:00", "2034-10-29 07:00:00", "2035-04-01 08:00:00", 
"2035-10-28 07:00:00", "2036-04-06 08:00:00", "2036-10-26 07:00:00", 
"2037-04-05 08:00:00", "2037-10-25 07:00:00"), offSet = c(-21508L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L), isdst = c(0L, 0L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L), TimeZone = c("LMT", "CST", "EST", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST"), numeric = c(-2147397248, -1514743200, 377935200, 407653200, 
828864000, 846399600, 860313600, 877849200, 891763200, 909298800, 
923212800, 941353200, 954662400, 972802800, 989136000, 1001833200, 
1018166400, 1035702000, 1049616000, 1067151600, 1081065600, 1099206000, 
1112515200, 1130655600, 1143964800, 1162105200, 1175414400, 1193554800, 
1207468800, 1225004400, 1238918400, 1256454000, 1270368000, 1288508400, 
1301817600, 1319958000, 1333267200, 1351407600, 1365321600, 1382857200, 
1396771200, 1414306800, 1428220800, 1445756400, 1459670400, 1477810800, 
1491120000, 1509260400, 1522569600, 1540710000, 1554624000, 1572159600, 
1586073600, 1603609200, 1617523200, 1635663600, 1648972800, 1667113200, 
1680422400, 1698562800, 1712476800, 1730012400, 1743926400, 1761462000, 
1775376000, 1792911600, 1806825600, 1824966000, 1838275200, 1856415600, 
1869724800, 1887865200, 1901779200, 1919314800, 1933228800, 1950764400, 
1964678400, 1982818800, 1996128000, 2014268400, 2027577600, 2045718000, 
2059027200, 2077167600, 2091081600, 2108617200, 2122531200, 2140066800
)), .Names = c("Merida", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -88L), class = "data.frame")
}

"Mexico_City" <- function () {
structure(list(Mexico_City = c("1901-12-14 20:45:52", "1922-01-01 07:00:00", 
"1927-06-11 06:00:00", "1930-11-15 06:00:00", "1931-05-02 06:00:00", 
"1931-10-01 06:00:00", "1932-04-01 07:00:00", "1939-02-05 06:00:00", 
"1939-06-25 05:00:00", "1940-12-09 06:00:00", "1941-04-01 05:00:00", 
"1943-12-16 06:00:00", "1944-05-01 05:00:00", "1950-02-12 06:00:00", 
"1950-07-30 05:00:00", "1996-04-07 08:00:00", "1996-10-27 07:00:00", 
"1997-04-06 08:00:00", "1997-10-26 07:00:00", "1998-04-05 08:00:00", 
"1998-10-25 07:00:00", "1999-04-04 08:00:00", "1999-10-31 07:00:00", 
"2000-04-02 08:00:00", "2000-10-29 07:00:00", "2001-05-06 08:00:00", 
"2001-09-30 07:00:00", "2002-04-07 08:00:00", "2002-10-27 07:00:00", 
"2003-04-06 08:00:00", "2003-10-26 07:00:00", "2004-04-04 08:00:00", 
"2004-10-31 07:00:00", "2005-04-03 08:00:00", "2005-10-30 07:00:00", 
"2006-04-02 08:00:00", "2006-10-29 07:00:00", "2007-04-01 08:00:00", 
"2007-10-28 07:00:00", "2008-04-06 08:00:00", "2008-10-26 07:00:00", 
"2009-04-05 08:00:00", "2009-10-25 07:00:00", "2010-04-04 08:00:00", 
"2010-10-31 07:00:00", "2011-04-03 08:00:00", "2011-10-30 07:00:00", 
"2012-04-01 08:00:00", "2012-10-28 07:00:00", "2013-04-07 08:00:00", 
"2013-10-27 07:00:00", "2014-04-06 08:00:00", "2014-10-26 07:00:00", 
"2015-04-05 08:00:00", "2015-10-25 07:00:00", "2016-04-03 08:00:00", 
"2016-10-30 07:00:00", "2017-04-02 08:00:00", "2017-10-29 07:00:00", 
"2018-04-01 08:00:00", "2018-10-28 07:00:00", "2019-04-07 08:00:00", 
"2019-10-27 07:00:00", "2020-04-05 08:00:00", "2020-10-25 07:00:00", 
"2021-04-04 08:00:00", "2021-10-31 07:00:00", "2022-04-03 08:00:00", 
"2022-10-30 07:00:00", "2023-04-02 08:00:00", "2023-10-29 07:00:00", 
"2024-04-07 08:00:00", "2024-10-27 07:00:00", "2025-04-06 08:00:00", 
"2025-10-26 07:00:00", "2026-04-05 08:00:00", "2026-10-25 07:00:00", 
"2027-04-04 08:00:00", "2027-10-31 07:00:00", "2028-04-02 08:00:00", 
"2028-10-29 07:00:00", "2029-04-01 08:00:00", "2029-10-28 07:00:00", 
"2030-04-07 08:00:00", "2030-10-27 07:00:00", "2031-04-06 08:00:00", 
"2031-10-26 07:00:00", "2032-04-04 08:00:00", "2032-10-31 07:00:00", 
"2033-04-03 08:00:00", "2033-10-30 07:00:00", "2034-04-02 08:00:00", 
"2034-10-29 07:00:00", "2035-04-01 08:00:00", "2035-10-28 07:00:00", 
"2036-04-06 08:00:00", "2036-10-26 07:00:00", "2037-04-05 08:00:00", 
"2037-10-25 07:00:00"), offSet = c(-23796L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L), isdst = c(0L, 0L, 
0L, 0L, 0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L), TimeZone = c("LMT", "MST", "CST", "MST", "CST", "MST", "CST", 
"CDT", "CST", "CDT", "CST", "CWT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST"), numeric = c(-2147397248, -1514739600, -1343066400, 
-1234807200, -1220292000, -1207159200, -1191344400, -975261600, 
-963169200, -917114400, -907354800, -821901600, -810068400, -627501600, 
-612990000, 828864000, 846399600, 860313600, 877849200, 891763200, 
909298800, 923212800, 941353200, 954662400, 972802800, 989136000, 
1001833200, 1018166400, 1035702000, 1049616000, 1067151600, 1081065600, 
1099206000, 1112515200, 1130655600, 1143964800, 1162105200, 1175414400, 
1193554800, 1207468800, 1225004400, 1238918400, 1256454000, 1270368000, 
1288508400, 1301817600, 1319958000, 1333267200, 1351407600, 1365321600, 
1382857200, 1396771200, 1414306800, 1428220800, 1445756400, 1459670400, 
1477810800, 1491120000, 1509260400, 1522569600, 1540710000, 1554624000, 
1572159600, 1586073600, 1603609200, 1617523200, 1635663600, 1648972800, 
1667113200, 1680422400, 1698562800, 1712476800, 1730012400, 1743926400, 
1761462000, 1775376000, 1792911600, 1806825600, 1824966000, 1838275200, 
1856415600, 1869724800, 1887865200, 1901779200, 1919314800, 1933228800, 
1950764400, 1964678400, 1982818800, 1996128000, 2014268400, 2027577600, 
2045718000, 2059027200, 2077167600, 2091081600, 2108617200, 2122531200, 
2140066800)), .Names = c("Mexico_City", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -99L), class = "data.frame")
}

"Miquelon" <- function () {
structure(list(Miquelon = c("1901-12-14 20:45:52", "1911-05-15 03:44:40", 
"1980-05-01 04:00:00", "1987-04-05 05:00:00", "1987-10-25 04:00:00", 
"1988-04-03 05:00:00", "1988-10-30 04:00:00", "1989-04-02 05:00:00", 
"1989-10-29 04:00:00", "1990-04-01 05:00:00", "1990-10-28 04:00:00", 
"1991-04-07 05:00:00", "1991-10-27 04:00:00", "1992-04-05 05:00:00", 
"1992-10-25 04:00:00", "1993-04-04 05:00:00", "1993-10-31 04:00:00", 
"1994-04-03 05:00:00", "1994-10-30 04:00:00", "1995-04-02 05:00:00", 
"1995-10-29 04:00:00", "1996-04-07 05:00:00", "1996-10-27 04:00:00", 
"1997-04-06 05:00:00", "1997-10-26 04:00:00", "1998-04-05 05:00:00", 
"1998-10-25 04:00:00", "1999-04-04 05:00:00", "1999-10-31 04:00:00", 
"2000-04-02 05:00:00", "2000-10-29 04:00:00", "2001-04-01 05:00:00", 
"2001-10-28 04:00:00", "2002-04-07 05:00:00", "2002-10-27 04:00:00", 
"2003-04-06 05:00:00", "2003-10-26 04:00:00", "2004-04-04 05:00:00", 
"2004-10-31 04:00:00", "2005-04-03 05:00:00", "2005-10-30 04:00:00", 
"2006-04-02 05:00:00", "2006-10-29 04:00:00", "2007-03-11 05:00:00", 
"2007-11-04 04:00:00", "2008-03-09 05:00:00", "2008-11-02 04:00:00", 
"2009-03-08 05:00:00", "2009-11-01 04:00:00", "2010-03-14 05:00:00", 
"2010-11-07 04:00:00", "2011-03-13 05:00:00", "2011-11-06 04:00:00", 
"2012-03-11 05:00:00", "2012-11-04 04:00:00", "2013-03-10 05:00:00", 
"2013-11-03 04:00:00", "2014-03-09 05:00:00", "2014-11-02 04:00:00", 
"2015-03-08 05:00:00", "2015-11-01 04:00:00", "2016-03-13 05:00:00", 
"2016-11-06 04:00:00", "2017-03-12 05:00:00", "2017-11-05 04:00:00", 
"2018-03-11 05:00:00", "2018-11-04 04:00:00", "2019-03-10 05:00:00", 
"2019-11-03 04:00:00", "2020-03-08 05:00:00", "2020-11-01 04:00:00", 
"2021-03-14 05:00:00", "2021-11-07 04:00:00", "2022-03-13 05:00:00", 
"2022-11-06 04:00:00", "2023-03-12 05:00:00", "2023-11-05 04:00:00", 
"2024-03-10 05:00:00", "2024-11-03 04:00:00", "2025-03-09 05:00:00", 
"2025-11-02 04:00:00", "2026-03-08 05:00:00", "2026-11-01 04:00:00", 
"2027-03-14 05:00:00", "2027-11-07 04:00:00", "2028-03-12 05:00:00", 
"2028-11-05 04:00:00", "2029-03-11 05:00:00", "2029-11-04 04:00:00", 
"2030-03-10 05:00:00", "2030-11-03 04:00:00", "2031-03-09 05:00:00", 
"2031-11-02 04:00:00", "2032-03-14 05:00:00", "2032-11-07 04:00:00", 
"2033-03-13 05:00:00", "2033-11-06 04:00:00", "2034-03-12 05:00:00", 
"2034-11-05 04:00:00", "2035-03-11 05:00:00", "2035-11-04 04:00:00", 
"2036-03-09 05:00:00", "2036-11-02 04:00:00", "2037-03-08 05:00:00", 
"2037-11-01 04:00:00"), offSet = c(-13480L, -14400L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L), isdst = c(0L, 
0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "AST", "PMST", 
"PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", 
"PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", 
"PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", 
"PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", 
"PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", 
"PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", 
"PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", 
"PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", 
"PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", 
"PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", 
"PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", 
"PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST", 
"PMDT", "PMST", "PMDT", "PMST", "PMDT", "PMST"), numeric = c(-2147397248, 
-1850328920, 326001600, 544597200, 562132800, 576046800, 594187200, 
607496400, 625636800, 638946000, 657086400, 671000400, 688536000, 
702450000, 719985600, 733899600, 752040000, 765349200, 783489600, 
796798800, 814939200, 828853200, 846388800, 860302800, 877838400, 
891752400, 909288000, 923202000, 941342400, 954651600, 972792000, 
986101200, 1004241600, 1018155600, 1035691200, 1049605200, 1067140800, 
1081054800, 1099195200, 1112504400, 1130644800, 1143954000, 1162094400, 
1173589200, 1194148800, 1205038800, 1225598400, 1236488400, 1257048000, 
1268542800, 1289102400, 1299992400, 1320552000, 1331442000, 1352001600, 
1362891600, 1383451200, 1394341200, 1414900800, 1425790800, 1446350400, 
1457845200, 1478404800, 1489294800, 1509854400, 1520744400, 1541304000, 
1552194000, 1572753600, 1583643600, 1604203200, 1615698000, 1636257600, 
1647147600, 1667707200, 1678597200, 1699156800, 1710046800, 1730606400, 
1741496400, 1762056000, 1772946000, 1793505600, 1805000400, 1825560000, 
1836450000, 1857009600, 1867899600, 1888459200, 1899349200, 1919908800, 
1930798800, 1951358400, 1962853200, 1983412800, 1994302800, 2014862400, 
2025752400, 2046312000, 2057202000, 2077761600, 2088651600, 2109211200, 
2120101200, 2140660800)), .Names = c("Miquelon", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -105L), class = "data.frame")
}

"Moncton" <- function () {
structure(list(Moncton = c("1901-12-14 20:45:52", "1902-06-15 05:00:00", 
"1918-04-14 06:00:00", "1918-10-31 05:00:00", "1933-06-11 05:00:00", 
"1933-09-10 04:00:00", "1934-06-10 05:00:00", "1934-09-09 04:00:00", 
"1935-06-09 05:00:00", "1935-09-08 04:00:00", "1936-06-07 05:00:00", 
"1936-09-06 04:00:00", "1937-06-06 05:00:00", "1937-09-05 04:00:00", 
"1938-06-05 05:00:00", "1938-09-04 04:00:00", "1939-05-27 05:00:00", 
"1939-09-23 04:00:00", "1940-05-19 05:00:00", "1940-09-21 04:00:00", 
"1941-05-04 05:00:00", "1941-09-27 04:00:00", "1945-08-14 23:00:00", 
"1945-09-30 05:00:00", "1946-04-28 06:00:00", "1946-09-29 05:00:00", 
"1947-04-27 06:00:00", "1947-09-28 05:00:00", "1948-04-25 06:00:00", 
"1948-09-26 05:00:00", "1949-04-24 06:00:00", "1949-09-25 05:00:00", 
"1950-04-30 06:00:00", "1950-09-24 05:00:00", "1951-04-29 06:00:00", 
"1951-09-30 05:00:00", "1952-04-27 06:00:00", "1952-09-28 05:00:00", 
"1953-04-26 06:00:00", "1953-09-27 05:00:00", "1954-04-25 06:00:00", 
"1954-09-26 05:00:00", "1955-04-24 06:00:00", "1955-09-25 05:00:00", 
"1956-04-29 06:00:00", "1956-09-30 05:00:00", "1957-04-28 06:00:00", 
"1957-10-27 05:00:00", "1958-04-27 06:00:00", "1958-10-26 05:00:00", 
"1959-04-26 06:00:00", "1959-10-25 05:00:00", "1960-04-24 06:00:00", 
"1960-10-30 05:00:00", "1961-04-30 06:00:00", "1961-10-29 05:00:00", 
"1962-04-29 06:00:00", "1962-10-28 05:00:00", "1963-04-28 06:00:00", 
"1963-10-27 05:00:00", "1964-04-26 06:00:00", "1964-10-25 05:00:00", 
"1965-04-25 06:00:00", "1965-10-31 05:00:00", "1966-04-24 06:00:00", 
"1966-10-30 05:00:00", "1967-04-30 06:00:00", "1967-10-29 05:00:00", 
"1968-04-28 06:00:00", "1968-10-27 05:00:00", "1969-04-27 06:00:00", 
"1969-10-26 05:00:00", "1970-04-26 06:00:00", "1970-10-25 05:00:00", 
"1971-04-25 06:00:00", "1971-10-31 05:00:00", "1972-04-30 06:00:00", 
"1972-10-29 05:00:00", "1974-04-28 06:00:00", "1974-10-27 05:00:00", 
"1975-04-27 06:00:00", "1975-10-26 05:00:00", "1976-04-25 06:00:00", 
"1976-10-31 05:00:00", "1977-04-24 06:00:00", "1977-10-30 05:00:00", 
"1978-04-30 06:00:00", "1978-10-29 05:00:00", "1979-04-29 06:00:00", 
"1979-10-28 05:00:00", "1980-04-27 06:00:00", "1980-10-26 05:00:00", 
"1981-04-26 06:00:00", "1981-10-25 05:00:00", "1982-04-25 06:00:00", 
"1982-10-31 05:00:00", "1983-04-24 06:00:00", "1983-10-30 05:00:00", 
"1984-04-29 06:00:00", "1984-10-28 05:00:00", "1985-04-28 06:00:00", 
"1985-10-27 05:00:00", "1986-04-27 06:00:00", "1986-10-26 05:00:00", 
"1987-04-05 06:00:00", "1987-10-25 05:00:00", "1988-04-03 06:00:00", 
"1988-10-30 05:00:00", "1989-04-02 06:00:00", "1989-10-29 05:00:00", 
"1990-04-01 06:00:00", "1990-10-28 05:00:00", "1991-04-07 06:00:00", 
"1991-10-27 05:00:00", "1992-04-05 06:00:00", "1992-10-25 05:00:00", 
"1993-04-04 04:01:00", "1993-10-31 03:01:00", "1994-04-03 04:01:00", 
"1994-10-30 03:01:00", "1995-04-02 04:01:00", "1995-10-29 03:01:00", 
"1996-04-07 04:01:00", "1996-10-27 03:01:00", "1997-04-06 04:01:00", 
"1997-10-26 03:01:00", "1998-04-05 04:01:00", "1998-10-25 03:01:00", 
"1999-04-04 04:01:00", "1999-10-31 03:01:00", "2000-04-02 04:01:00", 
"2000-10-29 03:01:00", "2001-04-01 04:01:00", "2001-10-28 03:01:00", 
"2002-04-07 04:01:00", "2002-10-27 03:01:00", "2003-04-06 04:01:00", 
"2003-10-26 03:01:00", "2004-04-04 04:01:00", "2004-10-31 03:01:00", 
"2005-04-03 04:01:00", "2005-10-30 03:01:00", "2006-04-02 04:01:00", 
"2006-10-29 03:01:00", "2007-03-11 06:00:00", "2007-11-04 05:00:00", 
"2008-03-09 06:00:00", "2008-11-02 05:00:00", "2009-03-08 06:00:00", 
"2009-11-01 05:00:00", "2010-03-14 06:00:00", "2010-11-07 05:00:00", 
"2011-03-13 06:00:00", "2011-11-06 05:00:00", "2012-03-11 06:00:00", 
"2012-11-04 05:00:00", "2013-03-10 06:00:00", "2013-11-03 05:00:00", 
"2014-03-09 06:00:00", "2014-11-02 05:00:00", "2015-03-08 06:00:00", 
"2015-11-01 05:00:00", "2016-03-13 06:00:00", "2016-11-06 05:00:00", 
"2017-03-12 06:00:00", "2017-11-05 05:00:00", "2018-03-11 06:00:00", 
"2018-11-04 05:00:00", "2019-03-10 06:00:00", "2019-11-03 05:00:00", 
"2020-03-08 06:00:00", "2020-11-01 05:00:00", "2021-03-14 06:00:00", 
"2021-11-07 05:00:00", "2022-03-13 06:00:00", "2022-11-06 05:00:00", 
"2023-03-12 06:00:00", "2023-11-05 05:00:00", "2024-03-10 06:00:00", 
"2024-11-03 05:00:00", "2025-03-09 06:00:00", "2025-11-02 05:00:00", 
"2026-03-08 06:00:00", "2026-11-01 05:00:00", "2027-03-14 06:00:00", 
"2027-11-07 05:00:00", "2028-03-12 06:00:00", "2028-11-05 05:00:00", 
"2029-03-11 06:00:00", "2029-11-04 05:00:00", "2030-03-10 06:00:00", 
"2030-11-03 05:00:00", "2031-03-09 06:00:00", "2031-11-02 05:00:00", 
"2032-03-14 06:00:00", "2032-11-07 05:00:00", "2033-03-13 06:00:00", 
"2033-11-06 05:00:00", "2034-03-12 06:00:00", "2034-11-05 05:00:00", 
"2035-03-11 06:00:00", "2035-11-04 05:00:00", "2036-03-09 06:00:00", 
"2036-11-02 05:00:00", "2037-03-08 06:00:00", "2037-11-01 05:00:00"
), offSet = c(-18000L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L), isdst = c(0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("EST", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "APT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST"), numeric = c(-2147397248, 
-2131642800, -1632074400, -1614798000, -1153681200, -1145822400, 
-1122231600, -1114372800, -1090782000, -1082923200, -1059332400, 
-1051473600, -1027882800, -1020024000, -996433200, -988574400, 
-965674800, -955396800, -934743600, -923947200, -904503600, -891892800, 
-769395600, -765399600, -747252000, -733950000, -715802400, -702500400, 
-684352800, -671050800, -652903200, -639601200, -620848800, -608151600, 
-589399200, -576097200, -557949600, -544647600, -526500000, -513198000, 
-495050400, -481748400, -463600800, -450298800, -431546400, -418244400, 
-400096800, -384375600, -368647200, -352926000, -337197600, -321476400, 
-305748000, -289422000, -273693600, -257972400, -242244000, -226522800, 
-210794400, -195073200, -179344800, -163623600, -147895200, -131569200, 
-116445600, -100119600, -84391200, -68670000, -52941600, -37220400, 
-21492000, -5770800, 9957600, 25678800, 41407200, 57733200, 73461600, 
89182800, 136360800, 152082000, 167810400, 183531600, 199260000, 
215586000, 230709600, 247035600, 262764000, 278485200, 294213600, 
309934800, 325663200, 341384400, 357112800, 372834000, 388562400, 
404888400, 420012000, 436338000, 452066400, 467787600, 483516000, 
499237200, 514965600, 530686800, 544600800, 562136400, 576050400, 
594190800, 607500000, 625640400, 638949600, 657090000, 671004000, 
688539600, 702453600, 719989200, 733896060, 752036460, 765345660, 
783486060, 796795260, 814935660, 828849660, 846385260, 860299260, 
877834860, 891748860, 909284460, 923198460, 941338860, 954648060, 
972788460, 986097660, 1004238060, 1018152060, 1035687660, 1049601660, 
1067137260, 1081051260, 1099191660, 1112500860, 1130641260, 1143950460, 
1162090860, 1173592800, 1194152400, 1205042400, 1225602000, 1236492000, 
1257051600, 1268546400, 1289106000, 1299996000, 1320555600, 1331445600, 
1352005200, 1362895200, 1383454800, 1394344800, 1414904400, 1425794400, 
1446354000, 1457848800, 1478408400, 1489298400, 1509858000, 1520748000, 
1541307600, 1552197600, 1572757200, 1583647200, 1604206800, 1615701600, 
1636261200, 1647151200, 1667710800, 1678600800, 1699160400, 1710050400, 
1730610000, 1741500000, 1762059600, 1772949600, 1793509200, 1805004000, 
1825563600, 1836453600, 1857013200, 1867903200, 1888462800, 1899352800, 
1919912400, 1930802400, 1951362000, 1962856800, 1983416400, 1994306400, 
2014866000, 2025756000, 2046315600, 2057205600, 2077765200, 2088655200, 
2109214800, 2120104800, 2140664400)), .Names = c("Moncton", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -206L), class = "data.frame")
}

"Monterrey" <- function () {
structure(list(Monterrey = c("1901-12-14 20:45:52", "1922-01-01 06:00:00", 
"1988-04-03 08:00:00", "1988-10-30 07:00:00", "1996-04-07 08:00:00", 
"1996-10-27 07:00:00", "1997-04-06 08:00:00", "1997-10-26 07:00:00", 
"1998-04-05 08:00:00", "1998-10-25 07:00:00", "1999-04-04 08:00:00", 
"1999-10-31 07:00:00", "2000-04-02 08:00:00", "2000-10-29 07:00:00", 
"2001-05-06 08:00:00", "2001-09-30 07:00:00", "2002-04-07 08:00:00", 
"2002-10-27 07:00:00", "2003-04-06 08:00:00", "2003-10-26 07:00:00", 
"2004-04-04 08:00:00", "2004-10-31 07:00:00", "2005-04-03 08:00:00", 
"2005-10-30 07:00:00", "2006-04-02 08:00:00", "2006-10-29 07:00:00", 
"2007-04-01 08:00:00", "2007-10-28 07:00:00", "2008-04-06 08:00:00", 
"2008-10-26 07:00:00", "2009-04-05 08:00:00", "2009-10-25 07:00:00", 
"2010-04-04 08:00:00", "2010-10-31 07:00:00", "2011-04-03 08:00:00", 
"2011-10-30 07:00:00", "2012-04-01 08:00:00", "2012-10-28 07:00:00", 
"2013-04-07 08:00:00", "2013-10-27 07:00:00", "2014-04-06 08:00:00", 
"2014-10-26 07:00:00", "2015-04-05 08:00:00", "2015-10-25 07:00:00", 
"2016-04-03 08:00:00", "2016-10-30 07:00:00", "2017-04-02 08:00:00", 
"2017-10-29 07:00:00", "2018-04-01 08:00:00", "2018-10-28 07:00:00", 
"2019-04-07 08:00:00", "2019-10-27 07:00:00", "2020-04-05 08:00:00", 
"2020-10-25 07:00:00", "2021-04-04 08:00:00", "2021-10-31 07:00:00", 
"2022-04-03 08:00:00", "2022-10-30 07:00:00", "2023-04-02 08:00:00", 
"2023-10-29 07:00:00", "2024-04-07 08:00:00", "2024-10-27 07:00:00", 
"2025-04-06 08:00:00", "2025-10-26 07:00:00", "2026-04-05 08:00:00", 
"2026-10-25 07:00:00", "2027-04-04 08:00:00", "2027-10-31 07:00:00", 
"2028-04-02 08:00:00", "2028-10-29 07:00:00", "2029-04-01 08:00:00", 
"2029-10-28 07:00:00", "2030-04-07 08:00:00", "2030-10-27 07:00:00", 
"2031-04-06 08:00:00", "2031-10-26 07:00:00", "2032-04-04 08:00:00", 
"2032-10-31 07:00:00", "2033-04-03 08:00:00", "2033-10-30 07:00:00", 
"2034-04-02 08:00:00", "2034-10-29 07:00:00", "2035-04-01 08:00:00", 
"2035-10-28 07:00:00", "2036-04-06 08:00:00", "2036-10-26 07:00:00", 
"2037-04-05 08:00:00", "2037-10-25 07:00:00"), offSet = c(-24076L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L), TimeZone = c("LMT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST"), numeric = c(-2147397248, -1514743200, 576057600, 594198000, 
828864000, 846399600, 860313600, 877849200, 891763200, 909298800, 
923212800, 941353200, 954662400, 972802800, 989136000, 1001833200, 
1018166400, 1035702000, 1049616000, 1067151600, 1081065600, 1099206000, 
1112515200, 1130655600, 1143964800, 1162105200, 1175414400, 1193554800, 
1207468800, 1225004400, 1238918400, 1256454000, 1270368000, 1288508400, 
1301817600, 1319958000, 1333267200, 1351407600, 1365321600, 1382857200, 
1396771200, 1414306800, 1428220800, 1445756400, 1459670400, 1477810800, 
1491120000, 1509260400, 1522569600, 1540710000, 1554624000, 1572159600, 
1586073600, 1603609200, 1617523200, 1635663600, 1648972800, 1667113200, 
1680422400, 1698562800, 1712476800, 1730012400, 1743926400, 1761462000, 
1775376000, 1792911600, 1806825600, 1824966000, 1838275200, 1856415600, 
1869724800, 1887865200, 1901779200, 1919314800, 1933228800, 1950764400, 
1964678400, 1982818800, 1996128000, 2014268400, 2027577600, 2045718000, 
2059027200, 2077167600, 2091081600, 2108617200, 2122531200, 2140066800
)), .Names = c("Monterrey", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -88L), class = "data.frame")
}

"Montevideo" <- function () {
structure(list(Montevideo = c("1901-12-14 20:45:52", "1920-05-01 03:44:44", 
"1923-10-02 03:30:00", "1924-04-01 03:00:00", "1924-10-01 03:30:00", 
"1925-04-01 03:00:00", "1925-10-01 03:30:00", "1926-04-01 03:00:00", 
"1933-10-29 03:30:00", "1934-04-01 03:00:00", "1934-10-28 03:30:00", 
"1935-03-31 03:00:00", "1935-10-27 03:30:00", "1936-03-29 03:00:00", 
"1936-11-01 03:30:00", "1937-03-28 03:00:00", "1937-10-31 03:30:00", 
"1938-03-27 03:00:00", "1938-10-30 03:30:00", "1939-03-26 03:00:00", 
"1939-10-29 03:30:00", "1940-03-31 03:00:00", "1940-10-27 03:30:00", 
"1941-03-30 03:00:00", "1941-08-01 03:30:00", "1942-01-01 03:00:00", 
"1942-12-14 03:30:00", "1943-03-14 02:00:00", "1959-05-24 03:00:00", 
"1959-11-15 02:00:00", "1960-01-17 03:00:00", "1960-03-06 02:00:00", 
"1965-04-04 03:00:00", "1965-09-26 02:00:00", "1966-04-03 03:00:00", 
"1966-10-31 02:00:00", "1967-04-02 03:00:00", "1967-10-31 02:00:00", 
"1968-05-27 03:00:00", "1968-12-02 02:30:00", "1969-05-27 03:00:00", 
"1969-12-02 02:30:00", "1970-05-27 03:00:00", "1970-12-02 02:30:00", 
"1972-04-24 03:00:00", "1972-08-15 02:00:00", "1974-03-10 03:00:00", 
"1974-12-22 02:30:00", "1976-10-01 02:00:00", "1977-12-04 03:00:00", 
"1978-04-01 02:00:00", "1979-10-01 03:00:00", "1980-05-01 02:00:00", 
"1987-12-14 03:00:00", "1988-03-14 02:00:00", "1988-12-11 03:00:00", 
"1989-03-12 02:00:00", "1989-10-29 03:00:00", "1990-03-04 02:00:00", 
"1990-10-21 03:00:00", "1991-03-03 02:00:00", "1991-10-27 03:00:00", 
"1992-03-01 02:00:00", "1992-10-18 03:00:00", "1993-02-28 02:00:00", 
"2004-09-19 03:00:00", "2005-03-27 04:00:00", "2005-10-09 05:00:00", 
"2006-03-12 04:00:00", "2006-10-01 05:00:00", "2007-03-11 04:00:00", 
"2007-10-07 05:00:00", "2008-03-09 04:00:00", "2008-10-05 05:00:00", 
"2009-03-08 04:00:00", "2009-10-04 05:00:00", "2010-03-14 04:00:00", 
"2010-10-03 05:00:00", "2011-03-13 04:00:00", "2011-10-02 05:00:00", 
"2012-03-11 04:00:00", "2012-10-07 05:00:00", "2013-03-10 04:00:00", 
"2013-10-06 05:00:00", "2014-03-09 04:00:00", "2014-10-05 05:00:00", 
"2015-03-08 04:00:00", "2015-10-04 05:00:00", "2016-03-13 04:00:00", 
"2016-10-02 05:00:00", "2017-03-12 04:00:00", "2017-10-01 05:00:00", 
"2018-03-11 04:00:00", "2018-10-07 05:00:00", "2019-03-10 04:00:00", 
"2019-10-06 05:00:00", "2020-03-08 04:00:00", "2020-10-04 05:00:00", 
"2021-03-14 04:00:00", "2021-10-03 05:00:00", "2022-03-13 04:00:00", 
"2022-10-02 05:00:00", "2023-03-12 04:00:00", "2023-10-01 05:00:00", 
"2024-03-10 04:00:00", "2024-10-06 05:00:00", "2025-03-09 04:00:00", 
"2025-10-05 05:00:00", "2026-03-08 04:00:00", "2026-10-04 05:00:00", 
"2027-03-14 04:00:00", "2027-10-03 05:00:00", "2028-03-12 04:00:00", 
"2028-10-01 05:00:00", "2029-03-11 04:00:00", "2029-10-07 05:00:00", 
"2030-03-10 04:00:00", "2030-10-06 05:00:00", "2031-03-09 04:00:00", 
"2031-10-05 05:00:00", "2032-03-14 04:00:00", "2032-10-03 05:00:00", 
"2033-03-13 04:00:00", "2033-10-02 05:00:00", "2034-03-12 04:00:00", 
"2034-10-01 05:00:00", "2035-03-11 04:00:00", "2035-10-07 05:00:00", 
"2036-03-09 04:00:00", "2036-10-05 05:00:00", "2037-03-08 04:00:00", 
"2037-10-04 05:00:00"), offSet = c(-13484L, -12600L, -10800L, 
-12600L, -10800L, -12600L, -10800L, -12600L, -10800L, -12600L, 
-10800L, -12600L, -10800L, -12600L, -10800L, -12600L, -10800L, 
-12600L, -10800L, -12600L, -10800L, -12600L, -10800L, -12600L, 
-10800L, -12600L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -9000L, -10800L, 
-9000L, -10800L, -9000L, -10800L, -7200L, -10800L, -9000L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L), isdst = c(0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L
), TimeZone = c("MMT", "UYT", "UYHST", "UYT", "UYHST", "UYT", 
"UYHST", "UYT", "UYHST", "UYT", "UYHST", "UYT", "UYHST", "UYT", 
"UYHST", "UYT", "UYHST", "UYT", "UYHST", "UYT", "UYHST", "UYT", 
"UYHST", "UYT", "UYHST", "UYT", "UYST", "UYT", "UYST", "UYT", 
"UYST", "UYT", "UYST", "UYT", "UYST", "UYT", "UYST", "UYT", "UYHST", 
"UYT", "UYHST", "UYT", "UYHST", "UYT", "UYST", "UYT", "UYHST", 
"UYST", "UYT", "UYST", "UYT", "UYST", "UYT", "UYST", "UYT", "UYST", 
"UYT", "UYST", "UYT", "UYST", "UYT", "UYST", "UYT", "UYST", "UYT", 
"UYST", "UYT", "UYST", "UYT", "UYST", "UYT", "UYST", "UYT", "UYST", 
"UYT", "UYST", "UYT", "UYST", "UYT", "UYST", "UYT", "UYST", "UYT", 
"UYST", "UYT", "UYST", "UYT", "UYST", "UYT", "UYST", "UYT", "UYST", 
"UYT", "UYST", "UYT", "UYST", "UYT", "UYST", "UYT", "UYST", "UYT", 
"UYST", "UYT", "UYST", "UYT", "UYST", "UYT", "UYST", "UYT", "UYST", 
"UYT", "UYST", "UYT", "UYST", "UYT", "UYST", "UYT", "UYST", "UYT", 
"UYST", "UYT", "UYST", "UYT", "UYST", "UYT", "UYST", "UYT", "UYST", 
"UYT", "UYST", "UYT", "UYST"), numeric = c(-2147397248, -1567455316, 
-1459542600, -1443819600, -1428006600, -1412283600, -1396470600, 
-1380747600, -1141590600, -1128286800, -1110141000, -1096837200, 
-1078691400, -1065387600, -1046637000, -1033938000, -1015187400, 
-1002488400, -983737800, -971038800, -952288200, -938984400, 
-920838600, -907534800, -896819400, -883602000, -853619400, -845848800, 
-334789200, -319672800, -314226000, -309996000, -149720400, -134604000, 
-118270800, -100044000, -86821200, -68508000, -50446800, -34119000, 
-18910800, -2583000, 12625200, 28953000, 72932400, 82692000, 
132116400, 156911400, 212983200, 250052400, 260244000, 307594800, 
325994400, 566449200, 574308000, 597812400, 605671200, 625633200, 
636516000, 656478000, 667965600, 688532400, 699415200, 719377200, 
730864800, 1095562800, 1111896000, 1128834000, 1142136000, 1159678800, 
1173585600, 1191733200, 1205035200, 1223182800, 1236484800, 1254632400, 
1268539200, 1286082000, 1299988800, 1317531600, 1331438400, 1349586000, 
1362888000, 1381035600, 1394337600, 1412485200, 1425787200, 1443934800, 
1457841600, 1475384400, 1489291200, 1506834000, 1520740800, 1538888400, 
1552190400, 1570338000, 1583640000, 1601787600, 1615694400, 1633237200, 
1647144000, 1664686800, 1678593600, 1696136400, 1710043200, 1728190800, 
1741492800, 1759640400, 1772942400, 1791090000, 1804996800, 1822539600, 
1836446400, 1853989200, 1867896000, 1886043600, 1899345600, 1917493200, 
1930795200, 1948942800, 1962849600, 1980392400, 1994299200, 2011842000, 
2025748800, 2043291600, 2057198400, 2075346000, 2088648000, 2106795600, 
2120097600, 2138245200)), .Names = c("Montevideo", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -132L), class = "data.frame")
}

"Montreal" <- function () {
structure(list(Montreal = c("1901-12-14 20:45:52", "1917-03-25 07:00:00", 
"1917-04-24 04:00:00", "1918-04-14 07:00:00", "1918-10-31 06:00:00", 
"1919-03-31 07:30:00", "1919-10-25 06:30:00", "1920-05-02 07:30:00", 
"1920-10-03 06:30:00", "1921-05-01 07:00:00", "1921-10-02 06:30:00", 
"1922-04-30 07:00:00", "1922-10-01 06:30:00", "1924-05-17 07:00:00", 
"1924-09-28 06:30:00", "1925-05-03 07:00:00", "1925-09-27 06:30:00", 
"1926-05-02 07:00:00", "1926-09-26 06:30:00", "1927-05-01 05:00:00", 
"1927-09-25 04:00:00", "1928-04-29 05:00:00", "1928-09-30 04:00:00", 
"1929-04-28 05:00:00", "1929-09-29 04:00:00", "1930-04-27 05:00:00", 
"1930-09-28 04:00:00", "1931-04-26 05:00:00", "1931-09-27 04:00:00", 
"1932-05-01 05:00:00", "1932-09-25 04:00:00", "1933-04-30 05:00:00", 
"1933-10-01 04:00:00", "1934-04-29 05:00:00", "1934-09-30 04:00:00", 
"1935-04-28 05:00:00", "1935-09-29 04:00:00", "1936-04-26 05:00:00", 
"1936-09-27 04:00:00", "1937-04-25 05:00:00", "1937-09-26 04:00:00", 
"1938-04-24 05:00:00", "1938-09-25 04:00:00", "1939-04-30 05:00:00", 
"1939-09-24 04:00:00", "1945-08-14 23:00:00", "1945-09-30 06:00:00", 
"1946-04-28 07:00:00", "1946-09-29 06:00:00", "1947-04-27 07:00:00", 
"1947-09-28 06:00:00", "1948-04-25 07:00:00", "1948-09-26 06:00:00", 
"1949-04-24 07:00:00", "1949-10-30 06:00:00", "1950-04-30 07:00:00", 
"1950-10-29 06:00:00", "1951-04-29 07:00:00", "1951-09-30 06:00:00", 
"1952-04-27 07:00:00", "1952-09-28 06:00:00", "1953-04-26 07:00:00", 
"1953-09-27 06:00:00", "1954-04-25 07:00:00", "1954-09-26 06:00:00", 
"1955-04-24 07:00:00", "1955-09-25 06:00:00", "1956-04-29 07:00:00", 
"1956-09-30 06:00:00", "1957-04-28 07:00:00", "1957-10-27 06:00:00", 
"1958-04-27 07:00:00", "1958-10-26 06:00:00", "1959-04-26 07:00:00", 
"1959-10-25 06:00:00", "1960-04-24 07:00:00", "1960-10-30 06:00:00", 
"1961-04-30 07:00:00", "1961-10-29 06:00:00", "1962-04-29 07:00:00", 
"1962-10-28 06:00:00", "1963-04-28 07:00:00", "1963-10-27 06:00:00", 
"1964-04-26 07:00:00", "1964-10-25 06:00:00", "1965-04-25 07:00:00", 
"1965-10-31 06:00:00", "1966-04-24 07:00:00", "1966-10-30 06:00:00", 
"1967-04-30 07:00:00", "1967-10-29 06:00:00", "1968-04-28 07:00:00", 
"1968-10-27 06:00:00", "1969-04-27 07:00:00", "1969-10-26 06:00:00", 
"1970-04-26 07:00:00", "1970-10-25 06:00:00", "1971-04-25 07:00:00", 
"1971-10-31 06:00:00", "1972-04-30 07:00:00", "1972-10-29 06:00:00", 
"1973-04-29 07:00:00", "1973-10-28 06:00:00", "1974-04-28 07:00:00", 
"1974-10-27 06:00:00", "1975-04-27 07:00:00", "1975-10-26 06:00:00", 
"1976-04-25 07:00:00", "1976-10-31 06:00:00", "1977-04-24 07:00:00", 
"1977-10-30 06:00:00", "1978-04-30 07:00:00", "1978-10-29 06:00:00", 
"1979-04-29 07:00:00", "1979-10-28 06:00:00", "1980-04-27 07:00:00", 
"1980-10-26 06:00:00", "1981-04-26 07:00:00", "1981-10-25 06:00:00", 
"1982-04-25 07:00:00", "1982-10-31 06:00:00", "1983-04-24 07:00:00", 
"1983-10-30 06:00:00", "1984-04-29 07:00:00", "1984-10-28 06:00:00", 
"1985-04-28 07:00:00", "1985-10-27 06:00:00", "1986-04-27 07:00:00", 
"1986-10-26 06:00:00", "1987-04-05 07:00:00", "1987-10-25 06:00:00", 
"1988-04-03 07:00:00", "1988-10-30 06:00:00", "1989-04-02 07:00:00", 
"1989-10-29 06:00:00", "1990-04-01 07:00:00", "1990-10-28 06:00:00", 
"1991-04-07 07:00:00", "1991-10-27 06:00:00", "1992-04-05 07:00:00", 
"1992-10-25 06:00:00", "1993-04-04 07:00:00", "1993-10-31 06:00:00", 
"1994-04-03 07:00:00", "1994-10-30 06:00:00", "1995-04-02 07:00:00", 
"1995-10-29 06:00:00", "1996-04-07 07:00:00", "1996-10-27 06:00:00", 
"1997-04-06 07:00:00", "1997-10-26 06:00:00", "1998-04-05 07:00:00", 
"1998-10-25 06:00:00", "1999-04-04 07:00:00", "1999-10-31 06:00:00", 
"2000-04-02 07:00:00", "2000-10-29 06:00:00", "2001-04-01 07:00:00", 
"2001-10-28 06:00:00", "2002-04-07 07:00:00", "2002-10-27 06:00:00", 
"2003-04-06 07:00:00", "2003-10-26 06:00:00", "2004-04-04 07:00:00", 
"2004-10-31 06:00:00", "2005-04-03 07:00:00", "2005-10-30 06:00:00", 
"2006-04-02 07:00:00", "2006-10-29 06:00:00", "2007-03-11 07:00:00", 
"2007-11-04 06:00:00", "2008-03-09 07:00:00", "2008-11-02 06:00:00", 
"2009-03-08 07:00:00", "2009-11-01 06:00:00", "2010-03-14 07:00:00", 
"2010-11-07 06:00:00", "2011-03-13 07:00:00", "2011-11-06 06:00:00", 
"2012-03-11 07:00:00", "2012-11-04 06:00:00", "2013-03-10 07:00:00", 
"2013-11-03 06:00:00", "2014-03-09 07:00:00", "2014-11-02 06:00:00", 
"2015-03-08 07:00:00", "2015-11-01 06:00:00", "2016-03-13 07:00:00", 
"2016-11-06 06:00:00", "2017-03-12 07:00:00", "2017-11-05 06:00:00", 
"2018-03-11 07:00:00", "2018-11-04 06:00:00", "2019-03-10 07:00:00", 
"2019-11-03 06:00:00", "2020-03-08 07:00:00", "2020-11-01 06:00:00", 
"2021-03-14 07:00:00", "2021-11-07 06:00:00", "2022-03-13 07:00:00", 
"2022-11-06 06:00:00", "2023-03-12 07:00:00", "2023-11-05 06:00:00", 
"2024-03-10 07:00:00", "2024-11-03 06:00:00", "2025-03-09 07:00:00", 
"2025-11-02 06:00:00", "2026-03-08 07:00:00", "2026-11-01 06:00:00", 
"2027-03-14 07:00:00", "2027-11-07 06:00:00", "2028-03-12 07:00:00", 
"2028-11-05 06:00:00", "2029-03-11 07:00:00", "2029-11-04 06:00:00", 
"2030-03-10 07:00:00", "2030-11-03 06:00:00", "2031-03-09 07:00:00", 
"2031-11-02 06:00:00", "2032-03-14 07:00:00", "2032-11-07 06:00:00", 
"2033-03-13 07:00:00", "2033-11-06 06:00:00", "2034-03-12 07:00:00", 
"2034-11-05 06:00:00", "2035-03-11 07:00:00", "2035-11-04 06:00:00", 
"2036-03-09 07:00:00", "2036-11-02 06:00:00", "2037-03-08 07:00:00", 
"2037-11-01 06:00:00"), offSet = c(-18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L), isdst = c(0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L), TimeZone = c("EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EPT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST"), numeric = c(-2147397248, -1665334800, -1662753600, -1632070800, 
-1614794400, -1601742600, -1583775000, -1567355400, -1554053400, 
-1535907600, -1522603800, -1504458000, -1491154200, -1439830800, 
-1428255000, -1409504400, -1396805400, -1378054800, -1365355800, 
-1346612400, -1333915200, -1315162800, -1301860800, -1283713200, 
-1270411200, -1252263600, -1238961600, -1220814000, -1207512000, 
-1188759600, -1176062400, -1157310000, -1144008000, -1125860400, 
-1112558400, -1094410800, -1081108800, -1062961200, -1049659200, 
-1031511600, -1018209600, -1000062000, -986760000, -968007600, 
-955310400, -769395600, -765396000, -747248400, -733946400, -715798800, 
-702496800, -684349200, -671047200, -652899600, -636573600, -620845200, 
-605124000, -589395600, -576093600, -557946000, -544644000, -526496400, 
-513194400, -495046800, -481744800, -463597200, -450295200, -431542800, 
-418240800, -400093200, -384372000, -368643600, -352922400, -337194000, 
-321472800, -305744400, -289418400, -273690000, -257968800, -242240400, 
-226519200, -210790800, -195069600, -179341200, -163620000, -147891600, 
-131565600, -116442000, -100116000, -84387600, -68666400, -52938000, 
-37216800, -21488400, -5767200, 9961200, 25682400, 41410800, 
57736800, 73465200, 89186400, 104914800, 120636000, 136364400, 
152085600, 167814000, 183535200, 199263600, 215589600, 230713200, 
247039200, 262767600, 278488800, 294217200, 309938400, 325666800, 
341388000, 357116400, 372837600, 388566000, 404892000, 420015600, 
436341600, 452070000, 467791200, 483519600, 499240800, 514969200, 
530690400, 544604400, 562140000, 576054000, 594194400, 607503600, 
625644000, 638953200, 657093600, 671007600, 688543200, 702457200, 
719992800, 733906800, 752047200, 765356400, 783496800, 796806000, 
814946400, 828860400, 846396000, 860310000, 877845600, 891759600, 
909295200, 923209200, 941349600, 954658800, 972799200, 986108400, 
1004248800, 1018162800, 1035698400, 1049612400, 1067148000, 1081062000, 
1099202400, 1112511600, 1130652000, 1143961200, 1162101600, 1173596400, 
1194156000, 1205046000, 1225605600, 1236495600, 1257055200, 1268550000, 
1289109600, 1299999600, 1320559200, 1331449200, 1352008800, 1362898800, 
1383458400, 1394348400, 1414908000, 1425798000, 1446357600, 1457852400, 
1478412000, 1489302000, 1509861600, 1520751600, 1541311200, 1552201200, 
1572760800, 1583650800, 1604210400, 1615705200, 1636264800, 1647154800, 
1667714400, 1678604400, 1699164000, 1710054000, 1730613600, 1741503600, 
1762063200, 1772953200, 1793512800, 1805007600, 1825567200, 1836457200, 
1857016800, 1867906800, 1888466400, 1899356400, 1919916000, 1930806000, 
1951365600, 1962860400, 1983420000, 1994310000, 2014869600, 2025759600, 
2046319200, 2057209200, 2077768800, 2088658800, 2109218400, 2120108400, 
2140668000)), .Names = c("Montreal", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -231L), class = "data.frame")
}

"Montserrat" <- function () {
structure(list(Montserrat = c("1901-12-14 20:45:52", "1911-07-01 04:09:52"
), offSet = c(-14932L, -14400L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"AST"), numeric = c(-2147397248, -1846266608)), .Names = c("Montserrat", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Nassau" <- function () {
structure(list(Nassau = c("1901-12-14 20:45:52", "1912-03-02 05:09:24", 
"1964-04-26 07:00:00", "1964-10-25 06:00:00", "1965-04-25 07:00:00", 
"1965-10-31 06:00:00", "1966-04-24 07:00:00", "1966-10-30 06:00:00", 
"1967-04-30 07:00:00", "1967-10-29 06:00:00", "1968-04-28 07:00:00", 
"1968-10-27 06:00:00", "1969-04-27 07:00:00", "1969-10-26 06:00:00", 
"1970-04-26 07:00:00", "1970-10-25 06:00:00", "1971-04-25 07:00:00", 
"1971-10-31 06:00:00", "1972-04-30 07:00:00", "1972-10-29 06:00:00", 
"1973-04-29 07:00:00", "1973-10-28 06:00:00", "1974-04-28 07:00:00", 
"1974-10-27 06:00:00", "1975-04-27 07:00:00", "1975-10-26 06:00:00", 
"1976-04-25 07:00:00", "1976-10-31 06:00:00", "1977-04-24 07:00:00", 
"1977-10-30 06:00:00", "1978-04-30 07:00:00", "1978-10-29 06:00:00", 
"1979-04-29 07:00:00", "1979-10-28 06:00:00", "1980-04-27 07:00:00", 
"1980-10-26 06:00:00", "1981-04-26 07:00:00", "1981-10-25 06:00:00", 
"1982-04-25 07:00:00", "1982-10-31 06:00:00", "1983-04-24 07:00:00", 
"1983-10-30 06:00:00", "1984-04-29 07:00:00", "1984-10-28 06:00:00", 
"1985-04-28 07:00:00", "1985-10-27 06:00:00", "1986-04-27 07:00:00", 
"1986-10-26 06:00:00", "1987-04-05 07:00:00", "1987-10-25 06:00:00", 
"1988-04-03 07:00:00", "1988-10-30 06:00:00", "1989-04-02 07:00:00", 
"1989-10-29 06:00:00", "1990-04-01 07:00:00", "1990-10-28 06:00:00", 
"1991-04-07 07:00:00", "1991-10-27 06:00:00", "1992-04-05 07:00:00", 
"1992-10-25 06:00:00", "1993-04-04 07:00:00", "1993-10-31 06:00:00", 
"1994-04-03 07:00:00", "1994-10-30 06:00:00", "1995-04-02 07:00:00", 
"1995-10-29 06:00:00", "1996-04-07 07:00:00", "1996-10-27 06:00:00", 
"1997-04-06 07:00:00", "1997-10-26 06:00:00", "1998-04-05 07:00:00", 
"1998-10-25 06:00:00", "1999-04-04 07:00:00", "1999-10-31 06:00:00", 
"2000-04-02 07:00:00", "2000-10-29 06:00:00", "2001-04-01 07:00:00", 
"2001-10-28 06:00:00", "2002-04-07 07:00:00", "2002-10-27 06:00:00", 
"2003-04-06 07:00:00", "2003-10-26 06:00:00", "2004-04-04 07:00:00", 
"2004-10-31 06:00:00", "2005-04-03 07:00:00", "2005-10-30 06:00:00", 
"2006-04-02 07:00:00", "2006-10-29 06:00:00", "2007-03-11 07:00:00", 
"2007-11-04 06:00:00", "2008-03-09 07:00:00", "2008-11-02 06:00:00", 
"2009-03-08 07:00:00", "2009-11-01 06:00:00", "2010-03-14 07:00:00", 
"2010-11-07 06:00:00", "2011-03-13 07:00:00", "2011-11-06 06:00:00", 
"2012-03-11 07:00:00", "2012-11-04 06:00:00", "2013-03-10 07:00:00", 
"2013-11-03 06:00:00", "2014-03-09 07:00:00", "2014-11-02 06:00:00", 
"2015-03-08 07:00:00", "2015-11-01 06:00:00", "2016-03-13 07:00:00", 
"2016-11-06 06:00:00", "2017-03-12 07:00:00", "2017-11-05 06:00:00", 
"2018-03-11 07:00:00", "2018-11-04 06:00:00", "2019-03-10 07:00:00", 
"2019-11-03 06:00:00", "2020-03-08 07:00:00", "2020-11-01 06:00:00", 
"2021-03-14 07:00:00", "2021-11-07 06:00:00", "2022-03-13 07:00:00", 
"2022-11-06 06:00:00", "2023-03-12 07:00:00", "2023-11-05 06:00:00", 
"2024-03-10 07:00:00", "2024-11-03 06:00:00", "2025-03-09 07:00:00", 
"2025-11-02 06:00:00", "2026-03-08 07:00:00", "2026-11-01 06:00:00", 
"2027-03-14 07:00:00", "2027-11-07 06:00:00", "2028-03-12 07:00:00", 
"2028-11-05 06:00:00", "2029-03-11 07:00:00", "2029-11-04 06:00:00", 
"2030-03-10 07:00:00", "2030-11-03 06:00:00", "2031-03-09 07:00:00", 
"2031-11-02 06:00:00", "2032-03-14 07:00:00", "2032-11-07 06:00:00", 
"2033-03-13 07:00:00", "2033-11-06 06:00:00", "2034-03-12 07:00:00", 
"2034-11-05 06:00:00", "2035-03-11 07:00:00", "2035-11-04 06:00:00", 
"2036-03-09 07:00:00", "2036-11-02 06:00:00", "2037-03-08 07:00:00", 
"2037-11-01 06:00:00"), offSet = c(-18564L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L
), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST"), numeric = c(-2147397248, 
-1825095036, -179341200, -163620000, -147891600, -131565600, 
-116442000, -100116000, -84387600, -68666400, -52938000, -37216800, 
-21488400, -5767200, 9961200, 25682400, 41410800, 57736800, 73465200, 
89186400, 104914800, 120636000, 136364400, 152085600, 167814000, 
183535200, 199263600, 215589600, 230713200, 247039200, 262767600, 
278488800, 294217200, 309938400, 325666800, 341388000, 357116400, 
372837600, 388566000, 404892000, 420015600, 436341600, 452070000, 
467791200, 483519600, 499240800, 514969200, 530690400, 544604400, 
562140000, 576054000, 594194400, 607503600, 625644000, 638953200, 
657093600, 671007600, 688543200, 702457200, 719992800, 733906800, 
752047200, 765356400, 783496800, 796806000, 814946400, 828860400, 
846396000, 860310000, 877845600, 891759600, 909295200, 923209200, 
941349600, 954658800, 972799200, 986108400, 1004248800, 1018162800, 
1035698400, 1049612400, 1067148000, 1081062000, 1099202400, 1112511600, 
1130652000, 1143961200, 1162101600, 1173596400, 1194156000, 1205046000, 
1225605600, 1236495600, 1257055200, 1268550000, 1289109600, 1299999600, 
1320559200, 1331449200, 1352008800, 1362898800, 1383458400, 1394348400, 
1414908000, 1425798000, 1446357600, 1457852400, 1478412000, 1489302000, 
1509861600, 1520751600, 1541311200, 1552201200, 1572760800, 1583650800, 
1604210400, 1615705200, 1636264800, 1647154800, 1667714400, 1678604400, 
1699164000, 1710054000, 1730613600, 1741503600, 1762063200, 1772953200, 
1793512800, 1805007600, 1825567200, 1836457200, 1857016800, 1867906800, 
1888466400, 1899356400, 1919916000, 1930806000, 1951365600, 1962860400, 
1983420000, 1994310000, 2014869600, 2025759600, 2046319200, 2057209200, 
2077768800, 2088658800, 2109218400, 2120108400, 2140668000)), .Names = c("Nassau", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-150L), class = "data.frame")
}

"New_York" <- function () {
structure(list(New_York = c("1901-12-14 20:45:52", "1918-03-31 07:00:00", 
"1918-10-27 06:00:00", "1919-03-30 07:00:00", "1919-10-26 06:00:00", 
"1920-03-28 07:00:00", "1920-10-31 06:00:00", "1921-04-24 07:00:00", 
"1921-09-25 06:00:00", "1922-04-30 07:00:00", "1922-09-24 06:00:00", 
"1923-04-29 07:00:00", "1923-09-30 06:00:00", "1924-04-27 07:00:00", 
"1924-09-28 06:00:00", "1925-04-26 07:00:00", "1925-09-27 06:00:00", 
"1926-04-25 07:00:00", "1926-09-26 06:00:00", "1927-04-24 07:00:00", 
"1927-09-25 06:00:00", "1928-04-29 07:00:00", "1928-09-30 06:00:00", 
"1929-04-28 07:00:00", "1929-09-29 06:00:00", "1930-04-27 07:00:00", 
"1930-09-28 06:00:00", "1931-04-26 07:00:00", "1931-09-27 06:00:00", 
"1932-04-24 07:00:00", "1932-09-25 06:00:00", "1933-04-30 07:00:00", 
"1933-09-24 06:00:00", "1934-04-29 07:00:00", "1934-09-30 06:00:00", 
"1935-04-28 07:00:00", "1935-09-29 06:00:00", "1936-04-26 07:00:00", 
"1936-09-27 06:00:00", "1937-04-25 07:00:00", "1937-09-26 06:00:00", 
"1938-04-24 07:00:00", "1938-09-25 06:00:00", "1939-04-30 07:00:00", 
"1939-09-24 06:00:00", "1940-04-28 07:00:00", "1940-09-29 06:00:00", 
"1941-04-27 07:00:00", "1941-09-28 06:00:00", "1945-08-14 23:00:00", 
"1945-09-30 06:00:00", "1946-04-28 07:00:00", "1946-09-29 06:00:00", 
"1947-04-27 07:00:00", "1947-09-28 06:00:00", "1948-04-25 07:00:00", 
"1948-09-26 06:00:00", "1949-04-24 07:00:00", "1949-09-25 06:00:00", 
"1950-04-30 07:00:00", "1950-09-24 06:00:00", "1951-04-29 07:00:00", 
"1951-09-30 06:00:00", "1952-04-27 07:00:00", "1952-09-28 06:00:00", 
"1953-04-26 07:00:00", "1953-09-27 06:00:00", "1954-04-25 07:00:00", 
"1954-09-26 06:00:00", "1955-04-24 07:00:00", "1955-10-30 06:00:00", 
"1956-04-29 07:00:00", "1956-10-28 06:00:00", "1957-04-28 07:00:00", 
"1957-10-27 06:00:00", "1958-04-27 07:00:00", "1958-10-26 06:00:00", 
"1959-04-26 07:00:00", "1959-10-25 06:00:00", "1960-04-24 07:00:00", 
"1960-10-30 06:00:00", "1961-04-30 07:00:00", "1961-10-29 06:00:00", 
"1962-04-29 07:00:00", "1962-10-28 06:00:00", "1963-04-28 07:00:00", 
"1963-10-27 06:00:00", "1964-04-26 07:00:00", "1964-10-25 06:00:00", 
"1965-04-25 07:00:00", "1965-10-31 06:00:00", "1966-04-24 07:00:00", 
"1966-10-30 06:00:00", "1967-04-30 07:00:00", "1967-10-29 06:00:00", 
"1968-04-28 07:00:00", "1968-10-27 06:00:00", "1969-04-27 07:00:00", 
"1969-10-26 06:00:00", "1970-04-26 07:00:00", "1970-10-25 06:00:00", 
"1971-04-25 07:00:00", "1971-10-31 06:00:00", "1972-04-30 07:00:00", 
"1972-10-29 06:00:00", "1973-04-29 07:00:00", "1973-10-28 06:00:00", 
"1974-01-06 07:00:00", "1974-10-27 06:00:00", "1975-02-23 07:00:00", 
"1975-10-26 06:00:00", "1976-04-25 07:00:00", "1976-10-31 06:00:00", 
"1977-04-24 07:00:00", "1977-10-30 06:00:00", "1978-04-30 07:00:00", 
"1978-10-29 06:00:00", "1979-04-29 07:00:00", "1979-10-28 06:00:00", 
"1980-04-27 07:00:00", "1980-10-26 06:00:00", "1981-04-26 07:00:00", 
"1981-10-25 06:00:00", "1982-04-25 07:00:00", "1982-10-31 06:00:00", 
"1983-04-24 07:00:00", "1983-10-30 06:00:00", "1984-04-29 07:00:00", 
"1984-10-28 06:00:00", "1985-04-28 07:00:00", "1985-10-27 06:00:00", 
"1986-04-27 07:00:00", "1986-10-26 06:00:00", "1987-04-05 07:00:00", 
"1987-10-25 06:00:00", "1988-04-03 07:00:00", "1988-10-30 06:00:00", 
"1989-04-02 07:00:00", "1989-10-29 06:00:00", "1990-04-01 07:00:00", 
"1990-10-28 06:00:00", "1991-04-07 07:00:00", "1991-10-27 06:00:00", 
"1992-04-05 07:00:00", "1992-10-25 06:00:00", "1993-04-04 07:00:00", 
"1993-10-31 06:00:00", "1994-04-03 07:00:00", "1994-10-30 06:00:00", 
"1995-04-02 07:00:00", "1995-10-29 06:00:00", "1996-04-07 07:00:00", 
"1996-10-27 06:00:00", "1997-04-06 07:00:00", "1997-10-26 06:00:00", 
"1998-04-05 07:00:00", "1998-10-25 06:00:00", "1999-04-04 07:00:00", 
"1999-10-31 06:00:00", "2000-04-02 07:00:00", "2000-10-29 06:00:00", 
"2001-04-01 07:00:00", "2001-10-28 06:00:00", "2002-04-07 07:00:00", 
"2002-10-27 06:00:00", "2003-04-06 07:00:00", "2003-10-26 06:00:00", 
"2004-04-04 07:00:00", "2004-10-31 06:00:00", "2005-04-03 07:00:00", 
"2005-10-30 06:00:00", "2006-04-02 07:00:00", "2006-10-29 06:00:00", 
"2007-03-11 07:00:00", "2007-11-04 06:00:00", "2008-03-09 07:00:00", 
"2008-11-02 06:00:00", "2009-03-08 07:00:00", "2009-11-01 06:00:00", 
"2010-03-14 07:00:00", "2010-11-07 06:00:00", "2011-03-13 07:00:00", 
"2011-11-06 06:00:00", "2012-03-11 07:00:00", "2012-11-04 06:00:00", 
"2013-03-10 07:00:00", "2013-11-03 06:00:00", "2014-03-09 07:00:00", 
"2014-11-02 06:00:00", "2015-03-08 07:00:00", "2015-11-01 06:00:00", 
"2016-03-13 07:00:00", "2016-11-06 06:00:00", "2017-03-12 07:00:00", 
"2017-11-05 06:00:00", "2018-03-11 07:00:00", "2018-11-04 06:00:00", 
"2019-03-10 07:00:00", "2019-11-03 06:00:00", "2020-03-08 07:00:00", 
"2020-11-01 06:00:00", "2021-03-14 07:00:00", "2021-11-07 06:00:00", 
"2022-03-13 07:00:00", "2022-11-06 06:00:00", "2023-03-12 07:00:00", 
"2023-11-05 06:00:00", "2024-03-10 07:00:00", "2024-11-03 06:00:00", 
"2025-03-09 07:00:00", "2025-11-02 06:00:00", "2026-03-08 07:00:00", 
"2026-11-01 06:00:00", "2027-03-14 07:00:00", "2027-11-07 06:00:00", 
"2028-03-12 07:00:00", "2028-11-05 06:00:00", "2029-03-11 07:00:00", 
"2029-11-04 06:00:00", "2030-03-10 07:00:00", "2030-11-03 06:00:00", 
"2031-03-09 07:00:00", "2031-11-02 06:00:00", "2032-03-14 07:00:00", 
"2032-11-07 06:00:00", "2033-03-13 07:00:00", "2033-11-06 06:00:00", 
"2034-03-12 07:00:00", "2034-11-05 06:00:00", "2035-03-11 07:00:00", 
"2035-11-04 06:00:00", "2036-03-09 07:00:00", "2036-11-02 06:00:00", 
"2037-03-08 07:00:00", "2037-11-01 06:00:00"), offSet = c(-18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L), TimeZone = c("EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EPT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST"), numeric = c(-2147397248, 
-1633280400, -1615140000, -1601830800, -1583690400, -1570381200, 
-1551636000, -1536512400, -1523210400, -1504458000, -1491760800, 
-1473008400, -1459706400, -1441558800, -1428256800, -1410109200, 
-1396807200, -1378659600, -1365357600, -1347210000, -1333908000, 
-1315155600, -1301853600, -1283706000, -1270404000, -1252256400, 
-1238954400, -1220806800, -1207504800, -1189357200, -1176055200, 
-1157302800, -1144605600, -1125853200, -1112551200, -1094403600, 
-1081101600, -1062954000, -1049652000, -1031504400, -1018202400, 
-1000054800, -986752800, -968000400, -955303200, -936550800, 
-923248800, -905101200, -891799200, -769395600, -765396000, -747248400, 
-733946400, -715798800, -702496800, -684349200, -671047200, -652899600, 
-639597600, -620845200, -608148000, -589395600, -576093600, -557946000, 
-544644000, -526496400, -513194400, -495046800, -481744800, -463597200, 
-447271200, -431542800, -415821600, -400093200, -384372000, -368643600, 
-352922400, -337194000, -321472800, -305744400, -289418400, -273690000, 
-257968800, -242240400, -226519200, -210790800, -195069600, -179341200, 
-163620000, -147891600, -131565600, -116442000, -100116000, -84387600, 
-68666400, -52938000, -37216800, -21488400, -5767200, 9961200, 
25682400, 41410800, 57736800, 73465200, 89186400, 104914800, 
120636000, 126687600, 152085600, 162370800, 183535200, 199263600, 
215589600, 230713200, 247039200, 262767600, 278488800, 294217200, 
309938400, 325666800, 341388000, 357116400, 372837600, 388566000, 
404892000, 420015600, 436341600, 452070000, 467791200, 483519600, 
499240800, 514969200, 530690400, 544604400, 562140000, 576054000, 
594194400, 607503600, 625644000, 638953200, 657093600, 671007600, 
688543200, 702457200, 719992800, 733906800, 752047200, 765356400, 
783496800, 796806000, 814946400, 828860400, 846396000, 860310000, 
877845600, 891759600, 909295200, 923209200, 941349600, 954658800, 
972799200, 986108400, 1004248800, 1018162800, 1035698400, 1049612400, 
1067148000, 1081062000, 1099202400, 1112511600, 1130652000, 1143961200, 
1162101600, 1173596400, 1194156000, 1205046000, 1225605600, 1236495600, 
1257055200, 1268550000, 1289109600, 1299999600, 1320559200, 1331449200, 
1352008800, 1362898800, 1383458400, 1394348400, 1414908000, 1425798000, 
1446357600, 1457852400, 1478412000, 1489302000, 1509861600, 1520751600, 
1541311200, 1552201200, 1572760800, 1583650800, 1604210400, 1615705200, 
1636264800, 1647154800, 1667714400, 1678604400, 1699164000, 1710054000, 
1730613600, 1741503600, 1762063200, 1772953200, 1793512800, 1805007600, 
1825567200, 1836457200, 1857016800, 1867906800, 1888466400, 1899356400, 
1919916000, 1930806000, 1951365600, 1962860400, 1983420000, 1994310000, 
2014869600, 2025759600, 2046319200, 2057209200, 2077768800, 2088658800, 
2109218400, 2120108400, 2140668000)), .Names = c("New_York", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-235L), class = "data.frame")
}

"Nipigon" <- function () {
structure(list(Nipigon = c("1901-12-14 20:45:52", "1918-04-14 07:00:00", 
"1918-10-31 06:00:00", "1945-08-14 23:00:00", "1945-09-30 06:00:00", 
"1974-04-28 07:00:00", "1974-10-27 06:00:00", "1975-04-27 07:00:00", 
"1975-10-26 06:00:00", "1976-04-25 07:00:00", "1976-10-31 06:00:00", 
"1977-04-24 07:00:00", "1977-10-30 06:00:00", "1978-04-30 07:00:00", 
"1978-10-29 06:00:00", "1979-04-29 07:00:00", "1979-10-28 06:00:00", 
"1980-04-27 07:00:00", "1980-10-26 06:00:00", "1981-04-26 07:00:00", 
"1981-10-25 06:00:00", "1982-04-25 07:00:00", "1982-10-31 06:00:00", 
"1983-04-24 07:00:00", "1983-10-30 06:00:00", "1984-04-29 07:00:00", 
"1984-10-28 06:00:00", "1985-04-28 07:00:00", "1985-10-27 06:00:00", 
"1986-04-27 07:00:00", "1986-10-26 06:00:00", "1987-04-05 07:00:00", 
"1987-10-25 06:00:00", "1988-04-03 07:00:00", "1988-10-30 06:00:00", 
"1989-04-02 07:00:00", "1989-10-29 06:00:00", "1990-04-01 07:00:00", 
"1990-10-28 06:00:00", "1991-04-07 07:00:00", "1991-10-27 06:00:00", 
"1992-04-05 07:00:00", "1992-10-25 06:00:00", "1993-04-04 07:00:00", 
"1993-10-31 06:00:00", "1994-04-03 07:00:00", "1994-10-30 06:00:00", 
"1995-04-02 07:00:00", "1995-10-29 06:00:00", "1996-04-07 07:00:00", 
"1996-10-27 06:00:00", "1997-04-06 07:00:00", "1997-10-26 06:00:00", 
"1998-04-05 07:00:00", "1998-10-25 06:00:00", "1999-04-04 07:00:00", 
"1999-10-31 06:00:00", "2000-04-02 07:00:00", "2000-10-29 06:00:00", 
"2001-04-01 07:00:00", "2001-10-28 06:00:00", "2002-04-07 07:00:00", 
"2002-10-27 06:00:00", "2003-04-06 07:00:00", "2003-10-26 06:00:00", 
"2004-04-04 07:00:00", "2004-10-31 06:00:00", "2005-04-03 07:00:00", 
"2005-10-30 06:00:00", "2006-04-02 07:00:00", "2006-10-29 06:00:00", 
"2007-03-11 07:00:00", "2007-11-04 06:00:00", "2008-03-09 07:00:00", 
"2008-11-02 06:00:00", "2009-03-08 07:00:00", "2009-11-01 06:00:00", 
"2010-03-14 07:00:00", "2010-11-07 06:00:00", "2011-03-13 07:00:00", 
"2011-11-06 06:00:00", "2012-03-11 07:00:00", "2012-11-04 06:00:00", 
"2013-03-10 07:00:00", "2013-11-03 06:00:00", "2014-03-09 07:00:00", 
"2014-11-02 06:00:00", "2015-03-08 07:00:00", "2015-11-01 06:00:00", 
"2016-03-13 07:00:00", "2016-11-06 06:00:00", "2017-03-12 07:00:00", 
"2017-11-05 06:00:00", "2018-03-11 07:00:00", "2018-11-04 06:00:00", 
"2019-03-10 07:00:00", "2019-11-03 06:00:00", "2020-03-08 07:00:00", 
"2020-11-01 06:00:00", "2021-03-14 07:00:00", "2021-11-07 06:00:00", 
"2022-03-13 07:00:00", "2022-11-06 06:00:00", "2023-03-12 07:00:00", 
"2023-11-05 06:00:00", "2024-03-10 07:00:00", "2024-11-03 06:00:00", 
"2025-03-09 07:00:00", "2025-11-02 06:00:00", "2026-03-08 07:00:00", 
"2026-11-01 06:00:00", "2027-03-14 07:00:00", "2027-11-07 06:00:00", 
"2028-03-12 07:00:00", "2028-11-05 06:00:00", "2029-03-11 07:00:00", 
"2029-11-04 06:00:00", "2030-03-10 07:00:00", "2030-11-03 06:00:00", 
"2031-03-09 07:00:00", "2031-11-02 06:00:00", "2032-03-14 07:00:00", 
"2032-11-07 06:00:00", "2033-03-13 07:00:00", "2033-11-06 06:00:00", 
"2034-03-12 07:00:00", "2034-11-05 06:00:00", "2035-03-11 07:00:00", 
"2035-11-04 06:00:00", "2036-03-09 07:00:00", "2036-11-02 06:00:00", 
"2037-03-08 07:00:00", "2037-11-01 06:00:00"), offSet = c(-18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L), isdst = c(0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L), TimeZone = c("EST", "EDT", "EST", "EPT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST"), numeric = c(-2147397248, -1632070800, -1614794400, 
-769395600, -765396000, 136364400, 152085600, 167814000, 183535200, 
199263600, 215589600, 230713200, 247039200, 262767600, 278488800, 
294217200, 309938400, 325666800, 341388000, 357116400, 372837600, 
388566000, 404892000, 420015600, 436341600, 452070000, 467791200, 
483519600, 499240800, 514969200, 530690400, 544604400, 562140000, 
576054000, 594194400, 607503600, 625644000, 638953200, 657093600, 
671007600, 688543200, 702457200, 719992800, 733906800, 752047200, 
765356400, 783496800, 796806000, 814946400, 828860400, 846396000, 
860310000, 877845600, 891759600, 909295200, 923209200, 941349600, 
954658800, 972799200, 986108400, 1004248800, 1018162800, 1035698400, 
1049612400, 1067148000, 1081062000, 1099202400, 1112511600, 1130652000, 
1143961200, 1162101600, 1173596400, 1194156000, 1205046000, 1225605600, 
1236495600, 1257055200, 1268550000, 1289109600, 1299999600, 1320559200, 
1331449200, 1352008800, 1362898800, 1383458400, 1394348400, 1414908000, 
1425798000, 1446357600, 1457852400, 1478412000, 1489302000, 1509861600, 
1520751600, 1541311200, 1552201200, 1572760800, 1583650800, 1604210400, 
1615705200, 1636264800, 1647154800, 1667714400, 1678604400, 1699164000, 
1710054000, 1730613600, 1741503600, 1762063200, 1772953200, 1793512800, 
1805007600, 1825567200, 1836457200, 1857016800, 1867906800, 1888466400, 
1899356400, 1919916000, 1930806000, 1951365600, 1962860400, 1983420000, 
1994310000, 2014869600, 2025759600, 2046319200, 2057209200, 2077768800, 
2088658800, 2109218400, 2120108400, 2140668000)), .Names = c("Nipigon", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-133L), class = "data.frame")
}

"Nome" <- function () {
structure(list(Nome = c("1901-12-14 20:45:52", "1945-08-14 23:00:00", 
"1967-04-01 11:00:00", "1969-04-27 13:00:00", "1969-10-26 12:00:00", 
"1970-04-26 13:00:00", "1970-10-25 12:00:00", "1971-04-25 13:00:00", 
"1971-10-31 12:00:00", "1972-04-30 13:00:00", "1972-10-29 12:00:00", 
"1973-04-29 13:00:00", "1973-10-28 12:00:00", "1974-01-06 13:00:00", 
"1974-10-27 12:00:00", "1975-02-23 13:00:00", "1975-10-26 12:00:00", 
"1976-04-25 13:00:00", "1976-10-31 12:00:00", "1977-04-24 13:00:00", 
"1977-10-30 12:00:00", "1978-04-30 13:00:00", "1978-10-29 12:00:00", 
"1979-04-29 13:00:00", "1979-10-28 12:00:00", "1980-04-27 13:00:00", 
"1980-10-26 12:00:00", "1981-04-26 13:00:00", "1981-10-25 12:00:00", 
"1982-04-25 13:00:00", "1982-10-31 12:00:00", "1983-04-24 13:00:00", 
"1983-11-30 09:00:00", "1984-04-29 11:00:00", "1984-10-28 10:00:00", 
"1985-04-28 11:00:00", "1985-10-27 10:00:00", "1986-04-27 11:00:00", 
"1986-10-26 10:00:00", "1987-04-05 11:00:00", "1987-10-25 10:00:00", 
"1988-04-03 11:00:00", "1988-10-30 10:00:00", "1989-04-02 11:00:00", 
"1989-10-29 10:00:00", "1990-04-01 11:00:00", "1990-10-28 10:00:00", 
"1991-04-07 11:00:00", "1991-10-27 10:00:00", "1992-04-05 11:00:00", 
"1992-10-25 10:00:00", "1993-04-04 11:00:00", "1993-10-31 10:00:00", 
"1994-04-03 11:00:00", "1994-10-30 10:00:00", "1995-04-02 11:00:00", 
"1995-10-29 10:00:00", "1996-04-07 11:00:00", "1996-10-27 10:00:00", 
"1997-04-06 11:00:00", "1997-10-26 10:00:00", "1998-04-05 11:00:00", 
"1998-10-25 10:00:00", "1999-04-04 11:00:00", "1999-10-31 10:00:00", 
"2000-04-02 11:00:00", "2000-10-29 10:00:00", "2001-04-01 11:00:00", 
"2001-10-28 10:00:00", "2002-04-07 11:00:00", "2002-10-27 10:00:00", 
"2003-04-06 11:00:00", "2003-10-26 10:00:00", "2004-04-04 11:00:00", 
"2004-10-31 10:00:00", "2005-04-03 11:00:00", "2005-10-30 10:00:00", 
"2006-04-02 11:00:00", "2006-10-29 10:00:00", "2007-03-11 11:00:00", 
"2007-11-04 10:00:00", "2008-03-09 11:00:00", "2008-11-02 10:00:00", 
"2009-03-08 11:00:00", "2009-11-01 10:00:00", "2010-03-14 11:00:00", 
"2010-11-07 10:00:00", "2011-03-13 11:00:00", "2011-11-06 10:00:00", 
"2012-03-11 11:00:00", "2012-11-04 10:00:00", "2013-03-10 11:00:00", 
"2013-11-03 10:00:00", "2014-03-09 11:00:00", "2014-11-02 10:00:00", 
"2015-03-08 11:00:00", "2015-11-01 10:00:00", "2016-03-13 11:00:00", 
"2016-11-06 10:00:00", "2017-03-12 11:00:00", "2017-11-05 10:00:00", 
"2018-03-11 11:00:00", "2018-11-04 10:00:00", "2019-03-10 11:00:00", 
"2019-11-03 10:00:00", "2020-03-08 11:00:00", "2020-11-01 10:00:00", 
"2021-03-14 11:00:00", "2021-11-07 10:00:00", "2022-03-13 11:00:00", 
"2022-11-06 10:00:00", "2023-03-12 11:00:00", "2023-11-05 10:00:00", 
"2024-03-10 11:00:00", "2024-11-03 10:00:00", "2025-03-09 11:00:00", 
"2025-11-02 10:00:00", "2026-03-08 11:00:00", "2026-11-01 10:00:00", 
"2027-03-14 11:00:00", "2027-11-07 10:00:00", "2028-03-12 11:00:00", 
"2028-11-05 10:00:00", "2029-03-11 11:00:00", "2029-11-04 10:00:00", 
"2030-03-10 11:00:00", "2030-11-03 10:00:00", "2031-03-09 11:00:00", 
"2031-11-02 10:00:00", "2032-03-14 11:00:00", "2032-11-07 10:00:00", 
"2033-03-13 11:00:00", "2033-11-06 10:00:00", "2034-03-12 11:00:00", 
"2034-11-05 10:00:00", "2035-03-11 11:00:00", "2035-11-04 10:00:00", 
"2036-03-09 11:00:00", "2036-11-02 10:00:00", "2037-03-08 11:00:00", 
"2037-11-01 10:00:00"), offSet = c(-39600L, -36000L, -39600L, 
-36000L, -39600L, -36000L, -39600L, -36000L, -39600L, -36000L, 
-39600L, -36000L, -39600L, -36000L, -39600L, -36000L, -39600L, 
-36000L, -39600L, -36000L, -39600L, -36000L, -39600L, -36000L, 
-39600L, -36000L, -39600L, -36000L, -39600L, -36000L, -39600L, 
-36000L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L), isdst = c(0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("NST", 
"NPT", "BST", "BDT", "BST", "BDT", "BST", "BDT", "BST", "BDT", 
"BST", "BDT", "BST", "BDT", "BST", "BDT", "BST", "BDT", "BST", 
"BDT", "BST", "BDT", "BST", "BDT", "BST", "BDT", "BST", "BDT", 
"BST", "BDT", "BST", "BDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST"
), numeric = c(-2147397248, -769395600, -86878800, -21466800, 
-5745600, 9982800, 25704000, 41432400, 57758400, 73486800, 89208000, 
104936400, 120657600, 126709200, 152107200, 162392400, 183556800, 
199285200, 215611200, 230734800, 247060800, 262789200, 278510400, 
294238800, 309960000, 325688400, 341409600, 357138000, 372859200, 
388587600, 404913600, 420037200, 439030800, 452084400, 467805600, 
483534000, 499255200, 514983600, 530704800, 544618800, 562154400, 
576068400, 594208800, 607518000, 625658400, 638967600, 657108000, 
671022000, 688557600, 702471600, 720007200, 733921200, 752061600, 
765370800, 783511200, 796820400, 814960800, 828874800, 846410400, 
860324400, 877860000, 891774000, 909309600, 923223600, 941364000, 
954673200, 972813600, 986122800, 1004263200, 1018177200, 1035712800, 
1049626800, 1067162400, 1081076400, 1099216800, 1112526000, 1130666400, 
1143975600, 1162116000, 1173610800, 1194170400, 1205060400, 1225620000, 
1236510000, 1257069600, 1268564400, 1289124000, 1300014000, 1320573600, 
1331463600, 1352023200, 1362913200, 1383472800, 1394362800, 1414922400, 
1425812400, 1446372000, 1457866800, 1478426400, 1489316400, 1509876000, 
1520766000, 1541325600, 1552215600, 1572775200, 1583665200, 1604224800, 
1615719600, 1636279200, 1647169200, 1667728800, 1678618800, 1699178400, 
1710068400, 1730628000, 1741518000, 1762077600, 1772967600, 1793527200, 
1805022000, 1825581600, 1836471600, 1857031200, 1867921200, 1888480800, 
1899370800, 1919930400, 1930820400, 1951380000, 1962874800, 1983434400, 
1994324400, 2014884000, 2025774000, 2046333600, 2057223600, 2077783200, 
2088673200, 2109232800, 2120122800, 2140682400)), .Names = c("Nome", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-141L), class = "data.frame")
}

"Noronha" <- function () {
structure(list(Noronha = c("1901-12-14 20:45:52", "1914-01-01 02:09:40", 
"1931-10-03 13:00:00", "1932-04-01 01:00:00", "1932-10-03 02:00:00", 
"1933-04-01 01:00:00", "1949-12-01 02:00:00", "1950-04-16 02:00:00", 
"1950-12-01 02:00:00", "1951-04-01 01:00:00", "1951-12-01 02:00:00", 
"1952-04-01 01:00:00", "1952-12-01 02:00:00", "1953-03-01 01:00:00", 
"1963-12-09 02:00:00", "1964-03-01 01:00:00", "1965-01-31 02:00:00", 
"1965-03-31 01:00:00", "1965-12-01 02:00:00", "1966-03-01 01:00:00", 
"1966-11-01 02:00:00", "1967-03-01 01:00:00", "1967-11-01 02:00:00", 
"1968-03-01 01:00:00", "1985-11-02 02:00:00", "1986-03-15 01:00:00", 
"1986-10-25 02:00:00", "1987-02-14 01:00:00", "1987-10-25 02:00:00", 
"1988-02-07 01:00:00", "1988-10-16 02:00:00", "1989-01-29 01:00:00", 
"1989-10-15 02:00:00", "1990-02-11 01:00:00", "1999-10-03 02:00:00", 
"2000-02-27 01:00:00", "2000-10-08 02:00:00", "2000-10-15 01:00:00", 
"2001-10-14 02:00:00", "2002-02-17 01:00:00"), offSet = c(-7780L, 
-7200L, -3600L, -7200L, -3600L, -7200L, -3600L, -7200L, -3600L, 
-7200L, -3600L, -7200L, -3600L, -7200L, -3600L, -7200L, -3600L, 
-7200L, -3600L, -7200L, -3600L, -7200L, -3600L, -7200L, -3600L, 
-7200L, -3600L, -7200L, -3600L, -7200L, -3600L, -7200L, -3600L, 
-7200L, -3600L, -7200L, -3600L, -7200L, -3600L, -7200L), isdst = c(0L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "FNT", "FNST", 
"FNT", "FNST", "FNT", "FNST", "FNT", "FNST", "FNT", "FNST", "FNT", 
"FNST", "FNT", "FNST", "FNT", "FNST", "FNT", "FNST", "FNT", "FNST", 
"FNT", "FNST", "FNT", "FNST", "FNT", "FNST", "FNT", "FNST", "FNT", 
"FNST", "FNT", "FNST", "FNT", "FNST", "FNT", "FNST", "FNT", "FNST", 
"FNT"), numeric = c(-2147397248, -1767217820, -1206961200, -1191366000, 
-1175378400, -1159830000, -633823200, -622072800, -602287200, 
-591836400, -570751200, -560214000, -539128800, -531356400, -191368800, 
-184201200, -155167200, -150073200, -128901600, -121129200, -99957600, 
-89593200, -68421600, -57970800, 499744800, 511232400, 530589600, 
540262800, 562125600, 571194000, 592970400, 602038800, 624420000, 
634698000, 938916000, 951613200, 970970400, 971571600, 1003024800, 
1013907600)), .Names = c("Noronha", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -40L), class = "data.frame")
}

"Center" <- function () {
structure(list(Center = c("1901-12-14 20:45:52", "1918-03-31 09:00:00", 
"1918-10-27 08:00:00", "1919-03-30 09:00:00", "1919-10-26 08:00:00", 
"1945-08-14 23:00:00", "1945-09-30 08:00:00", "1967-04-30 09:00:00", 
"1967-10-29 08:00:00", "1968-04-28 09:00:00", "1968-10-27 08:00:00", 
"1969-04-27 09:00:00", "1969-10-26 08:00:00", "1970-04-26 09:00:00", 
"1970-10-25 08:00:00", "1971-04-25 09:00:00", "1971-10-31 08:00:00", 
"1972-04-30 09:00:00", "1972-10-29 08:00:00", "1973-04-29 09:00:00", 
"1973-10-28 08:00:00", "1974-01-06 09:00:00", "1974-10-27 08:00:00", 
"1975-02-23 09:00:00", "1975-10-26 08:00:00", "1976-04-25 09:00:00", 
"1976-10-31 08:00:00", "1977-04-24 09:00:00", "1977-10-30 08:00:00", 
"1978-04-30 09:00:00", "1978-10-29 08:00:00", "1979-04-29 09:00:00", 
"1979-10-28 08:00:00", "1980-04-27 09:00:00", "1980-10-26 08:00:00", 
"1981-04-26 09:00:00", "1981-10-25 08:00:00", "1982-04-25 09:00:00", 
"1982-10-31 08:00:00", "1983-04-24 09:00:00", "1983-10-30 08:00:00", 
"1984-04-29 09:00:00", "1984-10-28 08:00:00", "1985-04-28 09:00:00", 
"1985-10-27 08:00:00", "1986-04-27 09:00:00", "1986-10-26 08:00:00", 
"1987-04-05 09:00:00", "1987-10-25 08:00:00", "1988-04-03 09:00:00", 
"1988-10-30 08:00:00", "1989-04-02 09:00:00", "1989-10-29 08:00:00", 
"1990-04-01 09:00:00", "1990-10-28 08:00:00", "1991-04-07 09:00:00", 
"1991-10-27 08:00:00", "1992-10-25 08:00:00", "1993-04-04 08:00:00", 
"1993-10-31 07:00:00", "1994-04-03 08:00:00", "1994-10-30 07:00:00", 
"1995-04-02 08:00:00", "1995-10-29 07:00:00", "1996-04-07 08:00:00", 
"1996-10-27 07:00:00", "1997-04-06 08:00:00", "1997-10-26 07:00:00", 
"1998-04-05 08:00:00", "1998-10-25 07:00:00", "1999-04-04 08:00:00", 
"1999-10-31 07:00:00", "2000-04-02 08:00:00", "2000-10-29 07:00:00", 
"2001-04-01 08:00:00", "2001-10-28 07:00:00", "2002-04-07 08:00:00", 
"2002-10-27 07:00:00", "2003-04-06 08:00:00", "2003-10-26 07:00:00", 
"2004-04-04 08:00:00", "2004-10-31 07:00:00", "2005-04-03 08:00:00", 
"2005-10-30 07:00:00", "2006-04-02 08:00:00", "2006-10-29 07:00:00", 
"2007-03-11 08:00:00", "2007-11-04 07:00:00", "2008-03-09 08:00:00", 
"2008-11-02 07:00:00", "2009-03-08 08:00:00", "2009-11-01 07:00:00", 
"2010-03-14 08:00:00", "2010-11-07 07:00:00", "2011-03-13 08:00:00", 
"2011-11-06 07:00:00", "2012-03-11 08:00:00", "2012-11-04 07:00:00", 
"2013-03-10 08:00:00", "2013-11-03 07:00:00", "2014-03-09 08:00:00", 
"2014-11-02 07:00:00", "2015-03-08 08:00:00", "2015-11-01 07:00:00", 
"2016-03-13 08:00:00", "2016-11-06 07:00:00", "2017-03-12 08:00:00", 
"2017-11-05 07:00:00", "2018-03-11 08:00:00", "2018-11-04 07:00:00", 
"2019-03-10 08:00:00", "2019-11-03 07:00:00", "2020-03-08 08:00:00", 
"2020-11-01 07:00:00", "2021-03-14 08:00:00", "2021-11-07 07:00:00", 
"2022-03-13 08:00:00", "2022-11-06 07:00:00", "2023-03-12 08:00:00", 
"2023-11-05 07:00:00", "2024-03-10 08:00:00", "2024-11-03 07:00:00", 
"2025-03-09 08:00:00", "2025-11-02 07:00:00", "2026-03-08 08:00:00", 
"2026-11-01 07:00:00", "2027-03-14 08:00:00", "2027-11-07 07:00:00", 
"2028-03-12 08:00:00", "2028-11-05 07:00:00", "2029-03-11 08:00:00", 
"2029-11-04 07:00:00", "2030-03-10 08:00:00", "2030-11-03 07:00:00", 
"2031-03-09 08:00:00", "2031-11-02 07:00:00", "2032-03-14 08:00:00", 
"2032-11-07 07:00:00", "2033-03-13 08:00:00", "2033-11-06 07:00:00", 
"2034-03-12 08:00:00", "2034-11-05 07:00:00", "2035-03-11 08:00:00", 
"2035-11-04 07:00:00", "2036-03-09 08:00:00", "2036-11-02 07:00:00", 
"2037-03-08 08:00:00", "2037-11-01 07:00:00"), offSet = c(-25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L
), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("MST", "MDT", "MST", 
"MDT", "MST", "MPT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST"), numeric = c(-2147397248, -1633273200, -1615132800, -1601823600, 
-1583683200, -769395600, -765388800, -84380400, -68659200, -52930800, 
-37209600, -21481200, -5760000, 9968400, 25689600, 41418000, 
57744000, 73472400, 89193600, 104922000, 120643200, 126694800, 
152092800, 162378000, 183542400, 199270800, 215596800, 230720400, 
247046400, 262774800, 278496000, 294224400, 309945600, 325674000, 
341395200, 357123600, 372844800, 388573200, 404899200, 420022800, 
436348800, 452077200, 467798400, 483526800, 499248000, 514976400, 
530697600, 544611600, 562147200, 576061200, 594201600, 607510800, 
625651200, 638960400, 657100800, 671014800, 688550400, 7.2e+08, 
733910400, 752050800, 765360000, 783500400, 796809600, 814950000, 
828864000, 846399600, 860313600, 877849200, 891763200, 909298800, 
923212800, 941353200, 954662400, 972802800, 986112000, 1004252400, 
1018166400, 1035702000, 1049616000, 1067151600, 1081065600, 1099206000, 
1112515200, 1130655600, 1143964800, 1162105200, 1173600000, 1194159600, 
1205049600, 1225609200, 1236499200, 1257058800, 1268553600, 1289113200, 
1300003200, 1320562800, 1331452800, 1352012400, 1362902400, 1383462000, 
1394352000, 1414911600, 1425801600, 1446361200, 1457856000, 1478415600, 
1489305600, 1509865200, 1520755200, 1541314800, 1552204800, 1572764400, 
1583654400, 1604214000, 1615708800, 1636268400, 1647158400, 1667718000, 
1678608000, 1699167600, 1710057600, 1730617200, 1741507200, 1762066800, 
1772956800, 1793516400, 1805011200, 1825570800, 1836460800, 1857020400, 
1867910400, 1888470000, 1899360000, 1919919600, 1930809600, 1951369200, 
1962864000, 1983423600, 1994313600, 2014873200, 2025763200, 2046322800, 
2057212800, 2077772400, 2088662400, 2109222000, 2120112000, 2140671600
)), .Names = c("Center", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -148L), class = "data.frame")
}

"New_Salem" <- function () {
structure(list(New_Salem = c("1901-12-14 20:45:52", "1918-03-31 09:00:00", 
"1918-10-27 08:00:00", "1919-03-30 09:00:00", "1919-10-26 08:00:00", 
"1945-08-14 23:00:00", "1945-09-30 08:00:00", "1967-04-30 09:00:00", 
"1967-10-29 08:00:00", "1968-04-28 09:00:00", "1968-10-27 08:00:00", 
"1969-04-27 09:00:00", "1969-10-26 08:00:00", "1970-04-26 09:00:00", 
"1970-10-25 08:00:00", "1971-04-25 09:00:00", "1971-10-31 08:00:00", 
"1972-04-30 09:00:00", "1972-10-29 08:00:00", "1973-04-29 09:00:00", 
"1973-10-28 08:00:00", "1974-01-06 09:00:00", "1974-10-27 08:00:00", 
"1975-02-23 09:00:00", "1975-10-26 08:00:00", "1976-04-25 09:00:00", 
"1976-10-31 08:00:00", "1977-04-24 09:00:00", "1977-10-30 08:00:00", 
"1978-04-30 09:00:00", "1978-10-29 08:00:00", "1979-04-29 09:00:00", 
"1979-10-28 08:00:00", "1980-04-27 09:00:00", "1980-10-26 08:00:00", 
"1981-04-26 09:00:00", "1981-10-25 08:00:00", "1982-04-25 09:00:00", 
"1982-10-31 08:00:00", "1983-04-24 09:00:00", "1983-10-30 08:00:00", 
"1984-04-29 09:00:00", "1984-10-28 08:00:00", "1985-04-28 09:00:00", 
"1985-10-27 08:00:00", "1986-04-27 09:00:00", "1986-10-26 08:00:00", 
"1987-04-05 09:00:00", "1987-10-25 08:00:00", "1988-04-03 09:00:00", 
"1988-10-30 08:00:00", "1989-04-02 09:00:00", "1989-10-29 08:00:00", 
"1990-04-01 09:00:00", "1990-10-28 08:00:00", "1991-04-07 09:00:00", 
"1991-10-27 08:00:00", "1992-04-05 09:00:00", "1992-10-25 08:00:00", 
"1993-04-04 09:00:00", "1993-10-31 08:00:00", "1994-04-03 09:00:00", 
"1994-10-30 08:00:00", "1995-04-02 09:00:00", "1995-10-29 08:00:00", 
"1996-04-07 09:00:00", "1996-10-27 08:00:00", "1997-04-06 09:00:00", 
"1997-10-26 08:00:00", "1998-04-05 09:00:00", "1998-10-25 08:00:00", 
"1999-04-04 09:00:00", "1999-10-31 08:00:00", "2000-04-02 09:00:00", 
"2000-10-29 08:00:00", "2001-04-01 09:00:00", "2001-10-28 08:00:00", 
"2002-04-07 09:00:00", "2002-10-27 08:00:00", "2003-10-26 08:00:00", 
"2004-04-04 08:00:00", "2004-10-31 07:00:00", "2005-04-03 08:00:00", 
"2005-10-30 07:00:00", "2006-04-02 08:00:00", "2006-10-29 07:00:00", 
"2007-03-11 08:00:00", "2007-11-04 07:00:00", "2008-03-09 08:00:00", 
"2008-11-02 07:00:00", "2009-03-08 08:00:00", "2009-11-01 07:00:00", 
"2010-03-14 08:00:00", "2010-11-07 07:00:00", "2011-03-13 08:00:00", 
"2011-11-06 07:00:00", "2012-03-11 08:00:00", "2012-11-04 07:00:00", 
"2013-03-10 08:00:00", "2013-11-03 07:00:00", "2014-03-09 08:00:00", 
"2014-11-02 07:00:00", "2015-03-08 08:00:00", "2015-11-01 07:00:00", 
"2016-03-13 08:00:00", "2016-11-06 07:00:00", "2017-03-12 08:00:00", 
"2017-11-05 07:00:00", "2018-03-11 08:00:00", "2018-11-04 07:00:00", 
"2019-03-10 08:00:00", "2019-11-03 07:00:00", "2020-03-08 08:00:00", 
"2020-11-01 07:00:00", "2021-03-14 08:00:00", "2021-11-07 07:00:00", 
"2022-03-13 08:00:00", "2022-11-06 07:00:00", "2023-03-12 08:00:00", 
"2023-11-05 07:00:00", "2024-03-10 08:00:00", "2024-11-03 07:00:00", 
"2025-03-09 08:00:00", "2025-11-02 07:00:00", "2026-03-08 08:00:00", 
"2026-11-01 07:00:00", "2027-03-14 08:00:00", "2027-11-07 07:00:00", 
"2028-03-12 08:00:00", "2028-11-05 07:00:00", "2029-03-11 08:00:00", 
"2029-11-04 07:00:00", "2030-03-10 08:00:00", "2030-11-03 07:00:00", 
"2031-03-09 08:00:00", "2031-11-02 07:00:00", "2032-03-14 08:00:00", 
"2032-11-07 07:00:00", "2033-03-13 08:00:00", "2033-11-06 07:00:00", 
"2034-03-12 08:00:00", "2034-11-05 07:00:00", "2035-03-11 08:00:00", 
"2035-11-04 07:00:00", "2036-03-09 08:00:00", "2036-11-02 07:00:00", 
"2037-03-08 08:00:00", "2037-11-01 07:00:00"), offSet = c(-25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L
), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("MST", "MDT", "MST", 
"MDT", "MST", "MPT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST"), numeric = c(-2147397248, -1633273200, -1615132800, -1601823600, 
-1583683200, -769395600, -765388800, -84380400, -68659200, -52930800, 
-37209600, -21481200, -5760000, 9968400, 25689600, 41418000, 
57744000, 73472400, 89193600, 104922000, 120643200, 126694800, 
152092800, 162378000, 183542400, 199270800, 215596800, 230720400, 
247046400, 262774800, 278496000, 294224400, 309945600, 325674000, 
341395200, 357123600, 372844800, 388573200, 404899200, 420022800, 
436348800, 452077200, 467798400, 483526800, 499248000, 514976400, 
530697600, 544611600, 562147200, 576061200, 594201600, 607510800, 
625651200, 638960400, 657100800, 671014800, 688550400, 702464400, 
7.2e+08, 733914000, 752054400, 765363600, 783504000, 796813200, 
814953600, 828867600, 846403200, 860317200, 877852800, 891766800, 
909302400, 923216400, 941356800, 954666000, 972806400, 986115600, 
1004256000, 1018170000, 1035705600, 1067155200, 1081065600, 1099206000, 
1112515200, 1130655600, 1143964800, 1162105200, 1173600000, 1194159600, 
1205049600, 1225609200, 1236499200, 1257058800, 1268553600, 1289113200, 
1300003200, 1320562800, 1331452800, 1352012400, 1362902400, 1383462000, 
1394352000, 1414911600, 1425801600, 1446361200, 1457856000, 1478415600, 
1489305600, 1509865200, 1520755200, 1541314800, 1552204800, 1572764400, 
1583654400, 1604214000, 1615708800, 1636268400, 1647158400, 1667718000, 
1678608000, 1699167600, 1710057600, 1730617200, 1741507200, 1762066800, 
1772956800, 1793516400, 1805011200, 1825570800, 1836460800, 1857020400, 
1867910400, 1888470000, 1899360000, 1919919600, 1930809600, 1951369200, 
1962864000, 1983423600, 1994313600, 2014873200, 2025763200, 2046322800, 
2057212800, 2077772400, 2088662400, 2109222000, 2120112000, 2140671600
)), .Names = c("New_Salem", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -148L), class = "data.frame")
}

"Panama" <- function () {
structure(list(Panama = c("1901-12-14 20:45:52", "1908-04-22 05:19:36"
), offSet = c(-19176L, -18000L), isdst = c(0L, 0L), TimeZone = c("CMT", 
"EST"), numeric = c(-2147397248, -1946918424)), .Names = c("Panama", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Pangnirtung" <- function () {
structure(list(Pangnirtung = c("1901-12-14 20:45:52", "1921-01-01 00:00:00", 
"1945-08-14 23:00:00", "1945-09-30 05:00:00", "1965-04-25 04:00:00", 
"1965-10-31 04:00:00", "1980-04-27 06:00:00", "1980-10-26 05:00:00", 
"1981-04-26 06:00:00", "1981-10-25 05:00:00", "1982-04-25 06:00:00", 
"1982-10-31 05:00:00", "1983-04-24 06:00:00", "1983-10-30 05:00:00", 
"1984-04-29 06:00:00", "1984-10-28 05:00:00", "1985-04-28 06:00:00", 
"1985-10-27 05:00:00", "1986-04-27 06:00:00", "1986-10-26 05:00:00", 
"1987-04-05 06:00:00", "1987-10-25 05:00:00", "1988-04-03 06:00:00", 
"1988-10-30 05:00:00", "1989-04-02 06:00:00", "1989-10-29 05:00:00", 
"1990-04-01 06:00:00", "1990-10-28 05:00:00", "1991-04-07 06:00:00", 
"1991-10-27 05:00:00", "1992-04-05 06:00:00", "1992-10-25 05:00:00", 
"1993-04-04 06:00:00", "1993-10-31 05:00:00", "1994-04-03 06:00:00", 
"1995-04-02 06:00:00", "1995-10-29 06:00:00", "1996-04-07 07:00:00", 
"1996-10-27 06:00:00", "1997-04-06 07:00:00", "1997-10-26 06:00:00", 
"1998-04-05 07:00:00", "1998-10-25 06:00:00", "1999-04-04 07:00:00", 
"1999-10-31 06:00:00", "2000-10-29 07:00:00", "2001-04-01 07:00:00", 
"2001-10-28 06:00:00", "2002-04-07 07:00:00", "2002-10-27 06:00:00", 
"2003-04-06 07:00:00", "2003-10-26 06:00:00", "2004-04-04 07:00:00", 
"2004-10-31 06:00:00", "2005-04-03 07:00:00", "2005-10-30 06:00:00", 
"2006-04-02 07:00:00", "2006-10-29 06:00:00", "2007-03-11 07:00:00", 
"2007-11-04 06:00:00", "2008-03-09 07:00:00", "2008-11-02 06:00:00", 
"2009-03-08 07:00:00", "2009-11-01 06:00:00", "2010-03-14 07:00:00", 
"2010-11-07 06:00:00", "2011-03-13 07:00:00", "2011-11-06 06:00:00", 
"2012-03-11 07:00:00", "2012-11-04 06:00:00", "2013-03-10 07:00:00", 
"2013-11-03 06:00:00", "2014-03-09 07:00:00", "2014-11-02 06:00:00", 
"2015-03-08 07:00:00", "2015-11-01 06:00:00", "2016-03-13 07:00:00", 
"2016-11-06 06:00:00", "2017-03-12 07:00:00", "2017-11-05 06:00:00", 
"2018-03-11 07:00:00", "2018-11-04 06:00:00", "2019-03-10 07:00:00", 
"2019-11-03 06:00:00", "2020-03-08 07:00:00", "2020-11-01 06:00:00", 
"2021-03-14 07:00:00", "2021-11-07 06:00:00", "2022-03-13 07:00:00", 
"2022-11-06 06:00:00", "2023-03-12 07:00:00", "2023-11-05 06:00:00", 
"2024-03-10 07:00:00", "2024-11-03 06:00:00", "2025-03-09 07:00:00", 
"2025-11-02 06:00:00", "2026-03-08 07:00:00", "2026-11-01 06:00:00", 
"2027-03-14 07:00:00", "2027-11-07 06:00:00", "2028-03-12 07:00:00", 
"2028-11-05 06:00:00", "2029-03-11 07:00:00", "2029-11-04 06:00:00", 
"2030-03-10 07:00:00", "2030-11-03 06:00:00", "2031-03-09 07:00:00", 
"2031-11-02 06:00:00", "2032-03-14 07:00:00", "2032-11-07 06:00:00", 
"2033-03-13 07:00:00", "2033-11-06 06:00:00", "2034-03-12 07:00:00", 
"2034-11-05 06:00:00", "2035-03-11 07:00:00", "2035-11-04 06:00:00", 
"2036-03-09 07:00:00", "2036-11-02 06:00:00", "2037-03-08 07:00:00", 
"2037-11-01 06:00:00"), offSet = c(0L, -14400L, -10800L, -14400L, 
-7200L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -21600L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L), isdst = c(0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L), TimeZone = c("zzz", "AST", "APT", "AST", "ADDT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "CST", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST"), numeric = c(-2147397248, 
-1546300800, -769395600, -765399600, -147902400, -131572800, 
325663200, 341384400, 357112800, 372834000, 388562400, 404888400, 
420012000, 436338000, 452066400, 467787600, 483516000, 499237200, 
514965600, 530686800, 544600800, 562136400, 576050400, 594190800, 
607500000, 625640400, 638949600, 657090000, 671004000, 688539600, 
702453600, 719989200, 733903200, 752043600, 765352800, 796802400, 
814946400, 828860400, 846396000, 860310000, 877845600, 891759600, 
909295200, 923209200, 941349600, 972802800, 986108400, 1004248800, 
1018162800, 1035698400, 1049612400, 1067148000, 1081062000, 1099202400, 
1112511600, 1130652000, 1143961200, 1162101600, 1173596400, 1194156000, 
1205046000, 1225605600, 1236495600, 1257055200, 1268550000, 1289109600, 
1299999600, 1320559200, 1331449200, 1352008800, 1362898800, 1383458400, 
1394348400, 1414908000, 1425798000, 1446357600, 1457852400, 1478412000, 
1489302000, 1509861600, 1520751600, 1541311200, 1552201200, 1572760800, 
1583650800, 1604210400, 1615705200, 1636264800, 1647154800, 1667714400, 
1678604400, 1699164000, 1710054000, 1730613600, 1741503600, 1762063200, 
1772953200, 1793512800, 1805007600, 1825567200, 1836457200, 1857016800, 
1867906800, 1888466400, 1899356400, 1919916000, 1930806000, 1951365600, 
1962860400, 1983420000, 1994310000, 2014869600, 2025759600, 2046319200, 
2057209200, 2077768800, 2088658800, 2109218400, 2120108400, 2140668000
)), .Names = c("Pangnirtung", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -120L), class = "data.frame")
}

"Paramaribo" <- function () {
structure(list(Paramaribo = c("1901-12-14 20:45:52", "1911-01-01 03:40:40", 
"1935-01-01 03:40:52", "1975-11-20 03:30:00", "1984-10-01 03:30:00"
), offSet = c(-13240L, -13252L, -13236L, -12600L, -10800L), isdst = c(0L, 
0L, 0L, 0L, 0L), TimeZone = c("LMT", "PMT", "PMT", "SRT", "SRT"
), numeric = c(-2147397248, -1861906760, -1104524348, 185686200, 
465449400)), .Names = c("Paramaribo", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -5L), class = "data.frame")
}

"Phoenix" <- function () {
structure(list(Phoenix = c("1901-12-14 20:45:52", "1918-03-31 09:00:00", 
"1918-10-27 08:00:00", "1919-03-30 09:00:00", "1919-10-26 08:00:00", 
"1942-02-09 09:00:00", "1944-01-01 06:01:00", "1944-04-01 07:01:00", 
"1944-10-01 06:01:00", "1967-04-30 09:00:00", "1967-10-29 08:00:00"
), offSet = c(-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L), isdst = c(0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("MST", "MDT", 
"MST", "MDT", "MST", "MWT", "MST", "MWT", "MST", "MDT", "MST"
), numeric = c(-2147397248, -1633273200, -1615132800, -1601823600, 
-1583683200, -880210800, -820519140, -812653140, -796845540, 
-84380400, -68659200)), .Names = c("Phoenix", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -11L), class = "data.frame")
}

"Port-au-Prince" <- function () {
structure(list(`Port-au-Prince` = c("1901-12-14 20:45:52", "1917-01-24 16:49:00", 
"1983-05-08 05:00:00", "1983-10-30 04:00:00", "1984-04-29 05:00:00", 
"1984-10-28 04:00:00", "1985-04-28 05:00:00", "1985-10-27 04:00:00", 
"1986-04-27 05:00:00", "1986-10-26 04:00:00", "1987-04-26 05:00:00", 
"1987-10-25 04:00:00", "1988-04-03 06:00:00", "1988-10-30 06:00:00", 
"1989-04-02 06:00:00", "1989-10-29 06:00:00", "1990-04-01 06:00:00", 
"1990-10-28 06:00:00", "1991-04-07 06:00:00", "1991-10-27 06:00:00", 
"1992-04-05 06:00:00", "1992-10-25 06:00:00", "1993-04-04 06:00:00", 
"1993-10-31 06:00:00", "1994-04-03 06:00:00", "1994-10-30 06:00:00", 
"1995-04-02 06:00:00", "1995-10-29 06:00:00", "1996-04-07 06:00:00", 
"1996-10-27 06:00:00", "1997-04-06 06:00:00", "1997-10-26 06:00:00", 
"2005-04-03 05:00:00", "2005-10-30 04:00:00", "2006-04-02 05:00:00", 
"2006-10-29 04:00:00"), offSet = c(-17340L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L), isdst = c(0L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L), TimeZone = c("PPMT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST"), numeric = c(-2147397248, -1670483460, 421218000, 
436334400, 452062800, 467784000, 483512400, 499233600, 514962000, 
530683200, 546411600, 562132800, 576050400, 594194400, 607500000, 
625644000, 638949600, 657093600, 671004000, 688543200, 702453600, 
719992800, 733903200, 752047200, 765352800, 783496800, 796802400, 
814946400, 828856800, 846396000, 860306400, 877845600, 1112504400, 
1130644800, 1143954000, 1162094400)), .Names = c("Port-au-Prince", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-36L), class = "data.frame")
}

"Port_of_Spain" <- function () {
structure(list(Port_of_Spain = c("1901-12-14 20:45:52", "1912-03-02 04:06:04"
), offSet = c(-14764L, -14400L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"AST"), numeric = c(-2147397248, -1825098836)), .Names = c("Port_of_Spain", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Porto_Velho" <- function () {
structure(list(Porto_Velho = c("1901-12-14 20:45:52", "1914-01-01 04:15:36", 
"1931-10-03 15:00:00", "1932-04-01 03:00:00", "1932-10-03 04:00:00", 
"1933-04-01 03:00:00", "1949-12-01 04:00:00", "1950-04-16 04:00:00", 
"1950-12-01 04:00:00", "1951-04-01 03:00:00", "1951-12-01 04:00:00", 
"1952-04-01 03:00:00", "1952-12-01 04:00:00", "1953-03-01 03:00:00", 
"1963-12-09 04:00:00", "1964-03-01 03:00:00", "1965-01-31 04:00:00", 
"1965-03-31 03:00:00", "1965-12-01 04:00:00", "1966-03-01 03:00:00", 
"1966-11-01 04:00:00", "1967-03-01 03:00:00", "1967-11-01 04:00:00", 
"1968-03-01 03:00:00", "1985-11-02 04:00:00", "1986-03-15 03:00:00", 
"1986-10-25 04:00:00", "1987-02-14 03:00:00", "1987-10-25 04:00:00", 
"1988-02-07 03:00:00"), offSet = c(-15336L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L), isdst = c(0L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT"), numeric = c(-2147397248, -1767210264, -1206954000, 
-1191358800, -1175371200, -1159822800, -633816000, -622065600, 
-602280000, -591829200, -570744000, -560206800, -539121600, -531349200, 
-191361600, -184194000, -155160000, -150066000, -128894400, -121122000, 
-99950400, -89586000, -68414400, -57963600, 499752000, 511239600, 
530596800, 540270000, 562132800, 571201200)), .Names = c("Porto_Velho", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-30L), class = "data.frame")
}

"Puerto_Rico" <- function () {
structure(list(Puerto_Rico = c("1901-12-14 20:45:52", "1945-08-14 23:00:00", 
"1945-09-30 05:00:00"), offSet = c(-14400L, -10800L, -14400L), 
    isdst = c(0L, 1L, 0L), TimeZone = c("AST", "APT", "AST"), 
    numeric = c(-2147397248, -769395600, -765399600)), .Names = c("Puerto_Rico", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-3L), class = "data.frame")
}

"Rainy_River" <- function () {
structure(list(Rainy_River = c("1901-12-14 20:45:52", "1918-04-14 08:00:00", 
"1918-10-31 07:00:00", "1945-08-14 23:00:00", "1945-09-30 07:00:00", 
"1974-04-28 08:00:00", "1974-10-27 07:00:00", "1975-04-27 08:00:00", 
"1975-10-26 07:00:00", "1976-04-25 08:00:00", "1976-10-31 07:00:00", 
"1977-04-24 08:00:00", "1977-10-30 07:00:00", "1978-04-30 08:00:00", 
"1978-10-29 07:00:00", "1979-04-29 08:00:00", "1979-10-28 07:00:00", 
"1980-04-27 08:00:00", "1980-10-26 07:00:00", "1981-04-26 08:00:00", 
"1981-10-25 07:00:00", "1982-04-25 08:00:00", "1982-10-31 07:00:00", 
"1983-04-24 08:00:00", "1983-10-30 07:00:00", "1984-04-29 08:00:00", 
"1984-10-28 07:00:00", "1985-04-28 08:00:00", "1985-10-27 07:00:00", 
"1986-04-27 08:00:00", "1986-10-26 07:00:00", "1987-04-05 08:00:00", 
"1987-10-25 07:00:00", "1988-04-03 08:00:00", "1988-10-30 07:00:00", 
"1989-04-02 08:00:00", "1989-10-29 07:00:00", "1990-04-01 08:00:00", 
"1990-10-28 07:00:00", "1991-04-07 08:00:00", "1991-10-27 07:00:00", 
"1992-04-05 08:00:00", "1992-10-25 07:00:00", "1993-04-04 08:00:00", 
"1993-10-31 07:00:00", "1994-04-03 08:00:00", "1994-10-30 07:00:00", 
"1995-04-02 08:00:00", "1995-10-29 07:00:00", "1996-04-07 08:00:00", 
"1996-10-27 07:00:00", "1997-04-06 08:00:00", "1997-10-26 07:00:00", 
"1998-04-05 08:00:00", "1998-10-25 07:00:00", "1999-04-04 08:00:00", 
"1999-10-31 07:00:00", "2000-04-02 08:00:00", "2000-10-29 07:00:00", 
"2001-04-01 08:00:00", "2001-10-28 07:00:00", "2002-04-07 08:00:00", 
"2002-10-27 07:00:00", "2003-04-06 08:00:00", "2003-10-26 07:00:00", 
"2004-04-04 08:00:00", "2004-10-31 07:00:00", "2005-04-03 08:00:00", 
"2005-10-30 07:00:00", "2006-04-02 08:00:00", "2006-10-29 07:00:00", 
"2007-03-11 08:00:00", "2007-11-04 07:00:00", "2008-03-09 08:00:00", 
"2008-11-02 07:00:00", "2009-03-08 08:00:00", "2009-11-01 07:00:00", 
"2010-03-14 08:00:00", "2010-11-07 07:00:00", "2011-03-13 08:00:00", 
"2011-11-06 07:00:00", "2012-03-11 08:00:00", "2012-11-04 07:00:00", 
"2013-03-10 08:00:00", "2013-11-03 07:00:00", "2014-03-09 08:00:00", 
"2014-11-02 07:00:00", "2015-03-08 08:00:00", "2015-11-01 07:00:00", 
"2016-03-13 08:00:00", "2016-11-06 07:00:00", "2017-03-12 08:00:00", 
"2017-11-05 07:00:00", "2018-03-11 08:00:00", "2018-11-04 07:00:00", 
"2019-03-10 08:00:00", "2019-11-03 07:00:00", "2020-03-08 08:00:00", 
"2020-11-01 07:00:00", "2021-03-14 08:00:00", "2021-11-07 07:00:00", 
"2022-03-13 08:00:00", "2022-11-06 07:00:00", "2023-03-12 08:00:00", 
"2023-11-05 07:00:00", "2024-03-10 08:00:00", "2024-11-03 07:00:00", 
"2025-03-09 08:00:00", "2025-11-02 07:00:00", "2026-03-08 08:00:00", 
"2026-11-01 07:00:00", "2027-03-14 08:00:00", "2027-11-07 07:00:00", 
"2028-03-12 08:00:00", "2028-11-05 07:00:00", "2029-03-11 08:00:00", 
"2029-11-04 07:00:00", "2030-03-10 08:00:00", "2030-11-03 07:00:00", 
"2031-03-09 08:00:00", "2031-11-02 07:00:00", "2032-03-14 08:00:00", 
"2032-11-07 07:00:00", "2033-03-13 08:00:00", "2033-11-06 07:00:00", 
"2034-03-12 08:00:00", "2034-11-05 07:00:00", "2035-03-11 08:00:00", 
"2035-11-04 07:00:00", "2036-03-09 08:00:00", "2036-11-02 07:00:00", 
"2037-03-08 08:00:00", "2037-11-01 07:00:00"), offSet = c(-21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L), isdst = c(0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L), TimeZone = c("CST", "CDT", "CST", "CPT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST"), numeric = c(-2147397248, -1632067200, -1614790800, 
-769395600, -765392400, 136368000, 152089200, 167817600, 183538800, 
199267200, 215593200, 230716800, 247042800, 262771200, 278492400, 
294220800, 309942000, 325670400, 341391600, 357120000, 372841200, 
388569600, 404895600, 420019200, 436345200, 452073600, 467794800, 
483523200, 499244400, 514972800, 530694000, 544608000, 562143600, 
576057600, 594198000, 607507200, 625647600, 638956800, 657097200, 
671011200, 688546800, 702460800, 719996400, 733910400, 752050800, 
765360000, 783500400, 796809600, 814950000, 828864000, 846399600, 
860313600, 877849200, 891763200, 909298800, 923212800, 941353200, 
954662400, 972802800, 986112000, 1004252400, 1018166400, 1035702000, 
1049616000, 1067151600, 1081065600, 1099206000, 1112515200, 1130655600, 
1143964800, 1162105200, 1173600000, 1194159600, 1205049600, 1225609200, 
1236499200, 1257058800, 1268553600, 1289113200, 1300003200, 1320562800, 
1331452800, 1352012400, 1362902400, 1383462000, 1394352000, 1414911600, 
1425801600, 1446361200, 1457856000, 1478415600, 1489305600, 1509865200, 
1520755200, 1541314800, 1552204800, 1572764400, 1583654400, 1604214000, 
1615708800, 1636268400, 1647158400, 1667718000, 1678608000, 1699167600, 
1710057600, 1730617200, 1741507200, 1762066800, 1772956800, 1793516400, 
1805011200, 1825570800, 1836460800, 1857020400, 1867910400, 1888470000, 
1899360000, 1919919600, 1930809600, 1951369200, 1962864000, 1983423600, 
1994313600, 2014873200, 2025763200, 2046322800, 2057212800, 2077772400, 
2088662400, 2109222000, 2120112000, 2140671600)), .Names = c("Rainy_River", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-133L), class = "data.frame")
}

"Rankin_Inlet" <- function () {
structure(list(Rankin_Inlet = c("1901-12-14 20:45:52", "1957-01-01 00:00:00", 
"1965-04-25 06:00:00", "1965-10-31 06:00:00", "1980-04-27 08:00:00", 
"1980-10-26 07:00:00", "1981-04-26 08:00:00", "1981-10-25 07:00:00", 
"1982-04-25 08:00:00", "1982-10-31 07:00:00", "1983-04-24 08:00:00", 
"1983-10-30 07:00:00", "1984-04-29 08:00:00", "1984-10-28 07:00:00", 
"1985-04-28 08:00:00", "1985-10-27 07:00:00", "1986-04-27 08:00:00", 
"1986-10-26 07:00:00", "1987-04-05 08:00:00", "1987-10-25 07:00:00", 
"1988-04-03 08:00:00", "1988-10-30 07:00:00", "1989-04-02 08:00:00", 
"1989-10-29 07:00:00", "1990-04-01 08:00:00", "1990-10-28 07:00:00", 
"1991-04-07 08:00:00", "1991-10-27 07:00:00", "1992-04-05 08:00:00", 
"1992-10-25 07:00:00", "1993-04-04 08:00:00", "1993-10-31 07:00:00", 
"1994-04-03 08:00:00", "1994-10-30 07:00:00", "1995-04-02 08:00:00", 
"1995-10-29 07:00:00", "1996-04-07 08:00:00", "1996-10-27 07:00:00", 
"1997-04-06 08:00:00", "1997-10-26 07:00:00", "1998-04-05 08:00:00", 
"1998-10-25 07:00:00", "1999-04-04 08:00:00", "1999-10-31 07:00:00", 
"2001-04-01 08:00:00", "2001-10-28 07:00:00", "2002-04-07 08:00:00", 
"2002-10-27 07:00:00", "2003-04-06 08:00:00", "2003-10-26 07:00:00", 
"2004-04-04 08:00:00", "2004-10-31 07:00:00", "2005-04-03 08:00:00", 
"2005-10-30 07:00:00", "2006-04-02 08:00:00", "2006-10-29 07:00:00", 
"2007-03-11 08:00:00", "2007-11-04 07:00:00", "2008-03-09 08:00:00", 
"2008-11-02 07:00:00", "2009-03-08 08:00:00", "2009-11-01 07:00:00", 
"2010-03-14 08:00:00", "2010-11-07 07:00:00", "2011-03-13 08:00:00", 
"2011-11-06 07:00:00", "2012-03-11 08:00:00", "2012-11-04 07:00:00", 
"2013-03-10 08:00:00", "2013-11-03 07:00:00", "2014-03-09 08:00:00", 
"2014-11-02 07:00:00", "2015-03-08 08:00:00", "2015-11-01 07:00:00", 
"2016-03-13 08:00:00", "2016-11-06 07:00:00", "2017-03-12 08:00:00", 
"2017-11-05 07:00:00", "2018-03-11 08:00:00", "2018-11-04 07:00:00", 
"2019-03-10 08:00:00", "2019-11-03 07:00:00", "2020-03-08 08:00:00", 
"2020-11-01 07:00:00", "2021-03-14 08:00:00", "2021-11-07 07:00:00", 
"2022-03-13 08:00:00", "2022-11-06 07:00:00", "2023-03-12 08:00:00", 
"2023-11-05 07:00:00", "2024-03-10 08:00:00", "2024-11-03 07:00:00", 
"2025-03-09 08:00:00", "2025-11-02 07:00:00", "2026-03-08 08:00:00", 
"2026-11-01 07:00:00", "2027-03-14 08:00:00", "2027-11-07 07:00:00", 
"2028-03-12 08:00:00", "2028-11-05 07:00:00", "2029-03-11 08:00:00", 
"2029-11-04 07:00:00", "2030-03-10 08:00:00", "2030-11-03 07:00:00", 
"2031-03-09 08:00:00", "2031-11-02 07:00:00", "2032-03-14 08:00:00", 
"2032-11-07 07:00:00", "2033-03-13 08:00:00", "2033-11-06 07:00:00", 
"2034-03-12 08:00:00", "2034-11-05 07:00:00", "2035-03-11 08:00:00", 
"2035-11-04 07:00:00", "2036-03-09 08:00:00", "2036-11-02 07:00:00", 
"2037-03-08 08:00:00", "2037-11-01 07:00:00"), offSet = c(0L, 
-21600L, -14400L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L), isdst = c(0L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L), TimeZone = c("zzz", "CST", "CDDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST"), numeric = c(-2147397248, 
-410227200, -147895200, -131565600, 325670400, 341391600, 357120000, 
372841200, 388569600, 404895600, 420019200, 436345200, 452073600, 
467794800, 483523200, 499244400, 514972800, 530694000, 544608000, 
562143600, 576057600, 594198000, 607507200, 625647600, 638956800, 
657097200, 671011200, 688546800, 702460800, 719996400, 733910400, 
752050800, 765360000, 783500400, 796809600, 814950000, 828864000, 
846399600, 860313600, 877849200, 891763200, 909298800, 923212800, 
941353200, 986112000, 1004252400, 1018166400, 1035702000, 1049616000, 
1067151600, 1081065600, 1099206000, 1112515200, 1130655600, 1143964800, 
1162105200, 1173600000, 1194159600, 1205049600, 1225609200, 1236499200, 
1257058800, 1268553600, 1289113200, 1300003200, 1320562800, 1331452800, 
1352012400, 1362902400, 1383462000, 1394352000, 1414911600, 1425801600, 
1446361200, 1457856000, 1478415600, 1489305600, 1509865200, 1520755200, 
1541314800, 1552204800, 1572764400, 1583654400, 1604214000, 1615708800, 
1636268400, 1647158400, 1667718000, 1678608000, 1699167600, 1710057600, 
1730617200, 1741507200, 1762066800, 1772956800, 1793516400, 1805011200, 
1825570800, 1836460800, 1857020400, 1867910400, 1888470000, 1899360000, 
1919919600, 1930809600, 1951369200, 1962864000, 1983423600, 1994313600, 
2014873200, 2025763200, 2046322800, 2057212800, 2077772400, 2088662400, 
2109222000, 2120112000, 2140671600)), .Names = c("Rankin_Inlet", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-118L), class = "data.frame")
}

"Recife" <- function () {
structure(list(Recife = c("1901-12-14 20:45:52", "1914-01-01 02:19:36", 
"1931-10-03 14:00:00", "1932-04-01 02:00:00", "1932-10-03 03:00:00", 
"1933-04-01 02:00:00", "1949-12-01 03:00:00", "1950-04-16 03:00:00", 
"1950-12-01 03:00:00", "1951-04-01 02:00:00", "1951-12-01 03:00:00", 
"1952-04-01 02:00:00", "1952-12-01 03:00:00", "1953-03-01 02:00:00", 
"1963-12-09 03:00:00", "1964-03-01 02:00:00", "1965-01-31 03:00:00", 
"1965-03-31 02:00:00", "1965-12-01 03:00:00", "1966-03-01 02:00:00", 
"1966-11-01 03:00:00", "1967-03-01 02:00:00", "1967-11-01 03:00:00", 
"1968-03-01 02:00:00", "1985-11-02 03:00:00", "1986-03-15 02:00:00", 
"1986-10-25 03:00:00", "1987-02-14 02:00:00", "1987-10-25 03:00:00", 
"1988-02-07 02:00:00", "1988-10-16 03:00:00", "1989-01-29 02:00:00", 
"1989-10-15 03:00:00", "1990-02-11 02:00:00", "1999-10-03 03:00:00", 
"2000-02-27 02:00:00", "2000-10-08 03:00:00", "2000-10-15 02:00:00", 
"2001-10-14 03:00:00", "2002-02-17 02:00:00"), offSet = c(-8376L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L), 
    isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
    1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
    0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
    "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
    "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
    "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
    "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
    "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT"), numeric = c(-2147397248, 
    -1767217224, -1206957600, -1191362400, -1175374800, -1159826400, 
    -633819600, -622069200, -602283600, -591832800, -570747600, 
    -560210400, -539125200, -531352800, -191365200, -184197600, 
    -155163600, -150069600, -128898000, -121125600, -99954000, 
    -89589600, -68418000, -57967200, 499748400, 511236000, 530593200, 
    540266400, 562129200, 571197600, 592974000, 602042400, 624423600, 
    634701600, 938919600, 951616800, 970974000, 971575200, 1003028400, 
    1013911200)), .Names = c("Recife", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -40L), class = "data.frame")
}

"Regina" <- function () {
structure(list(Regina = c("1901-12-14 20:45:52", "1905-09-01 06:58:36", 
"1918-04-14 09:00:00", "1918-10-31 08:00:00", "1930-05-04 07:00:00", 
"1930-10-05 06:00:00", "1931-05-03 07:00:00", "1931-10-04 06:00:00", 
"1932-05-01 07:00:00", "1932-10-02 06:00:00", "1933-05-07 07:00:00", 
"1933-10-01 06:00:00", "1934-05-06 07:00:00", "1934-10-07 06:00:00", 
"1937-04-11 07:00:00", "1937-10-10 06:00:00", "1938-04-10 07:00:00", 
"1938-10-02 06:00:00", "1939-04-09 07:00:00", "1939-10-08 06:00:00", 
"1940-04-14 07:00:00", "1940-10-13 06:00:00", "1941-04-13 07:00:00", 
"1941-10-12 06:00:00", "1945-08-14 23:00:00", "1945-09-30 08:00:00", 
"1946-04-14 09:00:00", "1946-10-13 08:00:00", "1947-04-27 09:00:00", 
"1947-09-28 08:00:00", "1948-04-25 09:00:00", "1948-09-26 08:00:00", 
"1949-04-24 09:00:00", "1949-09-25 08:00:00", "1950-04-30 09:00:00", 
"1950-09-24 08:00:00", "1951-04-29 09:00:00", "1951-09-30 08:00:00", 
"1952-04-27 09:00:00", "1952-09-28 08:00:00", "1953-04-26 09:00:00", 
"1953-09-27 08:00:00", "1954-04-25 09:00:00", "1954-09-26 08:00:00", 
"1955-04-24 09:00:00", "1955-09-25 08:00:00", "1956-04-29 09:00:00", 
"1956-09-30 08:00:00", "1957-04-28 09:00:00", "1957-09-29 08:00:00", 
"1959-04-26 09:00:00", "1959-10-25 08:00:00", "1960-04-24 09:00:00"
), offSet = c(-25116L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L), isdst = c(0L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 0L), TimeZone = c("LMT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MPT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "CST"), numeric = c(-2147397248, -2030202084, -1632063600, 
-1614787200, -1251651600, -1238349600, -1220202000, -1206900000, 
-1188752400, -1175450400, -1156698000, -1144000800, -1125248400, 
-1111946400, -1032714000, -1016992800, -1001264400, -986148000, 
-969814800, -954093600, -937760400, -922039200, -906310800, -890589600, 
-769395600, -765388800, -748450800, -732729600, -715791600, -702489600, 
-684342000, -671040000, -652892400, -639590400, -620838000, -608140800, 
-589388400, -576086400, -557938800, -544636800, -526489200, -513187200, 
-495039600, -481737600, -463590000, -450288000, -431535600, -418233600, 
-400086000, -386784000, -337186800, -321465600, -305737200)), .Names = c("Regina", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-53L), class = "data.frame")
}

"Resolute" <- function () {
structure(list(Resolute = c("1901-12-14 20:45:52", "1947-08-31 00:00:00", 
"1965-04-25 06:00:00", "1965-10-31 06:00:00", "1980-04-27 08:00:00", 
"1980-10-26 07:00:00", "1981-04-26 08:00:00", "1981-10-25 07:00:00", 
"1982-04-25 08:00:00", "1982-10-31 07:00:00", "1983-04-24 08:00:00", 
"1983-10-30 07:00:00", "1984-04-29 08:00:00", "1984-10-28 07:00:00", 
"1985-04-28 08:00:00", "1985-10-27 07:00:00", "1986-04-27 08:00:00", 
"1986-10-26 07:00:00", "1987-04-05 08:00:00", "1987-10-25 07:00:00", 
"1988-04-03 08:00:00", "1988-10-30 07:00:00", "1989-04-02 08:00:00", 
"1989-10-29 07:00:00", "1990-04-01 08:00:00", "1990-10-28 07:00:00", 
"1991-04-07 08:00:00", "1991-10-27 07:00:00", "1992-04-05 08:00:00", 
"1992-10-25 07:00:00", "1993-04-04 08:00:00", "1993-10-31 07:00:00", 
"1994-04-03 08:00:00", "1994-10-30 07:00:00", "1995-04-02 08:00:00", 
"1995-10-29 07:00:00", "1996-04-07 08:00:00", "1996-10-27 07:00:00", 
"1997-04-06 08:00:00", "1997-10-26 07:00:00", "1998-04-05 08:00:00", 
"1998-10-25 07:00:00", "1999-04-04 08:00:00", "1999-10-31 07:00:00", 
"2001-04-01 08:00:00", "2001-10-28 07:00:00", "2002-04-07 08:00:00", 
"2002-10-27 07:00:00", "2003-04-06 08:00:00", "2003-10-26 07:00:00", 
"2004-04-04 08:00:00", "2004-10-31 07:00:00", "2005-04-03 08:00:00", 
"2005-10-30 07:00:00", "2006-04-02 08:00:00"), offSet = c(0L, 
-21600L, -14400L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L), isdst = c(0L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L), TimeZone = c("zzz", "CST", "CDDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT"), numeric = c(-2147397248, 
-704937600, -147895200, -131565600, 325670400, 341391600, 357120000, 
372841200, 388569600, 404895600, 420019200, 436345200, 452073600, 
467794800, 483523200, 499244400, 514972800, 530694000, 544608000, 
562143600, 576057600, 594198000, 607507200, 625647600, 638956800, 
657097200, 671011200, 688546800, 702460800, 719996400, 733910400, 
752050800, 765360000, 783500400, 796809600, 814950000, 828864000, 
846399600, 860313600, 877849200, 891763200, 909298800, 923212800, 
941353200, 986112000, 1004252400, 1018166400, 1035702000, 1049616000, 
1067151600, 1081065600, 1099206000, 1112515200, 1130655600, 1143964800
)), .Names = c("Resolute", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -55L), class = "data.frame")
}

"Rio_Branco" <- function () {
structure(list(Rio_Branco = c("1901-12-14 20:45:52", "1914-01-01 04:31:12", 
"1931-10-03 16:00:00", "1932-04-01 04:00:00", "1932-10-03 05:00:00", 
"1933-04-01 04:00:00", "1949-12-01 05:00:00", "1950-04-16 05:00:00", 
"1950-12-01 05:00:00", "1951-04-01 04:00:00", "1951-12-01 05:00:00", 
"1952-04-01 04:00:00", "1952-12-01 05:00:00", "1953-03-01 04:00:00", 
"1963-12-09 05:00:00", "1964-03-01 04:00:00", "1965-01-31 05:00:00", 
"1965-03-31 04:00:00", "1965-12-01 05:00:00", "1966-03-01 04:00:00", 
"1966-11-01 05:00:00", "1967-03-01 04:00:00", "1967-11-01 05:00:00", 
"1968-03-01 04:00:00", "1985-11-02 05:00:00", "1986-03-15 04:00:00", 
"1986-10-25 05:00:00", "1987-02-14 04:00:00", "1987-10-25 05:00:00", 
"1988-02-07 04:00:00", "2008-06-24 05:00:00"), offSet = c(-16272L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 0L), TimeZone = c("LMT", "ACT", "ACST", 
"ACT", "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", 
"ACST", "ACT", "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", "ACST", 
"ACT", "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", "ACST", "ACT", 
"AMT"), numeric = c(-2147397248, -1767209328, -1206950400, -1191355200, 
-1175367600, -1159819200, -633812400, -622062000, -602276400, 
-591825600, -570740400, -560203200, -539118000, -531345600, -191358000, 
-184190400, -155156400, -150062400, -128890800, -121118400, -99946800, 
-89582400, -68410800, -57960000, 499755600, 511243200, 530600400, 
540273600, 562136400, 571204800, 1214283600)), .Names = c("Rio_Branco", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-31L), class = "data.frame")
}

"Santiago" <- function () {
structure(list(Santiago = c("1901-12-14 20:45:52", "1910-01-01 04:42:46", 
"1916-07-01 05:00:00", "1918-09-01 04:42:46", "1919-07-01 04:00:00", 
"1927-09-01 04:42:46", "1928-04-01 04:00:00", "1928-09-01 05:00:00", 
"1929-04-01 04:00:00", "1929-09-01 05:00:00", "1930-04-01 04:00:00", 
"1930-09-01 05:00:00", "1931-04-01 04:00:00", "1931-09-01 05:00:00", 
"1932-04-01 04:00:00", "1932-09-01 05:00:00", "1942-06-01 04:00:00", 
"1942-08-01 05:00:00", "1946-09-01 03:00:00", "1947-05-22 05:00:00", 
"1968-11-03 04:00:00", "1969-03-30 03:00:00", "1969-11-23 04:00:00", 
"1970-03-29 03:00:00", "1970-10-11 04:00:00", "1971-03-14 03:00:00", 
"1971-10-10 04:00:00", "1972-03-12 03:00:00", "1972-10-15 04:00:00", 
"1973-03-11 03:00:00", "1973-09-30 04:00:00", "1974-03-10 03:00:00", 
"1974-10-13 04:00:00", "1975-03-09 03:00:00", "1975-10-12 04:00:00", 
"1976-03-14 03:00:00", "1976-10-10 04:00:00", "1977-03-13 03:00:00", 
"1977-10-09 04:00:00", "1978-03-12 03:00:00", "1978-10-15 04:00:00", 
"1979-03-11 03:00:00", "1979-10-14 04:00:00", "1980-03-09 03:00:00", 
"1980-10-12 04:00:00", "1981-03-15 03:00:00", "1981-10-11 04:00:00", 
"1982-03-14 03:00:00", "1982-10-10 04:00:00", "1983-03-13 03:00:00", 
"1983-10-09 04:00:00", "1984-03-11 03:00:00", "1984-10-14 04:00:00", 
"1985-03-10 03:00:00", "1985-10-13 04:00:00", "1986-03-09 03:00:00", 
"1986-10-12 04:00:00", "1987-04-12 03:00:00", "1987-10-11 04:00:00", 
"1988-03-13 03:00:00", "1988-10-02 04:00:00", "1989-03-12 03:00:00", 
"1989-10-15 04:00:00", "1990-03-18 03:00:00", "1990-09-16 04:00:00", 
"1991-03-10 03:00:00", "1991-10-13 04:00:00", "1992-03-15 03:00:00", 
"1992-10-11 04:00:00", "1993-03-14 03:00:00", "1993-10-10 04:00:00", 
"1994-03-13 03:00:00", "1994-10-09 04:00:00", "1995-03-12 03:00:00", 
"1995-10-15 04:00:00", "1996-03-10 03:00:00", "1996-10-13 04:00:00", 
"1997-03-30 03:00:00", "1997-10-12 04:00:00", "1998-03-15 03:00:00", 
"1998-09-27 04:00:00", "1999-04-04 03:00:00", "1999-10-10 04:00:00", 
"2000-03-12 03:00:00", "2000-10-15 04:00:00", "2001-03-11 03:00:00", 
"2001-10-14 04:00:00", "2002-03-10 03:00:00", "2002-10-13 04:00:00", 
"2003-03-09 03:00:00", "2003-10-12 04:00:00", "2004-03-14 03:00:00", 
"2004-10-10 04:00:00", "2005-03-13 03:00:00", "2005-10-09 04:00:00", 
"2006-03-12 03:00:00", "2006-10-15 04:00:00", "2007-03-11 03:00:00", 
"2007-10-14 04:00:00", "2008-03-30 03:00:00", "2008-10-12 04:00:00", 
"2009-03-15 03:00:00", "2009-10-11 04:00:00", "2010-03-14 03:00:00", 
"2010-10-10 04:00:00", "2011-03-13 03:00:00", "2011-10-09 04:00:00", 
"2012-03-11 03:00:00", "2012-10-14 04:00:00", "2013-03-10 03:00:00", 
"2013-10-13 04:00:00", "2014-03-09 03:00:00", "2014-10-12 04:00:00", 
"2015-03-15 03:00:00", "2015-10-11 04:00:00", "2016-03-13 03:00:00", 
"2016-10-09 04:00:00", "2017-03-12 03:00:00", "2017-10-15 04:00:00", 
"2018-03-11 03:00:00", "2018-10-14 04:00:00", "2019-03-10 03:00:00", 
"2019-10-13 04:00:00", "2020-03-15 03:00:00", "2020-10-11 04:00:00", 
"2021-03-14 03:00:00", "2021-10-10 04:00:00", "2022-03-13 03:00:00", 
"2022-10-09 04:00:00", "2023-03-12 03:00:00", "2023-10-15 04:00:00", 
"2024-03-10 03:00:00", "2024-10-13 04:00:00", "2025-03-09 03:00:00", 
"2025-10-12 04:00:00", "2026-03-15 03:00:00", "2026-10-11 04:00:00", 
"2027-03-14 03:00:00", "2027-10-10 04:00:00", "2028-03-12 03:00:00", 
"2028-10-15 04:00:00", "2029-03-11 03:00:00", "2029-10-14 04:00:00", 
"2030-03-10 03:00:00", "2030-10-13 04:00:00", "2031-03-09 03:00:00", 
"2031-10-12 04:00:00", "2032-03-14 03:00:00", "2032-10-10 04:00:00", 
"2033-03-13 03:00:00", "2033-10-09 04:00:00", "2034-03-12 03:00:00", 
"2034-10-15 04:00:00", "2035-03-11 03:00:00", "2035-10-14 04:00:00", 
"2036-03-09 03:00:00", "2036-10-12 04:00:00", "2037-03-15 03:00:00", 
"2037-10-11 04:00:00"), offSet = c(-16966L, -18000L, -16966L, 
-14400L, -16966L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, 0L), isdst = c(0L, 0L, 0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 0L), TimeZone = c("SMT", "CLT", "SMT", "CLT", 
"SMT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "UTC"), numeric = c(-2147397248, -1893439034, -1688410800, 
-1619983034, -1593806400, -1335986234, -1317585600, -1304362800, 
-1286049600, -1272826800, -1254513600, -1241290800, -1222977600, 
-1209754800, -1191355200, -1178132400, -870552000, -865278000, 
-736376400, -713646000, -36619200, -23922000, -3355200, 7527600, 
24465600, 37767600, 55915200, 69217200, 87969600, 100666800, 
118209600, 132116400, 150868800, 163566000, 182318400, 195620400, 
213768000, 227070000, 245217600, 258519600, 277272000, 289969200, 
308721600, 321418800, 340171200, 353473200, 371620800, 384922800, 
403070400, 416372400, 434520000, 447822000, 466574400, 479271600, 
498024000, 510721200, 529473600, 545194800, 560923200, 574225200, 
591768000, 605674800, 624427200, 637729200, 653457600, 668574000, 
687326400, 700628400, 718776000, 732078000, 750225600, 763527600, 
781675200, 794977200, 813729600, 826426800, 845179200, 859690800, 
876628800, 889930800, 906868800, 923194800, 939528000, 952830000, 
971582400, 984279600, 1003032000, 1015729200, 1034481600, 1047178800, 
1065931200, 1079233200, 1097380800, 1110682800, 1128830400, 1142132400, 
1160884800, 1173582000, 1192334400, 1206846000, 1223784000, 1237086000, 
1255233600, 1268535600, 1286683200, 1299985200, 1318132800, 1331434800, 
1350187200, 1362884400, 1381636800, 1394334000, 1413086400, 1426388400, 
1444536000, 1457838000, 1475985600, 1489287600, 1508040000, 1520737200, 
1539489600, 1552186800, 1570939200, 1584241200, 1602388800, 1615690800, 
1633838400, 1647140400, 1665288000, 1678590000, 1697342400, 1710039600, 
1728792000, 1741489200, 1760241600, 1773543600, 1791691200, 1804993200, 
1823140800, 1836442800, 1855195200, 1867892400, 1886644800, 1899342000, 
1918094400, 1930791600, 1949544000, 1962846000, 1980993600, 1994295600, 
2012443200, 2025745200, 2044497600, 2057194800, 2075947200, 2088644400, 
2107396800, 2120698800, 2138846400)), .Names = c("Santiago", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-159L), class = "data.frame")
}

"Santo_Domingo" <- function () {
structure(list(Santo_Domingo = c("1901-12-14 20:45:52", "1933-04-01 16:40:00", 
"1966-10-30 05:00:00", "1967-02-28 04:00:00", "1969-10-26 05:00:00", 
"1970-02-21 04:30:00", "1970-10-25 05:00:00", "1971-01-20 04:30:00", 
"1971-10-31 05:00:00", "1972-01-21 04:30:00", "1972-10-29 05:00:00", 
"1973-01-21 04:30:00", "1973-10-28 05:00:00", "1974-01-21 04:30:00", 
"1974-10-27 05:00:00", "2000-10-29 06:00:00", "2000-12-03 06:00:00"
), offSet = c(-16800L, -18000L, -14400L, -18000L, -16200L, -18000L, 
-16200L, -18000L, -16200L, -18000L, -16200L, -18000L, -16200L, 
-18000L, -14400L, -18000L, -14400L), isdst = c(0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 0L, 0L), TimeZone = c("SDMT", 
"EST", "EDT", "EST", "EHDT", "EST", "EHDT", "EST", "EHDT", "EST", 
"EHDT", "EST", "EHDT", "EST", "AST", "EST", "AST"), numeric = c(-2147397248, 
-1159773600, -100119600, -89668800, -5770800, 4422600, 25678800, 
33193800, 57733200, 64816200, 89182800, 96438600, 120632400, 
127974600, 152082000, 972799200, 975823200)), .Names = c("Santo_Domingo", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-17L), class = "data.frame")
}

"Sao_Paulo" <- function () {
structure(list(Sao_Paulo = c("1901-12-14 20:45:52", "1914-01-01 03:06:28", 
"1931-10-03 14:00:00", "1932-04-01 02:00:00", "1932-10-03 03:00:00", 
"1933-04-01 02:00:00", "1949-12-01 03:00:00", "1950-04-16 03:00:00", 
"1950-12-01 03:00:00", "1951-04-01 02:00:00", "1951-12-01 03:00:00", 
"1952-04-01 02:00:00", "1952-12-01 03:00:00", "1953-03-01 02:00:00", 
"1963-10-23 03:00:00", "1964-03-01 02:00:00", "1965-01-31 03:00:00", 
"1965-03-31 02:00:00", "1965-12-01 03:00:00", "1966-03-01 02:00:00", 
"1966-11-01 03:00:00", "1967-03-01 02:00:00", "1967-11-01 03:00:00", 
"1968-03-01 02:00:00", "1985-11-02 03:00:00", "1986-03-15 02:00:00", 
"1986-10-25 03:00:00", "1987-02-14 02:00:00", "1987-10-25 03:00:00", 
"1988-02-07 02:00:00", "1988-10-16 03:00:00", "1989-01-29 02:00:00", 
"1989-10-15 03:00:00", "1990-02-11 02:00:00", "1990-10-21 03:00:00", 
"1991-02-17 02:00:00", "1991-10-20 03:00:00", "1992-02-09 02:00:00", 
"1992-10-25 03:00:00", "1993-01-31 02:00:00", "1993-10-17 03:00:00", 
"1994-02-20 02:00:00", "1994-10-16 03:00:00", "1995-02-19 02:00:00", 
"1995-10-15 03:00:00", "1996-02-11 02:00:00", "1996-10-06 03:00:00", 
"1997-02-16 02:00:00", "1997-10-06 03:00:00", "1998-03-01 02:00:00", 
"1998-10-11 03:00:00", "1999-02-21 02:00:00", "1999-10-03 03:00:00", 
"2000-02-27 02:00:00", "2000-10-08 03:00:00", "2001-02-18 02:00:00", 
"2001-10-14 03:00:00", "2002-02-17 02:00:00", "2002-11-03 03:00:00", 
"2003-02-16 02:00:00", "2003-10-19 03:00:00", "2004-02-15 02:00:00", 
"2004-11-02 03:00:00", "2005-02-20 02:00:00", "2005-10-16 03:00:00", 
"2006-02-19 02:00:00", "2006-11-05 03:00:00", "2007-02-25 02:00:00", 
"2007-10-14 03:00:00", "2008-02-17 02:00:00", "2008-10-19 03:00:00", 
"2009-02-15 02:00:00", "2009-10-18 03:00:00", "2010-02-21 02:00:00", 
"2010-10-17 03:00:00", "2011-02-20 02:00:00", "2011-10-16 03:00:00", 
"2012-02-26 02:00:00", "2012-10-21 03:00:00", "2013-02-17 02:00:00", 
"2013-10-20 03:00:00", "2014-02-16 02:00:00", "2014-10-19 03:00:00", 
"2015-02-22 02:00:00", "2015-10-18 03:00:00", "2016-02-21 02:00:00", 
"2016-10-16 03:00:00", "2017-02-19 02:00:00", "2017-10-15 03:00:00", 
"2018-02-18 02:00:00", "2018-10-21 03:00:00", "2019-02-17 02:00:00", 
"2019-10-20 03:00:00", "2020-02-16 02:00:00", "2020-10-18 03:00:00", 
"2021-02-21 02:00:00", "2021-10-17 03:00:00", "2022-02-20 02:00:00", 
"2022-10-16 03:00:00", "2023-02-26 02:00:00", "2023-10-15 03:00:00", 
"2024-02-18 02:00:00", "2024-10-20 03:00:00", "2025-02-16 02:00:00", 
"2025-10-19 03:00:00", "2026-02-22 02:00:00", "2026-10-18 03:00:00", 
"2027-02-21 02:00:00", "2027-10-17 03:00:00", "2028-02-20 02:00:00", 
"2028-10-15 03:00:00", "2029-02-18 02:00:00", "2029-10-21 03:00:00", 
"2030-02-17 02:00:00", "2030-10-20 03:00:00", "2031-02-16 02:00:00", 
"2031-10-19 03:00:00", "2032-02-15 02:00:00", "2032-10-17 03:00:00", 
"2033-02-20 02:00:00", "2033-10-16 03:00:00", "2034-02-26 02:00:00", 
"2034-10-15 03:00:00", "2035-02-18 02:00:00", "2035-10-21 03:00:00", 
"2036-02-17 02:00:00", "2036-10-19 03:00:00", "2037-02-22 02:00:00", 
"2037-10-18 03:00:00"), offSet = c(-11188L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L, -10800L, -7200L, 
-10800L, -7200L, -10800L, -7200L, -10800L, -7200L), isdst = c(0L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L
), TimeZone = c("LMT", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", 
"BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", "BRST", "BRT", 
"BRST", "BRT", "BRST", "BRT", "BRST"), numeric = c(-2147397248, 
-1767214412, -1206957600, -1191362400, -1175374800, -1159826400, 
-633819600, -622069200, -602283600, -591832800, -570747600, -560210400, 
-539125200, -531352800, -195426000, -184197600, -155163600, -150069600, 
-128898000, -121125600, -99954000, -89589600, -68418000, -57967200, 
499748400, 511236000, 530593200, 540266400, 562129200, 571197600, 
592974000, 602042400, 624423600, 634701600, 656478000, 666756000, 
687927600, 697600800, 719982000, 728445600, 750826800, 761709600, 
782276400, 793159200, 813726000, 824004000, 844570800, 856058400, 
876106800, 888717600, 908074800, 919562400, 938919600, 951616800, 
970974000, 982461600, 1003028400, 1013911200, 1036292400, 1045360800, 
1066532400, 1076810400, 1099364400, 1108864800, 1129431600, 1140314400, 
1162695600, 1172368800, 1192330800, 1203213600, 1224385200, 1234663200, 
1255834800, 1266717600, 1287284400, 1298167200, 1318734000, 1330221600, 
1350788400, 1361066400, 1382238000, 1392516000, 1413687600, 1424570400, 
1445137200, 1456020000, 1476586800, 1487469600, 1508036400, 1518919200, 
1540090800, 1550368800, 1571540400, 1581818400, 1602990000, 1613872800, 
1634439600, 1645322400, 1665889200, 1677376800, 1697338800, 1708221600, 
1729393200, 1739671200, 1760842800, 1771725600, 1792292400, 1803175200, 
1823742000, 1834624800, 1855191600, 1866074400, 1887246000, 1897524000, 
1918695600, 1928973600, 1950145200, 1960423200, 1981594800, 1992477600, 
2013044400, 2024532000, 2044494000, 2055376800, 2076548400, 2086826400, 
2107998000, 2118880800, 2139447600)), .Names = c("Sao_Paulo", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-129L), class = "data.frame")
}

"Scoresbysund" <- function () {
structure(list(Scoresbysund = c("1901-12-14 20:45:52", "1916-07-28 01:27:52", 
"1980-04-06 04:00:00", "1980-09-28 04:00:00", "1981-03-29 02:00:00", 
"1981-09-27 01:00:00", "1982-03-28 01:00:00", "1982-09-26 01:00:00", 
"1983-03-27 01:00:00", "1983-09-25 01:00:00", "1984-03-25 01:00:00", 
"1984-09-30 01:00:00", "1985-03-31 01:00:00", "1985-09-29 01:00:00", 
"1986-03-30 01:00:00", "1986-09-28 01:00:00", "1987-03-29 01:00:00", 
"1987-09-27 01:00:00", "1988-03-27 01:00:00", "1988-09-25 01:00:00", 
"1989-03-26 01:00:00", "1989-09-24 01:00:00", "1990-03-25 01:00:00", 
"1990-09-30 01:00:00", "1991-03-31 01:00:00", "1991-09-29 01:00:00", 
"1992-03-29 01:00:00", "1992-09-27 01:00:00", "1993-03-28 01:00:00", 
"1993-09-26 01:00:00", "1994-03-27 01:00:00", "1994-09-25 01:00:00", 
"1995-03-26 01:00:00", "1995-09-24 01:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 01:00:00", "1997-10-26 01:00:00", 
"1998-03-29 01:00:00", "1998-10-25 01:00:00", "1999-03-28 01:00:00", 
"1999-10-31 01:00:00", "2000-03-26 01:00:00", "2000-10-29 01:00:00", 
"2001-03-25 01:00:00", "2001-10-28 01:00:00", "2002-03-31 01:00:00", 
"2002-10-27 01:00:00", "2003-03-30 01:00:00", "2003-10-26 01:00:00", 
"2004-03-28 01:00:00", "2004-10-31 01:00:00", "2005-03-27 01:00:00", 
"2005-10-30 01:00:00", "2006-03-26 01:00:00", "2006-10-29 01:00:00", 
"2007-03-25 01:00:00", "2007-10-28 01:00:00", "2008-03-30 01:00:00", 
"2008-10-26 01:00:00", "2009-03-29 01:00:00", "2009-10-25 01:00:00", 
"2010-03-28 01:00:00", "2010-10-31 01:00:00", "2011-03-27 01:00:00", 
"2011-10-30 01:00:00", "2012-03-25 01:00:00", "2012-10-28 01:00:00", 
"2013-03-31 01:00:00", "2013-10-27 01:00:00", "2014-03-30 01:00:00", 
"2014-10-26 01:00:00", "2015-03-29 01:00:00", "2015-10-25 01:00:00", 
"2016-03-27 01:00:00", "2016-10-30 01:00:00", "2017-03-26 01:00:00", 
"2017-10-29 01:00:00", "2018-03-25 01:00:00", "2018-10-28 01:00:00", 
"2019-03-31 01:00:00", "2019-10-27 01:00:00", "2020-03-29 01:00:00", 
"2020-10-25 01:00:00", "2021-03-28 01:00:00", "2021-10-31 01:00:00", 
"2022-03-27 01:00:00", "2022-10-30 01:00:00", "2023-03-26 01:00:00", 
"2023-10-29 01:00:00", "2024-03-31 01:00:00", "2024-10-27 01:00:00", 
"2025-03-30 01:00:00", "2025-10-26 01:00:00", "2026-03-29 01:00:00", 
"2026-10-25 01:00:00", "2027-03-28 01:00:00", "2027-10-31 01:00:00", 
"2028-03-26 01:00:00", "2028-10-29 01:00:00", "2029-03-25 01:00:00", 
"2029-10-28 01:00:00", "2030-03-31 01:00:00", "2030-10-27 01:00:00", 
"2031-03-30 01:00:00", "2031-10-26 01:00:00", "2032-03-28 01:00:00", 
"2032-10-31 01:00:00", "2033-03-27 01:00:00", "2033-10-30 01:00:00", 
"2034-03-26 01:00:00", "2034-10-29 01:00:00", "2035-03-25 01:00:00", 
"2035-10-28 01:00:00", "2036-03-30 01:00:00", "2036-10-26 01:00:00", 
"2037-03-29 01:00:00", "2037-10-25 01:00:00"), offSet = c(-5272L, 
-7200L, -3600L, -7200L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L), isdst = c(0L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "CGT", "CGST", "CGT", 
"EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", 
"EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", 
"EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", 
"EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", 
"EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", 
"EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", 
"EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", 
"EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", 
"EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", 
"EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", 
"EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", 
"EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", "EGST", "EGT", 
"EGST", "EGT", "EGST", "EGT", "EGST", "EGT"), numeric = c(-2147397248, 
-1686090728, 323841600, 338961600, 354679200, 370400400, 386125200, 
401850000, 417574800, 433299600, 449024400, 465354000, 481078800, 
496803600, 512528400, 528253200, 543978000, 559702800, 575427600, 
591152400, 606877200, 622602000, 638326800, 654656400, 670381200, 
686106000, 701830800, 717555600, 733280400, 749005200, 764730000, 
780454800, 796179600, 811904400, 828234000, 846378000, 859683600, 
877827600, 891133200, 909277200, 922582800, 941331600, 954032400, 
972781200, 985482000, 1004230800, 1017536400, 1035680400, 1048986000, 
1067130000, 1080435600, 1099184400, 1111885200, 1130634000, 1143334800, 
1162083600, 1174784400, 1193533200, 1206838800, 1224982800, 1238288400, 
1256432400, 1269738000, 1288486800, 1301187600, 1319936400, 1332637200, 
1351386000, 1364691600, 1382835600, 1396141200, 1414285200, 1427590800, 
1445734800, 1459040400, 1477789200, 1490490000, 1509238800, 1521939600, 
1540688400, 1553994000, 1572138000, 1585443600, 1603587600, 1616893200, 
1635642000, 1648342800, 1667091600, 1679792400, 1698541200, 1711846800, 
1729990800, 1743296400, 1761440400, 1774746000, 1792890000, 1806195600, 
1824944400, 1837645200, 1856394000, 1869094800, 1887843600, 1901149200, 
1919293200, 1932598800, 1950742800, 1964048400, 1982797200, 1995498000, 
2014246800, 2026947600, 2045696400, 2058397200, 2077146000, 2090451600, 
2108595600, 2121901200, 2140045200)), .Names = c("Scoresbysund", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-118L), class = "data.frame")
}

"Shiprock" <- function () {
structure(list(Shiprock = c("1901-12-14 20:45:52", "1918-03-31 09:00:00", 
"1918-10-27 08:00:00", "1919-03-30 09:00:00", "1919-10-26 08:00:00", 
"1920-03-28 09:00:00", "1920-10-31 08:00:00", "1921-03-27 09:00:00", 
"1921-05-22 08:00:00", "1945-08-14 23:00:00", "1945-09-30 08:00:00", 
"1965-04-25 09:00:00", "1965-10-31 08:00:00", "1966-04-24 09:00:00", 
"1966-10-30 08:00:00", "1967-04-30 09:00:00", "1967-10-29 08:00:00", 
"1968-04-28 09:00:00", "1968-10-27 08:00:00", "1969-04-27 09:00:00", 
"1969-10-26 08:00:00", "1970-04-26 09:00:00", "1970-10-25 08:00:00", 
"1971-04-25 09:00:00", "1971-10-31 08:00:00", "1972-04-30 09:00:00", 
"1972-10-29 08:00:00", "1973-04-29 09:00:00", "1973-10-28 08:00:00", 
"1974-01-06 09:00:00", "1974-10-27 08:00:00", "1975-02-23 09:00:00", 
"1975-10-26 08:00:00", "1976-04-25 09:00:00", "1976-10-31 08:00:00", 
"1977-04-24 09:00:00", "1977-10-30 08:00:00", "1978-04-30 09:00:00", 
"1978-10-29 08:00:00", "1979-04-29 09:00:00", "1979-10-28 08:00:00", 
"1980-04-27 09:00:00", "1980-10-26 08:00:00", "1981-04-26 09:00:00", 
"1981-10-25 08:00:00", "1982-04-25 09:00:00", "1982-10-31 08:00:00", 
"1983-04-24 09:00:00", "1983-10-30 08:00:00", "1984-04-29 09:00:00", 
"1984-10-28 08:00:00", "1985-04-28 09:00:00", "1985-10-27 08:00:00", 
"1986-04-27 09:00:00", "1986-10-26 08:00:00", "1987-04-05 09:00:00", 
"1987-10-25 08:00:00", "1988-04-03 09:00:00", "1988-10-30 08:00:00", 
"1989-04-02 09:00:00", "1989-10-29 08:00:00", "1990-04-01 09:00:00", 
"1990-10-28 08:00:00", "1991-04-07 09:00:00", "1991-10-27 08:00:00", 
"1992-04-05 09:00:00", "1992-10-25 08:00:00", "1993-04-04 09:00:00", 
"1993-10-31 08:00:00", "1994-04-03 09:00:00", "1994-10-30 08:00:00", 
"1995-04-02 09:00:00", "1995-10-29 08:00:00", "1996-04-07 09:00:00", 
"1996-10-27 08:00:00", "1997-04-06 09:00:00", "1997-10-26 08:00:00", 
"1998-04-05 09:00:00", "1998-10-25 08:00:00", "1999-04-04 09:00:00", 
"1999-10-31 08:00:00", "2000-04-02 09:00:00", "2000-10-29 08:00:00", 
"2001-04-01 09:00:00", "2001-10-28 08:00:00", "2002-04-07 09:00:00", 
"2002-10-27 08:00:00", "2003-04-06 09:00:00", "2003-10-26 08:00:00", 
"2004-04-04 09:00:00", "2004-10-31 08:00:00", "2005-04-03 09:00:00", 
"2005-10-30 08:00:00", "2006-04-02 09:00:00", "2006-10-29 08:00:00", 
"2007-03-11 09:00:00", "2007-11-04 08:00:00", "2008-03-09 09:00:00", 
"2008-11-02 08:00:00", "2009-03-08 09:00:00", "2009-11-01 08:00:00", 
"2010-03-14 09:00:00", "2010-11-07 08:00:00", "2011-03-13 09:00:00", 
"2011-11-06 08:00:00", "2012-03-11 09:00:00", "2012-11-04 08:00:00", 
"2013-03-10 09:00:00", "2013-11-03 08:00:00", "2014-03-09 09:00:00", 
"2014-11-02 08:00:00", "2015-03-08 09:00:00", "2015-11-01 08:00:00", 
"2016-03-13 09:00:00", "2016-11-06 08:00:00", "2017-03-12 09:00:00", 
"2017-11-05 08:00:00", "2018-03-11 09:00:00", "2018-11-04 08:00:00", 
"2019-03-10 09:00:00", "2019-11-03 08:00:00", "2020-03-08 09:00:00", 
"2020-11-01 08:00:00", "2021-03-14 09:00:00", "2021-11-07 08:00:00", 
"2022-03-13 09:00:00", "2022-11-06 08:00:00", "2023-03-12 09:00:00", 
"2023-11-05 08:00:00", "2024-03-10 09:00:00", "2024-11-03 08:00:00", 
"2025-03-09 09:00:00", "2025-11-02 08:00:00", "2026-03-08 09:00:00", 
"2026-11-01 08:00:00", "2027-03-14 09:00:00", "2027-11-07 08:00:00", 
"2028-03-12 09:00:00", "2028-11-05 08:00:00", "2029-03-11 09:00:00", 
"2029-11-04 08:00:00", "2030-03-10 09:00:00", "2030-11-03 08:00:00", 
"2031-03-09 09:00:00", "2031-11-02 08:00:00", "2032-03-14 09:00:00", 
"2032-11-07 08:00:00", "2033-03-13 09:00:00", "2033-11-06 08:00:00", 
"2034-03-12 09:00:00", "2034-11-05 08:00:00", "2035-03-11 09:00:00", 
"2035-11-04 08:00:00", "2036-03-09 09:00:00", "2036-11-02 08:00:00", 
"2037-03-08 09:00:00", "2037-11-01 08:00:00"), offSet = c(-25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L), TimeZone = c("MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MPT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST"
), numeric = c(-2147397248, -1633273200, -1615132800, -1601823600, 
-1583683200, -1570374000, -1551628800, -1538924400, -1534089600, 
-769395600, -765388800, -147884400, -131558400, -116434800, -100108800, 
-84380400, -68659200, -52930800, -37209600, -21481200, -5760000, 
9968400, 25689600, 41418000, 57744000, 73472400, 89193600, 104922000, 
120643200, 126694800, 152092800, 162378000, 183542400, 199270800, 
215596800, 230720400, 247046400, 262774800, 278496000, 294224400, 
309945600, 325674000, 341395200, 357123600, 372844800, 388573200, 
404899200, 420022800, 436348800, 452077200, 467798400, 483526800, 
499248000, 514976400, 530697600, 544611600, 562147200, 576061200, 
594201600, 607510800, 625651200, 638960400, 657100800, 671014800, 
688550400, 702464400, 7.2e+08, 733914000, 752054400, 765363600, 
783504000, 796813200, 814953600, 828867600, 846403200, 860317200, 
877852800, 891766800, 909302400, 923216400, 941356800, 954666000, 
972806400, 986115600, 1004256000, 1018170000, 1035705600, 1049619600, 
1067155200, 1081069200, 1099209600, 1112518800, 1130659200, 1143968400, 
1162108800, 1173603600, 1194163200, 1205053200, 1225612800, 1236502800, 
1257062400, 1268557200, 1289116800, 1300006800, 1320566400, 1331456400, 
1352016000, 1362906000, 1383465600, 1394355600, 1414915200, 1425805200, 
1446364800, 1457859600, 1478419200, 1489309200, 1509868800, 1520758800, 
1541318400, 1552208400, 1572768000, 1583658000, 1604217600, 1615712400, 
1636272000, 1647162000, 1667721600, 1678611600, 1699171200, 1710061200, 
1730620800, 1741510800, 1762070400, 1772960400, 1793520000, 1805014800, 
1825574400, 1836464400, 1857024000, 1867914000, 1888473600, 1899363600, 
1919923200, 1930813200, 1951372800, 1962867600, 1983427200, 1994317200, 
2014876800, 2025766800, 2046326400, 2057216400, 2077776000, 2088666000, 
2109225600, 2120115600, 2140675200)), .Names = c("Shiprock", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-157L), class = "data.frame")
}

"St_Barthelemy" <- function () {
structure(list(St_Barthelemy = c("1901-12-14 20:45:52", "1911-06-08 04:06:08"
), offSet = c(-14768L, -14400L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"AST"), numeric = c(-2147397248, -1848254032)), .Names = c("St_Barthelemy", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"St_Johns" <- function () {
structure(list(St_Johns = c("1901-12-14 20:45:52", "1917-04-08 05:30:52", 
"1917-09-17 04:30:52", "1918-04-14 05:30:52", "1918-10-31 04:30:52", 
"1919-05-06 02:30:52", "1919-08-13 01:30:52", "1920-05-03 02:30:52", 
"1920-11-01 01:30:52", "1921-05-02 02:30:52", "1921-10-31 01:30:52", 
"1922-05-08 02:30:52", "1922-10-30 01:30:52", "1923-05-07 02:30:52", 
"1923-10-29 01:30:52", "1924-05-05 02:30:52", "1924-10-27 01:30:52", 
"1925-05-04 02:30:52", "1925-10-26 01:30:52", "1926-05-03 02:30:52", 
"1926-11-01 01:30:52", "1927-05-02 02:30:52", "1927-10-31 01:30:52", 
"1928-05-07 02:30:52", "1928-10-29 01:30:52", "1929-05-06 02:30:52", 
"1929-10-28 01:30:52", "1930-05-05 02:30:52", "1930-10-27 01:30:52", 
"1931-05-04 02:30:52", "1931-10-26 01:30:52", "1932-05-02 02:30:52", 
"1932-10-31 01:30:52", "1933-05-08 02:30:52", "1933-10-30 01:30:52", 
"1934-05-07 02:30:52", "1934-10-29 01:30:52", "1935-03-30 03:30:52", 
"1935-05-06 02:30:00", "1935-10-28 01:30:00", "1936-05-11 03:30:00", 
"1936-10-05 02:30:00", "1937-05-10 03:30:00", "1937-10-04 02:30:00", 
"1938-05-09 03:30:00", "1938-10-03 02:30:00", "1939-05-15 03:30:00", 
"1939-10-02 02:30:00", "1940-05-13 03:30:00", "1940-10-07 02:30:00", 
"1941-05-12 03:30:00", "1941-10-06 02:30:00", "1945-08-14 23:00:00", 
"1945-09-30 04:30:00", "1946-05-12 05:30:00", "1946-10-06 04:30:00", 
"1947-05-11 05:30:00", "1947-10-05 04:30:00", "1948-05-09 05:30:00", 
"1948-10-03 04:30:00", "1949-05-08 05:30:00", "1949-10-02 04:30:00", 
"1950-05-14 05:30:00", "1950-10-08 04:30:00", "1951-04-29 05:30:00", 
"1951-09-30 04:30:00", "1952-04-27 05:30:00", "1952-09-28 04:30:00", 
"1953-04-26 05:30:00", "1953-09-27 04:30:00", "1954-04-25 05:30:00", 
"1954-09-26 04:30:00", "1955-04-24 05:30:00", "1955-09-25 04:30:00", 
"1956-04-29 05:30:00", "1956-09-30 04:30:00", "1957-04-28 05:30:00", 
"1957-09-29 04:30:00", "1958-04-27 05:30:00", "1958-09-28 04:30:00", 
"1959-04-26 05:30:00", "1959-09-27 04:30:00", "1960-04-24 05:30:00", 
"1960-10-30 04:30:00", "1961-04-30 05:30:00", "1961-10-29 04:30:00", 
"1962-04-29 05:30:00", "1962-10-28 04:30:00", "1963-04-28 05:30:00", 
"1963-10-27 04:30:00", "1964-04-26 05:30:00", "1964-10-25 04:30:00", 
"1965-04-25 05:30:00", "1965-10-31 04:30:00", "1966-04-24 05:30:00", 
"1966-10-30 04:30:00", "1967-04-30 05:30:00", "1967-10-29 04:30:00", 
"1968-04-28 05:30:00", "1968-10-27 04:30:00", "1969-04-27 05:30:00", 
"1969-10-26 04:30:00", "1970-04-26 05:30:00", "1970-10-25 04:30:00", 
"1971-04-25 05:30:00", "1971-10-31 04:30:00", "1972-04-30 05:30:00", 
"1972-10-29 04:30:00", "1973-04-29 05:30:00", "1973-10-28 04:30:00", 
"1974-04-28 05:30:00", "1974-10-27 04:30:00", "1975-04-27 05:30:00", 
"1975-10-26 04:30:00", "1976-04-25 05:30:00", "1976-10-31 04:30:00", 
"1977-04-24 05:30:00", "1977-10-30 04:30:00", "1978-04-30 05:30:00", 
"1978-10-29 04:30:00", "1979-04-29 05:30:00", "1979-10-28 04:30:00", 
"1980-04-27 05:30:00", "1980-10-26 04:30:00", "1981-04-26 05:30:00", 
"1981-10-25 04:30:00", "1982-04-25 05:30:00", "1982-10-31 04:30:00", 
"1983-04-24 05:30:00", "1983-10-30 04:30:00", "1984-04-29 05:30:00", 
"1984-10-28 04:30:00", "1985-04-28 05:30:00", "1985-10-27 04:30:00", 
"1986-04-27 05:30:00", "1986-10-26 04:30:00", "1987-04-05 03:31:00", 
"1987-10-25 02:31:00", "1988-04-03 03:31:00", "1988-10-30 01:31:00", 
"1989-04-02 03:31:00", "1989-10-29 02:31:00", "1990-04-01 03:31:00", 
"1990-10-28 02:31:00", "1991-04-07 03:31:00", "1991-10-27 02:31:00", 
"1992-04-05 03:31:00", "1992-10-25 02:31:00", "1993-04-04 03:31:00", 
"1993-10-31 02:31:00", "1994-04-03 03:31:00", "1994-10-30 02:31:00", 
"1995-04-02 03:31:00", "1995-10-29 02:31:00", "1996-04-07 03:31:00", 
"1996-10-27 02:31:00", "1997-04-06 03:31:00", "1997-10-26 02:31:00", 
"1998-04-05 03:31:00", "1998-10-25 02:31:00", "1999-04-04 03:31:00", 
"1999-10-31 02:31:00", "2000-04-02 03:31:00", "2000-10-29 02:31:00", 
"2001-04-01 03:31:00", "2001-10-28 02:31:00", "2002-04-07 03:31:00", 
"2002-10-27 02:31:00", "2003-04-06 03:31:00", "2003-10-26 02:31:00", 
"2004-04-04 03:31:00", "2004-10-31 02:31:00", "2005-04-03 03:31:00", 
"2005-10-30 02:31:00", "2006-04-02 03:31:00", "2006-10-29 02:31:00", 
"2007-03-11 03:31:00", "2007-11-04 02:31:00", "2008-03-09 03:31:00", 
"2008-11-02 02:31:00", "2009-03-08 03:31:00", "2009-11-01 02:31:00", 
"2010-03-14 03:31:00", "2010-11-07 02:31:00", "2011-03-13 03:31:00", 
"2011-11-06 02:31:00", "2012-03-11 03:31:00", "2012-11-04 02:31:00", 
"2013-03-10 03:31:00", "2013-11-03 02:31:00", "2014-03-09 03:31:00", 
"2014-11-02 02:31:00", "2015-03-08 03:31:00", "2015-11-01 02:31:00", 
"2016-03-13 03:31:00", "2016-11-06 02:31:00", "2017-03-12 03:31:00", 
"2017-11-05 02:31:00", "2018-03-11 03:31:00", "2018-11-04 02:31:00", 
"2019-03-10 03:31:00", "2019-11-03 02:31:00", "2020-03-08 03:31:00", 
"2020-11-01 02:31:00", "2021-03-14 03:31:00", "2021-11-07 02:31:00", 
"2022-03-13 03:31:00", "2022-11-06 02:31:00", "2023-03-12 03:31:00", 
"2023-11-05 02:31:00", "2024-03-10 03:31:00", "2024-11-03 02:31:00", 
"2025-03-09 03:31:00", "2025-11-02 02:31:00", "2026-03-08 03:31:00", 
"2026-11-01 02:31:00", "2027-03-14 03:31:00", "2027-11-07 02:31:00", 
"2028-03-12 03:31:00", "2028-11-05 02:31:00", "2029-03-11 03:31:00", 
"2029-11-04 02:31:00", "2030-03-10 03:31:00", "2030-11-03 02:31:00", 
"2031-03-09 03:31:00", "2031-11-02 02:31:00", "2032-03-14 03:31:00", 
"2032-11-07 02:31:00", "2033-03-13 03:31:00", "2033-11-06 02:31:00", 
"2034-03-12 03:31:00", "2034-11-05 02:31:00", "2035-03-11 03:31:00", 
"2035-11-04 02:31:00", "2036-03-09 03:31:00", "2036-11-02 02:31:00", 
"2037-03-08 03:31:00", "2037-11-01 02:31:00"), offSet = c(-12652L, 
-9052L, -12652L, -9052L, -12652L, -9052L, -12652L, -9052L, -12652L, 
-9052L, -12652L, -9052L, -12652L, -9052L, -12652L, -9052L, -12652L, 
-9052L, -12652L, -9052L, -12652L, -9052L, -12652L, -9052L, -12652L, 
-9052L, -12652L, -9052L, -12652L, -9052L, -12652L, -9052L, -12652L, 
-9052L, -12652L, -9052L, -12652L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -5400L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L, -9000L, -12600L, -9000L, 
-12600L, -9000L, -12600L, -9000L, -12600L), isdst = c(0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NPT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", 
"NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", "NST", "NDT", 
"NST", "NDT", "NST"), numeric = c(-2147397248, -1664130548, -1650137348, 
-1632076148, -1614799748, -1598650148, -1590100148, -1567286948, 
-1551565748, -1535837348, -1520116148, -1503782948, -1488666548, 
-1472333348, -1457216948, -1440883748, -1425767348, -1409434148, 
-1394317748, -1377984548, -1362263348, -1346534948, -1330813748, 
-1314480548, -1299364148, -1283030948, -1267914548, -1251581348, 
-1236464948, -1220131748, -1205015348, -1188682148, -1172960948, 
-1156627748, -1141511348, -1125178148, -1110061748, -1096921748, 
-1093728600, -1078612200, -1061670600, -1048973400, -1030221000, 
-1017523800, -998771400, -986074200, -966717000, -954624600, 
-935267400, -922570200, -903817800, -891120600, -769395600, -765401400, 
-746044200, -733347000, -714594600, -701897400, -683145000, -670447800, 
-651695400, -638998200, -619641000, -606943800, -589401000, -576099000, 
-557951400, -544649400, -526501800, -513199800, -495052200, -481750200, 
-463602600, -450300600, -431548200, -418246200, -400098600, -386796600, 
-368649000, -355347000, -337199400, -323897400, -305749800, -289423800, 
-273695400, -257974200, -242245800, -226524600, -210796200, -195075000, 
-179346600, -163625400, -147897000, -131571000, -116447400, -100121400, 
-84393000, -68671800, -52943400, -37222200, -21493800, -5772600, 
9955800, 25677000, 41405400, 57731400, 73459800, 89181000, 104909400, 
120630600, 136359000, 152080200, 167808600, 183529800, 199258200, 
215584200, 230707800, 247033800, 262762200, 278483400, 294211800, 
309933000, 325661400, 341382600, 357111000, 372832200, 388560600, 
404886600, 420010200, 436336200, 452064600, 467785800, 483514200, 
499235400, 514963800, 530685000, 544591860, 562127460, 576041460, 
594178260, 607491060, 625631460, 638940660, 657081060, 670995060, 
688530660, 702444660, 719980260, 733894260, 752034660, 765343860, 
783484260, 796793460, 814933860, 828847860, 846383460, 860297460, 
877833060, 891747060, 909282660, 923196660, 941337060, 954646260, 
972786660, 986095860, 1004236260, 1018150260, 1035685860, 1049599860, 
1067135460, 1081049460, 1099189860, 1112499060, 1130639460, 1143948660, 
1162089060, 1173583860, 1194143460, 1205033460, 1225593060, 1236483060, 
1257042660, 1268537460, 1289097060, 1299987060, 1320546660, 1331436660, 
1351996260, 1362886260, 1383445860, 1394335860, 1414895460, 1425785460, 
1446345060, 1457839860, 1478399460, 1489289460, 1509849060, 1520739060, 
1541298660, 1552188660, 1572748260, 1583638260, 1604197860, 1615692660, 
1636252260, 1647142260, 1667701860, 1678591860, 1699151460, 1710041460, 
1730601060, 1741491060, 1762050660, 1772940660, 1793500260, 1804995060, 
1825554660, 1836444660, 1857004260, 1867894260, 1888453860, 1899343860, 
1919903460, 1930793460, 1951353060, 1962847860, 1983407460, 1994297460, 
2014857060, 2025747060, 2046306660, 2057196660, 2077756260, 2088646260, 
2109205860, 2120095860, 2140655460)), .Names = c("St_Johns", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-238L), class = "data.frame")
}

"St_Kitts" <- function () {
structure(list(St_Kitts = c("1901-12-14 20:45:52", "1912-03-02 04:10:52"
), offSet = c(-15052L, -14400L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"AST"), numeric = c(-2147397248, -1825098548)), .Names = c("St_Kitts", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"St_Lucia" <- function () {
structure(list(St_Lucia = c("1901-12-14 20:45:52", "1912-01-01 04:04:00"
), offSet = c(-14640L, -14400L), isdst = c(0L, 0L), TimeZone = c("CMT", 
"AST"), numeric = c(-2147397248, -1830369360)), .Names = c("St_Lucia", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"St_Thomas" <- function () {
structure(list(St_Thomas = c("1901-12-14 20:45:52", "1911-07-01 04:19:44"
), offSet = c(-15584L, -14400L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"AST"), numeric = c(-2147397248, -1846266016)), .Names = c("St_Thomas", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"St_Vincent" <- function () {
structure(list(St_Vincent = c("1901-12-14 20:45:52", "1912-01-01 04:04:56"
), offSet = c(-14696L, -14400L), isdst = c(0L, 0L), TimeZone = c("KMT", 
"AST"), numeric = c(-2147397248, -1830369304)), .Names = c("St_Vincent", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Swift_Current" <- function () {
structure(list(Swift_Current = c("1901-12-14 20:45:52", "1905-09-01 07:11:20", 
"1918-04-14 09:00:00", "1918-10-31 08:00:00", "1945-08-14 23:00:00", 
"1945-09-30 08:00:00", "1946-04-28 09:00:00", "1946-10-13 08:00:00", 
"1947-04-27 09:00:00", "1947-09-28 08:00:00", "1948-04-25 09:00:00", 
"1948-09-26 08:00:00", "1949-04-24 09:00:00", "1949-09-25 08:00:00", 
"1957-04-28 09:00:00", "1957-10-27 08:00:00", "1959-04-26 09:00:00", 
"1959-10-25 08:00:00", "1960-04-24 09:00:00", "1960-09-25 08:00:00", 
"1961-04-30 09:00:00", "1961-09-24 08:00:00", "1972-04-30 09:00:00"
), offSet = c(-25880L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
0L), TimeZone = c("LMT", "MST", "MDT", "MST", "MPT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "CST"), numeric = c(-2147397248, 
-2030201320, -1632063600, -1614787200, -769395600, -765388800, 
-747241200, -732729600, -715791600, -702489600, -684342000, -671040000, 
-652892400, -639590400, -400086000, -384364800, -337186800, -321465600, 
-305737200, -292435200, -273682800, -260985600, 73472400)), .Names = c("Swift_Current", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-23L), class = "data.frame")
}

"Tegucigalpa" <- function () {
structure(list(Tegucigalpa = c("1901-12-14 20:45:52", "1921-04-01 05:48:52", 
"1987-05-03 06:00:00", "1987-09-27 05:00:00", "1988-05-01 06:00:00", 
"1988-09-25 05:00:00", "2006-05-07 06:00:00", "2006-08-07 05:00:00"
), offSet = c(-20932L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), 
    TimeZone = c("LMT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST"), numeric = c(-2147397248, -1538503868, 547020000, 
    559717200, 578469600, 591166800, 1146981600, 1154926800)), .Names = c("Tegucigalpa", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-8L), class = "data.frame")
}

"Thule" <- function () {
structure(list(Thule = c("1901-12-14 20:45:52", "1916-07-28 04:35:08", 
"1991-03-31 06:00:00", "1991-09-29 05:00:00", "1992-03-29 06:00:00", 
"1992-09-27 05:00:00", "1993-04-04 06:00:00", "1993-10-31 05:00:00", 
"1994-04-03 06:00:00", "1994-10-30 05:00:00", "1995-04-02 06:00:00", 
"1995-10-29 05:00:00", "1996-04-07 06:00:00", "1996-10-27 05:00:00", 
"1997-04-06 06:00:00", "1997-10-26 05:00:00", "1998-04-05 06:00:00", 
"1998-10-25 05:00:00", "1999-04-04 06:00:00", "1999-10-31 05:00:00", 
"2000-04-02 06:00:00", "2000-10-29 05:00:00", "2001-04-01 06:00:00", 
"2001-10-28 05:00:00", "2002-04-07 06:00:00", "2002-10-27 05:00:00", 
"2003-04-06 06:00:00", "2003-10-26 05:00:00", "2004-04-04 06:00:00", 
"2004-10-31 05:00:00", "2005-04-03 06:00:00", "2005-10-30 05:00:00", 
"2006-04-02 06:00:00", "2006-10-29 05:00:00", "2007-03-11 06:00:00", 
"2007-11-04 05:00:00", "2008-03-09 06:00:00", "2008-11-02 05:00:00", 
"2009-03-08 06:00:00", "2009-11-01 05:00:00", "2010-03-14 06:00:00", 
"2010-11-07 05:00:00", "2011-03-13 06:00:00", "2011-11-06 05:00:00", 
"2012-03-11 06:00:00", "2012-11-04 05:00:00", "2013-03-10 06:00:00", 
"2013-11-03 05:00:00", "2014-03-09 06:00:00", "2014-11-02 05:00:00", 
"2015-03-08 06:00:00", "2015-11-01 05:00:00", "2016-03-13 06:00:00", 
"2016-11-06 05:00:00", "2017-03-12 06:00:00", "2017-11-05 05:00:00", 
"2018-03-11 06:00:00", "2018-11-04 05:00:00", "2019-03-10 06:00:00", 
"2019-11-03 05:00:00", "2020-03-08 06:00:00", "2020-11-01 05:00:00", 
"2021-03-14 06:00:00", "2021-11-07 05:00:00", "2022-03-13 06:00:00", 
"2022-11-06 05:00:00", "2023-03-12 06:00:00", "2023-11-05 05:00:00", 
"2024-03-10 06:00:00", "2024-11-03 05:00:00", "2025-03-09 06:00:00", 
"2025-11-02 05:00:00", "2026-03-08 06:00:00", "2026-11-01 05:00:00", 
"2027-03-14 06:00:00", "2027-11-07 05:00:00", "2028-03-12 06:00:00", 
"2028-11-05 05:00:00", "2029-03-11 06:00:00", "2029-11-04 05:00:00", 
"2030-03-10 06:00:00", "2030-11-03 05:00:00", "2031-03-09 06:00:00", 
"2031-11-02 05:00:00", "2032-03-14 06:00:00", "2032-11-07 05:00:00", 
"2033-03-13 06:00:00", "2033-11-06 05:00:00", "2034-03-12 06:00:00", 
"2034-11-05 05:00:00", "2035-03-11 06:00:00", "2035-11-04 05:00:00", 
"2036-03-09 06:00:00", "2036-11-02 05:00:00", "2037-03-08 06:00:00", 
"2037-11-01 05:00:00"), offSet = c(-16508L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST"), numeric = c(-2147397248, -1686079492, 670399200, 
686120400, 701848800, 717570000, 733903200, 752043600, 765352800, 
783493200, 796802400, 814942800, 828856800, 846392400, 860306400, 
877842000, 891756000, 909291600, 923205600, 941346000, 954655200, 
972795600, 986104800, 1004245200, 1018159200, 1035694800, 1049608800, 
1067144400, 1081058400, 1099198800, 1112508000, 1130648400, 1143957600, 
1162098000, 1173592800, 1194152400, 1205042400, 1225602000, 1236492000, 
1257051600, 1268546400, 1289106000, 1299996000, 1320555600, 1331445600, 
1352005200, 1362895200, 1383454800, 1394344800, 1414904400, 1425794400, 
1446354000, 1457848800, 1478408400, 1489298400, 1509858000, 1520748000, 
1541307600, 1552197600, 1572757200, 1583647200, 1604206800, 1615701600, 
1636261200, 1647151200, 1667710800, 1678600800, 1699160400, 1710050400, 
1730610000, 1741500000, 1762059600, 1772949600, 1793509200, 1805004000, 
1825563600, 1836453600, 1857013200, 1867903200, 1888462800, 1899352800, 
1919912400, 1930802400, 1951362000, 1962856800, 1983416400, 1994306400, 
2014866000, 2025756000, 2046315600, 2057205600, 2077765200, 2088655200, 
2109214800, 2120104800, 2140664400)), .Names = c("Thule", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -96L), class = "data.frame")
}

"Thunder_Bay" <- function () {
structure(list(Thunder_Bay = c("1901-12-14 20:45:52", "1910-01-01 06:00:00", 
"1945-08-14 23:00:00", "1945-09-30 06:00:00", "1970-04-26 07:00:00", 
"1970-10-25 06:00:00", "1971-04-25 07:00:00", "1971-10-31 06:00:00", 
"1972-04-30 07:00:00", "1972-10-29 06:00:00", "1974-04-28 07:00:00", 
"1974-10-27 06:00:00", "1975-04-27 07:00:00", "1975-10-26 06:00:00", 
"1976-04-25 07:00:00", "1976-10-31 06:00:00", "1977-04-24 07:00:00", 
"1977-10-30 06:00:00", "1978-04-30 07:00:00", "1978-10-29 06:00:00", 
"1979-04-29 07:00:00", "1979-10-28 06:00:00", "1980-04-27 07:00:00", 
"1980-10-26 06:00:00", "1981-04-26 07:00:00", "1981-10-25 06:00:00", 
"1982-04-25 07:00:00", "1982-10-31 06:00:00", "1983-04-24 07:00:00", 
"1983-10-30 06:00:00", "1984-04-29 07:00:00", "1984-10-28 06:00:00", 
"1985-04-28 07:00:00", "1985-10-27 06:00:00", "1986-04-27 07:00:00", 
"1986-10-26 06:00:00", "1987-04-05 07:00:00", "1987-10-25 06:00:00", 
"1988-04-03 07:00:00", "1988-10-30 06:00:00", "1989-04-02 07:00:00", 
"1989-10-29 06:00:00", "1990-04-01 07:00:00", "1990-10-28 06:00:00", 
"1991-04-07 07:00:00", "1991-10-27 06:00:00", "1992-04-05 07:00:00", 
"1992-10-25 06:00:00", "1993-04-04 07:00:00", "1993-10-31 06:00:00", 
"1994-04-03 07:00:00", "1994-10-30 06:00:00", "1995-04-02 07:00:00", 
"1995-10-29 06:00:00", "1996-04-07 07:00:00", "1996-10-27 06:00:00", 
"1997-04-06 07:00:00", "1997-10-26 06:00:00", "1998-04-05 07:00:00", 
"1998-10-25 06:00:00", "1999-04-04 07:00:00", "1999-10-31 06:00:00", 
"2000-04-02 07:00:00", "2000-10-29 06:00:00", "2001-04-01 07:00:00", 
"2001-10-28 06:00:00", "2002-04-07 07:00:00", "2002-10-27 06:00:00", 
"2003-04-06 07:00:00", "2003-10-26 06:00:00", "2004-04-04 07:00:00", 
"2004-10-31 06:00:00", "2005-04-03 07:00:00", "2005-10-30 06:00:00", 
"2006-04-02 07:00:00", "2006-10-29 06:00:00", "2007-03-11 07:00:00", 
"2007-11-04 06:00:00", "2008-03-09 07:00:00", "2008-11-02 06:00:00", 
"2009-03-08 07:00:00", "2009-11-01 06:00:00", "2010-03-14 07:00:00", 
"2010-11-07 06:00:00", "2011-03-13 07:00:00", "2011-11-06 06:00:00", 
"2012-03-11 07:00:00", "2012-11-04 06:00:00", "2013-03-10 07:00:00", 
"2013-11-03 06:00:00", "2014-03-09 07:00:00", "2014-11-02 06:00:00", 
"2015-03-08 07:00:00", "2015-11-01 06:00:00", "2016-03-13 07:00:00", 
"2016-11-06 06:00:00", "2017-03-12 07:00:00", "2017-11-05 06:00:00", 
"2018-03-11 07:00:00", "2018-11-04 06:00:00", "2019-03-10 07:00:00", 
"2019-11-03 06:00:00", "2020-03-08 07:00:00", "2020-11-01 06:00:00", 
"2021-03-14 07:00:00", "2021-11-07 06:00:00", "2022-03-13 07:00:00", 
"2022-11-06 06:00:00", "2023-03-12 07:00:00", "2023-11-05 06:00:00", 
"2024-03-10 07:00:00", "2024-11-03 06:00:00", "2025-03-09 07:00:00", 
"2025-11-02 06:00:00", "2026-03-08 07:00:00", "2026-11-01 06:00:00", 
"2027-03-14 07:00:00", "2027-11-07 06:00:00", "2028-03-12 07:00:00", 
"2028-11-05 06:00:00", "2029-03-11 07:00:00", "2029-11-04 06:00:00", 
"2030-03-10 07:00:00", "2030-11-03 06:00:00", "2031-03-09 07:00:00", 
"2031-11-02 06:00:00", "2032-03-14 07:00:00", "2032-11-07 06:00:00", 
"2033-03-13 07:00:00", "2033-11-06 06:00:00", "2034-03-12 07:00:00", 
"2034-11-05 06:00:00", "2035-03-11 07:00:00", "2035-11-04 06:00:00", 
"2036-03-09 07:00:00", "2036-11-02 06:00:00", "2037-03-08 07:00:00", 
"2037-11-01 06:00:00"), offSet = c(-21600L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L), TimeZone = c("CST", "EST", "EPT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST"), numeric = c(-2147397248, 
-1893434400, -769395600, -765396000, 9961200, 25682400, 41410800, 
57736800, 73465200, 89186400, 136364400, 152085600, 167814000, 
183535200, 199263600, 215589600, 230713200, 247039200, 262767600, 
278488800, 294217200, 309938400, 325666800, 341388000, 357116400, 
372837600, 388566000, 404892000, 420015600, 436341600, 452070000, 
467791200, 483519600, 499240800, 514969200, 530690400, 544604400, 
562140000, 576054000, 594194400, 607503600, 625644000, 638953200, 
657093600, 671007600, 688543200, 702457200, 719992800, 733906800, 
752047200, 765356400, 783496800, 796806000, 814946400, 828860400, 
846396000, 860310000, 877845600, 891759600, 909295200, 923209200, 
941349600, 954658800, 972799200, 986108400, 1004248800, 1018162800, 
1035698400, 1049612400, 1067148000, 1081062000, 1099202400, 1112511600, 
1130652000, 1143961200, 1162101600, 1173596400, 1194156000, 1205046000, 
1225605600, 1236495600, 1257055200, 1268550000, 1289109600, 1299999600, 
1320559200, 1331449200, 1352008800, 1362898800, 1383458400, 1394348400, 
1414908000, 1425798000, 1446357600, 1457852400, 1478412000, 1489302000, 
1509861600, 1520751600, 1541311200, 1552201200, 1572760800, 1583650800, 
1604210400, 1615705200, 1636264800, 1647154800, 1667714400, 1678604400, 
1699164000, 1710054000, 1730613600, 1741503600, 1762063200, 1772953200, 
1793512800, 1805007600, 1825567200, 1836457200, 1857016800, 1867906800, 
1888466400, 1899356400, 1919916000, 1930806000, 1951365600, 1962860400, 
1983420000, 1994310000, 2014869600, 2025759600, 2046319200, 2057209200, 
2077768800, 2088658800, 2109218400, 2120108400, 2140668000)), .Names = c("Thunder_Bay", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-138L), class = "data.frame")
}

"Tijuana" <- function () {
structure(list(Tijuana = c("1901-12-14 20:45:52", "1922-01-01 08:00:00", 
"1924-01-01 07:00:00", "1927-06-11 07:00:00", "1930-11-15 07:00:00", 
"1931-04-01 08:00:00", "1931-09-30 07:00:00", "1945-08-14 23:00:00", 
"1945-11-12 07:00:00", "1948-04-05 08:00:00", "1949-01-14 07:00:00", 
"1954-04-25 10:00:00", "1954-09-26 09:00:00", "1955-04-24 10:00:00", 
"1955-09-25 09:00:00", "1956-04-29 10:00:00", "1956-09-30 09:00:00", 
"1957-04-28 10:00:00", "1957-09-29 09:00:00", "1958-04-27 10:00:00", 
"1958-09-28 09:00:00", "1959-04-26 10:00:00", "1959-09-27 09:00:00", 
"1960-04-24 10:00:00", "1960-09-25 09:00:00", "1976-04-25 10:00:00", 
"1976-10-31 09:00:00", "1977-04-24 10:00:00", "1977-10-30 09:00:00", 
"1978-04-30 10:00:00", "1978-10-29 09:00:00", "1979-04-29 10:00:00", 
"1979-10-28 09:00:00", "1980-04-27 10:00:00", "1980-10-26 09:00:00", 
"1981-04-26 10:00:00", "1981-10-25 09:00:00", "1982-04-25 10:00:00", 
"1982-10-31 09:00:00", "1983-04-24 10:00:00", "1983-10-30 09:00:00", 
"1984-04-29 10:00:00", "1984-10-28 09:00:00", "1985-04-28 10:00:00", 
"1985-10-27 09:00:00", "1986-04-27 10:00:00", "1986-10-26 09:00:00", 
"1987-04-05 10:00:00", "1987-10-25 09:00:00", "1988-04-03 10:00:00", 
"1988-10-30 09:00:00", "1989-04-02 10:00:00", "1989-10-29 09:00:00", 
"1990-04-01 10:00:00", "1990-10-28 09:00:00", "1991-04-07 10:00:00", 
"1991-10-27 09:00:00", "1992-04-05 10:00:00", "1992-10-25 09:00:00", 
"1993-04-04 10:00:00", "1993-10-31 09:00:00", "1994-04-03 10:00:00", 
"1994-10-30 09:00:00", "1995-04-02 10:00:00", "1995-10-29 09:00:00", 
"1996-04-07 10:00:00", "1996-10-27 09:00:00", "1997-04-06 10:00:00", 
"1997-10-26 09:00:00", "1998-04-05 10:00:00", "1998-10-25 09:00:00", 
"1999-04-04 10:00:00", "1999-10-31 09:00:00", "2000-04-02 10:00:00", 
"2000-10-29 09:00:00", "2001-04-01 10:00:00", "2001-10-28 09:00:00", 
"2002-04-07 10:00:00", "2002-10-27 09:00:00", "2003-04-06 10:00:00", 
"2003-10-26 09:00:00", "2004-04-04 10:00:00", "2004-10-31 09:00:00", 
"2005-04-03 10:00:00", "2005-10-30 09:00:00", "2006-04-02 10:00:00", 
"2006-10-29 09:00:00", "2007-04-01 10:00:00", "2007-10-28 09:00:00", 
"2008-04-06 10:00:00", "2008-10-26 09:00:00", "2009-04-05 10:00:00", 
"2009-10-25 09:00:00", "2010-04-04 10:00:00", "2010-10-31 09:00:00", 
"2011-04-03 10:00:00", "2011-10-30 09:00:00", "2012-04-01 10:00:00", 
"2012-10-28 09:00:00", "2013-04-07 10:00:00", "2013-10-27 09:00:00", 
"2014-04-06 10:00:00", "2014-10-26 09:00:00", "2015-04-05 10:00:00", 
"2015-10-25 09:00:00", "2016-04-03 10:00:00", "2016-10-30 09:00:00", 
"2017-04-02 10:00:00", "2017-10-29 09:00:00", "2018-04-01 10:00:00", 
"2018-10-28 09:00:00", "2019-04-07 10:00:00", "2019-10-27 09:00:00", 
"2020-04-05 10:00:00", "2020-10-25 09:00:00", "2021-04-04 10:00:00", 
"2021-10-31 09:00:00", "2022-04-03 10:00:00", "2022-10-30 09:00:00", 
"2023-04-02 10:00:00", "2023-10-29 09:00:00", "2024-04-07 10:00:00", 
"2024-10-27 09:00:00", "2025-04-06 10:00:00", "2025-10-26 09:00:00", 
"2026-04-05 10:00:00", "2026-10-25 09:00:00", "2027-04-04 10:00:00", 
"2027-10-31 09:00:00", "2028-04-02 10:00:00", "2028-10-29 09:00:00", 
"2029-04-01 10:00:00", "2029-10-28 09:00:00", "2030-04-07 10:00:00", 
"2030-10-27 09:00:00", "2031-04-06 10:00:00", "2031-10-26 09:00:00", 
"2032-04-04 10:00:00", "2032-10-31 09:00:00", "2033-04-03 10:00:00", 
"2033-10-30 09:00:00", "2034-04-02 10:00:00", "2034-10-29 09:00:00", 
"2035-04-01 10:00:00", "2035-10-28 09:00:00", "2036-04-06 10:00:00", 
"2036-10-26 09:00:00", "2037-04-05 10:00:00", "2037-10-25 09:00:00"
), offSet = c(-28084L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L), isdst = c(0L, 0L, 0L, 0L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), 
    TimeZone = c("LMT", "MST", "PST", "MST", "PST", "PDT", "PST", 
    "PPT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
    "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
    "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
    "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
    "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
    "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
    "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
    "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
    "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
    "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
    "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
    "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
    "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
    "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
    "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
    "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST"), numeric = c(-2147397248, 
    -1514736000, -1451667600, -1343062800, -1234803600, -1222963200, 
    -1207242000, -769395600, -761677200, -686073600, -661539600, 
    -495036000, -481734000, -463586400, -450284400, -431532000, 
    -418230000, -400082400, -386780400, -368632800, -355330800, 
    -337183200, -323881200, -305733600, -292431600, 199274400, 
    215600400, 230724000, 247050000, 262778400, 278499600, 294228000, 
    309949200, 325677600, 341398800, 357127200, 372848400, 388576800, 
    404902800, 420026400, 436352400, 452080800, 467802000, 483530400, 
    499251600, 514980000, 530701200, 544615200, 562150800, 576064800, 
    594205200, 607514400, 625654800, 638964000, 657104400, 671018400, 
    688554000, 702468000, 720003600, 733917600, 752058000, 765367200, 
    783507600, 796816800, 814957200, 828871200, 846406800, 860320800, 
    877856400, 891770400, 909306000, 923220000, 941360400, 954669600, 
    972810000, 986119200, 1004259600, 1018173600, 1035709200, 
    1049623200, 1067158800, 1081072800, 1099213200, 1112522400, 
    1130662800, 1143972000, 1162112400, 1175421600, 1193562000, 
    1207476000, 1225011600, 1238925600, 1256461200, 1270375200, 
    1288515600, 1301824800, 1319965200, 1333274400, 1351414800, 
    1365328800, 1382864400, 1396778400, 1414314000, 1428228000, 
    1445763600, 1459677600, 1477818000, 1491127200, 1509267600, 
    1522576800, 1540717200, 1554631200, 1572166800, 1586080800, 
    1603616400, 1617530400, 1635670800, 1648980000, 1667120400, 
    1680429600, 1698570000, 1712484000, 1730019600, 1743933600, 
    1761469200, 1775383200, 1792918800, 1806832800, 1824973200, 
    1838282400, 1856422800, 1869732000, 1887872400, 1901786400, 
    1919322000, 1933236000, 1950771600, 1964685600, 1982826000, 
    1996135200, 2014275600, 2027584800, 2045725200, 2059034400, 
    2077174800, 2091088800, 2108624400, 2122538400, 2140074000
    )), .Names = c("Tijuana", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -149L), class = "data.frame")
}

"Toronto" <- function () {
structure(list(Toronto = c("1901-12-14 20:45:52", "1918-04-14 07:00:00", 
"1918-10-31 06:00:00", "1919-03-31 04:30:00", "1919-10-26 04:00:00", 
"1920-05-02 07:00:00", "1920-09-26 04:00:00", "1921-05-15 07:00:00", 
"1921-09-15 06:00:00", "1922-05-14 07:00:00", "1922-09-17 06:00:00", 
"1923-05-13 07:00:00", "1923-09-16 06:00:00", "1924-05-04 07:00:00", 
"1924-09-21 06:00:00", "1925-05-03 07:00:00", "1925-09-20 06:00:00", 
"1926-05-02 07:00:00", "1926-09-19 06:00:00", "1927-05-01 07:00:00", 
"1927-09-25 06:00:00", "1928-04-29 07:00:00", "1928-09-30 06:00:00", 
"1929-04-28 07:00:00", "1929-09-29 06:00:00", "1930-04-27 07:00:00", 
"1930-09-28 06:00:00", "1931-04-26 07:00:00", "1931-09-27 06:00:00", 
"1932-05-01 07:00:00", "1932-09-25 06:00:00", "1933-04-30 07:00:00", 
"1933-10-01 06:00:00", "1934-04-29 07:00:00", "1934-09-30 06:00:00", 
"1935-04-28 07:00:00", "1935-09-29 06:00:00", "1936-04-26 07:00:00", 
"1936-09-27 06:00:00", "1937-04-25 07:00:00", "1937-09-26 06:00:00", 
"1938-04-24 07:00:00", "1938-09-25 06:00:00", "1939-04-30 07:00:00", 
"1939-09-24 06:00:00", "1945-08-14 23:00:00", "1945-09-30 06:00:00", 
"1946-04-28 07:00:00", "1946-09-29 06:00:00", "1947-04-27 05:00:00", 
"1947-09-28 04:00:00", "1948-04-25 05:00:00", "1948-09-26 04:00:00", 
"1949-04-24 05:00:00", "1949-11-27 04:00:00", "1950-04-30 07:00:00", 
"1950-11-26 06:00:00", "1951-04-29 07:00:00", "1951-09-30 06:00:00", 
"1952-04-27 07:00:00", "1952-09-28 06:00:00", "1953-04-26 07:00:00", 
"1953-09-27 06:00:00", "1954-04-25 07:00:00", "1954-09-26 06:00:00", 
"1955-04-24 07:00:00", "1955-09-25 06:00:00", "1956-04-29 07:00:00", 
"1956-09-30 06:00:00", "1957-04-28 07:00:00", "1957-10-27 06:00:00", 
"1958-04-27 07:00:00", "1958-10-26 06:00:00", "1959-04-26 07:00:00", 
"1959-10-25 06:00:00", "1960-04-24 07:00:00", "1960-10-30 06:00:00", 
"1961-04-30 07:00:00", "1961-10-29 06:00:00", "1962-04-29 07:00:00", 
"1962-10-28 06:00:00", "1963-04-28 07:00:00", "1963-10-27 06:00:00", 
"1964-04-26 07:00:00", "1964-10-25 06:00:00", "1965-04-25 07:00:00", 
"1965-10-31 06:00:00", "1966-04-24 07:00:00", "1966-10-30 06:00:00", 
"1967-04-30 07:00:00", "1967-10-29 06:00:00", "1968-04-28 07:00:00", 
"1968-10-27 06:00:00", "1969-04-27 07:00:00", "1969-10-26 06:00:00", 
"1970-04-26 07:00:00", "1970-10-25 06:00:00", "1971-04-25 07:00:00", 
"1971-10-31 06:00:00", "1972-04-30 07:00:00", "1972-10-29 06:00:00", 
"1973-04-29 07:00:00", "1973-10-28 06:00:00", "1974-04-28 07:00:00", 
"1974-10-27 06:00:00", "1975-04-27 07:00:00", "1975-10-26 06:00:00", 
"1976-04-25 07:00:00", "1976-10-31 06:00:00", "1977-04-24 07:00:00", 
"1977-10-30 06:00:00", "1978-04-30 07:00:00", "1978-10-29 06:00:00", 
"1979-04-29 07:00:00", "1979-10-28 06:00:00", "1980-04-27 07:00:00", 
"1980-10-26 06:00:00", "1981-04-26 07:00:00", "1981-10-25 06:00:00", 
"1982-04-25 07:00:00", "1982-10-31 06:00:00", "1983-04-24 07:00:00", 
"1983-10-30 06:00:00", "1984-04-29 07:00:00", "1984-10-28 06:00:00", 
"1985-04-28 07:00:00", "1985-10-27 06:00:00", "1986-04-27 07:00:00", 
"1986-10-26 06:00:00", "1987-04-05 07:00:00", "1987-10-25 06:00:00", 
"1988-04-03 07:00:00", "1988-10-30 06:00:00", "1989-04-02 07:00:00", 
"1989-10-29 06:00:00", "1990-04-01 07:00:00", "1990-10-28 06:00:00", 
"1991-04-07 07:00:00", "1991-10-27 06:00:00", "1992-04-05 07:00:00", 
"1992-10-25 06:00:00", "1993-04-04 07:00:00", "1993-10-31 06:00:00", 
"1994-04-03 07:00:00", "1994-10-30 06:00:00", "1995-04-02 07:00:00", 
"1995-10-29 06:00:00", "1996-04-07 07:00:00", "1996-10-27 06:00:00", 
"1997-04-06 07:00:00", "1997-10-26 06:00:00", "1998-04-05 07:00:00", 
"1998-10-25 06:00:00", "1999-04-04 07:00:00", "1999-10-31 06:00:00", 
"2000-04-02 07:00:00", "2000-10-29 06:00:00", "2001-04-01 07:00:00", 
"2001-10-28 06:00:00", "2002-04-07 07:00:00", "2002-10-27 06:00:00", 
"2003-04-06 07:00:00", "2003-10-26 06:00:00", "2004-04-04 07:00:00", 
"2004-10-31 06:00:00", "2005-04-03 07:00:00", "2005-10-30 06:00:00", 
"2006-04-02 07:00:00", "2006-10-29 06:00:00", "2007-03-11 07:00:00", 
"2007-11-04 06:00:00", "2008-03-09 07:00:00", "2008-11-02 06:00:00", 
"2009-03-08 07:00:00", "2009-11-01 06:00:00", "2010-03-14 07:00:00", 
"2010-11-07 06:00:00", "2011-03-13 07:00:00", "2011-11-06 06:00:00", 
"2012-03-11 07:00:00", "2012-11-04 06:00:00", "2013-03-10 07:00:00", 
"2013-11-03 06:00:00", "2014-03-09 07:00:00", "2014-11-02 06:00:00", 
"2015-03-08 07:00:00", "2015-11-01 06:00:00", "2016-03-13 07:00:00", 
"2016-11-06 06:00:00", "2017-03-12 07:00:00", "2017-11-05 06:00:00", 
"2018-03-11 07:00:00", "2018-11-04 06:00:00", "2019-03-10 07:00:00", 
"2019-11-03 06:00:00", "2020-03-08 07:00:00", "2020-11-01 06:00:00", 
"2021-03-14 07:00:00", "2021-11-07 06:00:00", "2022-03-13 07:00:00", 
"2022-11-06 06:00:00", "2023-03-12 07:00:00", "2023-11-05 06:00:00", 
"2024-03-10 07:00:00", "2024-11-03 06:00:00", "2025-03-09 07:00:00", 
"2025-11-02 06:00:00", "2026-03-08 07:00:00", "2026-11-01 06:00:00", 
"2027-03-14 07:00:00", "2027-11-07 06:00:00", "2028-03-12 07:00:00", 
"2028-11-05 06:00:00", "2029-03-11 07:00:00", "2029-11-04 06:00:00", 
"2030-03-10 07:00:00", "2030-11-03 06:00:00", "2031-03-09 07:00:00", 
"2031-11-02 06:00:00", "2032-03-14 07:00:00", "2032-11-07 06:00:00", 
"2033-03-13 07:00:00", "2033-11-06 06:00:00", "2034-03-12 07:00:00", 
"2034-11-05 06:00:00", "2035-03-11 07:00:00", "2035-11-04 06:00:00", 
"2036-03-09 07:00:00", "2036-11-02 06:00:00", "2037-03-08 07:00:00", 
"2037-11-01 06:00:00"), offSet = c(-18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L, -14400L, -18000L, -14400L, 
-18000L, -14400L, -18000L, -14400L, -18000L, -14400L, -18000L, 
-14400L, -18000L, -14400L, -18000L), isdst = c(0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L), TimeZone = c("EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EPT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", 
"EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", "EST", "EDT", 
"EST"), numeric = c(-2147397248, -1632070800, -1614794400, -1601753400, 
-1583697600, -1567357200, -1554667200, -1534698000, -1524074400, 
-1503248400, -1492365600, -1471798800, -1460916000, -1440954000, 
-1428861600, -1409504400, -1397412000, -1378054800, -1365962400, 
-1346605200, -1333908000, -1315155600, -1301853600, -1283706000, 
-1270404000, -1252256400, -1238954400, -1220806800, -1207504800, 
-1188752400, -1176055200, -1157302800, -1144000800, -1125853200, 
-1112551200, -1094403600, -1081101600, -1062954000, -1049652000, 
-1031504400, -1018202400, -1000054800, -986752800, -968000400, 
-955303200, -769395600, -765396000, -747248400, -733946400, -715806000, 
-702504000, -684356400, -671054400, -652906800, -634161600, -620845200, 
-602704800, -589395600, -576093600, -557946000, -544644000, -526496400, 
-513194400, -495046800, -481744800, -463597200, -450295200, -431542800, 
-418240800, -400093200, -384372000, -368643600, -352922400, -337194000, 
-321472800, -305744400, -289418400, -273690000, -257968800, -242240400, 
-226519200, -210790800, -195069600, -179341200, -163620000, -147891600, 
-131565600, -116442000, -100116000, -84387600, -68666400, -52938000, 
-37216800, -21488400, -5767200, 9961200, 25682400, 41410800, 
57736800, 73465200, 89186400, 104914800, 120636000, 136364400, 
152085600, 167814000, 183535200, 199263600, 215589600, 230713200, 
247039200, 262767600, 278488800, 294217200, 309938400, 325666800, 
341388000, 357116400, 372837600, 388566000, 404892000, 420015600, 
436341600, 452070000, 467791200, 483519600, 499240800, 514969200, 
530690400, 544604400, 562140000, 576054000, 594194400, 607503600, 
625644000, 638953200, 657093600, 671007600, 688543200, 702457200, 
719992800, 733906800, 752047200, 765356400, 783496800, 796806000, 
814946400, 828860400, 846396000, 860310000, 877845600, 891759600, 
909295200, 923209200, 941349600, 954658800, 972799200, 986108400, 
1004248800, 1018162800, 1035698400, 1049612400, 1067148000, 1081062000, 
1099202400, 1112511600, 1130652000, 1143961200, 1162101600, 1173596400, 
1194156000, 1205046000, 1225605600, 1236495600, 1257055200, 1268550000, 
1289109600, 1299999600, 1320559200, 1331449200, 1352008800, 1362898800, 
1383458400, 1394348400, 1414908000, 1425798000, 1446357600, 1457852400, 
1478412000, 1489302000, 1509861600, 1520751600, 1541311200, 1552201200, 
1572760800, 1583650800, 1604210400, 1615705200, 1636264800, 1647154800, 
1667714400, 1678604400, 1699164000, 1710054000, 1730613600, 1741503600, 
1762063200, 1772953200, 1793512800, 1805007600, 1825567200, 1836457200, 
1857016800, 1867906800, 1888466400, 1899356400, 1919916000, 1930806000, 
1951365600, 1962860400, 1983420000, 1994310000, 2014869600, 2025759600, 
2046319200, 2057209200, 2077768800, 2088658800, 2109218400, 2120108400, 
2140668000)), .Names = c("Toronto", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -231L), class = "data.frame")
}

"Tortola" <- function () {
structure(list(Tortola = c("1901-12-14 20:45:52", "1911-07-01 04:18:28"
), offSet = c(-15508L, -14400L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"AST"), numeric = c(-2147397248, -1846266092)), .Names = c("Tortola", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Vancouver" <- function () {
structure(list(Vancouver = c("1901-12-14 20:45:52", "1918-04-14 10:00:00", 
"1918-10-31 09:00:00", "1945-08-14 23:00:00", "1945-09-30 09:00:00", 
"1946-04-28 10:00:00", "1946-10-13 09:00:00", "1947-04-27 10:00:00", 
"1947-09-28 09:00:00", "1948-04-25 10:00:00", "1948-09-26 09:00:00", 
"1949-04-24 10:00:00", "1949-09-25 09:00:00", "1950-04-30 10:00:00", 
"1950-09-24 09:00:00", "1951-04-29 10:00:00", "1951-09-30 09:00:00", 
"1952-04-27 10:00:00", "1952-09-28 09:00:00", "1953-04-26 10:00:00", 
"1953-09-27 09:00:00", "1954-04-25 10:00:00", "1954-09-26 09:00:00", 
"1955-04-24 10:00:00", "1955-09-25 09:00:00", "1956-04-29 10:00:00", 
"1956-09-30 09:00:00", "1957-04-28 10:00:00", "1957-09-29 09:00:00", 
"1958-04-27 10:00:00", "1958-09-28 09:00:00", "1959-04-26 10:00:00", 
"1959-09-27 09:00:00", "1960-04-24 10:00:00", "1960-09-25 09:00:00", 
"1961-04-30 10:00:00", "1961-09-24 09:00:00", "1962-04-29 10:00:00", 
"1962-10-28 09:00:00", "1963-04-28 10:00:00", "1963-10-27 09:00:00", 
"1964-04-26 10:00:00", "1964-10-25 09:00:00", "1965-04-25 10:00:00", 
"1965-10-31 09:00:00", "1966-04-24 10:00:00", "1966-10-30 09:00:00", 
"1967-04-30 10:00:00", "1967-10-29 09:00:00", "1968-04-28 10:00:00", 
"1968-10-27 09:00:00", "1969-04-27 10:00:00", "1969-10-26 09:00:00", 
"1970-04-26 10:00:00", "1970-10-25 09:00:00", "1971-04-25 10:00:00", 
"1971-10-31 09:00:00", "1972-04-30 10:00:00", "1972-10-29 09:00:00", 
"1973-04-29 10:00:00", "1973-10-28 09:00:00", "1974-04-28 10:00:00", 
"1974-10-27 09:00:00", "1975-04-27 10:00:00", "1975-10-26 09:00:00", 
"1976-04-25 10:00:00", "1976-10-31 09:00:00", "1977-04-24 10:00:00", 
"1977-10-30 09:00:00", "1978-04-30 10:00:00", "1978-10-29 09:00:00", 
"1979-04-29 10:00:00", "1979-10-28 09:00:00", "1980-04-27 10:00:00", 
"1980-10-26 09:00:00", "1981-04-26 10:00:00", "1981-10-25 09:00:00", 
"1982-04-25 10:00:00", "1982-10-31 09:00:00", "1983-04-24 10:00:00", 
"1983-10-30 09:00:00", "1984-04-29 10:00:00", "1984-10-28 09:00:00", 
"1985-04-28 10:00:00", "1985-10-27 09:00:00", "1986-04-27 10:00:00", 
"1986-10-26 09:00:00", "1987-04-05 10:00:00", "1987-10-25 09:00:00", 
"1988-04-03 10:00:00", "1988-10-30 09:00:00", "1989-04-02 10:00:00", 
"1989-10-29 09:00:00", "1990-04-01 10:00:00", "1990-10-28 09:00:00", 
"1991-04-07 10:00:00", "1991-10-27 09:00:00", "1992-04-05 10:00:00", 
"1992-10-25 09:00:00", "1993-04-04 10:00:00", "1993-10-31 09:00:00", 
"1994-04-03 10:00:00", "1994-10-30 09:00:00", "1995-04-02 10:00:00", 
"1995-10-29 09:00:00", "1996-04-07 10:00:00", "1996-10-27 09:00:00", 
"1997-04-06 10:00:00", "1997-10-26 09:00:00", "1998-04-05 10:00:00", 
"1998-10-25 09:00:00", "1999-04-04 10:00:00", "1999-10-31 09:00:00", 
"2000-04-02 10:00:00", "2000-10-29 09:00:00", "2001-04-01 10:00:00", 
"2001-10-28 09:00:00", "2002-04-07 10:00:00", "2002-10-27 09:00:00", 
"2003-04-06 10:00:00", "2003-10-26 09:00:00", "2004-04-04 10:00:00", 
"2004-10-31 09:00:00", "2005-04-03 10:00:00", "2005-10-30 09:00:00", 
"2006-04-02 10:00:00", "2006-10-29 09:00:00", "2007-03-11 10:00:00", 
"2007-11-04 09:00:00", "2008-03-09 10:00:00", "2008-11-02 09:00:00", 
"2009-03-08 10:00:00", "2009-11-01 09:00:00", "2010-03-14 10:00:00", 
"2010-11-07 09:00:00", "2011-03-13 10:00:00", "2011-11-06 09:00:00", 
"2012-03-11 10:00:00", "2012-11-04 09:00:00", "2013-03-10 10:00:00", 
"2013-11-03 09:00:00", "2014-03-09 10:00:00", "2014-11-02 09:00:00", 
"2015-03-08 10:00:00", "2015-11-01 09:00:00", "2016-03-13 10:00:00", 
"2016-11-06 09:00:00", "2017-03-12 10:00:00", "2017-11-05 09:00:00", 
"2018-03-11 10:00:00", "2018-11-04 09:00:00", "2019-03-10 10:00:00", 
"2019-11-03 09:00:00", "2020-03-08 10:00:00", "2020-11-01 09:00:00", 
"2021-03-14 10:00:00", "2021-11-07 09:00:00", "2022-03-13 10:00:00", 
"2022-11-06 09:00:00", "2023-03-12 10:00:00", "2023-11-05 09:00:00", 
"2024-03-10 10:00:00", "2024-11-03 09:00:00", "2025-03-09 10:00:00", 
"2025-11-02 09:00:00", "2026-03-08 10:00:00", "2026-11-01 09:00:00", 
"2027-03-14 10:00:00", "2027-11-07 09:00:00", "2028-03-12 10:00:00", 
"2028-11-05 09:00:00", "2029-03-11 10:00:00", "2029-11-04 09:00:00", 
"2030-03-10 10:00:00", "2030-11-03 09:00:00", "2031-03-09 10:00:00", 
"2031-11-02 09:00:00", "2032-03-14 10:00:00", "2032-11-07 09:00:00", 
"2033-03-13 10:00:00", "2033-11-06 09:00:00", "2034-03-12 10:00:00", 
"2034-11-05 09:00:00", "2035-03-11 10:00:00", "2035-11-04 09:00:00", 
"2036-03-09 10:00:00", "2036-11-02 09:00:00", "2037-03-08 10:00:00", 
"2037-11-01 09:00:00"), offSet = c(-28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L), isdst = c(0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("PST", "PDT", 
"PST", "PPT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST"), numeric = c(-2147397248, 
-1632060000, -1614783600, -769395600, -765385200, -747237600, 
-732726000, -715788000, -702486000, -684338400, -671036400, -652888800, 
-639586800, -620834400, -608137200, -589384800, -576082800, -557935200, 
-544633200, -526485600, -513183600, -495036000, -481734000, -463586400, 
-450284400, -431532000, -418230000, -400082400, -386780400, -368632800, 
-355330800, -337183200, -323881200, -305733600, -292431600, -273679200, 
-260982000, -242229600, -226508400, -210780000, -195058800, -179330400, 
-163609200, -147880800, -131554800, -116431200, -100105200, -84376800, 
-68655600, -52927200, -37206000, -21477600, -5756400, 9972000, 
25693200, 41421600, 57747600, 73476000, 89197200, 104925600, 
120646800, 136375200, 152096400, 167824800, 183546000, 199274400, 
215600400, 230724000, 247050000, 262778400, 278499600, 294228000, 
309949200, 325677600, 341398800, 357127200, 372848400, 388576800, 
404902800, 420026400, 436352400, 452080800, 467802000, 483530400, 
499251600, 514980000, 530701200, 544615200, 562150800, 576064800, 
594205200, 607514400, 625654800, 638964000, 657104400, 671018400, 
688554000, 702468000, 720003600, 733917600, 752058000, 765367200, 
783507600, 796816800, 814957200, 828871200, 846406800, 860320800, 
877856400, 891770400, 909306000, 923220000, 941360400, 954669600, 
972810000, 986119200, 1004259600, 1018173600, 1035709200, 1049623200, 
1067158800, 1081072800, 1099213200, 1112522400, 1130662800, 1143972000, 
1162112400, 1173607200, 1194166800, 1205056800, 1225616400, 1236506400, 
1257066000, 1268560800, 1289120400, 1300010400, 1320570000, 1331460000, 
1352019600, 1362909600, 1383469200, 1394359200, 1414918800, 1425808800, 
1446368400, 1457863200, 1478422800, 1489312800, 1509872400, 1520762400, 
1541322000, 1552212000, 1572771600, 1583661600, 1604221200, 1615716000, 
1636275600, 1647165600, 1667725200, 1678615200, 1699174800, 1710064800, 
1730624400, 1741514400, 1762074000, 1772964000, 1793523600, 1805018400, 
1825578000, 1836468000, 1857027600, 1867917600, 1888477200, 1899367200, 
1919926800, 1930816800, 1951376400, 1962871200, 1983430800, 1994320800, 
2014880400, 2025770400, 2046330000, 2057220000, 2077779600, 2088669600, 
2109229200, 2120119200, 2140678800)), .Names = c("Vancouver", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-189L), class = "data.frame")
}

"Whitehorse" <- function () {
structure(list(Whitehorse = c("1901-12-14 20:45:52", "1918-04-14 11:00:00", 
"1918-10-27 10:00:00", "1919-05-25 11:00:00", "1919-11-01 08:00:00", 
"1945-08-14 23:00:00", "1945-09-30 10:00:00", "1965-04-25 09:00:00", 
"1965-10-31 09:00:00", "1966-07-01 11:00:00", "1980-04-27 10:00:00", 
"1980-10-26 09:00:00", "1981-04-26 10:00:00", "1981-10-25 09:00:00", 
"1982-04-25 10:00:00", "1982-10-31 09:00:00", "1983-04-24 10:00:00", 
"1983-10-30 09:00:00", "1984-04-29 10:00:00", "1984-10-28 09:00:00", 
"1985-04-28 10:00:00", "1985-10-27 09:00:00", "1986-04-27 10:00:00", 
"1986-10-26 09:00:00", "1987-04-05 10:00:00", "1987-10-25 09:00:00", 
"1988-04-03 10:00:00", "1988-10-30 09:00:00", "1989-04-02 10:00:00", 
"1989-10-29 09:00:00", "1990-04-01 10:00:00", "1990-10-28 09:00:00", 
"1991-04-07 10:00:00", "1991-10-27 09:00:00", "1992-04-05 10:00:00", 
"1992-10-25 09:00:00", "1993-04-04 10:00:00", "1993-10-31 09:00:00", 
"1994-04-03 10:00:00", "1994-10-30 09:00:00", "1995-04-02 10:00:00", 
"1995-10-29 09:00:00", "1996-04-07 10:00:00", "1996-10-27 09:00:00", 
"1997-04-06 10:00:00", "1997-10-26 09:00:00", "1998-04-05 10:00:00", 
"1998-10-25 09:00:00", "1999-04-04 10:00:00", "1999-10-31 09:00:00", 
"2000-04-02 10:00:00", "2000-10-29 09:00:00", "2001-04-01 10:00:00", 
"2001-10-28 09:00:00", "2002-04-07 10:00:00", "2002-10-27 09:00:00", 
"2003-04-06 10:00:00", "2003-10-26 09:00:00", "2004-04-04 10:00:00", 
"2004-10-31 09:00:00", "2005-04-03 10:00:00", "2005-10-30 09:00:00", 
"2006-04-02 10:00:00", "2006-10-29 09:00:00", "2007-03-11 10:00:00", 
"2007-11-04 09:00:00", "2008-03-09 10:00:00", "2008-11-02 09:00:00", 
"2009-03-08 10:00:00", "2009-11-01 09:00:00", "2010-03-14 10:00:00", 
"2010-11-07 09:00:00", "2011-03-13 10:00:00", "2011-11-06 09:00:00", 
"2012-03-11 10:00:00", "2012-11-04 09:00:00", "2013-03-10 10:00:00", 
"2013-11-03 09:00:00", "2014-03-09 10:00:00", "2014-11-02 09:00:00", 
"2015-03-08 10:00:00", "2015-11-01 09:00:00", "2016-03-13 10:00:00", 
"2016-11-06 09:00:00", "2017-03-12 10:00:00", "2017-11-05 09:00:00", 
"2018-03-11 10:00:00", "2018-11-04 09:00:00", "2019-03-10 10:00:00", 
"2019-11-03 09:00:00", "2020-03-08 10:00:00", "2020-11-01 09:00:00", 
"2021-03-14 10:00:00", "2021-11-07 09:00:00", "2022-03-13 10:00:00", 
"2022-11-06 09:00:00", "2023-03-12 10:00:00", "2023-11-05 09:00:00", 
"2024-03-10 10:00:00", "2024-11-03 09:00:00", "2025-03-09 10:00:00", 
"2025-11-02 09:00:00", "2026-03-08 10:00:00", "2026-11-01 09:00:00", 
"2027-03-14 10:00:00", "2027-11-07 09:00:00", "2028-03-12 10:00:00", 
"2028-11-05 09:00:00", "2029-03-11 10:00:00", "2029-11-04 09:00:00", 
"2030-03-10 10:00:00", "2030-11-03 09:00:00", "2031-03-09 10:00:00", 
"2031-11-02 09:00:00", "2032-03-14 10:00:00", "2032-11-07 09:00:00", 
"2033-03-13 10:00:00", "2033-11-06 09:00:00", "2034-03-12 10:00:00", 
"2034-11-05 09:00:00", "2035-03-11 10:00:00", "2035-11-04 09:00:00", 
"2036-03-09 10:00:00", "2036-11-02 09:00:00", "2037-03-08 10:00:00", 
"2037-11-01 09:00:00"), offSet = c(-32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -25200L, -32400L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L, -25200L, -28800L, -25200L, 
-28800L, -25200L, -28800L, -25200L, -28800L, -25200L, -28800L, 
-25200L, -28800L, -25200L, -28800L), isdst = c(0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("YST", 
"YDT", "YST", "YDT", "YST", "YPT", "YST", "YDDT", "YST", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", 
"PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST", 
"PDT", "PST", "PDT", "PST", "PDT", "PST", "PDT", "PST"), numeric = c(-2147397248, 
-1632056400, -1615125600, -1596978000, -1583164800, -769395600, 
-765381600, -147884400, -131554800, -110552400, 325677600, 341398800, 
357127200, 372848400, 388576800, 404902800, 420026400, 436352400, 
452080800, 467802000, 483530400, 499251600, 514980000, 530701200, 
544615200, 562150800, 576064800, 594205200, 607514400, 625654800, 
638964000, 657104400, 671018400, 688554000, 702468000, 720003600, 
733917600, 752058000, 765367200, 783507600, 796816800, 814957200, 
828871200, 846406800, 860320800, 877856400, 891770400, 909306000, 
923220000, 941360400, 954669600, 972810000, 986119200, 1004259600, 
1018173600, 1035709200, 1049623200, 1067158800, 1081072800, 1099213200, 
1112522400, 1130662800, 1143972000, 1162112400, 1173607200, 1194166800, 
1205056800, 1225616400, 1236506400, 1257066000, 1268560800, 1289120400, 
1300010400, 1320570000, 1331460000, 1352019600, 1362909600, 1383469200, 
1394359200, 1414918800, 1425808800, 1446368400, 1457863200, 1478422800, 
1489312800, 1509872400, 1520762400, 1541322000, 1552212000, 1572771600, 
1583661600, 1604221200, 1615716000, 1636275600, 1647165600, 1667725200, 
1678615200, 1699174800, 1710064800, 1730624400, 1741514400, 1762074000, 
1772964000, 1793523600, 1805018400, 1825578000, 1836468000, 1857027600, 
1867917600, 1888477200, 1899367200, 1919926800, 1930816800, 1951376400, 
1962871200, 1983430800, 1994320800, 2014880400, 2025770400, 2046330000, 
2057220000, 2077779600, 2088669600, 2109229200, 2120119200, 2140678800
)), .Names = c("Whitehorse", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -126L), class = "data.frame")
}

"Winnipeg" <- function () {
structure(list(Winnipeg = c("1901-12-14 20:45:52", "1916-04-23 06:00:00", 
"1916-09-17 05:00:00", "1918-04-14 08:00:00", "1918-10-31 07:00:00", 
"1937-05-16 08:00:00", "1937-09-26 07:00:00", "1945-08-14 23:00:00", 
"1945-09-30 07:00:00", "1946-05-12 08:00:00", "1946-10-13 07:00:00", 
"1947-04-27 08:00:00", "1947-09-28 07:00:00", "1948-04-25 08:00:00", 
"1948-09-26 07:00:00", "1949-04-24 08:00:00", "1949-09-25 07:00:00", 
"1950-05-01 08:00:00", "1950-09-30 07:00:00", "1951-04-29 08:00:00", 
"1951-09-30 07:00:00", "1952-04-27 08:00:00", "1952-09-28 07:00:00", 
"1953-04-26 08:00:00", "1953-09-27 07:00:00", "1954-04-25 08:00:00", 
"1954-09-26 07:00:00", "1955-04-24 08:00:00", "1955-09-25 07:00:00", 
"1956-04-29 08:00:00", "1956-09-30 07:00:00", "1957-04-28 08:00:00", 
"1957-09-29 07:00:00", "1958-04-27 08:00:00", "1958-09-28 07:00:00", 
"1959-04-26 08:00:00", "1959-10-25 07:00:00", "1960-04-24 08:00:00", 
"1960-09-25 07:00:00", "1963-04-28 08:00:00", "1963-09-22 07:00:00", 
"1966-04-24 08:00:00", "1966-10-30 08:00:00", "1967-04-30 08:00:00", 
"1967-10-29 08:00:00", "1968-04-28 08:00:00", "1968-10-27 08:00:00", 
"1969-04-27 08:00:00", "1969-10-26 08:00:00", "1970-04-26 08:00:00", 
"1970-10-25 08:00:00", "1971-04-25 08:00:00", "1971-10-31 08:00:00", 
"1972-04-30 08:00:00", "1972-10-29 08:00:00", "1973-04-29 08:00:00", 
"1973-10-28 08:00:00", "1974-04-28 08:00:00", "1974-10-27 08:00:00", 
"1975-04-27 08:00:00", "1975-10-26 08:00:00", "1976-04-25 08:00:00", 
"1976-10-31 08:00:00", "1977-04-24 08:00:00", "1977-10-30 08:00:00", 
"1978-04-30 08:00:00", "1978-10-29 08:00:00", "1979-04-29 08:00:00", 
"1979-10-28 08:00:00", "1980-04-27 08:00:00", "1980-10-26 08:00:00", 
"1981-04-26 08:00:00", "1981-10-25 08:00:00", "1982-04-25 08:00:00", 
"1982-10-31 08:00:00", "1983-04-24 08:00:00", "1983-10-30 08:00:00", 
"1984-04-29 08:00:00", "1984-10-28 08:00:00", "1985-04-28 08:00:00", 
"1985-10-27 08:00:00", "1986-04-27 08:00:00", "1986-10-26 08:00:00", 
"1987-04-05 08:00:00", "1987-10-25 08:00:00", "1988-04-03 08:00:00", 
"1988-10-30 08:00:00", "1989-04-02 08:00:00", "1989-10-29 08:00:00", 
"1990-04-01 08:00:00", "1990-10-28 08:00:00", "1991-04-07 08:00:00", 
"1991-10-27 08:00:00", "1992-04-05 08:00:00", "1992-10-25 08:00:00", 
"1993-04-04 08:00:00", "1993-10-31 08:00:00", "1994-04-03 08:00:00", 
"1994-10-30 08:00:00", "1995-04-02 08:00:00", "1995-10-29 08:00:00", 
"1996-04-07 08:00:00", "1996-10-27 08:00:00", "1997-04-06 08:00:00", 
"1997-10-26 08:00:00", "1998-04-05 08:00:00", "1998-10-25 08:00:00", 
"1999-04-04 08:00:00", "1999-10-31 08:00:00", "2000-04-02 08:00:00", 
"2000-10-29 08:00:00", "2001-04-01 08:00:00", "2001-10-28 08:00:00", 
"2002-04-07 08:00:00", "2002-10-27 08:00:00", "2003-04-06 08:00:00", 
"2003-10-26 08:00:00", "2004-04-04 08:00:00", "2004-10-31 08:00:00", 
"2005-04-03 08:00:00", "2005-10-30 08:00:00", "2006-04-02 08:00:00", 
"2006-10-29 07:00:00", "2007-03-11 08:00:00", "2007-11-04 07:00:00", 
"2008-03-09 08:00:00", "2008-11-02 07:00:00", "2009-03-08 08:00:00", 
"2009-11-01 07:00:00", "2010-03-14 08:00:00", "2010-11-07 07:00:00", 
"2011-03-13 08:00:00", "2011-11-06 07:00:00", "2012-03-11 08:00:00", 
"2012-11-04 07:00:00", "2013-03-10 08:00:00", "2013-11-03 07:00:00", 
"2014-03-09 08:00:00", "2014-11-02 07:00:00", "2015-03-08 08:00:00", 
"2015-11-01 07:00:00", "2016-03-13 08:00:00", "2016-11-06 07:00:00", 
"2017-03-12 08:00:00", "2017-11-05 07:00:00", "2018-03-11 08:00:00", 
"2018-11-04 07:00:00", "2019-03-10 08:00:00", "2019-11-03 07:00:00", 
"2020-03-08 08:00:00", "2020-11-01 07:00:00", "2021-03-14 08:00:00", 
"2021-11-07 07:00:00", "2022-03-13 08:00:00", "2022-11-06 07:00:00", 
"2023-03-12 08:00:00", "2023-11-05 07:00:00", "2024-03-10 08:00:00", 
"2024-11-03 07:00:00", "2025-03-09 08:00:00", "2025-11-02 07:00:00", 
"2026-03-08 08:00:00", "2026-11-01 07:00:00", "2027-03-14 08:00:00", 
"2027-11-07 07:00:00", "2028-03-12 08:00:00", "2028-11-05 07:00:00", 
"2029-03-11 08:00:00", "2029-11-04 07:00:00", "2030-03-10 08:00:00", 
"2030-11-03 07:00:00", "2031-03-09 08:00:00", "2031-11-02 07:00:00", 
"2032-03-14 08:00:00", "2032-11-07 07:00:00", "2033-03-13 08:00:00", 
"2033-11-06 07:00:00", "2034-03-12 08:00:00", "2034-11-05 07:00:00", 
"2035-03-11 08:00:00", "2035-11-04 07:00:00", "2036-03-09 08:00:00", 
"2036-11-02 07:00:00", "2037-03-08 08:00:00", "2037-11-01 07:00:00"
), offSet = c(-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L, -18000L, -21600L, -18000L, 
-21600L, -18000L, -21600L, -18000L, -21600L, -18000L, -21600L, 
-18000L, -21600L, -18000L, -21600L), isdst = c(0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L), TimeZone = c("CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CPT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST"), numeric = c(-2147397248, -1694368800, -1681671600, -1632067200, 
-1614790800, -1029686400, -1018198800, -769395600, -765392400, 
-746035200, -732733200, -715795200, -702493200, -684345600, -671043600, 
-652896000, -639594000, -620755200, -607626000, -589392000, -576090000, 
-557942400, -544640400, -526492800, -513190800, -495043200, -481741200, 
-463593600, -450291600, -431539200, -418237200, -400089600, -386787600, 
-368640000, -355338000, -337190400, -321469200, -305740800, -292438800, 
-210787200, -198090000, -116438400, -100108800, -84384000, -68659200, 
-52934400, -37209600, -21484800, -5760000, 9964800, 25689600, 
41414400, 57744000, 73468800, 89193600, 104918400, 120643200, 
136368000, 152092800, 167817600, 183542400, 199267200, 215596800, 
230716800, 247046400, 262771200, 278496000, 294220800, 309945600, 
325670400, 341395200, 357120000, 372844800, 388569600, 404899200, 
420019200, 436348800, 452073600, 467798400, 483523200, 499248000, 
514972800, 530697600, 544608000, 562147200, 576057600, 594201600, 
607507200, 625651200, 638956800, 657100800, 671011200, 688550400, 
702460800, 7.2e+08, 733910400, 752054400, 765360000, 783504000, 
796809600, 814953600, 828864000, 846403200, 860313600, 877852800, 
891763200, 909302400, 923212800, 941356800, 954662400, 972806400, 
986112000, 1004256000, 1018166400, 1035705600, 1049616000, 1067155200, 
1081065600, 1099209600, 1112515200, 1130659200, 1143964800, 1162105200, 
1173600000, 1194159600, 1205049600, 1225609200, 1236499200, 1257058800, 
1268553600, 1289113200, 1300003200, 1320562800, 1331452800, 1352012400, 
1362902400, 1383462000, 1394352000, 1414911600, 1425801600, 1446361200, 
1457856000, 1478415600, 1489305600, 1509865200, 1520755200, 1541314800, 
1552204800, 1572764400, 1583654400, 1604214000, 1615708800, 1636268400, 
1647158400, 1667718000, 1678608000, 1699167600, 1710057600, 1730617200, 
1741507200, 1762066800, 1772956800, 1793516400, 1805011200, 1825570800, 
1836460800, 1857020400, 1867910400, 1888470000, 1899360000, 1919919600, 
1930809600, 1951369200, 1962864000, 1983423600, 1994313600, 2014873200, 
2025763200, 2046322800, 2057212800, 2077772400, 2088662400, 2109222000, 
2120112000, 2140671600)), .Names = c("Winnipeg", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -185L), class = "data.frame")
}

"Yakutat" <- function () {
structure(list(Yakutat = c("1901-12-14 20:45:52", "1945-08-14 23:00:00", 
"1945-09-30 10:00:00", "1969-04-27 11:00:00", "1969-10-26 10:00:00", 
"1970-04-26 11:00:00", "1970-10-25 10:00:00", "1971-04-25 11:00:00", 
"1971-10-31 10:00:00", "1972-04-30 11:00:00", "1972-10-29 10:00:00", 
"1973-04-29 11:00:00", "1973-10-28 10:00:00", "1974-01-06 11:00:00", 
"1974-10-27 10:00:00", "1975-02-23 11:00:00", "1975-10-26 10:00:00", 
"1976-04-25 11:00:00", "1976-10-31 10:00:00", "1977-04-24 11:00:00", 
"1977-10-30 10:00:00", "1978-04-30 11:00:00", "1978-10-29 10:00:00", 
"1979-04-29 11:00:00", "1979-10-28 10:00:00", "1980-04-27 11:00:00", 
"1980-10-26 10:00:00", "1981-04-26 11:00:00", "1981-10-25 10:00:00", 
"1982-04-25 11:00:00", "1982-10-31 10:00:00", "1983-04-24 11:00:00", 
"1983-11-30 09:00:00", "1984-04-29 11:00:00", "1984-10-28 10:00:00", 
"1985-04-28 11:00:00", "1985-10-27 10:00:00", "1986-04-27 11:00:00", 
"1986-10-26 10:00:00", "1987-04-05 11:00:00", "1987-10-25 10:00:00", 
"1988-04-03 11:00:00", "1988-10-30 10:00:00", "1989-04-02 11:00:00", 
"1989-10-29 10:00:00", "1990-04-01 11:00:00", "1990-10-28 10:00:00", 
"1991-04-07 11:00:00", "1991-10-27 10:00:00", "1992-04-05 11:00:00", 
"1992-10-25 10:00:00", "1993-04-04 11:00:00", "1993-10-31 10:00:00", 
"1994-04-03 11:00:00", "1994-10-30 10:00:00", "1995-04-02 11:00:00", 
"1995-10-29 10:00:00", "1996-04-07 11:00:00", "1996-10-27 10:00:00", 
"1997-04-06 11:00:00", "1997-10-26 10:00:00", "1998-04-05 11:00:00", 
"1998-10-25 10:00:00", "1999-04-04 11:00:00", "1999-10-31 10:00:00", 
"2000-04-02 11:00:00", "2000-10-29 10:00:00", "2001-04-01 11:00:00", 
"2001-10-28 10:00:00", "2002-04-07 11:00:00", "2002-10-27 10:00:00", 
"2003-04-06 11:00:00", "2003-10-26 10:00:00", "2004-04-04 11:00:00", 
"2004-10-31 10:00:00", "2005-04-03 11:00:00", "2005-10-30 10:00:00", 
"2006-04-02 11:00:00", "2006-10-29 10:00:00", "2007-03-11 11:00:00", 
"2007-11-04 10:00:00", "2008-03-09 11:00:00", "2008-11-02 10:00:00", 
"2009-03-08 11:00:00", "2009-11-01 10:00:00", "2010-03-14 11:00:00", 
"2010-11-07 10:00:00", "2011-03-13 11:00:00", "2011-11-06 10:00:00", 
"2012-03-11 11:00:00", "2012-11-04 10:00:00", "2013-03-10 11:00:00", 
"2013-11-03 10:00:00", "2014-03-09 11:00:00", "2014-11-02 10:00:00", 
"2015-03-08 11:00:00", "2015-11-01 10:00:00", "2016-03-13 11:00:00", 
"2016-11-06 10:00:00", "2017-03-12 11:00:00", "2017-11-05 10:00:00", 
"2018-03-11 11:00:00", "2018-11-04 10:00:00", "2019-03-10 11:00:00", 
"2019-11-03 10:00:00", "2020-03-08 11:00:00", "2020-11-01 10:00:00", 
"2021-03-14 11:00:00", "2021-11-07 10:00:00", "2022-03-13 11:00:00", 
"2022-11-06 10:00:00", "2023-03-12 11:00:00", "2023-11-05 10:00:00", 
"2024-03-10 11:00:00", "2024-11-03 10:00:00", "2025-03-09 11:00:00", 
"2025-11-02 10:00:00", "2026-03-08 11:00:00", "2026-11-01 10:00:00", 
"2027-03-14 11:00:00", "2027-11-07 10:00:00", "2028-03-12 11:00:00", 
"2028-11-05 10:00:00", "2029-03-11 11:00:00", "2029-11-04 10:00:00", 
"2030-03-10 11:00:00", "2030-11-03 10:00:00", "2031-03-09 11:00:00", 
"2031-11-02 10:00:00", "2032-03-14 11:00:00", "2032-11-07 10:00:00", 
"2033-03-13 11:00:00", "2033-11-06 10:00:00", "2034-03-12 11:00:00", 
"2034-11-05 10:00:00", "2035-03-11 11:00:00", "2035-11-04 10:00:00", 
"2036-03-09 11:00:00", "2036-11-02 10:00:00", "2037-03-08 11:00:00", 
"2037-11-01 10:00:00"), offSet = c(-32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L, -28800L, -32400L, 
-28800L, -32400L, -28800L, -32400L, -28800L, -32400L, -28800L, 
-32400L, -28800L, -32400L, -28800L, -32400L), isdst = c(0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("YST", 
"YPT", "YST", "YDT", "YST", "YDT", "YST", "YDT", "YST", "YDT", 
"YST", "YDT", "YST", "YDT", "YST", "YDT", "YST", "YDT", "YST", 
"YDT", "YST", "YDT", "YST", "YDT", "YST", "YDT", "YST", "YDT", 
"YST", "YDT", "YST", "YDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", 
"AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST", "AKDT", "AKST"
), numeric = c(-2147397248, -769395600, -765381600, -21474000, 
-5752800, 9975600, 25696800, 41425200, 57751200, 73479600, 89200800, 
104929200, 120650400, 126702000, 152100000, 162385200, 183549600, 
199278000, 215604000, 230727600, 247053600, 262782000, 278503200, 
294231600, 309952800, 325681200, 341402400, 357130800, 372852000, 
388580400, 404906400, 420030000, 439030800, 452084400, 467805600, 
483534000, 499255200, 514983600, 530704800, 544618800, 562154400, 
576068400, 594208800, 607518000, 625658400, 638967600, 657108000, 
671022000, 688557600, 702471600, 720007200, 733921200, 752061600, 
765370800, 783511200, 796820400, 814960800, 828874800, 846410400, 
860324400, 877860000, 891774000, 909309600, 923223600, 941364000, 
954673200, 972813600, 986122800, 1004263200, 1018177200, 1035712800, 
1049626800, 1067162400, 1081076400, 1099216800, 1112526000, 1130666400, 
1143975600, 1162116000, 1173610800, 1194170400, 1205060400, 1225620000, 
1236510000, 1257069600, 1268564400, 1289124000, 1300014000, 1320573600, 
1331463600, 1352023200, 1362913200, 1383472800, 1394362800, 1414922400, 
1425812400, 1446372000, 1457866800, 1478426400, 1489316400, 1509876000, 
1520766000, 1541325600, 1552215600, 1572775200, 1583665200, 1604224800, 
1615719600, 1636279200, 1647169200, 1667728800, 1678618800, 1699178400, 
1710068400, 1730628000, 1741518000, 1762077600, 1772967600, 1793527200, 
1805022000, 1825581600, 1836471600, 1857031200, 1867921200, 1888480800, 
1899370800, 1919930400, 1930820400, 1951380000, 1962874800, 1983434400, 
1994324400, 2014884000, 2025774000, 2046333600, 2057223600, 2077783200, 
2088673200, 2109232800, 2120122800, 2140682400)), .Names = c("Yakutat", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-141L), class = "data.frame")
}

"Yellowknife" <- function () {
structure(list(Yellowknife = c("1901-12-14 20:45:52", "1935-01-01 00:00:00", 
"1945-08-14 23:00:00", "1945-09-30 08:00:00", "1965-04-25 07:00:00", 
"1965-10-31 07:00:00", "1980-04-27 09:00:00", "1980-10-26 08:00:00", 
"1981-04-26 09:00:00", "1981-10-25 08:00:00", "1982-04-25 09:00:00", 
"1982-10-31 08:00:00", "1983-04-24 09:00:00", "1983-10-30 08:00:00", 
"1984-04-29 09:00:00", "1984-10-28 08:00:00", "1985-04-28 09:00:00", 
"1985-10-27 08:00:00", "1986-04-27 09:00:00", "1986-10-26 08:00:00", 
"1987-04-05 09:00:00", "1987-10-25 08:00:00", "1988-04-03 09:00:00", 
"1988-10-30 08:00:00", "1989-04-02 09:00:00", "1989-10-29 08:00:00", 
"1990-04-01 09:00:00", "1990-10-28 08:00:00", "1991-04-07 09:00:00", 
"1991-10-27 08:00:00", "1992-04-05 09:00:00", "1992-10-25 08:00:00", 
"1993-04-04 09:00:00", "1993-10-31 08:00:00", "1994-04-03 09:00:00", 
"1994-10-30 08:00:00", "1995-04-02 09:00:00", "1995-10-29 08:00:00", 
"1996-04-07 09:00:00", "1996-10-27 08:00:00", "1997-04-06 09:00:00", 
"1997-10-26 08:00:00", "1998-04-05 09:00:00", "1998-10-25 08:00:00", 
"1999-04-04 09:00:00", "1999-10-31 08:00:00", "2000-04-02 09:00:00", 
"2000-10-29 08:00:00", "2001-04-01 09:00:00", "2001-10-28 08:00:00", 
"2002-04-07 09:00:00", "2002-10-27 08:00:00", "2003-04-06 09:00:00", 
"2003-10-26 08:00:00", "2004-04-04 09:00:00", "2004-10-31 08:00:00", 
"2005-04-03 09:00:00", "2005-10-30 08:00:00", "2006-04-02 09:00:00", 
"2006-10-29 08:00:00", "2007-03-11 09:00:00", "2007-11-04 08:00:00", 
"2008-03-09 09:00:00", "2008-11-02 08:00:00", "2009-03-08 09:00:00", 
"2009-11-01 08:00:00", "2010-03-14 09:00:00", "2010-11-07 08:00:00", 
"2011-03-13 09:00:00", "2011-11-06 08:00:00", "2012-03-11 09:00:00", 
"2012-11-04 08:00:00", "2013-03-10 09:00:00", "2013-11-03 08:00:00", 
"2014-03-09 09:00:00", "2014-11-02 08:00:00", "2015-03-08 09:00:00", 
"2015-11-01 08:00:00", "2016-03-13 09:00:00", "2016-11-06 08:00:00", 
"2017-03-12 09:00:00", "2017-11-05 08:00:00", "2018-03-11 09:00:00", 
"2018-11-04 08:00:00", "2019-03-10 09:00:00", "2019-11-03 08:00:00", 
"2020-03-08 09:00:00", "2020-11-01 08:00:00", "2021-03-14 09:00:00", 
"2021-11-07 08:00:00", "2022-03-13 09:00:00", "2022-11-06 08:00:00", 
"2023-03-12 09:00:00", "2023-11-05 08:00:00", "2024-03-10 09:00:00", 
"2024-11-03 08:00:00", "2025-03-09 09:00:00", "2025-11-02 08:00:00", 
"2026-03-08 09:00:00", "2026-11-01 08:00:00", "2027-03-14 09:00:00", 
"2027-11-07 08:00:00", "2028-03-12 09:00:00", "2028-11-05 08:00:00", 
"2029-03-11 09:00:00", "2029-11-04 08:00:00", "2030-03-10 09:00:00", 
"2030-11-03 08:00:00", "2031-03-09 09:00:00", "2031-11-02 08:00:00", 
"2032-03-14 09:00:00", "2032-11-07 08:00:00", "2033-03-13 09:00:00", 
"2033-11-06 08:00:00", "2034-03-12 09:00:00", "2034-11-05 08:00:00", 
"2035-03-11 09:00:00", "2035-11-04 08:00:00", "2036-03-09 09:00:00", 
"2036-11-02 08:00:00", "2037-03-08 09:00:00", "2037-11-01 08:00:00"
), offSet = c(0L, -25200L, -21600L, -25200L, -18000L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L, -21600L, -25200L, -21600L, 
-25200L, -21600L, -25200L, -21600L, -25200L, -21600L, -25200L, 
-21600L, -25200L, -21600L, -25200L), isdst = c(0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("zzz", "MST", "MPT", "MST", 
"MDDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", 
"MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", "MST", "MDT", 
"MST"), numeric = c(-2147397248, -1104537600, -769395600, -765388800, 
-147891600, -131562000, 325674000, 341395200, 357123600, 372844800, 
388573200, 404899200, 420022800, 436348800, 452077200, 467798400, 
483526800, 499248000, 514976400, 530697600, 544611600, 562147200, 
576061200, 594201600, 607510800, 625651200, 638960400, 657100800, 
671014800, 688550400, 702464400, 7.2e+08, 733914000, 752054400, 
765363600, 783504000, 796813200, 814953600, 828867600, 846403200, 
860317200, 877852800, 891766800, 909302400, 923216400, 941356800, 
954666000, 972806400, 986115600, 1004256000, 1018170000, 1035705600, 
1049619600, 1067155200, 1081069200, 1099209600, 1112518800, 1130659200, 
1143968400, 1162108800, 1173603600, 1194163200, 1205053200, 1225612800, 
1236502800, 1257062400, 1268557200, 1289116800, 1300006800, 1320566400, 
1331456400, 1352016000, 1362906000, 1383465600, 1394355600, 1414915200, 
1425805200, 1446364800, 1457859600, 1478419200, 1489309200, 1509868800, 
1520758800, 1541318400, 1552208400, 1572768000, 1583658000, 1604217600, 
1615712400, 1636272000, 1647162000, 1667721600, 1678611600, 1699171200, 
1710061200, 1730620800, 1741510800, 1762070400, 1772960400, 1793520000, 
1805014800, 1825574400, 1836464400, 1857024000, 1867914000, 1888473600, 
1899363600, 1919923200, 1930813200, 1951372800, 1962867600, 1983427200, 
1994317200, 2014876800, 2025766800, 2046326400, 2057216400, 2077776000, 
2088666000, 2109225600, 2120115600, 2140675200)), .Names = c("Yellowknife", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-122L), class = "data.frame")
}

"Casey" <- function () {
structure(list(Casey = c("1901-12-14 20:45:52", "1969-01-01 00:00:00"
), offSet = c(0L, 28800L), isdst = c(0L, 0L), TimeZone = c("zzz", 
"WST"), numeric = c(-2147397248, -31536000)), .Names = c("Casey", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Davis" <- function () {
structure(list(Davis = c("1901-12-14 20:45:52", "1957-01-13 00:00:00", 
"1964-10-31 17:00:00", "1969-02-01 00:00:00"), offSet = c(0L, 
25200L, 0L, 25200L), isdst = c(0L, 0L, 0L, 0L), TimeZone = c("zzz", 
"DAVT", "zzz", "DAVT"), numeric = c(-2147397248, -409190400, 
-163062000, -28857600)), .Names = c("Davis", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"DumontDUrville" <- function () {
structure(list(DumontDUrville = c("1901-12-14 20:45:52", "1947-01-01 00:00:00", 
"1952-01-13 14:00:00", "1956-11-01 00:00:00"), offSet = c(0L, 
36000L, 0L, 36000L), isdst = c(0L, 0L, 0L, 0L), TimeZone = c("zzz", 
"PMT", "zzz", "DDUT"), numeric = c(-2147397248, -725846400, -566992800, 
-415497600)), .Names = c("DumontDUrville", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"Mawson" <- function () {
structure(list(Mawson = c("1901-12-14 20:45:52", "1954-02-13 00:00:00"
), offSet = c(0L, 21600L), isdst = c(0L, 0L), TimeZone = c("zzz", 
"MAWT"), numeric = c(-2147397248, -501206400)), .Names = c("Mawson", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"McMurdo" <- function () {
structure(list(McMurdo = c("1901-12-14 20:45:52", "1956-01-01 00:00:00", 
"1974-11-02 14:00:00", "1975-02-22 14:00:00", "1975-10-25 14:00:00", 
"1976-03-06 14:00:00", "1976-10-30 14:00:00", "1977-03-05 14:00:00", 
"1977-10-29 14:00:00", "1978-03-04 14:00:00", "1978-10-28 14:00:00", 
"1979-03-03 14:00:00", "1979-10-27 14:00:00", "1980-03-01 14:00:00", 
"1980-10-25 14:00:00", "1981-02-28 14:00:00", "1981-10-24 14:00:00", 
"1982-03-06 14:00:00", "1982-10-30 14:00:00", "1983-03-05 14:00:00", 
"1983-10-29 14:00:00", "1984-03-03 14:00:00", "1984-10-27 14:00:00", 
"1985-03-02 14:00:00", "1985-10-26 14:00:00", "1986-03-01 14:00:00", 
"1986-10-25 14:00:00", "1987-02-28 14:00:00", "1987-10-24 14:00:00", 
"1988-03-05 14:00:00", "1988-10-29 14:00:00", "1989-03-04 14:00:00", 
"1989-10-07 14:00:00", "1990-03-17 14:00:00", "1990-10-06 14:00:00", 
"1991-03-16 14:00:00", "1991-10-05 14:00:00", "1992-03-14 14:00:00", 
"1992-10-03 14:00:00", "1993-03-20 14:00:00", "1993-10-02 14:00:00", 
"1994-03-19 14:00:00", "1994-10-01 14:00:00", "1995-03-18 14:00:00", 
"1995-09-30 14:00:00", "1996-03-16 14:00:00", "1996-10-05 14:00:00", 
"1997-03-15 14:00:00", "1997-10-04 14:00:00", "1998-03-14 14:00:00", 
"1998-10-03 14:00:00", "1999-03-20 14:00:00", "1999-10-02 14:00:00", 
"2000-03-18 14:00:00", "2000-09-30 14:00:00", "2001-03-17 14:00:00", 
"2001-10-06 14:00:00", "2002-03-16 14:00:00", "2002-10-05 14:00:00", 
"2003-03-15 14:00:00", "2003-10-04 14:00:00", "2004-03-20 14:00:00", 
"2004-10-02 14:00:00", "2005-03-19 14:00:00", "2005-10-01 14:00:00", 
"2006-03-18 14:00:00", "2006-09-30 14:00:00", "2007-03-17 14:00:00", 
"2007-09-29 14:00:00", "2008-04-05 14:00:00", "2008-09-27 14:00:00", 
"2009-04-04 14:00:00", "2009-09-26 14:00:00", "2010-04-03 14:00:00", 
"2010-09-25 14:00:00", "2011-04-02 14:00:00", "2011-09-24 14:00:00", 
"2012-03-31 14:00:00", "2012-09-29 14:00:00", "2013-04-06 14:00:00", 
"2013-09-28 14:00:00", "2014-04-05 14:00:00", "2014-09-27 14:00:00", 
"2015-04-04 14:00:00", "2015-09-26 14:00:00", "2016-04-02 14:00:00", 
"2016-09-24 14:00:00", "2017-04-01 14:00:00", "2017-09-23 14:00:00", 
"2018-03-31 14:00:00", "2018-09-29 14:00:00", "2019-04-06 14:00:00", 
"2019-09-28 14:00:00", "2020-04-04 14:00:00", "2020-09-26 14:00:00", 
"2021-04-03 14:00:00", "2021-09-25 14:00:00", "2022-04-02 14:00:00", 
"2022-09-24 14:00:00", "2023-04-01 14:00:00", "2023-09-23 14:00:00", 
"2024-04-06 14:00:00", "2024-09-28 14:00:00", "2025-04-05 14:00:00", 
"2025-09-27 14:00:00", "2026-04-04 14:00:00", "2026-09-26 14:00:00", 
"2027-04-03 14:00:00", "2027-09-25 14:00:00", "2028-04-01 14:00:00", 
"2028-09-23 14:00:00", "2029-03-31 14:00:00", "2029-09-29 14:00:00", 
"2030-04-06 14:00:00", "2030-09-28 14:00:00", "2031-04-05 14:00:00", 
"2031-09-27 14:00:00", "2032-04-03 14:00:00", "2032-09-25 14:00:00", 
"2033-04-02 14:00:00", "2033-09-24 14:00:00", "2034-04-01 14:00:00", 
"2034-09-23 14:00:00", "2035-03-31 14:00:00", "2035-09-29 14:00:00", 
"2036-04-05 14:00:00", "2036-09-27 14:00:00", "2037-04-04 14:00:00", 
"2037-09-26 14:00:00"), offSet = c(0L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L), isdst = c(0L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L), TimeZone = c("zzz", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT"
), numeric = c(-2147397248, -441849600, 152632800, 162309600, 
183477600, 194968800, 215532000, 226418400, 246981600, 257868000, 
278431200, 289317600, 309880800, 320767200, 341330400, 352216800, 
372780000, 384271200, 404834400, 415720800, 436284000, 447170400, 
467733600, 478620000, 499183200, 510069600, 530632800, 541519200, 
562082400, 573573600, 594136800, 605023200, 623772000, 637682400, 
655221600, 669132000, 686671200, 700581600, 718120800, 732636000, 
749570400, 764085600, 781020000, 795535200, 812469600, 826984800, 
844524000, 858434400, 875973600, 889884000, 907423200, 921938400, 
938872800, 953388000, 970322400, 984837600, 1002376800, 1016287200, 
1033826400, 1047736800, 1065276000, 1079791200, 1096725600, 1111240800, 
1128175200, 1142690400, 1159624800, 1174140000, 1191074400, 1207404000, 
1222524000, 1238853600, 1253973600, 1270303200, 1285423200, 1301752800, 
1316872800, 1333202400, 1348927200, 1365256800, 1380376800, 1396706400, 
1411826400, 1428156000, 1443276000, 1459605600, 1474725600, 1491055200, 
1506175200, 1522504800, 1538229600, 1554559200, 1569679200, 1586008800, 
1601128800, 1617458400, 1632578400, 1648908000, 1664028000, 1680357600, 
1695477600, 1712412000, 1727532000, 1743861600, 1758981600, 1775311200, 
1790431200, 1806760800, 1821880800, 1838210400, 1853330400, 1869660000, 
1885384800, 1901714400, 1916834400, 1933164000, 1948284000, 1964613600, 
1979733600, 1996063200, 2011183200, 2027512800, 2042632800, 2058962400, 
2074687200, 2091016800, 2106136800, 2122466400, 2137586400)), .Names = c("McMurdo", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-129L), class = "data.frame")
}

"Palmer" <- function () {
structure(list(Palmer = c("1901-12-14 20:45:52", "1965-01-01 00:00:00", 
"1965-03-01 03:00:00", "1965-10-15 04:00:00", "1966-03-01 03:00:00", 
"1966-10-15 04:00:00", "1967-04-02 03:00:00", "1967-10-01 04:00:00", 
"1968-04-07 03:00:00", "1968-10-06 04:00:00", "1969-04-06 03:00:00", 
"1969-10-05 04:00:00", "1974-01-23 03:00:00", "1974-05-01 02:00:00", 
"1982-05-01 03:00:00", "1982-10-10 04:00:00", "1983-03-13 03:00:00", 
"1983-10-09 04:00:00", "1984-03-11 03:00:00", "1984-10-14 04:00:00", 
"1985-03-10 03:00:00", "1985-10-13 04:00:00", "1986-03-09 03:00:00", 
"1986-10-12 04:00:00", "1987-04-12 03:00:00", "1987-10-11 04:00:00", 
"1988-03-13 03:00:00", "1988-10-02 04:00:00", "1989-03-12 03:00:00", 
"1989-10-15 04:00:00", "1990-03-18 03:00:00", "1990-09-16 04:00:00", 
"1991-03-10 03:00:00", "1991-10-13 04:00:00", "1992-03-15 03:00:00", 
"1992-10-11 04:00:00", "1993-03-14 03:00:00", "1993-10-10 04:00:00", 
"1994-03-13 03:00:00", "1994-10-09 04:00:00", "1995-03-12 03:00:00", 
"1995-10-15 04:00:00", "1996-03-10 03:00:00", "1996-10-13 04:00:00", 
"1997-03-30 03:00:00", "1997-10-12 04:00:00", "1998-03-15 03:00:00", 
"1998-09-27 04:00:00", "1999-04-04 03:00:00", "1999-10-10 04:00:00", 
"2000-03-12 03:00:00", "2000-10-15 04:00:00", "2001-03-11 03:00:00", 
"2001-10-14 04:00:00", "2002-03-10 03:00:00", "2002-10-13 04:00:00", 
"2003-03-09 03:00:00", "2003-10-12 04:00:00", "2004-03-14 03:00:00", 
"2004-10-10 04:00:00", "2005-03-13 03:00:00", "2005-10-09 04:00:00", 
"2006-03-12 03:00:00", "2006-10-15 04:00:00", "2007-03-11 03:00:00", 
"2007-10-14 04:00:00", "2008-03-09 03:00:00", "2008-10-12 04:00:00", 
"2009-03-15 03:00:00", "2009-10-11 04:00:00", "2010-03-14 03:00:00", 
"2010-10-10 04:00:00", "2011-03-13 03:00:00", "2011-10-09 04:00:00", 
"2012-03-11 03:00:00", "2012-10-14 04:00:00", "2013-03-10 03:00:00", 
"2013-10-13 04:00:00", "2014-03-09 03:00:00", "2014-10-12 04:00:00", 
"2015-03-15 03:00:00", "2015-10-11 04:00:00", "2016-03-13 03:00:00", 
"2016-10-09 04:00:00", "2017-03-12 03:00:00", "2017-10-15 04:00:00", 
"2018-03-11 03:00:00", "2018-10-14 04:00:00", "2019-03-10 03:00:00", 
"2019-10-13 04:00:00", "2020-03-15 03:00:00", "2020-10-11 04:00:00", 
"2021-03-14 03:00:00", "2021-10-10 04:00:00", "2022-03-13 03:00:00", 
"2022-10-09 04:00:00", "2023-03-12 03:00:00", "2023-10-15 04:00:00", 
"2024-03-10 03:00:00", "2024-10-13 04:00:00", "2025-03-09 03:00:00", 
"2025-10-12 04:00:00", "2026-03-15 03:00:00", "2026-10-11 04:00:00", 
"2027-03-14 03:00:00", "2027-10-10 04:00:00", "2028-03-12 03:00:00", 
"2028-10-15 04:00:00", "2029-03-11 03:00:00", "2029-10-14 04:00:00", 
"2030-03-10 03:00:00", "2030-10-13 04:00:00", "2031-03-09 03:00:00", 
"2031-10-12 04:00:00", "2032-03-14 03:00:00", "2032-10-10 04:00:00", 
"2033-03-13 03:00:00", "2033-10-09 04:00:00", "2034-03-12 03:00:00", 
"2034-10-15 04:00:00", "2035-03-11 03:00:00", "2035-10-14 04:00:00", 
"2036-03-09 03:00:00", "2036-10-12 04:00:00", "2037-03-15 03:00:00", 
"2037-10-11 04:00:00"), offSet = c(0L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -7200L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, 0L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 0L), TimeZone = c("zzz", "ARST", "ART", 
"ARST", "ART", "ARST", "ART", "ARST", "ART", "ARST", "ART", "ART", 
"ARST", "ART", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", 
"CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", "CLT", "CLST", 
"CLT", "CLST", "CLT", "CLST", "CLT", "UTC"), numeric = c(-2147397248, 
-157766400, -152658000, -132955200, -121122000, -101419200, -86821200, 
-71092800, -54766800, -39038400, -23317200, -7588800, 128142000, 
136605600, 389070000, 403070400, 416372400, 434520000, 447822000, 
466574400, 479271600, 498024000, 510721200, 529473600, 545194800, 
560923200, 574225200, 591768000, 605674800, 624427200, 637729200, 
653457600, 668574000, 687326400, 700628400, 718776000, 732078000, 
750225600, 763527600, 781675200, 794977200, 813729600, 826426800, 
845179200, 859690800, 876628800, 889930800, 906868800, 923194800, 
939528000, 952830000, 971582400, 984279600, 1003032000, 1015729200, 
1034481600, 1047178800, 1065931200, 1079233200, 1097380800, 1110682800, 
1128830400, 1142132400, 1160884800, 1173582000, 1192334400, 1205031600, 
1223784000, 1237086000, 1255233600, 1268535600, 1286683200, 1299985200, 
1318132800, 1331434800, 1350187200, 1362884400, 1381636800, 1394334000, 
1413086400, 1426388400, 1444536000, 1457838000, 1475985600, 1489287600, 
1508040000, 1520737200, 1539489600, 1552186800, 1570939200, 1584241200, 
1602388800, 1615690800, 1633838400, 1647140400, 1665288000, 1678590000, 
1697342400, 1710039600, 1728792000, 1741489200, 1760241600, 1773543600, 
1791691200, 1804993200, 1823140800, 1836442800, 1855195200, 1867892400, 
1886644800, 1899342000, 1918094400, 1930791600, 1949544000, 1962846000, 
1980993600, 1994295600, 2012443200, 2025745200, 2044497600, 2057194800, 
2075947200, 2088644400, 2107396800, 2120698800, 2138846400)), .Names = c("Palmer", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-126L), class = "data.frame")
}

"Rothera" <- function () {
structure(list(Rothera = c("1901-12-14 20:45:52", "1976-12-01 00:00:00"
), offSet = c(0L, -10800L), isdst = c(0L, 0L), TimeZone = c("zzz", 
"ROTT"), numeric = c(-2147397248, 218246400)), .Names = c("Rothera", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"South_Pole" <- function () {
structure(list(South_Pole = c("1901-12-14 20:45:52", "1956-01-01 00:00:00", 
"1974-11-02 14:00:00", "1975-02-22 14:00:00", "1975-10-25 14:00:00", 
"1976-03-06 14:00:00", "1976-10-30 14:00:00", "1977-03-05 14:00:00", 
"1977-10-29 14:00:00", "1978-03-04 14:00:00", "1978-10-28 14:00:00", 
"1979-03-03 14:00:00", "1979-10-27 14:00:00", "1980-03-01 14:00:00", 
"1980-10-25 14:00:00", "1981-02-28 14:00:00", "1981-10-24 14:00:00", 
"1982-03-06 14:00:00", "1982-10-30 14:00:00", "1983-03-05 14:00:00", 
"1983-10-29 14:00:00", "1984-03-03 14:00:00", "1984-10-27 14:00:00", 
"1985-03-02 14:00:00", "1985-10-26 14:00:00", "1986-03-01 14:00:00", 
"1986-10-25 14:00:00", "1987-02-28 14:00:00", "1987-10-24 14:00:00", 
"1988-03-05 14:00:00", "1988-10-29 14:00:00", "1989-03-04 14:00:00", 
"1989-10-07 14:00:00", "1990-03-17 14:00:00", "1990-10-06 14:00:00", 
"1991-03-16 14:00:00", "1991-10-05 14:00:00", "1992-03-14 14:00:00", 
"1992-10-03 14:00:00", "1993-03-20 14:00:00", "1993-10-02 14:00:00", 
"1994-03-19 14:00:00", "1994-10-01 14:00:00", "1995-03-18 14:00:00", 
"1995-09-30 14:00:00", "1996-03-16 14:00:00", "1996-10-05 14:00:00", 
"1997-03-15 14:00:00", "1997-10-04 14:00:00", "1998-03-14 14:00:00", 
"1998-10-03 14:00:00", "1999-03-20 14:00:00", "1999-10-02 14:00:00", 
"2000-03-18 14:00:00", "2000-09-30 14:00:00", "2001-03-17 14:00:00", 
"2001-10-06 14:00:00", "2002-03-16 14:00:00", "2002-10-05 14:00:00", 
"2003-03-15 14:00:00", "2003-10-04 14:00:00", "2004-03-20 14:00:00", 
"2004-10-02 14:00:00", "2005-03-19 14:00:00", "2005-10-01 14:00:00", 
"2006-03-18 14:00:00", "2006-09-30 14:00:00", "2007-03-17 14:00:00", 
"2007-09-29 14:00:00", "2008-04-05 14:00:00", "2008-09-27 14:00:00", 
"2009-04-04 14:00:00", "2009-09-26 14:00:00", "2010-04-03 14:00:00", 
"2010-09-25 14:00:00", "2011-04-02 14:00:00", "2011-09-24 14:00:00", 
"2012-03-31 14:00:00", "2012-09-29 14:00:00", "2013-04-06 14:00:00", 
"2013-09-28 14:00:00", "2014-04-05 14:00:00", "2014-09-27 14:00:00", 
"2015-04-04 14:00:00", "2015-09-26 14:00:00", "2016-04-02 14:00:00", 
"2016-09-24 14:00:00", "2017-04-01 14:00:00", "2017-09-23 14:00:00", 
"2018-03-31 14:00:00", "2018-09-29 14:00:00", "2019-04-06 14:00:00", 
"2019-09-28 14:00:00", "2020-04-04 14:00:00", "2020-09-26 14:00:00", 
"2021-04-03 14:00:00", "2021-09-25 14:00:00", "2022-04-02 14:00:00", 
"2022-09-24 14:00:00", "2023-04-01 14:00:00", "2023-09-23 14:00:00", 
"2024-04-06 14:00:00", "2024-09-28 14:00:00", "2025-04-05 14:00:00", 
"2025-09-27 14:00:00", "2026-04-04 14:00:00", "2026-09-26 14:00:00", 
"2027-04-03 14:00:00", "2027-09-25 14:00:00", "2028-04-01 14:00:00", 
"2028-09-23 14:00:00", "2029-03-31 14:00:00", "2029-09-29 14:00:00", 
"2030-04-06 14:00:00", "2030-09-28 14:00:00", "2031-04-05 14:00:00", 
"2031-09-27 14:00:00", "2032-04-03 14:00:00", "2032-09-25 14:00:00", 
"2033-04-02 14:00:00", "2033-09-24 14:00:00", "2034-04-01 14:00:00", 
"2034-09-23 14:00:00", "2035-03-31 14:00:00", "2035-09-29 14:00:00", 
"2036-04-05 14:00:00", "2036-09-27 14:00:00", "2037-04-04 14:00:00", 
"2037-09-26 14:00:00"), offSet = c(0L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L), isdst = c(0L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L), TimeZone = c("zzz", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", 
"NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT", "NZST", "NZDT"
), numeric = c(-2147397248, -441849600, 152632800, 162309600, 
183477600, 194968800, 215532000, 226418400, 246981600, 257868000, 
278431200, 289317600, 309880800, 320767200, 341330400, 352216800, 
372780000, 384271200, 404834400, 415720800, 436284000, 447170400, 
467733600, 478620000, 499183200, 510069600, 530632800, 541519200, 
562082400, 573573600, 594136800, 605023200, 623772000, 637682400, 
655221600, 669132000, 686671200, 700581600, 718120800, 732636000, 
749570400, 764085600, 781020000, 795535200, 812469600, 826984800, 
844524000, 858434400, 875973600, 889884000, 907423200, 921938400, 
938872800, 953388000, 970322400, 984837600, 1002376800, 1016287200, 
1033826400, 1047736800, 1065276000, 1079791200, 1096725600, 1111240800, 
1128175200, 1142690400, 1159624800, 1174140000, 1191074400, 1207404000, 
1222524000, 1238853600, 1253973600, 1270303200, 1285423200, 1301752800, 
1316872800, 1333202400, 1348927200, 1365256800, 1380376800, 1396706400, 
1411826400, 1428156000, 1443276000, 1459605600, 1474725600, 1491055200, 
1506175200, 1522504800, 1538229600, 1554559200, 1569679200, 1586008800, 
1601128800, 1617458400, 1632578400, 1648908000, 1664028000, 1680357600, 
1695477600, 1712412000, 1727532000, 1743861600, 1758981600, 1775311200, 
1790431200, 1806760800, 1821880800, 1838210400, 1853330400, 1869660000, 
1885384800, 1901714400, 1916834400, 1933164000, 1948284000, 1964613600, 
1979733600, 1996063200, 2011183200, 2027512800, 2042632800, 2058962400, 
2074687200, 2091016800, 2106136800, 2122466400, 2137586400)), .Names = c("South_Pole", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-129L), class = "data.frame")
}

"Syowa" <- function () {
structure(list(Syowa = c("1901-12-14 20:45:52", "1957-01-29 00:00:00"
), offSet = c(0L, 10800L), isdst = c(0L, 0L), TimeZone = c("zzz", 
"SYOT"), numeric = c(-2147397248, -407808000)), .Names = c("Syowa", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Vostok" <- function () {
structure(list(Vostok = c("1901-12-14 20:45:52", "1957-12-16 00:00:00"
), offSet = c(0L, 21600L), isdst = c(0L, 0L), TimeZone = c("zzz", 
"VOST"), numeric = c(-2147397248, -380073600)), .Names = c("Vostok", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Longyearbyen" <- function () {
structure(list(Longyearbyen = c("1901-12-14 20:45:52", "1916-05-22 00:00:00", 
"1916-09-29 22:00:00", "1940-08-10 22:00:00", "1942-11-02 01:00:00", 
"1943-03-29 01:00:00", "1943-10-04 01:00:00", "1944-04-03 01:00:00", 
"1944-10-02 01:00:00", "1945-04-02 01:00:00", "1945-10-01 01:00:00", 
"1959-03-15 01:00:00", "1959-09-20 01:00:00", "1960-03-20 01:00:00", 
"1960-09-18 01:00:00", "1961-03-19 01:00:00", "1961-09-17 01:00:00", 
"1962-03-18 01:00:00", "1962-09-16 01:00:00", "1963-03-17 01:00:00", 
"1963-09-15 01:00:00", "1964-03-15 01:00:00", "1964-09-20 01:00:00", 
"1965-04-25 01:00:00", "1965-09-19 01:00:00", "1980-04-06 01:00:00", 
"1980-09-28 01:00:00", "1981-03-29 01:00:00", "1981-09-27 01:00:00", 
"1982-03-28 01:00:00", "1982-09-26 01:00:00", "1983-03-27 01:00:00", 
"1983-09-25 01:00:00", "1984-03-25 01:00:00", "1984-09-30 01:00:00", 
"1985-03-31 01:00:00", "1985-09-29 01:00:00", "1986-03-30 01:00:00", 
"1986-09-28 01:00:00", "1987-03-29 01:00:00", "1987-09-27 01:00:00", 
"1988-03-27 01:00:00", "1988-09-25 01:00:00", "1989-03-26 01:00:00", 
"1989-09-24 01:00:00", "1990-03-25 01:00:00", "1990-09-30 01:00:00", 
"1991-03-31 01:00:00", "1991-09-29 01:00:00", "1992-03-29 01:00:00", 
"1992-09-27 01:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00", "2031-03-30 01:00:00", 
"2031-10-26 01:00:00", "2032-03-28 01:00:00", "2032-10-31 01:00:00", 
"2033-03-27 01:00:00", "2033-10-30 01:00:00", "2034-03-26 01:00:00", 
"2034-10-29 01:00:00", "2035-03-25 01:00:00", "2035-10-28 01:00:00", 
"2036-03-30 01:00:00", "2036-10-26 01:00:00", "2037-03-29 01:00:00", 
"2037-10-25 01:00:00"), offSet = c(3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 
3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 7200L, 3600L, 
7200L, 3600L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L), TimeZone = c("CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", 
"CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", "CET", "CEST", 
"CET"), numeric = c(-2147397248, -1691884800, -1680573600, -927511200, 
-857257200, -844556400, -828226800, -812502000, -796777200, -781052400, 
-765327600, -340844400, -324514800, -308790000, -293065200, -277340400, 
-261615600, -245890800, -230166000, -214441200, -198716400, -182991600, 
-166662000, -147913200, -135212400, 323830800, 338950800, 354675600, 
370400400, 386125200, 401850000, 417574800, 433299600, 449024400, 
465354000, 481078800, 496803600, 512528400, 528253200, 543978000, 
559702800, 575427600, 591152400, 606877200, 622602000, 638326800, 
654656400, 670381200, 686106000, 701830800, 717555600, 733280400, 
749005200, 764730000, 780454800, 796179600, 811904400, 828234000, 
846378000, 859683600, 877827600, 891133200, 909277200, 922582800, 
941331600, 954032400, 972781200, 985482000, 1004230800, 1017536400, 
1035680400, 1048986000, 1067130000, 1080435600, 1099184400, 1111885200, 
1130634000, 1143334800, 1162083600, 1174784400, 1193533200, 1206838800, 
1224982800, 1238288400, 1256432400, 1269738000, 1288486800, 1301187600, 
1319936400, 1332637200, 1351386000, 1364691600, 1382835600, 1396141200, 
1414285200, 1427590800, 1445734800, 1459040400, 1477789200, 1490490000, 
1509238800, 1521939600, 1540688400, 1553994000, 1572138000, 1585443600, 
1603587600, 1616893200, 1635642000, 1648342800, 1667091600, 1679792400, 
1698541200, 1711846800, 1729990800, 1743296400, 1761440400, 1774746000, 
1792890000, 1806195600, 1824944400, 1837645200, 1856394000, 1869094800, 
1887843600, 1901149200, 1919293200, 1932598800, 1950742800, 1964048400, 
1982797200, 1995498000, 2014246800, 2026947600, 2045696400, 2058397200, 
2077146000, 2090451600, 2108595600, 2121901200, 2140045200)), .Names = c("Longyearbyen", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-141L), class = "data.frame")
}

"Aden" <- function () {
structure(list(Aden = c("1901-12-14 20:45:52", "1949-12-31 20:59:12"
), offSet = c(10848L, 10800L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"AST"), numeric = c(-2147397248, -631162848)), .Names = c("Aden", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Almaty" <- function () {
structure(list(Almaty = c("1901-12-14 20:45:52", "1924-05-01 18:52:12", 
"1930-06-20 19:00:00", "1981-03-31 18:00:00", "1981-09-30 17:00:00", 
"1982-03-31 18:00:00", "1982-09-30 17:00:00", "1983-03-31 18:00:00", 
"1983-09-30 17:00:00", "1984-03-31 18:00:00", "1984-09-29 20:00:00", 
"1985-03-30 20:00:00", "1985-09-28 20:00:00", "1986-03-29 20:00:00", 
"1986-09-27 20:00:00", "1987-03-28 20:00:00", "1987-09-26 20:00:00", 
"1988-03-26 20:00:00", "1988-09-24 20:00:00", "1989-03-25 20:00:00", 
"1989-09-23 20:00:00", "1990-03-24 20:00:00", "1990-09-29 20:00:00", 
"1992-03-28 17:00:00", "1992-09-26 16:00:00", "1993-03-27 20:00:00", 
"1993-09-25 20:00:00", "1994-03-26 20:00:00", "1994-09-24 20:00:00", 
"1995-03-25 20:00:00", "1995-09-23 20:00:00", "1996-03-30 20:00:00", 
"1996-10-26 20:00:00", "1997-03-29 20:00:00", "1997-10-25 20:00:00", 
"1998-03-28 20:00:00", "1998-10-24 20:00:00", "1999-03-27 20:00:00", 
"1999-10-30 20:00:00", "2000-03-25 20:00:00", "2000-10-28 20:00:00", 
"2001-03-24 20:00:00", "2001-10-27 20:00:00", "2002-03-30 20:00:00", 
"2002-10-26 20:00:00", "2003-03-29 20:00:00", "2003-10-25 20:00:00", 
"2004-03-27 20:00:00", "2004-10-30 20:00:00"), offSet = c(18468L, 
18000L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 
25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 
25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 
25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 
25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 
25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L
), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "ALMT", "ALMT", "ALMST", 
"ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", 
"ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", 
"ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", 
"ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", 
"ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", "ALMT", "ALMST", 
"ALMT", "ALMST", "ALMT", "ALMST", "ALMT"), numeric = c(-2147397248, 
-1441170468, -1247547600, 354909600, 370717200, 386445600, 402253200, 
417981600, 433789200, 449604000, 465336000, 481060800, 496785600, 
512510400, 528235200, 543960000, 559684800, 575409600, 591134400, 
606859200, 622584000, 638308800, 654638400, 701802000, 717523200, 
733262400, 748987200, 764712000, 780436800, 796161600, 811886400, 
828216000, 846360000, 859665600, 877809600, 891115200, 909259200, 
922564800, 941313600, 954014400, 972763200, 985464000, 1004212800, 
1017518400, 1035662400, 1048968000, 1067112000, 1080417600, 1099166400
)), .Names = c("Almaty", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -49L), class = "data.frame")
}

"Amman" <- function () {
structure(list(Amman = c("1901-12-14 20:45:52", "1930-12-31 21:36:16", 
"1973-06-05 22:00:00", "1973-09-30 21:00:00", "1974-04-30 22:00:00", 
"1974-09-30 21:00:00", "1975-04-30 22:00:00", "1975-09-30 21:00:00", 
"1976-04-30 22:00:00", "1976-10-31 21:00:00", "1977-04-30 22:00:00", 
"1977-09-30 21:00:00", "1978-04-29 22:00:00", "1978-09-29 21:00:00", 
"1985-03-31 22:00:00", "1985-09-30 21:00:00", "1986-04-03 22:00:00", 
"1986-10-02 21:00:00", "1987-04-02 22:00:00", "1987-10-01 21:00:00", 
"1988-03-31 22:00:00", "1988-10-06 21:00:00", "1989-05-07 22:00:00", 
"1989-10-05 21:00:00", "1990-04-26 22:00:00", "1990-10-04 21:00:00", 
"1991-04-16 22:00:00", "1991-09-26 21:00:00", "1992-04-09 22:00:00", 
"1992-10-01 21:00:00", "1993-04-01 22:00:00", "1993-09-30 21:00:00", 
"1994-03-31 22:00:00", "1994-09-15 21:00:00", "1995-04-06 22:00:00", 
"1995-09-14 22:00:00", "1996-04-04 22:00:00", "1996-09-19 22:00:00", 
"1997-04-03 22:00:00", "1997-09-18 22:00:00", "1998-04-02 22:00:00", 
"1998-09-17 22:00:00", "1999-06-30 22:00:00", "1999-09-29 22:00:00", 
"2000-03-29 22:00:00", "2000-09-27 22:00:00", "2001-03-28 22:00:00", 
"2001-09-26 22:00:00", "2002-03-27 22:00:00", "2002-09-25 22:00:00", 
"2003-03-26 22:00:00", "2003-10-23 22:00:00", "2004-03-24 22:00:00", 
"2004-10-14 22:00:00", "2005-03-30 22:00:00", "2005-09-29 22:00:00", 
"2006-03-29 22:00:00", "2006-10-26 22:00:00", "2007-03-28 22:00:00", 
"2007-10-25 22:00:00", "2008-03-26 22:00:00", "2008-10-30 22:00:00", 
"2009-03-25 22:00:00", "2009-10-29 22:00:00", "2010-03-24 22:00:00", 
"2010-10-28 22:00:00", "2011-03-30 22:00:00", "2011-10-27 22:00:00", 
"2012-03-28 22:00:00", "2012-10-25 22:00:00", "2013-03-27 22:00:00", 
"2013-10-24 22:00:00", "2014-03-26 22:00:00", "2014-10-30 22:00:00", 
"2015-03-25 22:00:00", "2015-10-29 22:00:00", "2016-03-30 22:00:00", 
"2016-10-27 22:00:00", "2017-03-29 22:00:00", "2017-10-26 22:00:00", 
"2018-03-28 22:00:00", "2018-10-25 22:00:00", "2019-03-27 22:00:00", 
"2019-10-24 22:00:00", "2020-03-25 22:00:00", "2020-10-29 22:00:00", 
"2021-03-24 22:00:00", "2021-10-28 22:00:00", "2022-03-30 22:00:00", 
"2022-10-27 22:00:00", "2023-03-29 22:00:00", "2023-10-26 22:00:00", 
"2024-03-27 22:00:00", "2024-10-24 22:00:00", "2025-03-26 22:00:00", 
"2025-10-30 22:00:00", "2026-03-25 22:00:00", "2026-10-29 22:00:00", 
"2027-03-24 22:00:00", "2027-10-28 22:00:00", "2028-03-29 22:00:00", 
"2028-10-26 22:00:00", "2029-03-28 22:00:00", "2029-10-25 22:00:00", 
"2030-03-27 22:00:00", "2030-10-24 22:00:00", "2031-03-26 22:00:00", 
"2031-10-30 22:00:00", "2032-03-24 22:00:00", "2032-10-28 22:00:00", 
"2033-03-30 22:00:00", "2033-10-27 22:00:00", "2034-03-29 22:00:00", 
"2034-10-26 22:00:00", "2035-03-28 22:00:00", "2035-10-25 22:00:00", 
"2036-03-26 22:00:00", "2036-10-30 22:00:00", "2037-03-25 22:00:00", 
"2037-10-29 22:00:00"), offSet = c(8624L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L), 
    isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
    1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
    0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
    1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
    0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
    1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
    0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
    1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
    0L, 1L, 0L), TimeZone = c("LMT", "EET", "EEST", "EET", "EEST", 
    "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
    "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
    "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
    "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
    "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
    "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
    "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
    "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
    "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
    "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
    "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
    "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
    "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
    "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
    "EET", "EEST", "EET"), numeric = c(-2147397248, -1230776624, 
    108165600, 118270800, 136591200, 149806800, 168127200, 181342800, 
    199749600, 215643600, 231285600, 244501200, 262735200, 275950800, 
    481154400, 496962000, 512949600, 528670800, 544399200, 560120400, 
    575848800, 592174800, 610581600, 623624400, 641167200, 655074000, 
    671839200, 685918800, 702856800, 717973200, 733701600, 749422800, 
    765151200, 779662800, 797205600, 811116000, 828655200, 843170400, 
    860104800, 874620000, 891554400, 906069600, 930780000, 938642400, 
    954367200, 970092000, 985816800, 1001541600, 1017266400, 
    1032991200, 1048716000, 1066946400, 1080165600, 1097791200, 
    1112220000, 1128031200, 1143669600, 1161900000, 1175119200, 
    1193349600, 1206568800, 1225404000, 1238018400, 1256853600, 
    1269468000, 1288303200, 1301522400, 1319752800, 1332972000, 
    1351202400, 1364421600, 1382652000, 1395871200, 1414706400, 
    1427320800, 1446156000, 1459375200, 1477605600, 1490824800, 
    1509055200, 1522274400, 1540504800, 1553724000, 1571954400, 
    1585173600, 1604008800, 1616623200, 1635458400, 1648677600, 
    1666908000, 1680127200, 1698357600, 1711576800, 1729807200, 
    1743026400, 1761861600, 1774476000, 1793311200, 1805925600, 
    1824760800, 1837980000, 1856210400, 1869429600, 1887660000, 
    1900879200, 1919109600, 1932328800, 1951164000, 1963778400, 
    1982613600, 1995832800, 2014063200, 2027282400, 2045512800, 
    2058732000, 2076962400, 2090181600, 2109016800, 2121631200, 
    2140466400)), .Names = c("Amman", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -120L), class = "data.frame")
}

"Anadyr" <- function () {
structure(list(Anadyr = c("1901-12-14 20:45:52", "1924-05-01 12:10:04", 
"1930-06-20 12:00:00", "1981-03-31 11:00:00", "1982-03-31 11:00:00", 
"1982-09-30 11:00:00", "1983-03-31 12:00:00", "1983-09-30 11:00:00", 
"1984-03-31 12:00:00", "1984-09-29 14:00:00", "1985-03-30 14:00:00", 
"1985-09-28 14:00:00", "1986-03-29 14:00:00", "1986-09-27 14:00:00", 
"1987-03-28 14:00:00", "1987-09-26 14:00:00", "1988-03-26 14:00:00", 
"1988-09-24 14:00:00", "1989-03-25 14:00:00", "1989-09-23 14:00:00", 
"1990-03-24 14:00:00", "1991-03-30 14:00:00", "1991-09-28 15:00:00", 
"1992-01-18 15:00:00", "1992-03-28 11:00:00", "1992-09-26 10:00:00", 
"1993-03-27 14:00:00", "1993-09-25 14:00:00", "1994-03-26 14:00:00", 
"1994-09-24 14:00:00", "1995-03-25 14:00:00", "1995-09-23 14:00:00", 
"1996-03-30 14:00:00", "1996-10-26 14:00:00", "1997-03-29 14:00:00", 
"1997-10-25 14:00:00", "1998-03-28 14:00:00", "1998-10-24 14:00:00", 
"1999-03-27 14:00:00", "1999-10-30 14:00:00", "2000-03-25 14:00:00", 
"2000-10-28 14:00:00", "2001-03-24 14:00:00", "2001-10-27 14:00:00", 
"2002-03-30 14:00:00", "2002-10-26 14:00:00", "2003-03-29 14:00:00", 
"2003-10-25 14:00:00", "2004-03-27 14:00:00", "2004-10-30 14:00:00", 
"2005-03-26 14:00:00", "2005-10-29 14:00:00", "2006-03-25 14:00:00", 
"2006-10-28 14:00:00", "2007-03-24 14:00:00", "2007-10-27 14:00:00", 
"2008-03-29 14:00:00", "2008-10-25 14:00:00", "2009-03-28 14:00:00", 
"2009-10-24 14:00:00", "2010-03-27 14:00:00", "2010-10-30 14:00:00", 
"2011-03-26 14:00:00", "2011-10-29 14:00:00", "2012-03-24 14:00:00", 
"2012-10-27 14:00:00", "2013-03-30 14:00:00", "2013-10-26 14:00:00", 
"2014-03-29 14:00:00", "2014-10-25 14:00:00", "2015-03-28 14:00:00", 
"2015-10-24 14:00:00", "2016-03-26 14:00:00", "2016-10-29 14:00:00", 
"2017-03-25 14:00:00", "2017-10-28 14:00:00", "2018-03-24 14:00:00", 
"2018-10-27 14:00:00", "2019-03-30 14:00:00", "2019-10-26 14:00:00", 
"2020-03-28 14:00:00", "2020-10-24 14:00:00", "2021-03-27 14:00:00", 
"2021-10-30 14:00:00", "2022-03-26 14:00:00", "2022-10-29 14:00:00", 
"2023-03-25 14:00:00", "2023-10-28 14:00:00", "2024-03-30 14:00:00", 
"2024-10-26 14:00:00", "2025-03-29 14:00:00", "2025-10-25 14:00:00", 
"2026-03-28 14:00:00", "2026-10-24 14:00:00", "2027-03-27 14:00:00", 
"2027-10-30 14:00:00", "2028-03-25 14:00:00", "2028-10-28 14:00:00", 
"2029-03-24 14:00:00", "2029-10-27 14:00:00", "2030-03-30 14:00:00", 
"2030-10-26 14:00:00", "2031-03-29 14:00:00", "2031-10-25 14:00:00", 
"2032-03-27 14:00:00", "2032-10-30 14:00:00", "2033-03-26 14:00:00", 
"2033-10-29 14:00:00", "2034-03-25 14:00:00", "2034-10-28 14:00:00", 
"2035-03-24 14:00:00", "2035-10-27 14:00:00", "2036-03-29 14:00:00", 
"2036-10-25 14:00:00", "2037-03-28 14:00:00", "2037-10-24 14:00:00"
), offSet = c(42596L, 43200L, 46800L, 50400L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
39600L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 
46800L, 43200L, 46800L, 43200L, 46800L, 43200L), isdst = c(0L, 
0L, 0L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L), TimeZone = c("LMT", "ANAT", "ANAT", "ANAST", "ANAST", 
"ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", 
"ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", 
"ANAST", "ANAT", "ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", 
"ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", 
"ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", 
"ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", 
"ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", 
"ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", 
"ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", 
"ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", 
"ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", 
"ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", 
"ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", 
"ANAT", "ANAST", "ANAT", "ANAST", "ANAT", "ANAST", "ANAT"), numeric = c(-2147397248, 
-1441194596, -1247572800, 354884400, 386420400, 402231600, 417960000, 
433767600, 449582400, 465314400, 481039200, 496764000, 512488800, 
528213600, 543938400, 559663200, 575388000, 591112800, 606837600, 
622562400, 638287200, 670341600, 686070000, 695746800, 701780400, 
717501600, 733240800, 748965600, 764690400, 780415200, 796140000, 
811864800, 828194400, 846338400, 859644000, 877788000, 891093600, 
909237600, 922543200, 941292000, 953992800, 972741600, 985442400, 
1004191200, 1017496800, 1035640800, 1048946400, 1067090400, 1080396000, 
1099144800, 1111845600, 1130594400, 1143295200, 1162044000, 1174744800, 
1193493600, 1206799200, 1224943200, 1238248800, 1256392800, 1269698400, 
1288447200, 1301148000, 1319896800, 1332597600, 1351346400, 1364652000, 
1382796000, 1396101600, 1414245600, 1427551200, 1445695200, 1459000800, 
1477749600, 1490450400, 1509199200, 1521900000, 1540648800, 1553954400, 
1572098400, 1585404000, 1603548000, 1616853600, 1635602400, 1648303200, 
1667052000, 1679752800, 1698501600, 1711807200, 1729951200, 1743256800, 
1761400800, 1774706400, 1792850400, 1806156000, 1824904800, 1837605600, 
1856354400, 1869055200, 1887804000, 1901109600, 1919253600, 1932559200, 
1950703200, 1964008800, 1982757600, 1995458400, 2014207200, 2026908000, 
2045656800, 2058357600, 2077106400, 2090412000, 2108556000, 2121861600, 
2140005600)), .Names = c("Anadyr", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -116L), class = "data.frame")
}

"Aqtau" <- function () {
structure(list(Aqtau = c("1901-12-14 20:45:52", "1924-05-01 20:38:56", 
"1962-12-31 19:00:00", "1982-03-31 18:00:00", "1982-09-30 18:00:00", 
"1983-03-31 19:00:00", "1983-09-30 18:00:00", "1984-03-31 19:00:00", 
"1984-09-29 21:00:00", "1985-03-30 21:00:00", "1985-09-28 21:00:00", 
"1986-03-29 21:00:00", "1986-09-27 21:00:00", "1987-03-28 21:00:00", 
"1987-09-26 21:00:00", "1988-03-26 21:00:00", "1988-09-24 21:00:00", 
"1989-03-25 21:00:00", "1989-09-23 21:00:00", "1990-03-24 21:00:00", 
"1991-12-15 19:00:00", "1992-03-28 18:00:00", "1992-09-26 17:00:00", 
"1993-03-27 21:00:00", "1993-09-25 21:00:00", "1994-03-26 21:00:00", 
"1995-03-25 21:00:00", "1995-09-23 22:00:00", "1996-03-30 22:00:00", 
"1996-10-26 22:00:00", "1997-03-29 22:00:00", "1997-10-25 22:00:00", 
"1998-03-28 22:00:00", "1998-10-24 22:00:00", "1999-03-27 22:00:00", 
"1999-10-30 22:00:00", "2000-03-25 22:00:00", "2000-10-28 22:00:00", 
"2001-03-24 22:00:00", "2001-10-27 22:00:00", "2002-03-30 22:00:00", 
"2002-10-26 22:00:00", "2003-03-29 22:00:00", "2003-10-25 22:00:00", 
"2004-03-27 22:00:00", "2004-10-30 22:00:00", "2005-03-14 20:00:00"
), offSet = c(12064L, 14400L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 0L), TimeZone = c("LMT", "FORT", "SHET", "SHEST", 
"SHET", "SHEST", "SHET", "SHEST", "SHET", "SHEST", "SHET", "SHEST", 
"SHET", "SHEST", "SHET", "SHEST", "SHET", "SHEST", "SHET", "SHEST", 
"AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTST", "AQTT", 
"AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", 
"AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", 
"AQTST", "AQTT", "AQTT"), numeric = c(-2147397248, -1441164064, 
-220942800, 386445600, 402256800, 417985200, 433792800, 449607600, 
465339600, 481064400, 496789200, 512514000, 528238800, 543963600, 
559688400, 575413200, 591138000, 606862800, 622587600, 638312400, 
692823600, 701805600, 717526800, 733266000, 748990800, 764715600, 
796165200, 811893600, 828223200, 846367200, 859672800, 877816800, 
891122400, 909266400, 922572000, 941320800, 954021600, 972770400, 
985471200, 1004220000, 1017525600, 1035669600, 1048975200, 1067119200, 
1080424800, 1099173600, 1110830400)), .Names = c("Aqtau", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -47L), class = "data.frame")
}

"Aqtobe" <- function () {
structure(list(Aqtobe = c("1901-12-14 20:45:52", "1924-05-01 20:11:20", 
"1930-06-20 20:00:00", "1982-03-31 18:00:00", "1982-09-30 18:00:00", 
"1983-03-31 19:00:00", "1983-09-30 18:00:00", "1984-03-31 19:00:00", 
"1984-09-29 21:00:00", "1985-03-30 21:00:00", "1985-09-28 21:00:00", 
"1986-03-29 21:00:00", "1986-09-27 21:00:00", "1987-03-28 21:00:00", 
"1987-09-26 21:00:00", "1988-03-26 21:00:00", "1988-09-24 21:00:00", 
"1989-03-25 21:00:00", "1989-09-23 21:00:00", "1990-03-24 21:00:00", 
"1991-12-15 19:00:00", "1992-03-28 18:00:00", "1992-09-26 17:00:00", 
"1993-03-27 21:00:00", "1993-09-25 21:00:00", "1994-03-26 21:00:00", 
"1994-09-24 21:00:00", "1995-03-25 21:00:00", "1995-09-23 21:00:00", 
"1996-03-30 21:00:00", "1996-10-26 21:00:00", "1997-03-29 21:00:00", 
"1997-10-25 21:00:00", "1998-03-28 21:00:00", "1998-10-24 21:00:00", 
"1999-03-27 21:00:00", "1999-10-30 21:00:00", "2000-03-25 21:00:00", 
"2000-10-28 21:00:00", "2001-03-24 21:00:00", "2001-10-27 21:00:00", 
"2002-03-30 21:00:00", "2002-10-26 21:00:00", "2003-03-29 21:00:00", 
"2003-10-25 21:00:00", "2004-03-27 21:00:00", "2004-10-30 21:00:00"
), offSet = c(13720L, 14400L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L), TimeZone = c("LMT", "AKTT", "AKTT", "AKTST", 
"AKTT", "AKTST", "AKTT", "AKTST", "AKTT", "AKTST", "AKTT", "AKTST", 
"AKTT", "AKTST", "AKTT", "AKTST", "AKTT", "AKTST", "AKTT", "AKTST", 
"AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", 
"AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", 
"AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", "AQTT", "AQTST", 
"AQTT", "AQTST", "AQTT"), numeric = c(-2147397248, -1441165720, 
-1247544000, 386445600, 402256800, 417985200, 433792800, 449607600, 
465339600, 481064400, 496789200, 512514000, 528238800, 543963600, 
559688400, 575413200, 591138000, 606862800, 622587600, 638312400, 
692823600, 701805600, 717526800, 733266000, 748990800, 764715600, 
780440400, 796165200, 811890000, 828219600, 846363600, 859669200, 
877813200, 891118800, 909262800, 922568400, 941317200, 954018000, 
972766800, 985467600, 1004216400, 1017522000, 1035666000, 1048971600, 
1067115600, 1080421200, 1099170000)), .Names = c("Aqtobe", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -47L), class = "data.frame")
}

"Ashgabat" <- function () {
structure(list(Ashgabat = c("1901-12-14 20:45:52", "1924-05-01 20:06:28", 
"1930-06-20 20:00:00", "1981-03-31 19:00:00", "1981-09-30 18:00:00", 
"1982-03-31 19:00:00", "1982-09-30 18:00:00", "1983-03-31 19:00:00", 
"1983-09-30 18:00:00", "1984-03-31 19:00:00", "1984-09-29 21:00:00", 
"1985-03-30 21:00:00", "1985-09-28 21:00:00", "1986-03-29 21:00:00", 
"1986-09-27 21:00:00", "1987-03-28 21:00:00", "1987-09-26 21:00:00", 
"1988-03-26 21:00:00", "1988-09-24 21:00:00", "1989-03-25 21:00:00", 
"1989-09-23 21:00:00", "1990-03-24 21:00:00", "1991-03-30 21:00:00", 
"1991-10-26 20:00:00", "1992-01-18 22:00:00"), offSet = c(14012L, 
14400L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 
21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 
21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 14400L, 18000L
), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 0L, 0L), TimeZone = c("LMT", 
"ASHT", "ASHT", "ASHST", "ASHT", "ASHST", "ASHT", "ASHST", "ASHT", 
"ASHST", "ASHT", "ASHST", "ASHT", "ASHST", "ASHT", "ASHST", "ASHT", 
"ASHST", "ASHT", "ASHST", "ASHT", "ASHST", "ASHST", "TMT", "TMT"
), numeric = c(-2147397248, -1441166012, -1247544000, 354913200, 
370720800, 386449200, 402256800, 417985200, 433792800, 449607600, 
465339600, 481064400, 496789200, 512514000, 528238800, 543963600, 
559688400, 575413200, 591138000, 606862800, 622587600, 638312400, 
670366800, 688507200, 695772000)), .Names = c("Ashgabat", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -25L), class = "data.frame")
}

"Baghdad" <- function () {
structure(list(Baghdad = c("1901-12-14 20:45:52", "1917-12-31 21:02:24", 
"1982-04-30 21:00:00", "1982-09-30 20:00:00", "1983-03-30 21:00:00", 
"1983-09-30 20:00:00", "1984-03-31 21:00:00", "1984-09-30 20:00:00", 
"1985-03-31 21:00:00", "1985-09-28 22:00:00", "1986-03-29 22:00:00", 
"1986-09-27 22:00:00", "1987-03-28 22:00:00", "1987-09-26 22:00:00", 
"1988-03-26 22:00:00", "1988-09-24 22:00:00", "1989-03-25 22:00:00", 
"1989-09-23 22:00:00", "1990-03-24 22:00:00", "1990-09-29 22:00:00", 
"1991-04-01 00:00:00", "1991-10-01 00:00:00", "1992-04-01 00:00:00", 
"1992-10-01 00:00:00", "1993-04-01 00:00:00", "1993-10-01 00:00:00", 
"1994-04-01 00:00:00", "1994-10-01 00:00:00", "1995-04-01 00:00:00", 
"1995-10-01 00:00:00", "1996-04-01 00:00:00", "1996-10-01 00:00:00", 
"1997-04-01 00:00:00", "1997-10-01 00:00:00", "1998-04-01 00:00:00", 
"1998-10-01 00:00:00", "1999-04-01 00:00:00", "1999-10-01 00:00:00", 
"2000-04-01 00:00:00", "2000-10-01 00:00:00", "2001-04-01 00:00:00", 
"2001-10-01 00:00:00", "2002-04-01 00:00:00", "2002-10-01 00:00:00", 
"2003-04-01 00:00:00", "2003-10-01 00:00:00", "2004-04-01 00:00:00", 
"2004-10-01 00:00:00", "2005-04-01 00:00:00", "2005-10-01 00:00:00", 
"2006-04-01 00:00:00", "2006-10-01 00:00:00", "2007-04-01 00:00:00", 
"2007-10-01 00:00:00"), offSet = c(10656L, 10800L, 14400L, 10800L, 
14400L, 10800L, 14400L, 10800L, 14400L, 10800L, 14400L, 10800L, 
14400L, 10800L, 14400L, 10800L, 14400L, 10800L, 14400L, 10800L, 
14400L, 10800L, 14400L, 10800L, 14400L, 10800L, 14400L, 10800L, 
14400L, 10800L, 14400L, 10800L, 14400L, 10800L, 14400L, 10800L, 
14400L, 10800L, 14400L, 10800L, 14400L, 10800L, 14400L, 10800L, 
14400L, 10800L, 14400L, 10800L, 14400L, 10800L, 14400L, 10800L, 
14400L, 10800L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("BMT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST"), numeric = c(-2147397248, 
-1641005856, 389048400, 402264000, 417906000, 433800000, 449614800, 
465422400, 481150800, 496792800, 512517600, 528242400, 543967200, 
559692000, 575416800, 591141600, 606866400, 622591200, 638316000, 
654645600, 670464000, 686275200, 702086400, 717897600, 733622400, 
749433600, 765158400, 780969600, 796694400, 812505600, 828316800, 
844128000, 859852800, 875664000, 891388800, 907200000, 922924800, 
938736000, 954547200, 970358400, 986083200, 1001894400, 1017619200, 
1033430400, 1049155200, 1064966400, 1080777600, 1096588800, 1112313600, 
1128124800, 1143849600, 1159660800, 1175385600, 1191196800)), .Names = c("Baghdad", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-54L), class = "data.frame")
}

"Bahrain" <- function () {
structure(list(Bahrain = c("1901-12-14 20:45:52", "1919-12-31 20:37:40", 
"1972-05-31 20:00:00"), offSet = c(12140L, 14400L, 10800L), isdst = c(0L, 
0L, 0L), TimeZone = c("LMT", "GST", "AST"), numeric = c(-2147397248, 
-1577935340, 76190400)), .Names = c("Bahrain", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -3L), class = "data.frame")
}

"Baku" <- function () {
structure(list(Baku = c("1901-12-14 20:45:52", "1924-05-01 20:40:36", 
"1957-02-28 21:00:00", "1981-03-31 20:00:00", "1981-09-30 19:00:00", 
"1982-03-31 20:00:00", "1982-09-30 19:00:00", "1983-03-31 20:00:00", 
"1983-09-30 19:00:00", "1984-03-31 20:00:00", "1984-09-29 22:00:00", 
"1985-03-30 22:00:00", "1985-09-28 22:00:00", "1986-03-29 22:00:00", 
"1986-09-27 22:00:00", "1987-03-28 22:00:00", "1987-09-26 22:00:00", 
"1988-03-26 22:00:00", "1988-09-24 22:00:00", "1989-03-25 22:00:00", 
"1989-09-23 22:00:00", "1990-03-24 22:00:00", "1991-08-29 20:00:00", 
"1991-09-28 23:00:00", "1992-09-26 19:00:00", "1996-03-31 01:00:00", 
"1996-10-27 01:00:00", "1997-03-30 00:00:00", "1997-10-26 00:00:00", 
"1998-03-29 00:00:00", "1998-10-25 00:00:00", "1999-03-28 00:00:00", 
"1999-10-31 00:00:00", "2000-03-26 00:00:00", "2000-10-29 00:00:00", 
"2001-03-25 00:00:00", "2001-10-28 00:00:00", "2002-03-31 00:00:00", 
"2002-10-27 00:00:00", "2003-03-30 00:00:00", "2003-10-26 00:00:00", 
"2004-03-28 00:00:00", "2004-10-31 00:00:00", "2005-03-27 00:00:00", 
"2005-10-30 00:00:00", "2006-03-26 00:00:00", "2006-10-29 00:00:00", 
"2007-03-25 00:00:00", "2007-10-28 00:00:00", "2008-03-30 00:00:00", 
"2008-10-26 00:00:00", "2009-03-29 00:00:00", "2009-10-25 00:00:00", 
"2010-03-28 00:00:00", "2010-10-31 00:00:00", "2011-03-27 00:00:00", 
"2011-10-30 00:00:00", "2012-03-25 00:00:00", "2012-10-28 00:00:00", 
"2013-03-31 00:00:00", "2013-10-27 00:00:00", "2014-03-30 00:00:00", 
"2014-10-26 00:00:00", "2015-03-29 00:00:00", "2015-10-25 00:00:00", 
"2016-03-27 00:00:00", "2016-10-30 00:00:00", "2017-03-26 00:00:00", 
"2017-10-29 00:00:00", "2018-03-25 00:00:00", "2018-10-28 00:00:00", 
"2019-03-31 00:00:00", "2019-10-27 00:00:00", "2020-03-29 00:00:00", 
"2020-10-25 00:00:00", "2021-03-28 00:00:00", "2021-10-31 00:00:00", 
"2022-03-27 00:00:00", "2022-10-30 00:00:00", "2023-03-26 00:00:00", 
"2023-10-29 00:00:00", "2024-03-31 00:00:00", "2024-10-27 00:00:00", 
"2025-03-30 00:00:00", "2025-10-26 00:00:00", "2026-03-29 00:00:00", 
"2026-10-25 00:00:00", "2027-03-28 00:00:00", "2027-10-31 00:00:00", 
"2028-03-26 00:00:00", "2028-10-29 00:00:00", "2029-03-25 00:00:00", 
"2029-10-28 00:00:00", "2030-03-31 00:00:00", "2030-10-27 00:00:00", 
"2031-03-30 00:00:00", "2031-10-26 00:00:00", "2032-03-28 00:00:00", 
"2032-10-31 00:00:00", "2033-03-27 00:00:00", "2033-10-30 00:00:00", 
"2034-03-26 00:00:00", "2034-10-29 00:00:00", "2035-03-25 00:00:00", 
"2035-10-28 00:00:00", "2036-03-30 00:00:00", "2036-10-26 00:00:00", 
"2037-03-29 00:00:00", "2037-10-25 00:00:00"), offSet = c(11964L, 
10800L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 10800L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L), isdst = c(0L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "BAKT", 
"BAKT", "BAKST", "BAKT", "BAKST", "BAKT", "BAKST", "BAKT", "BAKST", 
"BAKT", "BAKST", "BAKT", "BAKST", "BAKT", "BAKST", "BAKT", "BAKST", 
"BAKT", "BAKST", "BAKT", "BAKST", "AZST", "AZT", "AZT", "AZST", 
"AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", 
"AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", 
"AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", 
"AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", 
"AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", 
"AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", 
"AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", 
"AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", 
"AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", "AZST", "AZT", 
"AZST", "AZT"), numeric = c(-2147397248, -1441163964, -405140400, 
354916800, 370724400, 386452800, 402260400, 417988800, 433796400, 
449611200, 465343200, 481068000, 496792800, 512517600, 528242400, 
543967200, 559692000, 575416800, 591141600, 606866400, 622591200, 
638316000, 683496000, 686098800, 717534000, 828234000, 846378000, 
859680000, 877824000, 891129600, 909273600, 922579200, 941328000, 
954028800, 972777600, 985478400, 1004227200, 1017532800, 1035676800, 
1048982400, 1067126400, 1080432000, 1099180800, 1111881600, 1130630400, 
1143331200, 1162080000, 1174780800, 1193529600, 1206835200, 1224979200, 
1238284800, 1256428800, 1269734400, 1288483200, 1301184000, 1319932800, 
1332633600, 1351382400, 1364688000, 1382832000, 1396137600, 1414281600, 
1427587200, 1445731200, 1459036800, 1477785600, 1490486400, 1509235200, 
1521936000, 1540684800, 1553990400, 1572134400, 1585440000, 1603584000, 
1616889600, 1635638400, 1648339200, 1667088000, 1679788800, 1698537600, 
1711843200, 1729987200, 1743292800, 1761436800, 1774742400, 1792886400, 
1806192000, 1824940800, 1837641600, 1856390400, 1869091200, 1887840000, 
1901145600, 1919289600, 1932595200, 1950739200, 1964044800, 1982793600, 
1995494400, 2014243200, 2026944000, 2045692800, 2058393600, 2077142400, 
2090448000, 2108592000, 2121897600, 2140041600)), .Names = c("Baku", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-109L), class = "data.frame")
}

"Bangkok" <- function () {
structure(list(Bangkok = c("1901-12-14 20:45:52", "1920-03-31 17:17:56"
), offSet = c(24124L, 25200L), isdst = c(0L, 0L), TimeZone = c("BMT", 
"ICT"), numeric = c(-2147397248, -1570084924)), .Names = c("Bangkok", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Beirut" <- function () {
structure(list(Beirut = c("1901-12-14 20:45:52", "1920-03-27 22:00:00", 
"1920-10-24 21:00:00", "1921-04-02 22:00:00", "1921-10-02 21:00:00", 
"1922-03-25 22:00:00", "1922-10-07 21:00:00", "1923-04-21 22:00:00", 
"1923-09-15 21:00:00", "1957-04-30 22:00:00", "1957-09-30 21:00:00", 
"1958-04-30 22:00:00", "1958-09-30 21:00:00", "1959-04-30 22:00:00", 
"1959-09-30 21:00:00", "1960-04-30 22:00:00", "1960-09-30 21:00:00", 
"1961-04-30 22:00:00", "1961-09-30 21:00:00", "1972-06-21 22:00:00", 
"1972-09-30 21:00:00", "1973-04-30 22:00:00", "1973-09-30 21:00:00", 
"1974-04-30 22:00:00", "1974-09-30 21:00:00", "1975-04-30 22:00:00", 
"1975-09-30 21:00:00", "1976-04-30 22:00:00", "1976-09-30 21:00:00", 
"1977-04-30 22:00:00", "1977-09-30 21:00:00", "1978-04-29 22:00:00", 
"1978-09-29 21:00:00", "1984-04-30 22:00:00", "1984-10-15 21:00:00", 
"1985-04-30 22:00:00", "1985-10-15 21:00:00", "1986-04-30 22:00:00", 
"1986-10-15 21:00:00", "1987-04-30 22:00:00", "1987-10-15 21:00:00", 
"1988-05-31 22:00:00", "1988-10-15 21:00:00", "1989-05-09 22:00:00", 
"1989-10-15 21:00:00", "1990-04-30 22:00:00", "1990-10-15 21:00:00", 
"1991-04-30 22:00:00", "1991-10-15 21:00:00", "1992-04-30 22:00:00", 
"1992-10-03 21:00:00", "1993-03-27 22:00:00", "1993-09-25 21:00:00", 
"1994-03-26 22:00:00", "1994-09-24 21:00:00", "1995-03-25 22:00:00", 
"1995-09-23 21:00:00", "1996-03-30 22:00:00", "1996-09-28 21:00:00", 
"1997-03-29 22:00:00", "1997-09-27 21:00:00", "1998-03-28 22:00:00", 
"1998-09-26 21:00:00", "1999-03-27 22:00:00", "1999-10-30 21:00:00", 
"2000-03-25 22:00:00", "2000-10-28 21:00:00", "2001-03-24 22:00:00", 
"2001-10-27 21:00:00", "2002-03-30 22:00:00", "2002-10-26 21:00:00", 
"2003-03-29 22:00:00", "2003-10-25 21:00:00", "2004-03-27 22:00:00", 
"2004-10-30 21:00:00", "2005-03-26 22:00:00", "2005-10-29 21:00:00", 
"2006-03-25 22:00:00", "2006-10-28 21:00:00", "2007-03-24 22:00:00", 
"2007-10-27 21:00:00", "2008-03-29 22:00:00", "2008-10-25 21:00:00", 
"2009-03-28 22:00:00", "2009-10-24 21:00:00", "2010-03-27 22:00:00", 
"2010-10-30 21:00:00", "2011-03-26 22:00:00", "2011-10-29 21:00:00", 
"2012-03-24 22:00:00", "2012-10-27 21:00:00", "2013-03-30 22:00:00", 
"2013-10-26 21:00:00", "2014-03-29 22:00:00", "2014-10-25 21:00:00", 
"2015-03-28 22:00:00", "2015-10-24 21:00:00", "2016-03-26 22:00:00", 
"2016-10-29 21:00:00", "2017-03-25 22:00:00", "2017-10-28 21:00:00", 
"2018-03-24 22:00:00", "2018-10-27 21:00:00", "2019-03-30 22:00:00", 
"2019-10-26 21:00:00", "2020-03-28 22:00:00", "2020-10-24 21:00:00", 
"2021-03-27 22:00:00", "2021-10-30 21:00:00", "2022-03-26 22:00:00", 
"2022-10-29 21:00:00", "2023-03-25 22:00:00", "2023-10-28 21:00:00", 
"2024-03-30 22:00:00", "2024-10-26 21:00:00", "2025-03-29 22:00:00", 
"2025-10-25 21:00:00", "2026-03-28 22:00:00", "2026-10-24 21:00:00", 
"2027-03-27 22:00:00", "2027-10-30 21:00:00", "2028-03-25 22:00:00", 
"2028-10-28 21:00:00", "2029-03-24 22:00:00", "2029-10-27 21:00:00", 
"2030-03-30 22:00:00", "2030-10-26 21:00:00", "2031-03-29 22:00:00", 
"2031-10-25 21:00:00", "2032-03-27 22:00:00", "2032-10-30 21:00:00", 
"2033-03-26 22:00:00", "2033-10-29 21:00:00", "2034-03-25 22:00:00", 
"2034-10-28 21:00:00", "2035-03-24 22:00:00", "2035-10-27 21:00:00", 
"2036-03-29 22:00:00", "2036-10-25 21:00:00", "2037-03-28 22:00:00", 
"2037-10-24 21:00:00"), offSet = c(7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L), TimeZone = c("EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET"), numeric = c(-2147397248, -1570413600, -1552186800, -1538359200, 
-1522551600, -1507514400, -1490583600, -1473645600, -1460948400, 
-399866400, -386650800, -368330400, -355114800, -336794400, -323578800, 
-305172000, -291956400, -273636000, -260420400, 78012000, 86734800, 
105055200, 118270800, 136591200, 149806800, 168127200, 181342800, 
199749600, 212965200, 231285600, 244501200, 262735200, 275950800, 
452210400, 466722000, 483746400, 498258000, 515282400, 529794000, 
546818400, 561330000, 581119200, 592952400, 610754400, 624488400, 
641512800, 656024400, 673048800, 687560400, 704671200, 718146000, 
733269600, 748990800, 764719200, 780440400, 796168800, 811890000, 
828223200, 843944400, 859672800, 875394000, 891122400, 906843600, 
922572000, 941317200, 954021600, 972766800, 985471200, 1004216400, 
1017525600, 1035666000, 1048975200, 1067115600, 1080424800, 1099170000, 
1111874400, 1130619600, 1143324000, 1162069200, 1174773600, 1193518800, 
1206828000, 1224968400, 1238277600, 1256418000, 1269727200, 1288472400, 
1301176800, 1319922000, 1332626400, 1351371600, 1364680800, 1382821200, 
1396130400, 1414270800, 1427580000, 1445720400, 1459029600, 1477774800, 
1490479200, 1509224400, 1521928800, 1540674000, 1553983200, 1572123600, 
1585432800, 1603573200, 1616882400, 1635627600, 1648332000, 1667077200, 
1679781600, 1698526800, 1711836000, 1729976400, 1743285600, 1761426000, 
1774735200, 1792875600, 1806184800, 1824930000, 1837634400, 1856379600, 
1869084000, 1887829200, 1901138400, 1919278800, 1932588000, 1950728400, 
1964037600, 1982782800, 1995487200, 2014232400, 2026936800, 2045682000, 
2058386400, 2077131600, 2090440800, 2108581200, 2121890400, 2140030800
)), .Names = c("Beirut", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -141L), class = "data.frame")
}

"Bishkek" <- function () {
structure(list(Bishkek = c("1901-12-14 20:45:52", "1924-05-01 19:01:36", 
"1930-06-20 19:00:00", "1981-03-31 18:00:00", "1981-09-30 17:00:00", 
"1982-03-31 18:00:00", "1982-09-30 17:00:00", "1983-03-31 18:00:00", 
"1983-09-30 17:00:00", "1984-03-31 18:00:00", "1984-09-29 20:00:00", 
"1985-03-30 20:00:00", "1985-09-28 20:00:00", "1986-03-29 20:00:00", 
"1986-09-27 20:00:00", "1987-03-28 20:00:00", "1987-09-26 20:00:00", 
"1988-03-26 20:00:00", "1988-09-24 20:00:00", "1989-03-25 20:00:00", 
"1989-09-23 20:00:00", "1990-03-24 20:00:00", "1991-03-30 20:00:00", 
"1991-08-30 20:00:00", "1992-04-11 19:00:00", "1992-09-26 18:00:00", 
"1993-04-10 19:00:00", "1993-09-25 18:00:00", "1994-04-09 19:00:00", 
"1994-09-24 18:00:00", "1995-04-08 19:00:00", "1995-09-23 18:00:00", 
"1996-04-06 19:00:00", "1996-09-28 18:00:00", "1997-03-29 21:30:00", 
"1997-10-25 20:30:00", "1998-03-28 21:30:00", "1998-10-24 20:30:00", 
"1999-03-27 21:30:00", "1999-10-30 20:30:00", "2000-03-25 21:30:00", 
"2000-10-28 20:30:00", "2001-03-24 21:30:00", "2001-10-27 20:30:00", 
"2002-03-30 21:30:00", "2002-10-26 20:30:00", "2003-03-29 21:30:00", 
"2003-10-25 20:30:00", "2004-03-27 21:30:00", "2004-10-30 20:30:00", 
"2005-03-26 21:30:00"), offSet = c(17904L, 18000L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 
21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 
21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 
21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L), isdst = c(0L, 
0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L), TimeZone = c("LMT", "FRUT", "FRUT", "FRUST", "FRUT", 
"FRUST", "FRUT", "FRUST", "FRUT", "FRUST", "FRUT", "FRUST", "FRUT", 
"FRUST", "FRUT", "FRUST", "FRUT", "FRUST", "FRUT", "FRUST", "FRUT", 
"FRUST", "FRUST", "KGT", "KGST", "KGT", "KGST", "KGT", "KGST", 
"KGT", "KGST", "KGT", "KGST", "KGT", "KGST", "KGT", "KGST", "KGT", 
"KGST", "KGT", "KGST", "KGT", "KGST", "KGT", "KGST", "KGT", "KGST", 
"KGT", "KGST", "KGT", "KGST"), numeric = c(-2147397248, -1441169904, 
-1247547600, 354909600, 370717200, 386445600, 402253200, 417981600, 
433789200, 449604000, 465336000, 481060800, 496785600, 512510400, 
528235200, 543960000, 559684800, 575409600, 591134400, 606859200, 
622584000, 638308800, 670363200, 683582400, 703018800, 717530400, 
734468400, 748980000, 765918000, 780429600, 797367600, 811879200, 
828817200, 843933600, 859671000, 877811400, 891120600, 909261000, 
922570200, 941315400, 954019800, 972765000, 985469400, 1004214600, 
1017523800, 1035664200, 1048973400, 1067113800, 1080423000, 1099168200, 
1111872600)), .Names = c("Bishkek", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -51L), class = "data.frame")
}

"Brunei" <- function () {
structure(list(Brunei = c("1901-12-14 20:45:52", "1926-02-28 16:20:20", 
"1932-12-31 16:30:00"), offSet = c(27580L, 27000L, 28800L), isdst = c(0L, 
0L, 0L), TimeZone = c("LMT", "BNT", "BNT"), numeric = c(-2147397248, 
-1383464380, -1167636600)), .Names = c("Brunei", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -3L), class = "data.frame")
}

"Calcutta" <- function () {
structure(list(Calcutta = c("1901-12-14 20:45:52", "1941-09-30 18:06:40", 
"1942-05-14 17:30:00", "1942-08-31 18:30:00", "1945-10-14 17:30:00"
), offSet = c(21200L, 23400L, 19800L, 23400L, 19800L), isdst = c(0L, 
0L, 0L, 1L, 0L), TimeZone = c("HMT", "BURT", "IST", "IST", "IST"
), numeric = c(-2147397248, -891582800, -872058600, -862637400, 
-764145000)), .Names = c("Calcutta", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -5L), class = "data.frame")
}

"Choibalsan" <- function () {
structure(list(Choibalsan = c("1901-12-14 20:45:52", "1905-07-31 16:22:00", 
"1977-12-31 17:00:00", "1983-03-31 16:00:00", "1983-09-30 14:00:00", 
"1984-03-31 15:00:00", "1984-09-29 14:00:00", "1985-03-30 15:00:00", 
"1985-09-28 14:00:00", "1986-03-29 15:00:00", "1986-09-27 14:00:00", 
"1987-03-28 15:00:00", "1987-09-26 14:00:00", "1988-03-26 15:00:00", 
"1988-09-24 14:00:00", "1989-03-25 15:00:00", "1989-09-23 14:00:00", 
"1990-03-24 15:00:00", "1990-09-29 14:00:00", "1991-03-30 15:00:00", 
"1991-09-28 14:00:00", "1992-03-28 15:00:00", "1992-09-26 14:00:00", 
"1993-03-27 15:00:00", "1993-09-25 14:00:00", "1994-03-26 15:00:00", 
"1994-09-24 14:00:00", "1995-03-25 15:00:00", "1995-09-23 14:00:00", 
"1996-03-30 15:00:00", "1996-09-28 14:00:00", "1997-03-29 15:00:00", 
"1997-09-27 14:00:00", "1998-03-28 15:00:00", "1998-09-26 14:00:00", 
"2001-04-27 17:00:00", "2001-09-28 16:00:00", "2002-03-29 17:00:00", 
"2002-09-27 16:00:00", "2003-03-28 17:00:00", "2003-09-26 16:00:00", 
"2004-03-26 17:00:00", "2004-09-24 16:00:00", "2005-03-25 17:00:00", 
"2005-09-23 16:00:00", "2006-03-24 17:00:00", "2006-09-29 16:00:00", 
"2008-03-30 15:00:00"), offSet = c(27480L, 25200L, 28800L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 28800L), isdst = c(0L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L), TimeZone = c("LMT", 
"ULAT", "ULAT", "CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", 
"CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", 
"CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", 
"CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", 
"CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", 
"CHOST", "CHOT", "CHOST", "CHOT", "CHOST", "CHOT", "CHOT"), numeric = c(-2147397248, 
-2032933080, 252435600, 417974400, 433778400, 449593200, 465314400, 
481042800, 496764000, 512492400, 528213600, 543942000, 559663200, 
575391600, 591112800, 606841200, 622562400, 638290800, 654616800, 
670345200, 686066400, 701794800, 717516000, 733244400, 748965600, 
764694000, 780415200, 796143600, 811864800, 828198000, 843919200, 
859647600, 875368800, 891097200, 906818400, 988390800, 1001692800, 
1017421200, 1033142400, 1048870800, 1064592000, 1080320400, 1096041600, 
1111770000, 1127491200, 1143219600, 1159545600, 1206889200)), .Names = c("Choibalsan", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-48L), class = "data.frame")
}

"Chongqing" <- function () {
structure(list(Chongqing = c("1901-12-14 20:45:52", "1927-12-31 16:53:40", 
"1980-04-30 17:00:00", "1986-05-03 16:00:00", "1986-09-13 15:00:00", 
"1987-04-11 16:00:00", "1987-09-12 15:00:00", "1988-04-09 16:00:00", 
"1988-09-10 15:00:00", "1989-04-15 16:00:00", "1989-09-16 15:00:00", 
"1990-04-14 16:00:00", "1990-09-15 15:00:00", "1991-04-13 16:00:00", 
"1991-09-14 15:00:00"), offSet = c(25580L, 25200L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "LONT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST"), numeric = c(-2147397248, -1325487980, 
325962000, 515520000, 527007600, 545155200, 558457200, 576604800, 
589906800, 608659200, 621961200, 640108800, 653410800, 671558400, 
684860400)), .Names = c("Chongqing", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -15L), class = "data.frame")
}

"Colombo" <- function () {
structure(list(Colombo = c("1901-12-14 20:45:52", "1905-12-31 18:40:28", 
"1942-01-04 18:30:00", "1942-08-31 18:00:00", "1945-10-15 19:30:00", 
"1996-05-24 18:30:00", "1996-10-25 18:00:00", "2006-04-14 18:30:00"
), offSet = c(19172L, 19800L, 21600L, 23400L, 19800L, 23400L, 
21600L, 19800L), isdst = c(0L, 0L, 1L, 1L, 0L, 0L, 0L, 0L), TimeZone = c("MMT", 
"IST", "IHST", "IST", "IST", "LKT", "LKT", "IST"), numeric = c(-2147397248, 
-2019705572, -883287000, -862639200, -764051400, 832962600, 846266400, 
1145039400)), .Names = c("Colombo", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -8L), class = "data.frame")
}

"Damascus" <- function () {
structure(list(Damascus = c("1901-12-14 20:45:52", "1919-12-31 21:34:48", 
"1920-04-18 00:00:00", "1920-10-02 23:00:00", "1921-04-17 00:00:00", 
"1921-10-01 23:00:00", "1922-04-16 00:00:00", "1922-09-30 23:00:00", 
"1923-04-15 00:00:00", "1923-10-06 23:00:00", "1962-04-29 00:00:00", 
"1962-09-30 23:00:00", "1963-05-01 00:00:00", "1963-09-29 23:00:00", 
"1964-05-01 00:00:00", "1964-09-30 23:00:00", "1965-05-01 00:00:00", 
"1965-09-29 23:00:00", "1966-04-24 00:00:00", "1966-09-30 23:00:00", 
"1967-05-01 00:00:00", "1967-09-30 23:00:00", "1968-05-01 00:00:00", 
"1968-09-30 23:00:00", "1969-05-01 00:00:00", "1969-09-30 23:00:00", 
"1970-05-01 00:00:00", "1970-09-30 23:00:00", "1971-05-01 00:00:00", 
"1971-09-30 23:00:00", "1972-05-01 00:00:00", "1972-09-30 23:00:00", 
"1973-05-01 00:00:00", "1973-09-30 23:00:00", "1974-05-01 00:00:00", 
"1974-09-30 23:00:00", "1975-05-01 00:00:00", "1975-09-30 23:00:00", 
"1976-05-01 00:00:00", "1976-09-30 23:00:00", "1977-05-01 00:00:00", 
"1977-08-31 23:00:00", "1978-05-01 00:00:00", "1978-08-31 23:00:00", 
"1983-04-09 00:00:00", "1983-09-30 23:00:00", "1984-04-09 00:00:00", 
"1984-09-30 23:00:00", "1986-02-16 00:00:00", "1986-10-08 23:00:00", 
"1987-03-01 00:00:00", "1987-10-30 23:00:00", "1988-03-15 00:00:00", 
"1988-10-30 23:00:00", "1989-03-31 00:00:00", "1989-09-30 23:00:00", 
"1990-04-01 00:00:00", "1990-09-29 23:00:00", "1991-03-31 22:00:00", 
"1991-09-30 21:00:00", "1992-04-07 22:00:00", "1992-09-30 21:00:00", 
"1993-03-25 22:00:00", "1993-09-24 21:00:00", "1994-03-31 22:00:00", 
"1994-09-30 21:00:00", "1995-03-31 22:00:00", "1995-09-30 21:00:00", 
"1996-03-31 22:00:00", "1996-09-30 21:00:00", "1997-03-30 22:00:00", 
"1997-09-30 21:00:00", "1998-03-29 22:00:00", "1998-09-30 21:00:00", 
"1999-03-31 22:00:00", "1999-09-30 21:00:00", "2000-03-31 22:00:00", 
"2000-09-30 21:00:00", "2001-03-31 22:00:00", "2001-09-30 21:00:00", 
"2002-03-31 22:00:00", "2002-09-30 21:00:00", "2003-03-31 22:00:00", 
"2003-09-30 21:00:00", "2004-03-31 22:00:00", "2004-09-30 21:00:00", 
"2005-03-31 22:00:00", "2005-09-30 21:00:00", "2006-03-31 22:00:00", 
"2006-09-21 21:00:00", "2007-03-29 22:00:00", "2007-11-01 21:00:00", 
"2008-04-03 22:00:00", "2008-10-31 21:00:00", "2009-04-02 22:00:00", 
"2009-10-31 21:00:00", "2010-04-01 22:00:00", "2010-10-31 21:00:00", 
"2011-03-31 22:00:00", "2011-10-31 21:00:00", "2012-04-05 22:00:00", 
"2012-10-31 21:00:00", "2013-04-04 22:00:00", "2013-10-31 21:00:00", 
"2014-04-03 22:00:00", "2014-10-31 21:00:00", "2015-04-02 22:00:00", 
"2015-10-31 21:00:00", "2016-03-31 22:00:00", "2016-10-31 21:00:00", 
"2017-04-06 22:00:00", "2017-10-31 21:00:00", "2018-04-05 22:00:00", 
"2018-10-31 21:00:00", "2019-04-04 22:00:00", "2019-10-31 21:00:00", 
"2020-04-02 22:00:00", "2020-10-31 21:00:00", "2021-04-01 22:00:00", 
"2021-10-31 21:00:00", "2022-03-31 22:00:00", "2022-10-31 21:00:00", 
"2023-04-06 22:00:00", "2023-10-31 21:00:00", "2024-04-04 22:00:00", 
"2024-10-31 21:00:00", "2025-04-03 22:00:00", "2025-10-31 21:00:00", 
"2026-04-02 22:00:00", "2026-10-31 21:00:00", "2027-04-01 22:00:00", 
"2027-10-31 21:00:00", "2028-04-06 22:00:00", "2028-10-31 21:00:00", 
"2029-04-05 22:00:00", "2029-10-31 21:00:00", "2030-04-04 22:00:00", 
"2030-10-31 21:00:00", "2031-04-03 22:00:00", "2031-10-31 21:00:00", 
"2032-04-01 22:00:00", "2032-10-31 21:00:00", "2033-03-31 22:00:00", 
"2033-10-31 21:00:00", "2034-04-06 22:00:00", "2034-10-31 21:00:00", 
"2035-04-05 22:00:00", "2035-10-31 21:00:00", "2036-04-03 22:00:00", 
"2036-10-31 21:00:00", "2037-04-02 22:00:00", "2037-10-31 21:00:00"
), offSet = c(8712L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET"), numeric = c(-2147397248, 
-1577931912, -1568592000, -1554080400, -1537142400, -1522630800, 
-1505692800, -1491181200, -1474243200, -1459126800, -242265600, 
-228877200, -210556800, -197427600, -178934400, -165718800, -147398400, 
-134269200, -116467200, -102646800, -84326400, -71110800, -52704000, 
-39488400, -21168000, -7952400, 10368000, 23583600, 41904000, 
55119600, 73526400, 86742000, 105062400, 118278000, 136598400, 
149814000, 168134400, 181350000, 199756800, 212972400, 231292800, 
241916400, 262828800, 273452400, 418694400, 433810800, 450316800, 
465433200, 508896000, 529196400, 541555200, 562633200, 574387200, 
594255600, 607305600, 623199600, 638928000, 654649200, 670456800, 
686264400, 702684000, 717886800, 733096800, 748904400, 765151200, 
780958800, 796687200, 812494800, 828309600, 844117200, 859759200, 
875653200, 891208800, 907189200, 922917600, 938725200, 954540000, 
970347600, 986076000, 1001883600, 1017612000, 1033419600, 1049148000, 
1064955600, 1080770400, 1096578000, 1112306400, 1128114000, 1143842400, 
1158872400, 1175205600, 1193950800, 1207260000, 1225486800, 1238709600, 
1257022800, 1270159200, 1288558800, 1301608800, 1320094800, 1333663200, 
1351717200, 1365112800, 1383253200, 1396562400, 1414789200, 1428012000, 
1446325200, 1459461600, 1477947600, 1491516000, 1509483600, 1522965600, 
1541019600, 1554415200, 1572555600, 1585864800, 1604178000, 1617314400, 
1635714000, 1648764000, 1667250000, 1680818400, 1698786000, 1712268000, 
1730408400, 1743717600, 1761944400, 1775167200, 1793480400, 1806616800, 
1825016400, 1838671200, 1856638800, 1870120800, 1888174800, 1901570400, 
1919710800, 1933020000, 1951246800, 1964469600, 1982869200, 1995919200, 
2014405200, 2027973600, 2045941200, 2059423200, 2077477200, 2090872800, 
2109099600, 2122322400, 2140635600)), .Names = c("Damascus", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-152L), class = "data.frame")
}

"Dhaka" <- function () {
structure(list(Dhaka = c("1901-12-14 20:45:52", "1941-09-30 18:06:40", 
"1942-05-14 17:30:00", "1942-08-31 18:30:00", "1951-09-29 17:30:00"
), offSet = c(21200L, 23400L, 19800L, 23400L, 21600L), isdst = c(0L, 
0L, 0L, 0L, 0L), TimeZone = c("HMT", "BURT", "IST", "BURT", "DACT"
), numeric = c(-2147397248, -891582800, -872058600, -862637400, 
-576138600)), .Names = c("Dhaka", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -5L), class = "data.frame")
}

"Dili" <- function () {
structure(list(Dili = c("1901-12-14 20:45:52", "1911-12-31 15:37:40", 
"1945-09-22 15:00:00", "1976-05-02 15:00:00", "2000-09-16 16:00:00"
), offSet = c(30140L, 28800L, 32400L, 28800L, 32400L), isdst = c(0L, 
0L, 0L, 0L, 0L), TimeZone = c("LMT", "TLT", "TLT", "CIT", "TLT"
), numeric = c(-2147397248, -1830414140, -766054800, 199897200, 
969120000)), .Names = c("Dili", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -5L), class = "data.frame")
}

"Dubai" <- function () {
structure(list(Dubai = c("1901-12-14 20:45:52", "1919-12-31 20:18:48"
), offSet = c(13272L, 14400L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"GST"), numeric = c(-2147397248, -1577936472)), .Names = c("Dubai", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Dushanbe" <- function () {
structure(list(Dushanbe = c("1901-12-14 20:45:52", "1924-05-01 19:24:48", 
"1930-06-20 19:00:00", "1981-03-31 18:00:00", "1981-09-30 17:00:00", 
"1982-03-31 18:00:00", "1982-09-30 17:00:00", "1983-03-31 18:00:00", 
"1983-09-30 17:00:00", "1984-03-31 18:00:00", "1984-09-29 20:00:00", 
"1985-03-30 20:00:00", "1985-09-28 20:00:00", "1986-03-29 20:00:00", 
"1986-09-27 20:00:00", "1987-03-28 20:00:00", "1987-09-26 20:00:00", 
"1988-03-26 20:00:00", "1988-09-24 20:00:00", "1989-03-25 20:00:00", 
"1989-09-23 20:00:00", "1990-03-24 20:00:00", "1991-03-30 20:00:00", 
"1991-09-08 21:00:00"), offSet = c(16512L, 18000L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 18000L), isdst = c(0L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 1L, 0L), TimeZone = c("LMT", "DUST", "DUST", "DUSST", "DUST", 
"DUSST", "DUST", "DUSST", "DUST", "DUSST", "DUST", "DUSST", "DUST", 
"DUSST", "DUST", "DUSST", "DUST", "DUSST", "DUST", "DUSST", "DUST", 
"DUSST", "DUSST", "TJT"), numeric = c(-2147397248, -1441168512, 
-1247547600, 354909600, 370717200, 386445600, 402253200, 417981600, 
433789200, 449604000, 465336000, 481060800, 496785600, 512510400, 
528235200, 543960000, 559684800, 575409600, 591134400, 606859200, 
622584000, 638308800, 670363200, 684363600)), .Names = c("Dushanbe", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-24L), class = "data.frame")
}

"Gaza" <- function () {
structure(list(Gaza = c("1901-12-14 20:45:52", "1940-05-31 22:00:00", 
"1942-10-31 21:00:00", "1943-04-01 00:00:00", "1943-10-31 21:00:00", 
"1944-03-31 22:00:00", "1944-10-31 21:00:00", "1945-04-15 22:00:00", 
"1945-10-31 23:00:00", "1946-04-16 00:00:00", "1946-10-31 21:00:00", 
"1957-05-09 22:00:00", "1957-09-30 21:00:00", "1958-04-30 22:00:00", 
"1958-09-30 21:00:00", "1959-04-30 23:00:00", "1959-09-30 00:00:00", 
"1960-04-30 23:00:00", "1960-09-30 00:00:00", "1961-04-30 23:00:00", 
"1961-09-30 00:00:00", "1962-04-30 23:00:00", "1962-09-30 00:00:00", 
"1963-04-30 23:00:00", "1963-09-30 00:00:00", "1964-04-30 23:00:00", 
"1964-09-30 00:00:00", "1965-04-30 23:00:00", "1965-09-30 00:00:00", 
"1966-04-30 23:00:00", "1966-10-01 00:00:00", "1967-04-30 23:00:00", 
"1967-06-04 21:00:00", "1974-07-06 22:00:00", "1974-10-12 21:00:00", 
"1975-04-19 22:00:00", "1975-08-30 21:00:00", "1985-04-13 22:00:00", 
"1985-09-14 21:00:00", "1986-05-17 22:00:00", "1986-09-06 21:00:00", 
"1987-04-14 22:00:00", "1987-09-12 21:00:00", "1988-04-08 22:00:00", 
"1988-09-02 21:00:00", "1989-04-29 22:00:00", "1989-09-02 21:00:00", 
"1990-03-24 22:00:00", "1990-08-25 21:00:00", "1991-03-23 22:00:00", 
"1991-08-31 21:00:00", "1992-03-28 22:00:00", "1992-09-05 21:00:00", 
"1993-04-01 22:00:00", "1993-09-04 21:00:00", "1994-03-31 22:00:00", 
"1994-08-27 21:00:00", "1995-03-30 22:00:00", "1995-12-31 22:00:00", 
"1996-04-04 22:00:00", "1996-09-19 22:00:00", "1997-04-03 22:00:00", 
"1997-09-18 22:00:00", "1998-04-02 22:00:00", "1998-09-17 22:00:00", 
"1999-04-15 22:00:00", "1999-10-14 21:00:00", "2000-04-20 22:00:00", 
"2000-10-19 21:00:00", "2001-04-19 22:00:00", "2001-10-18 21:00:00", 
"2002-04-18 22:00:00", "2002-10-17 21:00:00", "2003-04-17 22:00:00", 
"2003-10-16 21:00:00", "2004-04-15 22:00:00", "2004-09-30 22:00:00", 
"2005-04-14 22:00:00", "2005-10-03 23:00:00", "2006-03-31 22:00:00", 
"2006-09-21 21:00:00", "2007-03-31 22:00:00", "2007-09-12 23:00:00", 
"2008-03-31 22:00:00", "2008-08-27 23:00:00", "2009-03-31 22:00:00", 
"2009-08-26 23:00:00", "2010-03-31 22:00:00", "2010-08-25 23:00:00", 
"2011-03-31 22:00:00", "2011-08-24 23:00:00", "2012-03-31 22:00:00", 
"2012-08-29 23:00:00", "2013-03-31 22:00:00", "2013-08-28 23:00:00", 
"2014-03-31 22:00:00", "2014-08-27 23:00:00", "2015-03-31 22:00:00", 
"2015-08-26 23:00:00", "2016-03-31 22:00:00", "2016-08-24 23:00:00", 
"2017-03-31 22:00:00", "2017-08-30 23:00:00", "2018-03-31 22:00:00", 
"2018-08-29 23:00:00", "2019-03-31 22:00:00", "2019-08-28 23:00:00", 
"2020-03-31 22:00:00", "2020-08-26 23:00:00", "2021-03-31 22:00:00", 
"2021-08-25 23:00:00", "2022-03-31 22:00:00", "2022-08-24 23:00:00", 
"2023-03-31 22:00:00", "2023-08-30 23:00:00", "2024-03-31 22:00:00", 
"2024-08-28 23:00:00", "2025-03-31 22:00:00", "2025-08-27 23:00:00", 
"2026-03-31 22:00:00", "2026-08-26 23:00:00", "2027-03-31 22:00:00", 
"2027-08-25 23:00:00", "2028-03-31 22:00:00", "2028-08-30 23:00:00", 
"2029-03-31 22:00:00", "2029-08-29 23:00:00", "2030-03-31 22:00:00", 
"2030-08-28 23:00:00", "2031-03-31 22:00:00", "2031-08-27 23:00:00", 
"2032-03-31 22:00:00", "2032-08-25 23:00:00", "2033-03-31 22:00:00", 
"2033-08-24 23:00:00", "2034-03-31 22:00:00", "2034-08-30 23:00:00", 
"2035-03-31 22:00:00", "2035-08-29 23:00:00", "2036-03-31 22:00:00", 
"2036-08-27 23:00:00", "2037-03-31 22:00:00", "2037-08-26 23:00:00"
), offSet = c(7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L), TimeZone = c("EET", "EET", "EET", "EET", "EET", 
"EET", "EET", "EET", "EET", "EET", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", 
"IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET"), numeric = c(-2147397248, -933645600, -857358000, 
-844300800, -825822000, -812685600, -794199600, -779853600, -762656400, 
-748310400, -731127600, -399088800, -386650800, -368330400, -355114800, 
-336790800, -323654400, -305168400, -292032000, -273632400, -260496000, 
-242096400, -228960000, -210560400, -197424000, -178938000, -165801600, 
-147402000, -134265600, -115866000, -102643200, -84330000, -81313200, 
142380000, 150843600, 167176800, 178664400, 482277600, 495579600, 
516751200, 526424400, 545436000, 558478800, 576540000, 589237200, 
609890400, 620773200, 638316000, 651618000, 669765600, 683672400, 
701820000, 715726800, 733701600, 747176400, 765151200, 778021200, 
796600800, 820447200, 828655200, 843170400, 860104800, 874620000, 
891554400, 906069600, 924213600, 939934800, 956268000, 971989200, 
987717600, 1003438800, 1019167200, 1034888400, 1050616800, 1066338000, 
1082066400, 1096581600, 1113516000, 1128380400, 1143842400, 1158872400, 
1175378400, 1189638000, 1207000800, 1219878000, 1238536800, 1251327600, 
1270072800, 1282777200, 1301608800, 1314226800, 1333231200, 1346281200, 
1364767200, 1377730800, 1396303200, 1409180400, 1427839200, 1440630000, 
1459461600, 1472079600, 1490997600, 1504134000, 1522533600, 1535583600, 
1554069600, 1567033200, 1585692000, 1598482800, 1617228000, 1629932400, 
1648764000, 1661382000, 1680300000, 1693436400, 1711922400, 1724886000, 
1743458400, 1756335600, 1774994400, 1787785200, 1806530400, 1819234800, 
1838152800, 1851289200, 1869688800, 1882738800, 1901224800, 1914188400, 
1932760800, 1945638000, 1964383200, 1977087600, 1995919200, 2008537200, 
2027455200, 2040591600, 2058991200, 2072041200, 2090613600, 2103490800, 
2122149600, 2134940400)), .Names = c("Gaza", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -143L), class = "data.frame")
}

"Harbin" <- function () {
structure(list(Harbin = c("1901-12-14 20:45:52", "1927-12-31 15:33:16", 
"1932-02-29 15:30:00", "1939-12-31 16:00:00", "1966-04-30 15:00:00", 
"1980-04-30 15:30:00", "1986-05-03 16:00:00", "1986-09-13 15:00:00", 
"1987-04-11 16:00:00", "1987-09-12 15:00:00", "1988-04-09 16:00:00", 
"1988-09-10 15:00:00", "1989-04-15 16:00:00", "1989-09-16 15:00:00", 
"1990-04-14 16:00:00", "1990-09-15 15:00:00", "1991-04-13 16:00:00", 
"1991-09-14 15:00:00"), offSet = c(30404L, 30600L, 28800L, 32400L, 
30600L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 
32400L, 28800L, 32400L, 28800L, 32400L, 28800L), isdst = c(0L, 
0L, 0L, 0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L), TimeZone = c("LMT", "CHAT", "CST", "CHAT", "CHAT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST"), numeric = c(-2147397248, -1325492804, -1194078600, 
-946800000, -115894800, 325956600, 515520000, 527007600, 545155200, 
558457200, 576604800, 589906800, 608659200, 621961200, 640108800, 
653410800, 671558400, 684860400)), .Names = c("Harbin", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -18L), class = "data.frame")
}

"Hong_Kong" <- function () {
structure(list(Hong_Kong = c("1901-12-14 20:45:52", "1904-10-29 16:23:24", 
"1946-04-19 19:30:00", "1946-11-30 18:30:00", "1947-04-12 19:30:00", 
"1947-12-29 18:30:00", "1948-05-01 19:30:00", "1948-10-30 18:30:00", 
"1949-04-02 19:30:00", "1949-10-29 18:30:00", "1950-04-01 19:30:00", 
"1950-10-28 18:30:00", "1951-03-31 19:30:00", "1951-10-27 18:30:00", 
"1952-04-05 19:30:00", "1952-10-25 18:30:00", "1953-04-04 19:30:00", 
"1953-10-31 18:30:00", "1954-03-20 19:30:00", "1954-10-30 18:30:00", 
"1955-03-19 19:30:00", "1955-11-05 18:30:00", "1956-03-17 19:30:00", 
"1956-11-03 18:30:00", "1957-03-23 19:30:00", "1957-11-02 18:30:00", 
"1958-03-22 19:30:00", "1958-11-01 18:30:00", "1959-03-21 19:30:00", 
"1959-10-31 18:30:00", "1960-03-19 19:30:00", "1960-11-05 18:30:00", 
"1961-03-18 19:30:00", "1961-11-04 18:30:00", "1962-03-17 19:30:00", 
"1962-11-03 18:30:00", "1963-03-23 19:30:00", "1963-11-02 18:30:00", 
"1964-03-21 19:30:00", "1964-10-31 18:30:00", "1965-04-17 19:30:00", 
"1965-10-16 18:30:00", "1966-04-16 19:30:00", "1966-10-15 18:30:00", 
"1967-04-15 19:30:00", "1967-10-21 18:30:00", "1968-04-20 19:30:00", 
"1968-10-19 18:30:00", "1969-04-19 19:30:00", "1969-10-18 18:30:00", 
"1970-04-18 19:30:00", "1970-10-17 18:30:00", "1971-04-17 19:30:00", 
"1971-10-16 18:30:00", "1972-04-15 19:30:00", "1972-10-21 18:30:00", 
"1973-04-21 19:30:00", "1973-10-20 18:30:00", "1974-04-20 19:30:00", 
"1974-10-19 18:30:00", "1975-04-19 19:30:00", "1975-10-18 18:30:00", 
"1976-04-17 19:30:00", "1976-10-16 18:30:00", "1977-04-16 19:30:00", 
"1977-10-15 18:30:00", "1979-05-12 19:30:00", "1979-10-20 18:30:00", 
"1980-05-10 19:30:00", "1980-10-18 18:30:00"), offSet = c(27396L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L), isdst = c(0L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L), TimeZone = c("LMT", "HKT", "HKST", "HKT", "HKST", 
"HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", 
"HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", 
"HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", 
"HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", 
"HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", 
"HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", 
"HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", "HKST", "HKT", 
"HKST", "HKT"), numeric = c(-2147397248, -2056692996, -747981000, 
-728544600, -717049800, -694503000, -683785800, -668064600, -654755400, 
-636615000, -623305800, -605165400, -591856200, -573715800, -559801800, 
-542266200, -528352200, -510211800, -498112200, -478762200, -466662600, 
-446707800, -435213000, -415258200, -403158600, -383808600, -371709000, 
-352359000, -340259400, -320909400, -308809800, -288855000, -277360200, 
-257405400, -245910600, -225955800, -213856200, -194506200, -182406600, 
-163056600, -148537800, -132816600, -117088200, -101367000, -85638600, 
-69312600, -53584200, -37863000, -22134600, -6413400, 9315000, 
25036200, 40764600, 56485800, 72214200, 88540200, 104268600, 
119989800, 135718200, 151439400, 167167800, 182889000, 198617400, 
214338600, 230067000, 245788200, 295385400, 309292200, 326835000, 
340741800)), .Names = c("Hong_Kong", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -70L), class = "data.frame")
}

"Hovd" <- function () {
structure(list(Hovd = c("1901-12-14 20:45:52", "1905-07-31 17:53:24", 
"1977-12-31 18:00:00", "1983-03-31 17:00:00", "1983-09-30 16:00:00", 
"1984-03-31 17:00:00", "1984-09-29 16:00:00", "1985-03-30 17:00:00", 
"1985-09-28 16:00:00", "1986-03-29 17:00:00", "1986-09-27 16:00:00", 
"1987-03-28 17:00:00", "1987-09-26 16:00:00", "1988-03-26 17:00:00", 
"1988-09-24 16:00:00", "1989-03-25 17:00:00", "1989-09-23 16:00:00", 
"1990-03-24 17:00:00", "1990-09-29 16:00:00", "1991-03-30 17:00:00", 
"1991-09-28 16:00:00", "1992-03-28 17:00:00", "1992-09-26 16:00:00", 
"1993-03-27 17:00:00", "1993-09-25 16:00:00", "1994-03-26 17:00:00", 
"1994-09-24 16:00:00", "1995-03-25 17:00:00", "1995-09-23 16:00:00", 
"1996-03-30 17:00:00", "1996-09-28 16:00:00", "1997-03-29 17:00:00", 
"1997-09-27 16:00:00", "1998-03-28 17:00:00", "1998-09-26 16:00:00", 
"2001-04-27 19:00:00", "2001-09-28 18:00:00", "2002-03-29 19:00:00", 
"2002-09-27 18:00:00", "2003-03-28 19:00:00", "2003-09-26 18:00:00", 
"2004-03-26 19:00:00", "2004-09-24 18:00:00", "2005-03-25 19:00:00", 
"2005-09-23 18:00:00", "2006-03-24 19:00:00", "2006-09-29 18:00:00"
), offSet = c(21996L, 21600L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L), TimeZone = c("LMT", "HOVT", "HOVT", "HOVST", 
"HOVT", "HOVST", "HOVT", "HOVST", "HOVT", "HOVST", "HOVT", "HOVST", 
"HOVT", "HOVST", "HOVT", "HOVST", "HOVT", "HOVST", "HOVT", "HOVST", 
"HOVT", "HOVST", "HOVT", "HOVST", "HOVT", "HOVST", "HOVT", "HOVST", 
"HOVT", "HOVST", "HOVT", "HOVST", "HOVT", "HOVST", "HOVT", "HOVST", 
"HOVT", "HOVST", "HOVT", "HOVST", "HOVT", "HOVST", "HOVT", "HOVST", 
"HOVT", "HOVST", "HOVT"), numeric = c(-2147397248, -2032927596, 
252439200, 417978000, 433785600, 449600400, 465321600, 481050000, 
496771200, 512499600, 528220800, 543949200, 559670400, 575398800, 
591120000, 606848400, 622569600, 638298000, 654624000, 670352400, 
686073600, 701802000, 717523200, 733251600, 748972800, 764701200, 
780422400, 796150800, 811872000, 828205200, 843926400, 859654800, 
875376000, 891104400, 906825600, 988398000, 1001700000, 1017428400, 
1033149600, 1048878000, 1064599200, 1080327600, 1096048800, 1111777200, 
1127498400, 1143226800, 1159552800)), .Names = c("Hovd", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -47L), class = "data.frame")
}

"Irkutsk" <- function () {
structure(list(Irkutsk = c("1901-12-14 20:45:52", "1920-01-24 17:02:40", 
"1930-06-20 17:00:00", "1981-03-31 16:00:00", "1981-09-30 15:00:00", 
"1982-03-31 16:00:00", "1982-09-30 15:00:00", "1983-03-31 16:00:00", 
"1983-09-30 15:00:00", "1984-03-31 16:00:00", "1984-09-29 18:00:00", 
"1985-03-30 18:00:00", "1985-09-28 18:00:00", "1986-03-29 18:00:00", 
"1986-09-27 18:00:00", "1987-03-28 18:00:00", "1987-09-26 18:00:00", 
"1988-03-26 18:00:00", "1988-09-24 18:00:00", "1989-03-25 18:00:00", 
"1989-09-23 18:00:00", "1990-03-24 18:00:00", "1991-03-30 18:00:00", 
"1991-09-28 19:00:00", "1992-01-18 19:00:00", "1992-03-28 15:00:00", 
"1992-09-26 14:00:00", "1993-03-27 18:00:00", "1993-09-25 18:00:00", 
"1994-03-26 18:00:00", "1994-09-24 18:00:00", "1995-03-25 18:00:00", 
"1995-09-23 18:00:00", "1996-03-30 18:00:00", "1996-10-26 18:00:00", 
"1997-03-29 18:00:00", "1997-10-25 18:00:00", "1998-03-28 18:00:00", 
"1998-10-24 18:00:00", "1999-03-27 18:00:00", "1999-10-30 18:00:00", 
"2000-03-25 18:00:00", "2000-10-28 18:00:00", "2001-03-24 18:00:00", 
"2001-10-27 18:00:00", "2002-03-30 18:00:00", "2002-10-26 18:00:00", 
"2003-03-29 18:00:00", "2003-10-25 18:00:00", "2004-03-27 18:00:00", 
"2004-10-30 18:00:00", "2005-03-26 18:00:00", "2005-10-29 18:00:00", 
"2006-03-25 18:00:00", "2006-10-28 18:00:00", "2007-03-24 18:00:00", 
"2007-10-27 18:00:00", "2008-03-29 18:00:00", "2008-10-25 18:00:00", 
"2009-03-28 18:00:00", "2009-10-24 18:00:00", "2010-03-27 18:00:00", 
"2010-10-30 18:00:00", "2011-03-26 18:00:00", "2011-10-29 18:00:00", 
"2012-03-24 18:00:00", "2012-10-27 18:00:00", "2013-03-30 18:00:00", 
"2013-10-26 18:00:00", "2014-03-29 18:00:00", "2014-10-25 18:00:00", 
"2015-03-28 18:00:00", "2015-10-24 18:00:00", "2016-03-26 18:00:00", 
"2016-10-29 18:00:00", "2017-03-25 18:00:00", "2017-10-28 18:00:00", 
"2018-03-24 18:00:00", "2018-10-27 18:00:00", "2019-03-30 18:00:00", 
"2019-10-26 18:00:00", "2020-03-28 18:00:00", "2020-10-24 18:00:00", 
"2021-03-27 18:00:00", "2021-10-30 18:00:00", "2022-03-26 18:00:00", 
"2022-10-29 18:00:00", "2023-03-25 18:00:00", "2023-10-28 18:00:00", 
"2024-03-30 18:00:00", "2024-10-26 18:00:00", "2025-03-29 18:00:00", 
"2025-10-25 18:00:00", "2026-03-28 18:00:00", "2026-10-24 18:00:00", 
"2027-03-27 18:00:00", "2027-10-30 18:00:00", "2028-03-25 18:00:00", 
"2028-10-28 18:00:00", "2029-03-24 18:00:00", "2029-10-27 18:00:00", 
"2030-03-30 18:00:00", "2030-10-26 18:00:00", "2031-03-29 18:00:00", 
"2031-10-25 18:00:00", "2032-03-27 18:00:00", "2032-10-30 18:00:00", 
"2033-03-26 18:00:00", "2033-10-29 18:00:00", "2034-03-25 18:00:00", 
"2034-10-28 18:00:00", "2035-03-24 18:00:00", "2035-10-27 18:00:00", 
"2036-03-29 18:00:00", "2036-10-25 18:00:00", "2037-03-28 18:00:00", 
"2037-10-24 18:00:00"), offSet = c(25040L, 25200L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 25200L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("IMT", 
"IRKT", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKST", "IRKT", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", "IRKST", "IRKT", 
"IRKST", "IRKT", "IRKST", "IRKT"), numeric = c(-2147397248, -1575874640, 
-1247554800, 354902400, 370710000, 386438400, 402246000, 417974400, 
433782000, 449596800, 465328800, 481053600, 496778400, 512503200, 
528228000, 543952800, 559677600, 575402400, 591127200, 606852000, 
622576800, 638301600, 670356000, 686084400, 695761200, 701794800, 
717516000, 733255200, 748980000, 764704800, 780429600, 796154400, 
811879200, 828208800, 846352800, 859658400, 877802400, 891108000, 
909252000, 922557600, 941306400, 954007200, 972756000, 985456800, 
1004205600, 1017511200, 1035655200, 1048960800, 1067104800, 1080410400, 
1099159200, 1111860000, 1130608800, 1143309600, 1162058400, 1174759200, 
1193508000, 1206813600, 1224957600, 1238263200, 1256407200, 1269712800, 
1288461600, 1301162400, 1319911200, 1332612000, 1351360800, 1364666400, 
1382810400, 1396116000, 1414260000, 1427565600, 1445709600, 1459015200, 
1477764000, 1490464800, 1509213600, 1521914400, 1540663200, 1553968800, 
1572112800, 1585418400, 1603562400, 1616868000, 1635616800, 1648317600, 
1667066400, 1679767200, 1698516000, 1711821600, 1729965600, 1743271200, 
1761415200, 1774720800, 1792864800, 1806170400, 1824919200, 1837620000, 
1856368800, 1869069600, 1887818400, 1901124000, 1919268000, 1932573600, 
1950717600, 1964023200, 1982772000, 1995472800, 2014221600, 2026922400, 
2045671200, 2058372000, 2077120800, 2090426400, 2108570400, 2121876000, 
2140020000)), .Names = c("Irkutsk", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -117L), class = "data.frame")
}

"Jakarta" <- function () {
structure(list(Jakarta = c("1901-12-14 20:45:52", "1923-12-31 16:40:00", 
"1932-10-31 16:40:00", "1942-03-22 16:30:00", "1945-09-22 15:00:00", 
"1948-04-30 16:30:00", "1950-04-30 16:00:00", "1963-12-31 16:30:00"
), offSet = c(25632L, 26400L, 27000L, 32400L, 27000L, 28800L, 
27000L, 25200L), isdst = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), TimeZone = c("JMT", 
"JAVT", "WIT", "JST", "WIT", "WIT", "WIT", "WIT"), numeric = c(-2147397248, 
-1451719200, -1172906400, -876641400, -766054800, -683883000, 
-620812800, -189415800)), .Names = c("Jakarta", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -8L), class = "data.frame")
}

"Jayapura" <- function () {
structure(list(Jayapura = c("1901-12-14 20:45:52", "1932-10-31 14:37:12", 
"1944-08-31 15:00:00", "1963-12-31 14:30:00"), offSet = c(33768L, 
32400L, 34200L, 32400L), isdst = c(0L, 0L, 0L, 0L), TimeZone = c("LMT", 
"EIT", "CST", "EIT"), numeric = c(-2147397248, -1172913768, -799491600, 
-189423000)), .Names = c("Jayapura", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"Jerusalem" <- function () {
structure(list(Jerusalem = c("1901-12-14 20:45:52", "1917-12-31 21:39:20", 
"1940-05-31 22:00:00", "1942-10-31 21:00:00", "1943-04-01 00:00:00", 
"1943-10-31 21:00:00", "1944-03-31 22:00:00", "1944-10-31 21:00:00", 
"1945-04-15 22:00:00", "1945-10-31 23:00:00", "1946-04-16 00:00:00", 
"1946-10-31 21:00:00", "1948-05-22 22:00:00", "1948-08-31 20:00:00", 
"1948-10-31 23:00:00", "1949-04-30 22:00:00", "1949-10-31 23:00:00", 
"1950-04-15 22:00:00", "1950-09-15 00:00:00", "1951-03-31 22:00:00", 
"1951-11-11 00:00:00", "1952-04-20 00:00:00", "1952-10-19 00:00:00", 
"1953-04-12 00:00:00", "1953-09-13 00:00:00", "1954-06-12 22:00:00", 
"1954-09-11 21:00:00", "1955-06-11 00:00:00", "1955-09-10 21:00:00", 
"1956-06-02 22:00:00", "1956-09-30 00:00:00", "1957-04-29 00:00:00", 
"1957-09-21 21:00:00", "1974-07-06 22:00:00", "1974-10-12 21:00:00", 
"1975-04-19 22:00:00", "1975-08-30 21:00:00", "1985-04-13 22:00:00", 
"1985-09-14 21:00:00", "1986-05-17 22:00:00", "1986-09-06 21:00:00", 
"1987-04-14 22:00:00", "1987-09-12 21:00:00", "1988-04-08 22:00:00", 
"1988-09-02 21:00:00", "1989-04-29 22:00:00", "1989-09-02 21:00:00", 
"1990-03-24 22:00:00", "1990-08-25 21:00:00", "1991-03-23 22:00:00", 
"1991-08-31 21:00:00", "1992-03-28 22:00:00", "1992-09-05 21:00:00", 
"1993-04-01 22:00:00", "1993-09-04 21:00:00", "1994-03-31 22:00:00", 
"1994-08-27 21:00:00", "1995-03-30 22:00:00", "1995-09-02 21:00:00", 
"1996-03-14 22:00:00", "1996-09-15 21:00:00", "1997-03-20 22:00:00", 
"1997-09-13 21:00:00", "1998-03-19 22:00:00", "1998-09-05 21:00:00", 
"1999-04-02 00:00:00", "1999-09-02 23:00:00", "2000-04-14 00:00:00", 
"2000-10-05 22:00:00", "2001-04-08 23:00:00", "2001-09-23 22:00:00", 
"2002-03-28 23:00:00", "2002-10-06 22:00:00", "2003-03-27 23:00:00", 
"2003-10-02 22:00:00", "2004-04-06 23:00:00", "2004-09-21 22:00:00", 
"2005-04-01 00:00:00", "2005-10-08 23:00:00", "2006-03-31 00:00:00", 
"2006-09-30 23:00:00", "2007-03-30 00:00:00", "2007-09-15 23:00:00", 
"2008-03-28 00:00:00", "2008-10-04 23:00:00", "2009-03-27 00:00:00", 
"2009-09-26 23:00:00", "2010-03-26 00:00:00", "2010-09-11 23:00:00", 
"2011-04-01 00:00:00", "2011-10-01 23:00:00", "2012-03-30 00:00:00", 
"2012-09-22 23:00:00", "2013-03-29 00:00:00", "2013-09-07 23:00:00", 
"2014-03-28 00:00:00", "2014-09-27 23:00:00", "2015-03-27 00:00:00", 
"2015-09-19 23:00:00", "2016-04-01 00:00:00", "2016-10-08 23:00:00", 
"2017-03-31 00:00:00", "2017-09-23 23:00:00", "2018-03-30 00:00:00", 
"2018-09-15 23:00:00", "2019-03-29 00:00:00", "2019-10-05 23:00:00", 
"2020-03-27 00:00:00", "2020-09-26 23:00:00", "2021-03-26 00:00:00", 
"2021-09-11 23:00:00", "2022-04-01 00:00:00", "2022-10-01 23:00:00", 
"2023-03-31 00:00:00", "2023-09-23 23:00:00", "2024-03-29 00:00:00", 
"2024-10-05 23:00:00", "2025-03-28 00:00:00", "2025-09-27 23:00:00", 
"2026-03-27 00:00:00", "2026-09-19 23:00:00", "2027-03-26 00:00:00", 
"2027-10-09 23:00:00", "2028-03-31 00:00:00", "2028-09-23 23:00:00", 
"2029-03-30 00:00:00", "2029-09-15 23:00:00", "2030-03-29 00:00:00", 
"2030-10-05 23:00:00", "2031-03-28 00:00:00", "2031-09-20 23:00:00", 
"2032-03-26 00:00:00", "2032-09-11 23:00:00", "2033-04-01 00:00:00", 
"2033-10-01 23:00:00", "2034-03-31 00:00:00", "2034-09-16 23:00:00", 
"2035-03-30 00:00:00", "2035-10-06 23:00:00", "2036-03-28 00:00:00", 
"2036-09-27 23:00:00", "2037-03-27 00:00:00", "2037-09-12 23:00:00"
), offSet = c(8440L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 14400L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
0L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L), TimeZone = c("JMT", "IST", "IDT", "IST", "IDT", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDDT", "IDT", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", 
"IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", 
"IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", 
"IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", 
"IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", 
"IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", 
"IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", 
"IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", 
"IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", "IST", "IDT", 
"IST", "IDT", "UTC"), numeric = c(-2147397248, -1641003640, -933645600, 
-857358000, -844300800, -825822000, -812685600, -794199600, -779853600, 
-762656400, -748310400, -731127600, -681962400, -673243200, -667962000, 
-652327200, -636426000, -622087200, -608947200, -591847200, -572486400, 
-558576000, -542851200, -527731200, -514425600, -490845600, -482986800, 
-459475200, -451537200, -428551200, -418262400, -400032000, -387428400, 
142380000, 150843600, 167176800, 178664400, 482277600, 495579600, 
516751200, 526424400, 545436000, 558478800, 576540000, 589237200, 
609890400, 620773200, 638316000, 651618000, 669765600, 683672400, 
701820000, 715726800, 733701600, 747176400, 765151200, 778021200, 
796600800, 810075600, 826840800, 842821200, 858895200, 874184400, 
890344800, 905029200, 923011200, 936313200, 955670400, 970783200, 
986770800, 1001282400, 1017356400, 1033941600, 1048806000, 1065132000, 
1081292400, 1095804000, 1112313600, 1128812400, 1143763200, 1159657200, 
1175212800, 1189897200, 1206662400, 1223161200, 1238112000, 1254006000, 
1269561600, 1284246000, 1301616000, 1317510000, 1333065600, 1348354800, 
1364515200, 1378594800, 1395964800, 1411858800, 1427414400, 1442703600, 
1459468800, 1475967600, 1490918400, 1506207600, 1522368000, 1537052400, 
1553817600, 1570316400, 1585267200, 1601161200, 1616716800, 1631401200, 
1648771200, 1664665200, 1680220800, 1695510000, 1711670400, 1728169200, 
1743120000, 1759014000, 1774569600, 1789858800, 1806019200, 1823122800, 
1838073600, 1853362800, 1869523200, 1884207600, 1900972800, 1917471600, 
1932422400, 1947711600, 1963872000, 1978556400, 1995926400, 2011820400, 
2027376000, 2042060400, 2058825600, 2075324400, 2090275200, 2106169200, 
2121724800, 2136409200)), .Names = c("Jerusalem", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -143L), class = "data.frame")
}

"Kabul" <- function () {
structure(list(Kabul = c("1901-12-14 20:45:52", "1944-12-31 20:00:00"
), offSet = c(14400L, 16200L), isdst = c(0L, 0L), TimeZone = c("AFT", 
"AFT"), numeric = c(-2147397248, -788932800)), .Names = c("Kabul", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Kamchatka" <- function () {
structure(list(Kamchatka = c("1901-12-14 20:45:52", "1922-11-09 13:25:24", 
"1930-06-20 13:00:00", "1981-03-31 12:00:00", "1981-09-30 11:00:00", 
"1982-03-31 12:00:00", "1982-09-30 11:00:00", "1983-03-31 12:00:00", 
"1983-09-30 11:00:00", "1984-03-31 12:00:00", "1984-09-29 14:00:00", 
"1985-03-30 14:00:00", "1985-09-28 14:00:00", "1986-03-29 14:00:00", 
"1986-09-27 14:00:00", "1987-03-28 14:00:00", "1987-09-26 14:00:00", 
"1988-03-26 14:00:00", "1988-09-24 14:00:00", "1989-03-25 14:00:00", 
"1989-09-23 14:00:00", "1990-03-24 14:00:00", "1991-03-30 14:00:00", 
"1991-09-28 15:00:00", "1992-01-18 15:00:00", "1992-03-28 11:00:00", 
"1992-09-26 10:00:00", "1993-03-27 14:00:00", "1993-09-25 14:00:00", 
"1994-03-26 14:00:00", "1994-09-24 14:00:00", "1995-03-25 14:00:00", 
"1995-09-23 14:00:00", "1996-03-30 14:00:00", "1996-10-26 14:00:00", 
"1997-03-29 14:00:00", "1997-10-25 14:00:00", "1998-03-28 14:00:00", 
"1998-10-24 14:00:00", "1999-03-27 14:00:00", "1999-10-30 14:00:00", 
"2000-03-25 14:00:00", "2000-10-28 14:00:00", "2001-03-24 14:00:00", 
"2001-10-27 14:00:00", "2002-03-30 14:00:00", "2002-10-26 14:00:00", 
"2003-03-29 14:00:00", "2003-10-25 14:00:00", "2004-03-27 14:00:00", 
"2004-10-30 14:00:00", "2005-03-26 14:00:00", "2005-10-29 14:00:00", 
"2006-03-25 14:00:00", "2006-10-28 14:00:00", "2007-03-24 14:00:00", 
"2007-10-27 14:00:00", "2008-03-29 14:00:00", "2008-10-25 14:00:00", 
"2009-03-28 14:00:00", "2009-10-24 14:00:00", "2010-03-27 14:00:00", 
"2010-10-30 14:00:00", "2011-03-26 14:00:00", "2011-10-29 14:00:00", 
"2012-03-24 14:00:00", "2012-10-27 14:00:00", "2013-03-30 14:00:00", 
"2013-10-26 14:00:00", "2014-03-29 14:00:00", "2014-10-25 14:00:00", 
"2015-03-28 14:00:00", "2015-10-24 14:00:00", "2016-03-26 14:00:00", 
"2016-10-29 14:00:00", "2017-03-25 14:00:00", "2017-10-28 14:00:00", 
"2018-03-24 14:00:00", "2018-10-27 14:00:00", "2019-03-30 14:00:00", 
"2019-10-26 14:00:00", "2020-03-28 14:00:00", "2020-10-24 14:00:00", 
"2021-03-27 14:00:00", "2021-10-30 14:00:00", "2022-03-26 14:00:00", 
"2022-10-29 14:00:00", "2023-03-25 14:00:00", "2023-10-28 14:00:00", 
"2024-03-30 14:00:00", "2024-10-26 14:00:00", "2025-03-29 14:00:00", 
"2025-10-25 14:00:00", "2026-03-28 14:00:00", "2026-10-24 14:00:00", 
"2027-03-27 14:00:00", "2027-10-30 14:00:00", "2028-03-25 14:00:00", 
"2028-10-28 14:00:00", "2029-03-24 14:00:00", "2029-10-27 14:00:00", 
"2030-03-30 14:00:00", "2030-10-26 14:00:00", "2031-03-29 14:00:00", 
"2031-10-25 14:00:00", "2032-03-27 14:00:00", "2032-10-30 14:00:00", 
"2033-03-26 14:00:00", "2033-10-29 14:00:00", "2034-03-25 14:00:00", 
"2034-10-28 14:00:00", "2035-03-24 14:00:00", "2035-10-27 14:00:00", 
"2036-03-29 14:00:00", "2036-10-25 14:00:00", "2037-03-28 14:00:00", 
"2037-10-24 14:00:00"), offSet = c(38076L, 39600L, 43200L, 46800L, 
43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 
43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 
43200L, 46800L, 43200L, 39600L, 43200L, 46800L, 43200L, 46800L, 
43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 
43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 
43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 
43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 
43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 
43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 
43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 
43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 
43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 
43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 
43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 43200L, 46800L, 
43200L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"PETT", "PETT", "PETST", "PETT", "PETST", "PETT", "PETST", "PETT", 
"PETST", "PETT", "PETST", "PETT", "PETST", "PETT", "PETST", "PETT", 
"PETST", "PETT", "PETST", "PETT", "PETST", "PETST", "PETT", "PETT", 
"PETST", "PETT", "PETST", "PETT", "PETST", "PETT", "PETST", "PETT", 
"PETST", "PETT", "PETST", "PETT", "PETST", "PETT", "PETST", "PETT", 
"PETST", "PETT", "PETST", "PETT", "PETST", "PETT", "PETST", "PETT", 
"PETST", "PETT", "PETST", "PETT", "PETST", "PETT", "PETST", "PETT", 
"PETST", "PETT", "PETST", "PETT", "PETST", "PETT", "PETST", "PETT", 
"PETST", "PETT", "PETST", "PETT", "PETST", "PETT", "PETST", "PETT", 
"PETST", "PETT", "PETST", "PETT", "PETST", "PETT", "PETST", "PETT", 
"PETST", "PETT", "PETST", "PETT", "PETST", "PETT", "PETST", "PETT", 
"PETST", "PETT", "PETST", "PETT", "PETST", "PETT", "PETST", "PETT", 
"PETST", "PETT", "PETST", "PETT", "PETST", "PETT", "PETST", "PETT", 
"PETST", "PETT", "PETST", "PETT", "PETST", "PETT", "PETST", "PETT", 
"PETST", "PETT", "PETST", "PETT"), numeric = c(-2147397248, -1487759676, 
-1247569200, 354888000, 370695600, 386424000, 402231600, 417960000, 
433767600, 449582400, 465314400, 481039200, 496764000, 512488800, 
528213600, 543938400, 559663200, 575388000, 591112800, 606837600, 
622562400, 638287200, 670341600, 686070000, 695746800, 701780400, 
717501600, 733240800, 748965600, 764690400, 780415200, 796140000, 
811864800, 828194400, 846338400, 859644000, 877788000, 891093600, 
909237600, 922543200, 941292000, 953992800, 972741600, 985442400, 
1004191200, 1017496800, 1035640800, 1048946400, 1067090400, 1080396000, 
1099144800, 1111845600, 1130594400, 1143295200, 1162044000, 1174744800, 
1193493600, 1206799200, 1224943200, 1238248800, 1256392800, 1269698400, 
1288447200, 1301148000, 1319896800, 1332597600, 1351346400, 1364652000, 
1382796000, 1396101600, 1414245600, 1427551200, 1445695200, 1459000800, 
1477749600, 1490450400, 1509199200, 1521900000, 1540648800, 1553954400, 
1572098400, 1585404000, 1603548000, 1616853600, 1635602400, 1648303200, 
1667052000, 1679752800, 1698501600, 1711807200, 1729951200, 1743256800, 
1761400800, 1774706400, 1792850400, 1806156000, 1824904800, 1837605600, 
1856354400, 1869055200, 1887804000, 1901109600, 1919253600, 1932559200, 
1950703200, 1964008800, 1982757600, 1995458400, 2014207200, 2026908000, 
2045656800, 2058357600, 2077106400, 2090412000, 2108556000, 2121861600, 
2140005600)), .Names = c("Kamchatka", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -117L), class = "data.frame")
}

"Karachi" <- function () {
structure(list(Karachi = c("1901-12-14 20:45:52", "1906-12-31 19:31:48", 
"1942-08-31 18:30:00", "1945-10-14 17:30:00", "1971-03-25 19:00:00", 
"2002-04-06 19:01:00", "2002-10-05 18:01:00", "2008-05-31 19:00:00", 
"2008-10-31 18:00:00"), offSet = c(16092L, 19800L, 23400L, 19800L, 
18000L, 21600L, 18000L, 21600L, 18000L), isdst = c(0L, 0L, 1L, 
0L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "IST", "IST", "IST", 
"PKT", "PKST", "PKT", "PKST", "PKT"), numeric = c(-2147397248, 
-1988166492, -862637400, -764145000, 38775600, 1018119660, 1033840860, 
1212260400, 1225476000)), .Names = c("Karachi", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -9L), class = "data.frame")
}

"Kashgar" <- function () {
structure(list(Kashgar = c("1901-12-14 20:45:52", "1927-12-31 18:56:04", 
"1939-12-31 18:30:00", "1980-04-30 19:00:00", "1986-05-03 16:00:00", 
"1986-09-13 15:00:00", "1987-04-11 16:00:00", "1987-09-12 15:00:00", 
"1988-04-09 16:00:00", "1988-09-10 15:00:00", "1989-04-15 16:00:00", 
"1989-09-16 15:00:00", "1990-04-14 16:00:00", "1990-09-15 15:00:00", 
"1991-04-13 16:00:00", "1991-09-14 15:00:00"), offSet = c(18236L, 
19800L, 18000L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L), isdst = c(0L, 
0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), 
    TimeZone = c("LMT", "KAST", "KAST", "CST", "CDT", "CST", 
    "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
    "CST"), numeric = c(-2147397248, -1325480636, -946791000, 
    325969200, 515520000, 527007600, 545155200, 558457200, 576604800, 
    589906800, 608659200, 621961200, 640108800, 653410800, 671558400, 
    684860400)), .Names = c("Kashgar", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -16L), class = "data.frame")
}

"Katmandu" <- function () {
structure(list(Katmandu = c("1901-12-14 20:45:52", "1919-12-31 18:18:44", 
"1985-12-31 18:30:00"), offSet = c(20476L, 19800L, 20700L), isdst = c(0L, 
0L, 0L), TimeZone = c("LMT", "IST", "NPT"), numeric = c(-2147397248, 
-1577943676, 504901800)), .Names = c("Katmandu", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -3L), class = "data.frame")
}

"Krasnoyarsk" <- function () {
structure(list(Krasnoyarsk = c("1901-12-14 20:45:52", "1920-01-05 17:48:40", 
"1930-06-20 18:00:00", "1981-03-31 17:00:00", "1981-09-30 16:00:00", 
"1982-03-31 17:00:00", "1982-09-30 16:00:00", "1983-03-31 17:00:00", 
"1983-09-30 16:00:00", "1984-03-31 17:00:00", "1984-09-29 19:00:00", 
"1985-03-30 19:00:00", "1985-09-28 19:00:00", "1986-03-29 19:00:00", 
"1986-09-27 19:00:00", "1987-03-28 19:00:00", "1987-09-26 19:00:00", 
"1988-03-26 19:00:00", "1988-09-24 19:00:00", "1989-03-25 19:00:00", 
"1989-09-23 19:00:00", "1990-03-24 19:00:00", "1991-03-30 19:00:00", 
"1991-09-28 20:00:00", "1992-01-18 20:00:00", "1992-03-28 16:00:00", 
"1992-09-26 15:00:00", "1993-03-27 19:00:00", "1993-09-25 19:00:00", 
"1994-03-26 19:00:00", "1994-09-24 19:00:00", "1995-03-25 19:00:00", 
"1995-09-23 19:00:00", "1996-03-30 19:00:00", "1996-10-26 19:00:00", 
"1997-03-29 19:00:00", "1997-10-25 19:00:00", "1998-03-28 19:00:00", 
"1998-10-24 19:00:00", "1999-03-27 19:00:00", "1999-10-30 19:00:00", 
"2000-03-25 19:00:00", "2000-10-28 19:00:00", "2001-03-24 19:00:00", 
"2001-10-27 19:00:00", "2002-03-30 19:00:00", "2002-10-26 19:00:00", 
"2003-03-29 19:00:00", "2003-10-25 19:00:00", "2004-03-27 19:00:00", 
"2004-10-30 19:00:00", "2005-03-26 19:00:00", "2005-10-29 19:00:00", 
"2006-03-25 19:00:00", "2006-10-28 19:00:00", "2007-03-24 19:00:00", 
"2007-10-27 19:00:00", "2008-03-29 19:00:00", "2008-10-25 19:00:00", 
"2009-03-28 19:00:00", "2009-10-24 19:00:00", "2010-03-27 19:00:00", 
"2010-10-30 19:00:00", "2011-03-26 19:00:00", "2011-10-29 19:00:00", 
"2012-03-24 19:00:00", "2012-10-27 19:00:00", "2013-03-30 19:00:00", 
"2013-10-26 19:00:00", "2014-03-29 19:00:00", "2014-10-25 19:00:00", 
"2015-03-28 19:00:00", "2015-10-24 19:00:00", "2016-03-26 19:00:00", 
"2016-10-29 19:00:00", "2017-03-25 19:00:00", "2017-10-28 19:00:00", 
"2018-03-24 19:00:00", "2018-10-27 19:00:00", "2019-03-30 19:00:00", 
"2019-10-26 19:00:00", "2020-03-28 19:00:00", "2020-10-24 19:00:00", 
"2021-03-27 19:00:00", "2021-10-30 19:00:00", "2022-03-26 19:00:00", 
"2022-10-29 19:00:00", "2023-03-25 19:00:00", "2023-10-28 19:00:00", 
"2024-03-30 19:00:00", "2024-10-26 19:00:00", "2025-03-29 19:00:00", 
"2025-10-25 19:00:00", "2026-03-28 19:00:00", "2026-10-24 19:00:00", 
"2027-03-27 19:00:00", "2027-10-30 19:00:00", "2028-03-25 19:00:00", 
"2028-10-28 19:00:00", "2029-03-24 19:00:00", "2029-10-27 19:00:00", 
"2030-03-30 19:00:00", "2030-10-26 19:00:00", "2031-03-29 19:00:00", 
"2031-10-25 19:00:00", "2032-03-27 19:00:00", "2032-10-30 19:00:00", 
"2033-03-26 19:00:00", "2033-10-29 19:00:00", "2034-03-25 19:00:00", 
"2034-10-28 19:00:00", "2035-03-24 19:00:00", "2035-10-27 19:00:00", 
"2036-03-29 19:00:00", "2036-10-25 19:00:00", "2037-03-28 19:00:00", 
"2037-10-24 19:00:00"), offSet = c(22280L, 21600L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 21600L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 
25200L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"KRAT", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAST", "KRAT", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", "KRAST", "KRAT", 
"KRAST", "KRAT", "KRAST", "KRAT"), numeric = c(-2147397248, -1577513480, 
-1247551200, 354906000, 370713600, 386442000, 402249600, 417978000, 
433785600, 449600400, 465332400, 481057200, 496782000, 512506800, 
528231600, 543956400, 559681200, 575406000, 591130800, 606855600, 
622580400, 638305200, 670359600, 686088000, 695764800, 701798400, 
717519600, 733258800, 748983600, 764708400, 780433200, 796158000, 
811882800, 828212400, 846356400, 859662000, 877806000, 891111600, 
909255600, 922561200, 941310000, 954010800, 972759600, 985460400, 
1004209200, 1017514800, 1035658800, 1048964400, 1067108400, 1080414000, 
1099162800, 1111863600, 1130612400, 1143313200, 1162062000, 1174762800, 
1193511600, 1206817200, 1224961200, 1238266800, 1256410800, 1269716400, 
1288465200, 1301166000, 1319914800, 1332615600, 1351364400, 1364670000, 
1382814000, 1396119600, 1414263600, 1427569200, 1445713200, 1459018800, 
1477767600, 1490468400, 1509217200, 1521918000, 1540666800, 1553972400, 
1572116400, 1585422000, 1603566000, 1616871600, 1635620400, 1648321200, 
1667070000, 1679770800, 1698519600, 1711825200, 1729969200, 1743274800, 
1761418800, 1774724400, 1792868400, 1806174000, 1824922800, 1837623600, 
1856372400, 1869073200, 1887822000, 1901127600, 1919271600, 1932577200, 
1950721200, 1964026800, 1982775600, 1995476400, 2014225200, 2026926000, 
2045674800, 2058375600, 2077124400, 2090430000, 2108574000, 2121879600, 
2140023600)), .Names = c("Krasnoyarsk", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -117L), class = "data.frame")
}

"Kuala_Lumpur" <- function () {
structure(list(Kuala_Lumpur = c("1901-12-14 20:45:52", "1905-05-31 17:04:35", 
"1935-12-31 16:40:00", "1941-08-31 16:40:00", "1942-02-15 16:30:00", 
"1945-09-11 15:00:00", "1981-12-31 16:30:00"), offSet = c(24925L, 
25200L, 26400L, 27000L, 32400L, 27000L, 28800L), isdst = c(0L, 
0L, 0L, 0L, 0L, 0L, 0L), TimeZone = c("SMT", "MALT", "MALT", 
"MALT", "JST", "MALT", "MYT"), numeric = c(-2147397248, -2038200925, 
-1073028000, -894180000, -879665400, -767005200, 378664200)), .Names = c("Kuala_Lumpur", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-7L), class = "data.frame")
}

"Kuching" <- function () {
structure(list(Kuching = c("1901-12-14 20:45:52", "1926-02-28 16:38:40", 
"1932-12-31 16:30:00", "1935-09-13 16:00:00", "1935-12-13 15:40:00", 
"1936-09-13 16:00:00", "1936-12-13 15:40:00", "1937-09-13 16:00:00", 
"1937-12-13 15:40:00", "1938-09-13 16:00:00", "1938-12-13 15:40:00", 
"1939-09-13 16:00:00", "1939-12-13 15:40:00", "1940-09-13 16:00:00", 
"1940-12-13 15:40:00", "1941-09-13 16:00:00", "1941-12-13 15:40:00", 
"1942-02-15 16:00:00", "1945-09-11 15:00:00"), offSet = c(26480L, 
27000L, 28800L, 30000L, 28800L, 30000L, 28800L, 30000L, 28800L, 
30000L, 28800L, 30000L, 28800L, 30000L, 28800L, 30000L, 28800L, 
32400L, 28800L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 0L), TimeZone = c("LMT", 
"BORT", "BORT", "BORTST", "BORT", "BORTST", "BORT", "BORTST", 
"BORT", "BORTST", "BORT", "BORTST", "BORT", "BORTST", "BORT", 
"BORTST", "BORT", "JST", "BORT"), numeric = c(-2147397248, -1383463280, 
-1167636600, -1082448000, -1074586800, -1050825600, -1042964400, 
-1019289600, -1011428400, -987753600, -979892400, -956217600, 
-948356400, -924595200, -916734000, -893059200, -885198000, -879667200, 
-767005200)), .Names = c("Kuching", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -19L), class = "data.frame")
}

"Kuwait" <- function () {
structure(list(Kuwait = c("1901-12-14 20:45:52", "1949-12-31 20:48:04"
), offSet = c(11516L, 10800L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"AST"), numeric = c(-2147397248, -631163516)), .Names = c("Kuwait", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Macau" <- function () {
structure(list(Macau = c("1901-12-14 20:45:52", "1911-12-31 16:25:40", 
"1961-03-18 19:30:00", "1961-11-04 18:30:00", "1962-03-17 19:30:00", 
"1962-11-03 18:30:00", "1963-03-16 16:00:00", "1963-11-02 18:30:00", 
"1964-03-21 19:30:00", "1964-10-31 18:30:00", "1965-03-20 16:00:00", 
"1965-10-30 15:00:00", "1966-04-16 19:30:00", "1966-10-15 18:30:00", 
"1967-04-15 19:30:00", "1967-10-21 18:30:00", "1968-04-20 19:30:00", 
"1968-10-19 18:30:00", "1969-04-19 19:30:00", "1969-10-18 18:30:00", 
"1970-04-18 19:30:00", "1970-10-17 18:30:00", "1971-04-17 19:30:00", 
"1971-10-16 18:30:00", "1972-04-15 16:00:00", "1972-10-14 15:00:00", 
"1973-04-14 16:00:00", "1973-10-20 15:00:00", "1974-04-20 16:00:00", 
"1974-10-19 18:30:00", "1975-04-19 19:30:00", "1975-10-18 18:30:00", 
"1976-04-17 19:30:00", "1976-10-16 18:30:00", "1977-04-16 19:30:00", 
"1977-10-15 18:30:00", "1978-04-15 16:00:00", "1978-10-14 15:00:00", 
"1979-04-14 16:00:00", "1979-10-20 15:00:00", "1980-04-19 16:00:00", 
"1980-10-18 15:00:00"), offSet = c(27260L, 28800L, 32400L, 28800L, 
32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 
32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 
32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 
32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 
32400L, 28800L, 32400L, 28800L, 32400L, 28800L), isdst = c(0L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "MOT", 
"MOST", "MOT", "MOST", "MOT", "MOST", "MOT", "MOST", "MOT", "MOST", 
"MOT", "MOST", "MOT", "MOST", "MOT", "MOST", "MOT", "MOST", "MOT", 
"MOST", "MOT", "MOST", "MOT", "MOST", "MOT", "MOST", "MOT", "MOST", 
"MOT", "MOST", "MOT", "MOST", "MOT", "MOST", "MOT", "MOST", "MOT", 
"MOST", "MOT", "MOST", "MOT"), numeric = c(-2147397248, -1830411260, 
-277360200, -257405400, -245910600, -225955800, -214473600, -194506200, 
-182406600, -163056600, -150969600, -131619600, -117088200, -101367000, 
-85638600, -69312600, -53584200, -37863000, -22134600, -6413400, 
9315000, 25036200, 40764600, 56485800, 72201600, 87922800, 103651200, 
119977200, 135705600, 151439400, 167167800, 182889000, 198617400, 
214338600, 230067000, 245788200, 261504000, 277225200, 292953600, 
309279600, 325008000, 340729200)), .Names = c("Macau", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -42L), class = "data.frame")
}

"Magadan" <- function () {
structure(list(Magadan = c("1901-12-14 20:45:52", "1924-05-01 13:56:48", 
"1930-06-20 14:00:00", "1981-03-31 13:00:00", "1981-09-30 12:00:00", 
"1982-03-31 13:00:00", "1982-09-30 12:00:00", "1983-03-31 13:00:00", 
"1983-09-30 12:00:00", "1984-03-31 13:00:00", "1984-09-29 15:00:00", 
"1985-03-30 15:00:00", "1985-09-28 15:00:00", "1986-03-29 15:00:00", 
"1986-09-27 15:00:00", "1987-03-28 15:00:00", "1987-09-26 15:00:00", 
"1988-03-26 15:00:00", "1988-09-24 15:00:00", "1989-03-25 15:00:00", 
"1989-09-23 15:00:00", "1990-03-24 15:00:00", "1991-03-30 15:00:00", 
"1991-09-28 16:00:00", "1992-01-18 16:00:00", "1992-03-28 12:00:00", 
"1992-09-26 11:00:00", "1993-03-27 15:00:00", "1993-09-25 15:00:00", 
"1994-03-26 15:00:00", "1994-09-24 15:00:00", "1995-03-25 15:00:00", 
"1995-09-23 15:00:00", "1996-03-30 15:00:00", "1996-10-26 15:00:00", 
"1997-03-29 15:00:00", "1997-10-25 15:00:00", "1998-03-28 15:00:00", 
"1998-10-24 15:00:00", "1999-03-27 15:00:00", "1999-10-30 15:00:00", 
"2000-03-25 15:00:00", "2000-10-28 15:00:00", "2001-03-24 15:00:00", 
"2001-10-27 15:00:00", "2002-03-30 15:00:00", "2002-10-26 15:00:00", 
"2003-03-29 15:00:00", "2003-10-25 15:00:00", "2004-03-27 15:00:00", 
"2004-10-30 15:00:00", "2005-03-26 15:00:00", "2005-10-29 15:00:00", 
"2006-03-25 15:00:00", "2006-10-28 15:00:00", "2007-03-24 15:00:00", 
"2007-10-27 15:00:00", "2008-03-29 15:00:00", "2008-10-25 15:00:00", 
"2009-03-28 15:00:00", "2009-10-24 15:00:00", "2010-03-27 15:00:00", 
"2010-10-30 15:00:00", "2011-03-26 15:00:00", "2011-10-29 15:00:00", 
"2012-03-24 15:00:00", "2012-10-27 15:00:00", "2013-03-30 15:00:00", 
"2013-10-26 15:00:00", "2014-03-29 15:00:00", "2014-10-25 15:00:00", 
"2015-03-28 15:00:00", "2015-10-24 15:00:00", "2016-03-26 15:00:00", 
"2016-10-29 15:00:00", "2017-03-25 15:00:00", "2017-10-28 15:00:00", 
"2018-03-24 15:00:00", "2018-10-27 15:00:00", "2019-03-30 15:00:00", 
"2019-10-26 15:00:00", "2020-03-28 15:00:00", "2020-10-24 15:00:00", 
"2021-03-27 15:00:00", "2021-10-30 15:00:00", "2022-03-26 15:00:00", 
"2022-10-29 15:00:00", "2023-03-25 15:00:00", "2023-10-28 15:00:00", 
"2024-03-30 15:00:00", "2024-10-26 15:00:00", "2025-03-29 15:00:00", 
"2025-10-25 15:00:00", "2026-03-28 15:00:00", "2026-10-24 15:00:00", 
"2027-03-27 15:00:00", "2027-10-30 15:00:00", "2028-03-25 15:00:00", 
"2028-10-28 15:00:00", "2029-03-24 15:00:00", "2029-10-27 15:00:00", 
"2030-03-30 15:00:00", "2030-10-26 15:00:00", "2031-03-29 15:00:00", 
"2031-10-25 15:00:00", "2032-03-27 15:00:00", "2032-10-30 15:00:00", 
"2033-03-26 15:00:00", "2033-10-29 15:00:00", "2034-03-25 15:00:00", 
"2034-10-28 15:00:00", "2035-03-24 15:00:00", "2035-10-27 15:00:00", 
"2036-03-29 15:00:00", "2036-10-25 15:00:00", "2037-03-28 15:00:00", 
"2037-10-24 15:00:00"), offSet = c(36192L, 36000L, 39600L, 43200L, 
39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 
39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 
39600L, 43200L, 39600L, 36000L, 39600L, 43200L, 39600L, 43200L, 
39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 
39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 
39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 
39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 
39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 
39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 
39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 
39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 
39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 
39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 
39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 
39600L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"MAGT", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGST", "MAGT", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", "MAGST", "MAGT", 
"MAGST", "MAGT", "MAGST", "MAGT"), numeric = c(-2147397248, -1441188192, 
-1247565600, 354891600, 370699200, 386427600, 402235200, 417963600, 
433771200, 449586000, 465318000, 481042800, 496767600, 512492400, 
528217200, 543942000, 559666800, 575391600, 591116400, 606841200, 
622566000, 638290800, 670345200, 686073600, 695750400, 701784000, 
717505200, 733244400, 748969200, 764694000, 780418800, 796143600, 
811868400, 828198000, 846342000, 859647600, 877791600, 891097200, 
909241200, 922546800, 941295600, 953996400, 972745200, 985446000, 
1004194800, 1017500400, 1035644400, 1048950000, 1067094000, 1080399600, 
1099148400, 1111849200, 1130598000, 1143298800, 1162047600, 1174748400, 
1193497200, 1206802800, 1224946800, 1238252400, 1256396400, 1269702000, 
1288450800, 1301151600, 1319900400, 1332601200, 1351350000, 1364655600, 
1382799600, 1396105200, 1414249200, 1427554800, 1445698800, 1459004400, 
1477753200, 1490454000, 1509202800, 1521903600, 1540652400, 1553958000, 
1572102000, 1585407600, 1603551600, 1616857200, 1635606000, 1648306800, 
1667055600, 1679756400, 1698505200, 1711810800, 1729954800, 1743260400, 
1761404400, 1774710000, 1792854000, 1806159600, 1824908400, 1837609200, 
1856358000, 1869058800, 1887807600, 1901113200, 1919257200, 1932562800, 
1950706800, 1964012400, 1982761200, 1995462000, 2014210800, 2026911600, 
2045660400, 2058361200, 2077110000, 2090415600, 2108559600, 2121865200, 
2140009200)), .Names = c("Magadan", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -117L), class = "data.frame")
}

"Makassar" <- function () {
structure(list(Makassar = c("1919-12-31 16:02:24", "1932-10-31 16:02:24", 
"1942-02-08 16:00:00", "1945-09-22 15:00:00"), offSet = c(28656L, 
28800L, 32400L, 28800L), isdst = c(0L, 0L, 0L, 0L), TimeZone = c("MMT", 
"CIT", "JST", "CIT"), numeric = c(-1577951856, -1172908656, -880272000, 
-766054800)), .Names = c("Makassar", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"Manila" <- function () {
structure(list(Manila = c("1901-12-14 20:45:52", "1936-10-31 16:00:00", 
"1937-01-31 15:00:00", "1942-04-30 16:00:00", "1944-10-31 15:00:00", 
"1954-04-11 16:00:00", "1954-06-30 15:00:00", "1978-03-21 16:00:00", 
"1978-09-20 15:00:00"), offSet = c(28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L), isdst = c(0L, 1L, 0L, 
0L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("PHT", "PHST", "PHT", "JST", 
"PHT", "PHST", "PHT", "PHST", "PHT"), numeric = c(-2147397248, 
-1046678400, -1038733200, -873273600, -794221200, -496224000, 
-489315600, 259344000, 275151600)), .Names = c("Manila", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -9L), class = "data.frame")
}

"Muscat" <- function () {
structure(list(Muscat = c("1901-12-14 20:45:52", "1919-12-31 20:05:40"
), offSet = c(14060L, 14400L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"GST"), numeric = c(-2147397248, -1577937260)), .Names = c("Muscat", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Nicosia" <- function () {
structure(list(Nicosia = c("1901-12-14 20:45:52", "1921-11-13 21:46:32", 
"1975-04-12 22:00:00", "1975-10-11 21:00:00", "1976-05-14 22:00:00", 
"1976-10-10 21:00:00", "1977-04-02 22:00:00", "1977-09-24 21:00:00", 
"1978-04-01 22:00:00", "1978-10-01 21:00:00", "1979-03-31 22:00:00", 
"1979-09-29 21:00:00", "1980-04-05 22:00:00", "1980-09-27 21:00:00", 
"1981-03-28 22:00:00", "1981-09-26 21:00:00", "1982-03-27 22:00:00", 
"1982-09-25 21:00:00", "1983-03-26 22:00:00", "1983-09-24 21:00:00", 
"1984-03-24 22:00:00", "1984-09-29 21:00:00", "1985-03-30 22:00:00", 
"1985-09-28 21:00:00", "1986-03-29 22:00:00", "1986-09-27 21:00:00", 
"1987-03-28 22:00:00", "1987-09-26 21:00:00", "1988-03-26 22:00:00", 
"1988-09-24 21:00:00", "1989-03-25 22:00:00", "1989-09-23 21:00:00", 
"1990-03-24 22:00:00", "1990-09-29 21:00:00", "1991-03-30 22:00:00", 
"1991-09-28 21:00:00", "1992-03-28 22:00:00", "1992-09-26 21:00:00", 
"1993-03-27 22:00:00", "1993-09-25 21:00:00", "1994-03-26 22:00:00", 
"1994-09-24 21:00:00", "1995-03-25 22:00:00", "1995-09-23 21:00:00", 
"1996-03-30 22:00:00", "1996-09-28 21:00:00", "1997-03-29 22:00:00", 
"1997-09-27 21:00:00", "1998-03-28 22:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00", "2037-10-25 01:00:00"
), offSet = c(8008L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 
7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 10800L, 7200L, 
10800L, 7200L, 10800L, 7200L), isdst = c(0L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", 
"EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", "EET", "EEST", 
"EET"), numeric = c(-2147397248, -1518920008, 166572000, 182293200, 
200959200, 213829200, 228866400, 243982800, 260316000, 276123600, 
291765600, 307486800, 323820000, 338936400, 354664800, 370386000, 
386114400, 401835600, 417564000, 433285200, 449013600, 465339600, 
481068000, 496789200, 512517600, 528238800, 543967200, 559688400, 
575416800, 591138000, 606866400, 622587600, 638316000, 654642000, 
670370400, 686091600, 701820000, 717541200, 733269600, 748990800, 
764719200, 780440400, 796168800, 811890000, 828223200, 843944400, 
859672800, 875394000, 891122400, 909277200, 922582800, 941331600, 
954032400, 972781200, 985482000, 1004230800, 1017536400, 1035680400, 
1048986000, 1067130000, 1080435600, 1099184400, 1111885200, 1130634000, 
1143334800, 1162083600, 1174784400, 1193533200, 1206838800, 1224982800, 
1238288400, 1256432400, 1269738000, 1288486800, 1301187600, 1319936400, 
1332637200, 1351386000, 1364691600, 1382835600, 1396141200, 1414285200, 
1427590800, 1445734800, 1459040400, 1477789200, 1490490000, 1509238800, 
1521939600, 1540688400, 1553994000, 1572138000, 1585443600, 1603587600, 
1616893200, 1635642000, 1648342800, 1667091600, 1679792400, 1698541200, 
1711846800, 1729990800, 1743296400, 1761440400, 1774746000, 1792890000, 
1806195600, 1824944400, 1837645200, 1856394000, 1869094800, 1887843600, 
1901149200, 1919293200, 1932598800, 1950742800, 1964048400, 1982797200, 
1995498000, 2014246800, 2026947600, 2045696400, 2058397200, 2077146000, 
2090451600, 2108595600, 2121901200, 2140045200)), .Names = c("Nicosia", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-128L), class = "data.frame")
}

"Novosibirsk" <- function () {
structure(list(Novosibirsk = c("1901-12-14 20:45:52", "1919-12-14 00:28:20", 
"1930-06-20 18:00:00", "1981-03-31 17:00:00", "1981-09-30 16:00:00", 
"1982-03-31 17:00:00", "1982-09-30 16:00:00", "1983-03-31 17:00:00", 
"1983-09-30 16:00:00", "1984-03-31 17:00:00", "1984-09-29 19:00:00", 
"1985-03-30 19:00:00", "1985-09-28 19:00:00", "1986-03-29 19:00:00", 
"1986-09-27 19:00:00", "1987-03-28 19:00:00", "1987-09-26 19:00:00", 
"1988-03-26 19:00:00", "1988-09-24 19:00:00", "1989-03-25 19:00:00", 
"1989-09-23 19:00:00", "1990-03-24 19:00:00", "1991-03-30 19:00:00", 
"1991-09-28 20:00:00", "1992-01-18 20:00:00", "1992-03-28 16:00:00", 
"1992-09-26 15:00:00", "1993-03-27 19:00:00", "1993-05-22 16:00:00", 
"1993-09-25 20:00:00", "1994-03-26 20:00:00", "1994-09-24 20:00:00", 
"1995-03-25 20:00:00", "1995-09-23 20:00:00", "1996-03-30 20:00:00", 
"1996-10-26 20:00:00", "1997-03-29 20:00:00", "1997-10-25 20:00:00", 
"1998-03-28 20:00:00", "1998-10-24 20:00:00", "1999-03-27 20:00:00", 
"1999-10-30 20:00:00", "2000-03-25 20:00:00", "2000-10-28 20:00:00", 
"2001-03-24 20:00:00", "2001-10-27 20:00:00", "2002-03-30 20:00:00", 
"2002-10-26 20:00:00", "2003-03-29 20:00:00", "2003-10-25 20:00:00", 
"2004-03-27 20:00:00", "2004-10-30 20:00:00", "2005-03-26 20:00:00", 
"2005-10-29 20:00:00", "2006-03-25 20:00:00", "2006-10-28 20:00:00", 
"2007-03-24 20:00:00", "2007-10-27 20:00:00", "2008-03-29 20:00:00", 
"2008-10-25 20:00:00", "2009-03-28 20:00:00", "2009-10-24 20:00:00", 
"2010-03-27 20:00:00", "2010-10-30 20:00:00", "2011-03-26 20:00:00", 
"2011-10-29 20:00:00", "2012-03-24 20:00:00", "2012-10-27 20:00:00", 
"2013-03-30 20:00:00", "2013-10-26 20:00:00", "2014-03-29 20:00:00", 
"2014-10-25 20:00:00", "2015-03-28 20:00:00", "2015-10-24 20:00:00", 
"2016-03-26 20:00:00", "2016-10-29 20:00:00", "2017-03-25 20:00:00", 
"2017-10-28 20:00:00", "2018-03-24 20:00:00", "2018-10-27 20:00:00", 
"2019-03-30 20:00:00", "2019-10-26 20:00:00", "2020-03-28 20:00:00", 
"2020-10-24 20:00:00", "2021-03-27 20:00:00", "2021-10-30 20:00:00", 
"2022-03-26 20:00:00", "2022-10-29 20:00:00", "2023-03-25 20:00:00", 
"2023-10-28 20:00:00", "2024-03-30 20:00:00", "2024-10-26 20:00:00", 
"2025-03-29 20:00:00", "2025-10-25 20:00:00", "2026-03-28 20:00:00", 
"2026-10-24 20:00:00", "2027-03-27 20:00:00", "2027-10-30 20:00:00", 
"2028-03-25 20:00:00", "2028-10-28 20:00:00", "2029-03-24 20:00:00", 
"2029-10-27 20:00:00", "2030-03-30 20:00:00", "2030-10-26 20:00:00", 
"2031-03-29 20:00:00", "2031-10-25 20:00:00", "2032-03-27 20:00:00", 
"2032-10-30 20:00:00", "2033-03-26 20:00:00", "2033-10-29 20:00:00", 
"2034-03-25 20:00:00", "2034-10-28 20:00:00", "2035-03-24 20:00:00", 
"2035-10-27 20:00:00", "2036-03-29 20:00:00", "2036-10-25 20:00:00", 
"2037-03-28 20:00:00", "2037-10-24 20:00:00"), offSet = c(19900L, 
21600L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 
28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 
28800L, 25200L, 28800L, 25200L, 28800L, 25200L, 21600L, 25200L, 
28800L, 25200L, 28800L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L), isdst = c(0L, 0L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L), TimeZone = c("LMT", "NOVT", "NOVT", "NOVST", "NOVT", 
"NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", 
"NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", 
"NOVST", "NOVST", "NOVT", "NOVT", "NOVST", "NOVT", "NOVST", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", "NOVT", "NOVST", 
"NOVT"), numeric = c(-2147397248, -1579476700, -1247551200, 354906000, 
370713600, 386442000, 402249600, 417978000, 433785600, 449600400, 
465332400, 481057200, 496782000, 512506800, 528231600, 543956400, 
559681200, 575406000, 591130800, 606855600, 622580400, 638305200, 
670359600, 686088000, 695764800, 701798400, 717519600, 733258800, 
738086400, 748987200, 764712000, 780436800, 796161600, 811886400, 
828216000, 846360000, 859665600, 877809600, 891115200, 909259200, 
922564800, 941313600, 954014400, 972763200, 985464000, 1004212800, 
1017518400, 1035662400, 1048968000, 1067112000, 1080417600, 1099166400, 
1111867200, 1130616000, 1143316800, 1162065600, 1174766400, 1193515200, 
1206820800, 1224964800, 1238270400, 1256414400, 1269720000, 1288468800, 
1301169600, 1319918400, 1332619200, 1351368000, 1364673600, 1382817600, 
1396123200, 1414267200, 1427572800, 1445716800, 1459022400, 1477771200, 
1490472000, 1509220800, 1521921600, 1540670400, 1553976000, 1572120000, 
1585425600, 1603569600, 1616875200, 1635624000, 1648324800, 1667073600, 
1679774400, 1698523200, 1711828800, 1729972800, 1743278400, 1761422400, 
1774728000, 1792872000, 1806177600, 1824926400, 1837627200, 1856376000, 
1869076800, 1887825600, 1901131200, 1919275200, 1932580800, 1950724800, 
1964030400, 1982779200, 1995480000, 2014228800, 2026929600, 2045678400, 
2058379200, 2077128000, 2090433600, 2108577600, 2121883200, 2140027200
)), .Names = c("Novosibirsk", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -118L), class = "data.frame")
}

"Omsk" <- function () {
structure(list(Omsk = c("1901-12-14 20:45:52", "1919-11-13 19:06:24", 
"1930-06-20 19:00:00", "1981-03-31 18:00:00", "1981-09-30 17:00:00", 
"1982-03-31 18:00:00", "1982-09-30 17:00:00", "1983-03-31 18:00:00", 
"1983-09-30 17:00:00", "1984-03-31 18:00:00", "1984-09-29 20:00:00", 
"1985-03-30 20:00:00", "1985-09-28 20:00:00", "1986-03-29 20:00:00", 
"1986-09-27 20:00:00", "1987-03-28 20:00:00", "1987-09-26 20:00:00", 
"1988-03-26 20:00:00", "1988-09-24 20:00:00", "1989-03-25 20:00:00", 
"1989-09-23 20:00:00", "1990-03-24 20:00:00", "1991-03-30 20:00:00", 
"1991-09-28 21:00:00", "1992-01-18 21:00:00", "1992-03-28 17:00:00", 
"1992-09-26 16:00:00", "1993-03-27 20:00:00", "1993-09-25 20:00:00", 
"1994-03-26 20:00:00", "1994-09-24 20:00:00", "1995-03-25 20:00:00", 
"1995-09-23 20:00:00", "1996-03-30 20:00:00", "1996-10-26 20:00:00", 
"1997-03-29 20:00:00", "1997-10-25 20:00:00", "1998-03-28 20:00:00", 
"1998-10-24 20:00:00", "1999-03-27 20:00:00", "1999-10-30 20:00:00", 
"2000-03-25 20:00:00", "2000-10-28 20:00:00", "2001-03-24 20:00:00", 
"2001-10-27 20:00:00", "2002-03-30 20:00:00", "2002-10-26 20:00:00", 
"2003-03-29 20:00:00", "2003-10-25 20:00:00", "2004-03-27 20:00:00", 
"2004-10-30 20:00:00", "2005-03-26 20:00:00", "2005-10-29 20:00:00", 
"2006-03-25 20:00:00", "2006-10-28 20:00:00", "2007-03-24 20:00:00", 
"2007-10-27 20:00:00", "2008-03-29 20:00:00", "2008-10-25 20:00:00", 
"2009-03-28 20:00:00", "2009-10-24 20:00:00", "2010-03-27 20:00:00", 
"2010-10-30 20:00:00", "2011-03-26 20:00:00", "2011-10-29 20:00:00", 
"2012-03-24 20:00:00", "2012-10-27 20:00:00", "2013-03-30 20:00:00", 
"2013-10-26 20:00:00", "2014-03-29 20:00:00", "2014-10-25 20:00:00", 
"2015-03-28 20:00:00", "2015-10-24 20:00:00", "2016-03-26 20:00:00", 
"2016-10-29 20:00:00", "2017-03-25 20:00:00", "2017-10-28 20:00:00", 
"2018-03-24 20:00:00", "2018-10-27 20:00:00", "2019-03-30 20:00:00", 
"2019-10-26 20:00:00", "2020-03-28 20:00:00", "2020-10-24 20:00:00", 
"2021-03-27 20:00:00", "2021-10-30 20:00:00", "2022-03-26 20:00:00", 
"2022-10-29 20:00:00", "2023-03-25 20:00:00", "2023-10-28 20:00:00", 
"2024-03-30 20:00:00", "2024-10-26 20:00:00", "2025-03-29 20:00:00", 
"2025-10-25 20:00:00", "2026-03-28 20:00:00", "2026-10-24 20:00:00", 
"2027-03-27 20:00:00", "2027-10-30 20:00:00", "2028-03-25 20:00:00", 
"2028-10-28 20:00:00", "2029-03-24 20:00:00", "2029-10-27 20:00:00", 
"2030-03-30 20:00:00", "2030-10-26 20:00:00", "2031-03-29 20:00:00", 
"2031-10-25 20:00:00", "2032-03-27 20:00:00", "2032-10-30 20:00:00", 
"2033-03-26 20:00:00", "2033-10-29 20:00:00", "2034-03-25 20:00:00", 
"2034-10-28 20:00:00", "2035-03-24 20:00:00", "2035-10-27 20:00:00", 
"2036-03-29 20:00:00", "2036-10-25 20:00:00", "2037-03-28 20:00:00", 
"2037-10-24 20:00:00"), offSet = c(17616L, 18000L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 18000L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"OMST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMSST", "OMST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", "OMSST", "OMST", 
"OMSST", "OMST", "OMSST", "OMST"), numeric = c(-2147397248, -1582088016, 
-1247547600, 354909600, 370717200, 386445600, 402253200, 417981600, 
433789200, 449604000, 465336000, 481060800, 496785600, 512510400, 
528235200, 543960000, 559684800, 575409600, 591134400, 606859200, 
622584000, 638308800, 670363200, 686091600, 695768400, 701802000, 
717523200, 733262400, 748987200, 764712000, 780436800, 796161600, 
811886400, 828216000, 846360000, 859665600, 877809600, 891115200, 
909259200, 922564800, 941313600, 954014400, 972763200, 985464000, 
1004212800, 1017518400, 1035662400, 1048968000, 1067112000, 1080417600, 
1099166400, 1111867200, 1130616000, 1143316800, 1162065600, 1174766400, 
1193515200, 1206820800, 1224964800, 1238270400, 1256414400, 1269720000, 
1288468800, 1301169600, 1319918400, 1332619200, 1351368000, 1364673600, 
1382817600, 1396123200, 1414267200, 1427572800, 1445716800, 1459022400, 
1477771200, 1490472000, 1509220800, 1521921600, 1540670400, 1553976000, 
1572120000, 1585425600, 1603569600, 1616875200, 1635624000, 1648324800, 
1667073600, 1679774400, 1698523200, 1711828800, 1729972800, 1743278400, 
1761422400, 1774728000, 1792872000, 1806177600, 1824926400, 1837627200, 
1856376000, 1869076800, 1887825600, 1901131200, 1919275200, 1932580800, 
1950724800, 1964030400, 1982779200, 1995480000, 2014228800, 2026929600, 
2045678400, 2058379200, 2077128000, 2090433600, 2108577600, 2121883200, 
2140027200)), .Names = c("Omsk", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -117L), class = "data.frame")
}

"Oral" <- function () {
structure(list(Oral = c("1901-12-14 20:45:52", "1924-05-01 20:34:36", 
"1930-06-20 20:00:00", "1982-03-31 18:00:00", "1982-09-30 18:00:00", 
"1983-03-31 19:00:00", "1983-09-30 18:00:00", "1984-03-31 19:00:00", 
"1984-09-29 21:00:00", "1985-03-30 21:00:00", "1985-09-28 21:00:00", 
"1986-03-29 21:00:00", "1986-09-27 21:00:00", "1987-03-28 21:00:00", 
"1987-09-26 21:00:00", "1988-03-26 21:00:00", "1989-03-25 21:00:00", 
"1989-09-23 22:00:00", "1990-03-24 22:00:00", "1991-12-15 20:00:00", 
"1992-03-28 19:00:00", "1992-09-26 18:00:00", "1993-03-27 22:00:00", 
"1993-09-25 22:00:00", "1994-03-26 22:00:00", "1994-09-24 22:00:00", 
"1995-03-25 22:00:00", "1995-09-23 22:00:00", "1996-03-30 22:00:00", 
"1996-10-26 22:00:00", "1997-03-29 22:00:00", "1997-10-25 22:00:00", 
"1998-03-28 22:00:00", "1998-10-24 22:00:00", "1999-03-27 22:00:00", 
"1999-10-30 22:00:00", "2000-03-25 22:00:00", "2000-10-28 22:00:00", 
"2001-03-24 22:00:00", "2001-10-27 22:00:00", "2002-03-30 22:00:00", 
"2002-10-26 22:00:00", "2003-03-29 22:00:00", "2003-10-25 22:00:00", 
"2004-03-27 22:00:00", "2004-10-30 22:00:00", "2005-03-14 20:00:00"
), offSet = c(12324L, 14400L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 0L), TimeZone = c("LMT", "URAT", "URAT", "URAST", 
"URAT", "URAST", "URAT", "URAST", "URAT", "URAST", "URAT", "URAST", 
"URAT", "URAST", "URAT", "URAST", "URAST", "URAT", "URAST", "ORAT", 
"ORAST", "ORAT", "ORAST", "ORAT", "ORAST", "ORAT", "ORAST", "ORAT", 
"ORAST", "ORAT", "ORAST", "ORAT", "ORAST", "ORAT", "ORAST", "ORAT", 
"ORAST", "ORAT", "ORAST", "ORAT", "ORAST", "ORAT", "ORAST", "ORAT", 
"ORAST", "ORAT", "ORAT"), numeric = c(-2147397248, -1441164324, 
-1247544000, 386445600, 402256800, 417985200, 433792800, 449607600, 
465339600, 481064400, 496789200, 512514000, 528238800, 543963600, 
559688400, 575413200, 606862800, 622591200, 638316000, 692827200, 
701809200, 717530400, 733269600, 748994400, 764719200, 780444000, 
796168800, 811893600, 828223200, 846367200, 859672800, 877816800, 
891122400, 909266400, 922572000, 941320800, 954021600, 972770400, 
985471200, 1004220000, 1017525600, 1035669600, 1048975200, 1067119200, 
1080424800, 1099173600, 1110830400)), .Names = c("Oral", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -47L), class = "data.frame")
}

"Phnom_Penh" <- function () {
structure(list(Phnom_Penh = c("1901-12-14 20:45:52", "1906-06-08 17:00:20", 
"1911-03-10 16:54:40", "1912-04-30 17:00:00", "1931-04-30 16:00:00"
), offSet = c(25180L, 25580L, 25200L, 28800L, 25200L), isdst = c(0L, 
0L, 0L, 0L, 0L), TimeZone = c("LMT", "SMT", "ICT", "ICT", "ICT"
), numeric = c(-2147397248, -2005973980, -1855983920, -1819954800, 
-1220428800)), .Names = c("Phnom_Penh", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -5L), class = "data.frame")
}

"Pontianak" <- function () {
structure(list(Pontianak = c("1908-04-30 16:42:40", "1932-10-31 16:42:40", 
"1942-01-28 16:30:00", "1945-09-22 15:00:00", "1948-04-30 16:30:00", 
"1950-04-30 16:00:00", "1963-12-31 16:30:00", "1987-12-31 16:00:00"
), offSet = c(26240L, 27000L, 32400L, 27000L, 28800L, 27000L, 
28800L, 25200L), isdst = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), TimeZone = c("PMT", 
"WIT", "JST", "WIT", "WIT", "WIT", "CIT", "WIT"), numeric = c(-1946186240, 
-1172906240, -881220600, -766054800, -683883000, -620812800, 
-189415800, 567964800)), .Names = c("Pontianak", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -8L), class = "data.frame")
}

"Pyongyang" <- function () {
structure(list(Pyongyang = c("1901-12-14 20:45:52", "1904-11-30 15:30:00", 
"1927-12-31 15:00:00", "1931-12-31 15:30:00", "1954-03-20 15:00:00", 
"1961-08-09 16:00:00"), offSet = c(30600L, 32400L, 30600L, 32400L, 
28800L, 32400L), isdst = c(0L, 0L, 0L, 0L, 0L, 0L), TimeZone = c("KST", 
"KST", "KST", "KST", "KST", "KST"), numeric = c(-2147397248, 
-2053931400, -1325494800, -1199262600, -498128400, -264931200
)), .Names = c("Pyongyang", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -6L), class = "data.frame")
}

"Qatar" <- function () {
structure(list(Qatar = c("1901-12-14 20:45:52", "1919-12-31 20:33:52", 
"1972-05-31 20:00:00"), offSet = c(12368L, 14400L, 10800L), isdst = c(0L, 
0L, 0L), TimeZone = c("LMT", "GST", "AST"), numeric = c(-2147397248, 
-1577935568, 76190400)), .Names = c("Qatar", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -3L), class = "data.frame")
}

"Qyzylorda" <- function () {
structure(list(Qyzylorda = c("1901-12-14 20:45:52", "1924-05-01 19:38:08", 
"1930-06-20 20:00:00", "1982-03-31 18:00:00", "1982-09-30 18:00:00", 
"1983-03-31 19:00:00", "1983-09-30 18:00:00", "1984-03-31 19:00:00", 
"1984-09-29 21:00:00", "1985-03-30 21:00:00", "1985-09-28 21:00:00", 
"1986-03-29 21:00:00", "1986-09-27 21:00:00", "1987-03-28 21:00:00", 
"1987-09-26 21:00:00", "1988-03-26 21:00:00", "1988-09-24 21:00:00", 
"1989-03-25 21:00:00", "1989-09-23 21:00:00", "1990-03-24 21:00:00", 
"1991-12-15 19:00:00", "1992-01-18 21:00:00", "1992-03-28 17:00:00", 
"1992-09-26 16:00:00", "1993-03-27 20:00:00", "1993-09-25 20:00:00", 
"1994-03-26 20:00:00", "1994-09-24 20:00:00", "1995-03-25 20:00:00", 
"1995-09-23 20:00:00", "1996-03-30 20:00:00", "1996-10-26 20:00:00", 
"1997-03-29 20:00:00", "1997-10-25 20:00:00", "1998-03-28 20:00:00", 
"1998-10-24 20:00:00", "1999-03-27 20:00:00", "1999-10-30 20:00:00", 
"2000-03-25 20:00:00", "2000-10-28 20:00:00", "2001-03-24 20:00:00", 
"2001-10-27 20:00:00", "2002-03-30 20:00:00", "2002-10-26 20:00:00", 
"2003-03-29 20:00:00", "2003-10-25 20:00:00", "2004-03-27 20:00:00", 
"2004-10-30 20:00:00"), offSet = c(15712L, 14400L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 
25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 
25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 
25200L, 21600L, 25200L, 21600L), isdst = c(0L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"KIZT", "KIZT", "KIZST", "KIZT", "KIZST", "KIZT", "KIZST", "KIZT", 
"KIZST", "KIZT", "KIZST", "KIZT", "KIZST", "KIZT", "KIZST", "KIZT", 
"KIZST", "KIZT", "KIZST", "QYZT", "QYZT", "QYZST", "QYZT", "QYZST", 
"QYZT", "QYZST", "QYZT", "QYZST", "QYZT", "QYZST", "QYZT", "QYZST", 
"QYZT", "QYZST", "QYZT", "QYZST", "QYZT", "QYZST", "QYZT", "QYZST", 
"QYZT", "QYZST", "QYZT", "QYZST", "QYZT", "QYZST", "QYZT"), numeric = c(-2147397248, 
-1441167712, -1247544000, 386445600, 402256800, 417985200, 433792800, 
449607600, 465339600, 481064400, 496789200, 512514000, 528238800, 
543963600, 559688400, 575413200, 591138000, 606862800, 622587600, 
638312400, 692823600, 695768400, 701802000, 717523200, 733262400, 
748987200, 764712000, 780436800, 796161600, 811886400, 828216000, 
846360000, 859665600, 877809600, 891115200, 909259200, 922564800, 
941313600, 954014400, 972763200, 985464000, 1004212800, 1017518400, 
1035662400, 1048968000, 1067112000, 1080417600, 1099166400)), .Names = c("Qyzylorda", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-48L), class = "data.frame")
}

"Rangoon" <- function () {
structure(list(Rangoon = c("1901-12-14 20:45:52", "1919-12-31 17:35:24", 
"1942-04-30 17:30:00", "1945-05-02 15:00:00"), offSet = c(23076L, 
23400L, 32400L, 23400L), isdst = c(0L, 0L, 0L, 0L), TimeZone = c("RMT", 
"BURT", "JST", "MMT"), numeric = c(-2147397248, -1577946276, 
-873268200, -778410000)), .Names = c("Rangoon", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -4L), class = "data.frame")
}

"Riyadh" <- function () {
structure(list(Riyadh = c("1901-12-14 20:45:52", "1949-12-31 20:53:08"
), offSet = c(11212L, 10800L), isdst = c(0L, 0L), TimeZone = c("LMT", 
"AST"), numeric = c(-2147397248, -631163212)), .Names = c("Riyadh", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Saigon" <- function () {
structure(list(Saigon = c("1901-12-14 20:45:52", "1906-06-08 16:53:20", 
"1911-03-10 16:54:40", "1912-04-30 17:00:00", "1931-04-30 16:00:00"
), offSet = c(25600L, 25580L, 25200L, 28800L, 25200L), isdst = c(0L, 
0L, 0L, 0L, 0L), TimeZone = c("LMT", "SMT", "ICT", "ICT", "ICT"
), numeric = c(-2147397248, -2005974400, -1855983920, -1819954800, 
-1220428800)), .Names = c("Saigon", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -5L), class = "data.frame")
}

"Sakhalin" <- function () {
structure(list(Sakhalin = c("1901-12-14 20:45:52", "1937-12-31 15:00:00", 
"1945-08-24 15:00:00", "1981-03-31 13:00:00", "1981-09-30 12:00:00", 
"1982-03-31 13:00:00", "1982-09-30 12:00:00", "1983-03-31 13:00:00", 
"1983-09-30 12:00:00", "1984-03-31 13:00:00", "1984-09-29 15:00:00", 
"1985-03-30 15:00:00", "1985-09-28 15:00:00", "1986-03-29 15:00:00", 
"1986-09-27 15:00:00", "1987-03-28 15:00:00", "1987-09-26 15:00:00", 
"1988-03-26 15:00:00", "1988-09-24 15:00:00", "1989-03-25 15:00:00", 
"1989-09-23 15:00:00", "1990-03-24 15:00:00", "1991-03-30 15:00:00", 
"1991-09-28 16:00:00", "1992-01-18 16:00:00", "1992-03-28 12:00:00", 
"1992-09-26 11:00:00", "1993-03-27 15:00:00", "1993-09-25 15:00:00", 
"1994-03-26 15:00:00", "1994-09-24 15:00:00", "1995-03-25 15:00:00", 
"1995-09-23 15:00:00", "1996-03-30 15:00:00", "1997-03-29 15:00:00", 
"1997-10-25 16:00:00", "1998-03-28 16:00:00", "1998-10-24 16:00:00", 
"1999-03-27 16:00:00", "1999-10-30 16:00:00", "2000-03-25 16:00:00", 
"2000-10-28 16:00:00", "2001-03-24 16:00:00", "2001-10-27 16:00:00", 
"2002-03-30 16:00:00", "2002-10-26 16:00:00", "2003-03-29 16:00:00", 
"2003-10-25 16:00:00", "2004-03-27 16:00:00", "2004-10-30 16:00:00", 
"2005-03-26 16:00:00", "2005-10-29 16:00:00", "2006-03-25 16:00:00", 
"2006-10-28 16:00:00", "2007-03-24 16:00:00", "2007-10-27 16:00:00", 
"2008-03-29 16:00:00", "2008-10-25 16:00:00", "2009-03-28 16:00:00", 
"2009-10-24 16:00:00", "2010-03-27 16:00:00", "2010-10-30 16:00:00", 
"2011-03-26 16:00:00", "2011-10-29 16:00:00", "2012-03-24 16:00:00", 
"2012-10-27 16:00:00", "2013-03-30 16:00:00", "2013-10-26 16:00:00", 
"2014-03-29 16:00:00", "2014-10-25 16:00:00", "2015-03-28 16:00:00", 
"2015-10-24 16:00:00", "2016-03-26 16:00:00", "2016-10-29 16:00:00", 
"2017-03-25 16:00:00", "2017-10-28 16:00:00", "2018-03-24 16:00:00", 
"2018-10-27 16:00:00", "2019-03-30 16:00:00", "2019-10-26 16:00:00", 
"2020-03-28 16:00:00", "2020-10-24 16:00:00", "2021-03-27 16:00:00", 
"2021-10-30 16:00:00", "2022-03-26 16:00:00", "2022-10-29 16:00:00", 
"2023-03-25 16:00:00", "2023-10-28 16:00:00", "2024-03-30 16:00:00", 
"2024-10-26 16:00:00", "2025-03-29 16:00:00", "2025-10-25 16:00:00", 
"2026-03-28 16:00:00", "2026-10-24 16:00:00", "2027-03-27 16:00:00", 
"2027-10-30 16:00:00", "2028-03-25 16:00:00", "2028-10-28 16:00:00", 
"2029-03-24 16:00:00", "2029-10-27 16:00:00", "2030-03-30 16:00:00", 
"2030-10-26 16:00:00", "2031-03-29 16:00:00", "2031-10-25 16:00:00", 
"2032-03-27 16:00:00", "2032-10-30 16:00:00", "2033-03-26 16:00:00", 
"2033-10-29 16:00:00", "2034-03-25 16:00:00", "2034-10-28 16:00:00", 
"2035-03-24 16:00:00", "2035-10-27 16:00:00", "2036-03-29 16:00:00", 
"2036-10-25 16:00:00", "2037-03-28 16:00:00", "2037-10-24 16:00:00"
), offSet = c(34248L, 32400L, 39600L, 43200L, 39600L, 43200L, 
39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 
39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 
39600L, 36000L, 39600L, 43200L, 39600L, 43200L, 39600L, 43200L, 
39600L, 43200L, 39600L, 43200L, 39600L, 36000L, 39600L, 36000L, 
39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 
39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 
39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 
39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 
39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 
39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 
39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 
39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 
39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 
39600L, 36000L, 39600L, 36000L, 39600L, 36000L), isdst = c(0L, 
0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L), TimeZone = c("LMT", "JST", "SAKT", "SAKST", "SAKT", 
"SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", 
"SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", 
"SAKST", "SAKST", "SAKT", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", 
"SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKST", "SAKT", "SAKST", 
"SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", 
"SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", 
"SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", 
"SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", 
"SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", 
"SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", 
"SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", 
"SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", 
"SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", 
"SAKT", "SAKST", "SAKT", "SAKST", "SAKT", "SAKST", "SAKT"), numeric = c(-2147397248, 
-1009875600, -768560400, 354891600, 370699200, 386427600, 402235200, 
417963600, 433771200, 449586000, 465318000, 481042800, 496767600, 
512492400, 528217200, 543942000, 559666800, 575391600, 591116400, 
606841200, 622566000, 638290800, 670345200, 686073600, 695750400, 
701784000, 717505200, 733244400, 748969200, 764694000, 780418800, 
796143600, 811868400, 828198000, 859647600, 877795200, 891100800, 
909244800, 922550400, 941299200, 9.54e+08, 972748800, 985449600, 
1004198400, 1017504000, 1035648000, 1048953600, 1067097600, 1080403200, 
1099152000, 1111852800, 1130601600, 1143302400, 1162051200, 1174752000, 
1193500800, 1206806400, 1224950400, 1238256000, 1256400000, 1269705600, 
1288454400, 1301155200, 1319904000, 1332604800, 1351353600, 1364659200, 
1382803200, 1396108800, 1414252800, 1427558400, 1445702400, 1459008000, 
1477756800, 1490457600, 1509206400, 1521907200, 1540656000, 1553961600, 
1572105600, 1585411200, 1603555200, 1616860800, 1635609600, 1648310400, 
1667059200, 1679760000, 1698508800, 1711814400, 1729958400, 1743264000, 
1761408000, 1774713600, 1792857600, 1806163200, 1824912000, 1837612800, 
1856361600, 1869062400, 1887811200, 1901116800, 1919260800, 1932566400, 
1950710400, 1964016000, 1982764800, 1995465600, 2014214400, 2026915200, 
2045664000, 2058364800, 2077113600, 2090419200, 2108563200, 2121868800, 
2140012800)), .Names = c("Sakhalin", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -116L), class = "data.frame")
}

"Samarkand" <- function () {
structure(list(Samarkand = c("1901-12-14 20:45:52", "1924-05-01 19:32:48", 
"1930-06-20 20:00:00", "1982-03-31 18:00:00", "1982-09-30 18:00:00", 
"1983-03-31 19:00:00", "1983-09-30 18:00:00", "1984-03-31 19:00:00", 
"1984-09-29 21:00:00", "1985-03-30 21:00:00", "1985-09-28 21:00:00", 
"1986-03-29 21:00:00", "1986-09-27 21:00:00", "1987-03-28 21:00:00", 
"1987-09-26 21:00:00", "1988-03-26 21:00:00", "1988-09-24 21:00:00", 
"1989-03-25 21:00:00", "1989-09-23 21:00:00", "1990-03-24 21:00:00", 
"1990-09-29 21:00:00", "1991-08-31 18:00:00", "1991-09-28 21:00:00"
), offSet = c(16032L, 14400L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"SAMT", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", 
"SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", "SAMST", "SAMT", 
"SAMST", "SAMT", "SAMST", "SAMT", "UZST", "UZT"), numeric = c(-2147397248, 
-1441168032, -1247544000, 386445600, 402256800, 417985200, 433792800, 
449607600, 465339600, 481064400, 496789200, 512514000, 528238800, 
543963600, 559688400, 575413200, 591138000, 606862800, 622587600, 
638312400, 654642000, 683661600, 686091600)), .Names = c("Samarkand", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-23L), class = "data.frame")
}

"Seoul" <- function () {
structure(list(Seoul = c("1901-12-14 20:45:52", "1904-11-30 15:30:00", 
"1927-12-31 15:00:00", "1931-12-31 15:30:00", "1954-03-20 15:00:00", 
"1960-05-14 16:00:00", "1960-09-12 15:00:00", "1961-08-09 16:00:00", 
"1968-09-30 15:30:00", "1987-05-09 15:00:00", "1987-10-10 14:00:00", 
"1988-05-07 15:00:00", "1988-10-08 14:00:00"), offSet = c(30600L, 
32400L, 30600L, 32400L, 28800L, 32400L, 28800L, 30600L, 32400L, 
36000L, 32400L, 36000L, 32400L), isdst = c(0L, 0L, 0L, 0L, 0L, 
1L, 0L, 0L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("KST", "KST", "KST", 
"KST", "KST", "KDT", "KST", "KST", "KST", "KDT", "KST", "KDT", 
"KST"), numeric = c(-2147397248, -2053931400, -1325494800, -1199262600, 
-498128400, -303984000, -293533200, -264931200, -39515400, 547570800, 
560872800, 579020400, 592322400)), .Names = c("Seoul", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -13L), class = "data.frame")
}

"Shanghai" <- function () {
structure(list(Shanghai = c("1901-12-14 20:45:52", "1927-12-31 15:54:08", 
"1940-06-02 16:00:00", "1940-09-30 15:00:00", "1941-03-15 16:00:00", 
"1941-09-30 15:00:00", "1986-05-03 16:00:00", "1986-09-13 15:00:00", 
"1987-04-11 16:00:00", "1987-09-12 15:00:00", "1988-04-09 16:00:00", 
"1988-09-10 15:00:00", "1989-04-15 16:00:00", "1989-09-16 15:00:00", 
"1990-04-14 16:00:00", "1990-09-15 15:00:00", "1991-04-13 16:00:00", 
"1991-09-14 15:00:00"), offSet = c(29152L, 28800L, 32400L, 28800L, 
32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 
32400L, 28800L, 32400L, 28800L, 32400L, 28800L), isdst = c(0L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L), TimeZone = c("LMT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST"), numeric = c(-2147397248, -1325491552, -933494400, 
-923130000, -908784000, -891594000, 515520000, 527007600, 545155200, 
558457200, 576604800, 589906800, 608659200, 621961200, 640108800, 
653410800, 671558400, 684860400)), .Names = c("Shanghai", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -18L), class = "data.frame")
}

"Singapore" <- function () {
structure(list(Singapore = c("1901-12-14 20:45:52", "1905-05-31 17:04:35", 
"1935-12-31 16:40:00", "1941-08-31 16:40:00", "1942-02-15 16:30:00", 
"1965-08-08 16:30:00", "1981-12-31 16:30:00"), offSet = c(24925L, 
25200L, 26400L, 27000L, 32400L, 27000L, 28800L), isdst = c(0L, 
0L, 0L, 0L, 0L, 0L, 0L), TimeZone = c("SMT", "MALT", "MALT", 
"MALT", "JST", "SGT", "SGT"), numeric = c(-2147397248, -2038200925, 
-1073028000, -894180000, -879665400, -138785400, 378664200)), .Names = c("Singapore", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-7L), class = "data.frame")
}

"Taipei" <- function () {
structure(list(Taipei = c("1901-12-14 20:45:52", "1945-04-30 16:00:00", 
"1945-09-30 15:00:00", "1946-04-30 16:00:00", "1946-09-30 15:00:00", 
"1947-04-30 16:00:00", "1947-09-30 15:00:00", "1948-04-30 16:00:00", 
"1948-09-30 15:00:00", "1949-04-30 16:00:00", "1949-09-30 15:00:00", 
"1950-04-30 16:00:00", "1950-09-30 15:00:00", "1951-04-30 16:00:00", 
"1951-09-30 15:00:00", "1952-02-29 16:00:00", "1952-10-31 15:00:00", 
"1953-03-31 16:00:00", "1953-10-31 15:00:00", "1954-03-31 16:00:00", 
"1954-10-31 15:00:00", "1955-03-31 16:00:00", "1955-09-30 15:00:00", 
"1956-03-31 16:00:00", "1956-09-30 15:00:00", "1957-03-31 16:00:00", 
"1957-09-30 15:00:00", "1958-03-31 16:00:00", "1958-09-30 15:00:00", 
"1959-03-31 16:00:00", "1959-09-30 15:00:00", "1960-05-31 16:00:00", 
"1960-09-30 15:00:00", "1961-05-31 16:00:00", "1961-09-30 15:00:00", 
"1974-03-31 16:00:00", "1974-09-30 15:00:00", "1975-03-31 16:00:00", 
"1975-09-30 15:00:00", "1980-06-29 16:00:00", "1980-09-29 15:00:00"
), offSet = c(28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L), isdst = c(0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L), TimeZone = c("CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST"), numeric = c(-2147397248, 
-778579200, -765363600, -747043200, -733827600, -715507200, -702291600, 
-683884800, -670669200, -652348800, -639133200, -620812800, -607597200, 
-589276800, -576061200, -562924800, -541760400, -528710400, -510224400, 
-497174400, -478688400, -465638400, -449830800, -434016000, -418208400, 
-402480000, -386672400, -370944000, -355136400, -339408000, -323600400, 
-302515200, -291978000, -270979200, -260442000, 133977600, 149785200, 
165513600, 181321200, 331142400, 339087600)), .Names = c("Taipei", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-41L), class = "data.frame")
}

"Tashkent" <- function () {
structure(list(Tashkent = c("1901-12-14 20:45:52", "1924-05-01 19:22:48", 
"1930-06-20 19:00:00", "1981-03-31 18:00:00", "1981-09-30 17:00:00", 
"1982-03-31 18:00:00", "1982-09-30 17:00:00", "1983-03-31 18:00:00", 
"1983-09-30 17:00:00", "1984-03-31 18:00:00", "1984-09-29 20:00:00", 
"1985-03-30 20:00:00", "1985-09-28 20:00:00", "1986-03-29 20:00:00", 
"1986-09-27 20:00:00", "1987-03-28 20:00:00", "1987-09-26 20:00:00", 
"1988-03-26 20:00:00", "1988-09-24 20:00:00", "1989-03-25 20:00:00", 
"1989-09-23 20:00:00", "1990-03-24 20:00:00", "1991-08-31 18:00:00", 
"1991-09-28 21:00:00"), offSet = c(16632L, 18000L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 21600L, 25200L, 
21600L, 25200L, 21600L, 18000L), isdst = c(0L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 1L, 0L), TimeZone = c("LMT", "TAST", "TAST", "TASST", "TAST", 
"TASST", "TAST", "TASST", "TAST", "TASST", "TAST", "TASST", "TAST", 
"TASST", "TAST", "TASST", "TAST", "TASST", "TAST", "TASST", "TAST", 
"TASST", "UZST", "UZT"), numeric = c(-2147397248, -1441168632, 
-1247547600, 354909600, 370717200, 386445600, 402253200, 417981600, 
433789200, 449604000, 465336000, 481060800, 496785600, 512510400, 
528235200, 543960000, 559684800, 575409600, 591134400, 606859200, 
622584000, 638308800, 683661600, 686091600)), .Names = c("Tashkent", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-24L), class = "data.frame")
}

"Tbilisi" <- function () {
structure(list(Tbilisi = c("1901-12-14 20:45:52", "1924-05-01 21:00:44", 
"1957-02-28 21:00:00", "1981-03-31 20:00:00", "1981-09-30 19:00:00", 
"1982-03-31 20:00:00", "1982-09-30 19:00:00", "1983-03-31 20:00:00", 
"1983-09-30 19:00:00", "1984-03-31 20:00:00", "1984-09-29 22:00:00", 
"1985-03-30 22:00:00", "1985-09-28 22:00:00", "1986-03-29 22:00:00", 
"1986-09-27 22:00:00", "1987-03-28 22:00:00", "1987-09-26 22:00:00", 
"1988-03-26 22:00:00", "1988-09-24 22:00:00", "1989-03-25 22:00:00", 
"1989-09-23 22:00:00", "1990-03-24 22:00:00", "1991-04-08 20:00:00", 
"1991-09-28 23:00:00", "1992-03-28 21:00:00", "1992-09-26 20:00:00", 
"1993-03-27 21:00:00", "1993-09-25 20:00:00", "1994-09-24 20:00:00", 
"1995-03-25 20:00:00", "1995-09-23 19:00:00", "1996-03-30 20:00:00", 
"1997-10-25 19:00:00", "1998-03-28 20:00:00", "1998-10-24 19:00:00", 
"1999-03-27 20:00:00", "1999-10-30 19:00:00", "2000-03-25 20:00:00", 
"2000-10-28 19:00:00", "2001-03-24 20:00:00", "2001-10-27 19:00:00", 
"2002-03-30 20:00:00", "2002-10-26 19:00:00", "2003-03-29 20:00:00", 
"2003-10-25 19:00:00", "2004-03-27 20:00:00", "2004-06-26 19:00:00", 
"2004-10-30 23:00:00", "2005-03-26 23:00:00"), offSet = c(10756L, 
10800L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 10800L, 14400L, 
10800L, 14400L, 10800L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 
18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 10800L, 14400L
), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 1L, 0L, 0L), TimeZone = c("TBMT", "TBIT", "TBIT", "TBIST", 
"TBIT", "TBIST", "TBIT", "TBIST", "TBIT", "TBIST", "TBIT", "TBIST", 
"TBIT", "TBIST", "TBIT", "TBIST", "TBIT", "TBIST", "TBIT", "TBIST", 
"TBIT", "TBIST", "GEST", "GET", "GEST", "GET", "GEST", "GET", 
"GET", "GEST", "GET", "GEST", "GET", "GEST", "GET", "GEST", "GET", 
"GEST", "GET", "GEST", "GET", "GEST", "GET", "GEST", "GET", "GEST", 
"GEST", "GET", "GET"), numeric = c(-2147397248, -1441162756, 
-405140400, 354916800, 370724400, 386452800, 402260400, 417988800, 
433796400, 449611200, 465343200, 481068000, 496792800, 512517600, 
528242400, 543967200, 559692000, 575416800, 591141600, 606866400, 
622591200, 638316000, 671140800, 686098800, 701816400, 717537600, 
733266000, 748987200, 780436800, 796161600, 811882800, 828216000, 
877806000, 891115200, 909255600, 922564800, 941310000, 954014400, 
972759600, 985464000, 1004209200, 1017518400, 1035658800, 1048968000, 
1067108400, 1080417600, 1088276400, 1099177200, 1111878000)), .Names = c("Tbilisi", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-49L), class = "data.frame")
}

"Tehran" <- function () {
structure(list(Tehran = c("1915-12-31 20:34:16", "1945-12-31 20:34:16", 
"1977-10-31 20:30:00", "1978-03-20 20:00:00", "1978-10-20 19:00:00", 
"1978-12-31 20:00:00", "1979-03-20 20:30:00", "1979-09-18 19:30:00", 
"1980-03-20 20:30:00", "1980-09-22 19:30:00", "1991-05-02 20:30:00", 
"1991-09-21 19:30:00", "1992-03-21 20:30:00", "1992-09-21 19:30:00", 
"1993-03-21 20:30:00", "1993-09-21 19:30:00", "1994-03-21 20:30:00", 
"1994-09-21 19:30:00", "1995-03-21 20:30:00", "1995-09-21 19:30:00", 
"1996-03-20 20:30:00", "1996-09-20 19:30:00", "1997-03-21 20:30:00", 
"1997-09-21 19:30:00", "1998-03-21 20:30:00", "1998-09-21 19:30:00", 
"1999-03-21 20:30:00", "1999-09-21 19:30:00", "2000-03-20 20:30:00", 
"2000-09-20 19:30:00", "2001-03-21 20:30:00", "2001-09-21 19:30:00", 
"2002-03-21 20:30:00", "2002-09-21 19:30:00", "2003-03-21 20:30:00", 
"2003-09-21 19:30:00", "2004-03-20 20:30:00", "2004-09-20 19:30:00", 
"2005-03-21 20:30:00", "2005-09-21 19:30:00", "2008-03-20 20:30:00", 
"2008-09-20 19:30:00", "2009-03-21 20:30:00", "2009-09-21 19:30:00", 
"2010-03-21 20:30:00", "2010-09-21 19:30:00", "2011-03-21 20:30:00", 
"2011-09-21 19:30:00", "2012-03-20 20:30:00", "2012-09-20 19:30:00", 
"2013-03-21 20:30:00", "2013-09-21 19:30:00", "2014-03-21 20:30:00", 
"2014-09-21 19:30:00", "2015-03-21 20:30:00", "2015-09-21 19:30:00", 
"2016-03-20 20:30:00", "2016-09-20 19:30:00", "2017-03-21 20:30:00", 
"2017-09-21 19:30:00", "2018-03-21 20:30:00", "2018-09-21 19:30:00", 
"2019-03-21 20:30:00", "2019-09-21 19:30:00", "2020-03-20 20:30:00", 
"2020-09-20 19:30:00", "2021-03-21 20:30:00", "2021-09-21 19:30:00", 
"2022-03-21 20:30:00", "2022-09-21 19:30:00", "2023-03-21 20:30:00", 
"2023-09-21 19:30:00", "2024-03-20 20:30:00", "2024-09-20 19:30:00", 
"2025-03-21 20:30:00", "2025-09-21 19:30:00", "2026-03-21 20:30:00", 
"2026-09-21 19:30:00", "2027-03-21 20:30:00", "2027-09-21 19:30:00", 
"2028-03-20 20:30:00", "2028-09-20 19:30:00", "2029-03-20 20:30:00", 
"2029-09-20 19:30:00", "2030-03-21 20:30:00", "2030-09-21 19:30:00", 
"2031-03-21 20:30:00", "2031-09-21 19:30:00", "2032-03-20 20:30:00", 
"2032-09-20 19:30:00", "2033-03-20 20:30:00", "2033-09-20 19:30:00", 
"2034-03-21 20:30:00", "2034-09-21 19:30:00", "2035-03-21 20:30:00", 
"2035-09-21 19:30:00", "2036-03-20 20:30:00", "2036-09-20 19:30:00", 
"2037-03-20 20:30:00", "2037-09-20 19:30:00"), offSet = c(12344L, 
12600L, 14400L, 18000L, 14400L, 12600L, 16200L, 12600L, 16200L, 
12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 
12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 
12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 
12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 
12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 
12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 
12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 
12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 
12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 
12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 
12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 12600L, 16200L, 
12600L, 16200L, 0L), isdst = c(0L, 0L, 0L, 1L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("TMT", 
"IRST", "IRST", "IRDT", "IRST", "IRST", "IRDT", "IRST", "IRDT", 
"IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", 
"IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", 
"IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", 
"IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", 
"IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", 
"IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", 
"IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", 
"IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", 
"IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", 
"IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", 
"IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", "IRST", "IRDT", 
"IRST", "IRDT", "UTC"), numeric = c(-1704165944, -757394744, 
247177800, 259272000, 277758000, 283982400, 290809800, 306531000, 
322432200, 338499000, 673216200, 685481400, 701209800, 717103800, 
732745800, 748639800, 764281800, 780175800, 795817800, 811711800, 
827353800, 843247800, 858976200, 874870200, 890512200, 906406200, 
922048200, 937942200, 953584200, 969478200, 985206600, 1001100600, 
1016742600, 1032636600, 1048278600, 1064172600, 1079814600, 1095708600, 
1111437000, 1127331000, 1206045000, 1221939000, 1237667400, 1253561400, 
1269203400, 1285097400, 1300739400, 1316633400, 1332275400, 1348169400, 
1363897800, 1379791800, 1395433800, 1411327800, 1426969800, 1442863800, 
1458505800, 1474399800, 1490128200, 1506022200, 1521664200, 1537558200, 
1553200200, 1569094200, 1584736200, 1600630200, 1616358600, 1632252600, 
1647894600, 1663788600, 1679430600, 1695324600, 1710966600, 1726860600, 
1742589000, 1758483000, 1774125000, 1790019000, 1805661000, 1821555000, 
1837197000, 1853091000, 1868733000, 1884627000, 1900355400, 1916249400, 
1931891400, 1947785400, 1963427400, 1979321400, 1994963400, 2010857400, 
2026585800, 2042479800, 2058121800, 2074015800, 2089657800, 2105551800, 
2121193800, 2137087800)), .Names = c("Tehran", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -100L), class = "data.frame")
}

"Thimphu" <- function () {
structure(list(Thimphu = c("1901-12-14 20:45:52", "1947-08-14 18:01:24", 
"1987-09-30 18:30:00"), offSet = c(21516L, 19800L, 21600L), isdst = c(0L, 
0L, 0L), TimeZone = c("LMT", "IST", "BTT"), numeric = c(-2147397248, 
-706341516, 560025000)), .Names = c("Thimphu", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -3L), class = "data.frame")
}

"Tokyo" <- function () {
structure(list(Tokyo = c("1937-12-31 15:00:00", "1948-05-01 17:00:00", 
"1948-09-10 16:00:00", "1949-04-02 17:00:00", "1949-09-09 16:00:00", 
"1950-05-06 17:00:00", "1950-09-08 16:00:00", "1951-05-05 17:00:00", 
"1951-09-07 16:00:00"), offSet = c(32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L), isdst = c(0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("JST", "JDT", "JST", "JDT", 
"JST", "JDT", "JST", "JDT", "JST"), numeric = c(-1009875600, 
-683794800, -672393600, -654764400, -640944000, -620290800, -609494400, 
-588841200, -578044800)), .Names = c("Tokyo", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -9L), class = "data.frame")
}

"Ulaanbaatar" <- function () {
structure(list(Ulaanbaatar = c("1901-12-14 20:45:52", "1905-07-31 16:52:28", 
"1977-12-31 17:00:00", "1983-03-31 16:00:00", "1983-09-30 15:00:00", 
"1984-03-31 16:00:00", "1984-09-29 15:00:00", "1985-03-30 16:00:00", 
"1985-09-28 15:00:00", "1986-03-29 16:00:00", "1986-09-27 15:00:00", 
"1987-03-28 16:00:00", "1987-09-26 15:00:00", "1988-03-26 16:00:00", 
"1988-09-24 15:00:00", "1989-03-25 16:00:00", "1989-09-23 15:00:00", 
"1990-03-24 16:00:00", "1990-09-29 15:00:00", "1991-03-30 16:00:00", 
"1991-09-28 15:00:00", "1992-03-28 16:00:00", "1992-09-26 15:00:00", 
"1993-03-27 16:00:00", "1993-09-25 15:00:00", "1994-03-26 16:00:00", 
"1994-09-24 15:00:00", "1995-03-25 16:00:00", "1995-09-23 15:00:00", 
"1996-03-30 16:00:00", "1996-09-28 15:00:00", "1997-03-29 16:00:00", 
"1997-09-27 15:00:00", "1998-03-28 16:00:00", "1998-09-26 15:00:00", 
"2001-04-27 18:00:00", "2001-09-28 17:00:00", "2002-03-29 18:00:00", 
"2002-09-27 17:00:00", "2003-03-28 18:00:00", "2003-09-26 17:00:00", 
"2004-03-26 18:00:00", "2004-09-24 17:00:00", "2005-03-25 18:00:00", 
"2005-09-23 17:00:00", "2006-03-24 18:00:00", "2006-09-29 17:00:00"
), offSet = c(25652L, 25200L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L), TimeZone = c("LMT", "ULAT", "ULAT", "ULAST", 
"ULAT", "ULAST", "ULAT", "ULAST", "ULAT", "ULAST", "ULAT", "ULAST", 
"ULAT", "ULAST", "ULAT", "ULAST", "ULAT", "ULAST", "ULAT", "ULAST", 
"ULAT", "ULAST", "ULAT", "ULAST", "ULAT", "ULAST", "ULAT", "ULAST", 
"ULAT", "ULAST", "ULAT", "ULAST", "ULAT", "ULAST", "ULAT", "ULAST", 
"ULAT", "ULAST", "ULAT", "ULAST", "ULAT", "ULAST", "ULAT", "ULAST", 
"ULAT", "ULAST", "ULAT"), numeric = c(-2147397248, -2032931252, 
252435600, 417974400, 433782000, 449596800, 465318000, 481046400, 
496767600, 512496000, 528217200, 543945600, 559666800, 575395200, 
591116400, 606844800, 622566000, 638294400, 654620400, 670348800, 
686070000, 701798400, 717519600, 733248000, 748969200, 764697600, 
780418800, 796147200, 811868400, 828201600, 843922800, 859651200, 
875372400, 891100800, 906822000, 988394400, 1001696400, 1017424800, 
1033146000, 1048874400, 1064595600, 1080324000, 1096045200, 1111773600, 
1127494800, 1143223200, 1159549200)), .Names = c("Ulaanbaatar", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-47L), class = "data.frame")
}

"Urumqi" <- function () {
structure(list(Urumqi = c("1901-12-14 20:45:52", "1927-12-31 18:09:40", 
"1980-04-30 18:00:00", "1986-05-03 16:00:00", "1986-09-13 15:00:00", 
"1987-04-11 16:00:00", "1987-09-12 15:00:00", "1988-04-09 16:00:00", 
"1988-09-10 15:00:00", "1989-04-15 16:00:00", "1989-09-16 15:00:00", 
"1990-04-14 16:00:00", "1990-09-15 15:00:00", "1991-04-13 16:00:00", 
"1991-09-14 15:00:00"), offSet = c(21020L, 21600L, 28800L, 32400L, 
28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 28800L, 32400L, 
28800L, 32400L, 28800L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", "URUT", 
"CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", "CDT", "CST", 
"CDT", "CST", "CDT", "CST"), numeric = c(-2147397248, -1325483420, 
325965600, 515520000, 527007600, 545155200, 558457200, 576604800, 
589906800, 608659200, 621961200, 640108800, 653410800, 671558400, 
684860400)), .Names = c("Urumqi", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -15L), class = "data.frame")
}

"Vientiane" <- function () {
structure(list(Vientiane = c("1901-12-14 20:45:52", "1906-06-08 17:09:36", 
"1911-03-10 16:54:40", "1912-04-30 17:00:00", "1931-04-30 16:00:00"
), offSet = c(24624L, 25580L, 25200L, 28800L, 25200L), isdst = c(0L, 
0L, 0L, 0L, 0L), TimeZone = c("LMT", "SMT", "ICT", "ICT", "ICT"
), numeric = c(-2147397248, -2005973424, -1855983920, -1819954800, 
-1220428800)), .Names = c("Vientiane", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -5L), class = "data.frame")
}

"Vladivostok" <- function () {
structure(list(Vladivostok = c("1901-12-14 20:45:52", "1922-11-14 15:12:16", 
"1930-06-20 15:00:00", "1981-03-31 14:00:00", "1981-09-30 13:00:00", 
"1982-03-31 14:00:00", "1982-09-30 13:00:00", "1983-03-31 14:00:00", 
"1983-09-30 13:00:00", "1984-03-31 14:00:00", "1984-09-29 16:00:00", 
"1985-03-30 16:00:00", "1985-09-28 16:00:00", "1986-03-29 16:00:00", 
"1986-09-27 16:00:00", "1987-03-28 16:00:00", "1987-09-26 16:00:00", 
"1988-03-26 16:00:00", "1988-09-24 16:00:00", "1989-03-25 16:00:00", 
"1989-09-23 16:00:00", "1990-03-24 16:00:00", "1991-03-30 16:00:00", 
"1991-09-28 17:00:00", "1992-01-18 17:00:00", "1992-03-28 13:00:00", 
"1992-09-26 12:00:00", "1993-03-27 16:00:00", "1993-09-25 16:00:00", 
"1994-03-26 16:00:00", "1994-09-24 16:00:00", "1995-03-25 16:00:00", 
"1995-09-23 16:00:00", "1996-03-30 16:00:00", "1996-10-26 16:00:00", 
"1997-03-29 16:00:00", "1997-10-25 16:00:00", "1998-03-28 16:00:00", 
"1998-10-24 16:00:00", "1999-03-27 16:00:00", "1999-10-30 16:00:00", 
"2000-03-25 16:00:00", "2000-10-28 16:00:00", "2001-03-24 16:00:00", 
"2001-10-27 16:00:00", "2002-03-30 16:00:00", "2002-10-26 16:00:00", 
"2003-03-29 16:00:00", "2003-10-25 16:00:00", "2004-03-27 16:00:00", 
"2004-10-30 16:00:00", "2005-03-26 16:00:00", "2005-10-29 16:00:00", 
"2006-03-25 16:00:00", "2006-10-28 16:00:00", "2007-03-24 16:00:00", 
"2007-10-27 16:00:00", "2008-03-29 16:00:00", "2008-10-25 16:00:00", 
"2009-03-28 16:00:00", "2009-10-24 16:00:00", "2010-03-27 16:00:00", 
"2010-10-30 16:00:00", "2011-03-26 16:00:00", "2011-10-29 16:00:00", 
"2012-03-24 16:00:00", "2012-10-27 16:00:00", "2013-03-30 16:00:00", 
"2013-10-26 16:00:00", "2014-03-29 16:00:00", "2014-10-25 16:00:00", 
"2015-03-28 16:00:00", "2015-10-24 16:00:00", "2016-03-26 16:00:00", 
"2016-10-29 16:00:00", "2017-03-25 16:00:00", "2017-10-28 16:00:00", 
"2018-03-24 16:00:00", "2018-10-27 16:00:00", "2019-03-30 16:00:00", 
"2019-10-26 16:00:00", "2020-03-28 16:00:00", "2020-10-24 16:00:00", 
"2021-03-27 16:00:00", "2021-10-30 16:00:00", "2022-03-26 16:00:00", 
"2022-10-29 16:00:00", "2023-03-25 16:00:00", "2023-10-28 16:00:00", 
"2024-03-30 16:00:00", "2024-10-26 16:00:00", "2025-03-29 16:00:00", 
"2025-10-25 16:00:00", "2026-03-28 16:00:00", "2026-10-24 16:00:00", 
"2027-03-27 16:00:00", "2027-10-30 16:00:00", "2028-03-25 16:00:00", 
"2028-10-28 16:00:00", "2029-03-24 16:00:00", "2029-10-27 16:00:00", 
"2030-03-30 16:00:00", "2030-10-26 16:00:00", "2031-03-29 16:00:00", 
"2031-10-25 16:00:00", "2032-03-27 16:00:00", "2032-10-30 16:00:00", 
"2033-03-26 16:00:00", "2033-10-29 16:00:00", "2034-03-25 16:00:00", 
"2034-10-28 16:00:00", "2035-03-24 16:00:00", "2035-10-27 16:00:00", 
"2036-03-29 16:00:00", "2036-10-25 16:00:00", "2037-03-28 16:00:00", 
"2037-10-24 16:00:00"), offSet = c(31664L, 32400L, 36000L, 39600L, 
36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 
36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 
36000L, 39600L, 36000L, 32400L, 36000L, 39600L, 36000L, 39600L, 
36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 
36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 
36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 
36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 
36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 
36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 
36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 
36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 
36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 
36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 
36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 36000L, 39600L, 
36000L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"VLAT", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", 
"VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", 
"VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLASST", "VLAST", 
"VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", 
"VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", 
"VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", 
"VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", 
"VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", 
"VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", 
"VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", 
"VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", 
"VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", 
"VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", 
"VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", "VLAT", "VLAST", 
"VLAT", "VLAST", "VLAT", "VLAST", "VLAT"), numeric = c(-2147397248, 
-1487321264, -1247562000, 354895200, 370702800, 386431200, 402238800, 
417967200, 433774800, 449589600, 465321600, 481046400, 496771200, 
512496000, 528220800, 543945600, 559670400, 575395200, 591120000, 
606844800, 622569600, 638294400, 670348800, 686077200, 695754000, 
701787600, 717508800, 733248000, 748972800, 764697600, 780422400, 
796147200, 811872000, 828201600, 846345600, 859651200, 877795200, 
891100800, 909244800, 922550400, 941299200, 9.54e+08, 972748800, 
985449600, 1004198400, 1017504000, 1035648000, 1048953600, 1067097600, 
1080403200, 1099152000, 1111852800, 1130601600, 1143302400, 1162051200, 
1174752000, 1193500800, 1206806400, 1224950400, 1238256000, 1256400000, 
1269705600, 1288454400, 1301155200, 1319904000, 1332604800, 1351353600, 
1364659200, 1382803200, 1396108800, 1414252800, 1427558400, 1445702400, 
1459008000, 1477756800, 1490457600, 1509206400, 1521907200, 1540656000, 
1553961600, 1572105600, 1585411200, 1603555200, 1616860800, 1635609600, 
1648310400, 1667059200, 1679760000, 1698508800, 1711814400, 1729958400, 
1743264000, 1761408000, 1774713600, 1792857600, 1806163200, 1824912000, 
1837612800, 1856361600, 1869062400, 1887811200, 1901116800, 1919260800, 
1932566400, 1950710400, 1964016000, 1982764800, 1995465600, 2014214400, 
2026915200, 2045664000, 2058364800, 2077113600, 2090419200, 2108563200, 
2121868800, 2140012800)), .Names = c("Vladivostok", "offSet", 
"isdst", "TimeZone", "numeric"), row.names = c(NA, -117L), class = "data.frame")
}

"Yakutsk" <- function () {
structure(list(Yakutsk = c("1901-12-14 20:45:52", "1919-12-14 15:21:20", 
"1930-06-20 16:00:00", "1981-03-31 15:00:00", "1981-09-30 14:00:00", 
"1982-03-31 15:00:00", "1982-09-30 14:00:00", "1983-03-31 15:00:00", 
"1983-09-30 14:00:00", "1984-03-31 15:00:00", "1984-09-29 17:00:00", 
"1985-03-30 17:00:00", "1985-09-28 17:00:00", "1986-03-29 17:00:00", 
"1986-09-27 17:00:00", "1987-03-28 17:00:00", "1987-09-26 17:00:00", 
"1988-03-26 17:00:00", "1988-09-24 17:00:00", "1989-03-25 17:00:00", 
"1989-09-23 17:00:00", "1990-03-24 17:00:00", "1991-03-30 17:00:00", 
"1991-09-28 18:00:00", "1992-01-18 18:00:00", "1992-03-28 14:00:00", 
"1992-09-26 13:00:00", "1993-03-27 17:00:00", "1993-09-25 17:00:00", 
"1994-03-26 17:00:00", "1994-09-24 17:00:00", "1995-03-25 17:00:00", 
"1995-09-23 17:00:00", "1996-03-30 17:00:00", "1996-10-26 17:00:00", 
"1997-03-29 17:00:00", "1997-10-25 17:00:00", "1998-03-28 17:00:00", 
"1998-10-24 17:00:00", "1999-03-27 17:00:00", "1999-10-30 17:00:00", 
"2000-03-25 17:00:00", "2000-10-28 17:00:00", "2001-03-24 17:00:00", 
"2001-10-27 17:00:00", "2002-03-30 17:00:00", "2002-10-26 17:00:00", 
"2003-03-29 17:00:00", "2003-10-25 17:00:00", "2004-03-27 17:00:00", 
"2004-10-30 17:00:00", "2005-03-26 17:00:00", "2005-10-29 17:00:00", 
"2006-03-25 17:00:00", "2006-10-28 17:00:00", "2007-03-24 17:00:00", 
"2007-10-27 17:00:00", "2008-03-29 17:00:00", "2008-10-25 17:00:00", 
"2009-03-28 17:00:00", "2009-10-24 17:00:00", "2010-03-27 17:00:00", 
"2010-10-30 17:00:00", "2011-03-26 17:00:00", "2011-10-29 17:00:00", 
"2012-03-24 17:00:00", "2012-10-27 17:00:00", "2013-03-30 17:00:00", 
"2013-10-26 17:00:00", "2014-03-29 17:00:00", "2014-10-25 17:00:00", 
"2015-03-28 17:00:00", "2015-10-24 17:00:00", "2016-03-26 17:00:00", 
"2016-10-29 17:00:00", "2017-03-25 17:00:00", "2017-10-28 17:00:00", 
"2018-03-24 17:00:00", "2018-10-27 17:00:00", "2019-03-30 17:00:00", 
"2019-10-26 17:00:00", "2020-03-28 17:00:00", "2020-10-24 17:00:00", 
"2021-03-27 17:00:00", "2021-10-30 17:00:00", "2022-03-26 17:00:00", 
"2022-10-29 17:00:00", "2023-03-25 17:00:00", "2023-10-28 17:00:00", 
"2024-03-30 17:00:00", "2024-10-26 17:00:00", "2025-03-29 17:00:00", 
"2025-10-25 17:00:00", "2026-03-28 17:00:00", "2026-10-24 17:00:00", 
"2027-03-27 17:00:00", "2027-10-30 17:00:00", "2028-03-25 17:00:00", 
"2028-10-28 17:00:00", "2029-03-24 17:00:00", "2029-10-27 17:00:00", 
"2030-03-30 17:00:00", "2030-10-26 17:00:00", "2031-03-29 17:00:00", 
"2031-10-25 17:00:00", "2032-03-27 17:00:00", "2032-10-30 17:00:00", 
"2033-03-26 17:00:00", "2033-10-29 17:00:00", "2034-03-25 17:00:00", 
"2034-10-28 17:00:00", "2035-03-24 17:00:00", "2035-10-27 17:00:00", 
"2036-03-29 17:00:00", "2036-10-25 17:00:00", "2037-03-28 17:00:00", 
"2037-10-24 17:00:00"), offSet = c(31120L, 28800L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 28800L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 32400L, 36000L, 
32400L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"YAKT", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKST", "YAKT", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", "YAKST", "YAKT", 
"YAKST", "YAKT", "YAKST", "YAKT"), numeric = c(-2147397248, -1579423120, 
-1247558400, 354898800, 370706400, 386434800, 402242400, 417970800, 
433778400, 449593200, 465325200, 481050000, 496774800, 512499600, 
528224400, 543949200, 559674000, 575398800, 591123600, 606848400, 
622573200, 638298000, 670352400, 686080800, 695757600, 701791200, 
717512400, 733251600, 748976400, 764701200, 780426000, 796150800, 
811875600, 828205200, 846349200, 859654800, 877798800, 891104400, 
909248400, 922554000, 941302800, 954003600, 972752400, 985453200, 
1004202000, 1017507600, 1035651600, 1048957200, 1067101200, 1080406800, 
1099155600, 1111856400, 1130605200, 1143306000, 1162054800, 1174755600, 
1193504400, 1206810000, 1224954000, 1238259600, 1256403600, 1269709200, 
1288458000, 1301158800, 1319907600, 1332608400, 1351357200, 1364662800, 
1382806800, 1396112400, 1414256400, 1427562000, 1445706000, 1459011600, 
1477760400, 1490461200, 1509210000, 1521910800, 1540659600, 1553965200, 
1572109200, 1585414800, 1603558800, 1616864400, 1635613200, 1648314000, 
1667062800, 1679763600, 1698512400, 1711818000, 1729962000, 1743267600, 
1761411600, 1774717200, 1792861200, 1806166800, 1824915600, 1837616400, 
1856365200, 1869066000, 1887814800, 1901120400, 1919264400, 1932570000, 
1950714000, 1964019600, 1982768400, 1995469200, 2014218000, 2026918800, 
2045667600, 2058368400, 2077117200, 2090422800, 2108566800, 2121872400, 
2140016400)), .Names = c("Yakutsk", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -117L), class = "data.frame")
}

"Yekaterinburg" <- function () {
structure(list(Yekaterinburg = c("1901-12-14 20:45:52", "1919-07-14 23:57:36", 
"1930-06-20 20:00:00", "1981-03-31 19:00:00", "1981-09-30 18:00:00", 
"1982-03-31 19:00:00", "1982-09-30 18:00:00", "1983-03-31 19:00:00", 
"1983-09-30 18:00:00", "1984-03-31 19:00:00", "1984-09-29 21:00:00", 
"1985-03-30 21:00:00", "1985-09-28 21:00:00", "1986-03-29 21:00:00", 
"1986-09-27 21:00:00", "1987-03-28 21:00:00", "1987-09-26 21:00:00", 
"1988-03-26 21:00:00", "1988-09-24 21:00:00", "1989-03-25 21:00:00", 
"1989-09-23 21:00:00", "1990-03-24 21:00:00", "1991-03-30 21:00:00", 
"1991-09-28 22:00:00", "1992-01-18 22:00:00", "1992-03-28 18:00:00", 
"1992-09-26 17:00:00", "1993-03-27 21:00:00", "1993-09-25 21:00:00", 
"1994-03-26 21:00:00", "1994-09-24 21:00:00", "1995-03-25 21:00:00", 
"1995-09-23 21:00:00", "1996-03-30 21:00:00", "1996-10-26 21:00:00", 
"1997-03-29 21:00:00", "1997-10-25 21:00:00", "1998-03-28 21:00:00", 
"1998-10-24 21:00:00", "1999-03-27 21:00:00", "1999-10-30 21:00:00", 
"2000-03-25 21:00:00", "2000-10-28 21:00:00", "2001-03-24 21:00:00", 
"2001-10-27 21:00:00", "2002-03-30 21:00:00", "2002-10-26 21:00:00", 
"2003-03-29 21:00:00", "2003-10-25 21:00:00", "2004-03-27 21:00:00", 
"2004-10-30 21:00:00", "2005-03-26 21:00:00", "2005-10-29 21:00:00", 
"2006-03-25 21:00:00", "2006-10-28 21:00:00", "2007-03-24 21:00:00", 
"2007-10-27 21:00:00", "2008-03-29 21:00:00", "2008-10-25 21:00:00", 
"2009-03-28 21:00:00", "2009-10-24 21:00:00", "2010-03-27 21:00:00", 
"2010-10-30 21:00:00", "2011-03-26 21:00:00", "2011-10-29 21:00:00", 
"2012-03-24 21:00:00", "2012-10-27 21:00:00", "2013-03-30 21:00:00", 
"2013-10-26 21:00:00", "2014-03-29 21:00:00", "2014-10-25 21:00:00", 
"2015-03-28 21:00:00", "2015-10-24 21:00:00", "2016-03-26 21:00:00", 
"2016-10-29 21:00:00", "2017-03-25 21:00:00", "2017-10-28 21:00:00", 
"2018-03-24 21:00:00", "2018-10-27 21:00:00", "2019-03-30 21:00:00", 
"2019-10-26 21:00:00", "2020-03-28 21:00:00", "2020-10-24 21:00:00", 
"2021-03-27 21:00:00", "2021-10-30 21:00:00", "2022-03-26 21:00:00", 
"2022-10-29 21:00:00", "2023-03-25 21:00:00", "2023-10-28 21:00:00", 
"2024-03-30 21:00:00", "2024-10-26 21:00:00", "2025-03-29 21:00:00", 
"2025-10-25 21:00:00", "2026-03-28 21:00:00", "2026-10-24 21:00:00", 
"2027-03-27 21:00:00", "2027-10-30 21:00:00", "2028-03-25 21:00:00", 
"2028-10-28 21:00:00", "2029-03-24 21:00:00", "2029-10-27 21:00:00", 
"2030-03-30 21:00:00", "2030-10-26 21:00:00", "2031-03-29 21:00:00", 
"2031-10-25 21:00:00", "2032-03-27 21:00:00", "2032-10-30 21:00:00", 
"2033-03-26 21:00:00", "2033-10-29 21:00:00", "2034-03-25 21:00:00", 
"2034-10-28 21:00:00", "2035-03-24 21:00:00", "2035-10-27 21:00:00", 
"2036-03-29 21:00:00", "2036-10-25 21:00:00", "2037-03-28 21:00:00", 
"2037-10-24 21:00:00"), offSet = c(14544L, 14400L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 14400L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 18000L, 21600L, 
18000L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"SVET", "SVET", "SVEST", "SVET", "SVEST", "SVET", "SVEST", "SVET", 
"SVEST", "SVET", "SVEST", "SVET", "SVEST", "SVET", "SVEST", "SVET", 
"SVEST", "SVET", "SVEST", "SVET", "SVEST", "SVEST", "SVET", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", "YEKST", "YEKT", 
"YEKST", "YEKT", "YEKST", "YEKT"), numeric = c(-2147397248, -1592611344, 
-1247544000, 354913200, 370720800, 386449200, 402256800, 417985200, 
433792800, 449607600, 465339600, 481064400, 496789200, 512514000, 
528238800, 543963600, 559688400, 575413200, 591138000, 606862800, 
622587600, 638312400, 670366800, 686095200, 695772000, 701805600, 
717526800, 733266000, 748990800, 764715600, 780440400, 796165200, 
811890000, 828219600, 846363600, 859669200, 877813200, 891118800, 
909262800, 922568400, 941317200, 954018000, 972766800, 985467600, 
1004216400, 1017522000, 1035666000, 1048971600, 1067115600, 1080421200, 
1099170000, 1111870800, 1130619600, 1143320400, 1162069200, 1174770000, 
1193518800, 1206824400, 1224968400, 1238274000, 1256418000, 1269723600, 
1288472400, 1301173200, 1319922000, 1332622800, 1351371600, 1364677200, 
1382821200, 1396126800, 1414270800, 1427576400, 1445720400, 1459026000, 
1477774800, 1490475600, 1509224400, 1521925200, 1540674000, 1553979600, 
1572123600, 1585429200, 1603573200, 1616878800, 1635627600, 1648328400, 
1667077200, 1679778000, 1698526800, 1711832400, 1729976400, 1743282000, 
1761426000, 1774731600, 1792875600, 1806181200, 1824930000, 1837630800, 
1856379600, 1869080400, 1887829200, 1901134800, 1919278800, 1932584400, 
1950728400, 1964034000, 1982782800, 1995483600, 2014232400, 2026933200, 
2045682000, 2058382800, 2077131600, 2090437200, 2108581200, 2121886800, 
2140030800)), .Names = c("Yekaterinburg", "offSet", "isdst", 
"TimeZone", "numeric"), row.names = c(NA, -117L), class = "data.frame")
}

"Yerevan" <- function () {
structure(list(Yerevan = c("1901-12-14 20:45:52", "1924-05-01 21:02:00", 
"1957-02-28 21:00:00", "1981-03-31 20:00:00", "1981-09-30 19:00:00", 
"1982-03-31 20:00:00", "1982-09-30 19:00:00", "1983-03-31 20:00:00", 
"1983-09-30 19:00:00", "1984-03-31 20:00:00", "1984-09-29 22:00:00", 
"1985-03-30 22:00:00", "1985-09-28 22:00:00", "1986-03-29 22:00:00", 
"1986-09-27 22:00:00", "1987-03-28 22:00:00", "1987-09-26 22:00:00", 
"1988-03-26 22:00:00", "1988-09-24 22:00:00", "1989-03-25 22:00:00", 
"1989-09-23 22:00:00", "1990-03-24 22:00:00", "1991-09-22 20:00:00", 
"1991-09-28 23:00:00", "1992-03-28 20:00:00", "1992-09-26 19:00:00", 
"1993-03-27 23:00:00", "1993-09-25 23:00:00", "1994-03-26 23:00:00", 
"1994-09-24 23:00:00", "1995-09-23 23:00:00", "1997-03-29 22:00:00", 
"1997-10-25 22:00:00", "1998-03-28 22:00:00", "1998-10-24 22:00:00", 
"1999-03-27 22:00:00", "1999-10-30 22:00:00", "2000-03-25 22:00:00", 
"2000-10-28 22:00:00", "2001-03-24 22:00:00", "2001-10-27 22:00:00", 
"2002-03-30 22:00:00", "2002-10-26 22:00:00", "2003-03-29 22:00:00", 
"2003-10-25 22:00:00", "2004-03-27 22:00:00", "2004-10-30 22:00:00", 
"2005-03-26 22:00:00", "2005-10-29 22:00:00", "2006-03-25 22:00:00", 
"2006-10-28 22:00:00", "2007-03-24 22:00:00", "2007-10-27 22:00:00", 
"2008-03-29 22:00:00", "2008-10-25 22:00:00", "2009-03-28 22:00:00", 
"2009-10-24 22:00:00", "2010-03-27 22:00:00", "2010-10-30 22:00:00", 
"2011-03-26 22:00:00", "2011-10-29 22:00:00", "2012-03-24 22:00:00", 
"2012-10-27 22:00:00", "2013-03-30 22:00:00", "2013-10-26 22:00:00", 
"2014-03-29 22:00:00", "2014-10-25 22:00:00", "2015-03-28 22:00:00", 
"2015-10-24 22:00:00", "2016-03-26 22:00:00", "2016-10-29 22:00:00", 
"2017-03-25 22:00:00", "2017-10-28 22:00:00", "2018-03-24 22:00:00", 
"2018-10-27 22:00:00", "2019-03-30 22:00:00", "2019-10-26 22:00:00", 
"2020-03-28 22:00:00", "2020-10-24 22:00:00", "2021-03-27 22:00:00", 
"2021-10-30 22:00:00", "2022-03-26 22:00:00", "2022-10-29 22:00:00", 
"2023-03-25 22:00:00", "2023-10-28 22:00:00", "2024-03-30 22:00:00", 
"2024-10-26 22:00:00", "2025-03-29 22:00:00", "2025-10-25 22:00:00", 
"2026-03-28 22:00:00", "2026-10-24 22:00:00", "2027-03-27 22:00:00", 
"2027-10-30 22:00:00", "2028-03-25 22:00:00", "2028-10-28 22:00:00", 
"2029-03-24 22:00:00", "2029-10-27 22:00:00", "2030-03-30 22:00:00", 
"2030-10-26 22:00:00", "2031-03-29 22:00:00", "2031-10-25 22:00:00", 
"2032-03-27 22:00:00", "2032-10-30 22:00:00", "2033-03-26 22:00:00", 
"2033-10-29 22:00:00", "2034-03-25 22:00:00", "2034-10-28 22:00:00", 
"2035-03-24 22:00:00", "2035-10-27 22:00:00", "2036-03-29 22:00:00", 
"2036-10-25 22:00:00", "2037-03-28 22:00:00", "2037-10-24 22:00:00"
), offSet = c(10680L, 10800L, 14400L, 18000L, 14400L, 18000L, 
14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 
14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 
14400L, 10800L, 14400L, 10800L, 14400L, 10800L, 14400L, 10800L, 
14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 
14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 
14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 
14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 
14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 
14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 
14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 
14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 
14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 
14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 14400L, 18000L, 
14400L, 18000L, 14400L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"YERT", "YERT", "YERST", "YERT", "YERST", "YERT", "YERST", "YERT", 
"YERST", "YERT", "YERST", "YERT", "YERST", "YERT", "YERST", "YERT", 
"YERST", "YERT", "YERST", "YERT", "YERST", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", 
"AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT", "AMST", 
"AMT", "AMST", "AMT", "AMST", "AMT", "AMST", "AMT"), numeric = c(-2147397248, 
-1441162680, -405140400, 354916800, 370724400, 386452800, 402260400, 
417988800, 433796400, 449611200, 465343200, 481068000, 496792800, 
512517600, 528242400, 543967200, 559692000, 575416800, 591141600, 
606866400, 622591200, 638316000, 685569600, 686098800, 701812800, 
717534000, 733273200, 748998000, 764722800, 780447600, 811897200, 
859672800, 877816800, 891122400, 909266400, 922572000, 941320800, 
954021600, 972770400, 985471200, 1004220000, 1017525600, 1035669600, 
1048975200, 1067119200, 1080424800, 1099173600, 1111874400, 1130623200, 
1143324000, 1162072800, 1174773600, 1193522400, 1206828000, 1224972000, 
1238277600, 1256421600, 1269727200, 1288476000, 1301176800, 1319925600, 
1332626400, 1351375200, 1364680800, 1382824800, 1396130400, 1414274400, 
1427580000, 1445724000, 1459029600, 1477778400, 1490479200, 1509228000, 
1521928800, 1540677600, 1553983200, 1572127200, 1585432800, 1603576800, 
1616882400, 1635631200, 1648332000, 1667080800, 1679781600, 1698530400, 
1711836000, 1729980000, 1743285600, 1761429600, 1774735200, 1792879200, 
1806184800, 1824933600, 1837634400, 1856383200, 1869084000, 1887832800, 
1901138400, 1919282400, 1932588000, 1950732000, 1964037600, 1982786400, 
1995487200, 2014236000, 2026936800, 2045685600, 2058386400, 2077135200, 
2090440800, 2108584800, 2121890400, 2140034400)), .Names = c("Yerevan", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-113L), class = "data.frame")
}

"Azores" <- function () {
structure(list(Azores = c("1901-12-14 20:45:52", "1911-05-24 01:54:32", 
"1916-06-18 01:00:00", "1916-11-01 02:00:00", "1917-03-01 01:00:00", 
"1917-10-15 01:00:00", "1918-03-02 01:00:00", "1918-10-15 01:00:00", 
"1919-03-01 01:00:00", "1919-10-15 01:00:00", "1920-03-01 01:00:00", 
"1920-10-15 01:00:00", "1921-03-01 01:00:00", "1921-10-15 01:00:00", 
"1924-04-17 01:00:00", "1924-10-15 01:00:00", "1926-04-18 01:00:00", 
"1926-10-03 01:00:00", "1927-04-10 01:00:00", "1927-10-02 01:00:00", 
"1928-04-15 01:00:00", "1928-10-07 01:00:00", "1929-04-21 01:00:00", 
"1929-10-06 01:00:00", "1931-04-19 01:00:00", "1931-10-04 01:00:00", 
"1932-04-03 01:00:00", "1932-10-02 01:00:00", "1934-04-08 01:00:00", 
"1934-10-07 01:00:00", "1935-03-31 01:00:00", "1935-10-06 01:00:00", 
"1936-04-19 01:00:00", "1936-10-04 01:00:00", "1937-04-04 01:00:00", 
"1937-10-03 01:00:00", "1938-03-27 01:00:00", "1938-10-02 01:00:00", 
"1939-04-16 01:00:00", "1939-11-19 01:00:00", "1940-02-25 01:00:00", 
"1940-10-06 01:00:00", "1941-04-06 01:00:00", "1941-10-06 01:00:00", 
"1942-03-15 01:00:00", "1942-04-26 00:00:00", "1942-08-16 00:00:00", 
"1942-10-25 01:00:00", "1943-03-14 01:00:00", "1943-04-18 00:00:00", 
"1943-08-29 00:00:00", "1943-10-31 01:00:00", "1944-03-12 01:00:00", 
"1944-04-23 00:00:00", "1944-08-27 00:00:00", "1944-10-29 01:00:00", 
"1945-03-11 01:00:00", "1945-04-22 00:00:00", "1945-08-26 00:00:00", 
"1945-10-28 01:00:00", "1946-04-07 01:00:00", "1946-10-06 01:00:00", 
"1947-04-06 04:00:00", "1947-10-05 04:00:00", "1948-04-04 04:00:00", 
"1948-10-03 04:00:00", "1949-04-03 04:00:00", "1949-10-02 04:00:00", 
"1951-04-01 04:00:00", "1951-10-07 04:00:00", "1952-04-06 04:00:00", 
"1952-10-05 04:00:00", "1953-04-05 04:00:00", "1953-10-04 04:00:00", 
"1954-04-04 04:00:00", "1954-10-03 04:00:00", "1955-04-03 04:00:00", 
"1955-10-02 04:00:00", "1956-04-01 04:00:00", "1956-10-07 04:00:00", 
"1957-04-07 04:00:00", "1957-10-06 04:00:00", "1958-04-06 04:00:00", 
"1958-10-05 04:00:00", "1959-04-05 04:00:00", "1959-10-04 04:00:00", 
"1960-04-03 04:00:00", "1960-10-02 04:00:00", "1961-04-02 04:00:00", 
"1961-10-01 04:00:00", "1962-04-01 04:00:00", "1962-10-07 04:00:00", 
"1963-04-07 04:00:00", "1963-10-06 04:00:00", "1964-04-05 04:00:00", 
"1964-10-04 04:00:00", "1965-04-04 04:00:00", "1965-10-03 04:00:00", 
"1966-04-03 04:00:00", "1977-03-27 01:00:00", "1977-09-25 01:00:00", 
"1978-04-02 01:00:00", "1978-10-01 01:00:00", "1979-04-01 01:00:00", 
"1979-09-30 02:00:00", "1980-03-30 01:00:00", "1980-09-28 02:00:00", 
"1981-03-29 02:00:00", "1981-09-27 02:00:00", "1982-03-28 02:00:00", 
"1982-09-26 02:00:00", "1983-03-27 03:00:00", "1983-09-25 02:00:00", 
"1984-03-25 02:00:00", "1984-09-30 02:00:00", "1985-03-31 02:00:00", 
"1985-09-29 02:00:00", "1986-03-30 02:00:00", "1986-09-28 02:00:00", 
"1987-03-29 02:00:00", "1987-09-27 02:00:00", "1988-03-27 02:00:00", 
"1988-09-25 02:00:00", "1989-03-26 02:00:00", "1989-09-24 02:00:00", 
"1990-03-25 02:00:00", "1990-09-30 02:00:00", "1991-03-31 02:00:00", 
"1991-09-29 02:00:00", "1993-03-28 01:00:00", "1993-09-26 01:00:00", 
"1994-03-27 01:00:00", "1994-09-25 01:00:00", "1995-03-26 01:00:00", 
"1995-09-24 01:00:00", "1996-03-31 01:00:00", "1996-10-27 01:00:00", 
"1997-03-30 01:00:00", "1997-10-26 01:00:00", "1998-03-29 01:00:00", 
"1998-10-25 01:00:00", "1999-03-28 01:00:00", "1999-10-31 01:00:00", 
"2000-03-26 01:00:00", "2000-10-29 01:00:00", "2001-03-25 01:00:00", 
"2001-10-28 01:00:00", "2002-03-31 01:00:00", "2002-10-27 01:00:00", 
"2003-03-30 01:00:00", "2003-10-26 01:00:00", "2004-03-28 01:00:00", 
"2004-10-31 01:00:00", "2005-03-27 01:00:00", "2005-10-30 01:00:00", 
"2006-03-26 01:00:00", "2006-10-29 01:00:00", "2007-03-25 01:00:00", 
"2007-10-28 01:00:00", "2008-03-30 01:00:00", "2008-10-26 01:00:00", 
"2009-03-29 01:00:00", "2009-10-25 01:00:00", "2010-03-28 01:00:00", 
"2010-10-31 01:00:00", "2011-03-27 01:00:00", "2011-10-30 01:00:00", 
"2012-03-25 01:00:00", "2012-10-28 01:00:00", "2013-03-31 01:00:00", 
"2013-10-27 01:00:00", "2014-03-30 01:00:00", "2014-10-26 01:00:00", 
"2015-03-29 01:00:00", "2015-10-25 01:00:00", "2016-03-27 01:00:00", 
"2016-10-30 01:00:00", "2017-03-26 01:00:00", "2017-10-29 01:00:00", 
"2018-03-25 01:00:00", "2018-10-28 01:00:00", "2019-03-31 01:00:00", 
"2019-10-27 01:00:00", "2020-03-29 01:00:00", "2020-10-25 01:00:00", 
"2021-03-28 01:00:00", "2021-10-31 01:00:00", "2022-03-27 01:00:00", 
"2022-10-30 01:00:00", "2023-03-26 01:00:00", "2023-10-29 01:00:00", 
"2024-03-31 01:00:00", "2024-10-27 01:00:00", "2025-03-30 01:00:00", 
"2025-10-26 01:00:00", "2026-03-29 01:00:00", "2026-10-25 01:00:00", 
"2027-03-28 01:00:00", "2027-10-31 01:00:00", "2028-03-26 01:00:00", 
"2028-10-29 01:00:00", "2029-03-25 01:00:00", "2029-10-28 01:00:00", 
"2030-03-31 01:00:00", "2030-10-27 01:00:00", "2031-03-30 01:00:00", 
"2031-10-26 01:00:00", "2032-03-28 01:00:00", "2032-10-31 01:00:00", 
"2033-03-27 01:00:00", "2033-10-30 01:00:00", "2034-03-26 01:00:00", 
"2034-10-29 01:00:00", "2035-03-25 01:00:00", "2035-10-28 01:00:00", 
"2036-03-30 01:00:00", "2036-10-26 01:00:00", "2037-03-29 01:00:00", 
"2037-10-25 01:00:00"), offSet = c(-6872L, -7200L, -3600L, -7200L, 
-3600L, -7200L, -3600L, -7200L, -3600L, -7200L, -3600L, -7200L, 
-3600L, -7200L, -3600L, -7200L, -3600L, -7200L, -3600L, -7200L, 
-3600L, -7200L, -3600L, -7200L, -3600L, -7200L, -3600L, -7200L, 
-3600L, -7200L, -3600L, -7200L, -3600L, -7200L, -3600L, -7200L, 
-3600L, -7200L, -3600L, -7200L, -3600L, -7200L, -3600L, -7200L, 
-3600L, 0L, -3600L, -7200L, -3600L, 0L, -3600L, -7200L, -3600L, 
0L, -3600L, -7200L, -3600L, 0L, -3600L, -7200L, -3600L, -7200L, 
-3600L, -7200L, -3600L, -7200L, -3600L, -7200L, -3600L, -7200L, 
-3600L, -7200L, -3600L, -7200L, -3600L, -7200L, -3600L, -7200L, 
-3600L, -7200L, -3600L, -7200L, -3600L, -7200L, -3600L, -7200L, 
-3600L, -7200L, -3600L, -7200L, -3600L, -7200L, -3600L, -7200L, 
-3600L, -7200L, -3600L, -7200L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L), isdst = c(0L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 1L, 0L, 1L, 1L, 1L, 0L, 
1L, 1L, 1L, 0L, 1L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("HMT", "AZOT", "AZOST", 
"AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
"AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
"AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
"AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
"AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
"AZOT", "AZOST", "AZOMT", "AZOST", "AZOT", "AZOST", "AZOMT", 
"AZOST", "AZOT", "AZOST", "AZOMT", "AZOST", "AZOT", "AZOST", 
"AZOMT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
"AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
"AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
"AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
"AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", 
"AZOT", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
"AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
"AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
"AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
"AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
"AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
"AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
"AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
"AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
"AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
"AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
"AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
"AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
"AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
"AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", "AZOST", "AZOT", 
"AZOST", "AZOT"), numeric = c(-2147397248, -1849557928, -1689548400, 
-1677794400, -1667430000, -1647730800, -1635807600, -1616194800, 
-1604358000, -1584658800, -1572735600, -1553036400, -1541199600, 
-1521500400, -1442444400, -1426806000, -1379286000, -1364770800, 
-1348441200, -1333321200, -1316386800, -1301266800, -1284332400, 
-1269817200, -1221433200, -1206918000, -1191193200, -1175468400, 
-1127689200, -1111964400, -1096844400, -1080514800, -1063580400, 
-1049065200, -1033340400, -1017615600, -1002495600, -986166000, 
-969231600, -950482800, -942015600, -922662000, -906937200, -891126000, 
-877302000, -873676800, -8.64e+08, -857948400, -845852400, -842832000, 
-831340800, -825894000, -814402800, -810777600, -799891200, -794444400, 
-782953200, -779328000, -768441600, -762994800, -749084400, -733359600, 
-717624000, -701899200, -686174400, -670449600, -654724800, -6.39e+08, 
-591825600, -575496000, -559771200, -544046400, -528321600, -512596800, 
-496872000, -481147200, -465422400, -449697600, -433972800, -417643200, 
-401918400, -386193600, -370468800, -354744000, -339019200, -323294400, 
-307569600, -291844800, -276120000, -260395200, -244670400, -228340800, 
-212616000, -196891200, -181166400, -165441600, -149716800, -133992000, 
-118267200, 228272400, 243997200, 260326800, 276051600, 291776400, 
307504800, 323226000, 338954400, 354679200, 370404000, 386128800, 
401853600, 417582000, 433303200, 449028000, 465357600, 481082400, 
496807200, 512532000, 528256800, 543981600, 559706400, 575431200, 
591156000, 606880800, 622605600, 638330400, 654660000, 670384800, 
686109600, 733280400, 749005200, 764730000, 780454800, 796179600, 
811904400, 828234000, 846378000, 859683600, 877827600, 891133200, 
909277200, 922582800, 941331600, 954032400, 972781200, 985482000, 
1004230800, 1017536400, 1035680400, 1048986000, 1067130000, 1080435600, 
1099184400, 1111885200, 1130634000, 1143334800, 1162083600, 1174784400, 
1193533200, 1206838800, 1224982800, 1238288400, 1256432400, 1269738000, 
1288486800, 1301187600, 1319936400, 1332637200, 1351386000, 1364691600, 
1382835600, 1396141200, 1414285200, 1427590800, 1445734800, 1459040400, 
1477789200, 1490490000, 1509238800, 1521939600, 1540688400, 1553994000, 
1572138000, 1585443600, 1603587600, 1616893200, 1635642000, 1648342800, 
1667091600, 1679792400, 1698541200, 1711846800, 1729990800, 1743296400, 
1761440400, 1774746000, 1792890000, 1806195600, 1824944400, 1837645200, 
1856394000, 1869094800, 1887843600, 1901149200, 1919293200, 1932598800, 
1950742800, 1964048400, 1982797200, 1995498000, 2014246800, 2026947600, 
2045696400, 2058397200, 2077146000, 2090451600, 2108595600, 2121901200, 
2140045200)), .Names = c("Azores", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -219L), class = "data.frame")
}

"Bermuda" <- function () {
structure(list(Bermuda = c("1901-12-14 20:45:52", "1930-01-01 06:19:04", 
"1974-04-28 06:00:00", "1974-10-27 05:00:00", "1975-04-27 06:00:00", 
"1975-10-26 05:00:00", "1976-04-25 06:00:00", "1976-10-31 05:00:00", 
"1977-04-24 06:00:00", "1977-10-30 05:00:00", "1978-04-30 06:00:00", 
"1978-10-29 05:00:00", "1979-04-29 06:00:00", "1979-10-28 05:00:00", 
"1980-04-27 06:00:00", "1980-10-26 05:00:00", "1981-04-26 06:00:00", 
"1981-10-25 05:00:00", "1982-04-25 06:00:00", "1982-10-31 05:00:00", 
"1983-04-24 06:00:00", "1983-10-30 05:00:00", "1984-04-29 06:00:00", 
"1984-10-28 05:00:00", "1985-04-28 06:00:00", "1985-10-27 05:00:00", 
"1986-04-27 06:00:00", "1986-10-26 05:00:00", "1987-04-05 06:00:00", 
"1987-10-25 05:00:00", "1988-04-03 06:00:00", "1988-10-30 05:00:00", 
"1989-04-02 06:00:00", "1989-10-29 05:00:00", "1990-04-01 06:00:00", 
"1990-10-28 05:00:00", "1991-04-07 06:00:00", "1991-10-27 05:00:00", 
"1992-04-05 06:00:00", "1992-10-25 05:00:00", "1993-04-04 06:00:00", 
"1993-10-31 05:00:00", "1994-04-03 06:00:00", "1994-10-30 05:00:00", 
"1995-04-02 06:00:00", "1995-10-29 05:00:00", "1996-04-07 06:00:00", 
"1996-10-27 05:00:00", "1997-04-06 06:00:00", "1997-10-26 05:00:00", 
"1998-04-05 06:00:00", "1998-10-25 05:00:00", "1999-04-04 06:00:00", 
"1999-10-31 05:00:00", "2000-04-02 06:00:00", "2000-10-29 05:00:00", 
"2001-04-01 06:00:00", "2001-10-28 05:00:00", "2002-04-07 06:00:00", 
"2002-10-27 05:00:00", "2003-04-06 06:00:00", "2003-10-26 05:00:00", 
"2004-04-04 06:00:00", "2004-10-31 05:00:00", "2005-04-03 06:00:00", 
"2005-10-30 05:00:00", "2006-04-02 06:00:00", "2006-10-29 05:00:00", 
"2007-03-11 06:00:00", "2007-11-04 05:00:00", "2008-03-09 06:00:00", 
"2008-11-02 05:00:00", "2009-03-08 06:00:00", "2009-11-01 05:00:00", 
"2010-03-14 06:00:00", "2010-11-07 05:00:00", "2011-03-13 06:00:00", 
"2011-11-06 05:00:00", "2012-03-11 06:00:00", "2012-11-04 05:00:00", 
"2013-03-10 06:00:00", "2013-11-03 05:00:00", "2014-03-09 06:00:00", 
"2014-11-02 05:00:00", "2015-03-08 06:00:00", "2015-11-01 05:00:00", 
"2016-03-13 06:00:00", "2016-11-06 05:00:00", "2017-03-12 06:00:00", 
"2017-11-05 05:00:00", "2018-03-11 06:00:00", "2018-11-04 05:00:00", 
"2019-03-10 06:00:00", "2019-11-03 05:00:00", "2020-03-08 06:00:00", 
"2020-11-01 05:00:00", "2021-03-14 06:00:00", "2021-11-07 05:00:00", 
"2022-03-13 06:00:00", "2022-11-06 05:00:00", "2023-03-12 06:00:00", 
"2023-11-05 05:00:00", "2024-03-10 06:00:00", "2024-11-03 05:00:00", 
"2025-03-09 06:00:00", "2025-11-02 05:00:00", "2026-03-08 06:00:00", 
"2026-11-01 05:00:00", "2027-03-14 06:00:00", "2027-11-07 05:00:00", 
"2028-03-12 06:00:00", "2028-11-05 05:00:00", "2029-03-11 06:00:00", 
"2029-11-04 05:00:00", "2030-03-10 06:00:00", "2030-11-03 05:00:00", 
"2031-03-09 06:00:00", "2031-11-02 05:00:00", "2032-03-14 06:00:00", 
"2032-11-07 05:00:00", "2033-03-13 06:00:00", "2033-11-06 05:00:00", 
"2034-03-12 06:00:00", "2034-11-05 05:00:00", "2035-03-11 06:00:00", 
"2035-11-04 05:00:00", "2036-03-09 06:00:00", "2036-11-02 05:00:00", 
"2037-03-08 06:00:00", "2037-11-01 05:00:00"), offSet = c(-15544L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", 
"ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", "AST", "ADT", 
"AST", "ADT", "AST"), numeric = c(-2147397248, -1262281256, 136360800, 
152082000, 167810400, 183531600, 199260000, 215586000, 230709600, 
247035600, 262764000, 278485200, 294213600, 309934800, 325663200, 
341384400, 357112800, 372834000, 388562400, 404888400, 420012000, 
436338000, 452066400, 467787600, 483516000, 499237200, 514965600, 
530686800, 544600800, 562136400, 576050400, 594190800, 607500000, 
625640400, 638949600, 657090000, 671004000, 688539600, 702453600, 
719989200, 733903200, 752043600, 765352800, 783493200, 796802400, 
814942800, 828856800, 846392400, 860306400, 877842000, 891756000, 
909291600, 923205600, 941346000, 954655200, 972795600, 986104800, 
1004245200, 1018159200, 1035694800, 1049608800, 1067144400, 1081058400, 
1099198800, 1112508000, 1130648400, 1143957600, 1162098000, 1173592800, 
1194152400, 1205042400, 1225602000, 1236492000, 1257051600, 1268546400, 
1289106000, 1299996000, 1320555600, 1331445600, 1352005200, 1362895200, 
1383454800, 1394344800, 1414904400, 1425794400, 1446354000, 1457848800, 
1478408400, 1489298400, 1509858000, 1520748000, 1541307600, 1552197600, 
1572757200, 1583647200, 1604206800, 1615701600, 1636261200, 1647151200, 
1667710800, 1678600800, 1699160400, 1710050400, 1730610000, 1741500000, 
1762059600, 1772949600, 1793509200, 1805004000, 1825563600, 1836453600, 
1857013200, 1867903200, 1888462800, 1899352800, 1919912400, 1930802400, 
1951362000, 1962856800, 1983416400, 1994306400, 2014866000, 2025756000, 
2046315600, 2057205600, 2077765200, 2088655200, 2109214800, 2120104800, 
2140664400)), .Names = c("Bermuda", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -130L), class = "data.frame")
}

"Canary" <- function () {
structure(list(Canary = c("1901-12-14 20:45:52", "1922-03-01 01:01:36", 
"1946-09-30 02:00:00", "1980-04-06 00:00:00", "1980-09-28 01:00:00", 
"1981-03-29 01:00:00", "1981-09-27 01:00:00", "1982-03-28 01:00:00", 
"1982-09-26 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00", "2037-10-25 01:00:00"
), offSet = c(-3696L, -3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L), isdst = c(0L, 0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("LMT", 
"CANT", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET"), numeric = c(-2147397248, -1509663504, -733874400, 323827200, 
338950800, 354675600, 370400400, 386125200, 401850000, 417574800, 
433299600, 449024400, 465354000, 481078800, 496803600, 512528400, 
528253200, 543978000, 559702800, 575427600, 591152400, 606877200, 
622602000, 638326800, 654656400, 670381200, 686106000, 701830800, 
717555600, 733280400, 749005200, 764730000, 780454800, 796179600, 
811904400, 828234000, 846378000, 859683600, 877827600, 891133200, 
909277200, 922582800, 941331600, 954032400, 972781200, 985482000, 
1004230800, 1017536400, 1035680400, 1048986000, 1067130000, 1080435600, 
1099184400, 1111885200, 1130634000, 1143334800, 1162083600, 1174784400, 
1193533200, 1206838800, 1224982800, 1238288400, 1256432400, 1269738000, 
1288486800, 1301187600, 1319936400, 1332637200, 1351386000, 1364691600, 
1382835600, 1396141200, 1414285200, 1427590800, 1445734800, 1459040400, 
1477789200, 1490490000, 1509238800, 1521939600, 1540688400, 1553994000, 
1572138000, 1585443600, 1603587600, 1616893200, 1635642000, 1648342800, 
1667091600, 1679792400, 1698541200, 1711846800, 1729990800, 1743296400, 
1761440400, 1774746000, 1792890000, 1806195600, 1824944400, 1837645200, 
1856394000, 1869094800, 1887843600, 1901149200, 1919293200, 1932598800, 
1950742800, 1964048400, 1982797200, 1995498000, 2014246800, 2026947600, 
2045696400, 2058397200, 2077146000, 2090451600, 2108595600, 2121901200, 
2140045200)), .Names = c("Canary", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -119L), class = "data.frame")
}

"Cape_Verde" <- function () {
structure(list(Cape_Verde = c("1901-12-14 20:45:52", "1907-01-01 01:34:04", 
"1942-09-01 02:00:00", "1945-10-15 01:00:00", "1975-11-25 04:00:00"
), offSet = c(-5644L, -7200L, -3600L, -7200L, -3600L), isdst = c(0L, 
0L, 1L, 0L, 0L), TimeZone = c("LMT", "CVT", "CVST", "CVT", "CVT"
), numeric = c(-2147397248, -1988144756, -862610400, -764118000, 
186120000)), .Names = c("Cape_Verde", "offSet", "isdst", "TimeZone", 
"numeric"), row.names = c(NA, -5L), class = "data.frame")
}

"Faroe" <- function () {
structure(list(Faroe = c("1901-12-14 20:45:52", "1908-01-11 00:27:04", 
"1981-03-29 01:00:00", "1981-09-27 01:00:00", "1982-03-28 01:00:00", 
"1982-09-26 01:00:00", "1983-03-27 01:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00", "2037-10-25 01:00:00"
), offSet = c(-1624L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L), isdst = c(0L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L), TimeZone = c("LMT", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET"), numeric = c(-2147397248, -1955748776, 
354675600, 370400400, 386125200, 401850000, 417574800, 433299600, 
449024400, 465354000, 481078800, 496803600, 512528400, 528253200, 
543978000, 559702800, 575427600, 591152400, 606877200, 622602000, 
638326800, 654656400, 670381200, 686106000, 701830800, 717555600, 
733280400, 749005200, 764730000, 780454800, 796179600, 811904400, 
828234000, 846378000, 859683600, 877827600, 891133200, 909277200, 
922582800, 941331600, 954032400, 972781200, 985482000, 1004230800, 
1017536400, 1035680400, 1048986000, 1067130000, 1080435600, 1099184400, 
1111885200, 1130634000, 1143334800, 1162083600, 1174784400, 1193533200, 
1206838800, 1224982800, 1238288400, 1256432400, 1269738000, 1288486800, 
1301187600, 1319936400, 1332637200, 1351386000, 1364691600, 1382835600, 
1396141200, 1414285200, 1427590800, 1445734800, 1459040400, 1477789200, 
1490490000, 1509238800, 1521939600, 1540688400, 1553994000, 1572138000, 
1585443600, 1603587600, 1616893200, 1635642000, 1648342800, 1667091600, 
1679792400, 1698541200, 1711846800, 1729990800, 1743296400, 1761440400, 
1774746000, 1792890000, 1806195600, 1824944400, 1837645200, 1856394000, 
1869094800, 1887843600, 1901149200, 1919293200, 1932598800, 1950742800, 
1964048400, 1982797200, 1995498000, 2014246800, 2026947600, 2045696400, 
2058397200, 2077146000, 2090451600, 2108595600, 2121901200, 2140045200
)), .Names = c("Faroe", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -116L), class = "data.frame")
}

"Madeira" <- function () {
structure(list(Madeira = c("1901-12-14 20:45:52", "1911-05-24 01:07:36", 
"1916-06-18 00:00:00", "1916-11-01 01:00:00", "1917-03-01 00:00:00", 
"1917-10-15 00:00:00", "1918-03-02 00:00:00", "1918-10-15 00:00:00", 
"1919-03-01 00:00:00", "1919-10-15 00:00:00", "1920-03-01 00:00:00", 
"1920-10-15 00:00:00", "1921-03-01 00:00:00", "1921-10-15 00:00:00", 
"1924-04-17 00:00:00", "1924-10-15 00:00:00", "1926-04-18 00:00:00", 
"1926-10-03 00:00:00", "1927-04-10 00:00:00", "1927-10-02 00:00:00", 
"1928-04-15 00:00:00", "1928-10-07 00:00:00", "1929-04-21 00:00:00", 
"1929-10-06 00:00:00", "1931-04-19 00:00:00", "1931-10-04 00:00:00", 
"1932-04-03 00:00:00", "1932-10-02 00:00:00", "1934-04-08 00:00:00", 
"1934-10-07 00:00:00", "1935-03-31 00:00:00", "1935-10-06 00:00:00", 
"1936-04-19 00:00:00", "1936-10-04 00:00:00", "1937-04-04 00:00:00", 
"1937-10-03 00:00:00", "1938-03-27 00:00:00", "1938-10-02 00:00:00", 
"1939-04-16 00:00:00", "1939-11-19 00:00:00", "1940-02-25 00:00:00", 
"1940-10-06 00:00:00", "1941-04-06 00:00:00", "1941-10-06 00:00:00", 
"1942-03-15 00:00:00", "1942-04-25 23:00:00", "1942-08-15 23:00:00", 
"1942-10-25 00:00:00", "1943-03-14 00:00:00", "1943-04-17 23:00:00", 
"1943-08-28 23:00:00", "1943-10-31 00:00:00", "1944-03-12 00:00:00", 
"1944-04-22 23:00:00", "1944-08-26 23:00:00", "1944-10-29 00:00:00", 
"1945-03-11 00:00:00", "1945-04-21 23:00:00", "1945-08-25 23:00:00", 
"1945-10-28 00:00:00", "1946-04-07 00:00:00", "1946-10-06 00:00:00", 
"1947-04-06 03:00:00", "1947-10-05 03:00:00", "1948-04-04 03:00:00", 
"1948-10-03 03:00:00", "1949-04-03 03:00:00", "1949-10-02 03:00:00", 
"1951-04-01 03:00:00", "1951-10-07 03:00:00", "1952-04-06 03:00:00", 
"1952-10-05 03:00:00", "1953-04-05 03:00:00", "1953-10-04 03:00:00", 
"1954-04-04 03:00:00", "1954-10-03 03:00:00", "1955-04-03 03:00:00", 
"1955-10-02 03:00:00", "1956-04-01 03:00:00", "1956-10-07 03:00:00", 
"1957-04-07 03:00:00", "1957-10-06 03:00:00", "1958-04-06 03:00:00", 
"1958-10-05 03:00:00", "1959-04-05 03:00:00", "1959-10-04 03:00:00", 
"1960-04-03 03:00:00", "1960-10-02 03:00:00", "1961-04-02 03:00:00", 
"1961-10-01 03:00:00", "1962-04-01 03:00:00", "1962-10-07 03:00:00", 
"1963-04-07 03:00:00", "1963-10-06 03:00:00", "1964-04-05 03:00:00", 
"1964-10-04 03:00:00", "1965-04-04 03:00:00", "1965-10-03 03:00:00", 
"1966-04-03 03:00:00", "1977-03-27 00:00:00", "1977-09-25 00:00:00", 
"1978-04-02 00:00:00", "1978-10-01 00:00:00", "1979-04-01 00:00:00", 
"1979-09-30 01:00:00", "1980-03-30 00:00:00", "1980-09-28 01:00:00", 
"1981-03-29 01:00:00", "1981-09-27 01:00:00", "1982-03-28 01:00:00", 
"1982-09-26 01:00:00", "1983-03-27 02:00:00", "1983-09-25 01:00:00", 
"1984-03-25 01:00:00", "1984-09-30 01:00:00", "1985-03-31 01:00:00", 
"1985-09-29 01:00:00", "1986-03-30 01:00:00", "1986-09-28 01:00:00", 
"1987-03-29 01:00:00", "1987-09-27 01:00:00", "1988-03-27 01:00:00", 
"1988-09-25 01:00:00", "1989-03-26 01:00:00", "1989-09-24 01:00:00", 
"1990-03-25 01:00:00", "1990-09-30 01:00:00", "1991-03-31 01:00:00", 
"1991-09-29 01:00:00", "1992-03-29 01:00:00", "1992-09-27 01:00:00", 
"1993-03-28 01:00:00", "1993-09-26 01:00:00", "1994-03-27 01:00:00", 
"1994-09-25 01:00:00", "1995-03-26 01:00:00", "1995-09-24 01:00:00", 
"1996-03-31 01:00:00", "1996-10-27 01:00:00", "1997-03-30 01:00:00", 
"1997-10-26 01:00:00", "1998-03-29 01:00:00", "1998-10-25 01:00:00", 
"1999-03-28 01:00:00", "1999-10-31 01:00:00", "2000-03-26 01:00:00", 
"2000-10-29 01:00:00", "2001-03-25 01:00:00", "2001-10-28 01:00:00", 
"2002-03-31 01:00:00", "2002-10-27 01:00:00", "2003-03-30 01:00:00", 
"2003-10-26 01:00:00", "2004-03-28 01:00:00", "2004-10-31 01:00:00", 
"2005-03-27 01:00:00", "2005-10-30 01:00:00", "2006-03-26 01:00:00", 
"2006-10-29 01:00:00", "2007-03-25 01:00:00", "2007-10-28 01:00:00", 
"2008-03-30 01:00:00", "2008-10-26 01:00:00", "2009-03-29 01:00:00", 
"2009-10-25 01:00:00", "2010-03-28 01:00:00", "2010-10-31 01:00:00", 
"2011-03-27 01:00:00", "2011-10-30 01:00:00", "2012-03-25 01:00:00", 
"2012-10-28 01:00:00", "2013-03-31 01:00:00", "2013-10-27 01:00:00", 
"2014-03-30 01:00:00", "2014-10-26 01:00:00", "2015-03-29 01:00:00", 
"2015-10-25 01:00:00", "2016-03-27 01:00:00", "2016-10-30 01:00:00", 
"2017-03-26 01:00:00", "2017-10-29 01:00:00", "2018-03-25 01:00:00", 
"2018-10-28 01:00:00", "2019-03-31 01:00:00", "2019-10-27 01:00:00", 
"2020-03-29 01:00:00", "2020-10-25 01:00:00", "2021-03-28 01:00:00", 
"2021-10-31 01:00:00", "2022-03-27 01:00:00", "2022-10-30 01:00:00", 
"2023-03-26 01:00:00", "2023-10-29 01:00:00", "2024-03-31 01:00:00", 
"2024-10-27 01:00:00", "2025-03-30 01:00:00", "2025-10-26 01:00:00", 
"2026-03-29 01:00:00", "2026-10-25 01:00:00", "2027-03-28 01:00:00", 
"2027-10-31 01:00:00", "2028-03-26 01:00:00", "2028-10-29 01:00:00", 
"2029-03-25 01:00:00", "2029-10-28 01:00:00", "2030-03-31 01:00:00", 
"2030-10-27 01:00:00", "2031-03-30 01:00:00", "2031-10-26 01:00:00", 
"2032-03-28 01:00:00", "2032-10-31 01:00:00", "2033-03-27 01:00:00", 
"2033-10-30 01:00:00", "2034-03-26 01:00:00", "2034-10-29 01:00:00", 
"2035-03-25 01:00:00", "2035-10-28 01:00:00", "2036-03-30 01:00:00", 
"2036-10-26 01:00:00", "2037-03-29 01:00:00", "2037-10-25 01:00:00"
), offSet = c(-4056L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L, -3600L, 0L, 3600L, 0L, -3600L, 0L, 3600L, 0L, -3600L, 
0L, 3600L, 0L, -3600L, 0L, 3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 0L, 3600L, 
0L, 3600L, 0L, 3600L, 0L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 1L, 1L, 0L, 1L, 1L, 1L, 0L, 1L, 1L, 
1L, 0L, 1L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L), TimeZone = c("FMT", "MADT", "MADST", 
"MADT", "MADST", "MADT", "MADST", "MADT", "MADST", "MADT", "MADST", 
"MADT", "MADST", "MADT", "MADST", "MADT", "MADST", "MADT", "MADST", 
"MADT", "MADST", "MADT", "MADST", "MADT", "MADST", "MADT", "MADST", 
"MADT", "MADST", "MADT", "MADST", "MADT", "MADST", "MADT", "MADST", 
"MADT", "MADST", "MADT", "MADST", "MADT", "MADST", "MADT", "MADST", 
"MADT", "MADST", "MADMT", "MADST", "MADT", "MADST", "MADMT", 
"MADST", "MADT", "MADST", "MADMT", "MADST", "MADT", "MADST", 
"MADMT", "MADST", "MADT", "MADST", "MADT", "MADST", "MADT", "MADST", 
"MADT", "MADST", "MADT", "MADST", "MADT", "MADST", "MADT", "MADST", 
"MADT", "MADST", "MADT", "MADST", "MADT", "MADST", "MADT", "MADST", 
"MADT", "MADST", "MADT", "MADST", "MADT", "MADST", "MADT", "MADST", 
"MADT", "MADST", "MADT", "MADST", "MADT", "MADST", "MADT", "MADST", 
"MADT", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", 
"WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", "WET", "WEST", 
"WET", "WEST", "WET", "WEST", "WET", "WEST", "WET"), numeric = c(-2147397248, 
-1849560744, -1689552000, -1677798000, -1667433600, -1647734400, 
-1635811200, -1616198400, -1604361600, -1584662400, -1572739200, 
-1553040000, -1541203200, -1521504000, -1442448000, -1426809600, 
-1379289600, -1364774400, -1348444800, -1333324800, -1316390400, 
-1301270400, -1284336000, -1269820800, -1221436800, -1206921600, 
-1191196800, -1175472000, -1127692800, -1111968000, -1096848000, 
-1080518400, -1063584000, -1049068800, -1033344000, -1017619200, 
-1002499200, -986169600, -969235200, -950486400, -942019200, 
-922665600, -906940800, -891129600, -877305600, -873680400, -864003600, 
-857952000, -845856000, -842835600, -831344400, -825897600, -814406400, 
-810781200, -799894800, -794448000, -782956800, -779331600, -768445200, 
-762998400, -749088000, -733363200, -717627600, -701902800, -686178000, 
-670453200, -654728400, -639003600, -591829200, -575499600, -559774800, 
-544050000, -528325200, -512600400, -496875600, -481150800, -465426000, 
-449701200, -433976400, -417646800, -401922000, -386197200, -370472400, 
-354747600, -339022800, -323298000, -307573200, -291848400, -276123600, 
-260398800, -244674000, -228344400, -212619600, -196894800, -181170000, 
-165445200, -149720400, -133995600, -118270800, 228268800, 243993600, 
260323200, 276048000, 291772800, 307501200, 323222400, 338950800, 
354675600, 370400400, 386125200, 401850000, 417578400, 433299600, 
449024400, 465354000, 481078800, 496803600, 512528400, 528253200, 
543978000, 559702800, 575427600, 591152400, 606877200, 622602000, 
638326800, 654656400, 670381200, 686106000, 701830800, 717555600, 
733280400, 749005200, 764730000, 780454800, 796179600, 811904400, 
828234000, 846378000, 859683600, 877827600, 891133200, 909277200, 
922582800, 941331600, 954032400, 972781200, 985482000, 1004230800, 
1017536400, 1035680400, 1048986000, 1067130000, 1080435600, 1099184400, 
1111885200, 1130634000, 1143334800, 1162083600, 1174784400, 1193533200, 
1206838800, 1224982800, 1238288400, 1256432400, 1269738000, 1288486800, 
1301187600, 1319936400, 1332637200, 1351386000, 1364691600, 1382835600, 
1396141200, 1414285200, 1427590800, 1445734800, 1459040400, 1477789200, 
1490490000, 1509238800, 1521939600, 1540688400, 1553994000, 1572138000, 
1585443600, 1603587600, 1616893200, 1635642000, 1648342800, 1667091600, 
1679792400, 1698541200, 1711846800, 1729990800, 1743296400, 1761440400, 
1774746000, 1792890000, 1806195600, 1824944400, 1837645200, 1856394000, 
1869094800, 1887843600, 1901149200, 1919293200, 1932598800, 1950742800, 
1964048400, 1982797200, 1995498000, 2014246800, 2026947600, 2045696400, 
2058397200, 2077146000, 2090451600, 2108595600, 2121901200, 2140045200
)), .Names = c("Madeira", "offSet", "isdst", "TimeZone", "numeric"
), row.names = c(NA, -221L), class = "data.frame")
}

"Reykjavik" <- function () {
structure(list(Reykjavik = c("1901-12-14 20:45:52", "1908-01-01 01:27:48", 
"1917-02-20 00:00:00", "1917-10-21 01:00:00", "1918-02-20 00:00:00", 
"1918-11-16 01:00:00", "1939-04-30 00:00:00", "1939-11-29 02:00:00", 
"1940-02-25 03:00:00", "1940-11-03 02:00:00", "1941-03-02 02:00:00", 
"1941-11-02 02:00:00", "1942-03-08 02:00:00", "1942-10-25 02:00:00", 
"1943-03-07 02:00:00", "1943-10-24 02:00:00", "1944-03-05 02:00:00", 
"1944-10-22 02:00:00", "1945-03-04 02:00:00", "1945-10-28 02:00:00", 
"1946-03-03 02:00:00", "1946-10-27 02:00:00", "1947-04-06 02:00:00", 
"1947-10-26 02:00:00", "1948-04-04 02:00:00", "1948-10-24 02:00:00", 
"1949-04-03 02:00:00", "1949-10-30 02:00:00", "1950-04-02 02:00:00", 
"1950-10-22 02:00:00", "1951-04-01 02:00:00", "1951-10-28 02:00:00", 
"1952-04-06 02:00:00", "1952-10-26 02:00:00", "1953-04-05 02:00:00", 
"1953-10-25 02:00:00", "1954-04-04 02:00:00", "1954-10-24 02:00:00", 
"1955-04-03 02:00:00", "1955-10-23 02:00:00", "1956-04-01 02:00:00", 
"1956-10-28 02:00:00", "1957-04-07 02:00:00", "1957-10-27 02:00:00", 
"1958-04-06 02:00:00", "1958-10-26 02:00:00", "1959-04-05 02:00:00", 
"1959-10-25 02:00:00", "1960-04-03 02:00:00", "1960-10-23 02:00:00", 
"1961-04-02 02:00:00", "1961-10-22 02:00:00", "1962-04-01 02:00:00", 
"1962-10-28 02:00:00", "1963-04-07 02:00:00", "1963-10-27 02:00:00", 
"1964-04-05 02:00:00", "1964-10-25 02:00:00", "1965-04-04 02:00:00", 
"1965-10-24 02:00:00", "1966-04-03 02:00:00", "1966-10-23 02:00:00", 
"1967-04-02 02:00:00", "1967-10-29 02:00:00", "1968-04-07 02:00:00"
), offSet = c(-5268L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 
0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, -3600L, 0L, 
-3600L, 0L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 
1L, 0L, 1L, 0L, 1L, 0L, 0L), TimeZone = c("RMT", "IST", "ISST", 
"IST", "ISST", "IST", "ISST", "IST", "ISST", "IST", "ISST", "IST", 
"ISST", "IST", "ISST", "IST", "ISST", "IST", "ISST", "IST", "ISST", 
"IST", "ISST", "IST", "ISST", "IST", "ISST", "IST", "ISST", "IST", 
"ISST", "IST", "ISST", "IST", "ISST", "IST", "ISST", "IST", "ISST", 
"IST", "ISST", "IST", "ISST", "IST", "ISST", "IST", "ISST", "IST", 
"ISST", "IST", "ISST", "IST", "ISST", "IST", "ISST", "IST", "ISST", 
"IST", "ISST", "IST", "ISST", "IST", "ISST", "IST", "GMT"), numeric = c(-2147397248, 
-1956609132, -1668211200, -1647212400, -1636675200, -1613430000, 
-968025600, -949615200, -942008400, -920239200, -909957600, -888789600, 
-877903200, -857944800, -846453600, -826495200, -815004000, -795045600, 
-783554400, -762991200, -752104800, -731541600, -717631200, -700092000, 
-686181600, -668642400, -654732000, -636588000, -623282400, -605743200, 
-591832800, -573688800, -559778400, -542239200, -528328800, -510789600, 
-496879200, -479340000, -465429600, -447890400, -433980000, -415836000, 
-401925600, -384386400, -370476000, -352936800, -339026400, -321487200, 
-307576800, -290037600, -276127200, -258588000, -244677600, -226533600, 
-212623200, -195084000, -181173600, -163634400, -149724000, -132184800, 
-118274400, -100735200, -86824800, -68680800, -54770400)), .Names = c("Reykjavik", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-65L), class = "data.frame")
}

"South_Georgia" <- function () {
structure(list(South_Georgia = "1901-12-14 20:45:52", offSet = -7200L, 
    isdst = 0L, TimeZone = "GST", numeric = -2147397248), .Names = c("South_Georgia", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-1L), class = "data.frame")
}

"Stanley" <- function () {
structure(list(Stanley = c("1901-12-14 20:45:52", "1912-03-12 03:51:24", 
"1937-09-26 04:00:00", "1938-03-20 03:00:00", "1938-09-25 04:00:00", 
"1939-03-19 03:00:00", "1939-10-01 04:00:00", "1940-03-24 03:00:00", 
"1940-09-29 04:00:00", "1941-03-23 03:00:00", "1941-09-28 04:00:00", 
"1942-03-22 03:00:00", "1942-09-27 04:00:00", "1943-01-01 03:00:00", 
"1983-05-01 04:00:00", "1983-09-25 03:00:00", "1984-04-29 02:00:00", 
"1984-09-16 03:00:00", "1985-09-15 03:00:00", "1986-04-20 03:00:00", 
"1986-09-14 04:00:00", "1987-04-19 03:00:00", "1987-09-13 04:00:00", 
"1988-04-17 03:00:00", "1988-09-11 04:00:00", "1989-04-16 03:00:00", 
"1989-09-10 04:00:00", "1990-04-22 03:00:00", "1990-09-09 04:00:00", 
"1991-04-21 03:00:00", "1991-09-15 04:00:00", "1992-04-19 03:00:00", 
"1992-09-13 04:00:00", "1993-04-18 03:00:00", "1993-09-12 04:00:00", 
"1994-04-17 03:00:00", "1994-09-11 04:00:00", "1995-04-16 03:00:00", 
"1995-09-10 04:00:00", "1996-04-21 03:00:00", "1996-09-15 04:00:00", 
"1997-04-20 03:00:00", "1997-09-14 04:00:00", "1998-04-19 03:00:00", 
"1998-09-13 04:00:00", "1999-04-18 03:00:00", "1999-09-12 04:00:00", 
"2000-04-16 03:00:00", "2000-09-10 04:00:00", "2001-04-15 05:00:00", 
"2001-09-02 06:00:00", "2002-04-21 05:00:00", "2002-09-01 06:00:00", 
"2003-04-20 05:00:00", "2003-09-07 06:00:00", "2004-04-18 05:00:00", 
"2004-09-05 06:00:00", "2005-04-17 05:00:00", "2005-09-04 06:00:00", 
"2006-04-16 05:00:00", "2006-09-03 06:00:00", "2007-04-15 05:00:00", 
"2007-09-02 06:00:00", "2008-04-20 05:00:00", "2008-09-07 06:00:00", 
"2009-04-19 05:00:00", "2009-09-06 06:00:00", "2010-04-18 05:00:00", 
"2010-09-05 06:00:00", "2011-04-17 05:00:00", "2011-09-04 06:00:00", 
"2012-04-15 05:00:00", "2012-09-02 06:00:00", "2013-04-21 05:00:00", 
"2013-09-01 06:00:00", "2014-04-20 05:00:00", "2014-09-07 06:00:00", 
"2015-04-19 05:00:00", "2015-09-06 06:00:00", "2016-04-17 05:00:00", 
"2016-09-04 06:00:00", "2017-04-16 05:00:00", "2017-09-03 06:00:00", 
"2018-04-15 05:00:00", "2018-09-02 06:00:00", "2019-04-21 05:00:00", 
"2019-09-01 06:00:00", "2020-04-19 05:00:00", "2020-09-06 06:00:00", 
"2021-04-18 05:00:00", "2021-09-05 06:00:00", "2022-04-17 05:00:00", 
"2022-09-04 06:00:00", "2023-04-16 05:00:00", "2023-09-03 06:00:00", 
"2024-04-21 05:00:00", "2024-09-01 06:00:00", "2025-04-20 05:00:00", 
"2025-09-07 06:00:00", "2026-04-19 05:00:00", "2026-09-06 06:00:00", 
"2027-04-18 05:00:00", "2027-09-05 06:00:00", "2028-04-16 05:00:00", 
"2028-09-03 06:00:00", "2029-04-15 05:00:00", "2029-09-02 06:00:00", 
"2030-04-21 05:00:00", "2030-09-01 06:00:00", "2031-04-20 05:00:00", 
"2031-09-07 06:00:00", "2032-04-18 05:00:00", "2032-09-05 06:00:00", 
"2033-04-17 05:00:00", "2033-09-04 06:00:00", "2034-04-16 05:00:00", 
"2034-09-03 06:00:00", "2035-04-15 05:00:00", "2035-09-02 06:00:00", 
"2036-04-20 05:00:00", "2036-09-07 06:00:00", "2037-04-19 05:00:00", 
"2037-09-06 06:00:00"), offSet = c(-13884L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -7200L, -10800L, 
-7200L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L, -14400L, -10800L, -14400L, -10800L, -14400L, -10800L, 
-14400L, -10800L, -14400L, -10800L, -14400L, -10800L, -14400L, 
-10800L), isdst = c(0L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 0L, 1L, 0L, 1L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 
0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L
), TimeZone = c("SMT", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", 
"FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKT", "FKST", 
"FKT", "FKST", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", 
"FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", 
"FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", 
"FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", 
"FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", 
"FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", 
"FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", 
"FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", 
"FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", 
"FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", 
"FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST", 
"FKT", "FKST", "FKT", "FKST", "FKT", "FKST", "FKT", "FKST"), 
    numeric = c(-2147397248, -1824235716, -1018209600, -1003093200, 
    -986760000, -971643600, -954705600, -939589200, -923256000, 
    -908139600, -891806400, -876690000, -860356800, -852066000, 
    420609600, 433306800, 452052000, 464151600, 495601200, 514350000, 
    527054400, 545799600, 558504000, 577249200, 589953600, 608698800, 
    621403200, 640753200, 652852800, 672202800, 684907200, 703652400, 
    716356800, 735102000, 747806400, 766551600, 779256000, 798001200, 
    810705600, 830055600, 842760000, 861505200, 874209600, 892954800, 
    905659200, 924404400, 937108800, 955854000, 968558400, 987310800, 
    999410400, 1019365200, 1030860000, 1050814800, 1062914400, 
    1082264400, 1094364000, 1113714000, 1125813600, 1145163600, 
    1157263200, 1176613200, 1188712800, 1208667600, 1220767200, 
    1240117200, 1252216800, 1271566800, 1283666400, 1303016400, 
    1315116000, 1334466000, 1346565600, 1366520400, 1378015200, 
    1397970000, 1410069600, 1429419600, 1441519200, 1460869200, 
    1472968800, 1492318800, 1504418400, 1523768400, 1535868000, 
    1555822800, 1567317600, 1587272400, 1599372000, 1618722000, 
    1630821600, 1650171600, 1662271200, 1681621200, 1693720800, 
    1713675600, 1725170400, 1745125200, 1757224800, 1776574800, 
    1788674400, 1808024400, 1820124000, 1839474000, 1851573600, 
    1870923600, 1883023200, 1902978000, 1914472800, 1934427600, 
    1946527200, 1965877200, 1977976800, 1997326800, 2009426400, 
    2028776400, 2040876000, 2060226000, 2072325600, 2092280400, 
    2104380000, 2123730000, 2135829600)), .Names = c("Stanley", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-123L), class = "data.frame")
}

"St_Helena" <- function () {
structure(list(St_Helena = c("1901-12-14 20:45:52", "1951-01-01 00:22:48"
), offSet = c(-1368L, 0L), isdst = c(0L, 0L), TimeZone = c("JMT", 
"GMT"), numeric = c(-2147397248, -599614632)), .Names = c("St_Helena", 
"offSet", "isdst", "TimeZone", "numeric"), row.names = c(NA, 
-2L), class = "data.frame")
}

"Adelaide" <- function ()