% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_as_tbl.R
\name{ts_as_tbl}
\alias{ts_as_tbl}
\alias{ts_as_tbl.default}
\alias{ts_as_tbl.mts}
\alias{ts_as_tbl.xts}
\alias{ts_as_tbl.zoo}
\alias{ts_as_tbl.timeSeries}
\title{Turn \code{ts} into a \code{tibble}}
\usage{
ts_as_tbl(x, name = "time", value = "value", group = "group")

\method{ts_as_tbl}{default}(x, name = "time", value = "value", group = "group")

\method{ts_as_tbl}{mts}(x, name = "time", value = "value", group = "group")

\method{ts_as_tbl}{xts}(x, name = "time", value = "value", group = "group")

\method{ts_as_tbl}{zoo}(x, name = "time", value = "value", group = "group")

\method{ts_as_tbl}{timeSeries}(x, name = "time", value = "value", group = "group")
}
\arguments{
\item{x}{An object of class \code{ts}, \code{mts}, \code{zoo}, \code{xts} or \code{timeSeries}.}

\item{name}{Name of the output time column.}

\item{value}{Name of the output value column.}

\item{group}{Name of the output group column
when there are multiple series.}
}
\value{
A 2-column \code{tibble} containing the time index and values for each
time index. In the case where there are multiple series, this becomes
a 3-column \code{tibble} with an additional "group" column added.
}
\description{
While a method already exists in the \code{tibble} package,
this method works differently in 2 ways:
\itemize{
\item The time variable associated with the time-series is also returned.
\item The returned \code{tibble} is always in long format, even when the time-series
is multivariate.
}
}
\examples{
library(timeplyr)
library(ggplot2)
library(dplyr)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
# Using the examples from ?ts

# Univariate
uts <- ts(cumsum(1 + round(rnorm(100), 2)),
          start = c(1954, 7), frequency = 12)
uts_tbl <- ts_as_tbl(uts)

## Multivariate
mts <- ts(matrix(rnorm(300), 100, 3), start = c(1961, 1), frequency = 12)
mts_tbl <- ts_as_tbl(mts)

uts_tbl \%>\%
  time_ggplot(time, value)

mts_tbl \%>\%
  time_ggplot(time, value, group, facet = TRUE)

# zoo example
x.Date <- as.Date("2003-02-01") + c(1, 3, 7, 9, 14) - 1
x <- zoo::zoo(rnorm(5), x.Date)
ts_as_tbl(x)
x <- zoo::zoo(matrix(1:12, 4, 3), as.Date("2003-01-01") + 0:3)
ts_as_tbl(x)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
\seealso{
\link{time_ggplot}
}
