% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/storeMetaInformation.R
\name{storeMetaInformation}
\alias{storeMetaInformation}
\title{Store Meta Information to the Database}
\usage{
storeMetaInformation(series, con, tbl = "meta_data_localized",
  lookup_env = "meta_data_localized", locale = "de", overwrite = F,
  quiet = F, schema = "timeseries")
}
\arguments{
\item{series}{a character name of an time series object}

\item{con}{a PostgreSQL connection object}

\item{tbl}{name of the meta information table, defaults to localized meta data: meta_data_localized. Alternatively choose meta_data_unlocalized if you are not translating meta information.}

\item{lookup_env}{name of the R environment in which to look for meta information objects}

\item{locale}{character locale fo the metainformation. Defaults to Germen 'de'. See also \code{\link{readMetaInformation}}.
If locale is set to NULL unlocalized meta is updated. Make sure to change tbl to 'meta_data_unlocalized'.}

\item{overwrite}{logical, defaults to FALSE.}

\item{quiet}{logical, should there be console output for every query result ? Defaults to FALSE.}

\item{schema}{SQL schema name, defaults to 'timeseries'.}
}
\description{
This function stores meta information to the database for a given time series.
Make sure that corresponding time series had been inserted to the main table before.
}

