% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readTimeseries.R
\name{readTimeSeries}
\alias{readTimeSeries}
\title{Read Time Series From PostgreSQL database}
\usage{
readTimeSeries(series, con, valid_on = NULL, tbl = "timeseries_main",
  tbl_vintages = "timeseries_vintages", schema = "timeseries", env = NULL,
  pkg_for_irreg = "xts", chunksize = 10000, respect_release_date = FALSE,
  regex = FALSE)
}
\arguments{
\item{series}{character vector of time series keys}

\item{con}{a PostgreSQL connection object}

\item{valid_on}{character date string on which the series should be valid. Defaults to NULL. Only needed when different vintages of a time series are stored.}

\item{tbl}{character string denoting the name of the relation that contains ts_key, ts_data, ts_frequency.}

\item{tbl_vintages}{character table name of the relation that holds time series vintages}

\item{schema}{character SQL schema name. Defaults to timeseries.}

\item{env}{environment, optional argument to dump time series directly into an environment. Most often used with globalenv(), which gives all time series directly back to the global env.}

\item{pkg_for_irreg}{character name of package for irregular series. xts or zoo, defaults to xts.}

\item{chunksize}{numeric value of threshold at which input vector should be processed in chunks. defaults to 70000.}

\item{respect_release_date}{logical should the relaase set in the database be respected. If TRUE, the last observation will be cut off if server time is before release date. Reasonable for relesae date.}

\item{regex}{If set to TRUE, series will be interpreted as a regular exporession, so that all time series whose keys match the pattern will be returned.}
}
\description{
This function reads a time series from a PostgreSQL relation
that uses Postgres' key value pair storage (hstore).
After reading the information from the database a standard
R time series object of class 'ts' is built and returned. Irregular time series return zoo objects.
}
\author{
Matthias Bannert, Gabriel Bucur
}
