% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asis-nodes.R
\name{protect_unescaped}
\alias{protect_unescaped}
\title{Protect unescaped square brackets from being escaped}
\usage{
protect_unescaped(body, txt, ns = md_ns())
}
\arguments{
\item{body}{an XML body}

\item{txt}{the text of a source file}

\item{ns}{an the namespace that resolves the Markdown namespace (defaults to
\code{\link[=md_ns]{md_ns()}})}
}
\description{
Commonmark allows both \verb{[unescaped]} and \verb{\[escaped\]} square brackets, but
in the XML representation, it makes no note of which square brackets were
originally escaped and thus will escape both in the output. This function
protects brackets that were unescaped in the source document from being
escaped.
}
\details{
This is an \strong{internal function} that is run by default via \code{to_xml()} and
\code{yarn$new()}. It uses the original document, parsed as text, to find and
protect unescaped square brackets from being escaped in the output.
\subsection{Example: child documents and footnotes}{

For example, let's say you have two R Markdown documents, one references the
other as a child, which has a \href{https://spec.commonmark.org/0.30/#reference-link}{reference-style link}:

index.Rmd:

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{## Title

Without protection reference style links (e.g. \[text\]\[link\]) like this
[outside link][reflink] would be accidentally escaped.
This is a footnote [^1].

[^1]: footnotes are not recognised by commonmark

```\{r, child="child.Rmd"\}
```
}\if{html}{\out{</div>}}

child.Rmd:

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{...
[reflink]: https://example.com
}\if{html}{\out{</div>}}

Without protection, the roundtripped index.Rmd document would look like this:

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{## Title

Without protection reference style links (e.g. \[text\]\[link\]) like this
\[outside link\]\[reflink\] would be accidentally escaped.
This is a footnote \[^1\]

\[^1\]: footnotes are not recognised by commonmark

```\{r, child="child.Rmd"\}
```
}\if{html}{\out{</div>}}

This function provides the protection that allows these unescaped brackets to
remain unescaped during roundtrip.
}
}
\note{
Because the This \code{body} to be an XML document with \code{sourcepos} attributes on the
nodes, which is achieved by using \code{sourcepos = TRUE} with \code{\link[=to_xml]{to_xml()}} or
\link{yarn}.
}
\examples{
f <- system.file("extdata", "link-test.md", package = "tinkr")
md <- yarn$new(f, sourcepos = TRUE, unescaped = FALSE)
md$show()
if (requireNamespace("withr")) {
lines <- readLines(f)[-length(md$yaml)]
lnks <- withr::with_namespace("tinkr", 
  protect_unescaped(body = md$body, txt = lines))
md$body <- lnks
md$show()
}
}
\keyword{internal}
