% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scripts.R
\name{prMoveScript}
\alias{prMoveScript}
\alias{prRenameScript}
\alias{prDeleteScript}
\title{Move, rename and delete scripts}
\usage{
prMoveScript(name, newDir, subdir = ".")

prRenameScript(name, newName, subdir = ".")

prDeleteScript(name, subdir = ".")
}
\arguments{
\item{name}{Name of the script on which one wants to perform an action.}

\item{newDir}{Subdirectory where to move a script.}

\item{subdir}{Subdirectory of the script on which one wants to perform an action. It can 
also be indicated directly in the \code{name} parameter.}

\item{newName}{New name of the script.}
}
\description{
These functions can be used to pragrammatically move, rename and delete 
scripts files.
}
\examples{
projectPath <- file.path(tempdir(), "test")
prInit(projectPath)

prScript("test")

prMoveScript("test", "testdir")

prRenameScript("testdir/test", "myTest")

prDeleteScript("testdir/myTest")


}
\seealso{
\code{\link{prScript}}
}
