% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_tcga_group_trans_exp.R
\name{trans_array}
\alias{trans_array}
\title{trans_array}
\usage{
trans_array(exp, ids, from = "probe_id", to = "symbol")
}
\arguments{
\item{exp}{TCGA or TCGA_Gtex expression set from gdc or xena}

\item{ids}{data.frame  with original rownames and new rownames}

\item{from}{colname for original rownames}

\item{to}{colname for new rownames}
}
\value{
a transformed expression set with new rownames
}
\description{
transform rownames for microarray expression matrix
}
\examples{
exp = matrix(1:50,nrow = 10)
rownames(exp) = paste0("g",1:10)
ids = data.frame(probe_id = paste0("g",1:10),
                symbol = paste0("G",c(1:9,9)))
trans_array(exp,ids)
}
\seealso{
\code{\link{trans_exp}}
}
\author{
Xiaojie Sun
}
