% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_multi_deg_all.R
\name{plot_deg}
\alias{plot_deg}
\title{plot_deg}
\usage{
plot_deg(
  exp,
  group_list,
  deg,
  symmetry = TRUE,
  my_genes = NULL,
  show_rownames = FALSE,
  cluster_cols = TRUE,
  color_volcano = c("#2874C5", "grey", "#f87669"),
  pvalue_cutoff = 0.05,
  logFC_cutoff = 1,
  adjust = FALSE,
  annotation_legend = FALSE,
  lab = NA,
  species = "human"
)
}
\arguments{
\item{exp}{A numeric matrix}

\item{group_list}{A factor with duplicated character or factor}

\item{deg}{result of multi_deg or get_deg function}

\item{symmetry}{a logical value ,would you like to get your plot symmetrical}

\item{my_genes}{genes for pheatmap}

\item{show_rownames}{boolean specifying if column names are be shown.}

\item{cluster_cols}{boolean values determining if columns should be clustered or \code{hclust} object.}

\item{color_volcano}{color for volcano}

\item{pvalue_cutoff}{Cutoff value of pvalue,0.05 by default.}

\item{logFC_cutoff}{Cutoff value of logFC,1 by default.}

\item{adjust}{a logical value, would you like to use adjusted pvalue to draw this plot,FAlSE by default.}

\item{annotation_legend}{boolean value showing if the legend for annotation 
tracks should be drawn.}

\item{lab}{label for  x axis in volcano plot, if NA , x axis names by package}

\item{species}{choose human or mouse, or rat, default: human}
}
\value{
plots
}
\description{
plot pca plot,volcano plot,heatmap,and venn plot for  Differential analysis result
}
\examples{
\dontrun{
gse = "GSE474"
geo = geo_download(gse,destdir=tempdir())
geo$exp[1:4,1:4]
geo$exp=log2(geo$exp+1)
group_list=ifelse(stringr::str_detect(geo$pd$title,"MObese"),"MObese",
ifelse(stringr::str_detect(geo$pd$title,"NonObese"),"NonObese","Obese"))
group_list=factor(group_list,levels = c("NonObese","Obese","MObese"))
find_anno(geo$gpl)
ids = AnnoProbe::idmap(geo$gpl,destdir = tempdir())
deg = get_deg(geo$exp,group_list,ids,adjust = FALSE)
plot_deg(geo$exp,group_list,deg)
}
}
\author{
Xiaojie Sun
}
