% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_plots.R
\name{draw_venn}
\alias{draw_venn}
\title{draw a venn plot}
\usage{
draw_venn(
  x,
  main,
  color = c("#2874C5", "#f87669", "#e6b707", "#868686", "#66C2A5", "#FC8D62", "#8DA0CB",
    "#E78AC3", "#A6D854", "#FFD92F", "#E5C494", "#B3B3B3"),
  imagetype = "png",
  filename = NULL,
  lwd = 1,
  lty = 1,
  col = color[1:length(x)],
  fill = color[1:length(x)],
  cat.col = color[1:length(x)],
  cat.cex = 1,
  cat.dist = -0.15,
  rotation.degree = 0,
  main.cex = 1,
  cex = 1,
  alpha = 0.1,
  reverse = TRUE,
  ...
)
}
\arguments{
\item{x}{a list for plot}

\item{main}{Character giving the main title of the diagram}

\item{color}{color vector}

\item{imagetype}{Specification of the image format (e.g. tiff, png or svg)}

\item{filename}{Filename for image output, or if NULL returns the grid object itself}

\item{lwd}{width of the circle's circumference}

\item{lty}{dash pattern of the circle's circumference}

\item{col}{Colour of the circle's circumference}

\item{fill}{Colour of the circle's area}

\item{cat.col}{Colour of the category name}

\item{cat.cex}{size of the category name}

\item{cat.dist}{The distance (in npc units) of the category name from the edge of the circle (can be negative)}

\item{rotation.degree}{Number of degrees to rotate the entire diagram}

\item{main.cex}{Number giving the cex (font size) of the main title}

\item{cex}{size of the area label}

\item{alpha}{Alpha transparency of the circle's area}

\item{reverse}{logical,reflect the three-set Venn diagram along its central
vertical axis of symmetry. Use in combination with rotation
to generate all possible set orders}

\item{...}{other parameters from venn.diagram}
}
\value{
a venn plot according to \code{x}, \code{y} and.\code{z} named "name" paramter
}
\description{
print a venn plot for deg result created by three packages
}
\examples{
x = list(Deseq2=sample(1:100,30),edgeR = sample(1:100,30),limma = sample(1:100,30))
draw_venn(x,"test")
draw_venn(x,"test",color = c("darkgreen", "darkblue", "#B2182B"))
}
\seealso{
\code{\link{draw_pca}};\code{\link{draw_volcano}};\code{\link{draw_heatmap}}
}
\author{
Xiaojie Sun
}
