% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_rug.R
\name{type_rug}
\alias{type_rug}
\title{Add a rug to a plot}
\usage{
type_rug(
  ticksize = 0.03,
  side = 1,
  quiet = getOption("warn") < 0,
  jitter = FALSE,
  amount = NULL
)
}
\arguments{
\item{ticksize}{The length of the ticks making up the \sQuote{rug}.
   Positive lengths give inwards ticks.}

\item{side}{On which side of the plot box the rug will be
   plotted. Normally 1 (bottom) or 3 (top).}

\item{quiet}{logical indicating if there should be a warning about
   clipped values.}

\item{jitter}{Logical. Add jittering to separate ties? Default is \code{FALSE}.}

\item{amount}{Numeric. Amount of jittering (see \code{\link[base]{jitter}}).
Only used if \code{jitter} is \code{TRUE}.}
}
\description{
Adds a rug representation (1-d plot) of the data to the plot.
}
\details{
This function should only be used as part of \code{\link[=tinyplot_add]{tinyplot_add()}}, i.e. adding
to an existing plot.

In most cases, determining which variable receives the rug representation
will be based on the \code{side} argument (i.e., x-variable if side is 1 or 3, and
y-variable if side is 2 or 4). An exception is if the preceding plot type was
either \code{"density"} or \code{"histogram"}; for these latter cases, the x-variable
will always be used. See Examples.
}
\examples{
tinyplot(~wt | am, data = mtcars, type = "density", facet = "by", fill = "by")
tinyplot_add(type = "rug")
# use type_rug() to pass extra options
tinyplot_add(type = type_rug(side = 3, ticksize = 0.05))

# For ties, use jittering
tinyplot(eruptions ~ waiting, data = faithful, type = "lm")
tinyplot_add(type = type_rug(jitter = TRUE, amount = 0.3))
tinyplot_add(type = type_rug(jitter = TRUE, amount = 0.1, side = 2))
# Add original points just for reference
tinyplot_add(type = "p")

}
