% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tt.R
\name{plot_tt}
\alias{plot_tt}
\title{Insert images and inline plots into tinytable objects}
\usage{
plot_tt(
  x,
  i = NULL,
  j = NULL,
  fun = NULL,
  data = NULL,
  color = "black",
  xlim = NULL,
  height = 1,
  asp = 1/3,
  images = NULL,
  assets = "tinytable_assets",
  ...
)
}
\arguments{
\item{x}{A tinytable object.}

\item{i}{Integer vector, the row indices where images are to be inserted. If \code{NULL},
images will be inserted in all rows.}

\item{j}{Integer vector, the column indices where images are to be inserted. If \code{NULL},
images will be inserted in all columns.}

\item{fun}{A function to generate plots from the data in \code{data}. Valid functions include:
\itemize{
\item Functions that return \code{ggplot2} objects.
\item Functions that return another function which generates a base \code{R} plot, ex: \code{function(x) {function() hist(x)}}
\item See the tutorial on the \code{tinytable} website for more information.
}}

\item{data}{Optional, a list of data frames to be used with a custom plotting function.}

\item{color}{string Name of color to use for inline plots (passed to the \code{col} argument base \code{graphics} plots in \code{R}).}

\item{xlim}{Numeric vector of length 2.}

\item{height}{Numeric, the height of the images in the table in em units.}

\item{asp}{Numeric, aspect ratio of the plots (height / width).}

\item{images}{Character vector, the paths to the images to be inserted. Paths are relative to the main table file or Quarto (Rmarkdown) document.}

\item{assets}{Character, the directory to store generated assets.}

\item{...}{Extra arguments are passed to the function in \code{fun}. Important: Custom plotting functions must always have \code{...} as an argument.}
}
\value{
A modified tinytable object with images or plots inserted.
}
\description{
The \code{plot_tt()} function allows for the insertion of images and inline plots into
tinytable objects. This function can handle both local and web-based images. #'
}
\details{
The \code{plot_tt()} can insert images and inline plots into tables.
}
