% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinytest.R
\name{test_package}
\alias{test_package}
\title{Test a package during R CMD check}
\usage{
test_package(pkgname, testdir = "utst")
}
\arguments{
\item{pkgname}{\code{[character]} scalar. Name of the package}

\item{testdir}{\code{[character]} scalar. Path to installed directory, relative
to the working directory of \code{R CMD check}.}
}
\description{
Run all tests in a package. Throw an error and print all failed test
results when one or more tests fail. This function is intended to be
used with \code{R CMD check} and not for interactive use (use \code{\link{test_all}}
for that.)
}
\examples{
\dontrun{
# Create a file with the following content, to use
# tinytest as your unit testing framework:
  if (require(tinytest)) test_package("your package name")
}
}
\seealso{
Other test-files: \code{\link{[.tinytests}},
  \code{\link{build_install_test}},
  \code{\link{run_test_dir}}, \code{\link{run_test_file}}
}
\concept{test-files}
